/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.api.impl;

import com.sun.xml.internal.bind.api.impl.NameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public interface NameConverter {
    public static final NameConverter standard = new Standard();
    public static final NameConverter jaxrpcCompatible = new Standard(){

        @Override
        protected boolean isPunct(char c) {
            return c == '.' || c == '-' || c == ';' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
        }

        @Override
        protected boolean isLetter(char c) {
            return super.isLetter(c) || c == '_';
        }

        @Override
        protected int classify(char c) {
            if (c == '_') {
                return 2;
            }
            return super.classify(c);
        }
    };
    public static final NameConverter smart = new Standard(){

        @Override
        public String toConstantName(String string) {
            String string2 = super.toConstantName(string);
            if (NameUtil.isJavaIdentifier(string2)) {
                return string2;
            }
            return '_' + string2;
        }
    };

    public String toClassName(String var1);

    public String toInterfaceName(String var1);

    public String toPropertyName(String var1);

    public String toConstantName(String var1);

    public String toVariableName(String var1);

    public String toPackageName(String var1);

    public static class Standard
    extends NameUtil
    implements NameConverter {
        @Override
        public String toClassName(String string) {
            return this.toMixedCaseName(this.toWordList(string), true);
        }

        @Override
        public String toVariableName(String string) {
            return this.toMixedCaseName(this.toWordList(string), false);
        }

        @Override
        public String toInterfaceName(String string) {
            return this.toClassName(string);
        }

        @Override
        public String toPropertyName(String string) {
            String string2 = this.toClassName(string);
            if (string2.equals("Class")) {
                string2 = "Clazz";
            }
            return string2;
        }

        @Override
        public String toConstantName(String string) {
            return super.toConstantName(string);
        }

        @Override
        public String toPackageName(String string) {
            ArrayList<String> arrayList;
            String string2;
            ArrayList<String> arrayList2;
            int n = string.indexOf(58);
            String string3 = "";
            if (n >= 0 && ((string3 = string.substring(0, n)).equalsIgnoreCase("http") || string3.equalsIgnoreCase("urn"))) {
                string = string.substring(n + 1);
            }
            if ((n = string.indexOf("#")) >= 0) {
                string = string.substring(0, n);
            }
            if ((arrayList2 = Standard.tokenize(string, "/: ")).size() == 0) {
                return null;
            }
            if (arrayList2.size() > 1 && (n = (string2 = arrayList2.get(arrayList2.size() - 1)).lastIndexOf(46)) > 0) {
                string2 = string2.substring(0, n);
                arrayList2.set(arrayList2.size() - 1, string2);
            }
            if ((n = (string2 = arrayList2.get(0)).indexOf(58)) >= 0) {
                string2 = string2.substring(0, n);
            }
            if ((arrayList = Standard.reverse(Standard.tokenize(string2, string3.equals("urn") ? ".-" : "."))).get(arrayList.size() - 1).equalsIgnoreCase("www")) {
                arrayList.remove(arrayList.size() - 1);
            }
            arrayList2.addAll(1, arrayList);
            arrayList2.remove(0);
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string4 = arrayList2.get(i);
                if (!NameUtil.isJavaIdentifier((string4 = Standard.removeIllegalIdentifierChars(string4)).toLowerCase())) {
                    string4 = '_' + string4;
                }
                arrayList2.set(i, string4.toLowerCase());
            }
            return Standard.combine(arrayList2, '.');
        }

        private static String removeIllegalIdentifierChars(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                    stringBuffer.append('_').append(c);
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) {
                    stringBuffer.append('_');
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        private static ArrayList<String> tokenize(String string, String string2) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return arrayList;
        }

        private static <T> ArrayList<T> reverse(List<T> list) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (int i = list.size() - 1; i >= 0; --i) {
                arrayList.add(list.get(i));
            }
            return arrayList;
        }

        private static String combine(List list, char c) {
            StringBuilder stringBuilder = new StringBuilder(list.get(0).toString());
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append(c);
                stringBuilder.append(list.get(i));
            }
            return stringBuilder.toString();
        }
    }
}

