/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSPropertyTextHandler
implements ICSSPropertyTextHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if ("color".equals(property)) {
            this.applyCSSPropertyColor(element, value, pseudo, engine);
        }
        if ("text-transform".equals(property)) {
            this.applyCSSPropertyTextTransform(element, value, pseudo, engine);
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        if ("color".equals(property)) {
            return this.retrieveCSSPropertyColor(element, pseudo, engine);
        }
        if ("text-transform".equals(property)) {
            return this.retrieveCSSPropertyTextTransform(element, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        throw new UnsupportedPropertyException("color");
    }

    public void applyCSSPropertyTextTransform(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        throw new UnsupportedPropertyException("text-transform");
    }

    public String retrieveCSSPropertyColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyTextTransform(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    protected String getTextTransform(String text, CSSValue value, String defaultText) {
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
            String textTransform = primitiveValue.getStringValue();
            if ("capitalize".equals(textTransform)) {
                return StringUtils.capitalize(text);
            }
            if ("uppercase".equals(textTransform) && text != null) {
                return text.toUpperCase();
            }
            if ("lowercase".equals(textTransform) && text != null) {
                return text.toLowerCase();
            }
            if ("inherit".equals(textTransform)) {
                return text;
            }
        }
        if (defaultText != null) {
            return defaultText;
        }
        return text;
    }

    protected String getTextTransform(String textToInsert, String oldText, CSSValue value) {
        if (value.getCssValueType() == 1) {
            String newText;
            CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
            String textTransform = primitiveValue.getStringValue();
            if ("capitalize".equals(textTransform) && (newText = StringUtils.capitalize(String.valueOf(oldText) + textToInsert)).length() > 0) {
                return newText.substring(newText.length() - 1);
            }
            if ("uppercase".equals(textTransform) && textToInsert != null) {
                return textToInsert.toUpperCase();
            }
            if ("lowercase".equals(textTransform) && textToInsert != null) {
                return textToInsert.toLowerCase();
            }
            if ("inherit".equals(textTransform)) {
                return textToInsert;
            }
        }
        return textToInsert;
    }

    protected boolean hasTextTransform(CSSValue value) {
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
            String textTransform = primitiveValue.getStringValue();
            if ("capitalize".equals(textTransform)) {
                return true;
            }
            if ("uppercase".equals(textTransform)) {
                return true;
            }
            if ("lowercase".equals(textTransform)) {
                return true;
            }
        }
        return false;
    }
}

