/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.navigator.projects;

import it.sogei.rcp.core.util.RCPHandlerUtil;
import it.sogei.rcp.navigator.Activator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class ProjectContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private static final Object[] NO_CHILDREN = new Object[0];
    private Map<String, Object> wrapperCache = new HashMap<String, Object>();
    private Viewer viewer;

    public ProjectContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.refreshAll();
    }

    protected void refreshAll() {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            ProjectContentProvider.refreshTreeViewer((TreeViewer)this.viewer);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectContentProvider.refreshTreeViewer((TreeViewer)ProjectContentProvider.this.viewer);
                }
            });
        }
    }

    private static void refreshTreeViewer(TreeViewer viewer) {
        TreePath[] treePaths = viewer.getExpandedTreePaths();
        viewer.refresh();
        viewer.setExpandedTreePaths(treePaths);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        IProject[] projects = null;
        if (IWorkspaceRoot.class.isInstance(inputElement)) {
            projects = ((IWorkspaceRoot)inputElement).getProjects();
        }
        String perspectiveId = RCPHandlerUtil.getActivePerspectiveId();
        String natureId = Activator.naturesMap.get(perspectiveId);
        IProject project = null;
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].hasNature(natureId)) {
                    project = projects[i];
                    break;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (project != null) {
            return this.getChildren(project);
        }
        return this.getChildren(projects);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (IWorkspaceRoot.class.isInstance(parentElement)) {
            Object[] projects;
            children = projects = ((IWorkspaceRoot)parentElement).getProjects();
        } else if (IProject.class.isInstance(parentElement)) {
            try {
                children = ((IProject)parentElement).members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (IFolder.class.isInstance(parentElement)) {
            try {
                children = ((IFolder)parentElement).members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            children = NO_CHILDREN;
        }
        return children;
    }

    public Object getParent(Object element) {
        IWorkspaceRoot parent = null;
        if (IProject.class.isInstance(element)) {
            parent = ((IProject)element).getWorkspace().getRoot();
        } else if (IFolder.class.isInstance(element)) {
            parent = ((IFolder)element).getParent();
        } else if (IFile.class.isInstance(element)) {
            parent = ((IFile)element).getParent();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (IWorkspaceRoot.class.isInstance(element)) {
            boolean bl = hasChildren = ((IWorkspaceRoot)element).getProjects().length > 0;
        }
        if (IProject.class.isInstance(element)) {
            try {
                hasChildren = ((IProject)element).members().length > 0;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (IFolder.class.isInstance(element)) {
            hasChildren = true;
        }
        return hasChildren;
    }
}

