/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;

public final class PojoObservables {
    public static IObservableValue observeValue(Object pojo, String propertyName) {
        return PojoObservables.observeValue(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableValue observeValue(Realm realm, Object pojo, String propertyName) {
        return PojoProperties.value(pojo.getClass(), propertyName).observe(realm, pojo);
    }

    public static IObservableMap observeMap(IObservableSet domain, String propertyName) {
        return PojoProperties.value(propertyName).observeDetail(domain);
    }

    public static IObservableMap observeMap(IObservableSet domain, Class pojoClass, String propertyName) {
        return PojoProperties.value(pojoClass, propertyName).observeDetail(domain);
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoObservables.observeMap(domain, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, Class pojoClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoObservables.observeMap(domain, pojoClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static IObservableMap observeMap(Realm realm, Object pojo, String propertyName) {
        return PojoObservables.observeMap(realm, pojo, propertyName, null, null);
    }

    public static IObservableMap observeMap(Realm realm, Object pojo, String propertyName, Class keyType, Class valueType) {
        return PojoProperties.map(pojo.getClass(), propertyName, keyType, valueType).observe(realm, pojo);
    }

    public static IObservableMap observeMap(Object pojo, String propertyName) {
        return PojoObservables.observeMap(Realm.getDefault(), pojo, propertyName, null, null);
    }

    public static IObservableMap observeMap(Object pojo, String propertyName, Class keyType, Class valueType) {
        return PojoObservables.observeMap(Realm.getDefault(), pojo, propertyName, keyType, valueType);
    }

    public static IObservableList observeList(Realm realm, Object pojo, String propertyName) {
        return PojoObservables.observeList(realm, pojo, propertyName, null);
    }

    public static IObservableList observeList(Object pojo, String propertyName) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableList observeList(Realm realm, Object pojo, String propertyName, Class elementType) {
        return PojoProperties.list(pojo.getClass(), propertyName, elementType).observe(realm, pojo);
    }

    public static IObservableList observeList(Object pojo, String propertyName, Class elementType) {
        return PojoObservables.observeList(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static IObservableSet observeSet(Realm realm, Object pojo, String propertyName) {
        return PojoObservables.observeSet(realm, pojo, propertyName, null);
    }

    public static IObservableSet observeSet(Object pojo, String propertyName) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName);
    }

    public static IObservableSet observeSet(Realm realm, Object pojo, String propertyName, Class elementType) {
        return PojoProperties.set(pojo.getClass(), propertyName, elementType).observe(realm, pojo);
    }

    public static IObservableSet observeSet(Object pojo, String propertyName, Class elementType) {
        return PojoObservables.observeSet(Realm.getDefault(), pojo, propertyName, elementType);
    }

    public static IObservableFactory valueFactory(Realm realm, String propertyName) {
        return PojoProperties.value(propertyName).valueFactory(realm);
    }

    public static IObservableFactory valueFactory(String propertyName) {
        return PojoObservables.valueFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableFactory listFactory(Realm realm, String propertyName, Class elementType) {
        return PojoProperties.list(propertyName, elementType).listFactory(realm);
    }

    public static IObservableFactory listFactory(String propertyName, Class elementType) {
        return PojoObservables.listFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory setFactory(Realm realm, String propertyName) {
        return PojoProperties.set(propertyName).setFactory(realm);
    }

    public static IObservableFactory setFactory(String propertyName) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableFactory setFactory(Realm realm, String propertyName, Class elementType) {
        return PojoProperties.set(propertyName, elementType).setFactory(realm);
    }

    public static IObservableFactory setFactory(String propertyName, Class elementType) {
        return PojoObservables.setFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static IObservableFactory mapPropertyFactory(Realm realm, String propertyName) {
        return PojoProperties.map(propertyName).mapFactory(realm);
    }

    public static IObservableFactory mapPropertyFactory(String propertyName) {
        return PojoObservables.mapPropertyFactory(Realm.getDefault(), propertyName);
    }

    public static IObservableValue observeDetailValue(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableValue value = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)PojoProperties.value(propertyName, propertyType).valueFactory(realm), (Object)propertyType);
        return new BeanObservableValueDecorator(value, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static IObservableValue observeDetailValue(IObservableValue master, String propertyName, Class propertyType) {
        Class pojoClass = null;
        if (master.getValueType() instanceof Class) {
            pojoClass = (Class)master.getValueType();
        }
        return PojoProperties.value(pojoClass, propertyName, propertyType).observeDetail(master);
    }

    public static IObservableList observeDetailList(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableList observableList = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)PojoProperties.list(propertyName, propertyType).listFactory(realm), (Object)propertyType);
        return new BeanObservableListDecorator(observableList, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static IObservableList observeDetailList(IObservableValue master, String propertyName, Class propertyType) {
        Class pojoClass = null;
        if (master.getValueType() instanceof Class) {
            pojoClass = (Class)master.getValueType();
        }
        return PojoProperties.list(pojoClass, propertyName).observeDetail(master);
    }

    public static IObservableSet observeDetailSet(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableSet observableSet = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)PojoProperties.set(propertyName, propertyType).setFactory(realm), (Object)propertyType);
        return new BeanObservableSetDecorator(observableSet, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static IObservableSet observeDetailSet(IObservableValue master, String propertyName, Class propertyType) {
        Class pojoClass = null;
        if (master.getValueType() instanceof Class) {
            pojoClass = (Class)master.getValueType();
        }
        return PojoProperties.set(pojoClass, propertyName, propertyType).observeDetail(master);
    }

    public static IObservableMap observeDetailMap(Realm realm, IObservableValue master, String propertyName) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableMap observableMap = MasterDetailObservables.detailMap((IObservableValue)master, (IObservableFactory)PojoProperties.map(propertyName).mapFactory(realm));
        return new BeanObservableMapDecorator(observableMap, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static IObservableMap observeDetailMap(IObservableValue master, String propertyName) {
        Class pojoClass = null;
        if (master.getValueType() instanceof Class) {
            pojoClass = (Class)master.getValueType();
        }
        return PojoProperties.map(pojoClass, propertyName).observeDetail(master);
    }
}

