/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.AbstractPipeline;
import java.util.stream.DoublePipeline;
import java.util.stream.DoubleStream;
import java.util.stream.FindOps;
import java.util.stream.ForEachOps;
import java.util.stream.IntPipeline;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.MatchOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.SliceOps;
import java.util.stream.SortedOps;
import java.util.stream.Stream;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.Tripwire;

abstract class LongPipeline<E_IN>
extends AbstractPipeline<E_IN, Long, LongStream>
implements LongStream {
    LongPipeline(Supplier<? extends Spliterator<Long>> supplier, int n, boolean bl) {
        super(supplier, n, bl);
    }

    LongPipeline(Spliterator<Long> spliterator, int n, boolean bl) {
        super(spliterator, n, bl);
    }

    LongPipeline(AbstractPipeline<?, E_IN, ?> abstractPipeline, int n) {
        super(abstractPipeline, n);
    }

    private static LongConsumer adapt(Sink<Long> sink) {
        if (sink instanceof LongConsumer) {
            return (LongConsumer)((Object)sink);
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using LongStream.adapt(Sink<Long> s)");
        }
        return sink::accept;
    }

    private static Spliterator.OfLong adapt(Spliterator<Long> spliterator) {
        if (spliterator instanceof Spliterator.OfLong) {
            return (Spliterator.OfLong)spliterator;
        }
        if (Tripwire.ENABLED) {
            Tripwire.trip(AbstractPipeline.class, "using LongStream.adapt(Spliterator<Long> s)");
        }
        throw new UnsupportedOperationException("LongStream.adapt(Spliterator<Long> s)");
    }

    @Override
    final StreamShape getOutputShape() {
        return StreamShape.LONG_VALUE;
    }

    @Override
    final <P_IN> Node<Long> evaluateToNode(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, boolean bl, IntFunction<Long[]> intFunction) {
        return Nodes.collectLong(pipelineHelper, spliterator, bl);
    }

    @Override
    final <P_IN> Spliterator<Long> wrap(PipelineHelper<Long> pipelineHelper, Supplier<Spliterator<P_IN>> supplier, boolean bl) {
        return new StreamSpliterators.LongWrappingSpliterator<P_IN>(pipelineHelper, supplier, bl);
    }

    final Spliterator.OfLong lazySpliterator(Supplier<? extends Spliterator<Long>> supplier) {
        return new StreamSpliterators.DelegatingSpliterator.OfLong((Supplier<Spliterator.OfLong>)supplier);
    }

    @Override
    final void forEachWithCancel(Spliterator<Long> spliterator, Sink<Long> sink) {
        Spliterator.OfLong ofLong = LongPipeline.adapt(spliterator);
        LongConsumer longConsumer = LongPipeline.adapt(sink);
        while (!sink.cancellationRequested() && ofLong.tryAdvance(longConsumer)) {
        }
    }

    @Override
    final Node.Builder<Long> makeNodeBuilder(long l, IntFunction<Long[]> intFunction) {
        return Nodes.longBuilder(l);
    }

    @Override
    public final PrimitiveIterator.OfLong iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public final Spliterator.OfLong spliterator() {
        return LongPipeline.adapt(super.spliterator());
    }

    @Override
    public final DoubleStream asDoubleStream() {
        return new DoublePipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedLong<Double>(sink){

                    @Override
                    public void accept(long l) {
                        this.downstream.accept((double)l);
                    }
                };
            }
        };
    }

    @Override
    public final Stream<Long> boxed() {
        return this.mapToObj(Long::valueOf);
    }

    @Override
    public final LongStream map(final LongUnaryOperator longUnaryOperator) {
        Objects.requireNonNull(longUnaryOperator);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void accept(long l) {
                        this.downstream.accept(longUnaryOperator.applyAsLong(l));
                    }
                };
            }
        };
    }

    @Override
    public final <U> Stream<U> mapToObj(final LongFunction<? extends U> longFunction) {
        Objects.requireNonNull(longFunction);
        return new ReferencePipeline.StatelessOp<Long, U>(this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int n, Sink<U> sink) {
                return new Sink.ChainedLong<U>(sink){

                    @Override
                    public void accept(long l) {
                        this.downstream.accept(longFunction.apply(l));
                    }
                };
            }
        };
    }

    @Override
    public final IntStream mapToInt(final LongToIntFunction longToIntFunction) {
        Objects.requireNonNull(longToIntFunction);
        return new IntPipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Integer> sink) {
                return new Sink.ChainedLong<Integer>(sink){

                    @Override
                    public void accept(long l) {
                        this.downstream.accept(longToIntFunction.applyAsInt(l));
                    }
                };
            }
        };
    }

    @Override
    public final DoubleStream mapToDouble(final LongToDoubleFunction longToDoubleFunction) {
        Objects.requireNonNull(longToDoubleFunction);
        return new DoublePipeline.StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Double> sink) {
                return new Sink.ChainedLong<Double>(sink){

                    @Override
                    public void accept(long l) {
                        this.downstream.accept(longToDoubleFunction.applyAsDouble(l));
                    }
                };
            }
        };
    }

    @Override
    public final LongStream flatMap(final LongFunction<? extends LongStream> longFunction) {
        Objects.requireNonNull(longFunction);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SORTED | StreamOpFlag.NOT_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(long l2) {
                        try (LongStream longStream = (LongStream)longFunction.apply(l2);){
                            if (longStream != null) {
                                longStream.sequential().forEach(l -> this.downstream.accept(l));
                            }
                        }
                    }
                };
            }
        };
    }

    @Override
    public LongStream unordered() {
        if (!this.isOrdered()) {
            return this;
        }
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_ORDERED){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return sink;
            }
        };
    }

    @Override
    public final LongStream filter(final LongPredicate longPredicate) {
        Objects.requireNonNull(longPredicate);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, StreamOpFlag.NOT_SIZED){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void begin(long l) {
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void accept(long l) {
                        if (longPredicate.test(l)) {
                            this.downstream.accept(l);
                        }
                    }
                };
            }
        };
    }

    @Override
    public final LongStream peek(final LongConsumer longConsumer) {
        Objects.requireNonNull(longConsumer);
        return new StatelessOp<Long>((AbstractPipeline)this, StreamShape.LONG_VALUE, 0){

            @Override
            Sink<Long> opWrapSink(int n, Sink<Long> sink) {
                return new Sink.ChainedLong<Long>(sink){

                    @Override
                    public void accept(long l) {
                        longConsumer.accept(l);
                        this.downstream.accept(l);
                    }
                };
            }
        };
    }

    @Override
    public final LongStream limit(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        return SliceOps.makeLong(this, 0L, l);
    }

    @Override
    public final LongStream skip(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Long.toString(l));
        }
        if (l == 0L) {
            return this;
        }
        return SliceOps.makeLong(this, l, -1L);
    }

    @Override
    public final LongStream sorted() {
        return SortedOps.makeLong(this);
    }

    @Override
    public final LongStream distinct() {
        return this.boxed().distinct().mapToLong(l -> l);
    }

    @Override
    public void forEach(LongConsumer longConsumer) {
        this.evaluate(ForEachOps.makeLong(longConsumer, false));
    }

    @Override
    public void forEachOrdered(LongConsumer longConsumer) {
        this.evaluate(ForEachOps.makeLong(longConsumer, true));
    }

    @Override
    public final long sum() {
        return this.reduce(0L, Long::sum);
    }

    @Override
    public final OptionalLong min() {
        return this.reduce(Math::min);
    }

    @Override
    public final OptionalLong max() {
        return this.reduce(Math::max);
    }

    @Override
    public final OptionalDouble average() {
        long[] lArray3 = this.collect(() -> new long[2], (lArray, l) -> {
            lArray[0] = lArray[0] + 1L;
            lArray[1] = lArray[1] + l;
        }, (lArray, lArray2) -> {
            lArray[0] = lArray[0] + lArray2[0];
            lArray[1] = lArray[1] + lArray2[1];
        });
        return lArray3[0] > 0L ? OptionalDouble.of((double)lArray3[1] / (double)lArray3[0]) : OptionalDouble.empty();
    }

    @Override
    public final long count() {
        return this.map(l -> 1L).sum();
    }

    @Override
    public final LongSummaryStatistics summaryStatistics() {
        return this.collect(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    @Override
    public final long reduce(long l, LongBinaryOperator longBinaryOperator) {
        return this.evaluate(ReduceOps.makeLong(l, longBinaryOperator));
    }

    @Override
    public final OptionalLong reduce(LongBinaryOperator longBinaryOperator) {
        return this.evaluate(ReduceOps.makeLong(longBinaryOperator));
    }

    @Override
    public final <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> objLongConsumer, BiConsumer<R, R> biConsumer) {
        Objects.requireNonNull(biConsumer);
        BinaryOperator binaryOperator = (object, object2) -> {
            biConsumer.accept(object, object2);
            return object;
        };
        return this.evaluate(ReduceOps.makeLong(supplier, objLongConsumer, binaryOperator));
    }

    @Override
    public final boolean anyMatch(LongPredicate longPredicate) {
        return this.evaluate(MatchOps.makeLong(longPredicate, MatchOps.MatchKind.ANY));
    }

    @Override
    public final boolean allMatch(LongPredicate longPredicate) {
        return this.evaluate(MatchOps.makeLong(longPredicate, MatchOps.MatchKind.ALL));
    }

    @Override
    public final boolean noneMatch(LongPredicate longPredicate) {
        return this.evaluate(MatchOps.makeLong(longPredicate, MatchOps.MatchKind.NONE));
    }

    @Override
    public final OptionalLong findFirst() {
        return this.evaluate(FindOps.makeLong(true));
    }

    @Override
    public final OptionalLong findAny() {
        return this.evaluate(FindOps.makeLong(false));
    }

    @Override
    public final long[] toArray() {
        return (long[])Nodes.flattenLong((Node.OfLong)this.evaluateToArrayNode(Long[]::new)).asPrimitiveArray();
    }

    static abstract class StatefulOp<E_IN>
    extends LongPipeline<E_IN> {
        StatefulOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return true;
        }

        @Override
        abstract <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> var1, Spliterator<P_IN> var2, IntFunction<Long[]> var3);
    }

    static abstract class StatelessOp<E_IN>
    extends LongPipeline<E_IN> {
        StatelessOp(AbstractPipeline<?, E_IN, ?> abstractPipeline, StreamShape streamShape, int n) {
            super(abstractPipeline, n);
            assert (abstractPipeline.getOutputShape() == streamShape);
        }

        @Override
        final boolean opIsStateful() {
            return false;
        }
    }

    static class Head<E_IN>
    extends LongPipeline<E_IN> {
        Head(Supplier<? extends Spliterator<Long>> supplier, int n, boolean bl) {
            super(supplier, n, bl);
        }

        Head(Spliterator<Long> spliterator, int n, boolean bl) {
            super(spliterator, n, bl);
        }

        @Override
        final boolean opIsStateful() {
            throw new UnsupportedOperationException();
        }

        @Override
        final Sink<E_IN> opWrapSink(int n, Sink<Long> sink) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(LongConsumer longConsumer) {
            if (!this.isParallel()) {
                LongPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(longConsumer);
            } else {
                super.forEach(longConsumer);
            }
        }

        @Override
        public void forEachOrdered(LongConsumer longConsumer) {
            if (!this.isParallel()) {
                LongPipeline.adapt(this.sourceStageSpliterator()).forEachRemaining(longConsumer);
            } else {
                super.forEachOrdered(longConsumer);
            }
        }
    }
}

