/*
   itoa.S

   Copyright (C) 2000 Michael Rickmann <mrickma@gwdg.de>

   Permission to use, copy, modify, and distribute this software and
   its documentation for any purpose and without fee is hereby granted,
   without any conditions or restrictions.  This software is provided
   "as is" without express or implied warranty.

	#include <stdlib.h>
	char *itoa(int value, char *string, int radix);
  ----------------------------------------------------------------------
*/

#include "macros.inc"
#include "ctoasm.inc"

	.global _U(itoa)
	.func _U(itoa)

/* arguments */
#define r_val_hi r25
#define r_val_lo r24
#define r_str_hi r23
#define r_str_lo r22
#define r_radix  r20

/* local variables */
#define r_minus r19
#define r_count r18

_U(itoa):
	mov	r30, r_str_lo	; *string
	mov	r31, r_str_hi
	clr	r_count		; count, clear for later
	clr	r_minus		; minus flag

	cpi	r_radix, 2	; no radix < 2
	brlt	terminate
	cpi	r_radix, 10	; decimal number ?
	brne	divide_loop
	tst	r_val_hi	; sign of value ?
	brge	divide_loop
	com	r_val_hi	; make positive
	neg	r_val_lo
	sbci	r_val_hi,0xff
	ldi	r_minus, '-'	; store sign
divide_loop:
	mov	r22, r_radix	; radix
	clr	r23		;  dividend in r25:r24,   divisor in r23:r22
	XCALL	_U(__udivmodhi4) ; quotient in r23:r22, remainder in r25:r24
				;  clobbered: r0, r21, r26, r27
				;  call-used but preserved: r18, r19, r20, r30, r31
	subi	r24, 0xd0	; + '0'
	cpi	r24, 0x3a	; > '9' ?
	brlt	L_10
	subi	r24, 0xd9	; + 'a' - 10 - '0'
L_10:
	push	r24		; save char on stack
	inc	r_count		; increment char count
	mov	r_val_lo,r22	; quotient -> dividend
	mov	r_val_hi,r23
	sbiw	r_val_lo,0	; value == 0 ?
	brne	divide_loop

	mov	r24, r30	; return start of *string
	mov	r25, r31
	tst	r_minus		; minus sign ?
	brne	store_char
	rjmp	test_count
character_loop:
	pop	r_minus		; restore character
	dec	r_count		; decrement count
store_char:
	st	Z+, r_minus	; store character
test_count:
	tst	r_count		; count == 0 ?
	brne	character_loop
terminate:
	st	Z, r_count	; terminator
	ret

	.endfunc

