/* vim: set sw=4 ts=4 si : */
/*************************************************************************
Title:    linuxfocus autonomous robot, testprgram for motor
Authors:   guido socher <guido[at]linuxfocus.org>, 
           katja socher <katja[at]linuxfocus.org>
Copyright: GPL
**************************************************************************/
#include <io.h>
#include <progmem.h>
#include <stdlib.h>

/* defines if a pin is input or output,ddr= data direction register */
#define MOTORDDR DDRB  
/* the port controls the values (0 or 5V) of the output pins*/
#define MOTORPORT PORTB

#define MOTOR1PLUS PB2
#define MOTOR1MINUS PB3
#define MOTOR2PLUS PB4
#define MOTOR2MINUS PB5

/* to control the speed of the motors*/
#define MOTORENABLE PB1

#define LED2 PB0
#define LED1 PD2

/* defines if a pin is input or output,ddr= data direction register */
#define TSENSORDDR DDRD  
/* the input pin controls the values in the port register, PIN is needed
 * instead of PORT when using it as input*/
#define TSENSORPIND PIND

#define TSENSORPORT PORTD

/* note: PD7 is not used */
#define TSENSORFRONTRIGHT PD6
#define TSENSORFRONTLEFT PD5
#define TSENSORRIGHT PD4
#define TSENSORLEFT PD3
/* the bit positions for the input lines */
#define TSENSORPINFRONTRIGHT PIND3
#define TSENSORPINFRONTLEFT PIND4
#define TSENSORPINRIGHT PIND5
#define TSENSORPINLEFT PIND6
#define TSENSORPINBACK PIND7


void delay(unsigned int us)
{
	unsigned int outer=1000;
	while(outer){
		while ( us ) us--;
		outer--;
	}
}

void motoroff(void)
{
	/* motors off only on when button pressed (see below) */
	cbi(MOTORPORT,MOTOR1PLUS);
	cbi(MOTORPORT,MOTOR1MINUS);
	cbi(MOTORPORT,MOTOR2MINUS);	
	cbi(MOTORPORT,MOTOR2PLUS);	
}

void main(void)
{ 
	unsigned char slowled;

	/*enable motor pins as output */
	sbi(MOTORDDR,MOTOR1PLUS);
	sbi(MOTORDDR,MOTOR1MINUS);
	sbi(MOTORDDR,MOTOR2PLUS);
	sbi(MOTORDDR,MOTOR2MINUS);
	sbi(MOTORDDR,MOTORENABLE);
	sbi(DDRD,LED1);	
	sbi(DDRB,LED2);	

	/* enable touch sensor as input line */
	cbi(TSENSORDDR,TSENSORFRONTRIGHT); 
	cbi(TSENSORDDR,TSENSORFRONTLEFT); 
	cbi(TSENSORDDR,TSENSORRIGHT); 
	cbi(TSENSORDDR,TSENSORLEFT); 

	/* pull up resistors on */
	sbi(TSENSORPORT,TSENSORPINFRONTRIGHT);
	sbi(TSENSORPORT,TSENSORPINFRONTLEFT);
	sbi(TSENSORPORT,TSENSORPINRIGHT);
	sbi(TSENSORPORT,TSENSORPINLEFT);
	sbi(TSENSORPORT,TSENSORPINBACK);
	
	/* enable to on (=full speed) */
	sbi(MOTORPORT,MOTORENABLE);	

	/* we check the touch sensors very often to have good respose
	* times but we need to keep the state of the LEDs for a while 
	* to have them nicely blinking */
	slowled=0;

	/* motors off  */
	cbi(MOTORPORT,MOTOR1PLUS);
	cbi(MOTORPORT,MOTOR1MINUS);
	cbi(MOTORPORT,MOTOR2MINUS);	
	cbi(MOTORPORT,MOTOR2PLUS);	
	
	while (1) {
		
	 	/*check if any of the touch sensors is pressed*/
		if (bit_is_clear(TSENSORPIND,TSENSORPINFRONTRIGHT)) {
			motoroff();
		    /* turn motor on the right */
			cbi(MOTORPORT,MOTOR2PLUS);
			sbi(MOTORPORT,MOTOR2MINUS);

		}
		if (bit_is_clear(TSENSORPIND,TSENSORPINFRONTLEFT)) {
			/* turn motor on the left */
			motoroff();
			cbi(MOTORPORT,MOTOR1PLUS);
			sbi(MOTORPORT,MOTOR1MINUS);	

		}	
		if (bit_is_clear(TSENSORPIND,TSENSORPINRIGHT)) {
			motoroff();
			sbi(MOTORPORT,MOTOR2PLUS);
			cbi(MOTORPORT,MOTOR2MINUS);	

		}
		if (bit_is_clear(TSENSORPIND,TSENSORPINLEFT)) {	
			motoroff();
			sbi(MOTORPORT,MOTOR1PLUS);
			cbi(MOTORPORT,MOTOR1MINUS);	

		}
		/* blink led and continue running the motor */
		if (slowled < 125 ){
			cbi(PORTD,LED1);	
			cbi(PORTB,LED2);	
		}else{
			sbi(PORTD,LED1);
			sbi(PORTB,LED2);
		}
		slowled++;
		if (slowled > 250){
			motoroff();
			slowled=0;
		}
		delay(200);					
	}
}
