
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include "Gd_monomer.h" 
 
 
 
/********************************************************************\  
*         GdBead        M E M B E R S  
\********************************************************************/  
 
// Default Constructor 
GdBead::GdBead(){  
  int i;  
	  
  numberBonds = 0;  
  for (i = 0; i < 3; i++){  
    position[i] = 0.0;  
    velocity[i] = 0.0;  
    acceleration[i] = 0.0;  
  };  
	  
  for (i = 0; i < 4; i++){  
    bond[i] = 0;  
  };  
};  
 
 
// Copy Construtor 
GdBead::GdBead(GdBead &source){  
  int i;  
	  
  numberBonds = source.numberBonds;  
  for (i = 0; i < 3; i++){  
    position[i] = source.position[i];  
    velocity[i] = source.velocity[i];  
    acceleration[i] = source.acceleration[i];  
  };  
	  
  for (i = 0; i < 4; i++){  
    bond[i] = 0;  
  };  
};  
 
 
// Assignment Operator 
GdBead& GdBead::operator=(GdBead &b){  
  for (int i = 0; i < 3; i++) {  
    acceleration[i] = b.acceleration[i];  
    position[i] = b.position[i];  
    velocity[i] = b.velocity[i];  
  };  
  return *this;  
};  
 
 
/* Get current position of the bead */  
void GdBead::getPosition(double &x, double &y, double &z) const {  
  x = position[0], y = position[1], z = position[2] ;  
};  
 
/* Get current velocity of the bead */  
void GdBead::getVelocity(double &x, double &y, double &z) const {  
  x = velocity[0], y = velocity[1], z = velocity[2];  
};  
 
/* Get current acceleration of the bead */  
void GdBead::getAcceleration(double &x, double &y, double &z) const{  
  x = acceleration[0], y = acceleration[1], z = acceleration[2];  
};  
 
 
/* Return number of active bonds */  
int GdBead::getNrBonds() const {  
  return (int) numberBonds;  
};  
 
 
/* Compute the distance^2 to the bead "alpha" */  
double GdBead::distanceSqr(GdBead &alpha) const {  
  double tmp = 0.0;  
  for (int i = 0; i < 3; i++)  
    tmp += pow(position[i]-alpha.position[i], 2.0);  
  return tmp;  
};  
 
 
/* Compute the distance to the bead "alpha" */  
double GdBead::distance(GdBead &alpha) const {  
  double tmp = 0.0;  
  for (int i = 0; i < 3; i++)  
    tmp += pow(position[i]-alpha.position[i], 2.0);  
  return sqrt(tmp);  
};  
 
 
/* Check if there are free radicals */ 
bool GdBead::isUnsaturated() const { 
  if(numberBonds < 4) return true; 
  return false; 
}; 
 
 
/* Reset bead acceleration */  
void GdBead::resetAcceleration(){  
  acceleration[0] = 0.0;  
  acceleration[1] = 0.0;  
  acceleration[2] = 0.0;  
};  
 
/* Reset bead velocity */  
void GdBead::resetVelocity(){  
  velocity[0] = 0.0;  
  velocity[1] = 0.0;  
  velocity[2] = 0.0;  
};  
 
 
/* Set position of the bead */  
void GdBead::setPosition(double x, double y, double z){  
  position[0] = x, position[1] = y, position[2] = z;  
};  
 
 
/* Set Velocity of the Bead */  
void GdBead::setVelocity(double x, double y, double z){  
  velocity[0] = x, velocity[1] = y, velocity[2] = z;  
};  
 
 
/* Set Acceleration of the Bead */  
void GdBead::setAcceleration(double x, double y, double z){  
  acceleration[0] = x, acceleration[1] = y, acceleration[2] = z;  
};  
 
 
 
/* Translate the bead in space by dx, dy, dz */  
void GdBead::addPosition(double dx, double dy, double dz){  
  position[0] += dx;  
  position[1] += dy;  
  position[2] += dz;  
};  
 
/* Translate the bead in space by dx, dy, dz */  
void GdBead::addVelocity(double dx, double dy, double dz){  
  velocity[0] += dx;  
  velocity[1] += dy;  
  velocity[2] += dz;  
};  
 
/* Add an acceleration (force) to the bead */  
void GdBead::addAcceleration(double dx, double dy, double dz){  
  acceleration[0] += dx;  
  acceleration[1] += dy;  
  acceleration[2] += dz;  
};  
 
/* Scale the bead's current position by dx, dy, dz */  
void GdBead::multPosition(double dx, double dy, double dz){  
  position[0] *= dx;  
  position[1] *= dy;  
  position[2] *= dz;  
};  
 
 
/* Make a bond between the current bead and "alpha", another bead */  
int GdBead::makeBond(GdBead &alpha){  
  if (numberBonds < 4){  
    bond[numberBonds] = &alpha;  
    numberBonds++;  
  };  
  return (int) numberBonds;  
};  
 
/* Break a bond from the bead */  
int GdBead::breakBond(int i){  
  // First check if it is an existing bond  
  if (i < (int)numberBonds){  
    bond[i] = bond[numberBonds-1];  
    numberBonds--;  
  };  
	  
  return (int) numberBonds;  
};  
 
 
 
 
GdBead& GdBead::getBond(int i){  
  return *bond[i];  
};  
 
 
 
 
 
ostream& operator<<(ostream &cs, GdBead &data){  
  cs << "positions : ";  
  cs << data.position[0] << " ";  
  cs << data.position[1] << " ";  
  cs << data.position[2] << "    ";  
   
  cs << "velocities : ";  
  cs << data.velocity[0] << " ";  
  cs << data.velocity[1] << " ";  
  cs << data.velocity[2] << "    ";  
   
  cs << "accelerations : ";  
  cs << data.acceleration[0] << " ";  
  cs << data.acceleration[1] << " ";  
  cs << data.acceleration[2] << "    ";  
	  
  cs << "bonds : ";  
  cs << data.numberBonds;  
	  
  return cs;  
};  
 
 
 
 

