/*****************************************************************************
  Module: mpgformat.cpp  -- Implements the MPEG3waveformat class
  Copyright (C) 1999  Andrew L. Sandoval

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/
/* Module: mpgformat.cpp                                                     */
/* Developer: Andrew L. Sandoval                                             */
/* Purpose: Implements the MPEG3waveformat class which is used by            */
/* MPEGrecorder to set recording options, etc.                               */
/*****************************************************************************/
#include "mpgformat.h"

static MPEG1WAVEFORMAT* const createFormat(DWORD BitRate, DWORD SampleFreq, WORD layer)
{
	MPEG1WAVEFORMAT *format;
	format = new MPEG1WAVEFORMAT;
	
	if(format)
	{
		format->wfx.cbSize = 22;
		format->wfx.wFormatTag = WAVE_FORMAT_MPEG;
		format->wfx.nChannels = 2;
		format->wfx.nSamplesPerSec = SampleFreq;
		format->wfx.nAvgBytesPerSec = 0;
		format->wfx.nBlockAlign = (144 * BitRate/SampleFreq);
		format->wfx.wBitsPerSample = 0;
		format->fwHeadLayer = layer;
		format->dwHeadBitrate = BitRate;
		format->fwHeadMode = ACM_MPEG_STEREO;
		format->fwHeadModeExt = 0;
		format->wHeadEmphasis = 1;
		format->dwPTSLow = format->dwPTSHigh = 0;
	}
	return const_cast<MPEG1WAVEFORMAT* const>(format);
}

MPEG3waveformat::~MPEG3waveformat()
{ 
	if(this->format) delete const_cast<MPEG1WAVEFORMAT*>(this->format); 
}

//
// Normal Wave Format -- Gets piped to an mp3 encoder
//
static WAVEFORMATEX* const createWavFormat(DWORD SampleFreq)
{
	WAVEFORMATEX *format;
	format = new WAVEFORMATEX;
	
	if(format)
	{
		format->cbSize = 0;
		format->wFormatTag = WAVE_FORMAT_PCM;
		format->nChannels = 2;
		format->nSamplesPerSec = SampleFreq;
		format->nBlockAlign = (16 * 2) / 8; 
		format->wBitsPerSample = 16;
		format->nAvgBytesPerSec = SampleFreq * format->nBlockAlign;
	}
	return const_cast<WAVEFORMATEX* const>(format);
}

NORMALwaveformat::~NORMALwaveformat()
{ 
	if(this->format) delete const_cast<WAVEFORMATEX*>(this->format); 
}
