/* The implementation of the floating point class */

#ifndef FLOATS_H
#define FLOATS_H

#include <math.h>

#include "datatypes.H"

#define FLTERRORSTR "<<< ERROR >>>"


class CalcFloat : public Arithdatatype {

private:
  double value;


public:
/* constructors */
  CalcFloat(void);
  CalcFloat(CalcFloat const &from);
  CalcFloat(double const &from);
  CalcFloat(int const &from);

  ~CalcFloat(void);

  inline int int_value(void) const {
    return (int) value;
  }
  
  inline int value_ok(void) const {
    return !(isinf(value) || isnan(value));
  }

  void printvalue(int ndigits, enum disp_mode dmode, char *buffer, int bsize,
		  int *rows, int *cols) const;
  parse_codes parsevalue(char const *buffer, char **remainder);

  CalcFloat &operator= (double from);
  CalcFloat &operator= (int from);
  CalcFloat &operator= (Arithdatatype const &from);
  CalcFloat &operator= (CalcFloat const &from);

// Unary + and -
//  CalcFloat &operator+ (void) const { return (CalcFloat &) *new CalcFloat(this->value); }
//  CalcFloat &operator- (void) const { return (CalcFloat &) *new CalcFloat(-this->value); }
  
// Arithmetic functions
  CalcFloat &plus (Arithdatatype const &from) {
    CalcFloat &ff = (CalcFloat &) from;
    this->value += ff.value;
    return *this;
  }

  CalcFloat &minus(Arithdatatype const &from) {
    CalcFloat &ff = (CalcFloat &) from;
    this->value -= ff.value;
    return *this;
  }

  CalcFloat &times(Arithdatatype const &from) {
    CalcFloat &ff = (CalcFloat &) from;
    this->value *= ff.value;
    return *this;
  }

  CalcFloat &div_by(Arithdatatype const &from) {
    CalcFloat &ff = (CalcFloat &) from;
    this->value /= ff.value;
    return *this;
  }
  
// Trig and trans
  CalcFloat &sin(void);
  CalcFloat &cos(void);
  CalcFloat &tan(void);
  CalcFloat &arcsin(void);
  CalcFloat &arccos(void);
  CalcFloat &arctan(void);
  CalcFloat &sqrt(void);
  CalcFloat &square(void);
  CalcFloat &log_e(void);
  CalcFloat &exp_e(void);
  CalcFloat &log_10(void);
  CalcFloat &exp_10(void);
  CalcFloat &recip(void);
  CalcFloat &power(Arithdatatype const &exponent);
  CalcFloat &abs(void);
  CalcFloat &factorial(void);
  void rec2polar(Arithdatatype *x, Arithdatatype *y);
  void polar2rec(Arithdatatype *x, Arithdatatype *y);

// Increment / decrement
  CalcFloat &operator++ (void) {
    this->value++;
    return *this;
  }

  CalcFloat &operator-- (void) {
    this->value--;
    return *this;
  }

// Relational operators
  bool operator! (void) const {
    return (this->value != 0.0);
  }

  bool operator== (Arithdatatype const &cmpr) const {
    return (this->value == ((CalcFloat const &) cmpr).value);
  }

  bool operator== (int const &cmpr) const {
    return (this->value == cmpr);
  }

  bool operator!= (Arithdatatype const &cmpr) const {
    return (this->value != ((CalcFloat const &) cmpr).value);
  }

  bool operator!= (int const &cmpr) const {
    return (this->value != cmpr);
  }

  bool operator> (Arithdatatype const &cmpr) const {
    return (this->value > ((CalcFloat const &) cmpr).value);
  }

  bool operator> (int const &cmpr) const {
    return (this->value > cmpr);
  }

  bool operator>= (Arithdatatype const &cmpr) const {
    return (this->value >= ((CalcFloat const &) cmpr).value);
  }

  bool operator< (Arithdatatype const &cmpr) const {
    return (this->value < ((CalcFloat const &) cmpr).value);
  }

  bool operator< (int const &cmpr) const {
    return (this->value < cmpr);
  }

  bool operator<= (Arithdatatype const &cmpr) const {
    return (this->value <= ((CalcFloat const &) cmpr).value);
  }


private:
/* Make sure the value conforms to HP-67 internal representation */
  void force_strict_numbers(void);
/* Round off to 10 digits. Used for strict emulation mode */
  void force_10digits(void);
/* Enforce precision limits */
  void force_2dexponent(void);
/* Check for illegal values, and possibly force HP-67 representation */
  inline void check_value(void);
  
};


inline CalcFloat::~CalcFloat(void)
{
}


inline void CalcFloat::check_value(void)
{
  if (isinf(this->value)) {
    this->value = HUGE_VAL * isinf(value);
  }
}


#endif  /* !FLOATS_H */
