#ifndef FLAGS_H
#define FLAGS_H

#include "memory.h"


/* Flags. Notice that flags matching the strings "2" or "3" are cleared
 * on reading if "MAGIC_FLAGS" is defined */


class fstruct
{
public:
  unsigned setting:1;
  unsigned clr_on_test:1;

  inline fstruct(void) { setting = clr_on_test = FALSE; }
  inline fstruct(bool arg) { setting = arg; clr_on_test = FALSE; }
};


class Flags {

private:
  HashTable<fstruct> *flagelems;

public:
  inline Flags(void) { flagelems = new HashTable<fstruct>; };
  inline ~Flags(void) { delete flagelems; };

  inline void set_flag(char const *label, int test_clears);
  inline void clr_flag(char const *label);
  inline bool test_flag(char const *label);
  inline void clr_all_flags(void) { delete flagelems;
				    flagelems = new HashTable<fstruct> ; }
};

inline void Flags::set_flag(char const *label, int test_clears = FALSE)
{
  (*flagelems)[label].setting = TRUE;
  (*flagelems)[label].clr_on_test = (test_clears ? TRUE : FALSE);
}

inline void Flags::clr_flag(char const *label)
{
  (*flagelems)[label].setting = (*flagelems)[label].clr_on_test = FALSE;
}

inline bool Flags::test_flag(char const *label)
{
  bool retval = (*flagelems)[label].setting;

#ifdef MAGIC_FLAGS
  if (label[1] == 0 && 
      (label[0] == '2' ||
       label[0] == '3'))
    clr_flag(label);
#endif  /* MAGIC_FLAGS */

  if ((*flagelems)[label].clr_on_test)
    clr_flag(label);

  return retval;
}

#endif  /* !FLAGS_H */
