#include "progmem.h"


static void basicparse(char *rest, char **arg, char **comment, int *hasarg)
{
  char *cp2, *cptr;

  *arg = *comment = NULL;
  cp2 = rest + strspn(rest, WHITESPACE); /* Flush initial whitespace */
  if (*cp2 != 0) {  /* There's something in 'rest' */

    *arg = cp2;   /* Arg points to the argument plus
		   * any comment */

    if ((cptr = strchr(*arg, COMMENT)) != NULL) {
      *cptr = 0;
      *comment = cptr + 1;  /* Clip the comment off the string, and
			     * point to it */
    } else {
      *comment = *arg + strlen(*arg);
    }

    cptr = *arg + strlen(*arg) - 1;
    while (strchr(WHITESPACE, *cptr)) *(cptr--) = 0;  // flush trailing whitespace
  }

  *hasarg = (*arg == NULL || **arg == 0) ? 0 : 1;
}


/* Parse everything after the first word in the line to produce
 * argument and comment fields. These are located inside the "rest"
 * argument, a pointer to a NUL-terminated string representing the
 * text after the the first word which was keyed in. After the
 * subroutine returns, the contents of "rest" have been altered 
 *
 * Return values: -1 if the parse was bad
 *                 0 if the parse was good
 *                 1 if the parsing has produced a command which cannot
 *                     be stored as program memory, but must be executed
 *                     immediately even when in program mode.
 */
/* Default function never returns 1. Default function assumes that
 * if an argument is allowed, then it is required. */
int KeyType::parse_arg(char *rest, char **arg, char **comment) const
{
  int hasarg;

  if (this->new_parse_arg != NULL)
    return (*this->new_parse_arg)(rest, arg, comment);

  basicparse(rest, arg, comment, &hasarg);

  if (*arg != NULL && **arg == '.') return -1;   // Arguments must not begin with '.'
  if (hasarg == this->keycap.can_have_arg) return 0;
  return -1;
}


// The following function is not a method of KeyType, but it's related
// to KeyType::parse_arg()
// We need a special parse for "immed" because it cannot be stored as
// a program command.
int parse_arg_immed_or_clprg(char *rest, char **arg, char **comment)
{
  int hasarg;

  basicparse(rest, arg, comment, &hasarg);

  if (hasarg) return -1;

  return 1;
}

int parse_arg_goto(char *rest, char **arg, char **comment)
{
  char *endptr;
  int hasarg;

  basicparse(rest, arg, comment, &hasarg);
  
  if (!hasarg) return -1;    // Problem, 'goto' must have an argument

  if (**arg == '.') {    // Absolute address branch
    (void) strtol(*arg + 1, &endptr, 10);  // Check to make sure it's a valid
    if (*endptr == 0)                      // integer
      return 1;
    else
      return -1;
  }

  return 0;
}


int parse_arg_run(char *rest, char **arg, char **comment)
{
  int hasarg;

  basicparse(rest, arg, comment, &hasarg);


  if (*arg != NULL && **arg == '.') return -1;   // Arguments must not begin with '.'
  if (runmode != IMMED &&
      !hasarg)
    return -1;      // Need an argument if not in immediate mode

  return 0;
}


int parse_arg_loadsave(char *rest, char **arg, char **comment)
{
  char *cptr;

  *arg = rest + strspn(rest, WHITESPACE);
  *comment = *arg + strlen(*arg);
  cptr = *comment - 1;
  while (strchr(WHITESPACE, *cptr)) *(cptr--) = 0;

  if (**arg != 0) return 0;
  return -1;
}
