#!/usr/bin/env python
#
# dpw.py - GUI front end for decrypting passwords
#
# Author: Jerry Sweet <cfs-tools@akamail.com>
#
# Acknowledgments:
# - Some of the GUI code was borrowed from "Programming Python", 
#   2nd ed. by Mark Lutz (O'Reilly, March 2001, ISBN: 0-596-00085-5).
#   (Any ugly code or bad GUI design is my fault, not Mr. Lutz's.)
#
# Notes:
#   - This program requires Tkinter and some other Python modules
#       that were standard as of Python 1.5.2, which is the version
#       that came with Red Hat Linux 6.2.
#   - Change the "Customization Section" below to suit yourself.
#   - After pressing the "go" button, results can take a minute or so 
#       to appear.
#   - Requires the "decrypt" command, which is a Perl script that
#       simplifies the interface to "cattach".
#   - The following is a somewhat simplified summary of what this
#     program does (partially by means of calling "decrypt"):
#         $ cd ~/cdata && cattach -l -i 10 pw {unique-name}
#         $ grep -i {pattern} /mnt/crypt/{unique-name}/passwords
#         $ cdetach {unique-name}
#
# No warranty.  User of this program agrees to hold author(s) harmless.
#
# $Id: dpw.py,v 1.1 2002/07/10 23:26:40 jsweet Rel $

import Tkinter
import sys
import string
import re
import popen2
import select

class ScrolledText(Tkinter.Frame):
    def __init__(self, parent=None, howhigh=8):
        Tkinter.Frame.__init__(self, parent)
        self.pack(expand=Tkinter.YES, fill=Tkinter.BOTH)
                                                         # make me expandable
        self.makewidgets(howhigh)

    def makewidgets(self, howhigh):
        sbar = Tkinter.Scrollbar(self)
        text = Tkinter.Text(self, relief=Tkinter.SUNKEN)
        sbar.config(command=text.yview)                  # xlink sbar and text
        text.config(yscrollcommand=sbar.set, height=howhigh)
                                                         # move one moves other
        sbar.pack(side=Tkinter.RIGHT, fill=Tkinter.Y)    # pack first=clip last
        text.pack(side=Tkinter.LEFT, expand=Tkinter.YES, fill=Tkinter.BOTH)
						         # text clipped first
        self.text = text

    def settext(self, text=''):
        self.text.delete('1.0', Tkinter.END)             # delete current text
        self.text.insert('1.0', text)                    # add at line 1, col 0
        self.text.mark_set(Tkinter.INSERT, '1.0')        # set insert cursor
        self.text.focus()                                # save user a click

    def gettext(self):                                   # returns a string
        return self.text.get('1.0', Tkinter.END + '-1c') # first through last

def progname():
    progpat = re.compile("([^/]+)$")
    progmatch = progpat.search(sys.argv[0])
    if progmatch:
	return progmatch.group(1)
    else:
	return "Unknown"

def rundecrypt():
    global cmdout
    global cmdin
    global cmderr
    global key
    global passwordsdir
    global passwordsfile

    cmdout, cmdin, cmderr = popen2.popen3('decrypt -unique ' +
                                          '-cat=' + passwordsfile +
                                          ' - ' + passwordsdir)

    cmdin.write(key + "\n")
    cmdin.flush()
    cmdin.close()
    
def selectresult():
    global cmdout
    global text
    global textheight
    global prog

    if pattern:
    	matchtext = []
    	searchpat = re.compile(pattern, re.I)
    	for line in cmdout.readlines():
    	    match = searchpat.search(line)
    	    if match:
    		matchtext.append(line)
    else:
        matchtext = cmdout.readlines()

    cmdout.close()

    if len(matchtext) > 0:
        text = string.join(matchtext, '')
	if len(matchtext) > 8:
            textheight = 8
        else:
            textheight = len(matchtext)
    else:
        text = prog + ": no match for '" + pattern + "'"
        textheight = 1
    
def checkerrors():
    global cmderr
    global text
    global textheight

    errtext = cmderr.readlines()
    cmderr.close()
    
    if len(errtext) > 0:
        text = string.join(errtext, '')
        textheight = 1
    
def displayresult():
    global textboxlist
    global root
    global text
    global textheight

    textboxlist.append(ScrolledText(root, howhigh=textheight))
    textboxlist[-1].settext(text)

def startsearch():
    global textboxlist
    global patbox
    global keybox
    global root
    global prog
    global key
    global pattern
  
    pattern = patbox.get()
    key = keybox.get()

    if not key:
        textboxlist.append(ScrolledText(root, howhigh=1))
  	textboxlist[-1].settext(prog + ': error: you must enter a key.')
	return

    rundecrypt()
    selectresult()
    checkerrors()
    displayresult()


def reset():
    global textboxlist
    global patbox

    if len(textboxlist) > 0:
	for textbox in textboxlist:
            textbox.forget()

        textboxlist = []

    if patbox:
        patbox.focus()
  
def RCSrev():
    revpat = re.compile("revision:\s+(\S+)", re.I)
    revmatch = revpat.search('$Revision: 1.1 $')
    if revmatch:
        return revmatch.group(1)
    else:
        return '(unknown revision)' 

def help():
    global textboxlist
    global root
    global textheight
    global sw_version

    helptext = "This program, " + prog + " " + RCSrev() + \
", provides a graphical user interface for\n\
searching a CFS private file containing passwords.\n\
\n\
The file to be searched is named \"passwords\".\n\
That file resides under the private directory ~/cdata/pw,\n\
which you may create as in this example:\n\
\n\
    $ decrypt -init pw\n\
    Key: (type a key/passphrase here and remember it)\n\
    Again: (type the key again)\n\
    Key: (type the key once more for the attach process)\n\
\n\
Example contents of the \"passwords\" file may then be created\n\
as follows (although you might prefer to use a text editor):\n\
\n\
    $ cat >/mnt/crypt/${LOGNAME}-pw/passwords <<EOF\n\
village.example.com login id [assigned 6/28/02]:  number6\n\
village.example.com password [changed 6/28/02]: HoozNo2\n\
pulp.example.com login id [assigned 7/4/02]: zed94\n\
pulp.example.com password [changed 7/4/02]: ZedzDedBB\n\
EOF\n\
\n\
    $ cdetach ${LOGNAME}-pw\n\
\n\
How to use this program once the \"passwords\" file exists:\n\
\n\
- In the \"Pattern\" field, type a pattern such as \"village\",\n\
  and in the \"Key\" field, type the same key with which you\n\
  created the \"pw\" directory in the example above.\n\
\n\
  Then click the \"go\" button.\n\
\n\
  It may take a minute or two to display a result,\n\
  which, if you used the \"village\" example above,\n\
  should be the two lines from the example above that\n\
  contain the pattern \"village\".\n\
\n\
- The \"clear search results\" button makes the previous\n\
  search results disappear in preparation for another search.\n\
  You may leave the previous search results visible if you wish.\n\
\n\
- The \"quit\" button ends the program.\n\
\n\
Notes:\n\
\n\
- As shown in the example above, this program requires\n\
  \"decrypt\", a Perl script that accompanies this program.\n\
  The \"decrypt\" program must be located in a directory\n\
  named in your execution path (your $PATH environment variable).\n\
\n\
- The following is a somewhat simplified summary of what this\n\
  program does (partially by means of calling \"decrypt\"):\n\
\n\
      $ cd ~/cdata && cattach -l -i 10 pw {unique-name}\n\
      $ grep -i {pattern} /mnt/crypt/{unique-name}/passwords\n\
      $ cdetach {unique-name}\n\
\n\
- Maintaining a file, even an encrypted one, containing various\n\
  login ids and passwords, may violate your organization's security\n\
  policy; this isn't necessarily \"best practice\" for password\n\
  security. Ask your information security officer for guidance.\n\
\n\
- No warranty.  User of this program agrees to hold author(s) harmless.\n\
"
    textboxlist.append(ScrolledText(root, howhigh=12))
    textboxlist[-1].settext(helptext)



def initkeyfield():
    # Key entry field
    
    global root
    global keybox

    row = Tkinter.Frame(root)
    lab = Tkinter.Label(row, width=8, text="Key")
    keybox = Tkinter.Entry(row, show='*')
    row.pack(side=Tkinter.TOP, fill=Tkinter.X)
    lab.pack(side=Tkinter.LEFT)
    keybox.pack(side=Tkinter.RIGHT, expand=Tkinter.YES, fill=Tkinter.X)
    
def initpatternfield():
    # Pattern entry field
    
    global root
    global patbox

    row = Tkinter.Frame(root)
    lab = Tkinter.Label(row, width=8, text="Pattern")
    patbox = Tkinter.Entry(row)
    row.pack(side=Tkinter.TOP, fill=Tkinter.X)
    lab.pack(side=Tkinter.LEFT)
    patbox.pack(side=Tkinter.RIGHT, expand=Tkinter.YES, fill=Tkinter.X)
    
def initactionbuttons():
    # Action buttons
    
    global root

    row = Tkinter.Frame(root)
    lab = Tkinter.Label(row, width=8, text="Actions")
    gobutton = Tkinter.Button(row, text="go", width=15, 
                              command=startsearch)
    clearbutton = Tkinter.Button(row, text="clear search results", 
                                 width=15, command=reset)
    helpbutton = Tkinter.Button(row, text="help", width=15,
				command=help)
    quitbutton = Tkinter.Button(row, text="quit", width=15, 
				command=root.quit)
    lab.pack(side=Tkinter.LEFT)
    gobutton.pack(side=Tkinter.LEFT)
    clearbutton.pack(side=Tkinter.LEFT)
    helpbutton.pack(side=Tkinter.LEFT)
    quitbutton.pack(side=Tkinter.LEFT)
    row.pack(expand=Tkinter.YES, fill=Tkinter.X)


def initwindow():
    global textboxlist
    global root
    global prog

    # Root window instantiation
    
    root = Tkinter.Tk()
    Tkinter.Label(root, text=prog + ": password search").pack()
    
    # Root window active elements setup

    textboxlist = []
    
    initkeyfield()
    initpatternfield()
    initactionbuttons()
    
    # Root window start

    root.title(prog)
    root.mainloop()

# ========================================================================
# Customization section
#

#
# Specify the subdirectory under "cnotes" where you keep your passwords file.
# 

passwordsdir = 'pw'

#
# Specify the passwords file name.
#

passwordsfile = 'passwords'

# ========================================================================
# Main
#

prog = progname()
initwindow()
