/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.types.Cluster;

public interface ClusterService extends Service {
    public interface GetRequest extends Request<GetRequest, GetResponse> {
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        GetRequest filter(Boolean filter);
    }
    
    public interface GetResponse extends Response {
        Cluster cluster();
    }
    
    GetRequest get();
    
    /**
     * Removes cluster from the system.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/clusters/00000000-0000-0000-0000-000000000000
     * ----
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    /**
     * Removes cluster from the system.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/clusters/00000000-0000-0000-0000-000000000000
     * ----
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Removes cluster from the system.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/clusters/00000000-0000-0000-0000-000000000000
     * ----
     */
    RemoveRequest remove();
    
    public interface ResetEmulatedMachineRequest extends Request<ResetEmulatedMachineRequest, ResetEmulatedMachineResponse> {
        /**
         * Indicates if the reset should be performed asynchronously.
         */
        ResetEmulatedMachineRequest async(Boolean async);
    }
    
    public interface ResetEmulatedMachineResponse extends Response {
    }
    
    ResetEmulatedMachineRequest resetEmulatedMachine();
    
    /**
     * Updates information about the cluster.
     * 
     * Only specified fields are updated, others remain unchanged.
     * 
     * E.g. update cluster's CPU:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/clusters/123
     * ----
     * 
     * With request body like:
     * 
     * [source,xml]
     * ----
     * <cluster>
     *   <cpu>
     *     <type>Intel Haswell-noTSX Family</type>
     *   </cpu>
     * </cluster>
     * ----
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest cluster(Cluster cluster);
        UpdateRequest cluster(ClusterBuilder cluster);
    }
    
    /**
     * Updates information about the cluster.
     * 
     * Only specified fields are updated, others remain unchanged.
     * 
     * E.g. update cluster's CPU:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/clusters/123
     * ----
     * 
     * With request body like:
     * 
     * [source,xml]
     * ----
     * <cluster>
     *   <cpu>
     *     <type>Intel Haswell-noTSX Family</type>
     *   </cpu>
     * </cluster>
     * ----
     */
    public interface UpdateResponse extends Response {
        Cluster cluster();
    }
    
    /**
     * Updates information about the cluster.
     * 
     * Only specified fields are updated, others remain unchanged.
     * 
     * E.g. update cluster's CPU:
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/clusters/123
     * ----
     * 
     * With request body like:
     * 
     * [source,xml]
     * ----
     * <cluster>
     *   <cpu>
     *     <type>Intel Haswell-noTSX Family</type>
     *   </cpu>
     * </cluster>
     * ----
     */
    UpdateRequest update();
    
    AffinityGroupsService affinityGroupsService();
    AssignedCpuProfilesService cpuProfilesService();
    GlusterHooksService glusterHooksService();
    GlusterVolumesService glusterVolumesService();
    /**
     * A sub collection with all the supported network filters for this cluster.
     */
    NetworkFiltersService networkFiltersService();
    AssignedNetworksService networksService();
    AssignedPermissionsService permissionsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

