/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.GraphicsConsoleBuilder;
import org.ovirt.engine.sdk4.types.GraphicsConsole;

public interface VmGraphicsConsolesService extends Service {
    /**
     * Add new graphics console to the virtual machine.
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest console(GraphicsConsole console);
        AddRequest console(GraphicsConsoleBuilder console);
    }
    
    /**
     * Add new graphics console to the virtual machine.
     */
    public interface AddResponse extends Response {
        GraphicsConsole console();
    }
    
    /**
     * Add new graphics console to the virtual machine.
     */
    AddRequest add();
    
    /**
     * Lists all the configured graphics consoles of the virtual machine.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Use the following query to obtain the current run-time configuration of the graphics consoles.
         * 
         * [source]
         * ----
         * GET /ovit-engine/api/vms/123/graphicsconsoles?current=true
         * ----
         * 
         * The default value is `false`.
         */
        ListRequest current(Boolean current);
        /**
         * Sets the maximum number of consoles to return. If not specified all the consoles are returned.
         */
        ListRequest max(Integer max);
        /**
         * Sets the maximum number of consoles to return. If not specified all the consoles are returned.
         */
        ListRequest max(Long max);
        /**
         * Sets the maximum number of consoles to return. If not specified all the consoles are returned.
         */
        ListRequest max(BigInteger max);
    }
    
    /**
     * Lists all the configured graphics consoles of the virtual machine.
     */
    public interface ListResponse extends Response {
        /**
         * The list of graphics consoles of the virtual machine.
         */
        List<GraphicsConsole> consoles();
    }
    
    /**
     * Lists all the configured graphics consoles of the virtual machine.
     */
    ListRequest list();
    
    /**
     * Returns a reference to the service that manages a specific virtual machine graphics console.
     */
    VmGraphicsConsoleService consoleService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

