/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.CpuTopology;

public class CpuTopologyContainer extends Container implements CpuTopology {
    private BigInteger cores;
    private BigInteger sockets;
    private BigInteger threads;
    
    public BigInteger cores() {
        return cores;
    }
    
    public void cores(BigInteger newCores) {
        cores = newCores;
    }
    
    public boolean coresPresent() {
        return cores != null;
    }
    
    public BigInteger sockets() {
        return sockets;
    }
    
    public void sockets(BigInteger newSockets) {
        sockets = newSockets;
    }
    
    public boolean socketsPresent() {
        return sockets != null;
    }
    
    public BigInteger threads() {
        return threads;
    }
    
    public void threads(BigInteger newThreads) {
        threads = newThreads;
    }
    
    public boolean threadsPresent() {
        return threads != null;
    }
    
}
