/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.types.Disk;

public interface VmDiskService extends Service {
    public interface ActivateRequest extends Request<ActivateRequest, ActivateResponse> {
        /**
         * Indicates if the activation should be performed asynchronously.
         */
        ActivateRequest async(Boolean async);
    }
    
    public interface ActivateResponse extends Response {
    }
    
    ActivateRequest activate();
    
    public interface DeactivateRequest extends Request<DeactivateRequest, DeactivateResponse> {
        /**
         * Indicates if the deactivation should be performed asynchronously.
         */
        DeactivateRequest async(Boolean async);
    }
    
    public interface DeactivateResponse extends Response {
    }
    
    DeactivateRequest deactivate();
    
    public interface ExportRequest extends Request<ExportRequest, ExportResponse> {
        /**
         * Indicates if the export should be performed asynchronously.
         */
        ExportRequest async(Boolean async);
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        ExportRequest filter(Boolean filter);
    }
    
    public interface ExportResponse extends Response {
    }
    
    ExportRequest export();
    
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    public interface GetResponse extends Response {
        Disk disk();
    }
    
    GetRequest get();
    
    public interface MoveRequest extends Request<MoveRequest, MoveResponse> {
        /**
         * Indicates if the move should be performed asynchronously.
         */
        MoveRequest async(Boolean async);
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        MoveRequest filter(Boolean filter);
    }
    
    public interface MoveResponse extends Response {
    }
    
    MoveRequest move();
    
    /**
     * Detach the disk from the virtual machine.
     * 
     * NOTE: In version 3 of the API this used to also remove the disk completely from the system, but starting with
     * version 4 it doesn't. If you need to remove it completely use the <<services/disk/methods/remove,remove
     * method of the top level disk service>>.
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    /**
     * Detach the disk from the virtual machine.
     * 
     * NOTE: In version 3 of the API this used to also remove the disk completely from the system, but starting with
     * version 4 it doesn't. If you need to remove it completely use the <<services/disk/methods/remove,remove
     * method of the top level disk service>>.
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Detach the disk from the virtual machine.
     * 
     * NOTE: In version 3 of the API this used to also remove the disk completely from the system, but starting with
     * version 4 it doesn't. If you need to remove it completely use the <<services/disk/methods/remove,remove
     * method of the top level disk service>>.
     */
    RemoveRequest remove();
    
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest disk(Disk disk);
        UpdateRequest disk(DiskBuilder disk);
    }
    
    public interface UpdateResponse extends Response {
        Disk disk();
    }
    
    UpdateRequest update();
    
    AssignedPermissionsService permissionsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

