/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ConfigurationContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlConfigurationTypeReader;
import org.ovirt.engine.sdk4.types.Configuration;

public class XmlConfigurationReader {
    public static Configuration readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        ConfigurationContainer object = new ConfigurationContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "data": {
                    object.data(reader.readString());
                    continue block10;
                }
                case "type": {
                    object.type(XmlConfigurationTypeReader.readOne(reader));
                    continue block10;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block10;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlConfigurationReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Configuration> iterateMany(final XmlReader reader) {
        return new Iterator<Configuration>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Configuration next() {
                Configuration next = XmlConfigurationReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Configuration> readMany(XmlReader reader) {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        Iterator<Configuration> iterator = XmlConfigurationReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ConfigurationContainer object, String[] link) {
    }
}

