/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.GlusterHookContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterHookStatusReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterServerHookReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHookContentTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHookStageReader;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.GlusterServerHook;

public class XmlGlusterHookReader {
    public static GlusterHook readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        GlusterHookContainer object = new GlusterHookContainer();
        block40: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block40;
                }
                case "id": {
                    object.id(image);
                    continue block40;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block41: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "checksum": {
                    object.checksum(reader.readString());
                    continue block41;
                }
                case "cluster": {
                    object.cluster(XmlClusterReader.readOne(reader));
                    continue block41;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block41;
                }
                case "conflict_status": {
                    object.conflictStatus(reader.readInteger());
                    continue block41;
                }
                case "conflicts": {
                    object.conflicts(reader.readString());
                    continue block41;
                }
                case "content": {
                    object.content(reader.readString());
                    continue block41;
                }
                case "content_type": {
                    object.contentType(XmlHookContentTypeReader.readOne(reader));
                    continue block41;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block41;
                }
                case "gluster_command": {
                    object.glusterCommand(reader.readString());
                    continue block41;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block41;
                }
                case "server_hooks": {
                    object.serverHooks(XmlGlusterServerHookReader.readMany(reader));
                    continue block41;
                }
                case "stage": {
                    object.stage(XmlHookStageReader.readOne(reader));
                    continue block41;
                }
                case "status": {
                    object.status(XmlGlusterHookStatusReader.readOne(reader));
                    continue block41;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block41;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlGlusterHookReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<GlusterHook> iterateMany(final XmlReader reader) {
        return new Iterator<GlusterHook>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public GlusterHook next() {
                GlusterHook next = XmlGlusterHookReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<GlusterHook> readMany(XmlReader reader) {
        ArrayList<GlusterHook> list = new ArrayList<GlusterHook>();
        Iterator<GlusterHook> iterator = XmlGlusterHookReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(GlusterHookContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "serverhooks": {
                    ArrayListWithHref<GlusterServerHook> list = new ArrayListWithHref<GlusterServerHook>(object.serverHooks());
                    list.href(href);
                    object.serverHooks(list);
                    break;
                }
            }
        }
    }
}

