/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Quota;
import org.ovirt.engine.sdk4.types.QuotaClusterLimit;

public class QuotaClusterLimitContainer extends IdentifiedContainer implements QuotaClusterLimit {
    private BigDecimal memoryLimit;
    private BigDecimal memoryUsage;
    private BigInteger vcpuLimit;
    private BigInteger vcpuUsage;
    private Cluster cluster;
    private Quota quota;
    
    public BigDecimal memoryLimit() {
        return memoryLimit;
    }
    
    public void memoryLimit(BigDecimal newMemoryLimit) {
        memoryLimit = newMemoryLimit;
    }
    
    public boolean memoryLimitPresent() {
        return memoryLimit != null;
    }
    
    public BigDecimal memoryUsage() {
        return memoryUsage;
    }
    
    public void memoryUsage(BigDecimal newMemoryUsage) {
        memoryUsage = newMemoryUsage;
    }
    
    public boolean memoryUsagePresent() {
        return memoryUsage != null;
    }
    
    public BigInteger vcpuLimit() {
        return vcpuLimit;
    }
    
    public void vcpuLimit(BigInteger newVcpuLimit) {
        vcpuLimit = newVcpuLimit;
    }
    
    public boolean vcpuLimitPresent() {
        return vcpuLimit != null;
    }
    
    public BigInteger vcpuUsage() {
        return vcpuUsage;
    }
    
    public void vcpuUsage(BigInteger newVcpuUsage) {
        vcpuUsage = newVcpuUsage;
    }
    
    public boolean vcpuUsagePresent() {
        return vcpuUsage != null;
    }
    
    public Cluster cluster() {
        return cluster;
    }
    
    public void cluster(Cluster newCluster) {
        cluster = newCluster;
    }
    
    public boolean clusterPresent() {
        return cluster != null;
    }
    
    public Quota quota() {
        return quota;
    }
    
    public void quota(Quota newQuota) {
        quota = newQuota;
    }
    
    public boolean quotaPresent() {
        return quota != null;
    }
    
}
