/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.CpuTuneContainer;
import org.ovirt.engine.sdk4.types.CpuTune;
import org.ovirt.engine.sdk4.types.VcpuPin;

public class CpuTuneBuilder {
    private List<VcpuPin> vcpuPins;
    
    public CpuTuneBuilder vcpuPins(List<VcpuPin> newVcpuPins) {
        if (newVcpuPins != null) {
            if (vcpuPins == null) {
                vcpuPins = new ArrayList<>(newVcpuPins);
            }
            else {
                vcpuPins.addAll(newVcpuPins);
            }
        }
        return this;
    }
    
    public CpuTuneBuilder vcpuPins(VcpuPin... newVcpuPins) {
        if (newVcpuPins != null) {
            if (vcpuPins == null) {
                vcpuPins = new ArrayList<>(newVcpuPins.length);
            }
            Collections.addAll(vcpuPins, newVcpuPins);
        }
        return this;
    }
    
    public CpuTuneBuilder vcpuPins(VcpuPinBuilder... newVcpuPins) {
        if (newVcpuPins != null) {
            if (vcpuPins == null) {
                vcpuPins = new ArrayList<>(newVcpuPins.length);
            }
            for (VcpuPinBuilder builder : newVcpuPins) {
                vcpuPins.add(builder.build());
            }
        }
        return this;
    }
    
    
    public CpuTune build() {
        CpuTuneContainer container = new CpuTuneContainer();
        container.vcpuPins(vcpuPins);
        return container;
    }
}
