/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.Rate;

public class RateContainer extends Container implements Rate {
    private BigInteger bytes;
    private BigInteger period;
    
    public BigInteger bytes() {
        return bytes;
    }
    
    public void bytes(BigInteger newBytes) {
        bytes = newBytes;
    }
    
    public boolean bytesPresent() {
        return bytes != null;
    }
    
    public BigInteger period() {
        return period;
    }
    
    public void period(BigInteger newPeriod) {
        period = newPeriod;
    }
    
    public boolean periodPresent() {
        return period != null;
    }
    
}
