/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.StorageFormat;

public class XmlStorageFormatWriter {
    
    public static void writeOne(StorageFormat object, XmlWriter writer) {
        writeOne(object, "storage_format", writer);
    }
    
    public static void writeOne(StorageFormat object, String tag, XmlWriter writer) {
        writer.writeElement(tag, object.value());
    }
    
    public static void writeMany(Iterator<StorageFormat> list, XmlWriter writer) {
        writeMany(list, "storage_format", "storage_formats", writer);
    }
    
    public static void writeMany(Iterator<StorageFormat> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlStorageFormatWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

