/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StorageDomainStatus {
    ACTIVATING("activating"),
    ACTIVE("active"),
    DETACHING("detaching"),
    INACTIVE("inactive"),
    LOCKED("locked"),
    MAINTENANCE("maintenance"),
    MIXED("mixed"),
    PREPARING_FOR_MAINTENANCE("preparing_for_maintenance"),
    UNATTACHED("unattached"),
    UNKNOWN("unknown");

    private static final Logger log;
    private String image;

    private StorageDomainStatus(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StorageDomainStatus fromValue(String value) {
        try {
            return StorageDomainStatus.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StorageDomainStatus' enumerated type. Valid values are 'activating', 'active', 'detaching', 'inactive', 'locked', 'maintenance', 'mixed', 'preparing_for_maintenance', 'unattached' and 'unknown'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StorageDomainStatus.class);
    }
}

