/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.BookmarkBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlBookmarkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBookmarkWriter;
import org.ovirt.engine.sdk4.services.BookmarkService;
import org.ovirt.engine.sdk4.types.Bookmark;

public class BookmarkServiceImpl
extends ServiceImpl
implements BookmarkService {
    public BookmarkServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public BookmarkService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public BookmarkService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public BookmarkService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "BookmarkService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements BookmarkService.UpdateResponse {
        private Bookmark bookmark;

        private UpdateResponseImpl() {
        }

        public void bookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
        }

        @Override
        public Bookmark bookmark() {
            return this.bookmark;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<BookmarkService.UpdateRequest, BookmarkService.UpdateResponse>
    implements BookmarkService.UpdateRequest {
        private Boolean async;
        private Bookmark bookmark;

        private UpdateRequestImpl() {
        }

        @Override
        public BookmarkService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public BookmarkService.UpdateRequest bookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        @Override
        public BookmarkService.UpdateRequest bookmark(BookmarkBuilder bookmark) {
            this.bookmark = bookmark.build();
            return this;
        }

        @Override
        public BookmarkService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BookmarkServiceImpl.this.getConnection().getUrl() + BookmarkServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlBookmarkWriter.writeOne(this.bookmark, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BookmarkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.bookmark(XmlBookmarkReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BookmarkServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements BookmarkService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<BookmarkService.RemoveRequest, BookmarkService.RemoveResponse>
    implements BookmarkService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public BookmarkService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public BookmarkService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BookmarkServiceImpl.this.getConnection().getUrl() + BookmarkServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BookmarkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            BookmarkServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements BookmarkService.GetResponse {
        private Bookmark bookmark;

        private GetResponseImpl() {
        }

        public void bookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
        }

        @Override
        public Bookmark bookmark() {
            return this.bookmark;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<BookmarkService.GetRequest, BookmarkService.GetResponse>
    implements BookmarkService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public BookmarkService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public BookmarkService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(BookmarkServiceImpl.this.getConnection().getUrl() + BookmarkServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = BookmarkServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.bookmark(XmlBookmarkReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            BookmarkServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

