/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionExtensionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageServerConnectionExtensionServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionExtensionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionExtensionWriter;
import org.ovirt.engine.sdk4.services.StorageServerConnectionExtensionService;
import org.ovirt.engine.sdk4.services.StorageServerConnectionExtensionsService;
import org.ovirt.engine.sdk4.types.StorageConnectionExtension;

public class StorageServerConnectionExtensionsServiceImpl
extends ServiceImpl
implements StorageServerConnectionExtensionsService {
    public StorageServerConnectionExtensionsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageServerConnectionExtensionsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public StorageServerConnectionExtensionsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageServerConnectionExtensionService storageConnectionExtensionService(String id) {
        return new StorageServerConnectionExtensionServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.storageConnectionExtensionService(path);
        }
        return this.storageConnectionExtensionService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "StorageServerConnectionExtensionsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements StorageServerConnectionExtensionsService.ListResponse {
        private List<StorageConnectionExtension> extensions;

        private ListResponseImpl() {
        }

        public void extensions(List<StorageConnectionExtension> extensions) {
            this.extensions = extensions;
        }

        @Override
        public List<StorageConnectionExtension> extensions() {
            return this.extensions;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<StorageServerConnectionExtensionsService.ListRequest, StorageServerConnectionExtensionsService.ListResponse>
    implements StorageServerConnectionExtensionsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public StorageServerConnectionExtensionsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionExtensionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionExtensionsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionExtensionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.extensions(XmlStorageConnectionExtensionReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionExtensionsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements StorageServerConnectionExtensionsService.AddResponse {
        private StorageConnectionExtension extension;

        private AddResponseImpl() {
        }

        public void extension(StorageConnectionExtension extension) {
            this.extension = extension;
        }

        @Override
        public StorageConnectionExtension extension() {
            return this.extension;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<StorageServerConnectionExtensionsService.AddRequest, StorageServerConnectionExtensionsService.AddResponse>
    implements StorageServerConnectionExtensionsService.AddRequest {
        private StorageConnectionExtension extension;

        private AddRequestImpl() {
        }

        @Override
        public StorageServerConnectionExtensionsService.AddRequest extension(StorageConnectionExtension extension) {
            this.extension = extension;
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.AddRequest extension(StorageConnectionExtensionBuilder extension) {
            this.extension = extension.build();
            return this;
        }

        @Override
        public StorageServerConnectionExtensionsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionExtensionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionExtensionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionExtensionWriter.writeOne(this.extension, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionExtensionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.extension(XmlStorageConnectionExtensionReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionExtensionsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

