/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AffinityGroupBuilder;
import org.ovirt.engine.sdk4.builders.ClusterFeatureBuilder;
import org.ovirt.engine.sdk4.builders.CpuBuilder;
import org.ovirt.engine.sdk4.builders.CpuProfileBuilder;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.DisplayBuilder;
import org.ovirt.engine.sdk4.builders.ErrorHandlingBuilder;
import org.ovirt.engine.sdk4.builders.ExternalProviderBuilder;
import org.ovirt.engine.sdk4.builders.FencingPolicyBuilder;
import org.ovirt.engine.sdk4.builders.GlusterHookBuilder;
import org.ovirt.engine.sdk4.builders.GlusterVolumeBuilder;
import org.ovirt.engine.sdk4.builders.KsmBuilder;
import org.ovirt.engine.sdk4.builders.MacPoolBuilder;
import org.ovirt.engine.sdk4.builders.MemoryPolicyBuilder;
import org.ovirt.engine.sdk4.builders.MigrationOptionsBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.NetworkFilterBuilder;
import org.ovirt.engine.sdk4.builders.PermissionBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.builders.SchedulingPolicyBuilder;
import org.ovirt.engine.sdk4.builders.SerialNumberBuilder;
import org.ovirt.engine.sdk4.builders.VersionBuilder;
import org.ovirt.engine.sdk4.internal.containers.ClusterContainer;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.BiosType;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.ClusterFeature;
import org.ovirt.engine.sdk4.types.Cpu;
import org.ovirt.engine.sdk4.types.CpuProfile;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Display;
import org.ovirt.engine.sdk4.types.ErrorHandling;
import org.ovirt.engine.sdk4.types.ExternalProvider;
import org.ovirt.engine.sdk4.types.FencingPolicy;
import org.ovirt.engine.sdk4.types.FirewallType;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.GlusterVolume;
import org.ovirt.engine.sdk4.types.Ksm;
import org.ovirt.engine.sdk4.types.LogMaxMemoryUsedThresholdType;
import org.ovirt.engine.sdk4.types.MacPool;
import org.ovirt.engine.sdk4.types.MemoryPolicy;
import org.ovirt.engine.sdk4.types.MigrationOptions;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkFilter;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Property;
import org.ovirt.engine.sdk4.types.RngSource;
import org.ovirt.engine.sdk4.types.SchedulingPolicy;
import org.ovirt.engine.sdk4.types.SerialNumber;
import org.ovirt.engine.sdk4.types.SwitchType;
import org.ovirt.engine.sdk4.types.Version;

public class ClusterBuilder {
    private List<AffinityGroup> affinityGroups;
    private Boolean ballooningEnabled;
    private BiosType biosType;
    private String comment;
    private Cpu cpu;
    private List<CpuProfile> cpuProfiles;
    private List<Property> customSchedulingPolicyProperties;
    private DataCenter dataCenter;
    private String description;
    private Display display;
    private List<ClusterFeature> enabledFeatures;
    private ErrorHandling errorHandling;
    private List<ExternalProvider> externalNetworkProviders;
    private FencingPolicy fencingPolicy;
    private FirewallType firewallType;
    private List<GlusterHook> glusterHooks;
    private Boolean glusterService;
    private String glusterTunedProfile;
    private List<GlusterVolume> glusterVolumes;
    private Boolean haReservation;
    private String href;
    private String id;
    private Ksm ksm;
    private BigInteger logMaxMemoryUsedThreshold;
    private LogMaxMemoryUsedThresholdType logMaxMemoryUsedThresholdType;
    private MacPool macPool;
    private Boolean maintenanceReasonRequired;
    private Network managementNetwork;
    private MemoryPolicy memoryPolicy;
    private MigrationOptions migration;
    private String name;
    private List<NetworkFilter> networkFilters;
    private List<Network> networks;
    private Boolean optionalReason;
    private List<Permission> permissions;
    private List<RngSource> requiredRngSources;
    private SchedulingPolicy schedulingPolicy;
    private SerialNumber serialNumber;
    private List<Version> supportedVersions;
    private SwitchType switchType;
    private Boolean threadsAsCores;
    private Boolean trustedService;
    private Boolean tunnelMigration;
    private Version version;
    private Boolean virtService;
    private Boolean vncEncryption;

    public ClusterBuilder affinityGroups(List<AffinityGroup> newAffinityGroups) {
        if (newAffinityGroups != null) {
            if (this.affinityGroups == null) {
                this.affinityGroups = new ArrayList<AffinityGroup>(newAffinityGroups);
            } else {
                this.affinityGroups.addAll(newAffinityGroups);
            }
        }
        return this;
    }

    public ClusterBuilder affinityGroups(AffinityGroup ... newAffinityGroups) {
        if (newAffinityGroups != null) {
            if (this.affinityGroups == null) {
                this.affinityGroups = new ArrayList<AffinityGroup>(newAffinityGroups.length);
            }
            Collections.addAll(this.affinityGroups, newAffinityGroups);
        }
        return this;
    }

    public ClusterBuilder affinityGroups(AffinityGroupBuilder ... newAffinityGroups) {
        if (newAffinityGroups != null) {
            if (this.affinityGroups == null) {
                this.affinityGroups = new ArrayList<AffinityGroup>(newAffinityGroups.length);
            }
            for (AffinityGroupBuilder builder : newAffinityGroups) {
                this.affinityGroups.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder ballooningEnabled(boolean newBallooningEnabled) {
        this.ballooningEnabled = newBallooningEnabled;
        return this;
    }

    public ClusterBuilder ballooningEnabled(Boolean newBallooningEnabled) {
        this.ballooningEnabled = newBallooningEnabled;
        return this;
    }

    public ClusterBuilder biosType(BiosType newBiosType) {
        this.biosType = newBiosType;
        return this;
    }

    public ClusterBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ClusterBuilder cpu(Cpu newCpu) {
        this.cpu = newCpu;
        return this;
    }

    public ClusterBuilder cpu(CpuBuilder newCpu) {
        this.cpu = newCpu == null ? null : newCpu.build();
        return this;
    }

    public ClusterBuilder cpuProfiles(List<CpuProfile> newCpuProfiles) {
        if (newCpuProfiles != null) {
            if (this.cpuProfiles == null) {
                this.cpuProfiles = new ArrayList<CpuProfile>(newCpuProfiles);
            } else {
                this.cpuProfiles.addAll(newCpuProfiles);
            }
        }
        return this;
    }

    public ClusterBuilder cpuProfiles(CpuProfile ... newCpuProfiles) {
        if (newCpuProfiles != null) {
            if (this.cpuProfiles == null) {
                this.cpuProfiles = new ArrayList<CpuProfile>(newCpuProfiles.length);
            }
            Collections.addAll(this.cpuProfiles, newCpuProfiles);
        }
        return this;
    }

    public ClusterBuilder cpuProfiles(CpuProfileBuilder ... newCpuProfiles) {
        if (newCpuProfiles != null) {
            if (this.cpuProfiles == null) {
                this.cpuProfiles = new ArrayList<CpuProfile>(newCpuProfiles.length);
            }
            for (CpuProfileBuilder builder : newCpuProfiles) {
                this.cpuProfiles.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder customSchedulingPolicyProperties(List<Property> newCustomSchedulingPolicyProperties) {
        if (newCustomSchedulingPolicyProperties != null) {
            if (this.customSchedulingPolicyProperties == null) {
                this.customSchedulingPolicyProperties = new ArrayList<Property>(newCustomSchedulingPolicyProperties);
            } else {
                this.customSchedulingPolicyProperties.addAll(newCustomSchedulingPolicyProperties);
            }
        }
        return this;
    }

    public ClusterBuilder customSchedulingPolicyProperties(Property ... newCustomSchedulingPolicyProperties) {
        if (newCustomSchedulingPolicyProperties != null) {
            if (this.customSchedulingPolicyProperties == null) {
                this.customSchedulingPolicyProperties = new ArrayList<Property>(newCustomSchedulingPolicyProperties.length);
            }
            Collections.addAll(this.customSchedulingPolicyProperties, newCustomSchedulingPolicyProperties);
        }
        return this;
    }

    public ClusterBuilder customSchedulingPolicyProperties(PropertyBuilder ... newCustomSchedulingPolicyProperties) {
        if (newCustomSchedulingPolicyProperties != null) {
            if (this.customSchedulingPolicyProperties == null) {
                this.customSchedulingPolicyProperties = new ArrayList<Property>(newCustomSchedulingPolicyProperties.length);
            }
            for (PropertyBuilder builder : newCustomSchedulingPolicyProperties) {
                this.customSchedulingPolicyProperties.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public ClusterBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public ClusterBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ClusterBuilder display(Display newDisplay) {
        this.display = newDisplay;
        return this;
    }

    public ClusterBuilder display(DisplayBuilder newDisplay) {
        this.display = newDisplay == null ? null : newDisplay.build();
        return this;
    }

    public ClusterBuilder enabledFeatures(List<ClusterFeature> newEnabledFeatures) {
        if (newEnabledFeatures != null) {
            if (this.enabledFeatures == null) {
                this.enabledFeatures = new ArrayList<ClusterFeature>(newEnabledFeatures);
            } else {
                this.enabledFeatures.addAll(newEnabledFeatures);
            }
        }
        return this;
    }

    public ClusterBuilder enabledFeatures(ClusterFeature ... newEnabledFeatures) {
        if (newEnabledFeatures != null) {
            if (this.enabledFeatures == null) {
                this.enabledFeatures = new ArrayList<ClusterFeature>(newEnabledFeatures.length);
            }
            Collections.addAll(this.enabledFeatures, newEnabledFeatures);
        }
        return this;
    }

    public ClusterBuilder enabledFeatures(ClusterFeatureBuilder ... newEnabledFeatures) {
        if (newEnabledFeatures != null) {
            if (this.enabledFeatures == null) {
                this.enabledFeatures = new ArrayList<ClusterFeature>(newEnabledFeatures.length);
            }
            for (ClusterFeatureBuilder builder : newEnabledFeatures) {
                this.enabledFeatures.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder errorHandling(ErrorHandling newErrorHandling) {
        this.errorHandling = newErrorHandling;
        return this;
    }

    public ClusterBuilder errorHandling(ErrorHandlingBuilder newErrorHandling) {
        this.errorHandling = newErrorHandling == null ? null : newErrorHandling.build();
        return this;
    }

    public ClusterBuilder externalNetworkProviders(List<ExternalProvider> newExternalNetworkProviders) {
        if (newExternalNetworkProviders != null) {
            if (this.externalNetworkProviders == null) {
                this.externalNetworkProviders = new ArrayList<ExternalProvider>(newExternalNetworkProviders);
            } else {
                this.externalNetworkProviders.addAll(newExternalNetworkProviders);
            }
        }
        return this;
    }

    public ClusterBuilder externalNetworkProviders(ExternalProvider ... newExternalNetworkProviders) {
        if (newExternalNetworkProviders != null) {
            if (this.externalNetworkProviders == null) {
                this.externalNetworkProviders = new ArrayList<ExternalProvider>(newExternalNetworkProviders.length);
            }
            Collections.addAll(this.externalNetworkProviders, newExternalNetworkProviders);
        }
        return this;
    }

    public ClusterBuilder externalNetworkProviders(ExternalProviderBuilder ... newExternalNetworkProviders) {
        if (newExternalNetworkProviders != null) {
            if (this.externalNetworkProviders == null) {
                this.externalNetworkProviders = new ArrayList<ExternalProvider>(newExternalNetworkProviders.length);
            }
            for (ExternalProviderBuilder builder : newExternalNetworkProviders) {
                this.externalNetworkProviders.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder fencingPolicy(FencingPolicy newFencingPolicy) {
        this.fencingPolicy = newFencingPolicy;
        return this;
    }

    public ClusterBuilder fencingPolicy(FencingPolicyBuilder newFencingPolicy) {
        this.fencingPolicy = newFencingPolicy == null ? null : newFencingPolicy.build();
        return this;
    }

    public ClusterBuilder firewallType(FirewallType newFirewallType) {
        this.firewallType = newFirewallType;
        return this;
    }

    public ClusterBuilder glusterHooks(List<GlusterHook> newGlusterHooks) {
        if (newGlusterHooks != null) {
            if (this.glusterHooks == null) {
                this.glusterHooks = new ArrayList<GlusterHook>(newGlusterHooks);
            } else {
                this.glusterHooks.addAll(newGlusterHooks);
            }
        }
        return this;
    }

    public ClusterBuilder glusterHooks(GlusterHook ... newGlusterHooks) {
        if (newGlusterHooks != null) {
            if (this.glusterHooks == null) {
                this.glusterHooks = new ArrayList<GlusterHook>(newGlusterHooks.length);
            }
            Collections.addAll(this.glusterHooks, newGlusterHooks);
        }
        return this;
    }

    public ClusterBuilder glusterHooks(GlusterHookBuilder ... newGlusterHooks) {
        if (newGlusterHooks != null) {
            if (this.glusterHooks == null) {
                this.glusterHooks = new ArrayList<GlusterHook>(newGlusterHooks.length);
            }
            for (GlusterHookBuilder builder : newGlusterHooks) {
                this.glusterHooks.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder glusterService(boolean newGlusterService) {
        this.glusterService = newGlusterService;
        return this;
    }

    public ClusterBuilder glusterService(Boolean newGlusterService) {
        this.glusterService = newGlusterService;
        return this;
    }

    public ClusterBuilder glusterTunedProfile(String newGlusterTunedProfile) {
        this.glusterTunedProfile = newGlusterTunedProfile;
        return this;
    }

    public ClusterBuilder glusterVolumes(List<GlusterVolume> newGlusterVolumes) {
        if (newGlusterVolumes != null) {
            if (this.glusterVolumes == null) {
                this.glusterVolumes = new ArrayList<GlusterVolume>(newGlusterVolumes);
            } else {
                this.glusterVolumes.addAll(newGlusterVolumes);
            }
        }
        return this;
    }

    public ClusterBuilder glusterVolumes(GlusterVolume ... newGlusterVolumes) {
        if (newGlusterVolumes != null) {
            if (this.glusterVolumes == null) {
                this.glusterVolumes = new ArrayList<GlusterVolume>(newGlusterVolumes.length);
            }
            Collections.addAll(this.glusterVolumes, newGlusterVolumes);
        }
        return this;
    }

    public ClusterBuilder glusterVolumes(GlusterVolumeBuilder ... newGlusterVolumes) {
        if (newGlusterVolumes != null) {
            if (this.glusterVolumes == null) {
                this.glusterVolumes = new ArrayList<GlusterVolume>(newGlusterVolumes.length);
            }
            for (GlusterVolumeBuilder builder : newGlusterVolumes) {
                this.glusterVolumes.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder haReservation(boolean newHaReservation) {
        this.haReservation = newHaReservation;
        return this;
    }

    public ClusterBuilder haReservation(Boolean newHaReservation) {
        this.haReservation = newHaReservation;
        return this;
    }

    public ClusterBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ClusterBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ClusterBuilder ksm(Ksm newKsm) {
        this.ksm = newKsm;
        return this;
    }

    public ClusterBuilder ksm(KsmBuilder newKsm) {
        this.ksm = newKsm == null ? null : newKsm.build();
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThreshold(int newLogMaxMemoryUsedThreshold) {
        this.logMaxMemoryUsedThreshold = BigInteger.valueOf(newLogMaxMemoryUsedThreshold);
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThreshold(Integer newLogMaxMemoryUsedThreshold) {
        this.logMaxMemoryUsedThreshold = newLogMaxMemoryUsedThreshold == null ? null : BigInteger.valueOf(newLogMaxMemoryUsedThreshold.longValue());
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThreshold(long newLogMaxMemoryUsedThreshold) {
        this.logMaxMemoryUsedThreshold = BigInteger.valueOf(newLogMaxMemoryUsedThreshold);
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThreshold(Long newLogMaxMemoryUsedThreshold) {
        this.logMaxMemoryUsedThreshold = newLogMaxMemoryUsedThreshold == null ? null : BigInteger.valueOf(newLogMaxMemoryUsedThreshold);
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThreshold(BigInteger newLogMaxMemoryUsedThreshold) {
        this.logMaxMemoryUsedThreshold = newLogMaxMemoryUsedThreshold;
        return this;
    }

    public ClusterBuilder logMaxMemoryUsedThresholdType(LogMaxMemoryUsedThresholdType newLogMaxMemoryUsedThresholdType) {
        this.logMaxMemoryUsedThresholdType = newLogMaxMemoryUsedThresholdType;
        return this;
    }

    public ClusterBuilder macPool(MacPool newMacPool) {
        this.macPool = newMacPool;
        return this;
    }

    public ClusterBuilder macPool(MacPoolBuilder newMacPool) {
        this.macPool = newMacPool == null ? null : newMacPool.build();
        return this;
    }

    public ClusterBuilder maintenanceReasonRequired(boolean newMaintenanceReasonRequired) {
        this.maintenanceReasonRequired = newMaintenanceReasonRequired;
        return this;
    }

    public ClusterBuilder maintenanceReasonRequired(Boolean newMaintenanceReasonRequired) {
        this.maintenanceReasonRequired = newMaintenanceReasonRequired;
        return this;
    }

    public ClusterBuilder managementNetwork(Network newManagementNetwork) {
        this.managementNetwork = newManagementNetwork;
        return this;
    }

    public ClusterBuilder managementNetwork(NetworkBuilder newManagementNetwork) {
        this.managementNetwork = newManagementNetwork == null ? null : newManagementNetwork.build();
        return this;
    }

    public ClusterBuilder memoryPolicy(MemoryPolicy newMemoryPolicy) {
        this.memoryPolicy = newMemoryPolicy;
        return this;
    }

    public ClusterBuilder memoryPolicy(MemoryPolicyBuilder newMemoryPolicy) {
        this.memoryPolicy = newMemoryPolicy == null ? null : newMemoryPolicy.build();
        return this;
    }

    public ClusterBuilder migration(MigrationOptions newMigration) {
        this.migration = newMigration;
        return this;
    }

    public ClusterBuilder migration(MigrationOptionsBuilder newMigration) {
        this.migration = newMigration == null ? null : newMigration.build();
        return this;
    }

    public ClusterBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ClusterBuilder networkFilters(List<NetworkFilter> newNetworkFilters) {
        if (newNetworkFilters != null) {
            if (this.networkFilters == null) {
                this.networkFilters = new ArrayList<NetworkFilter>(newNetworkFilters);
            } else {
                this.networkFilters.addAll(newNetworkFilters);
            }
        }
        return this;
    }

    public ClusterBuilder networkFilters(NetworkFilter ... newNetworkFilters) {
        if (newNetworkFilters != null) {
            if (this.networkFilters == null) {
                this.networkFilters = new ArrayList<NetworkFilter>(newNetworkFilters.length);
            }
            Collections.addAll(this.networkFilters, newNetworkFilters);
        }
        return this;
    }

    public ClusterBuilder networkFilters(NetworkFilterBuilder ... newNetworkFilters) {
        if (newNetworkFilters != null) {
            if (this.networkFilters == null) {
                this.networkFilters = new ArrayList<NetworkFilter>(newNetworkFilters.length);
            }
            for (NetworkFilterBuilder builder : newNetworkFilters) {
                this.networkFilters.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder networks(List<Network> newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks);
            } else {
                this.networks.addAll(newNetworks);
            }
        }
        return this;
    }

    public ClusterBuilder networks(Network ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            Collections.addAll(this.networks, newNetworks);
        }
        return this;
    }

    public ClusterBuilder networks(NetworkBuilder ... newNetworks) {
        if (newNetworks != null) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>(newNetworks.length);
            }
            for (NetworkBuilder builder : newNetworks) {
                this.networks.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder optionalReason(boolean newOptionalReason) {
        this.optionalReason = newOptionalReason;
        return this;
    }

    public ClusterBuilder optionalReason(Boolean newOptionalReason) {
        this.optionalReason = newOptionalReason;
        return this;
    }

    public ClusterBuilder permissions(List<Permission> newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions);
            } else {
                this.permissions.addAll(newPermissions);
            }
        }
        return this;
    }

    public ClusterBuilder permissions(Permission ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            Collections.addAll(this.permissions, newPermissions);
        }
        return this;
    }

    public ClusterBuilder permissions(PermissionBuilder ... newPermissions) {
        if (newPermissions != null) {
            if (this.permissions == null) {
                this.permissions = new ArrayList<Permission>(newPermissions.length);
            }
            for (PermissionBuilder builder : newPermissions) {
                this.permissions.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder requiredRngSources(List<RngSource> newRequiredRngSources) {
        if (newRequiredRngSources != null) {
            if (this.requiredRngSources == null) {
                this.requiredRngSources = new ArrayList<RngSource>(newRequiredRngSources);
            } else {
                this.requiredRngSources.addAll(newRequiredRngSources);
            }
        }
        return this;
    }

    public ClusterBuilder requiredRngSources(RngSource ... newRequiredRngSources) {
        if (newRequiredRngSources != null) {
            if (this.requiredRngSources == null) {
                this.requiredRngSources = new ArrayList<RngSource>(newRequiredRngSources.length);
            }
            Collections.addAll(this.requiredRngSources, newRequiredRngSources);
        }
        return this;
    }

    public ClusterBuilder schedulingPolicy(SchedulingPolicy newSchedulingPolicy) {
        this.schedulingPolicy = newSchedulingPolicy;
        return this;
    }

    public ClusterBuilder schedulingPolicy(SchedulingPolicyBuilder newSchedulingPolicy) {
        this.schedulingPolicy = newSchedulingPolicy == null ? null : newSchedulingPolicy.build();
        return this;
    }

    public ClusterBuilder serialNumber(SerialNumber newSerialNumber) {
        this.serialNumber = newSerialNumber;
        return this;
    }

    public ClusterBuilder serialNumber(SerialNumberBuilder newSerialNumber) {
        this.serialNumber = newSerialNumber == null ? null : newSerialNumber.build();
        return this;
    }

    public ClusterBuilder supportedVersions(List<Version> newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions);
            } else {
                this.supportedVersions.addAll(newSupportedVersions);
            }
        }
        return this;
    }

    public ClusterBuilder supportedVersions(Version ... newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions.length);
            }
            Collections.addAll(this.supportedVersions, newSupportedVersions);
        }
        return this;
    }

    public ClusterBuilder supportedVersions(VersionBuilder ... newSupportedVersions) {
        if (newSupportedVersions != null) {
            if (this.supportedVersions == null) {
                this.supportedVersions = new ArrayList<Version>(newSupportedVersions.length);
            }
            for (VersionBuilder builder : newSupportedVersions) {
                this.supportedVersions.add(builder.build());
            }
        }
        return this;
    }

    public ClusterBuilder switchType(SwitchType newSwitchType) {
        this.switchType = newSwitchType;
        return this;
    }

    public ClusterBuilder threadsAsCores(boolean newThreadsAsCores) {
        this.threadsAsCores = newThreadsAsCores;
        return this;
    }

    public ClusterBuilder threadsAsCores(Boolean newThreadsAsCores) {
        this.threadsAsCores = newThreadsAsCores;
        return this;
    }

    public ClusterBuilder trustedService(boolean newTrustedService) {
        this.trustedService = newTrustedService;
        return this;
    }

    public ClusterBuilder trustedService(Boolean newTrustedService) {
        this.trustedService = newTrustedService;
        return this;
    }

    public ClusterBuilder tunnelMigration(boolean newTunnelMigration) {
        this.tunnelMigration = newTunnelMigration;
        return this;
    }

    public ClusterBuilder tunnelMigration(Boolean newTunnelMigration) {
        this.tunnelMigration = newTunnelMigration;
        return this;
    }

    public ClusterBuilder version(Version newVersion) {
        this.version = newVersion;
        return this;
    }

    public ClusterBuilder version(VersionBuilder newVersion) {
        this.version = newVersion == null ? null : newVersion.build();
        return this;
    }

    public ClusterBuilder virtService(boolean newVirtService) {
        this.virtService = newVirtService;
        return this;
    }

    public ClusterBuilder virtService(Boolean newVirtService) {
        this.virtService = newVirtService;
        return this;
    }

    public ClusterBuilder vncEncryption(boolean newVncEncryption) {
        this.vncEncryption = newVncEncryption;
        return this;
    }

    public ClusterBuilder vncEncryption(Boolean newVncEncryption) {
        this.vncEncryption = newVncEncryption;
        return this;
    }

    public Cluster build() {
        ClusterContainer container = new ClusterContainer();
        container.affinityGroups(this.affinityGroups);
        container.ballooningEnabled(this.ballooningEnabled);
        container.biosType(this.biosType);
        container.comment(this.comment);
        container.cpu(this.cpu);
        container.cpuProfiles(this.cpuProfiles);
        container.customSchedulingPolicyProperties(this.customSchedulingPolicyProperties);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.display(this.display);
        container.enabledFeatures(this.enabledFeatures);
        container.errorHandling(this.errorHandling);
        container.externalNetworkProviders(this.externalNetworkProviders);
        container.fencingPolicy(this.fencingPolicy);
        container.firewallType(this.firewallType);
        container.glusterHooks(this.glusterHooks);
        container.glusterService(this.glusterService);
        container.glusterTunedProfile(this.glusterTunedProfile);
        container.glusterVolumes(this.glusterVolumes);
        container.haReservation(this.haReservation);
        container.href(this.href);
        container.id(this.id);
        container.ksm(this.ksm);
        container.logMaxMemoryUsedThreshold(this.logMaxMemoryUsedThreshold);
        container.logMaxMemoryUsedThresholdType(this.logMaxMemoryUsedThresholdType);
        container.macPool(this.macPool);
        container.maintenanceReasonRequired(this.maintenanceReasonRequired);
        container.managementNetwork(this.managementNetwork);
        container.memoryPolicy(this.memoryPolicy);
        container.migration(this.migration);
        container.name(this.name);
        container.networkFilters(this.networkFilters);
        container.networks(this.networks);
        container.optionalReason(this.optionalReason);
        container.permissions(this.permissions);
        container.requiredRngSources(this.requiredRngSources);
        container.schedulingPolicy(this.schedulingPolicy);
        container.serialNumber(this.serialNumber);
        container.supportedVersions(this.supportedVersions);
        container.switchType(this.switchType);
        container.threadsAsCores(this.threadsAsCores);
        container.trustedService(this.trustedService);
        container.tunnelMigration(this.tunnelMigration);
        container.version(this.version);
        container.virtService(this.virtService);
        container.vncEncryption(this.vncEncryption);
        return container;
    }
}

