/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HookContentType {
    BINARY("binary"),
    TEXT("text");

    private static final Logger log;
    private String image;

    private HookContentType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static HookContentType fromValue(String value) {
        try {
            return HookContentType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'HookContentType' enumerated type. Valid values are 'binary' and 'text'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(HookContentType.class);
    }
}

