/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.internal.containers.SkipIfConnectivityBrokenContainer;
import org.ovirt.engine.sdk4.types.SkipIfConnectivityBroken;

public class SkipIfConnectivityBrokenBuilder {
    private Boolean enabled;
    private BigInteger threshold;
    
    public SkipIfConnectivityBrokenBuilder enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
        return this;
    }
    
    public SkipIfConnectivityBrokenBuilder enabled(Boolean newEnabled) {
        enabled = newEnabled;
        return this;
    }
    
    
    public SkipIfConnectivityBrokenBuilder threshold(int newThreshold) {
        threshold = BigInteger.valueOf((long) newThreshold);
        return this;
    }
    
    public SkipIfConnectivityBrokenBuilder threshold(Integer newThreshold) {
        if (newThreshold == null) {
            threshold = null;
        }
        else {
            threshold = BigInteger.valueOf(newThreshold.longValue());
        }
        return this;
    }
    
    public SkipIfConnectivityBrokenBuilder threshold(long newThreshold) {
        threshold = BigInteger.valueOf(newThreshold);
        return this;
    }
    
    public SkipIfConnectivityBrokenBuilder threshold(Long newThreshold) {
        if (newThreshold == null) {
            threshold = null;
        }
        else {
            threshold = BigInteger.valueOf(newThreshold.longValue());
        }
        return this;
    }
    
    public SkipIfConnectivityBrokenBuilder threshold(BigInteger newThreshold) {
        threshold = newThreshold;
        return this;
    }
    
    
    public SkipIfConnectivityBroken build() {
        SkipIfConnectivityBrokenContainer container = new SkipIfConnectivityBrokenContainer();
        container.enabled(enabled);
        container.threshold(threshold);
        return container;
    }
}
