/*	$NetBSD: atomic_inc_64_nv_cas.c,v 1.8 2026/01/07 18:24:35 christos Exp $	*/

/*-
 * Copyright (c) 2007 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "atomic_op_namespace.h"

#include <sys/atomic.h>

#ifdef __HAVE_ATOMIC64_OPS

uint64_t __noinline
atomic_inc_64_nv(volatile uint64_t *addr)
{
	uint64_t old, new;

	do {
		old = *addr;
		new = old + 1;
	} while (atomic_cas_64(addr, old, new) != old);

	return new;
}

atomic_op_alias(atomic_inc_64_nv,_atomic_inc_64_nv)

#if defined(_LP64)
atomic_op_alias(atomic_inc_ulong_nv,_atomic_inc_64_nv)
__strong_alias(_atomic_inc_ulong_nv,_atomic_inc_64_nv)

/*
 * N.B. not an alias!  Pointer values may have a different return
 * convention.
 */
void *
atomic_inc_ptr_nv(volatile void *ptr)
{
	return (void *)atomic_inc_64_nv((volatile uint64_t *)ptr);
}

atomic_op_alias(atomic_inc_ptr_nv,_atomic_inc_ptr_nv)
#endif /* _LP64 */

#endif
