/*	$NetBSD: device_calls.h,v 1.6 2025/10/04 01:13:00 thorpej Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	NetBSD: device_calls,v 1.4 2025/10/04 01:12:15 thorpej Exp
 */

/*-
 * Copyright (c) 2021, 2025 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Device calls used by the device autoconfiguration subsystem
 */

#ifndef _DEVICE_CALLS_H_
#define _DEVICE_CALLS_H_

#include <sys/device.h>

/*
 * device-enumerate-children
 *
 * Enumerates the direct children of a device, invoking the callback for
 * each one.  The callback is passed the devhandle_t corresponding to the
 * child device, as well as a user-supplied argument.  If the callback
 * returns true, then enumeration continues.  If the callback returns false,
 * enumeration is stopped.
 */
struct device_enumerate_children_args {
	bool	(*callback)(device_t, devhandle_t, void *);
	void *	callback_arg;
};

union device_enumerate_children_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct device_enumerate_children_args *args;
	} binding;
};

#define DEVICE_ENUMERATE_CHILDREN_STR "device-enumerate-children"

#define DEVICE_ENUMERATE_CHILDREN(_args_) \
	&((const union device_enumerate_children_binding){ \
		.binding.name = "device-enumerate-children", \
		.binding.args = (_args_), \
	})

/*
 * device-register
 *
 * This is a hook for the platform device tree implementation to
 * inspect or take action upon a new device before the machine-
 * specific device_register() function is called.
 */
struct device_register_args {
	void *	aux;		/* IN */
};

union device_register_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct device_register_args *args;
	} binding;
};

#define DEVICE_REGISTER_STR "device-register"

#define DEVICE_REGISTER(_args_) \
	&((const union device_register_binding){ \
		.binding.name = "device-register", \
		.binding.args = (_args_), \
	})

/*
 * device-is-system-todr
 *
 * This is a filter that is considered when attaching the system TODR / RTC.
 * For systems which may have multiple TODR / RTC devices, the platform
 * device tree may have information about which is authoritative.  This is
 * an optional method, and in its absence, the system will proceed as if
 * the answer was "yes".
 */
struct device_is_system_todr_args {
	bool	result;		/* OUT */
};

union device_is_system_todr_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct device_is_system_todr_args *args;
	} binding;
};

#define DEVICE_IS_SYSTEM_TODR_STR "device-is-system-todr"

#define DEVICE_IS_SYSTEM_TODR(_args_) \
	&((const union device_is_system_todr_binding){ \
		.binding.name = "device-is-system-todr", \
		.binding.args = (_args_), \
	})

/*
 * device-get-property
 *
 * Gets the specified property (and its attributes) and copies it into
 * the caller-provided buffer, in addtion to returning the property's
 * attributes:
 * ==> propsize		The native size of the property in the backing
 *			store.
 * ==> encoding		The native encoding of numbers in the backing store,
 *			_BIG_ENDIAN or _LITTLE_ENDIAN.
 * ==> type		The native type of the property in the backing store.
 *			If the backing store does not have a native typing
 *			system, then it may return PROP_TYPE_UNKNOWN for this
 *			attribute.
 *
 * If the requested property type is PROP_TYPE_UNKNOWN, then the pointer to
 * and size of the caller-provided buffer shall be NULL and 0, respectively.
 * Implementations may assert this.  In this instance, the caller is requesting
 * only the property's attributes.
 *
 * Conversely, if the requested property type is not PROP_TYPE_UNKNOWN,
 * then the pointer to the caller-provided buffer shall not be NULL and
 * the size shall not be 0, and the type will be one of the four listed
 * below.  Implementation may assert this.
 *
 * If the requested property type is PROP_TYPE_DATA or PROP_TYPE_STRING,
 * then the following rules apply:
 * ==> If the caller-provided buffer is insufficiently large to hold the
 *     entire property, the "propsize" output must be set to reflect the
 *     required buffer size and the EFBIG error returned.  In this situation,
 *     it is unspecified whether or not any data is copied into the caller-
 *     provided buffer.
 * ==> If the backing store has a native STRING type, then the implementation
 *     must allow STRING properties to be fetched as DATA objects.
 *
 * If the requested type is PROP_TYPE_STRING, the property value in returned
 * in the caller-provided buffer must be NUL-terminated.
 *
 * If the requested property type is PROP_TYPE_NUMBER, then the following
 * rules apply:
 * ==> The size of the caller-provided buffer shall be sizeof(uint64_t) and
 *     will have alignment suitable for the type.  Implementations may assert
 *     this.
 * ==> The implementation must silently zero-extend whatever value is in the
 *     backing store to a uint64_t and return that value.  The front-end
 *     will perform any type conversions, including range checks, requested
 *     by the caller.
 * ==> The returned "propsize" must reflect an accurate representation of
 *     the size of the property in the backing store; this information is
 *     is used in type conversion.
 * ==> If the backing store's number encoding differs from the native number
 *     encoding, then the backing store shall convert the number to the native
 *     encoding.
 *
 * If the requested property type is PROP_TYPE_BOOL, then the following
 * rules apply:
 * ==> The size of the caller-provided buffer shall be sizeof(bool) and will
 *     have alignment suitable for the type.  Implementations may assert this.
 * ==> If the implementation's backing store does not provide a native boolean
 *     type, then the implementation may use backing-store-specific conventions
 *     to infer bool-ness of the property.  If, in this situation, the property
 *     does not match the backing store's boolean conventions, then the
 *     implementation must return EFTYPE; the system will then use its own
 *     default policy as a fallback.
 *
 * Call returns 0 if successful, or an error code upon failure:
 *
 * ENOENT	The property does not exist.
 *
 * EFBIG	The property is too large to fit in the provided buffer.
 *		The "propsize" output is set to reflect the required
 *		buffer size (for DATA and STRING properties).
 *
 * EFTYPE	The property is a different type than what was requested.
 *
 * EINVAL	The arguments provided to the call are invalid in a way
 *		not covered by one of the above error cases.
 *
 * EIO		An input/output error to the backing store occurred.
 *
 * The "flags" field of the arguments structure is reserved for future
 * expansion.
 *
 * The "dev" argument to the device-get-property call may be NULL.
 */
struct device_get_property_args {
	const char *	prop;		/* IN */
	void *		buf;		/* IN */
	size_t		buflen;		/* IN */
	prop_type_t	reqtype;	/* IN */
	int		flags;		/* IN */
	ssize_t		propsize;	/* OUT */
	int		encoding;	/* OUT */
	prop_type_t	type;		/* OUT */
};

union device_get_property_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct device_get_property_args *args;
	} binding;
};

#define DEVICE_GET_PROPERTY_STR "device-get-property"

#define DEVICE_GET_PROPERTY(_args_) \
	&((const union device_get_property_binding){ \
		.binding.name = "device-get-property", \
		.binding.args = (_args_), \
	})

#endif /* _DEVICE_CALLS_H_ */
