/*	$NetBSD: nbsd-namespace.h,v 1.4 2021/12/19 12:22:03 riastradh Exp $	*/

/*-
 * Copyright (c) 2020 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_NBSD_NAMESPACE_H_
#define _LINUX_NBSD_NAMESPACE_H_

/*
 * WARNING: You MUST NOT include any other header files after you
 * include this one.  DO NOT include this in a header file -- .c files
 * only.
 */

#undef	ALIGN
#undef	LIST_HEAD

#define	ALIGN		round_up
#define	LIST_HEAD	LINUX_LIST_HEAD
#define	mutex_destroy	linux_mutex_destroy
#define	mutex_init	linux_mutex_init

/* Disable our historic malloc(9) compatibility macro.  */
#undef	free

/* This should not appear in NetBSD code -- we do not sprintf!  */
#define	sprintf(BUF, FMT, ARGS...)	snprintf(BUF, SIZE_MAX, FMT, ##ARGS)

#endif  /* _LINUX_NBSD_NAMESPACE_H_ */
