/*	$NetBSD: conf.c,v 1.76 2023/05/08 08:26:11 skrll Exp $	*/

/*-
 * Copyright (c) 1991 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *      @(#)conf.c	7.9 (Berkeley) 5/28/91
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: conf.c,v 1.76 2023/05/08 08:26:11 skrll Exp $");

#include <sys/param.h>
#include <sys/conf.h>

#include <dev/cons.h>

#include "ser.h"
#include "ite.h"
#include "grf.h"
#include "amidisplaycc.h"
#include "mntva.h"
#ifndef __powerpc__
#include "zz9k_fb.h"
#endif
#include "wsdisplay.h"

/*
 * This entire table could be autoconfig()ed but that would mean that
 * the kernel's idea of the console would be out of sync with that of
 * the standalone boot.  I think it best that they both use the same
 * known algorithm unless we see a pressing need otherwise.
 */
cons_decl(ser);
cons_decl(mntva);
cons_decl(zzfb_);
cons_decl(grf);
cons_decl(amidisplaycc_);
cons_decl(ite);

struct	consdev constab[] = {
#if NSER > 0
	cons_init(ser),
#endif
#if NMNTVA > 0
	cons_init(mntva),
#endif
#if NZZ9K_FB > 0
	cons_init(zzfb_),
#endif
#if (NWSDISPLAY > 0) && (NGRF > 0)
	{ dev_init(grf,cnprobe), dev_init(grf,cninit) },
#endif
#if NAMIDISPLAYCC > 0
	cons_init(amidisplaycc_),
#endif
#if NITE > 0
	cons_init(ite),
#endif
	{ 0 }
};
