/*	$NetBSD: bif_5_0_sh_mask.h,v 1.3 2021/12/18 23:45:09 riastradh Exp $	*/

/*
 * BIF_5_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef BIF_5_0_SH_MASK_H
#define BIF_5_0_SH_MASK_H

#define MM_INDEX__MM_OFFSET_MASK 0x7fffffff
#define MM_INDEX__MM_OFFSET__SHIFT 0x0
#define MM_INDEX__MM_APER_MASK 0x80000000
#define MM_INDEX__MM_APER__SHIFT 0x1f
#define MM_INDEX_HI__MM_OFFSET_HI_MASK 0xffffffff
#define MM_INDEX_HI__MM_OFFSET_HI__SHIFT 0x0
#define MM_DATA__MM_DATA_MASK 0xffffffff
#define MM_DATA__MM_DATA__SHIFT 0x0
#define CC_BIF_BX_FUSESTRAP0__STRAP_BIF_PX_CAPABLE_MASK    0x2
#define CC_BIF_BX_FUSESTRAP0__STRAP_BIF_PX_CAPABLE__SHIFT  0x1
#define BIF_MM_INDACCESS_CNTL__MM_INDACCESS_DIS_MASK 0x2
#define BIF_MM_INDACCESS_CNTL__MM_INDACCESS_DIS__SHIFT 0x1
#define BIF_DOORBELL_APER_EN__BIF_DOORBELL_APER_EN_MASK 0x1
#define BIF_DOORBELL_APER_EN__BIF_DOORBELL_APER_EN__SHIFT 0x0
#define BUS_CNTL__BIOS_ROM_WRT_EN_MASK 0x1
#define BUS_CNTL__BIOS_ROM_WRT_EN__SHIFT 0x0
#define BUS_CNTL__BIOS_ROM_DIS_MASK 0x2
#define BUS_CNTL__BIOS_ROM_DIS__SHIFT 0x1
#define BUS_CNTL__PMI_IO_DIS_MASK 0x4
#define BUS_CNTL__PMI_IO_DIS__SHIFT 0x2
#define BUS_CNTL__PMI_MEM_DIS_MASK 0x8
#define BUS_CNTL__PMI_MEM_DIS__SHIFT 0x3
#define BUS_CNTL__PMI_BM_DIS_MASK 0x10
#define BUS_CNTL__PMI_BM_DIS__SHIFT 0x4
#define BUS_CNTL__PMI_INT_DIS_MASK 0x20
#define BUS_CNTL__PMI_INT_DIS__SHIFT 0x5
#define BUS_CNTL__VGA_REG_COHERENCY_DIS_MASK 0x40
#define BUS_CNTL__VGA_REG_COHERENCY_DIS__SHIFT 0x6
#define BUS_CNTL__VGA_MEM_COHERENCY_DIS_MASK 0x80
#define BUS_CNTL__VGA_MEM_COHERENCY_DIS__SHIFT 0x7
#define BUS_CNTL__BIF_ERR_RTR_BKPRESSURE_EN_MASK 0x100
#define BUS_CNTL__BIF_ERR_RTR_BKPRESSURE_EN__SHIFT 0x8
#define BUS_CNTL__SET_AZ_TC_MASK 0x1c00
#define BUS_CNTL__SET_AZ_TC__SHIFT 0xa
#define BUS_CNTL__SET_MC_TC_MASK 0xe000
#define BUS_CNTL__SET_MC_TC__SHIFT 0xd
#define BUS_CNTL__ZERO_BE_WR_EN_MASK 0x10000
#define BUS_CNTL__ZERO_BE_WR_EN__SHIFT 0x10
#define BUS_CNTL__ZERO_BE_RD_EN_MASK 0x20000
#define BUS_CNTL__ZERO_BE_RD_EN__SHIFT 0x11
#define BUS_CNTL__RD_STALL_IO_WR_MASK 0x40000
#define BUS_CNTL__RD_STALL_IO_WR__SHIFT 0x12
#define CONFIG_CNTL__CFG_VGA_RAM_EN_MASK 0x1
#define CONFIG_CNTL__CFG_VGA_RAM_EN__SHIFT 0x0
#define CONFIG_CNTL__VGA_DIS_MASK 0x2
#define CONFIG_CNTL__VGA_DIS__SHIFT 0x1
#define CONFIG_CNTL__GENMO_MONO_ADDRESS_B_MASK 0x4
#define CONFIG_CNTL__GENMO_MONO_ADDRESS_B__SHIFT 0x2
#define CONFIG_CNTL__GRPH_ADRSEL_MASK 0x18
#define CONFIG_CNTL__GRPH_ADRSEL__SHIFT 0x3
#define CONFIG_MEMSIZE__CONFIG_MEMSIZE_MASK 0xffffffff
#define CONFIG_MEMSIZE__CONFIG_MEMSIZE__SHIFT 0x0
#define CONFIG_RESERVED__CONFIG_RESERVED_MASK 0xffffffff
#define CONFIG_RESERVED__CONFIG_RESERVED__SHIFT 0x0
#define BIF_IOV_FUNC_IDENTIFIER__FUNC_IDENTIFIER_MASK 0x1
#define BIF_IOV_FUNC_IDENTIFIER__FUNC_IDENTIFIER__SHIFT 0x0
#define BIF_IOV_FUNC_IDENTIFIER__IOV_ENABLE_MASK 0x80000000
#define BIF_IOV_FUNC_IDENTIFIER__IOV_ENABLE__SHIFT 0x1f
#define CONFIG_F0_BASE__F0_BASE_MASK 0xffffffff
#define CONFIG_F0_BASE__F0_BASE__SHIFT 0x0
#define CONFIG_APER_SIZE__APER_SIZE_MASK 0xffffffff
#define CONFIG_APER_SIZE__APER_SIZE__SHIFT 0x0
#define CONFIG_REG_APER_SIZE__REG_APER_SIZE_MASK 0xfffff
#define CONFIG_REG_APER_SIZE__REG_APER_SIZE__SHIFT 0x0
#define BIF_SCRATCH0__BIF_SCRATCH0_MASK 0xffffffff
#define BIF_SCRATCH0__BIF_SCRATCH0__SHIFT 0x0
#define BIF_SCRATCH1__BIF_SCRATCH1_MASK 0xffffffff
#define BIF_SCRATCH1__BIF_SCRATCH1__SHIFT 0x0
#define BIF_RLC_INTR_CNTL__RLC_HVCMD_INTERRUPT_MASK 0x1
#define BIF_RLC_INTR_CNTL__RLC_HVCMD_INTERRUPT__SHIFT 0x0
#define BIF_RLC_INTR_CNTL__RLC_VM_IDLE_INTERRUPT_MASK 0x100
#define BIF_RLC_INTR_CNTL__RLC_VM_IDLE_INTERRUPT__SHIFT 0x8
#define BIF_BME_STATUS__DMA_ON_BME_LOW_MASK 0x1
#define BIF_BME_STATUS__DMA_ON_BME_LOW__SHIFT 0x0
#define BIF_BME_STATUS__CLEAR_DMA_ON_BME_LOW_MASK 0x10000
#define BIF_BME_STATUS__CLEAR_DMA_ON_BME_LOW__SHIFT 0x10
#define BIF_ATOMIC_ERR_LOG__UR_ATOMIC_OPCODE_MASK 0x1
#define BIF_ATOMIC_ERR_LOG__UR_ATOMIC_OPCODE__SHIFT 0x0
#define BIF_ATOMIC_ERR_LOG__UR_ATOMIC_REQEN_LOW_MASK 0x2
#define BIF_ATOMIC_ERR_LOG__UR_ATOMIC_REQEN_LOW__SHIFT 0x1
#define BIF_ATOMIC_ERR_LOG__CLEAR_UR_ATOMIC_OPCODE_MASK 0x10000
#define BIF_ATOMIC_ERR_LOG__CLEAR_UR_ATOMIC_OPCODE__SHIFT 0x10
#define BIF_ATOMIC_ERR_LOG__CLEAR_UR_ATOMIC_REQEN_LOW_MASK 0x20000
#define BIF_ATOMIC_ERR_LOG__CLEAR_UR_ATOMIC_REQEN_LOW__SHIFT 0x11
#define BX_RESET_EN__COR_RESET_EN_MASK 0x1
#define BX_RESET_EN__COR_RESET_EN__SHIFT 0x0
#define BX_RESET_EN__REG_RESET_EN_MASK 0x2
#define BX_RESET_EN__REG_RESET_EN__SHIFT 0x1
#define BX_RESET_EN__STY_RESET_EN_MASK 0x4
#define BX_RESET_EN__STY_RESET_EN__SHIFT 0x2
#define BX_RESET_EN__FLR_TWICE_EN_MASK 0x100
#define BX_RESET_EN__FLR_TWICE_EN__SHIFT 0x8
#define BX_RESET_EN__FLR_TIMER_SEL_MASK 0x600
#define BX_RESET_EN__FLR_TIMER_SEL__SHIFT 0x9
#define BX_RESET_EN__DB_APER_RESET_EN_MASK 0x8000
#define BX_RESET_EN__DB_APER_RESET_EN__SHIFT 0xf
#define BX_RESET_EN__RESET_ON_VFENABLE_LOW_EN_MASK 0x10000
#define BX_RESET_EN__RESET_ON_VFENABLE_LOW_EN__SHIFT 0x10
#define BX_RESET_EN__PF_FLR_NEWHDL_EN_MASK 0x20000
#define BX_RESET_EN__PF_FLR_NEWHDL_EN__SHIFT 0x11
#define MM_CFGREGS_CNTL__MM_CFG_FUNC_SEL_MASK 0x7
#define MM_CFGREGS_CNTL__MM_CFG_FUNC_SEL__SHIFT 0x0
#define MM_CFGREGS_CNTL__MM_WR_TO_CFG_EN_MASK 0x8
#define MM_CFGREGS_CNTL__MM_WR_TO_CFG_EN__SHIFT 0x3
#define HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define HW_DEBUG__HW_16_DEBUG_MASK 0x10000
#define HW_DEBUG__HW_16_DEBUG__SHIFT 0x10
#define HW_DEBUG__HW_17_DEBUG_MASK 0x20000
#define HW_DEBUG__HW_17_DEBUG__SHIFT 0x11
#define HW_DEBUG__HW_18_DEBUG_MASK 0x40000
#define HW_DEBUG__HW_18_DEBUG__SHIFT 0x12
#define HW_DEBUG__HW_19_DEBUG_MASK 0x80000
#define HW_DEBUG__HW_19_DEBUG__SHIFT 0x13
#define HW_DEBUG__HW_20_DEBUG_MASK 0x100000
#define HW_DEBUG__HW_20_DEBUG__SHIFT 0x14
#define HW_DEBUG__HW_21_DEBUG_MASK 0x200000
#define HW_DEBUG__HW_21_DEBUG__SHIFT 0x15
#define HW_DEBUG__HW_22_DEBUG_MASK 0x400000
#define HW_DEBUG__HW_22_DEBUG__SHIFT 0x16
#define HW_DEBUG__HW_23_DEBUG_MASK 0x800000
#define HW_DEBUG__HW_23_DEBUG__SHIFT 0x17
#define HW_DEBUG__HW_24_DEBUG_MASK 0x1000000
#define HW_DEBUG__HW_24_DEBUG__SHIFT 0x18
#define HW_DEBUG__HW_25_DEBUG_MASK 0x2000000
#define HW_DEBUG__HW_25_DEBUG__SHIFT 0x19
#define HW_DEBUG__HW_26_DEBUG_MASK 0x4000000
#define HW_DEBUG__HW_26_DEBUG__SHIFT 0x1a
#define HW_DEBUG__HW_27_DEBUG_MASK 0x8000000
#define HW_DEBUG__HW_27_DEBUG__SHIFT 0x1b
#define HW_DEBUG__HW_28_DEBUG_MASK 0x10000000
#define HW_DEBUG__HW_28_DEBUG__SHIFT 0x1c
#define HW_DEBUG__HW_29_DEBUG_MASK 0x20000000
#define HW_DEBUG__HW_29_DEBUG__SHIFT 0x1d
#define HW_DEBUG__HW_30_DEBUG_MASK 0x40000000
#define HW_DEBUG__HW_30_DEBUG__SHIFT 0x1e
#define HW_DEBUG__HW_31_DEBUG_MASK 0x80000000
#define HW_DEBUG__HW_31_DEBUG__SHIFT 0x1f
#define MASTER_CREDIT_CNTL__BIF_MC_RDRET_CREDIT_MASK 0x7f
#define MASTER_CREDIT_CNTL__BIF_MC_RDRET_CREDIT__SHIFT 0x0
#define MASTER_CREDIT_CNTL__BIF_AZ_RDRET_CREDIT_MASK 0x3f0000
#define MASTER_CREDIT_CNTL__BIF_AZ_RDRET_CREDIT__SHIFT 0x10
#define SLAVE_REQ_CREDIT_CNTL__BIF_SRBM_REQ_CREDIT_MASK 0x1f
#define SLAVE_REQ_CREDIT_CNTL__BIF_SRBM_REQ_CREDIT__SHIFT 0x0
#define SLAVE_REQ_CREDIT_CNTL__BIF_VGA_REQ_CREDIT_MASK 0x1e0
#define SLAVE_REQ_CREDIT_CNTL__BIF_VGA_REQ_CREDIT__SHIFT 0x5
#define SLAVE_REQ_CREDIT_CNTL__BIF_HDP_REQ_CREDIT_MASK 0x7c00
#define SLAVE_REQ_CREDIT_CNTL__BIF_HDP_REQ_CREDIT__SHIFT 0xa
#define SLAVE_REQ_CREDIT_CNTL__BIF_ROM_REQ_CREDIT_MASK 0x8000
#define SLAVE_REQ_CREDIT_CNTL__BIF_ROM_REQ_CREDIT__SHIFT 0xf
#define SLAVE_REQ_CREDIT_CNTL__BIF_AZ_REQ_CREDIT_MASK 0x100000
#define SLAVE_REQ_CREDIT_CNTL__BIF_AZ_REQ_CREDIT__SHIFT 0x14
#define SLAVE_REQ_CREDIT_CNTL__BIF_XDMA_REQ_CREDIT_MASK 0x7e000000
#define SLAVE_REQ_CREDIT_CNTL__BIF_XDMA_REQ_CREDIT__SHIFT 0x19
#define BX_RESET_CNTL__LINK_TRAIN_EN_MASK 0x1
#define BX_RESET_CNTL__LINK_TRAIN_EN__SHIFT 0x0
#define INTERRUPT_CNTL__IH_DUMMY_RD_OVERRIDE_MASK 0x1
#define INTERRUPT_CNTL__IH_DUMMY_RD_OVERRIDE__SHIFT 0x0
#define INTERRUPT_CNTL__IH_DUMMY_RD_EN_MASK 0x2
#define INTERRUPT_CNTL__IH_DUMMY_RD_EN__SHIFT 0x1
#define INTERRUPT_CNTL__IH_REQ_NONSNOOP_EN_MASK 0x8
#define INTERRUPT_CNTL__IH_REQ_NONSNOOP_EN__SHIFT 0x3
#define INTERRUPT_CNTL__IH_INTR_DLY_CNTR_MASK 0xf0
#define INTERRUPT_CNTL__IH_INTR_DLY_CNTR__SHIFT 0x4
#define INTERRUPT_CNTL__GEN_IH_INT_EN_MASK 0x100
#define INTERRUPT_CNTL__GEN_IH_INT_EN__SHIFT 0x8
#define INTERRUPT_CNTL__GEN_GPIO_INT_EN_MASK 0x1e00
#define INTERRUPT_CNTL__GEN_GPIO_INT_EN__SHIFT 0x9
#define INTERRUPT_CNTL__SELECT_INT_GPIO_OUTPUT_MASK 0x6000
#define INTERRUPT_CNTL__SELECT_INT_GPIO_OUTPUT__SHIFT 0xd
#define INTERRUPT_CNTL__BIF_RB_REQ_NONSNOOP_EN_MASK 0x8000
#define INTERRUPT_CNTL__BIF_RB_REQ_NONSNOOP_EN__SHIFT 0xf
#define INTERRUPT_CNTL2__IH_DUMMY_RD_ADDR_MASK 0xffffffff
#define INTERRUPT_CNTL2__IH_DUMMY_RD_ADDR__SHIFT 0x0
#define BIF_DEBUG_CNTL__DEBUG_EN_MASK 0x1
#define BIF_DEBUG_CNTL__DEBUG_EN__SHIFT 0x0
#define BIF_DEBUG_CNTL__DEBUG_MULTIBLOCKEN_MASK 0x2
#define BIF_DEBUG_CNTL__DEBUG_MULTIBLOCKEN__SHIFT 0x1
#define BIF_DEBUG_CNTL__DEBUG_OUT_EN_MASK 0x4
#define BIF_DEBUG_CNTL__DEBUG_OUT_EN__SHIFT 0x2
#define BIF_DEBUG_CNTL__DEBUG_PAD_SEL_MASK 0x8
#define BIF_DEBUG_CNTL__DEBUG_PAD_SEL__SHIFT 0x3
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK1_MASK 0x10
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK1__SHIFT 0x4
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK2_MASK 0x20
#define BIF_DEBUG_CNTL__DEBUG_BYTESEL_BLK2__SHIFT 0x5
#define BIF_DEBUG_CNTL__DEBUG_SYNC_EN_MASK 0x40
#define BIF_DEBUG_CNTL__DEBUG_SYNC_EN__SHIFT 0x6
#define BIF_DEBUG_CNTL__DEBUG_SWAP_MASK 0x80
#define BIF_DEBUG_CNTL__DEBUG_SWAP__SHIFT 0x7
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK1_MASK 0x1f00
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK1__SHIFT 0x8
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK2_MASK 0x1f0000
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_BLK2__SHIFT 0x10
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_XSP_MASK 0x1000000
#define BIF_DEBUG_CNTL__DEBUG_IDSEL_XSP__SHIFT 0x18
#define BIF_DEBUG_CNTL__DEBUG_SYNC_CLKSEL_MASK 0xc0000000
#define BIF_DEBUG_CNTL__DEBUG_SYNC_CLKSEL__SHIFT 0x1e
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK1_MASK 0x3f
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK1__SHIFT 0x0
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK2_MASK 0x3f00
#define BIF_DEBUG_MUX__DEBUG_MUX_BLK2__SHIFT 0x8
#define BIF_DEBUG_OUT__DEBUG_OUTPUT_MASK 0x1ffff
#define BIF_DEBUG_OUT__DEBUG_OUTPUT__SHIFT 0x0
#define HDP_REG_COHERENCY_FLUSH_CNTL__HDP_REG_FLUSH_ADDR_MASK 0x1
#define HDP_REG_COHERENCY_FLUSH_CNTL__HDP_REG_FLUSH_ADDR__SHIFT 0x0
#define HDP_MEM_COHERENCY_FLUSH_CNTL__HDP_MEM_FLUSH_ADDR_MASK 0x1
#define HDP_MEM_COHERENCY_FLUSH_CNTL__HDP_MEM_FLUSH_ADDR__SHIFT 0x0
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_A_MASK 0x1
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_A__SHIFT 0x0
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SEL_MASK 0x2
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SEL__SHIFT 0x1
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_MODE_MASK 0x4
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_MODE__SHIFT 0x2
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SPARE_MASK 0x18
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SPARE__SHIFT 0x3
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN0_MASK 0x20
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN0__SHIFT 0x5
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN1_MASK 0x40
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN1__SHIFT 0x6
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN2_MASK 0x80
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN2__SHIFT 0x7
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN3_MASK 0x100
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SN3__SHIFT 0x8
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SLEWN_MASK 0x200
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SLEWN__SHIFT 0x9
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_WAKE_MASK 0x400
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_WAKE__SHIFT 0xa
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SCHMEN_MASK 0x800
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_SCHMEN__SHIFT 0xb
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_CNTL_EN_MASK 0x1000
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_CNTL_EN__SHIFT 0xc
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_Y_MASK 0x2000
#define CLKREQB_PAD_CNTL__CLKREQB_PAD_Y__SHIFT 0xd
#define CLKREQB_PAD_CNTL__CLKREQB_PERF_COUNTER_UPPER_MASK 0xff000000
#define CLKREQB_PAD_CNTL__CLKREQB_PERF_COUNTER_UPPER__SHIFT 0x18
#define CLKREQB_PERF_COUNTER__CLKREQB_PERF_COUNTER_LOWER_MASK 0xffffffff
#define CLKREQB_PERF_COUNTER__CLKREQB_PERF_COUNTER_LOWER__SHIFT 0x0
#define BIF_XDMA_LO__BIF_XDMA_LOWER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_LO__BIF_XDMA_LOWER_BOUND__SHIFT 0x0
#define BIF_XDMA_LO__BIF_XDMA_APER_EN_MASK 0x80000000
#define BIF_XDMA_LO__BIF_XDMA_APER_EN__SHIFT 0x1f
#define BIF_XDMA_HI__BIF_XDMA_UPPER_BOUND_MASK 0x1fffffff
#define BIF_XDMA_HI__BIF_XDMA_UPPER_BOUND__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC__MST_BIF_REQ_EP_DIS_MASK 0x1
#define BIF_FEATURES_CONTROL_MISC__MST_BIF_REQ_EP_DIS__SHIFT 0x0
#define BIF_FEATURES_CONTROL_MISC__SLV_BIF_CPL_EP_DIS_MASK 0x2
#define BIF_FEATURES_CONTROL_MISC__SLV_BIF_CPL_EP_DIS__SHIFT 0x1
#define BIF_FEATURES_CONTROL_MISC__BIF_SLV_REQ_EP_DIS_MASK 0x4
#define BIF_FEATURES_CONTROL_MISC__BIF_SLV_REQ_EP_DIS__SHIFT 0x2
#define BIF_FEATURES_CONTROL_MISC__BIF_MST_CPL_EP_DIS_MASK 0x8
#define BIF_FEATURES_CONTROL_MISC__BIF_MST_CPL_EP_DIS__SHIFT 0x3
#define BIF_FEATURES_CONTROL_MISC__UR_PSN_PKT_REPORT_POISON_DIS_MASK 0x10
#define BIF_FEATURES_CONTROL_MISC__UR_PSN_PKT_REPORT_POISON_DIS__SHIFT 0x4
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS_MASK 0x20
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_ALL_DIS__SHIFT 0x5
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS_MASK 0x40
#define BIF_FEATURES_CONTROL_MISC__POST_PSN_ONLY_PKT_REPORT_UR_PART_DIS__SHIFT 0x6
#define BIF_FEATURES_CONTROL_MISC__PLL_SWITCH_IMPCTL_CAL_DONE_DIS_MASK 0x80
#define BIF_FEATURES_CONTROL_MISC__PLL_SWITCH_IMPCTL_CAL_DONE_DIS__SHIFT 0x7
#define BIF_FEATURES_CONTROL_MISC__IGNORE_BE_CHECK_GASKET_COMB_DIS_MASK 0x100
#define BIF_FEATURES_CONTROL_MISC__IGNORE_BE_CHECK_GASKET_COMB_DIS__SHIFT 0x8
#define BIF_FEATURES_CONTROL_MISC__MC_BIF_REQ_ID_ROUTING_DIS_MASK 0x200
#define BIF_FEATURES_CONTROL_MISC__MC_BIF_REQ_ID_ROUTING_DIS__SHIFT 0x9
#define BIF_FEATURES_CONTROL_MISC__AZ_BIF_REQ_ID_ROUTING_DIS_MASK 0x400
#define BIF_FEATURES_CONTROL_MISC__AZ_BIF_REQ_ID_ROUTING_DIS__SHIFT 0xa
#define BIF_FEATURES_CONTROL_MISC__ATC_PRG_RESP_PASID_UR_EN_MASK 0x800
#define BIF_FEATURES_CONTROL_MISC__ATC_PRG_RESP_PASID_UR_EN__SHIFT 0xb
#define BIF_FEATURES_CONTROL_MISC__BIF_RB_SET_OVERFLOW_EN_MASK 0x1000
#define BIF_FEATURES_CONTROL_MISC__BIF_RB_SET_OVERFLOW_EN__SHIFT 0xc
#define BIF_FEATURES_CONTROL_MISC__ATOMIC_ERR_INT_DIS_MASK 0x2000
#define BIF_FEATURES_CONTROL_MISC__ATOMIC_ERR_INT_DIS__SHIFT 0xd
#define BIF_FEATURES_CONTROL_MISC__BME_HDL_NONVIR_EN_MASK 0x8000
#define BIF_FEATURES_CONTROL_MISC__BME_HDL_NONVIR_EN__SHIFT 0xf
#define BIF_FEATURES_CONTROL_MISC__INIT_PFFLR_CRS_RET_DIS_MASK 0x10000
#define BIF_FEATURES_CONTROL_MISC__INIT_PFFLR_CRS_RET_DIS__SHIFT 0x10
#define BIF_FEATURES_CONTROL_MISC__FLR_MST_PEND_CHK_DIS_MASK 0x20000
#define BIF_FEATURES_CONTROL_MISC__FLR_MST_PEND_CHK_DIS__SHIFT 0x11
#define BIF_FEATURES_CONTROL_MISC__FLR_SLV_PEND_CHK_DIS_MASK 0x40000
#define BIF_FEATURES_CONTROL_MISC__FLR_SLV_PEND_CHK_DIS__SHIFT 0x12
#define BIF_FEATURES_CONTROL_MISC__SOFT_PF_FLR_UR_CFG_EN_MASK 0x80000
#define BIF_FEATURES_CONTROL_MISC__SOFT_PF_FLR_UR_CFG_EN__SHIFT 0x13
#define BIF_FEATURES_CONTROL_MISC__FLR_OSTD_UR_DIS_MASK 0x100000
#define BIF_FEATURES_CONTROL_MISC__FLR_OSTD_UR_DIS__SHIFT 0x14
#define BIF_FEATURES_CONTROL_MISC__FLR_OSTD_HDL_DIS_MASK 0x200000
#define BIF_FEATURES_CONTROL_MISC__FLR_OSTD_HDL_DIS__SHIFT 0x15
#define BIF_FEATURES_CONTROL_MISC__FLR_NEWREQ_HDL_DIS_MASK 0x400000
#define BIF_FEATURES_CONTROL_MISC__FLR_NEWREQ_HDL_DIS__SHIFT 0x16
#define BIF_FEATURES_CONTROL_MISC__FLR_CRS_CFG_DIS_MASK 0x800000
#define BIF_FEATURES_CONTROL_MISC__FLR_CRS_CFG_DIS__SHIFT 0x17
#define BIF_FEATURES_CONTROL_MISC__DUMMY_TRANS_CPL_RET_DIS_MASK 0x1000000
#define BIF_FEATURES_CONTROL_MISC__DUMMY_TRANS_CPL_RET_DIS__SHIFT 0x18
#define BIF_DOORBELL_CNTL__SELF_RING_DIS_MASK 0x1
#define BIF_DOORBELL_CNTL__SELF_RING_DIS__SHIFT 0x0
#define BIF_DOORBELL_CNTL__TRANS_CHECK_DIS_MASK 0x2
#define BIF_DOORBELL_CNTL__TRANS_CHECK_DIS__SHIFT 0x1
#define BIF_DOORBELL_CNTL__UNTRANS_LBACK_EN_MASK 0x4
#define BIF_DOORBELL_CNTL__UNTRANS_LBACK_EN__SHIFT 0x2
#define BIF_DOORBELL_CNTL__NON_CONSECUTIVE_BE_ZERO_DIS_MASK 0x8
#define BIF_DOORBELL_CNTL__NON_CONSECUTIVE_BE_ZERO_DIS__SHIFT 0x3
#define BIF_DOORBELL_CNTL__DOORBELL_MONITOR_EN_MASK 0x10
#define BIF_DOORBELL_CNTL__DOORBELL_MONITOR_EN__SHIFT 0x4
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_STATUS_MASK 0x20
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_STATUS__SHIFT 0x5
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_CLEAR_MASK 0x10000
#define BIF_DOORBELL_CNTL__DOORBELL_INTERRUPT_CLEAR__SHIFT 0x10
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_DIS_MASK 0x1000000
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_DIS__SHIFT 0x18
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_0_MASK 0x2000000
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_0__SHIFT 0x19
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_1_MASK 0x4000000
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_1__SHIFT 0x1a
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_2_MASK 0x8000000
#define BIF_DOORBELL_CNTL__DB_MNTR_INTGEN_MODE_2__SHIFT 0x1b
#define BIF_SLVARB_MODE__SLVARB_MODE_MASK 0x3
#define BIF_SLVARB_MODE__SLVARB_MODE__SHIFT 0x0
#define BIF_CLK_CTRL__BIF_XSTCLK_READY_MASK 0x1
#define BIF_CLK_CTRL__BIF_XSTCLK_READY__SHIFT 0x0
#define BIF_CLK_CTRL__BACO_XSTCLK_SWITCH_BYPASS_MASK 0x2
#define BIF_CLK_CTRL__BACO_XSTCLK_SWITCH_BYPASS__SHIFT 0x1
#define BIF_FB_EN__FB_READ_EN_MASK 0x1
#define BIF_FB_EN__FB_READ_EN__SHIFT 0x0
#define BIF_FB_EN__FB_WRITE_EN_MASK 0x2
#define BIF_FB_EN__FB_WRITE_EN__SHIFT 0x1
#define BIF_BUSNUM_CNTL1__ID_MASK_MASK 0xff
#define BIF_BUSNUM_CNTL1__ID_MASK__SHIFT 0x0
#define BIF_BUSNUM_LIST0__ID0_MASK 0xff
#define BIF_BUSNUM_LIST0__ID0__SHIFT 0x0
#define BIF_BUSNUM_LIST0__ID1_MASK 0xff00
#define BIF_BUSNUM_LIST0__ID1__SHIFT 0x8
#define BIF_BUSNUM_LIST0__ID2_MASK 0xff0000
#define BIF_BUSNUM_LIST0__ID2__SHIFT 0x10
#define BIF_BUSNUM_LIST0__ID3_MASK 0xff000000
#define BIF_BUSNUM_LIST0__ID3__SHIFT 0x18
#define BIF_BUSNUM_LIST1__ID4_MASK 0xff
#define BIF_BUSNUM_LIST1__ID4__SHIFT 0x0
#define BIF_BUSNUM_LIST1__ID5_MASK 0xff00
#define BIF_BUSNUM_LIST1__ID5__SHIFT 0x8
#define BIF_BUSNUM_LIST1__ID6_MASK 0xff0000
#define BIF_BUSNUM_LIST1__ID6__SHIFT 0x10
#define BIF_BUSNUM_LIST1__ID7_MASK 0xff000000
#define BIF_BUSNUM_LIST1__ID7__SHIFT 0x18
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_SEL_MASK 0xff
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_SEL__SHIFT 0x0
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_EN_MASK 0x100
#define BIF_BUSNUM_CNTL2__AUTOUPDATE_EN__SHIFT 0x8
#define BIF_BUSNUM_CNTL2__HDPREG_CNTL_MASK 0x10000
#define BIF_BUSNUM_CNTL2__HDPREG_CNTL__SHIFT 0x10
#define BIF_BUSNUM_CNTL2__ERROR_MULTIPLE_ID_MATCH_MASK 0x20000
#define BIF_BUSNUM_CNTL2__ERROR_MULTIPLE_ID_MATCH__SHIFT 0x11
#define BIF_BUSY_DELAY_CNTR__DELAY_CNT_MASK 0x3f
#define BIF_BUSY_DELAY_CNTR__DELAY_CNT__SHIFT 0x0
#define BIF_PERFMON_CNTL__PERFCOUNTER_EN_MASK 0x1
#define BIF_PERFMON_CNTL__PERFCOUNTER_EN__SHIFT 0x0
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET0_MASK 0x2
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET0__SHIFT 0x1
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET1_MASK 0x4
#define BIF_PERFMON_CNTL__PERFCOUNTER_RESET1__SHIFT 0x2
#define BIF_PERFMON_CNTL__PERF_SEL0_MASK 0x1f00
#define BIF_PERFMON_CNTL__PERF_SEL0__SHIFT 0x8
#define BIF_PERFMON_CNTL__PERF_SEL1_MASK 0x3e000
#define BIF_PERFMON_CNTL__PERF_SEL1__SHIFT 0xd
#define BIF_PERFCOUNTER0_RESULT__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER0_RESULT__PERFCOUNTER_RESULT__SHIFT 0x0
#define BIF_PERFCOUNTER1_RESULT__PERFCOUNTER_RESULT_MASK 0xffffffff
#define BIF_PERFCOUNTER1_RESULT__PERFCOUNTER_RESULT__SHIFT 0x0
#define SLAVE_HANG_PROTECTION_CNTL__HANG_PROTECTION_TIMER_SEL_MASK 0xe
#define SLAVE_HANG_PROTECTION_CNTL__HANG_PROTECTION_TIMER_SEL__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ__CP0_MASK 0x1
#define GPU_HDP_FLUSH_REQ__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_REQ__CP1_MASK 0x2
#define GPU_HDP_FLUSH_REQ__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_REQ__CP2_MASK 0x4
#define GPU_HDP_FLUSH_REQ__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_REQ__CP3_MASK 0x8
#define GPU_HDP_FLUSH_REQ__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_REQ__CP4_MASK 0x10
#define GPU_HDP_FLUSH_REQ__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_REQ__CP5_MASK 0x20
#define GPU_HDP_FLUSH_REQ__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_REQ__CP6_MASK 0x40
#define GPU_HDP_FLUSH_REQ__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_REQ__CP7_MASK 0x80
#define GPU_HDP_FLUSH_REQ__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_REQ__CP8_MASK 0x100
#define GPU_HDP_FLUSH_REQ__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_REQ__CP9_MASK 0x200
#define GPU_HDP_FLUSH_REQ__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_REQ__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_REQ__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_REQ__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_REQ__SDMA1__SHIFT 0xb
#define GPU_HDP_FLUSH_DONE__CP0_MASK 0x1
#define GPU_HDP_FLUSH_DONE__CP0__SHIFT 0x0
#define GPU_HDP_FLUSH_DONE__CP1_MASK 0x2
#define GPU_HDP_FLUSH_DONE__CP1__SHIFT 0x1
#define GPU_HDP_FLUSH_DONE__CP2_MASK 0x4
#define GPU_HDP_FLUSH_DONE__CP2__SHIFT 0x2
#define GPU_HDP_FLUSH_DONE__CP3_MASK 0x8
#define GPU_HDP_FLUSH_DONE__CP3__SHIFT 0x3
#define GPU_HDP_FLUSH_DONE__CP4_MASK 0x10
#define GPU_HDP_FLUSH_DONE__CP4__SHIFT 0x4
#define GPU_HDP_FLUSH_DONE__CP5_MASK 0x20
#define GPU_HDP_FLUSH_DONE__CP5__SHIFT 0x5
#define GPU_HDP_FLUSH_DONE__CP6_MASK 0x40
#define GPU_HDP_FLUSH_DONE__CP6__SHIFT 0x6
#define GPU_HDP_FLUSH_DONE__CP7_MASK 0x80
#define GPU_HDP_FLUSH_DONE__CP7__SHIFT 0x7
#define GPU_HDP_FLUSH_DONE__CP8_MASK 0x100
#define GPU_HDP_FLUSH_DONE__CP8__SHIFT 0x8
#define GPU_HDP_FLUSH_DONE__CP9_MASK 0x200
#define GPU_HDP_FLUSH_DONE__CP9__SHIFT 0x9
#define GPU_HDP_FLUSH_DONE__SDMA0_MASK 0x400
#define GPU_HDP_FLUSH_DONE__SDMA0__SHIFT 0xa
#define GPU_HDP_FLUSH_DONE__SDMA1_MASK 0x800
#define GPU_HDP_FLUSH_DONE__SDMA1__SHIFT 0xb
#define SLAVE_HANG_ERROR__SRBM_HANG_ERROR_MASK 0x1
#define SLAVE_HANG_ERROR__SRBM_HANG_ERROR__SHIFT 0x0
#define SLAVE_HANG_ERROR__HDP_HANG_ERROR_MASK 0x2
#define SLAVE_HANG_ERROR__HDP_HANG_ERROR__SHIFT 0x1
#define SLAVE_HANG_ERROR__VGA_HANG_ERROR_MASK 0x4
#define SLAVE_HANG_ERROR__VGA_HANG_ERROR__SHIFT 0x2
#define SLAVE_HANG_ERROR__ROM_HANG_ERROR_MASK 0x8
#define SLAVE_HANG_ERROR__ROM_HANG_ERROR__SHIFT 0x3
#define SLAVE_HANG_ERROR__AUDIO_HANG_ERROR_MASK 0x10
#define SLAVE_HANG_ERROR__AUDIO_HANG_ERROR__SHIFT 0x4
#define SLAVE_HANG_ERROR__CEC_HANG_ERROR_MASK 0x20
#define SLAVE_HANG_ERROR__CEC_HANG_ERROR__SHIFT 0x5
#define SLAVE_HANG_ERROR__XDMA_HANG_ERROR_MASK 0x80
#define SLAVE_HANG_ERROR__XDMA_HANG_ERROR__SHIFT 0x7
#define SLAVE_HANG_ERROR__DOORBELL_HANG_ERROR_MASK 0x100
#define SLAVE_HANG_ERROR__DOORBELL_HANG_ERROR__SHIFT 0x8
#define SLAVE_HANG_ERROR__GARLIC_HANG_ERROR_MASK 0x200
#define SLAVE_HANG_ERROR__GARLIC_HANG_ERROR__SHIFT 0x9
#define CAPTURE_HOST_BUSNUM__CHECK_EN_MASK 0x1
#define CAPTURE_HOST_BUSNUM__CHECK_EN__SHIFT 0x0
#define HOST_BUSNUM__HOST_ID_MASK 0xffff
#define HOST_BUSNUM__HOST_ID__SHIFT 0x0
#define PEER_REG_RANGE0__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE0__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE0__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE0__END_ADDR__SHIFT 0x10
#define PEER_REG_RANGE1__START_ADDR_MASK 0xffff
#define PEER_REG_RANGE1__START_ADDR__SHIFT 0x0
#define PEER_REG_RANGE1__END_ADDR_MASK 0xffff0000
#define PEER_REG_RANGE1__END_ADDR__SHIFT 0x10
#define PEER0_FB_OFFSET_HI__PEER0_FB_OFFSET_HI_MASK 0xfffff
#define PEER0_FB_OFFSET_HI__PEER0_FB_OFFSET_HI__SHIFT 0x0
#define PEER0_FB_OFFSET_LO__PEER0_FB_OFFSET_LO_MASK 0xfffff
#define PEER0_FB_OFFSET_LO__PEER0_FB_OFFSET_LO__SHIFT 0x0
#define PEER0_FB_OFFSET_LO__PEER0_FB_EN_MASK 0x80000000
#define PEER0_FB_OFFSET_LO__PEER0_FB_EN__SHIFT 0x1f
#define PEER1_FB_OFFSET_HI__PEER1_FB_OFFSET_HI_MASK 0xfffff
#define PEER1_FB_OFFSET_HI__PEER1_FB_OFFSET_HI__SHIFT 0x0
#define PEER1_FB_OFFSET_LO__PEER1_FB_OFFSET_LO_MASK 0xfffff
#define PEER1_FB_OFFSET_LO__PEER1_FB_OFFSET_LO__SHIFT 0x0
#define PEER1_FB_OFFSET_LO__PEER1_FB_EN_MASK 0x80000000
#define PEER1_FB_OFFSET_LO__PEER1_FB_EN__SHIFT 0x1f
#define PEER2_FB_OFFSET_HI__PEER2_FB_OFFSET_HI_MASK 0xfffff
#define PEER2_FB_OFFSET_HI__PEER2_FB_OFFSET_HI__SHIFT 0x0
#define PEER2_FB_OFFSET_LO__PEER2_FB_OFFSET_LO_MASK 0xfffff
#define PEER2_FB_OFFSET_LO__PEER2_FB_OFFSET_LO__SHIFT 0x0
#define PEER2_FB_OFFSET_LO__PEER2_FB_EN_MASK 0x80000000
#define PEER2_FB_OFFSET_LO__PEER2_FB_EN__SHIFT 0x1f
#define PEER3_FB_OFFSET_HI__PEER3_FB_OFFSET_HI_MASK 0xfffff
#define PEER3_FB_OFFSET_HI__PEER3_FB_OFFSET_HI__SHIFT 0x0
#define PEER3_FB_OFFSET_LO__PEER3_FB_OFFSET_LO_MASK 0xfffff
#define PEER3_FB_OFFSET_LO__PEER3_FB_OFFSET_LO__SHIFT 0x0
#define PEER3_FB_OFFSET_LO__PEER3_FB_EN_MASK 0x80000000
#define PEER3_FB_OFFSET_LO__PEER3_FB_EN__SHIFT 0x1f
#define DBG_SMB_BYPASS_SRBM_ACCESS__DBG_SMB_BYPASS_SRBM_EN_MASK 0x1
#define DBG_SMB_BYPASS_SRBM_ACCESS__DBG_SMB_BYPASS_SRBM_EN__SHIFT 0x0
#define BIF_MST_TRANS_PENDING__BIF_MST_TRANS_PENDING_MASK 0xffffffff
#define BIF_MST_TRANS_PENDING__BIF_MST_TRANS_PENDING__SHIFT 0x0
#define BIF_SLV_TRANS_PENDING__BIF_SLV_TRANS_PENDING_MASK 0xffffffff
#define BIF_SLV_TRANS_PENDING__BIF_SLV_TRANS_PENDING__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID0_MASK 0xff
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID0__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID1_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID1__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID2_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID2__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID3_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST0__DEVFUNC_ID3__SHIFT 0x18
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID4_MASK 0xff
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID4__SHIFT 0x0
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID5_MASK 0xff00
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID5__SHIFT 0x8
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID6_MASK 0xff0000
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID6__SHIFT 0x10
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID7_MASK 0xff000000
#define BIF_DEVFUNCNUM_LIST1__DEVFUNC_ID7__SHIFT 0x18
#define BACO_CNTL__BACO_EN_MASK 0x1
#define BACO_CNTL__BACO_EN__SHIFT 0x0
#define BACO_CNTL__BACO_BCLK_OFF_MASK 0x2
#define BACO_CNTL__BACO_BCLK_OFF__SHIFT 0x1
#define BACO_CNTL__BACO_ISO_DIS_MASK 0x4
#define BACO_CNTL__BACO_ISO_DIS__SHIFT 0x2
#define BACO_CNTL__BACO_POWER_OFF_MASK 0x8
#define BACO_CNTL__BACO_POWER_OFF__SHIFT 0x3
#define BACO_CNTL__BACO_RESET_EN_MASK 0x10
#define BACO_CNTL__BACO_RESET_EN__SHIFT 0x4
#define BACO_CNTL__BACO_HANG_PROTECTION_EN_MASK 0x20
#define BACO_CNTL__BACO_HANG_PROTECTION_EN__SHIFT 0x5
#define BACO_CNTL__BACO_MODE_MASK 0x40
#define BACO_CNTL__BACO_MODE__SHIFT 0x6
#define BACO_CNTL__BACO_ANA_ISO_DIS_MASK 0x80
#define BACO_CNTL__BACO_ANA_ISO_DIS__SHIFT 0x7
#define BACO_CNTL__RCU_BIF_CONFIG_DONE_MASK 0x100
#define BACO_CNTL__RCU_BIF_CONFIG_DONE__SHIFT 0x8
#define BACO_CNTL__PWRGOOD_BF_MASK 0x200
#define BACO_CNTL__PWRGOOD_BF__SHIFT 0x9
#define BACO_CNTL__PWRGOOD_GPIO_MASK 0x400
#define BACO_CNTL__PWRGOOD_GPIO__SHIFT 0xa
#define BACO_CNTL__PWRGOOD_MEM_MASK 0x800
#define BACO_CNTL__PWRGOOD_MEM__SHIFT 0xb
#define BACO_CNTL__PWRGOOD_DVO_MASK 0x1000
#define BACO_CNTL__PWRGOOD_DVO__SHIFT 0xc
#define BACO_CNTL__PWRGOOD_IDSC_MASK 0x2000
#define BACO_CNTL__PWRGOOD_IDSC__SHIFT 0xd
#define BACO_CNTL__BACO_POWER_OFF_DRAM_MASK 0x10000
#define BACO_CNTL__BACO_POWER_OFF_DRAM__SHIFT 0x10
#define BACO_CNTL__BACO_BF_MEM_PHY_ISO_CNTRL_MASK 0x20000
#define BACO_CNTL__BACO_BF_MEM_PHY_ISO_CNTRL__SHIFT 0x11
#define BACO_CNTL__BACO_BIF_SCLK_SWITCH_MASK 0x40000
#define BACO_CNTL__BACO_BIF_SCLK_SWITCH__SHIFT 0x12
#define BF_ANA_ISO_CNTL__BF_ANA_ISO_DIS_MASK_MASK 0x1
#define BF_ANA_ISO_CNTL__BF_ANA_ISO_DIS_MASK__SHIFT 0x0
#define BF_ANA_ISO_CNTL__BF_VDDC_ISO_DIS_MASK_MASK 0x2
#define BF_ANA_ISO_CNTL__BF_VDDC_ISO_DIS_MASK__SHIFT 0x1
#define MEM_TYPE_CNTL__BF_MEM_PHY_G5_G3_MASK 0x1
#define MEM_TYPE_CNTL__BF_MEM_PHY_G5_G3__SHIFT 0x0
#define BIF_BACO_DEBUG__BIF_BACO_SCANDUMP_FLG_MASK 0x1
#define BIF_BACO_DEBUG__BIF_BACO_SCANDUMP_FLG__SHIFT 0x0
#define BIF_BACO_DEBUG_LATCH__BIF_BACO_LATCH_FLG_MASK 0x1
#define BIF_BACO_DEBUG_LATCH__BIF_BACO_LATCH_FLG__SHIFT 0x0
#define BACO_CNTL_MISC__BIF_ROM_REQ_DIS_MASK 0x1
#define BACO_CNTL_MISC__BIF_ROM_REQ_DIS__SHIFT 0x0
#define BACO_CNTL_MISC__BIF_AZ_REQ_DIS_MASK 0x2
#define BACO_CNTL_MISC__BIF_AZ_REQ_DIS__SHIFT 0x1
#define BACO_CNTL_MISC__BACO_LINK_RST_WIDTH_SEL_MASK 0xc
#define BACO_CNTL_MISC__BACO_LINK_RST_WIDTH_SEL__SHIFT 0x2
#define BACO_CNTL_MISC__BACO_REFCLK_SEL_MASK 0x10
#define BACO_CNTL_MISC__BACO_REFCLK_SEL__SHIFT 0x4
#define SMU_BIF_VDDGFX_PWR_STATUS__VDDGFX_GFX_PWR_OFF_MASK 0x1
#define SMU_BIF_VDDGFX_PWR_STATUS__VDDGFX_GFX_PWR_OFF__SHIFT 0x0
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX0_LOWER__VDDGFX_GFX0_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX0_UPPER__VDDGFX_GFX0_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX0_UPPER__VDDGFX_GFX0_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX1_LOWER__VDDGFX_GFX1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX1_UPPER__VDDGFX_GFX1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX1_UPPER__VDDGFX_GFX1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX2_LOWER__VDDGFX_GFX2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX2_UPPER__VDDGFX_GFX2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX2_UPPER__VDDGFX_GFX2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX3_LOWER__VDDGFX_GFX3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX3_UPPER__VDDGFX_GFX3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX3_UPPER__VDDGFX_GFX3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX4_LOWER__VDDGFX_GFX4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX4_UPPER__VDDGFX_GFX4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX4_UPPER__VDDGFX_GFX4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_GFX5_LOWER__VDDGFX_GFX5_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_GFX5_UPPER__VDDGFX_GFX5_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_GFX5_UPPER__VDDGFX_GFX5_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV1_LOWER__VDDGFX_RSV1_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV1_UPPER__VDDGFX_RSV1_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV1_UPPER__VDDGFX_RSV1_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV2_LOWER__VDDGFX_RSV2_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV2_UPPER__VDDGFX_RSV2_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV2_UPPER__VDDGFX_RSV2_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV3_LOWER__VDDGFX_RSV3_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV3_UPPER__VDDGFX_RSV3_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV3_UPPER__VDDGFX_RSV3_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_LOWER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_LOWER__SHIFT 0x2
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_CMP_EN_MASK 0x40000000
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_CMP_EN__SHIFT 0x1e
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_STALL_EN_MASK 0x80000000
#define BIF_VDDGFX_RSV4_LOWER__VDDGFX_RSV4_REG_STALL_EN__SHIFT 0x1f
#define BIF_VDDGFX_RSV4_UPPER__VDDGFX_RSV4_REG_UPPER_MASK 0x3fffc
#define BIF_VDDGFX_RSV4_UPPER__VDDGFX_RSV4_REG_UPPER__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_CMP_EN_MASK 0x1
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_CMP_EN__SHIFT 0x0
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_STALL_EN_MASK 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_HDP_STALL_EN__SHIFT 0x1
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_CMP_EN_MASK 0x4
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_CMP_EN__SHIFT 0x2
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_STALL_EN_MASK 0x8
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_XDMA_STALL_EN__SHIFT 0x3
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_CMP_EN_MASK 0x10
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_CMP_EN__SHIFT 0x4
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_STALL_EN_MASK 0x20
#define BIF_VDDGFX_FB_CMP__VDDGFX_FB_VGA_STALL_EN__SHIFT 0x5
#define BIF_SMU_INDEX__BIF_SMU_INDEX_MASK 0x7fffc
#define BIF_SMU_INDEX__BIF_SMU_INDEX__SHIFT 0x2
#define BIF_SMU_DATA__BIF_SMU_DATA_MASK 0x7fffc
#define BIF_SMU_DATA__BIF_SMU_DATA__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER1_LOWER__DOORBELL_GBLAPER1_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER1_UPPER__DOORBELL_GBLAPER1_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER1_UPPER__DOORBELL_GBLAPER1_UPPER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_LOWER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_LOWER__SHIFT 0x2
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_EN_MASK 0x80000000
#define BIF_DOORBELL_GBLAPER2_LOWER__DOORBELL_GBLAPER2_EN__SHIFT 0x1f
#define BIF_DOORBELL_GBLAPER2_UPPER__DOORBELL_GBLAPER2_UPPER_MASK 0xffc
#define BIF_DOORBELL_GBLAPER2_UPPER__DOORBELL_GBLAPER2_UPPER__SHIFT 0x2
#define IMPCTL_RESET__IMP_SW_RESET_MASK 0x1
#define IMPCTL_RESET__IMP_SW_RESET__SHIFT 0x0
#define GARLIC_FLUSH_CNTL__CP_RB0_WPTR_MASK 0x1
#define GARLIC_FLUSH_CNTL__CP_RB0_WPTR__SHIFT 0x0
#define GARLIC_FLUSH_CNTL__CP_RB1_WPTR_MASK 0x2
#define GARLIC_FLUSH_CNTL__CP_RB1_WPTR__SHIFT 0x1
#define GARLIC_FLUSH_CNTL__CP_RB2_WPTR_MASK 0x4
#define GARLIC_FLUSH_CNTL__CP_RB2_WPTR__SHIFT 0x2
#define GARLIC_FLUSH_CNTL__UVD_RBC_RB_WPTR_MASK 0x8
#define GARLIC_FLUSH_CNTL__UVD_RBC_RB_WPTR__SHIFT 0x3
#define GARLIC_FLUSH_CNTL__SDMA0_GFX_RB_WPTR_MASK 0x10
#define GARLIC_FLUSH_CNTL__SDMA0_GFX_RB_WPTR__SHIFT 0x4
#define GARLIC_FLUSH_CNTL__SDMA1_GFX_RB_WPTR_MASK 0x20
#define GARLIC_FLUSH_CNTL__SDMA1_GFX_RB_WPTR__SHIFT 0x5
#define GARLIC_FLUSH_CNTL__CP_DMA_ME_COMMAND_MASK 0x40
#define GARLIC_FLUSH_CNTL__CP_DMA_ME_COMMAND__SHIFT 0x6
#define GARLIC_FLUSH_CNTL__CP_DMA_PFP_COMMAND_MASK 0x80
#define GARLIC_FLUSH_CNTL__CP_DMA_PFP_COMMAND__SHIFT 0x7
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBI_WPTR_MASK 0x100
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBI_WPTR__SHIFT 0x8
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBO_WPTR_MASK 0x200
#define GARLIC_FLUSH_CNTL__SAM_SAB_RBO_WPTR__SHIFT 0x9
#define GARLIC_FLUSH_CNTL__VCE_OUT_RB_WPTR_MASK 0x400
#define GARLIC_FLUSH_CNTL__VCE_OUT_RB_WPTR__SHIFT 0xa
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR2_MASK 0x800
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR2__SHIFT 0xb
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR_MASK 0x1000
#define GARLIC_FLUSH_CNTL__VCE_RB_WPTR__SHIFT 0xc
#define GARLIC_FLUSH_CNTL__HOST_DOORBELL_MASK 0x2000
#define GARLIC_FLUSH_CNTL__HOST_DOORBELL__SHIFT 0xd
#define GARLIC_FLUSH_CNTL__SELFRING_DOORBELL_MASK 0x4000
#define GARLIC_FLUSH_CNTL__SELFRING_DOORBELL__SHIFT 0xe
#define GARLIC_FLUSH_CNTL__CP_DMA_PIO_COMMAND_MASK 0x8000
#define GARLIC_FLUSH_CNTL__CP_DMA_PIO_COMMAND__SHIFT 0xf
#define GARLIC_FLUSH_CNTL__DISPLAY_MASK 0x10000
#define GARLIC_FLUSH_CNTL__DISPLAY__SHIFT 0x10
#define GARLIC_FLUSH_CNTL__SDMA2_GFX_RB_WPTR_MASK 0x20000
#define GARLIC_FLUSH_CNTL__SDMA2_GFX_RB_WPTR__SHIFT 0x11
#define GARLIC_FLUSH_CNTL__SDMA3_GFX_RB_WPTR_MASK 0x40000
#define GARLIC_FLUSH_CNTL__SDMA3_GFX_RB_WPTR__SHIFT 0x12
#define GARLIC_FLUSH_CNTL__IGNORE_MC_DISABLE_MASK 0x40000000
#define GARLIC_FLUSH_CNTL__IGNORE_MC_DISABLE__SHIFT 0x1e
#define GARLIC_FLUSH_CNTL__DISABLE_ALL_MASK 0x80000000
#define GARLIC_FLUSH_CNTL__DISABLE_ALL__SHIFT 0x1f
#define GARLIC_FLUSH_ADDR_START_0__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_0__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_0__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_0__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_0__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_0__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_1__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_1__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_1__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_1__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_1__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_1__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_2__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_2__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_2__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_2__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_2__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_2__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_3__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_3__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_3__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_3__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_3__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_3__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_4__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_4__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_4__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_4__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_4__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_4__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_5__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_5__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_5__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_5__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_5__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_5__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_6__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_6__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_6__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_6__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_6__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_6__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_START_7__ENABLE_MASK 0x1
#define GARLIC_FLUSH_ADDR_START_7__ENABLE__SHIFT 0x0
#define GARLIC_FLUSH_ADDR_START_7__MODE_MASK 0x2
#define GARLIC_FLUSH_ADDR_START_7__MODE__SHIFT 0x1
#define GARLIC_FLUSH_ADDR_START_7__ADDR_START_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_START_7__ADDR_START__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_0__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_0__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_1__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_1__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_2__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_2__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_3__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_3__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_4__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_4__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_5__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_5__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_6__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_6__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_ADDR_END_7__ADDR_END_MASK 0xfffffffc
#define GARLIC_FLUSH_ADDR_END_7__ADDR_END__SHIFT 0x2
#define GARLIC_FLUSH_REQ__FLUSH_REQ_MASK 0x1
#define GARLIC_FLUSH_REQ__FLUSH_REQ__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_REQ__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_REQ__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_REQ__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_REQ__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_REQ__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_REQ__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_REQ__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_REQ__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_REQ__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_REQ__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_REQ__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_REQ__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_REQ__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_REQ__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_REQ__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_REQ__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_REQ__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_REQ__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_REQ__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_REQ__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_REQ__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_REQ__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_REQ__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_REQ__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_REQ__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_REQ__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_REQ__SDMA3__SHIFT 0xd
#define GPU_GARLIC_FLUSH_DONE__CP0_MASK 0x1
#define GPU_GARLIC_FLUSH_DONE__CP0__SHIFT 0x0
#define GPU_GARLIC_FLUSH_DONE__CP1_MASK 0x2
#define GPU_GARLIC_FLUSH_DONE__CP1__SHIFT 0x1
#define GPU_GARLIC_FLUSH_DONE__CP2_MASK 0x4
#define GPU_GARLIC_FLUSH_DONE__CP2__SHIFT 0x2
#define GPU_GARLIC_FLUSH_DONE__CP3_MASK 0x8
#define GPU_GARLIC_FLUSH_DONE__CP3__SHIFT 0x3
#define GPU_GARLIC_FLUSH_DONE__CP4_MASK 0x10
#define GPU_GARLIC_FLUSH_DONE__CP4__SHIFT 0x4
#define GPU_GARLIC_FLUSH_DONE__CP5_MASK 0x20
#define GPU_GARLIC_FLUSH_DONE__CP5__SHIFT 0x5
#define GPU_GARLIC_FLUSH_DONE__CP6_MASK 0x40
#define GPU_GARLIC_FLUSH_DONE__CP6__SHIFT 0x6
#define GPU_GARLIC_FLUSH_DONE__CP7_MASK 0x80
#define GPU_GARLIC_FLUSH_DONE__CP7__SHIFT 0x7
#define GPU_GARLIC_FLUSH_DONE__CP8_MASK 0x100
#define GPU_GARLIC_FLUSH_DONE__CP8__SHIFT 0x8
#define GPU_GARLIC_FLUSH_DONE__CP9_MASK 0x200
#define GPU_GARLIC_FLUSH_DONE__CP9__SHIFT 0x9
#define GPU_GARLIC_FLUSH_DONE__SDMA0_MASK 0x400
#define GPU_GARLIC_FLUSH_DONE__SDMA0__SHIFT 0xa
#define GPU_GARLIC_FLUSH_DONE__SDMA1_MASK 0x800
#define GPU_GARLIC_FLUSH_DONE__SDMA1__SHIFT 0xb
#define GPU_GARLIC_FLUSH_DONE__SDMA2_MASK 0x1000
#define GPU_GARLIC_FLUSH_DONE__SDMA2__SHIFT 0xc
#define GPU_GARLIC_FLUSH_DONE__SDMA3_MASK 0x2000
#define GPU_GARLIC_FLUSH_DONE__SDMA3__SHIFT 0xd
#define REMAP_HDP_MEM_FLUSH_CNTL__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_MEM_FLUSH_CNTL__ADDRESS__SHIFT 0x2
#define REMAP_HDP_REG_FLUSH_CNTL__ADDRESS_MASK 0x7fffc
#define REMAP_HDP_REG_FLUSH_CNTL__ADDRESS__SHIFT 0x2
#define BIOS_SCRATCH_0__BIOS_SCRATCH_0_MASK 0xffffffff
#define BIOS_SCRATCH_0__BIOS_SCRATCH_0__SHIFT 0x0
#define BIOS_SCRATCH_1__BIOS_SCRATCH_1_MASK 0xffffffff
#define BIOS_SCRATCH_1__BIOS_SCRATCH_1__SHIFT 0x0
#define BIOS_SCRATCH_2__BIOS_SCRATCH_2_MASK 0xffffffff
#define BIOS_SCRATCH_2__BIOS_SCRATCH_2__SHIFT 0x0
#define BIOS_SCRATCH_3__BIOS_SCRATCH_3_MASK 0xffffffff
#define BIOS_SCRATCH_3__BIOS_SCRATCH_3__SHIFT 0x0
#define BIOS_SCRATCH_4__BIOS_SCRATCH_4_MASK 0xffffffff
#define BIOS_SCRATCH_4__BIOS_SCRATCH_4__SHIFT 0x0
#define BIOS_SCRATCH_5__BIOS_SCRATCH_5_MASK 0xffffffff
#define BIOS_SCRATCH_5__BIOS_SCRATCH_5__SHIFT 0x0
#define BIOS_SCRATCH_6__BIOS_SCRATCH_6_MASK 0xffffffff
#define BIOS_SCRATCH_6__BIOS_SCRATCH_6__SHIFT 0x0
#define BIOS_SCRATCH_7__BIOS_SCRATCH_7_MASK 0xffffffff
#define BIOS_SCRATCH_7__BIOS_SCRATCH_7__SHIFT 0x0
#define BIOS_SCRATCH_8__BIOS_SCRATCH_8_MASK 0xffffffff
#define BIOS_SCRATCH_8__BIOS_SCRATCH_8__SHIFT 0x0
#define BIOS_SCRATCH_9__BIOS_SCRATCH_9_MASK 0xffffffff
#define BIOS_SCRATCH_9__BIOS_SCRATCH_9__SHIFT 0x0
#define BIOS_SCRATCH_10__BIOS_SCRATCH_10_MASK 0xffffffff
#define BIOS_SCRATCH_10__BIOS_SCRATCH_10__SHIFT 0x0
#define BIOS_SCRATCH_11__BIOS_SCRATCH_11_MASK 0xffffffff
#define BIOS_SCRATCH_11__BIOS_SCRATCH_11__SHIFT 0x0
#define BIOS_SCRATCH_12__BIOS_SCRATCH_12_MASK 0xffffffff
#define BIOS_SCRATCH_12__BIOS_SCRATCH_12__SHIFT 0x0
#define BIOS_SCRATCH_13__BIOS_SCRATCH_13_MASK 0xffffffff
#define BIOS_SCRATCH_13__BIOS_SCRATCH_13__SHIFT 0x0
#define BIOS_SCRATCH_14__BIOS_SCRATCH_14_MASK 0xffffffff
#define BIOS_SCRATCH_14__BIOS_SCRATCH_14__SHIFT 0x0
#define BIOS_SCRATCH_15__BIOS_SCRATCH_15_MASK 0xffffffff
#define BIOS_SCRATCH_15__BIOS_SCRATCH_15__SHIFT 0x0
#define BIF_RB_CNTL__RB_ENABLE_MASK 0x1
#define BIF_RB_CNTL__RB_ENABLE__SHIFT 0x0
#define BIF_RB_CNTL__RB_SIZE_MASK 0x3e
#define BIF_RB_CNTL__RB_SIZE__SHIFT 0x1
#define BIF_RB_CNTL__WPTR_WRITEBACK_ENABLE_MASK 0x100
#define BIF_RB_CNTL__WPTR_WRITEBACK_ENABLE__SHIFT 0x8
#define BIF_RB_CNTL__WPTR_WRITEBACK_TIMER_MASK 0x3e00
#define BIF_RB_CNTL__WPTR_WRITEBACK_TIMER__SHIFT 0x9
#define BIF_RB_CNTL__BIF_RB_TRAN_MASK 0x20000
#define BIF_RB_CNTL__BIF_RB_TRAN__SHIFT 0x11
#define BIF_RB_CNTL__WPTR_OVERFLOW_CLEAR_MASK 0x80000000
#define BIF_RB_CNTL__WPTR_OVERFLOW_CLEAR__SHIFT 0x1f
#define BIF_RB_BASE__ADDR_MASK 0xffffffff
#define BIF_RB_BASE__ADDR__SHIFT 0x0
#define BIF_RB_RPTR__OFFSET_MASK 0x3fffc
#define BIF_RB_RPTR__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR__BIF_RB_OVERFLOW_MASK 0x1
#define BIF_RB_WPTR__BIF_RB_OVERFLOW__SHIFT 0x0
#define BIF_RB_WPTR__OFFSET_MASK 0x3fffc
#define BIF_RB_WPTR__OFFSET__SHIFT 0x2
#define BIF_RB_WPTR_ADDR_HI__ADDR_MASK 0xff
#define BIF_RB_WPTR_ADDR_HI__ADDR__SHIFT 0x0
#define BIF_RB_WPTR_ADDR_LO__ADDR_MASK 0xfffffffc
#define BIF_RB_WPTR_ADDR_LO__ADDR__SHIFT 0x2
#define MAILBOX_INDEX__MAILBOX_INDEX_MASK 0xf
#define MAILBOX_INDEX__MAILBOX_INDEX__SHIFT 0x0
#define MAILBOX_MSGBUF_TRN_DW0__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_TRN_DW0__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_TRN_DW1__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_TRN_DW1__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_TRN_DW2__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_TRN_DW2__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_TRN_DW3__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_TRN_DW3__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_RCV_DW0__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_RCV_DW0__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_RCV_DW1__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_RCV_DW1__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_RCV_DW2__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_RCV_DW2__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_MSGBUF_RCV_DW3__MSGBUF_DATA_MASK 0xffffffff
#define MAILBOX_MSGBUF_RCV_DW3__MSGBUF_DATA__SHIFT 0x0
#define MAILBOX_CONTROL__TRN_MSG_VALID_MASK 0x1
#define MAILBOX_CONTROL__TRN_MSG_VALID__SHIFT 0x0
#define MAILBOX_CONTROL__TRN_MSG_ACK_MASK 0x2
#define MAILBOX_CONTROL__TRN_MSG_ACK__SHIFT 0x1
#define MAILBOX_CONTROL__RCV_MSG_VALID_MASK 0x100
#define MAILBOX_CONTROL__RCV_MSG_VALID__SHIFT 0x8
#define MAILBOX_CONTROL__RCV_MSG_ACK_MASK 0x200
#define MAILBOX_CONTROL__RCV_MSG_ACK__SHIFT 0x9
#define MAILBOX_INT_CNTL__VALID_INT_EN_MASK 0x1
#define MAILBOX_INT_CNTL__VALID_INT_EN__SHIFT 0x0
#define MAILBOX_INT_CNTL__ACK_INT_EN_MASK 0x2
#define MAILBOX_INT_CNTL__ACK_INT_EN__SHIFT 0x1
#define BIF_VIRT_RESET_REQ__VIRT_RESET_REQ_VF_MASK 0xffff
#define BIF_VIRT_RESET_REQ__VIRT_RESET_REQ_VF__SHIFT 0x0
#define BIF_VIRT_RESET_REQ__VIRT_RESET_REQ_SOFTPF_MASK 0x80000000
#define BIF_VIRT_RESET_REQ__VIRT_RESET_REQ_SOFTPF__SHIFT 0x1f
#define VM_INIT_STATUS__VM_INIT_STATUS_MASK 0x1
#define VM_INIT_STATUS__VM_INIT_STATUS__SHIFT 0x0
#define BIF_GPUIOV_RESET_NOTIFICATION__RESET_NOTIFICATION_MASK 0xffffffff
#define BIF_GPUIOV_RESET_NOTIFICATION__RESET_NOTIFICATION__SHIFT 0x0
#define BIF_GPUIOV_VM_INIT_STATUS__VM_INIT_STATUS_MASK 0xffffffff
#define BIF_GPUIOV_VM_INIT_STATUS__VM_INIT_STATUS__SHIFT 0x0
#define BIF_GPUIOV_FB_TOTAL_FB_INFO__TOTAL_FB_AVAILABLE_MASK 0xffff
#define BIF_GPUIOV_FB_TOTAL_FB_INFO__TOTAL_FB_AVAILABLE__SHIFT 0x0
#define BIF_GPUIOV_FB_TOTAL_FB_INFO__TOTAL_FB_CONSUMED_MASK 0xffff0000
#define BIF_GPUIOV_FB_TOTAL_FB_INFO__TOTAL_FB_CONSUMED__SHIFT 0x10
#define BIF_GPUIOV_GPU_IDLE_LATENCY__GPU_IDLE_LATENCY_MASK 0xffffffff
#define BIF_GPUIOV_GPU_IDLE_LATENCY__GPU_IDLE_LATENCY__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_UPPER__SHIFT 0x10
#define BIF_GPUIOV_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_UPPER__SHIFT 0x10
#define BIF_GPUIOV_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_UPPER__SHIFT 0x10
#define BIF_GPUIOV_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_UPPER__SHIFT 0x10
#define BIF_GPUIOV_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_UPPER__SHIFT 0x10
#define BIF_GPUIOV_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_LOWER_MASK 0xffff
#define BIF_GPUIOV_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_LOWER__SHIFT 0x0
#define BIF_GPUIOV_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_UPPER_MASK 0xffff0000
#define BIF_GPUIOV_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_UPPER__SHIFT 0x10
#define BIF_GPU_IDLE_LATENCY__GPU_IDLE_LATENCY_MASK 0xffffffff
#define BIF_GPU_IDLE_LATENCY__GPU_IDLE_LATENCY__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE0__MMIO_MAP_RANGE0_UPPER__SHIFT 0x10
#define BIF_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE1__MMIO_MAP_RANGE1_UPPER__SHIFT 0x10
#define BIF_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE2__MMIO_MAP_RANGE2_UPPER__SHIFT 0x10
#define BIF_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE3__MMIO_MAP_RANGE3_UPPER__SHIFT 0x10
#define BIF_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE4__MMIO_MAP_RANGE4_UPPER__SHIFT 0x10
#define BIF_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_LOWER_MASK 0xffff
#define BIF_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_LOWER__SHIFT 0x0
#define BIF_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_UPPER_MASK 0xffff0000
#define BIF_MMIO_MAP_RANGE5__MMIO_MAP_RANGE5_UPPER__SHIFT 0x10
#define VENDOR_ID__VENDOR_ID_MASK 0xffff
#define VENDOR_ID__VENDOR_ID__SHIFT 0x0
#define DEVICE_ID__DEVICE_ID_MASK 0xffff
#define DEVICE_ID__DEVICE_ID__SHIFT 0x0
#define COMMAND__IO_ACCESS_EN_MASK 0x1
#define COMMAND__IO_ACCESS_EN__SHIFT 0x0
#define COMMAND__MEM_ACCESS_EN_MASK 0x2
#define COMMAND__MEM_ACCESS_EN__SHIFT 0x1
#define COMMAND__BUS_MASTER_EN_MASK 0x4
#define COMMAND__BUS_MASTER_EN__SHIFT 0x2
#define COMMAND__SPECIAL_CYCLE_EN_MASK 0x8
#define COMMAND__SPECIAL_CYCLE_EN__SHIFT 0x3
#define COMMAND__MEM_WRITE_INVALIDATE_EN_MASK 0x10
#define COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT 0x4
#define COMMAND__PAL_SNOOP_EN_MASK 0x20
#define COMMAND__PAL_SNOOP_EN__SHIFT 0x5
#define COMMAND__PARITY_ERROR_RESPONSE_MASK 0x40
#define COMMAND__PARITY_ERROR_RESPONSE__SHIFT 0x6
#define COMMAND__AD_STEPPING_MASK 0x80
#define COMMAND__AD_STEPPING__SHIFT 0x7
#define COMMAND__SERR_EN_MASK 0x100
#define COMMAND__SERR_EN__SHIFT 0x8
#define COMMAND__FAST_B2B_EN_MASK 0x200
#define COMMAND__FAST_B2B_EN__SHIFT 0x9
#define COMMAND__INT_DIS_MASK 0x400
#define COMMAND__INT_DIS__SHIFT 0xa
#define STATUS__INT_STATUS_MASK 0x8
#define STATUS__INT_STATUS__SHIFT 0x3
#define STATUS__CAP_LIST_MASK 0x10
#define STATUS__CAP_LIST__SHIFT 0x4
#define STATUS__PCI_66_EN_MASK 0x20
#define STATUS__PCI_66_EN__SHIFT 0x5
#define STATUS__FAST_BACK_CAPABLE_MASK 0x80
#define STATUS__FAST_BACK_CAPABLE__SHIFT 0x7
#define STATUS__MASTER_DATA_PARITY_ERROR_MASK 0x100
#define STATUS__MASTER_DATA_PARITY_ERROR__SHIFT 0x8
#define STATUS__DEVSEL_TIMING_MASK 0x600
#define STATUS__DEVSEL_TIMING__SHIFT 0x9
#define STATUS__SIGNAL_TARGET_ABORT_MASK 0x800
#define STATUS__SIGNAL_TARGET_ABORT__SHIFT 0xb
#define STATUS__RECEIVED_TARGET_ABORT_MASK 0x1000
#define STATUS__RECEIVED_TARGET_ABORT__SHIFT 0xc
#define STATUS__RECEIVED_MASTER_ABORT_MASK 0x2000
#define STATUS__RECEIVED_MASTER_ABORT__SHIFT 0xd
#define STATUS__SIGNALED_SYSTEM_ERROR_MASK 0x4000
#define STATUS__SIGNALED_SYSTEM_ERROR__SHIFT 0xe
#define STATUS__PARITY_ERROR_DETECTED_MASK 0x8000
#define STATUS__PARITY_ERROR_DETECTED__SHIFT 0xf
#define REVISION_ID__MINOR_REV_ID_MASK 0xf
#define REVISION_ID__MINOR_REV_ID__SHIFT 0x0
#define REVISION_ID__MAJOR_REV_ID_MASK 0xf0
#define REVISION_ID__MAJOR_REV_ID__SHIFT 0x4
#define PROG_INTERFACE__PROG_INTERFACE_MASK 0xff
#define PROG_INTERFACE__PROG_INTERFACE__SHIFT 0x0
#define SUB_CLASS__SUB_CLASS_MASK 0xff
#define SUB_CLASS__SUB_CLASS__SHIFT 0x0
#define BASE_CLASS__BASE_CLASS_MASK 0xff
#define BASE_CLASS__BASE_CLASS__SHIFT 0x0
#define CACHE_LINE__CACHE_LINE_SIZE_MASK 0xff
#define CACHE_LINE__CACHE_LINE_SIZE__SHIFT 0x0
#define LATENCY__LATENCY_TIMER_MASK 0xff
#define LATENCY__LATENCY_TIMER__SHIFT 0x0
#define HEADER__HEADER_TYPE_MASK 0x7f
#define HEADER__HEADER_TYPE__SHIFT 0x0
#define HEADER__DEVICE_TYPE_MASK 0x80
#define HEADER__DEVICE_TYPE__SHIFT 0x7
#define BIST__BIST_COMP_MASK 0xf
#define BIST__BIST_COMP__SHIFT 0x0
#define BIST__BIST_STRT_MASK 0x40
#define BIST__BIST_STRT__SHIFT 0x6
#define BIST__BIST_CAP_MASK 0x80
#define BIST__BIST_CAP__SHIFT 0x7
#define BASE_ADDR_1__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_1__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_2__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_2__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_3__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_3__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_4__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_4__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_5__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_5__BASE_ADDR__SHIFT 0x0
#define BASE_ADDR_6__BASE_ADDR_MASK 0xffffffff
#define BASE_ADDR_6__BASE_ADDR__SHIFT 0x0
#define ROM_BASE_ADDR__BASE_ADDR_MASK 0xffffffff
#define ROM_BASE_ADDR__BASE_ADDR__SHIFT 0x0
#define CAP_PTR__CAP_PTR_MASK 0xff
#define CAP_PTR__CAP_PTR__SHIFT 0x0
#define INTERRUPT_LINE__INTERRUPT_LINE_MASK 0xff
#define INTERRUPT_LINE__INTERRUPT_LINE__SHIFT 0x0
#define INTERRUPT_PIN__INTERRUPT_PIN_MASK 0xff
#define INTERRUPT_PIN__INTERRUPT_PIN__SHIFT 0x0
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define ADAPTER_ID__SUBSYSTEM_ID_MASK 0xffff0000
#define ADAPTER_ID__SUBSYSTEM_ID__SHIFT 0x10
#define MIN_GRANT__MIN_GNT_MASK 0xff
#define MIN_GRANT__MIN_GNT__SHIFT 0x0
#define MAX_LATENCY__MAX_LAT_MASK 0xff
#define MAX_LATENCY__MAX_LAT__SHIFT 0x0
#define VENDOR_CAP_LIST__CAP_ID_MASK 0xff
#define VENDOR_CAP_LIST__CAP_ID__SHIFT 0x0
#define VENDOR_CAP_LIST__NEXT_PTR_MASK 0xff00
#define VENDOR_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define VENDOR_CAP_LIST__LENGTH_MASK 0xff0000
#define VENDOR_CAP_LIST__LENGTH__SHIFT 0x10
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK 0xffff
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT 0x0
#define ADAPTER_ID_W__SUBSYSTEM_ID_MASK 0xffff0000
#define ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT 0x10
#define PMI_CAP_LIST__CAP_ID_MASK 0xff
#define PMI_CAP_LIST__CAP_ID__SHIFT 0x0
#define PMI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define PMI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define PMI_CAP__VERSION_MASK 0x7
#define PMI_CAP__VERSION__SHIFT 0x0
#define PMI_CAP__PME_CLOCK_MASK 0x8
#define PMI_CAP__PME_CLOCK__SHIFT 0x3
#define PMI_CAP__DEV_SPECIFIC_INIT_MASK 0x20
#define PMI_CAP__DEV_SPECIFIC_INIT__SHIFT 0x5
#define PMI_CAP__AUX_CURRENT_MASK 0x1c0
#define PMI_CAP__AUX_CURRENT__SHIFT 0x6
#define PMI_CAP__D1_SUPPORT_MASK 0x200
#define PMI_CAP__D1_SUPPORT__SHIFT 0x9
#define PMI_CAP__D2_SUPPORT_MASK 0x400
#define PMI_CAP__D2_SUPPORT__SHIFT 0xa
#define PMI_CAP__PME_SUPPORT_MASK 0xf800
#define PMI_CAP__PME_SUPPORT__SHIFT 0xb
#define PMI_STATUS_CNTL__POWER_STATE_MASK 0x3
#define PMI_STATUS_CNTL__POWER_STATE__SHIFT 0x0
#define PMI_STATUS_CNTL__NO_SOFT_RESET_MASK 0x8
#define PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT 0x3
#define PMI_STATUS_CNTL__PME_EN_MASK 0x100
#define PMI_STATUS_CNTL__PME_EN__SHIFT 0x8
#define PMI_STATUS_CNTL__DATA_SELECT_MASK 0x1e00
#define PMI_STATUS_CNTL__DATA_SELECT__SHIFT 0x9
#define PMI_STATUS_CNTL__DATA_SCALE_MASK 0x6000
#define PMI_STATUS_CNTL__DATA_SCALE__SHIFT 0xd
#define PMI_STATUS_CNTL__PME_STATUS_MASK 0x8000
#define PMI_STATUS_CNTL__PME_STATUS__SHIFT 0xf
#define PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK 0x400000
#define PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT 0x16
#define PMI_STATUS_CNTL__BUS_PWR_EN_MASK 0x800000
#define PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT 0x17
#define PMI_STATUS_CNTL__PMI_DATA_MASK 0xff000000
#define PMI_STATUS_CNTL__PMI_DATA__SHIFT 0x18
#define PCIE_CAP_LIST__CAP_ID_MASK 0xff
#define PCIE_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_CAP_LIST__NEXT_PTR_MASK 0xff00
#define PCIE_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define PCIE_CAP__VERSION_MASK 0xf
#define PCIE_CAP__VERSION__SHIFT 0x0
#define PCIE_CAP__DEVICE_TYPE_MASK 0xf0
#define PCIE_CAP__DEVICE_TYPE__SHIFT 0x4
#define PCIE_CAP__SLOT_IMPLEMENTED_MASK 0x100
#define PCIE_CAP__SLOT_IMPLEMENTED__SHIFT 0x8
#define PCIE_CAP__INT_MESSAGE_NUM_MASK 0x3e00
#define PCIE_CAP__INT_MESSAGE_NUM__SHIFT 0x9
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK 0x7
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT 0x0
#define DEVICE_CAP__PHANTOM_FUNC_MASK 0x18
#define DEVICE_CAP__PHANTOM_FUNC__SHIFT 0x3
#define DEVICE_CAP__EXTENDED_TAG_MASK 0x20
#define DEVICE_CAP__EXTENDED_TAG__SHIFT 0x5
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK 0x1c0
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT 0x6
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK 0xe00
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT 0x9
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK 0x8000
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT 0xf
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK 0x3fc0000
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT 0x12
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK 0xc000000
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT 0x1a
#define DEVICE_CAP__FLR_CAPABLE_MASK 0x10000000
#define DEVICE_CAP__FLR_CAPABLE__SHIFT 0x1c
#define DEVICE_CNTL__CORR_ERR_EN_MASK 0x1
#define DEVICE_CNTL__CORR_ERR_EN__SHIFT 0x0
#define DEVICE_CNTL__NON_FATAL_ERR_EN_MASK 0x2
#define DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT 0x1
#define DEVICE_CNTL__FATAL_ERR_EN_MASK 0x4
#define DEVICE_CNTL__FATAL_ERR_EN__SHIFT 0x2
#define DEVICE_CNTL__USR_REPORT_EN_MASK 0x8
#define DEVICE_CNTL__USR_REPORT_EN__SHIFT 0x3
#define DEVICE_CNTL__RELAXED_ORD_EN_MASK 0x10
#define DEVICE_CNTL__RELAXED_ORD_EN__SHIFT 0x4
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK 0xe0
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT 0x5
#define DEVICE_CNTL__EXTENDED_TAG_EN_MASK 0x100
#define DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT 0x8
#define DEVICE_CNTL__PHANTOM_FUNC_EN_MASK 0x200
#define DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT 0x9
#define DEVICE_CNTL__AUX_POWER_PM_EN_MASK 0x400
#define DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT 0xa
#define DEVICE_CNTL__NO_SNOOP_EN_MASK 0x800
#define DEVICE_CNTL__NO_SNOOP_EN__SHIFT 0xb
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK 0x7000
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT 0xc
#define DEVICE_CNTL__INITIATE_FLR_MASK 0x8000
#define DEVICE_CNTL__INITIATE_FLR__SHIFT 0xf
#define DEVICE_STATUS__CORR_ERR_MASK 0x1
#define DEVICE_STATUS__CORR_ERR__SHIFT 0x0
#define DEVICE_STATUS__NON_FATAL_ERR_MASK 0x2
#define DEVICE_STATUS__NON_FATAL_ERR__SHIFT 0x1
#define DEVICE_STATUS__FATAL_ERR_MASK 0x4
#define DEVICE_STATUS__FATAL_ERR__SHIFT 0x2
#define DEVICE_STATUS__USR_DETECTED_MASK 0x8
#define DEVICE_STATUS__USR_DETECTED__SHIFT 0x3
#define DEVICE_STATUS__AUX_PWR_MASK 0x10
#define DEVICE_STATUS__AUX_PWR__SHIFT 0x4
#define DEVICE_STATUS__TRANSACTIONS_PEND_MASK 0x20
#define DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT 0x5
#define LINK_CAP__LINK_SPEED_MASK 0xf
#define LINK_CAP__LINK_SPEED__SHIFT 0x0
#define LINK_CAP__LINK_WIDTH_MASK 0x3f0
#define LINK_CAP__LINK_WIDTH__SHIFT 0x4
#define LINK_CAP__PM_SUPPORT_MASK 0xc00
#define LINK_CAP__PM_SUPPORT__SHIFT 0xa
#define LINK_CAP__L0S_EXIT_LATENCY_MASK 0x7000
#define LINK_CAP__L0S_EXIT_LATENCY__SHIFT 0xc
#define LINK_CAP__L1_EXIT_LATENCY_MASK 0x38000
#define LINK_CAP__L1_EXIT_LATENCY__SHIFT 0xf
#define LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK 0x40000
#define LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT 0x12
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK 0x80000
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT 0x13
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK 0x100000
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT 0x14
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK 0x200000
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT 0x15
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK 0x400000
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT 0x16
#define LINK_CAP__PORT_NUMBER_MASK 0xff000000
#define LINK_CAP__PORT_NUMBER__SHIFT 0x18
#define LINK_CNTL__PM_CONTROL_MASK 0x3
#define LINK_CNTL__PM_CONTROL__SHIFT 0x0
#define LINK_CNTL__READ_CPL_BOUNDARY_MASK 0x8
#define LINK_CNTL__READ_CPL_BOUNDARY__SHIFT 0x3
#define LINK_CNTL__LINK_DIS_MASK 0x10
#define LINK_CNTL__LINK_DIS__SHIFT 0x4
#define LINK_CNTL__RETRAIN_LINK_MASK 0x20
#define LINK_CNTL__RETRAIN_LINK__SHIFT 0x5
#define LINK_CNTL__COMMON_CLOCK_CFG_MASK 0x40
#define LINK_CNTL__COMMON_CLOCK_CFG__SHIFT 0x6
#define LINK_CNTL__EXTENDED_SYNC_MASK 0x80
#define LINK_CNTL__EXTENDED_SYNC__SHIFT 0x7
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK 0x100
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT 0x8
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK 0x200
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT 0x9
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK 0x400
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT 0xa
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK 0x800
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT 0xb
#define LINK_STATUS__CURRENT_LINK_SPEED_MASK 0xf
#define LINK_STATUS__CURRENT_LINK_SPEED__SHIFT 0x0
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK 0x3f0
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT 0x4
#define LINK_STATUS__LINK_TRAINING_MASK 0x800
#define LINK_STATUS__LINK_TRAINING__SHIFT 0xb
#define LINK_STATUS__SLOT_CLOCK_CFG_MASK 0x1000
#define LINK_STATUS__SLOT_CLOCK_CFG__SHIFT 0xc
#define LINK_STATUS__DL_ACTIVE_MASK 0x2000
#define LINK_STATUS__DL_ACTIVE__SHIFT 0xd
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK 0x4000
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT 0xe
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK 0x8000
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT 0xf
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK 0xf
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT 0x0
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK 0x10
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT 0x4
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK 0x20
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT 0x5
#define DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK 0x40
#define DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT 0x6
#define DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK 0x80
#define DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT 0x7
#define DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK 0x100
#define DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT 0x8
#define DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK 0x200
#define DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT 0x9
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK 0x400
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT 0xa
#define DEVICE_CAP2__LTR_SUPPORTED_MASK 0x800
#define DEVICE_CAP2__LTR_SUPPORTED__SHIFT 0xb
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK 0x3000
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT 0xc
#define DEVICE_CAP2__OBFF_SUPPORTED_MASK 0xc0000
#define DEVICE_CAP2__OBFF_SUPPORTED__SHIFT 0x12
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK 0x100000
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT 0x14
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK 0x200000
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT 0x15
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK 0xc00000
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT 0x16
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK 0xf
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT 0x0
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK 0x10
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT 0x4
#define DEVICE_CNTL2__ARI_FORWARDING_EN_MASK 0x20
#define DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT 0x5
#define DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK 0x40
#define DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT 0x6
#define DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK 0x80
#define DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT 0x7
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK 0x100
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT 0x8
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK 0x200
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT 0x9
#define DEVICE_CNTL2__LTR_EN_MASK 0x400
#define DEVICE_CNTL2__LTR_EN__SHIFT 0xa
#define DEVICE_CNTL2__OBFF_EN_MASK 0x6000
#define DEVICE_CNTL2__OBFF_EN__SHIFT 0xd
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK 0x8000
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT 0xf
#define DEVICE_STATUS2__RESERVED_MASK 0xffff
#define DEVICE_STATUS2__RESERVED__SHIFT 0x0
#define LINK_CAP2__SUPPORTED_LINK_SPEED_MASK 0xfe
#define LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT 0x1
#define LINK_CAP2__CROSSLINK_SUPPORTED_MASK 0x100
#define LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT 0x8
#define LINK_CAP2__RESERVED_MASK 0xfffffe00
#define LINK_CAP2__RESERVED__SHIFT 0x9
#define LINK_CNTL2__TARGET_LINK_SPEED_MASK 0xf
#define LINK_CNTL2__TARGET_LINK_SPEED__SHIFT 0x0
#define LINK_CNTL2__ENTER_COMPLIANCE_MASK 0x10
#define LINK_CNTL2__ENTER_COMPLIANCE__SHIFT 0x4
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK 0x20
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT 0x5
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK 0x40
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT 0x6
#define LINK_CNTL2__XMIT_MARGIN_MASK 0x380
#define LINK_CNTL2__XMIT_MARGIN__SHIFT 0x7
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK 0x400
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT 0xa
#define LINK_CNTL2__COMPLIANCE_SOS_MASK 0x800
#define LINK_CNTL2__COMPLIANCE_SOS__SHIFT 0xb
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK 0xf000
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT 0xc
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK 0x1
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT 0x0
#define LINK_STATUS2__EQUALIZATION_COMPLETE_MASK 0x2
#define LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT 0x1
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK 0x4
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT 0x2
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK 0x8
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT 0x3
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK 0x10
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT 0x4
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK 0x20
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT 0x5
#define MSI_CAP_LIST__CAP_ID_MASK 0xff
#define MSI_CAP_LIST__CAP_ID__SHIFT 0x0
#define MSI_CAP_LIST__NEXT_PTR_MASK 0xff00
#define MSI_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define MSI_MSG_CNTL__MSI_EN_MASK 0x1
#define MSI_MSG_CNTL__MSI_EN__SHIFT 0x0
#define MSI_MSG_CNTL__MSI_MULTI_CAP_MASK 0xe
#define MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT 0x1
#define MSI_MSG_CNTL__MSI_MULTI_EN_MASK 0x70
#define MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT 0x4
#define MSI_MSG_CNTL__MSI_64BIT_MASK 0x80
#define MSI_MSG_CNTL__MSI_64BIT__SHIFT 0x7
#define MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK 0x100
#define MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT 0x8
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK 0xfffffffc
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT 0x2
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK 0xffffffff
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT 0x0
#define MSI_MSG_DATA_64__MSI_DATA_64_MASK 0xffff
#define MSI_MSG_DATA_64__MSI_DATA_64__SHIFT 0x0
#define MSI_MSG_DATA__MSI_DATA_MASK 0xffff
#define MSI_MSG_DATA__MSI_DATA__SHIFT 0x0
#define MSI_MASK__MSI_MASK_MASK 0xffffffff
#define MSI_MASK__MSI_MASK__SHIFT 0x0
#define MSI_PENDING__MSI_PENDING_MASK 0xffffffff
#define MSI_PENDING__MSI_PENDING__SHIFT 0x0
#define MSI_MASK_64__MSI_MASK_64_MASK 0xffffffff
#define MSI_MASK_64__MSI_MASK_64__SHIFT 0x0
#define MSI_PENDING_64__MSI_PENDING_64_MASK 0xffffffff
#define MSI_PENDING_64__MSI_PENDING_64__SHIFT 0x0
#define MSIX_CAP_LIST__CAP_ID_MASK 0xff
#define MSIX_CAP_LIST__CAP_ID__SHIFT 0x0
#define MSIX_CAP_LIST__NEXT_PTR_MASK 0xff00
#define MSIX_CAP_LIST__NEXT_PTR__SHIFT 0x8
#define MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK 0x7ff
#define MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT 0x0
#define MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK 0x4000
#define MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT 0xe
#define MSIX_MSG_CNTL__MSIX_EN_MASK 0x8000
#define MSIX_MSG_CNTL__MSIX_EN__SHIFT 0xf
#define MSIX_TABLE__MSIX_TABLE_BIR_MASK 0x7
#define MSIX_TABLE__MSIX_TABLE_BIR__SHIFT 0x0
#define MSIX_TABLE__MSIX_TABLE_OFFSET_MASK 0xfffffff8
#define MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT 0x3
#define MSIX_PBA__MSIX_PBA_BIR_MASK 0x7
#define MSIX_PBA__MSIX_PBA_BIR__SHIFT 0x0
#define MSIX_PBA__MSIX_PBA_OFFSET_MASK 0xfffffff8
#define MSIX_PBA__MSIX_PBA_OFFSET__SHIFT 0x3
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT 0x0
#define PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK 0x7
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT 0x0
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK 0x70
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT 0x4
#define PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK 0x300
#define PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT 0x8
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK 0xc00
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT 0xa
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK 0xff
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT 0x0
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK 0x1
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT 0x0
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK 0xe
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT 0x1
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x2
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x1
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK 0xff
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT 0x0
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK 0x8000
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT 0xf
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK 0x3f0000
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT 0x10
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK 0xff000000
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT 0x18
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK 0x1
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT 0x0
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK 0xfe
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT 0x1
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK 0x10000
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT 0x10
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK 0xe0000
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT 0x11
#define PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK 0x7000000
#define PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT 0x18
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK 0x80000000
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT 0x1f
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK 0x1
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT 0x0
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK 0x2
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT 0x1
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK 0xffffffff
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT 0x0
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK 0xffffffff
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT 0x0
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK 0x10
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT 0x4
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK 0x20
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT 0x5
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK 0x1000
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT 0xc
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK 0x2000
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT 0xd
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK 0x4000
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT 0xe
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK 0x8000
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT 0xf
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK 0x10000
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT 0x10
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK 0x20000
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT 0x11
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK 0x40000
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT 0x12
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK 0x80000
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT 0x13
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK 0x100000
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT 0x14
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK 0x200000
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT 0x15
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK 0x400000
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT 0x16
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK 0x800000
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT 0x17
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK 0x1000000
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT 0x18
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK 0x2000000
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT 0x19
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK 0x10
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT 0x4
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK 0x20
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT 0x5
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK 0x1000
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT 0xc
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK 0x2000
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT 0xd
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK 0x4000
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT 0xe
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK 0x8000
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT 0xf
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK 0x10000
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT 0x10
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK 0x20000
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT 0x11
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK 0x40000
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT 0x12
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK 0x80000
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT 0x13
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK 0x100000
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT 0x14
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK 0x200000
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT 0x15
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK 0x400000
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT 0x16
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK 0x800000
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT 0x17
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK 0x1000000
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT 0x18
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK 0x2000000
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT 0x19
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK 0x10
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT 0x4
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK 0x20
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT 0x5
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK 0x1000
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT 0xc
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK 0x2000
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT 0xd
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK 0x4000
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT 0xe
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK 0x8000
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT 0xf
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK 0x10000
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT 0x10
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK 0x20000
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT 0x11
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK 0x40000
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT 0x12
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK 0x80000
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT 0x13
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK 0x100000
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT 0x14
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK 0x200000
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT 0x15
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK 0x400000
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT 0x16
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK 0x800000
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT 0x17
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK 0x1000000
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT 0x18
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK 0x2000000
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT 0x19
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK 0x1
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT 0x0
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK 0x40
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT 0x6
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK 0x80
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT 0x7
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK 0x100
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT 0x8
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK 0x1000
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT 0xc
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK 0x2000
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT 0xd
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK 0x4000
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT 0xe
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK 0x8000
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT 0xf
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK 0x1
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT 0x0
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK 0x40
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT 0x6
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK 0x80
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT 0x7
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK 0x100
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT 0x8
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK 0x1000
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT 0xc
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK 0x2000
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT 0xd
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK 0x4000
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT 0xe
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK 0x8000
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT 0xf
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK 0x1f
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT 0x0
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK 0x20
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT 0x5
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK 0x40
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT 0x6
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK 0x80
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT 0x7
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK 0x100
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT 0x8
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK 0x200
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT 0x9
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK 0x400
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT 0xa
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK 0x800
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT 0xb
#define PCIE_HDR_LOG0__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG0__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG1__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG1__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG2__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG2__TLP_HDR__SHIFT 0x0
#define PCIE_HDR_LOG3__TLP_HDR_MASK 0xffffffff
#define PCIE_HDR_LOG3__TLP_HDR__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT 0x0
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK 0xffffffff
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT 0x0
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR1_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR1_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR1_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR1_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR2_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR2_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR2_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR2_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR3_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR3_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR3_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR3_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR4_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR4_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR4_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR4_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR5_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR5_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR5_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR5_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK 0xfffff0
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT 0x4
#define PCIE_BAR6_CNTL__BAR_INDEX_MASK 0x7
#define PCIE_BAR6_CNTL__BAR_INDEX__SHIFT 0x0
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK 0xe0
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT 0x5
#define PCIE_BAR6_CNTL__BAR_SIZE_MASK 0x1f00
#define PCIE_BAR6_CNTL__BAR_SIZE__SHIFT 0x8
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK 0xff
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT 0x0
#define PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK 0xff
#define PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT 0x0
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK 0x300
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT 0x8
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK 0x1c00
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT 0xa
#define PCIE_PWR_BUDGET_DATA__PM_STATE_MASK 0x6000
#define PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT 0xd
#define PCIE_PWR_BUDGET_DATA__TYPE_MASK 0x38000
#define PCIE_PWR_BUDGET_DATA__TYPE__SHIFT 0xf
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK 0x1c0000
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT 0x12
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK 0x1
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT 0x0
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_DPA_CAP__SUBSTATE_MAX_MASK 0x1f
#define PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT 0x0
#define PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK 0x300
#define PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT 0x8
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK 0x3000
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT 0xc
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK 0xff0000
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT 0x10
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK 0xff000000
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT 0x18
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK 0xff
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT 0x0
#define PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK 0x1f
#define PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT 0x0
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK 0x100
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT 0x8
#define PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK 0x1f
#define PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK 0x1
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT 0x0
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK 0x2
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT 0x1
#define PCIE_LINK_CNTL3__RESERVED_MASK 0xfffffffc
#define PCIE_LINK_CNTL3__RESERVED__SHIFT 0x2
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK 0xffff
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT 0x0
#define PCIE_LANE_ERROR_STATUS__RESERVED_MASK 0xffff0000
#define PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT 0x10
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK 0xf
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT 0x0
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK 0x70
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT 0x4
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK 0xf00
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT 0x8
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK 0x7000
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT 0xc
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK 0x8000
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT 0xf
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_ACS_CAP__SOURCE_VALIDATION_MASK 0x1
#define PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT 0x0
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK 0x2
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT 0x1
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK 0x4
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT 0x2
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK 0x8
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT 0x3
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK 0x10
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT 0x4
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK 0x20
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT 0x5
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK 0x40
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT 0x6
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK 0xff00
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT 0x8
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK 0x1
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT 0x0
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK 0x2
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT 0x1
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK 0x4
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT 0x2
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK 0x8
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT 0x3
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK 0x10
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT 0x4
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK 0x20
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT 0x5
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK 0x40
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT 0x6
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK 0x1f
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT 0x0
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK 0x20
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT 0x5
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK 0x40
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT 0x6
#define PCIE_ATS_CNTL__STU_MASK 0x1f
#define PCIE_ATS_CNTL__STU__SHIFT 0x0
#define PCIE_ATS_CNTL__ATC_ENABLE_MASK 0x8000
#define PCIE_ATS_CNTL__ATC_ENABLE__SHIFT 0xf
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK 0x1
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT 0x0
#define PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK 0x2
#define PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT 0x1
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK 0x1
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT 0x0
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK 0x2
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT 0x1
#define PCIE_PAGE_REQ_STATUS__STOPPED_MASK 0x100
#define PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT 0x8
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK 0x8000
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT 0xf
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK 0xffffffff
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT 0x0
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK 0xffffffff
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT 0x0
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK 0x2
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT 0x1
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK 0x4
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT 0x2
#define PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK 0x1f00
#define PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT 0x8
#define PCIE_PASID_CNTL__PASID_ENABLE_MASK 0x1
#define PCIE_PASID_CNTL__PASID_ENABLE__SHIFT 0x0
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK 0x2
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT 0x1
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK 0x4
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT 0x2
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED_MASK 0x1
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED__SHIFT 0x0
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED_MASK 0x2
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED__SHIFT 0x1
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED_MASK 0x4
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED__SHIFT 0x2
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED_MASK 0x100
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED__SHIFT 0x8
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION_MASK 0x600
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION__SHIFT 0x9
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE_MASK 0x7ff0000
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE__SHIFT 0x10
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL_MASK 0x7
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL__SHIFT 0x0
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN_MASK 0x300
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN__SHIFT 0x8
#define PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_MC_CAP__MC_MAX_GROUP_MASK 0x3f
#define PCIE_MC_CAP__MC_MAX_GROUP__SHIFT 0x0
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK 0x3f00
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT 0x8
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK 0x8000
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT 0xf
#define PCIE_MC_CNTL__MC_NUM_GROUP_MASK 0x3f
#define PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT 0x0
#define PCIE_MC_CNTL__MC_ENABLE_MASK 0x8000
#define PCIE_MC_CNTL__MC_ENABLE__SHIFT 0xf
#define PCIE_MC_ADDR0__MC_INDEX_POS_MASK 0x3f
#define PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT 0x0
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK 0xfffff000
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT 0xc
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK 0xffffffff
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT 0x0
#define PCIE_MC_RCV0__MC_RECEIVE_0_MASK 0xffffffff
#define PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT 0x0
#define PCIE_MC_RCV1__MC_RECEIVE_1_MASK 0xffffffff
#define PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT 0x0
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK 0xffffffff
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT 0x0
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK 0xffffffff
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT 0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK 0xffffffff
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT 0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK 0xffffffff
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT 0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK 0x3ff
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT 0x0
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK 0x1c00
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT 0xa
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK 0x3ff0000
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT 0x10
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK 0x1c000000
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT 0x1a
#define PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK 0x1
#define PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT 0x0
#define PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK 0x2
#define PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT 0x1
#define PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK 0xff00
#define PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT 0x8
#define PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK 0x1
#define PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT 0x0
#define PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK 0x2
#define PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT 0x1
#define PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK 0x70
#define PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT 0x4
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_ID_MASK 0xffff
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_ID__SHIFT 0x0
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_VER_MASK 0xf0000
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_VER__SHIFT 0x10
#define PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR_MASK 0xfff00000
#define PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR__SHIFT 0x14
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP_MASK 0x1
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP__SHIFT 0x0
#define PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED_MASK 0x2
#define PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED__SHIFT 0x1
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM_MASK 0xffe00000
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM__SHIFT 0x15
#define PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE_MASK 0x1
#define PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE__SHIFT 0x0
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE_MASK 0x2
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE__SHIFT 0x1
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE_MASK 0x4
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE__SHIFT 0x2
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MSE_MASK 0x8
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MSE__SHIFT 0x3
#define PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY_MASK 0x10
#define PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY__SHIFT 0x4
#define PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS_MASK 0x1
#define PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS__SHIFT 0x0
#define PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS_MASK 0xffff
#define PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS__SHIFT 0x0
#define PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS_MASK 0xffff
#define PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS__SHIFT 0x0
#define PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS_MASK 0xffff
#define PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS__SHIFT 0x0
#define PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK_MASK 0xff
#define PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK__SHIFT 0x0
#define PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET_MASK 0xffff
#define PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET__SHIFT 0x0
#define PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE_MASK 0xffff
#define PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE__SHIFT 0x0
#define PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID_MASK 0xffff
#define PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID__SHIFT 0x0
#define PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE_MASK 0xffffffff
#define PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE__SHIFT 0x0
#define PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE_MASK 0xffffffff
#define PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR_MASK 0xffffffff
#define PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR__SHIFT 0x0
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET_MASK 0xffffffff
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV_MASK 0xf0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH_MASK 0xfff00000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH__SHIFT 0x14
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN_MASK 0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__CMD_CONTROL_MASK 0xff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__CMD_CONTROL__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__FCN_ID_MASK 0xff00
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__FCN_ID__SHIFT 0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__NXT_FCN_ID_MASK 0xff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_CTRL_N_FUNC__NXT_FCN_ID__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_STATUS__CMD_STATUS_MASK 0xff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CMD_STATUS__CMD_STATUS__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR_MASK 0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_NOTIFICATION__RESET_NOTIFICATION_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_NOTIFICATION__RESET_NOTIFICATION__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VM_INIT_STATUS__VM_INIT_STATUS_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VM_INIT_STATUS__VM_INIT_STATUS__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CNTXT_SIZE_MASK 0x7f
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CNTXT_SIZE__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC_MASK 0x80
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC__SHIFT 0x7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CNTXT_OFFSET_MASK 0xfffc0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CNTXT_OFFSET__SHIFT 0x12
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VM_BUSY_STATUS__VM_BUSY_STATUS_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VM_BUSY_STATUS__VM_BUSY_STATUS__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GPU_INFO_OFFSET_MASK 0xff00
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GPU_INFO_OFFSET__SHIFT 0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__AUTO_SCH_OFFSET_MASK 0xff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__AUTO_SCH_OFFSET__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__DISP_OFFSET_MASK 0xff000000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__DISP_OFFSET__SHIFT 0x18
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__FB_OFFSET_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__FB_OFFSET__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__FB_SIZE_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__FB_SIZE__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GPU_IDLE_LAT__GPU_IDLE_LATENCY_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GPU_IDLE_LAT__GPU_IDLE_LATENCY__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE0__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE0__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE0__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE0__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE1__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE1__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE1__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE1__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE2__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE2__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE2__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE2__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE3__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE3__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE3__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE3__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE4__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE4__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE4__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE4__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE5__LOWER_MASK 0xffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE5__LOWER__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE5__UPPER_MASK 0xffff0000
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_MMIO_MAP_RANGE5__UPPER__SHIFT 0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_0__DATA_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_0__DATA__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_1__DATA_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_1__DATA__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_2__DATA_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_2__DATA__SHIFT 0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_3__DATA_MASK 0xffffffff
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SCH_3__DATA__SHIFT 0x0
#define PCIE_INDEX__PCIE_INDEX_MASK 0xffffffff
#define PCIE_INDEX__PCIE_INDEX__SHIFT 0x0
#define PCIE_DATA__PCIE_DATA_MASK 0xffffffff
#define PCIE_DATA__PCIE_DATA__SHIFT 0x0
#define PCIE_INDEX_2__PCIE_INDEX_MASK 0xffffffff
#define PCIE_INDEX_2__PCIE_INDEX__SHIFT 0x0
#define PCIE_DATA_2__PCIE_DATA_MASK 0xffffffff
#define PCIE_DATA_2__PCIE_DATA__SHIFT 0x0
#define PCIE_HOLD_TRAINING_A__HOLD_TRAINING_A_MASK 0x1
#define PCIE_HOLD_TRAINING_A__HOLD_TRAINING_A__SHIFT 0x0
#define LNCNT_CONTROL__CFG_LNC_WINDOW_EN0_MASK 0x1
#define LNCNT_CONTROL__CFG_LNC_WINDOW_EN0__SHIFT 0x0
#define LNCNT_CONTROL__CFG_LNC_BW_CNT_EN1_MASK 0x2
#define LNCNT_CONTROL__CFG_LNC_BW_CNT_EN1__SHIFT 0x1
#define LNCNT_CONTROL__CFG_LNC_CMN_CNT_EN2_MASK 0x4
#define LNCNT_CONTROL__CFG_LNC_CMN_CNT_EN2__SHIFT 0x2
#define LNCNT_CONTROL__CFG_LNC_OVRD_EN3_MASK 0x8
#define LNCNT_CONTROL__CFG_LNC_OVRD_EN3__SHIFT 0x3
#define LNCNT_CONTROL__CFG_LNC_OVRD_VAL4_MASK 0x10
#define LNCNT_CONTROL__CFG_LNC_OVRD_VAL4__SHIFT 0x4
#define CFG_LNC_WINDOW__CFG_LNC_WINDOW0_MASK 0xffffff
#define CFG_LNC_WINDOW__CFG_LNC_WINDOW0__SHIFT 0x0
#define LNCNT_QUAN_THRD__CFG_LNC_BW_QUAN_THRD0_MASK 0x7
#define LNCNT_QUAN_THRD__CFG_LNC_BW_QUAN_THRD0__SHIFT 0x0
#define LNCNT_QUAN_THRD__CFG_LNC_CMN_QUAN_THRD4_MASK 0x70
#define LNCNT_QUAN_THRD__CFG_LNC_CMN_QUAN_THRD4__SHIFT 0x4
#define LNCNT_WEIGHT__CFG_LNC_BW_WEIGHT0_MASK 0xffff
#define LNCNT_WEIGHT__CFG_LNC_BW_WEIGHT0__SHIFT 0x0
#define LNCNT_WEIGHT__CFG_LNC_CMN_WEIGHT16_MASK 0xffff0000
#define LNCNT_WEIGHT__CFG_LNC_CMN_WEIGHT16__SHIFT 0x10
#define LNC_TOTAL_WACC__LNC_TOTAL_WACC_MASK 0xffffffff
#define LNC_TOTAL_WACC__LNC_TOTAL_WACC__SHIFT 0x0
#define LNC_BW_WACC__LNC_BW_WACC_MASK 0xffffffff
#define LNC_BW_WACC__LNC_BW_WACC__SHIFT 0x0
#define LNC_CMN_WACC__LNC_CMN_WACC_MASK 0xffffffff
#define LNC_CMN_WACC__LNC_CMN_WACC__SHIFT 0x0
#define PCIE_EFUSE__PCIE_EFUSE_VALID_MASK 0x2
#define PCIE_EFUSE__PCIE_EFUSE_VALID__SHIFT 0x1
#define PCIE_EFUSE__PPHY_EFUSE_VALID_MASK 0x4
#define PCIE_EFUSE__PPHY_EFUSE_VALID__SHIFT 0x2
#define PCIE_EFUSE__SPARE_5_3_EFUSE0_MASK 0x38
#define PCIE_EFUSE__SPARE_5_3_EFUSE0__SHIFT 0x3
#define PCIE_EFUSE__ISTRAP_ARBEN0_MASK 0x40
#define PCIE_EFUSE__ISTRAP_ARBEN0__SHIFT 0x6
#define PCIE_EFUSE__SPARE_26_7_EFUSE0_MASK 0x7ffff80
#define PCIE_EFUSE__SPARE_26_7_EFUSE0__SHIFT 0x7
#define PCIE_EFUSE__CHIP_BIF_MODE_MASK 0x8000000
#define PCIE_EFUSE__CHIP_BIF_MODE__SHIFT 0x1b
#define PCIE_EFUSE__SPARE_31_28_EFUSE0_MASK 0xf0000000
#define PCIE_EFUSE__SPARE_31_28_EFUSE0__SHIFT 0x1c
#define PCIE_EFUSE2__SPARE_31_1_EFUSE2_MASK 0xfffffffe
#define PCIE_EFUSE2__SPARE_31_1_EFUSE2__SHIFT 0x1
#define PCIE_EFUSE3__STRAP_CEC_ID_MASK 0x1fffe
#define PCIE_EFUSE3__STRAP_CEC_ID__SHIFT 0x1
#define PCIE_EFUSE3__STRAP_BIF_KILL_GEN3_MASK 0x20000
#define PCIE_EFUSE3__STRAP_BIF_KILL_GEN3__SHIFT 0x11
#define PCIE_EFUSE3__SPARE_14_PCIEFUSE3_MASK 0xfffc0000
#define PCIE_EFUSE3__SPARE_14_PCIEFUSE3__SHIFT 0x12
#define PCIE_EFUSE4__CC_WRITE_DISABLE_MASK 0x1
#define PCIE_EFUSE4__CC_WRITE_DISABLE__SHIFT 0x0
#define PCIE_EFUSE4__SPARE_3_PCIEFUSE4_MASK 0xe
#define PCIE_EFUSE4__SPARE_3_PCIEFUSE4__SHIFT 0x1
#define PCIE_EFUSE4__STRAP_BIF_F0_DEVICE_ID_MASK 0xffff0
#define PCIE_EFUSE4__STRAP_BIF_F0_DEVICE_ID__SHIFT 0x4
#define PCIE_EFUSE4__STRAP_BIF_F0_MAJOR_REV_ID_MASK 0xf00000
#define PCIE_EFUSE4__STRAP_BIF_F0_MAJOR_REV_ID__SHIFT 0x14
#define PCIE_EFUSE4__STRAP_BIF_F0_MINOR_REV_ID_MASK 0xf000000
#define PCIE_EFUSE4__STRAP_BIF_F0_MINOR_REV_ID__SHIFT 0x18
#define PCIE_EFUSE4__STRAP_BIF_ATI_REV_ID_MASK 0xf0000000
#define PCIE_EFUSE4__STRAP_BIF_ATI_REV_ID__SHIFT 0x1c
#define PCIE_EFUSE5__STRAP_AZALIA_DID_MASK 0x1fffe
#define PCIE_EFUSE5__STRAP_AZALIA_DID__SHIFT 0x1
#define PCIE_EFUSE5__SPARE_16_PCIEFUSE5_MASK 0xfffe0000
#define PCIE_EFUSE5__SPARE_16_PCIEFUSE5__SHIFT 0x11
#define PCIE_EFUSE6__STRAP_BIF_F0_SUPPORTED_PAGE_SIZES_MASK 0x1fffe
#define PCIE_EFUSE6__STRAP_BIF_F0_SUPPORTED_PAGE_SIZES__SHIFT 0x1
#define PCIE_EFUSE6__SPARE_15_PCIEFUSE6_MASK 0xfffe0000
#define PCIE_EFUSE6__SPARE_15_PCIEFUSE6__SHIFT 0x11
#define PCIE_EFUSE7__STRAP_BIF_F0_SRIOV_VF_DEVICE_ID_MASK 0x1fffe
#define PCIE_EFUSE7__STRAP_BIF_F0_SRIOV_VF_DEVICE_ID__SHIFT 0x1
#define PCIE_EFUSE7__SPARE_15_PCIEFUSE7_MASK 0xfffe0000
#define PCIE_EFUSE7__SPARE_15_PCIEFUSE7__SHIFT 0x11
#define PCIE_WRAP_SCRATCH1__PCIE_WRAP_SCRATCH1_MASK 0xffffffff
#define PCIE_WRAP_SCRATCH1__PCIE_WRAP_SCRATCH1__SHIFT 0x0
#define PCIE_WRAP_SCRATCH2__PCIE_WRAP_SCRATCH2_MASK 0xffffffff
#define PCIE_WRAP_SCRATCH2__PCIE_WRAP_SCRATCH2__SHIFT 0x0
#define PCIE_WRAP_REG_TARG_MISC__CLKEN_MASK_MASK 0x1
#define PCIE_WRAP_REG_TARG_MISC__CLKEN_MASK__SHIFT 0x0
#define PCIE_WRAP_DTM_MISC__DTM_BULKPHY_FREQDIV_OVERRIDE_MASK 0x1
#define PCIE_WRAP_DTM_MISC__DTM_BULKPHY_FREQDIV_OVERRIDE__SHIFT 0x0
#define PCIE_WRAP_TURNAROUND_DAISYCHAIN__END_BIFCORE_REGISTER_DAISYCHAIN_MASK 0x1
#define PCIE_WRAP_TURNAROUND_DAISYCHAIN__END_BIFCORE_REGISTER_DAISYCHAIN__SHIFT 0x0
#define PCIE_WRAP_TURNAROUND_DAISYCHAIN__END_WRAPPER_REGISTER_DAISYCHAIN_MASK 0x2
#define PCIE_WRAP_TURNAROUND_DAISYCHAIN__END_WRAPPER_REGISTER_DAISYCHAIN__SHIFT 0x1
#define PCIE_WRAP_MISC__STRAP_BIF_HOLD_TRAINING_STICKY_MASK 0x2
#define PCIE_WRAP_MISC__STRAP_BIF_HOLD_TRAINING_STICKY__SHIFT 0x1
#define PCIE_WRAP_MISC__STRAP_BIF_QUICKSIM_START_MASK 0x4
#define PCIE_WRAP_MISC__STRAP_BIF_QUICKSIM_START__SHIFT 0x2
#define PCIE_WRAP_PIF_MISC__DTM_PIF_DELAY_FI_MASK 0x7
#define PCIE_WRAP_PIF_MISC__DTM_PIF_DELAY_FI__SHIFT 0x0
#define PCIE_WRAP_PIF_MISC__DTM_PIF_DELAY_DI_MASK 0x70
#define PCIE_WRAP_PIF_MISC__DTM_PIF_DELAY_DI__SHIFT 0x4
#define PCIE_WRAP_PIF_MISC__DTM_PIF_ATSEL_FI_MASK 0x80
#define PCIE_WRAP_PIF_MISC__DTM_PIF_ATSEL_FI__SHIFT 0x7
#define PCIE_WRAP_PIF_MISC__DTM_PIF_ATSEL_DI_MASK 0x100
#define PCIE_WRAP_PIF_MISC__DTM_PIF_ATSEL_DI__SHIFT 0x8
#define PCIE_RXDET_OVERRIDE__RxDetOvrVal_MASK 0xffff
#define PCIE_RXDET_OVERRIDE__RxDetOvrVal__SHIFT 0x0
#define PCIE_RXDET_OVERRIDE__RxDetOvrEn_MASK 0x10000
#define PCIE_RXDET_OVERRIDE__RxDetOvrEn__SHIFT 0x10
#define REG_ADAPT_pciecore0_CONTROL__ACCESS_MODE_pciecore0_MASK 0x1
#define REG_ADAPT_pciecore0_CONTROL__ACCESS_MODE_pciecore0__SHIFT 0x0
#define REG_ADAPT_pwregt_CONTROL__ACCESS_MODE_pwregt_MASK 0x1
#define REG_ADAPT_pwregt_CONTROL__ACCESS_MODE_pwregt__SHIFT 0x0
#define REG_ADAPT_pwregr_CONTROL__ACCESS_MODE_pwregr_MASK 0x1
#define REG_ADAPT_pwregr_CONTROL__ACCESS_MODE_pwregr__SHIFT 0x0
#define REG_ADAPT_pif0_CONTROL__ACCESS_MODE_pif0_MASK 0x1
#define REG_ADAPT_pif0_CONTROL__ACCESS_MODE_pif0__SHIFT 0x0
#define PCIE_RESERVED__PCIE_RESERVED_MASK 0xffffffff
#define PCIE_RESERVED__PCIE_RESERVED__SHIFT 0x0
#define PCIE_SCRATCH__PCIE_SCRATCH_MASK 0xffffffff
#define PCIE_SCRATCH__PCIE_SCRATCH__SHIFT 0x0
#define PCIE_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PCIE_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PCIE_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PCIE_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PCIE_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PCIE_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PCIE_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PCIE_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PCIE_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PCIE_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PCIE_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PCIE_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PCIE_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PCIE_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PCIE_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PCIE_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PCIE_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PCIE_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PCIE_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PCIE_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PCIE_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PCIE_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PCIE_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PCIE_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PCIE_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PCIE_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PCIE_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PCIE_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PCIE_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PCIE_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PCIE_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PCIE_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PCIE_RX_NUM_NAK__RX_NUM_NAK_MASK 0xffffffff
#define PCIE_RX_NUM_NAK__RX_NUM_NAK__SHIFT 0x0
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED_MASK 0xffffffff
#define PCIE_RX_NUM_NAK_GENERATED__RX_NUM_NAK_GENERATED__SHIFT 0x0
#define PCIE_CNTL__HWINIT_WR_LOCK_MASK 0x1
#define PCIE_CNTL__HWINIT_WR_LOCK__SHIFT 0x0
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL_MASK 0xe
#define PCIE_CNTL__LC_HOT_PLUG_DELAY_SEL__SHIFT 0x1
#define PCIE_CNTL__UR_ERR_REPORT_DIS_MASK 0x80
#define PCIE_CNTL__UR_ERR_REPORT_DIS__SHIFT 0x7
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS_MASK 0x100
#define PCIE_CNTL__PCIE_MALFORM_ATOMIC_OPS__SHIFT 0x8
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE_MASK 0x200
#define PCIE_CNTL__PCIE_HT_NP_MEM_WRITE__SHIFT 0x9
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE_MASK 0x1c00
#define PCIE_CNTL__RX_SB_ADJ_PAYLOAD_SIZE__SHIFT 0xa
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS_MASK 0x8000
#define PCIE_CNTL__RX_RCB_ATS_UC_DIS__SHIFT 0xf
#define PCIE_CNTL__RX_RCB_REORDER_EN_MASK 0x10000
#define PCIE_CNTL__RX_RCB_REORDER_EN__SHIFT 0x10
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS_MASK 0x20000
#define PCIE_CNTL__RX_RCB_INVALID_SIZE_DIS__SHIFT 0x11
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS_MASK 0x40000
#define PCIE_CNTL__RX_RCB_UNEXP_CPL_DIS__SHIFT 0x12
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE_MASK 0x80000
#define PCIE_CNTL__RX_RCB_CPL_TIMEOUT_TEST_MODE__SHIFT 0x13
#define PCIE_CNTL__RX_RCB_WRONG_PREFIX_DIS_MASK 0x100000
#define PCIE_CNTL__RX_RCB_WRONG_PREFIX_DIS__SHIFT 0x14
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS_MASK 0x200000
#define PCIE_CNTL__RX_RCB_WRONG_ATTR_DIS__SHIFT 0x15
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS_MASK 0x400000
#define PCIE_CNTL__RX_RCB_WRONG_FUNCNUM_DIS__SHIFT 0x16
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS_MASK 0x800000
#define PCIE_CNTL__RX_ATS_TRAN_CPL_SPLIT_DIS__SHIFT 0x17
#define PCIE_CNTL__TX_CPL_DEBUG_MASK 0x3f000000
#define PCIE_CNTL__TX_CPL_DEBUG__SHIFT 0x18
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR_MASK 0x40000000
#define PCIE_CNTL__RX_IGNORE_LTR_MSG_UR__SHIFT 0x1e
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN_MASK 0x80000000
#define PCIE_CNTL__RX_CPL_POSTED_REQ_ORD_EN__SHIFT 0x1f
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY_MASK 0xf
#define PCIE_CONFIG_CNTL__DYN_CLK_LATENCY__SHIFT 0x0
#define PCIE_CONFIG_CNTL__CI_MAX_PAYLOAD_SIZE_MODE_MASK 0x10000
#define PCIE_CONFIG_CNTL__CI_MAX_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_PAYLOAD_SIZE_MASK 0xe0000
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_PAYLOAD_SIZE__SHIFT 0x11
#define PCIE_CONFIG_CNTL__CI_MAX_READ_REQUEST_SIZE_MODE_MASK 0x100000
#define PCIE_CONFIG_CNTL__CI_MAX_READ_REQUEST_SIZE_MODE__SHIFT 0x14
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_READ_REQUEST_SIZE_MASK 0xe00000
#define PCIE_CONFIG_CNTL__CI_PRIV_MAX_READ_REQUEST_SIZE__SHIFT 0x15
#define PCIE_CONFIG_CNTL__CI_MAX_READ_SAFE_MODE_MASK 0x1000000
#define PCIE_CONFIG_CNTL__CI_MAX_READ_SAFE_MODE__SHIFT 0x18
#define PCIE_CONFIG_CNTL__CI_EXTENDED_TAG_EN_OVERRIDE_MASK 0x6000000
#define PCIE_CONFIG_CNTL__CI_EXTENDED_TAG_EN_OVERRIDE__SHIFT 0x19
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN_MASK 0xff
#define PCIE_DEBUG_CNTL__DEBUG_PORT_EN__SHIFT 0x0
#define PCIE_DEBUG_CNTL__DEBUG_SELECT_MASK 0x100
#define PCIE_DEBUG_CNTL__DEBUG_SELECT__SHIFT 0x8
#define PCIE_DEBUG_CNTL__DEBUG_LANE_EN_MASK 0xffff0000
#define PCIE_DEBUG_CNTL__DEBUG_LANE_EN__SHIFT 0x10
#define PCIE_INT_CNTL__CORR_ERR_INT_EN_MASK 0x1
#define PCIE_INT_CNTL__CORR_ERR_INT_EN__SHIFT 0x0
#define PCIE_INT_CNTL__NON_FATAL_ERR_INT_EN_MASK 0x2
#define PCIE_INT_CNTL__NON_FATAL_ERR_INT_EN__SHIFT 0x1
#define PCIE_INT_CNTL__FATAL_ERR_INT_EN_MASK 0x4
#define PCIE_INT_CNTL__FATAL_ERR_INT_EN__SHIFT 0x2
#define PCIE_INT_CNTL__USR_DETECTED_INT_EN_MASK 0x8
#define PCIE_INT_CNTL__USR_DETECTED_INT_EN__SHIFT 0x3
#define PCIE_INT_CNTL__MISC_ERR_INT_EN_MASK 0x10
#define PCIE_INT_CNTL__MISC_ERR_INT_EN__SHIFT 0x4
#define PCIE_INT_CNTL__POWER_STATE_CHG_INT_EN_MASK 0x40
#define PCIE_INT_CNTL__POWER_STATE_CHG_INT_EN__SHIFT 0x6
#define PCIE_INT_CNTL__LINK_BW_INT_EN_MASK 0x80
#define PCIE_INT_CNTL__LINK_BW_INT_EN__SHIFT 0x7
#define PCIE_INT_CNTL__QUIESCE_RCVD_INT_EN_MASK 0x100
#define PCIE_INT_CNTL__QUIESCE_RCVD_INT_EN__SHIFT 0x8
#define PCIE_INT_STATUS__CORR_ERR_INT_STATUS_MASK 0x1
#define PCIE_INT_STATUS__CORR_ERR_INT_STATUS__SHIFT 0x0
#define PCIE_INT_STATUS__NON_FATAL_ERR_INT_STATUS_MASK 0x2
#define PCIE_INT_STATUS__NON_FATAL_ERR_INT_STATUS__SHIFT 0x1
#define PCIE_INT_STATUS__FATAL_ERR_INT_STATUS_MASK 0x4
#define PCIE_INT_STATUS__FATAL_ERR_INT_STATUS__SHIFT 0x2
#define PCIE_INT_STATUS__USR_DETECTED_INT_STATUS_MASK 0x8
#define PCIE_INT_STATUS__USR_DETECTED_INT_STATUS__SHIFT 0x3
#define PCIE_INT_STATUS__MISC_ERR_INT_STATUS_MASK 0x10
#define PCIE_INT_STATUS__MISC_ERR_INT_STATUS__SHIFT 0x4
#define PCIE_INT_STATUS__POWER_STATE_CHG_INT_STATUS_MASK 0x40
#define PCIE_INT_STATUS__POWER_STATE_CHG_INT_STATUS__SHIFT 0x6
#define PCIE_INT_STATUS__LINK_BW_INT_STATUS_MASK 0x80
#define PCIE_INT_STATUS__LINK_BW_INT_STATUS__SHIFT 0x7
#define PCIE_INT_STATUS__QUIESCE_RCVD_INT_STATUS_MASK 0x100
#define PCIE_INT_STATUS__QUIESCE_RCVD_INT_STATUS__SHIFT 0x8
#define PCIE_CNTL2__TX_ARB_ROUND_ROBIN_EN_MASK 0x1
#define PCIE_CNTL2__TX_ARB_ROUND_ROBIN_EN__SHIFT 0x0
#define PCIE_CNTL2__TX_ARB_SLV_LIMIT_MASK 0x3e
#define PCIE_CNTL2__TX_ARB_SLV_LIMIT__SHIFT 0x1
#define PCIE_CNTL2__TX_ARB_MST_LIMIT_MASK 0x7c0
#define PCIE_CNTL2__TX_ARB_MST_LIMIT__SHIFT 0x6
#define PCIE_CNTL2__TX_BLOCK_TLP_ON_PM_DIS_MASK 0x800
#define PCIE_CNTL2__TX_BLOCK_TLP_ON_PM_DIS__SHIFT 0xb
#define PCIE_CNTL2__TX_NP_MEM_WRITE_SWP_ENCODING_MASK 0x1000
#define PCIE_CNTL2__TX_NP_MEM_WRITE_SWP_ENCODING__SHIFT 0xc
#define PCIE_CNTL2__TX_ATOMIC_OPS_DISABLE_MASK 0x2000
#define PCIE_CNTL2__TX_ATOMIC_OPS_DISABLE__SHIFT 0xd
#define PCIE_CNTL2__TX_ATOMIC_ORDERING_DIS_MASK 0x4000
#define PCIE_CNTL2__TX_ATOMIC_ORDERING_DIS__SHIFT 0xe
#define PCIE_CNTL2__SLV_MEM_LS_EN_MASK 0x10000
#define PCIE_CNTL2__SLV_MEM_LS_EN__SHIFT 0x10
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN_MASK 0x20000
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_LS_EN__SHIFT 0x11
#define PCIE_CNTL2__MST_MEM_LS_EN_MASK 0x40000
#define PCIE_CNTL2__MST_MEM_LS_EN__SHIFT 0x12
#define PCIE_CNTL2__REPLAY_MEM_LS_EN_MASK 0x80000
#define PCIE_CNTL2__REPLAY_MEM_LS_EN__SHIFT 0x13
#define PCIE_CNTL2__SLV_MEM_SD_EN_MASK 0x100000
#define PCIE_CNTL2__SLV_MEM_SD_EN__SHIFT 0x14
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN_MASK 0x200000
#define PCIE_CNTL2__SLV_MEM_AGGRESSIVE_SD_EN__SHIFT 0x15
#define PCIE_CNTL2__MST_MEM_SD_EN_MASK 0x400000
#define PCIE_CNTL2__MST_MEM_SD_EN__SHIFT 0x16
#define PCIE_CNTL2__REPLAY_MEM_SD_EN_MASK 0x800000
#define PCIE_CNTL2__REPLAY_MEM_SD_EN__SHIFT 0x17
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING_MASK 0x1f000000
#define PCIE_CNTL2__RX_NP_MEM_WRITE_ENCODING__SHIFT 0x18
#define PCIE_CNTL2__SLV_MEM_DS_EN_MASK 0x20000000
#define PCIE_CNTL2__SLV_MEM_DS_EN__SHIFT 0x1d
#define PCIE_CNTL2__MST_MEM_DS_EN_MASK 0x40000000
#define PCIE_CNTL2__MST_MEM_DS_EN__SHIFT 0x1e
#define PCIE_CNTL2__REPLAY_MEM_DS_EN_MASK 0x80000000
#define PCIE_CNTL2__REPLAY_MEM_DS_EN__SHIFT 0x1f
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR_MASK 0x1
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVALIDPASID_UR__SHIFT 0x0
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR_MASK 0x2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMRD_UR__SHIFT 0x1
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR_MASK 0x4
#define PCIE_RX_CNTL2__RX_IGNORE_EP_TRANSMWR_UR__SHIFT 0x2
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR_MASK 0x8
#define PCIE_RX_CNTL2__RX_IGNORE_EP_ATSTRANSREQ_UR__SHIFT 0x3
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR_MASK 0x10
#define PCIE_RX_CNTL2__RX_IGNORE_EP_PAGEREQMSG_UR__SHIFT 0x4
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR_MASK 0x20
#define PCIE_RX_CNTL2__RX_IGNORE_EP_INVCPL_UR__SHIFT 0x5
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN_MASK 0x100
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_EN__SHIFT 0x8
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE_MASK 0xe00
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_SCALE__SHIFT 0x9
#define PCIE_RX_CNTL2__SLVCPL_MEM_LS_EN_MASK 0x1000
#define PCIE_RX_CNTL2__SLVCPL_MEM_LS_EN__SHIFT 0xc
#define PCIE_RX_CNTL2__SLVCPL_MEM_SD_EN_MASK 0x2000
#define PCIE_RX_CNTL2__SLVCPL_MEM_SD_EN__SHIFT 0xd
#define PCIE_RX_CNTL2__SLVCPL_MEM_DS_EN_MASK 0x4000
#define PCIE_RX_CNTL2__SLVCPL_MEM_DS_EN__SHIFT 0xe
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT_MASK 0x3ff0000
#define PCIE_RX_CNTL2__RX_RCB_LATENCY_MAX_COUNT__SHIFT 0x10
#define PCIE_RX_CNTL2__FLR_EXTEND_MODE_MASK 0x70000000
#define PCIE_RX_CNTL2__FLR_EXTEND_MODE__SHIFT 0x1c
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P_MASK 0x3
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_P__SHIFT 0x0
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP_MASK 0xc
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_NP__SHIFT 0x2
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL_MASK 0x30
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_IDO_OVERRIDE_CPL__SHIFT 0x4
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P_MASK 0xc0
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_P__SHIFT 0x6
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP_MASK 0x300
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_RO_OVERRIDE_NP__SHIFT 0x8
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P_MASK 0xc00
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_P__SHIFT 0xa
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP_MASK 0x3000
#define PCIE_TX_F0_ATTR_CNTL__TX_F0_SNR_OVERRIDE_NP__SHIFT 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_P_MASK 0x3
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_P__SHIFT 0x0
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_NP_MASK 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_NP__SHIFT 0x2
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_CPL_MASK 0x30
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_IDO_OVERRIDE_CPL__SHIFT 0x4
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_P_MASK 0xc0
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_P__SHIFT 0x6
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_NP_MASK 0x300
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_RO_OVERRIDE_NP__SHIFT 0x8
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_P_MASK 0xc00
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_P__SHIFT 0xa
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_NP_MASK 0x3000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F1_SNR_OVERRIDE_NP__SHIFT 0xc
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_P_MASK 0x30000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_P__SHIFT 0x10
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_NP_MASK 0xc0000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_NP__SHIFT 0x12
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_CPL_MASK 0x300000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_IDO_OVERRIDE_CPL__SHIFT 0x14
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_P_MASK 0xc00000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_P__SHIFT 0x16
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_NP_MASK 0x3000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_RO_OVERRIDE_NP__SHIFT 0x18
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_P_MASK 0xc000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_P__SHIFT 0x1a
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_NP_MASK 0x30000000
#define PCIE_TX_F1_F2_ATTR_CNTL__TX_F2_SNR_OVERRIDE_NP__SHIFT 0x1c
#define PCIE_CI_CNTL__CI_SLAVE_SPLIT_MODE_MASK 0x4
#define PCIE_CI_CNTL__CI_SLAVE_SPLIT_MODE__SHIFT 0x2
#define PCIE_CI_CNTL__CI_SLAVE_GEN_USR_DIS_MASK 0x8
#define PCIE_CI_CNTL__CI_SLAVE_GEN_USR_DIS__SHIFT 0x3
#define PCIE_CI_CNTL__CI_MST_CMPL_DUMMY_DATA_MASK 0x10
#define PCIE_CI_CNTL__CI_MST_CMPL_DUMMY_DATA__SHIFT 0x4
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE_MASK 0xc0
#define PCIE_CI_CNTL__CI_SLV_RC_RD_REQ_SIZE__SHIFT 0x6
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS_MASK 0x100
#define PCIE_CI_CNTL__CI_SLV_ORDERING_DIS__SHIFT 0x8
#define PCIE_CI_CNTL__CI_RC_ORDERING_DIS_MASK 0x200
#define PCIE_CI_CNTL__CI_RC_ORDERING_DIS__SHIFT 0x9
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS_MASK 0x400
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_DIS__SHIFT 0xa
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE_MASK 0x800
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_MODE__SHIFT 0xb
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR_MASK 0x1000
#define PCIE_CI_CNTL__CI_SLV_CPL_ALLOC_SOR__SHIFT 0xc
#define PCIE_CI_CNTL__CI_MST_IGNORE_PAGE_ALIGNED_REQUEST_MASK 0x2000
#define PCIE_CI_CNTL__CI_MST_IGNORE_PAGE_ALIGNED_REQUEST__SHIFT 0xd
#define PCIE_CI_CNTL__CI_MST_ATOMIC_ADDR_HASH_MASK 0x70000
#define PCIE_CI_CNTL__CI_MST_ATOMIC_ADDR_HASH__SHIFT 0x10
#define PCIE_BUS_CNTL__PMI_INT_DIS_MASK 0x40
#define PCIE_BUS_CNTL__PMI_INT_DIS__SHIFT 0x6
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS_MASK 0x80
#define PCIE_BUS_CNTL__IMMEDIATE_PMI_DIS__SHIFT 0x7
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN_MASK 0x1000
#define PCIE_BUS_CNTL__TRUE_PM_STATUS_EN__SHIFT 0xc
#define PCIE_LC_STATE6__LC_PREV_STATE24_MASK 0x3f
#define PCIE_LC_STATE6__LC_PREV_STATE24__SHIFT 0x0
#define PCIE_LC_STATE6__LC_PREV_STATE25_MASK 0x3f00
#define PCIE_LC_STATE6__LC_PREV_STATE25__SHIFT 0x8
#define PCIE_LC_STATE6__LC_PREV_STATE26_MASK 0x3f0000
#define PCIE_LC_STATE6__LC_PREV_STATE26__SHIFT 0x10
#define PCIE_LC_STATE6__LC_PREV_STATE27_MASK 0x3f000000
#define PCIE_LC_STATE6__LC_PREV_STATE27__SHIFT 0x18
#define PCIE_LC_STATE7__LC_PREV_STATE28_MASK 0x3f
#define PCIE_LC_STATE7__LC_PREV_STATE28__SHIFT 0x0
#define PCIE_LC_STATE7__LC_PREV_STATE29_MASK 0x3f00
#define PCIE_LC_STATE7__LC_PREV_STATE29__SHIFT 0x8
#define PCIE_LC_STATE7__LC_PREV_STATE30_MASK 0x3f0000
#define PCIE_LC_STATE7__LC_PREV_STATE30__SHIFT 0x10
#define PCIE_LC_STATE7__LC_PREV_STATE31_MASK 0x3f000000
#define PCIE_LC_STATE7__LC_PREV_STATE31__SHIFT 0x18
#define PCIE_LC_STATE8__LC_PREV_STATE32_MASK 0x3f
#define PCIE_LC_STATE8__LC_PREV_STATE32__SHIFT 0x0
#define PCIE_LC_STATE8__LC_PREV_STATE33_MASK 0x3f00
#define PCIE_LC_STATE8__LC_PREV_STATE33__SHIFT 0x8
#define PCIE_LC_STATE8__LC_PREV_STATE34_MASK 0x3f0000
#define PCIE_LC_STATE8__LC_PREV_STATE34__SHIFT 0x10
#define PCIE_LC_STATE8__LC_PREV_STATE35_MASK 0x3f000000
#define PCIE_LC_STATE8__LC_PREV_STATE35__SHIFT 0x18
#define PCIE_LC_STATE9__LC_PREV_STATE36_MASK 0x3f
#define PCIE_LC_STATE9__LC_PREV_STATE36__SHIFT 0x0
#define PCIE_LC_STATE9__LC_PREV_STATE37_MASK 0x3f00
#define PCIE_LC_STATE9__LC_PREV_STATE37__SHIFT 0x8
#define PCIE_LC_STATE9__LC_PREV_STATE38_MASK 0x3f0000
#define PCIE_LC_STATE9__LC_PREV_STATE38__SHIFT 0x10
#define PCIE_LC_STATE9__LC_PREV_STATE39_MASK 0x3f000000
#define PCIE_LC_STATE9__LC_PREV_STATE39__SHIFT 0x18
#define PCIE_LC_STATE10__LC_PREV_STATE40_MASK 0x3f
#define PCIE_LC_STATE10__LC_PREV_STATE40__SHIFT 0x0
#define PCIE_LC_STATE10__LC_PREV_STATE41_MASK 0x3f00
#define PCIE_LC_STATE10__LC_PREV_STATE41__SHIFT 0x8
#define PCIE_LC_STATE10__LC_PREV_STATE42_MASK 0x3f0000
#define PCIE_LC_STATE10__LC_PREV_STATE42__SHIFT 0x10
#define PCIE_LC_STATE10__LC_PREV_STATE43_MASK 0x3f000000
#define PCIE_LC_STATE10__LC_PREV_STATE43__SHIFT 0x18
#define PCIE_LC_STATE11__LC_PREV_STATE44_MASK 0x3f
#define PCIE_LC_STATE11__LC_PREV_STATE44__SHIFT 0x0
#define PCIE_LC_STATE11__LC_PREV_STATE45_MASK 0x3f00
#define PCIE_LC_STATE11__LC_PREV_STATE45__SHIFT 0x8
#define PCIE_LC_STATE11__LC_PREV_STATE46_MASK 0x3f0000
#define PCIE_LC_STATE11__LC_PREV_STATE46__SHIFT 0x10
#define PCIE_LC_STATE11__LC_PREV_STATE47_MASK 0x3f000000
#define PCIE_LC_STATE11__LC_PREV_STATE47__SHIFT 0x18
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR_MASK 0x1
#define PCIE_LC_STATUS1__LC_REVERSE_RCVR__SHIFT 0x0
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT_MASK 0x2
#define PCIE_LC_STATUS1__LC_REVERSE_XMIT__SHIFT 0x1
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH_MASK 0x1c
#define PCIE_LC_STATUS1__LC_OPERATING_LINK_WIDTH__SHIFT 0x2
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH_MASK 0xe0
#define PCIE_LC_STATUS1__LC_DETECTED_LINK_WIDTH__SHIFT 0x5
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES_MASK 0xffff
#define PCIE_LC_STATUS2__LC_TOTAL_INACTIVE_LANES__SHIFT 0x0
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE_MASK 0xffff0000
#define PCIE_LC_STATUS2__LC_TURN_ON_LANE__SHIFT 0x10
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN_MASK 0x1
#define PCIE_WPR_CNTL__WPR_RESET_HOT_RST_EN__SHIFT 0x0
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN_MASK 0x2
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DWN_EN__SHIFT 0x1
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN_MASK 0x4
#define PCIE_WPR_CNTL__WPR_RESET_LNK_DIS_EN__SHIFT 0x2
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN_MASK 0x8
#define PCIE_WPR_CNTL__WPR_RESET_COR_EN__SHIFT 0x3
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN_MASK 0x10
#define PCIE_WPR_CNTL__WPR_RESET_REG_EN__SHIFT 0x4
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN_MASK 0x20
#define PCIE_WPR_CNTL__WPR_RESET_STY_EN__SHIFT 0x5
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN_MASK 0x40
#define PCIE_WPR_CNTL__WPR_RESET_PHY_EN__SHIFT 0x6
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0_MASK 0xffffffff
#define PCIE_RX_LAST_TLP0__RX_LAST_TLP0__SHIFT 0x0
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1_MASK 0xffffffff
#define PCIE_RX_LAST_TLP1__RX_LAST_TLP1__SHIFT 0x0
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2_MASK 0xffffffff
#define PCIE_RX_LAST_TLP2__RX_LAST_TLP2__SHIFT 0x0
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3_MASK 0xffffffff
#define PCIE_RX_LAST_TLP3__RX_LAST_TLP3__SHIFT 0x0
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0_MASK 0xffffffff
#define PCIE_TX_LAST_TLP0__TX_LAST_TLP0__SHIFT 0x0
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1_MASK 0xffffffff
#define PCIE_TX_LAST_TLP1__TX_LAST_TLP1__SHIFT 0x0
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2_MASK 0xffffffff
#define PCIE_TX_LAST_TLP2__TX_LAST_TLP2__SHIFT 0x0
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3_MASK 0xffffffff
#define PCIE_TX_LAST_TLP3__TX_LAST_TLP3__SHIFT 0x0
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR_MASK 0x1ffff
#define PCIE_I2C_REG_ADDR_EXPAND__I2C_REG_ADDR__SHIFT 0x0
#define PCIE_I2C_REG_DATA__I2C_REG_DATA_MASK 0xffffffff
#define PCIE_I2C_REG_DATA__I2C_REG_DATA__SHIFT 0x0
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG_MASK 0x1
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_HIDDEN_REG__SHIFT 0x0
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG_MASK 0x2
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN2_HIDDEN_REG__SHIFT 0x1
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG_MASK 0x4
#define PCIE_CFG_CNTL__CFG_EN_DEC_TO_GEN3_HIDDEN_REG__SHIFT 0x2
#define PCIE_LC_PM_CNTL__LC_L1_POWER_GATING_EN_MASK 0x1
#define PCIE_LC_PM_CNTL__LC_L1_POWER_GATING_EN__SHIFT 0x0
#define PCIE_P_CNTL__P_PWRDN_EN_MASK 0x1
#define PCIE_P_CNTL__P_PWRDN_EN__SHIFT 0x0
#define PCIE_P_CNTL__P_SYMALIGN_MODE_MASK 0x2
#define PCIE_P_CNTL__P_SYMALIGN_MODE__SHIFT 0x1
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG_MASK 0x4
#define PCIE_P_CNTL__P_SYMALIGN_HW_DEBUG__SHIFT 0x2
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG_MASK 0x8
#define PCIE_P_CNTL__P_ELASTDESKEW_HW_DEBUG__SHIFT 0x3
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR_MASK 0x10
#define PCIE_P_CNTL__P_IGNORE_CRC_ERR__SHIFT 0x4
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR_MASK 0x20
#define PCIE_P_CNTL__P_IGNORE_LEN_ERR__SHIFT 0x5
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR_MASK 0x40
#define PCIE_P_CNTL__P_IGNORE_EDB_ERR__SHIFT 0x6
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR_MASK 0x80
#define PCIE_P_CNTL__P_IGNORE_IDL_ERR__SHIFT 0x7
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR_MASK 0x100
#define PCIE_P_CNTL__P_IGNORE_TOK_ERR__SHIFT 0x8
#define PCIE_P_CNTL__P_BLK_LOCK_MODE_MASK 0x1000
#define PCIE_P_CNTL__P_BLK_LOCK_MODE__SHIFT 0xc
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK_MASK 0x2000
#define PCIE_P_CNTL__P_ALWAYS_USE_FAST_TXCLK__SHIFT 0xd
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE_MASK 0xc000
#define PCIE_P_CNTL__P_ELEC_IDLE_MODE__SHIFT 0xe
#define PCIE_P_CNTL__DLP_IGNORE_IN_L1_EN_MASK 0x10000
#define PCIE_P_CNTL__DLP_IGNORE_IN_L1_EN__SHIFT 0x10
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR_MASK 0xffff
#define PCIE_P_BUF_STATUS__P_OVERFLOW_ERR__SHIFT 0x0
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR_MASK 0xffff0000
#define PCIE_P_BUF_STATUS__P_UNDERFLOW_ERR__SHIFT 0x10
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR_MASK 0xffff
#define PCIE_P_DECODER_STATUS__P_DECODE_ERR__SHIFT 0x0
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR_MASK 0xff
#define PCIE_P_MISC_STATUS__P_DESKEW_ERR__SHIFT 0x0
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR_MASK 0xffff0000
#define PCIE_P_MISC_STATUS__P_SYMUNLOCK_ERR__SHIFT 0x10
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN_MASK 0xff
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MIN__SHIFT 0x0
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX_MASK 0xff00
#define PCIE_P_RCV_L0S_FTS_DET__P_RCV_L0S_FTS_DET_MAX__SHIFT 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_PRIV_DISABLE_MASK 0x1
#define PCIE_OBFF_CNTL__TX_OBFF_PRIV_DISABLE__SHIFT 0x0
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SIMPLE_MODE_EN_MASK 0x2
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SIMPLE_MODE_EN__SHIFT 0x1
#define PCIE_OBFF_CNTL__TX_OBFF_HOSTMEM_TO_ACTIVE_MASK 0x4
#define PCIE_OBFF_CNTL__TX_OBFF_HOSTMEM_TO_ACTIVE__SHIFT 0x2
#define PCIE_OBFF_CNTL__TX_OBFF_SLVCPL_TO_ACTIVE_MASK 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_SLVCPL_TO_ACTIVE__SHIFT 0x3
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_PULSE_WIDTH_MASK 0xf0
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_PULSE_WIDTH__SHIFT 0x4
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_TWO_FALLING_WIDTH_MASK 0xf00
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_MAX_TWO_FALLING_WIDTH__SHIFT 0x8
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SAMPLING_PERIOD_MASK 0xf000
#define PCIE_OBFF_CNTL__TX_OBFF_WAKE_SAMPLING_PERIOD__SHIFT 0xc
#define PCIE_OBFF_CNTL__TX_OBFF_INTR_TO_ACTIVE_MASK 0x10000
#define PCIE_OBFF_CNTL__TX_OBFF_INTR_TO_ACTIVE__SHIFT 0x10
#define PCIE_OBFF_CNTL__TX_OBFF_ERR_TO_ACTIVE_MASK 0x20000
#define PCIE_OBFF_CNTL__TX_OBFF_ERR_TO_ACTIVE__SHIFT 0x11
#define PCIE_OBFF_CNTL__TX_OBFF_ANY_MSG_TO_ACTIVE_MASK 0x40000
#define PCIE_OBFF_CNTL__TX_OBFF_ANY_MSG_TO_ACTIVE__SHIFT 0x12
#define PCIE_OBFF_CNTL__TX_OBFF_ACCEPT_IN_NOND0_MASK 0x80000
#define PCIE_OBFF_CNTL__TX_OBFF_ACCEPT_IN_NOND0__SHIFT 0x13
#define PCIE_OBFF_CNTL__TX_OBFF_PENDING_REQ_TO_ACTIVE_MASK 0xf00000
#define PCIE_OBFF_CNTL__TX_OBFF_PENDING_REQ_TO_ACTIVE__SHIFT 0x14
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_SHORT_VALUE_MASK 0x7
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_SHORT_VALUE__SHIFT 0x0
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_LONG_VALUE_MASK 0x38
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_LONG_VALUE__SHIFT 0x3
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_REQUIREMENT_MASK 0x40
#define PCIE_TX_LTR_CNTL__LTR_PRIV_S_REQUIREMENT__SHIFT 0x6
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_SHORT_VALUE_MASK 0x380
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_SHORT_VALUE__SHIFT 0x7
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_LONG_VALUE_MASK 0x1c00
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_LONG_VALUE__SHIFT 0xa
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_REQUIREMENT_MASK 0x2000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_NS_REQUIREMENT__SHIFT 0xd
#define PCIE_TX_LTR_CNTL__LTR_PRIV_MSG_DIS_IN_PM_NON_D0_MASK 0x4000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_MSG_DIS_IN_PM_NON_D0__SHIFT 0xe
#define PCIE_TX_LTR_CNTL__LTR_PRIV_RST_LTR_IN_DL_DOWN_MASK 0x8000
#define PCIE_TX_LTR_CNTL__LTR_PRIV_RST_LTR_IN_DL_DOWN__SHIFT 0xf
#define PCIE_TX_LTR_CNTL__TX_CHK_FC_FOR_L1_MASK 0x10000
#define PCIE_TX_LTR_CNTL__TX_CHK_FC_FOR_L1__SHIFT 0x10
#define PCIE_IDLE_STATUS__PCIE_ALL_IDLE_STATUS_MASK 0x1
#define PCIE_IDLE_STATUS__PCIE_ALL_IDLE_STATUS__SHIFT 0x0
#define PCIE_IDLE_STATUS__TX_TXDL_IDLE_STATUS_MASK 0x2
#define PCIE_IDLE_STATUS__TX_TXDL_IDLE_STATUS__SHIFT 0x1
#define PCIE_IDLE_STATUS__TX_RBUF_IDLE_STATUS_MASK 0x4
#define PCIE_IDLE_STATUS__TX_RBUF_IDLE_STATUS__SHIFT 0x2
#define PCIE_IDLE_STATUS__TX_RCVD_FC_CREDITS_IDLE_MASK 0x8
#define PCIE_IDLE_STATUS__TX_RCVD_FC_CREDITS_IDLE__SHIFT 0x3
#define PCIE_IDLE_STATUS__TX_RPL_CREDITS_IDLE_MASK 0x10
#define PCIE_IDLE_STATUS__TX_RPL_CREDITS_IDLE__SHIFT 0x4
#define PCIE_IDLE_STATUS__TX_PBUF_IDLE_MASK 0x20
#define PCIE_IDLE_STATUS__TX_PBUF_IDLE__SHIFT 0x5
#define PCIE_IDLE_STATUS__TX_NPBUF_IDLE_MASK 0x40
#define PCIE_IDLE_STATUS__TX_NPBUF_IDLE__SHIFT 0x6
#define PCIE_IDLE_STATUS__TX_CPLBUF_IDLE_MASK 0x80
#define PCIE_IDLE_STATUS__TX_CPLBUF_IDLE__SHIFT 0x7
#define PCIE_IDLE_STATUS__TX_MSGBUF_IDLE_MASK 0x100
#define PCIE_IDLE_STATUS__TX_MSGBUF_IDLE__SHIFT 0x8
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN_MASK 0x1
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_EN__SHIFT 0x0
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR_MASK 0x2
#define PCIE_PERF_COUNT_CNTL__GLOBAL_SHADOW_WR__SHIFT 0x1
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET_MASK 0x4
#define PCIE_PERF_COUNT_CNTL__GLOBAL_COUNT_RESET__SHIFT 0x2
#define PCIE_PERF_CNTL_TXCLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_TXCLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_TXCLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_TXCLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_TXCLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_TXCLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_TXCLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_TXCLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_TXCLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_TXCLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_TXCLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_TXCLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_MST_R_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_MST_R_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_MST_R_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_MST_R_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_MST_R_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_MST_R_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_MST_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_MST_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_MST_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_MST_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_MST_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_MST_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_R_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_R_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_R_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_R_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_R_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_R_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_S_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_S_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_S_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_S_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_S_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_S_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_SLV_NS_C_CLK__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_SLV_NS_C_CLK__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_SLV_NS_C_CLK__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_SLV_NS_C_CLK__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_SLV_NS_C_CLK__COUNTER1__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK_MASK 0xf
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_R_CLK_MASK 0xf0
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_R_CLK__SHIFT 0x4
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_C_CLK_MASK 0xf00
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_MST_C_CLK__SHIFT 0x8
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_R_CLK_MASK 0xf000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_R_CLK__SHIFT 0xc
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_S_C_CLK_MASK 0xf0000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_S_C_CLK__SHIFT 0x10
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_NS_C_CLK_MASK 0xf00000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_SLV_NS_C_CLK__SHIFT 0x14
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK2_MASK 0xf000000
#define PCIE_PERF_CNTL_EVENT0_PORT_SEL__PERF0_PORT_SEL_TXCLK2__SHIFT 0x18
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK_MASK 0xf
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK__SHIFT 0x0
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_R_CLK_MASK 0xf0
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_R_CLK__SHIFT 0x4
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_C_CLK_MASK 0xf00
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_MST_C_CLK__SHIFT 0x8
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_R_CLK_MASK 0xf000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_R_CLK__SHIFT 0xc
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_S_C_CLK_MASK 0xf0000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_S_C_CLK__SHIFT 0x10
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_NS_C_CLK_MASK 0xf00000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_SLV_NS_C_CLK__SHIFT 0x14
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK2_MASK 0xf000000
#define PCIE_PERF_CNTL_EVENT1_PORT_SEL__PERF1_PORT_SEL_TXCLK2__SHIFT 0x18
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL_MASK 0xff
#define PCIE_PERF_CNTL_TXCLK2__EVENT0_SEL__SHIFT 0x0
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL_MASK 0xff00
#define PCIE_PERF_CNTL_TXCLK2__EVENT1_SEL__SHIFT 0x8
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_UPPER_MASK 0xff0000
#define PCIE_PERF_CNTL_TXCLK2__COUNTER0_UPPER__SHIFT 0x10
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_UPPER_MASK 0xff000000
#define PCIE_PERF_CNTL_TXCLK2__COUNTER1_UPPER__SHIFT 0x18
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0_MASK 0xffffffff
#define PCIE_PERF_COUNT0_TXCLK2__COUNTER0__SHIFT 0x0
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1_MASK 0xffffffff
#define PCIE_PERF_COUNT1_TXCLK2__COUNTER1__SHIFT 0x0
#define PCIE_STRAP_F0__STRAP_F0_EN_MASK 0x1
#define PCIE_STRAP_F0__STRAP_F0_EN__SHIFT 0x0
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F0__STRAP_F0_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN_MASK 0x4
#define PCIE_STRAP_F0__STRAP_F0_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F0__STRAP_F0_VC_EN_MASK 0x8
#define PCIE_STRAP_F0__STRAP_F0_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN_MASK 0x10
#define PCIE_STRAP_F0__STRAP_F0_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F0__STRAP_F0_AER_EN_MASK 0x20
#define PCIE_STRAP_F0__STRAP_F0_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN_MASK 0x40
#define PCIE_STRAP_F0__STRAP_F0_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN_MASK 0x80
#define PCIE_STRAP_F0__STRAP_F0_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN_MASK 0x100
#define PCIE_STRAP_F0__STRAP_F0_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN_MASK 0x200
#define PCIE_STRAP_F0__STRAP_F0_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN_MASK 0x400
#define PCIE_STRAP_F0__STRAP_F0_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F0__STRAP_F0_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F0__STRAP_F0_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F0__STRAP_F0_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F0__STRAP_F0_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F0__STRAP_F0_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F0__STRAP_F0_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F0__STRAP_F0_MC_EN_MASK 0x20000
#define PCIE_STRAP_F0__STRAP_F0_MC_EN__SHIFT 0x11
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_EN_MASK 0x40000
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_EN__SHIFT 0x12
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_64BIT_EN_MASK 0x80000
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_64BIT_EN__SHIFT 0x13
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_ROUTING_EN_MASK 0x100000
#define PCIE_STRAP_F0__STRAP_F0_ATOMIC_ROUTING_EN__SHIFT 0x14
#define PCIE_STRAP_F0__STRAP_F0_MSI_MULTI_CAP_MASK 0xe00000
#define PCIE_STRAP_F0__STRAP_F0_MSI_MULTI_CAP__SHIFT 0x15
#define PCIE_STRAP_F0__STRAP_F0_VFn_MSI_MULTI_CAP_MASK 0x7000000
#define PCIE_STRAP_F0__STRAP_F0_VFn_MSI_MULTI_CAP__SHIFT 0x18
#define PCIE_STRAP_F0__STRAP_F0_MSI_PERVECTOR_MASK_CAP_MASK 0x8000000
#define PCIE_STRAP_F0__STRAP_F0_MSI_PERVECTOR_MASK_CAP__SHIFT 0x1b
#define PCIE_STRAP_F0__STRAP_F0_NO_RO_ENABLED_P2P_PASSING_MASK 0x10000000
#define PCIE_STRAP_F0__STRAP_F0_NO_RO_ENABLED_P2P_PASSING__SHIFT 0x1c
#define PCIE_STRAP_F0__STRAP_F0_ARI_EN_MASK 0x20000000
#define PCIE_STRAP_F0__STRAP_F0_ARI_EN__SHIFT 0x1d
#define PCIE_STRAP_F0__STRAP_F0_SRIOV_EN_MASK 0x40000000
#define PCIE_STRAP_F0__STRAP_F0_SRIOV_EN__SHIFT 0x1e
#define PCIE_STRAP_F1__STRAP_F1_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F1__STRAP_F1_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F1__STRAP_F1_MSI_EN_MASK 0x4
#define PCIE_STRAP_F1__STRAP_F1_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F1__STRAP_F1_VC_EN_MASK 0x8
#define PCIE_STRAP_F1__STRAP_F1_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F1__STRAP_F1_DSN_EN_MASK 0x10
#define PCIE_STRAP_F1__STRAP_F1_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F1__STRAP_F1_AER_EN_MASK 0x20
#define PCIE_STRAP_F1__STRAP_F1_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F1__STRAP_F1_ACS_EN_MASK 0x40
#define PCIE_STRAP_F1__STRAP_F1_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F1__STRAP_F1_BAR_EN_MASK 0x80
#define PCIE_STRAP_F1__STRAP_F1_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F1__STRAP_F1_PWR_EN_MASK 0x100
#define PCIE_STRAP_F1__STRAP_F1_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F1__STRAP_F1_DPA_EN_MASK 0x200
#define PCIE_STRAP_F1__STRAP_F1_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F1__STRAP_F1_ATS_EN_MASK 0x400
#define PCIE_STRAP_F1__STRAP_F1_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F1__STRAP_F1_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F1__STRAP_F1_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F1__STRAP_F1_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F1__STRAP_F1_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F1__STRAP_F1_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F1__STRAP_F1_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F1__STRAP_F1_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F1__STRAP_F1_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F1__STRAP_F1_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F1__STRAP_F1_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F1__STRAP_F1_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F1__STRAP_F1_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_EN_MASK 0x40000
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_EN__SHIFT 0x12
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_64BIT_EN_MASK 0x80000
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_64BIT_EN__SHIFT 0x13
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_ROUTING_EN_MASK 0x100000
#define PCIE_STRAP_F1__STRAP_F1_ATOMIC_ROUTING_EN__SHIFT 0x14
#define PCIE_STRAP_F1__STRAP_F1_MSI_MULTI_CAP_MASK 0xe00000
#define PCIE_STRAP_F1__STRAP_F1_MSI_MULTI_CAP__SHIFT 0x15
#define PCIE_STRAP_F1__STRAP_F1_MSI_PERVECTOR_MASK_CAP_MASK 0x8000000
#define PCIE_STRAP_F1__STRAP_F1_MSI_PERVECTOR_MASK_CAP__SHIFT 0x1b
#define PCIE_STRAP_F2__STRAP_F2_LEGACY_DEVICE_TYPE_EN_MASK 0x2
#define PCIE_STRAP_F2__STRAP_F2_LEGACY_DEVICE_TYPE_EN__SHIFT 0x1
#define PCIE_STRAP_F2__STRAP_F2_MSI_EN_MASK 0x4
#define PCIE_STRAP_F2__STRAP_F2_MSI_EN__SHIFT 0x2
#define PCIE_STRAP_F2__STRAP_F2_VC_EN_MASK 0x8
#define PCIE_STRAP_F2__STRAP_F2_VC_EN__SHIFT 0x3
#define PCIE_STRAP_F2__STRAP_F2_DSN_EN_MASK 0x10
#define PCIE_STRAP_F2__STRAP_F2_DSN_EN__SHIFT 0x4
#define PCIE_STRAP_F2__STRAP_F2_AER_EN_MASK 0x20
#define PCIE_STRAP_F2__STRAP_F2_AER_EN__SHIFT 0x5
#define PCIE_STRAP_F2__STRAP_F2_ACS_EN_MASK 0x40
#define PCIE_STRAP_F2__STRAP_F2_ACS_EN__SHIFT 0x6
#define PCIE_STRAP_F2__STRAP_F2_BAR_EN_MASK 0x80
#define PCIE_STRAP_F2__STRAP_F2_BAR_EN__SHIFT 0x7
#define PCIE_STRAP_F2__STRAP_F2_PWR_EN_MASK 0x100
#define PCIE_STRAP_F2__STRAP_F2_PWR_EN__SHIFT 0x8
#define PCIE_STRAP_F2__STRAP_F2_DPA_EN_MASK 0x200
#define PCIE_STRAP_F2__STRAP_F2_DPA_EN__SHIFT 0x9
#define PCIE_STRAP_F2__STRAP_F2_ATS_EN_MASK 0x400
#define PCIE_STRAP_F2__STRAP_F2_ATS_EN__SHIFT 0xa
#define PCIE_STRAP_F2__STRAP_F2_PAGE_REQ_EN_MASK 0x800
#define PCIE_STRAP_F2__STRAP_F2_PAGE_REQ_EN__SHIFT 0xb
#define PCIE_STRAP_F2__STRAP_F2_PASID_EN_MASK 0x1000
#define PCIE_STRAP_F2__STRAP_F2_PASID_EN__SHIFT 0xc
#define PCIE_STRAP_F2__STRAP_F2_ECRC_CHECK_EN_MASK 0x2000
#define PCIE_STRAP_F2__STRAP_F2_ECRC_CHECK_EN__SHIFT 0xd
#define PCIE_STRAP_F2__STRAP_F2_ECRC_GEN_EN_MASK 0x4000
#define PCIE_STRAP_F2__STRAP_F2_ECRC_GEN_EN__SHIFT 0xe
#define PCIE_STRAP_F2__STRAP_F2_CPL_ABORT_ERR_EN_MASK 0x8000
#define PCIE_STRAP_F2__STRAP_F2_CPL_ABORT_ERR_EN__SHIFT 0xf
#define PCIE_STRAP_F2__STRAP_F2_POISONED_ADVISORY_NONFATAL_MASK 0x10000
#define PCIE_STRAP_F2__STRAP_F2_POISONED_ADVISORY_NONFATAL__SHIFT 0x10
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_EN_MASK 0x40000
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_EN__SHIFT 0x12
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_64BIT_EN_MASK 0x80000
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_64BIT_EN__SHIFT 0x13
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_ROUTING_EN_MASK 0x100000
#define PCIE_STRAP_F2__STRAP_F2_ATOMIC_ROUTING_EN__SHIFT 0x14
#define PCIE_STRAP_F2__STRAP_F2_MSI_MULTI_CAP_MASK 0xe00000
#define PCIE_STRAP_F2__STRAP_F2_MSI_MULTI_CAP__SHIFT 0x15
#define PCIE_STRAP_F2__STRAP_F2_MSI_PERVECTOR_MASK_CAP_MASK 0x8000000
#define PCIE_STRAP_F2__STRAP_F2_MSI_PERVECTOR_MASK_CAP__SHIFT 0x1b
#define PCIE_STRAP_F3__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F3__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F4__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F4__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F5__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F5__RESERVED__SHIFT 0x0
#define PCIE_STRAP_F6__RESERVED_MASK 0xffffffff
#define PCIE_STRAP_F6__RESERVED__SHIFT 0x0
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_EN_MASK 0x1
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_EN__SHIFT 0x0
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_TABLE_BIR_MASK 0xe
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_TABLE_BIR__SHIFT 0x1
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_TABLE_OFFSET_MASK 0xfffff000
#define PCIE_STRAP_MSIX__STRAP_F0_MSIX_TABLE_OFFSET__SHIFT 0xc
#define PCIE_STRAP_MISC__STRAP_TL_ALT_BUF_EN_MASK 0x10
#define PCIE_STRAP_MISC__STRAP_TL_ALT_BUF_EN__SHIFT 0x4
#define PCIE_STRAP_MISC__STRAP_MAX_PASID_WIDTH_MASK 0x1f00
#define PCIE_STRAP_MISC__STRAP_MAX_PASID_WIDTH__SHIFT 0x8
#define PCIE_STRAP_MISC__STRAP_PASID_EXE_PERMISSION_SUPPORTED_MASK 0x2000
#define PCIE_STRAP_MISC__STRAP_PASID_EXE_PERMISSION_SUPPORTED__SHIFT 0xd
#define PCIE_STRAP_MISC__STRAP_PASID_PRIV_MODE_SUPPORTED_MASK 0x4000
#define PCIE_STRAP_MISC__STRAP_PASID_PRIV_MODE_SUPPORTED__SHIFT 0xe
#define PCIE_STRAP_MISC__STRAP_PASID_GLOBAL_INVALIDATE_SUPPORTED_MASK 0x8000
#define PCIE_STRAP_MISC__STRAP_PASID_GLOBAL_INVALIDATE_SUPPORTED__SHIFT 0xf
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN_MASK 0x1000000
#define PCIE_STRAP_MISC__STRAP_CLK_PM_EN__SHIFT 0x18
#define PCIE_STRAP_MISC__STRAP_ECN1P1_EN_MASK 0x2000000
#define PCIE_STRAP_MISC__STRAP_ECN1P1_EN__SHIFT 0x19
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT_MASK 0x4000000
#define PCIE_STRAP_MISC__STRAP_EXT_VC_COUNT__SHIFT 0x1a
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL_MASK 0x10000000
#define PCIE_STRAP_MISC__STRAP_REVERSE_ALL__SHIFT 0x1c
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN_MASK 0x20000000
#define PCIE_STRAP_MISC__STRAP_MST_ADR64_EN__SHIFT 0x1d
#define PCIE_STRAP_MISC__STRAP_FLR_EN_MASK 0x40000000
#define PCIE_STRAP_MISC__STRAP_FLR_EN__SHIFT 0x1e
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN_MASK 0x80000000
#define PCIE_STRAP_MISC__STRAP_INTERNAL_ERR_EN__SHIFT 0x1f
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE_MASK 0x2
#define PCIE_STRAP_MISC2__STRAP_GEN2_COMPLIANCE__SHIFT 0x1
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN_MASK 0x4
#define PCIE_STRAP_MISC2__STRAP_MSTCPL_TIMEOUT_EN__SHIFT 0x2
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE_MASK 0x8
#define PCIE_STRAP_MISC2__STRAP_GEN3_COMPLIANCE__SHIFT 0x3
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED_MASK 0x10
#define PCIE_STRAP_MISC2__STRAP_TPH_SUPPORTED__SHIFT 0x4
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START_MASK 0x1
#define PCIE_STRAP_PI__STRAP_QUICKSIM_START__SHIFT 0x0
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN_MASK 0x10000000
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_PATTERN__SHIFT 0x1c
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE_MASK 0x20000000
#define PCIE_STRAP_PI__STRAP_TEST_TOGGLE_MODE__SHIFT 0x1d
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR_MASK 0x7f
#define PCIE_STRAP_I2C_BD__STRAP_BIF_I2C_SLV_ADR__SHIFT 0x0
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN_MASK 0x80
#define PCIE_STRAP_I2C_BD__STRAP_BIF_DBG_I2C_EN__SHIFT 0x7
#define PCIE_PRBS_CLR__PRBS_CLR_MASK 0xffff
#define PCIE_PRBS_CLR__PRBS_CLR__SHIFT 0x0
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT_MASK 0xf0000
#define PCIE_PRBS_CLR__PRBS_CHECKER_DEBUG_BUS_SELECT__SHIFT 0x10
#define PCIE_PRBS_CLR__PRBS_POLARITY_EN_MASK 0x1000000
#define PCIE_PRBS_CLR__PRBS_POLARITY_EN__SHIFT 0x18
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT_MASK 0xffff
#define PCIE_PRBS_STATUS1__PRBS_ERRSTAT__SHIFT 0x0
#define PCIE_PRBS_STATUS1__PRBS_LOCKED_MASK 0xffff0000
#define PCIE_PRBS_STATUS1__PRBS_LOCKED__SHIFT 0x10
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE_MASK 0xffff
#define PCIE_PRBS_STATUS2__PRBS_BITCNT_DONE__SHIFT 0x0
#define PCIE_PRBS_FREERUN__PRBS_FREERUN_MASK 0xffff
#define PCIE_PRBS_FREERUN__PRBS_FREERUN__SHIFT 0x0
#define PCIE_PRBS_MISC__PRBS_EN_MASK 0x1
#define PCIE_PRBS_MISC__PRBS_EN__SHIFT 0x0
#define PCIE_PRBS_MISC__PRBS_TEST_MODE_MASK 0xe
#define PCIE_PRBS_MISC__PRBS_TEST_MODE__SHIFT 0x1
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE_MASK 0x10
#define PCIE_PRBS_MISC__PRBS_USER_PATTERN_TOGGLE__SHIFT 0x4
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL_MASK 0x20
#define PCIE_PRBS_MISC__PRBS_8BIT_SEL__SHIFT 0x5
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM_MASK 0xc0
#define PCIE_PRBS_MISC__PRBS_COMMA_NUM__SHIFT 0x6
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT_MASK 0x1f00
#define PCIE_PRBS_MISC__PRBS_LOCK_CNT__SHIFT 0x8
#define PCIE_PRBS_MISC__PRBS_DATA_RATE_MASK 0xc000
#define PCIE_PRBS_MISC__PRBS_DATA_RATE__SHIFT 0xe
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK_MASK 0xffff0000
#define PCIE_PRBS_MISC__PRBS_CHK_ERR_MASK__SHIFT 0x10
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN_MASK 0x3fffffff
#define PCIE_PRBS_USER_PATTERN__PRBS_USER_PATTERN__SHIFT 0x0
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT_MASK 0xffffffff
#define PCIE_PRBS_LO_BITCNT__PRBS_LO_BITCNT__SHIFT 0x0
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT_MASK 0xff
#define PCIE_PRBS_HI_BITCNT__PRBS_HI_BITCNT__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_0__PRBS_ERRCNT_0__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_1__PRBS_ERRCNT_1__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_2__PRBS_ERRCNT_2__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_3__PRBS_ERRCNT_3__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_4__PRBS_ERRCNT_4__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_5__PRBS_ERRCNT_5__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_6__PRBS_ERRCNT_6__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_7__PRBS_ERRCNT_7__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_8__PRBS_ERRCNT_8__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_9__PRBS_ERRCNT_9__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_10__PRBS_ERRCNT_10__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_11__PRBS_ERRCNT_11__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_12__PRBS_ERRCNT_12__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_13__PRBS_ERRCNT_13__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_14__PRBS_ERRCNT_14__SHIFT 0x0
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15_MASK 0xffffffff
#define PCIE_PRBS_ERRCNT_15__PRBS_ERRCNT_15__SHIFT 0x0
#define PCIE_F0_DPA_CAP__TRANS_LAT_UNIT_MASK 0x300
#define PCIE_F0_DPA_CAP__TRANS_LAT_UNIT__SHIFT 0x8
#define PCIE_F0_DPA_CAP__PWR_ALLOC_SCALE_MASK 0x3000
#define PCIE_F0_DPA_CAP__PWR_ALLOC_SCALE__SHIFT 0xc
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_0_MASK 0xff0000
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_0__SHIFT 0x10
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_1_MASK 0xff000000
#define PCIE_F0_DPA_CAP__TRANS_LAT_VAL_1__SHIFT 0x18
#define PCIE_F0_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK 0xff
#define PCIE_F0_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT 0x0
#define PCIE_F0_DPA_CNTL__SUBSTATE_STATUS_MASK 0x1f
#define PCIE_F0_DPA_CNTL__SUBSTATE_STATUS__SHIFT 0x0
#define PCIE_F0_DPA_CNTL__DPA_COMPLIANCE_MODE_MASK 0x100
#define PCIE_F0_DPA_CNTL__DPA_COMPLIANCE_MODE__SHIFT 0x8
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK 0xff
#define PCIE_F0_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT 0x0
#define SWRST_COMMAND_STATUS__RECONFIGURE_MASK 0x1
#define SWRST_COMMAND_STATUS__RECONFIGURE__SHIFT 0x0
#define SWRST_COMMAND_STATUS__ATOMIC_RESET_MASK 0x2
#define SWRST_COMMAND_STATUS__ATOMIC_RESET__SHIFT 0x1
#define SWRST_COMMAND_STATUS__RESET_COMPLETE_MASK 0x10000
#define SWRST_COMMAND_STATUS__RESET_COMPLETE__SHIFT 0x10
#define SWRST_COMMAND_STATUS__WAIT_STATE_MASK 0x20000
#define SWRST_COMMAND_STATUS__WAIT_STATE__SHIFT 0x11
#define SWRST_GENERAL_CONTROL__RECONFIGURE_EN_MASK 0x1
#define SWRST_GENERAL_CONTROL__RECONFIGURE_EN__SHIFT 0x0
#define SWRST_GENERAL_CONTROL__ATOMIC_RESET_EN_MASK 0x2
#define SWRST_GENERAL_CONTROL__ATOMIC_RESET_EN__SHIFT 0x1
#define SWRST_GENERAL_CONTROL__RESET_PERIOD_MASK 0x1c
#define SWRST_GENERAL_CONTROL__RESET_PERIOD__SHIFT 0x2
#define SWRST_GENERAL_CONTROL__WAIT_LINKUP_MASK 0x100
#define SWRST_GENERAL_CONTROL__WAIT_LINKUP__SHIFT 0x8
#define SWRST_GENERAL_CONTROL__FORCE_REGIDLE_MASK 0x200
#define SWRST_GENERAL_CONTROL__FORCE_REGIDLE__SHIFT 0x9
#define SWRST_GENERAL_CONTROL__BLOCK_ON_IDLE_MASK 0x400
#define SWRST_GENERAL_CONTROL__BLOCK_ON_IDLE__SHIFT 0xa
#define SWRST_GENERAL_CONTROL__CONFIG_XFER_MODE_MASK 0x1000
#define SWRST_GENERAL_CONTROL__CONFIG_XFER_MODE__SHIFT 0xc
#define SWRST_GENERAL_CONTROL__MUXSEL_XFER_MODE_MASK 0x2000
#define SWRST_GENERAL_CONTROL__MUXSEL_XFER_MODE__SHIFT 0xd
#define SWRST_GENERAL_CONTROL__HLDTRAIN_XFER_MODE_MASK 0x4000
#define SWRST_GENERAL_CONTROL__HLDTRAIN_XFER_MODE__SHIFT 0xe
#define SWRST_GENERAL_CONTROL__BYPASS_HOLD_MASK 0x10000
#define SWRST_GENERAL_CONTROL__BYPASS_HOLD__SHIFT 0x10
#define SWRST_GENERAL_CONTROL__BYPASS_PIF_HOLD_MASK 0x20000
#define SWRST_GENERAL_CONTROL__BYPASS_PIF_HOLD__SHIFT 0x11
#define SWRST_GENERAL_CONTROL__EP_COMPLT_CHK_EN_MASK 0x10000000
#define SWRST_GENERAL_CONTROL__EP_COMPLT_CHK_EN__SHIFT 0x1c
#define SWRST_GENERAL_CONTROL__EP_COMPLT_WAIT_TMR_MASK 0x60000000
#define SWRST_GENERAL_CONTROL__EP_COMPLT_WAIT_TMR__SHIFT 0x1d
#define SWRST_COMMAND_0__BIF_STRAPREG_RESET_MASK 0x8000
#define SWRST_COMMAND_0__BIF_STRAPREG_RESET__SHIFT 0xf
#define SWRST_COMMAND_0__BIF0_GLOBAL_RESET_MASK 0x10000
#define SWRST_COMMAND_0__BIF0_GLOBAL_RESET__SHIFT 0x10
#define SWRST_COMMAND_0__BIF0_CALIB_RESET_MASK 0x20000
#define SWRST_COMMAND_0__BIF0_CALIB_RESET__SHIFT 0x11
#define SWRST_COMMAND_0__BIF0_CORE_RESET_MASK 0x40000
#define SWRST_COMMAND_0__BIF0_CORE_RESET__SHIFT 0x12
#define SWRST_COMMAND_0__BIF0_REGISTER_RESET_MASK 0x80000
#define SWRST_COMMAND_0__BIF0_REGISTER_RESET__SHIFT 0x13
#define SWRST_COMMAND_0__BIF0_PHY_RESET_MASK 0x100000
#define SWRST_COMMAND_0__BIF0_PHY_RESET__SHIFT 0x14
#define SWRST_COMMAND_0__BIF0_STICKY_RESET_MASK 0x200000
#define SWRST_COMMAND_0__BIF0_STICKY_RESET__SHIFT 0x15
#define SWRST_COMMAND_0__BIF0_CONFIG_RESET_MASK 0x400000
#define SWRST_COMMAND_0__BIF0_CONFIG_RESET__SHIFT 0x16
#define SWRST_COMMAND_1__SWITCHCLK_MASK 0x1
#define SWRST_COMMAND_1__SWITCHCLK__SHIFT 0x0
#define SWRST_COMMAND_1__RESETPCFG_MASK 0x2
#define SWRST_COMMAND_1__RESETPCFG__SHIFT 0x1
#define SWRST_COMMAND_1__RESETLANEMUX_MASK 0x4
#define SWRST_COMMAND_1__RESETLANEMUX__SHIFT 0x2
#define SWRST_COMMAND_1__RESETWRAPREGS_MASK 0x8
#define SWRST_COMMAND_1__RESETWRAPREGS__SHIFT 0x3
#define SWRST_COMMAND_1__RESETSRBM0_MASK 0x10
#define SWRST_COMMAND_1__RESETSRBM0__SHIFT 0x4
#define SWRST_COMMAND_1__RESETSRBM1_MASK 0x20
#define SWRST_COMMAND_1__RESETSRBM1__SHIFT 0x5
#define SWRST_COMMAND_1__RESETLC_MASK 0x40
#define SWRST_COMMAND_1__RESETLC__SHIFT 0x6
#define SWRST_COMMAND_1__SYNCIDLEPIF0_MASK 0x100
#define SWRST_COMMAND_1__SYNCIDLEPIF0__SHIFT 0x8
#define SWRST_COMMAND_1__SYNCIDLEPIF1_MASK 0x200
#define SWRST_COMMAND_1__SYNCIDLEPIF1__SHIFT 0x9
#define SWRST_COMMAND_1__RESETMNTR_MASK 0x2000
#define SWRST_COMMAND_1__RESETMNTR__SHIFT 0xd
#define SWRST_COMMAND_1__RESETHLTR_MASK 0x4000
#define SWRST_COMMAND_1__RESETHLTR__SHIFT 0xe
#define SWRST_COMMAND_1__RESETCPM_MASK 0x8000
#define SWRST_COMMAND_1__RESETCPM__SHIFT 0xf
#define SWRST_COMMAND_1__RESETPIF0_MASK 0x10000
#define SWRST_COMMAND_1__RESETPIF0__SHIFT 0x10
#define SWRST_COMMAND_1__RESETPIF1_MASK 0x20000
#define SWRST_COMMAND_1__RESETPIF1__SHIFT 0x11
#define SWRST_COMMAND_1__RESETIMPARB0_MASK 0x100000
#define SWRST_COMMAND_1__RESETIMPARB0__SHIFT 0x14
#define SWRST_COMMAND_1__RESETIMPARB1_MASK 0x200000
#define SWRST_COMMAND_1__RESETIMPARB1__SHIFT 0x15
#define SWRST_COMMAND_1__RESETPHY0_MASK 0x1000000
#define SWRST_COMMAND_1__RESETPHY0__SHIFT 0x18
#define SWRST_COMMAND_1__RESETPHY1_MASK 0x2000000
#define SWRST_COMMAND_1__RESETPHY1__SHIFT 0x19
#define SWRST_COMMAND_1__TOGGLESTRAP_MASK 0x10000000
#define SWRST_COMMAND_1__TOGGLESTRAP__SHIFT 0x1c
#define SWRST_COMMAND_1__CMDCFGEN_MASK 0x20000000
#define SWRST_COMMAND_1__CMDCFGEN__SHIFT 0x1d
#define SWRST_CONTROL_0__BIF_STRAPREG_RESETRCEN_MASK 0x8000
#define SWRST_CONTROL_0__BIF_STRAPREG_RESETRCEN__SHIFT 0xf
#define SWRST_CONTROL_0__BIF0_GLOBAL_RESETRCEN_MASK 0x10000
#define SWRST_CONTROL_0__BIF0_GLOBAL_RESETRCEN__SHIFT 0x10
#define SWRST_CONTROL_0__BIF0_CALIB_RESETRCEN_MASK 0x20000
#define SWRST_CONTROL_0__BIF0_CALIB_RESETRCEN__SHIFT 0x11
#define SWRST_CONTROL_0__BIF0_CORE_RESETRCEN_MASK 0x40000
#define SWRST_CONTROL_0__BIF0_CORE_RESETRCEN__SHIFT 0x12
#define SWRST_CONTROL_0__BIF0_REGISTER_RESETRCEN_MASK 0x80000
#define SWRST_CONTROL_0__BIF0_REGISTER_RESETRCEN__SHIFT 0x13
#define SWRST_CONTROL_0__BIF0_PHY_RESETRCEN_MASK 0x100000
#define SWRST_CONTROL_0__BIF0_PHY_RESETRCEN__SHIFT 0x14
#define SWRST_CONTROL_0__BIF0_STICKY_RESETRCEN_MASK 0x200000
#define SWRST_CONTROL_0__BIF0_STICKY_RESETRCEN__SHIFT 0x15
#define SWRST_CONTROL_0__BIF0_CONFIG_RESETRCEN_MASK 0x400000
#define SWRST_CONTROL_0__BIF0_CONFIG_RESETRCEN__SHIFT 0x16
#define SWRST_CONTROL_1__SWITCHCLK_RCEN_MASK 0x1
#define SWRST_CONTROL_1__SWITCHCLK_RCEN__SHIFT 0x0
#define SWRST_CONTROL_1__RESETPCFG_RCEN_MASK 0x2
#define SWRST_CONTROL_1__RESETPCFG_RCEN__SHIFT 0x1
#define SWRST_CONTROL_1__RESETLANEMUX_RCEN_MASK 0x4
#define SWRST_CONTROL_1__RESETLANEMUX_RCEN__SHIFT 0x2
#define SWRST_CONTROL_1__RESETWRAPREGS_RCEN_MASK 0x8
#define SWRST_CONTROL_1__RESETWRAPREGS_RCEN__SHIFT 0x3
#define SWRST_CONTROL_1__RESETSRBM0_RCEN_MASK 0x10
#define SWRST_CONTROL_1__RESETSRBM0_RCEN__SHIFT 0x4
#define SWRST_CONTROL_1__RESETSRBM1_RCEN_MASK 0x20
#define SWRST_CONTROL_1__RESETSRBM1_RCEN__SHIFT 0x5
#define SWRST_CONTROL_1__RESETLC_RCEN_MASK 0x40
#define SWRST_CONTROL_1__RESETLC_RCEN__SHIFT 0x6
#define SWRST_CONTROL_1__SYNCIDLEPIF0_RCEN_MASK 0x100
#define SWRST_CONTROL_1__SYNCIDLEPIF0_RCEN__SHIFT 0x8
#define SWRST_CONTROL_1__SYNCIDLEPIF1_RCEN_MASK 0x200
#define SWRST_CONTROL_1__SYNCIDLEPIF1_RCEN__SHIFT 0x9
#define SWRST_CONTROL_1__RESETMNTR_RCEN_MASK 0x2000
#define SWRST_CONTROL_1__RESETMNTR_RCEN__SHIFT 0xd
#define SWRST_CONTROL_1__RESETHLTR_RCEN_MASK 0x4000
#define SWRST_CONTROL_1__RESETHLTR_RCEN__SHIFT 0xe
#define SWRST_CONTROL_1__RESETCPM_RCEN_MASK 0x8000
#define SWRST_CONTROL_1__RESETCPM_RCEN__SHIFT 0xf
#define SWRST_CONTROL_1__RESETPIF0_RCEN_MASK 0x10000
#define SWRST_CONTROL_1__RESETPIF0_RCEN__SHIFT 0x10
#define SWRST_CONTROL_1__RESETPIF1_RCEN_MASK 0x20000
#define SWRST_CONTROL_1__RESETPIF1_RCEN__SHIFT 0x11
#define SWRST_CONTROL_1__RESETIMPARB0_RCEN_MASK 0x100000
#define SWRST_CONTROL_1__RESETIMPARB0_RCEN__SHIFT 0x14
#define SWRST_CONTROL_1__RESETIMPARB1_RCEN_MASK 0x200000
#define SWRST_CONTROL_1__RESETIMPARB1_RCEN__SHIFT 0x15
#define SWRST_CONTROL_1__RESETPHY0_RCEN_MASK 0x1000000
#define SWRST_CONTROL_1__RESETPHY0_RCEN__SHIFT 0x18
#define SWRST_CONTROL_1__RESETPHY1_RCEN_MASK 0x2000000
#define SWRST_CONTROL_1__RESETPHY1_RCEN__SHIFT 0x19
#define SWRST_CONTROL_1__STRAPVLD_RCEN_MASK 0x10000000
#define SWRST_CONTROL_1__STRAPVLD_RCEN__SHIFT 0x1c
#define SWRST_CONTROL_1__CMDCFG_RCEN_MASK 0x20000000
#define SWRST_CONTROL_1__CMDCFG_RCEN__SHIFT 0x1d
#define SWRST_CONTROL_2__BIF_STRAPREG_RESETATEN_MASK 0x8000
#define SWRST_CONTROL_2__BIF_STRAPREG_RESETATEN__SHIFT 0xf
#define SWRST_CONTROL_2__BIF0_GLOBAL_RESETATEN_MASK 0x10000
#define SWRST_CONTROL_2__BIF0_GLOBAL_RESETATEN__SHIFT 0x10
#define SWRST_CONTROL_2__BIF0_CALIB_RESETATEN_MASK 0x20000
#define SWRST_CONTROL_2__BIF0_CALIB_RESETATEN__SHIFT 0x11
#define SWRST_CONTROL_2__BIF0_CORE_RESETATEN_MASK 0x40000
#define SWRST_CONTROL_2__BIF0_CORE_RESETATEN__SHIFT 0x12
#define SWRST_CONTROL_2__BIF0_REGISTER_RESETATEN_MASK 0x80000
#define SWRST_CONTROL_2__BIF0_REGISTER_RESETATEN__SHIFT 0x13
#define SWRST_CONTROL_2__BIF0_PHY_RESETATEN_MASK 0x100000
#define SWRST_CONTROL_2__BIF0_PHY_RESETATEN__SHIFT 0x14
#define SWRST_CONTROL_2__BIF0_STICKY_RESETATEN_MASK 0x200000
#define SWRST_CONTROL_2__BIF0_STICKY_RESETATEN__SHIFT 0x15
#define SWRST_CONTROL_2__BIF0_CONFIG_RESETATEN_MASK 0x400000
#define SWRST_CONTROL_2__BIF0_CONFIG_RESETATEN__SHIFT 0x16
#define SWRST_CONTROL_3__SWITCHCLK_ATEN_MASK 0x1
#define SWRST_CONTROL_3__SWITCHCLK_ATEN__SHIFT 0x0
#define SWRST_CONTROL_3__RESETPCFG_ATEN_MASK 0x2
#define SWRST_CONTROL_3__RESETPCFG_ATEN__SHIFT 0x1
#define SWRST_CONTROL_3__RESETLANEMUX_ATEN_MASK 0x4
#define SWRST_CONTROL_3__RESETLANEMUX_ATEN__SHIFT 0x2
#define SWRST_CONTROL_3__RESETWRAPREGS_ATEN_MASK 0x8
#define SWRST_CONTROL_3__RESETWRAPREGS_ATEN__SHIFT 0x3
#define SWRST_CONTROL_3__RESETSRBM0_ATEN_MASK 0x10
#define SWRST_CONTROL_3__RESETSRBM0_ATEN__SHIFT 0x4
#define SWRST_CONTROL_3__RESETSRBM1_ATEN_MASK 0x20
#define SWRST_CONTROL_3__RESETSRBM1_ATEN__SHIFT 0x5
#define SWRST_CONTROL_3__RESETLC_ATEN_MASK 0x40
#define SWRST_CONTROL_3__RESETLC_ATEN__SHIFT 0x6
#define SWRST_CONTROL_3__SYNCIDLEPIF0_ATEN_MASK 0x100
#define SWRST_CONTROL_3__SYNCIDLEPIF0_ATEN__SHIFT 0x8
#define SWRST_CONTROL_3__SYNCIDLEPIF1_ATEN_MASK 0x200
#define SWRST_CONTROL_3__SYNCIDLEPIF1_ATEN__SHIFT 0x9
#define SWRST_CONTROL_3__RESETMNTR_ATEN_MASK 0x2000
#define SWRST_CONTROL_3__RESETMNTR_ATEN__SHIFT 0xd
#define SWRST_CONTROL_3__RESETHLTR_ATEN_MASK 0x4000
#define SWRST_CONTROL_3__RESETHLTR_ATEN__SHIFT 0xe
#define SWRST_CONTROL_3__RESETCPM_ATEN_MASK 0x8000
#define SWRST_CONTROL_3__RESETCPM_ATEN__SHIFT 0xf
#define SWRST_CONTROL_3__RESETPIF0_ATEN_MASK 0x10000
#define SWRST_CONTROL_3__RESETPIF0_ATEN__SHIFT 0x10
#define SWRST_CONTROL_3__RESETPIF1_ATEN_MASK 0x20000
#define SWRST_CONTROL_3__RESETPIF1_ATEN__SHIFT 0x11
#define SWRST_CONTROL_3__RESETIMPARB0_ATEN_MASK 0x100000
#define SWRST_CONTROL_3__RESETIMPARB0_ATEN__SHIFT 0x14
#define SWRST_CONTROL_3__RESETIMPARB1_ATEN_MASK 0x200000
#define SWRST_CONTROL_3__RESETIMPARB1_ATEN__SHIFT 0x15
#define SWRST_CONTROL_3__RESETPHY0_ATEN_MASK 0x1000000
#define SWRST_CONTROL_3__RESETPHY0_ATEN__SHIFT 0x18
#define SWRST_CONTROL_3__RESETPHY1_ATEN_MASK 0x2000000
#define SWRST_CONTROL_3__RESETPHY1_ATEN__SHIFT 0x19
#define SWRST_CONTROL_3__STRAPVLD_ATEN_MASK 0x10000000
#define SWRST_CONTROL_3__STRAPVLD_ATEN__SHIFT 0x1c
#define SWRST_CONTROL_3__CMDCFG_ATEN_MASK 0x20000000
#define SWRST_CONTROL_3__CMDCFG_ATEN__SHIFT 0x1d
#define SWRST_CONTROL_4__BIF_STRAPREG_WRRESETEN_MASK 0x4000
#define SWRST_CONTROL_4__BIF_STRAPREG_WRRESETEN__SHIFT 0xe
#define SWRST_CONTROL_4__BIF0_GLOBAL_WRRESETEN_MASK 0x10000
#define SWRST_CONTROL_4__BIF0_GLOBAL_WRRESETEN__SHIFT 0x10
#define SWRST_CONTROL_4__BIF0_CALIB_WRRESETEN_MASK 0x20000
#define SWRST_CONTROL_4__BIF0_CALIB_WRRESETEN__SHIFT 0x11
#define SWRST_CONTROL_4__BIF0_CORE_WRRESETEN_MASK 0x40000
#define SWRST_CONTROL_4__BIF0_CORE_WRRESETEN__SHIFT 0x12
#define SWRST_CONTROL_4__BIF0_REGISTER_WRRESETEN_MASK 0x80000
#define SWRST_CONTROL_4__BIF0_REGISTER_WRRESETEN__SHIFT 0x13
#define SWRST_CONTROL_4__BIF0_PHY_WRRESETEN_MASK 0x100000
#define SWRST_CONTROL_4__BIF0_PHY_WRRESETEN__SHIFT 0x14
#define SWRST_CONTROL_4__BIF0_STICKY_WRRESETEN_MASK 0x200000
#define SWRST_CONTROL_4__BIF0_STICKY_WRRESETEN__SHIFT 0x15
#define SWRST_CONTROL_4__BIF0_CONFIG_WRRESETEN_MASK 0x400000
#define SWRST_CONTROL_4__BIF0_CONFIG_WRRESETEN__SHIFT 0x16
#define SWRST_CONTROL_5__WRSWITCHCLK_EN_MASK 0x1
#define SWRST_CONTROL_5__WRSWITCHCLK_EN__SHIFT 0x0
#define SWRST_CONTROL_5__WRRESETPCFG_EN_MASK 0x2
#define SWRST_CONTROL_5__WRRESETPCFG_EN__SHIFT 0x1
#define SWRST_CONTROL_5__WRRESETLANEMUX_EN_MASK 0x4
#define SWRST_CONTROL_5__WRRESETLANEMUX_EN__SHIFT 0x2
#define SWRST_CONTROL_5__WRRESETWRAPREGS_EN_MASK 0x8
#define SWRST_CONTROL_5__WRRESETWRAPREGS_EN__SHIFT 0x3
#define SWRST_CONTROL_5__WRRESETSRBM0_EN_MASK 0x10
#define SWRST_CONTROL_5__WRRESETSRBM0_EN__SHIFT 0x4
#define SWRST_CONTROL_5__WRRESETSRBM1_EN_MASK 0x20
#define SWRST_CONTROL_5__WRRESETSRBM1_EN__SHIFT 0x5
#define SWRST_CONTROL_5__WRRESETLC_EN_MASK 0x40
#define SWRST_CONTROL_5__WRRESETLC_EN__SHIFT 0x6
#define SWRST_CONTROL_5__WRSYNCIDLEPIF0_EN_MASK 0x100
#define SWRST_CONTROL_5__WRSYNCIDLEPIF0_EN__SHIFT 0x8
#define SWRST_CONTROL_5__WRSYNCIDLEPIF1_EN_MASK 0x200
#define SWRST_CONTROL_5__WRSYNCIDLEPIF1_EN__SHIFT 0x9
#define SWRST_CONTROL_5__WRRESETMNTR_EN_MASK 0x2000
#define SWRST_CONTROL_5__WRRESETMNTR_EN__SHIFT 0xd
#define SWRST_CONTROL_5__WRRESETHLTR_EN_MASK 0x4000
#define SWRST_CONTROL_5__WRRESETHLTR_EN__SHIFT 0xe
#define SWRST_CONTROL_5__WRRESETCPM_EN_MASK 0x8000
#define SWRST_CONTROL_5__WRRESETCPM_EN__SHIFT 0xf
#define SWRST_CONTROL_5__WRRESETPIF0_EN_MASK 0x10000
#define SWRST_CONTROL_5__WRRESETPIF0_EN__SHIFT 0x10
#define SWRST_CONTROL_5__WRRESETPIF1_EN_MASK 0x20000
#define SWRST_CONTROL_5__WRRESETPIF1_EN__SHIFT 0x11
#define SWRST_CONTROL_5__WRRESETIMPARB0_EN_MASK 0x100000
#define SWRST_CONTROL_5__WRRESETIMPARB0_EN__SHIFT 0x14
#define SWRST_CONTROL_5__WRRESETIMPARB1_EN_MASK 0x200000
#define SWRST_CONTROL_5__WRRESETIMPARB1_EN__SHIFT 0x15
#define SWRST_CONTROL_5__WRRESETPHY0_EN_MASK 0x1000000
#define SWRST_CONTROL_5__WRRESETPHY0_EN__SHIFT 0x18
#define SWRST_CONTROL_5__WRRESETPHY1_EN_MASK 0x2000000
#define SWRST_CONTROL_5__WRRESETPHY1_EN__SHIFT 0x19
#define SWRST_CONTROL_5__WRSTRAPVLD_EN_MASK 0x10000000
#define SWRST_CONTROL_5__WRSTRAPVLD_EN__SHIFT 0x1c
#define SWRST_CONTROL_5__WRCMDCFG_EN_MASK 0x20000000
#define SWRST_CONTROL_5__WRCMDCFG_EN__SHIFT 0x1d
#define SWRST_CONTROL_6__WARMRESET_EN_MASK 0x1
#define SWRST_CONTROL_6__WARMRESET_EN__SHIFT 0x0
#define SWRST_CONTROL_6__CONNECTWITHWRAPREGS_EN_MASK 0x100
#define SWRST_CONTROL_6__CONNECTWITHWRAPREGS_EN__SHIFT 0x8
#define SWRST_EP_COMMAND_0__EP_CFG_RESET_ONLY_MASK 0x1
#define SWRST_EP_COMMAND_0__EP_CFG_RESET_ONLY__SHIFT 0x0
#define SWRST_EP_COMMAND_0__EP_SOFT_RESET_MASK 0x2
#define SWRST_EP_COMMAND_0__EP_SOFT_RESET__SHIFT 0x1
#define SWRST_EP_COMMAND_0__EP_DRV_RESET_MASK 0x4
#define SWRST_EP_COMMAND_0__EP_DRV_RESET__SHIFT 0x2
#define SWRST_EP_COMMAND_0__EP_HOT_RESET_MASK 0x100
#define SWRST_EP_COMMAND_0__EP_HOT_RESET__SHIFT 0x8
#define SWRST_EP_COMMAND_0__EP_LNKDWN_RESET_MASK 0x200
#define SWRST_EP_COMMAND_0__EP_LNKDWN_RESET__SHIFT 0x9
#define SWRST_EP_COMMAND_0__EP_LNKDIS_RESET_MASK 0x400
#define SWRST_EP_COMMAND_0__EP_LNKDIS_RESET__SHIFT 0xa
#define SWRST_EP_COMMAND_0__EP_FLR0_RESET_MASK 0x10000
#define SWRST_EP_COMMAND_0__EP_FLR0_RESET__SHIFT 0x10
#define SWRST_EP_COMMAND_0__EP_FLR1_RESET_MASK 0x20000
#define SWRST_EP_COMMAND_0__EP_FLR1_RESET__SHIFT 0x11
#define SWRST_EP_COMMAND_0__EP_FLR2_RESET_MASK 0x40000
#define SWRST_EP_COMMAND_0__EP_FLR2_RESET__SHIFT 0x12
#define SWRST_EP_CONTROL_0__EP_CFG_RESET_ONLY_EN_MASK 0x1
#define SWRST_EP_CONTROL_0__EP_CFG_RESET_ONLY_EN__SHIFT 0x0
#define SWRST_EP_CONTROL_0__EP_SOFT_RESET_EN_MASK 0x2
#define SWRST_EP_CONTROL_0__EP_SOFT_RESET_EN__SHIFT 0x1
#define SWRST_EP_CONTROL_0__EP_DRV_RESET_EN_MASK 0x4
#define SWRST_EP_CONTROL_0__EP_DRV_RESET_EN__SHIFT 0x2
#define SWRST_EP_CONTROL_0__EP_HOT_RESET_EN_MASK 0x100
#define SWRST_EP_CONTROL_0__EP_HOT_RESET_EN__SHIFT 0x8
#define SWRST_EP_CONTROL_0__EP_LNKDWN_RESET_EN_MASK 0x200
#define SWRST_EP_CONTROL_0__EP_LNKDWN_RESET_EN__SHIFT 0x9
#define SWRST_EP_CONTROL_0__EP_LNKDIS_RESET_EN_MASK 0x400
#define SWRST_EP_CONTROL_0__EP_LNKDIS_RESET_EN__SHIFT 0xa
#define SWRST_EP_CONTROL_0__EP_FLR0_RESET_EN_MASK 0x10000
#define SWRST_EP_CONTROL_0__EP_FLR0_RESET_EN__SHIFT 0x10
#define SWRST_EP_CONTROL_0__EP_FLR1_RESET_EN_MASK 0x20000
#define SWRST_EP_CONTROL_0__EP_FLR1_RESET_EN__SHIFT 0x11
#define SWRST_EP_CONTROL_0__EP_FLR2_RESET_EN_MASK 0x40000
#define SWRST_EP_CONTROL_0__EP_FLR2_RESET_EN__SHIFT 0x12
#define SWRST_EP_CONTROL_0__EP_CFG_WR_RESET_EN_MASK 0x80000
#define SWRST_EP_CONTROL_0__EP_CFG_WR_RESET_EN__SHIFT 0x13
#define SWRST_EP_CONTROL_0__EP_FLR_DISABLE_CFG_RST_MASK 0xf00000
#define SWRST_EP_CONTROL_0__EP_FLR_DISABLE_CFG_RST__SHIFT 0x14
#define CPM_CONTROL__LCLK_DYN_GATE_ENABLE_MASK 0x1
#define CPM_CONTROL__LCLK_DYN_GATE_ENABLE__SHIFT 0x0
#define CPM_CONTROL__TXCLK_DYN_GATE_ENABLE_MASK 0x2
#define CPM_CONTROL__TXCLK_DYN_GATE_ENABLE__SHIFT 0x1
#define CPM_CONTROL__TXCLK_PERM_GATE_ENABLE_MASK 0x4
#define CPM_CONTROL__TXCLK_PERM_GATE_ENABLE__SHIFT 0x2
#define CPM_CONTROL__TXCLK_PIF_GATE_ENABLE_MASK 0x8
#define CPM_CONTROL__TXCLK_PIF_GATE_ENABLE__SHIFT 0x3
#define CPM_CONTROL__TXCLK_GSKT_GATE_ENABLE_MASK 0x10
#define CPM_CONTROL__TXCLK_GSKT_GATE_ENABLE__SHIFT 0x4
#define CPM_CONTROL__TXCLK_LCNT_GATE_ENABLE_MASK 0x20
#define CPM_CONTROL__TXCLK_LCNT_GATE_ENABLE__SHIFT 0x5
#define CPM_CONTROL__TXCLK_REGS_GATE_ENABLE_MASK 0x40
#define CPM_CONTROL__TXCLK_REGS_GATE_ENABLE__SHIFT 0x6
#define CPM_CONTROL__TXCLK_PRBS_GATE_ENABLE_MASK 0x80
#define CPM_CONTROL__TXCLK_PRBS_GATE_ENABLE__SHIFT 0x7
#define CPM_CONTROL__REFCLK_REGS_GATE_ENABLE_MASK 0x100
#define CPM_CONTROL__REFCLK_REGS_GATE_ENABLE__SHIFT 0x8
#define CPM_CONTROL__LCLK_DYN_GATE_LATENCY_MASK 0x200
#define CPM_CONTROL__LCLK_DYN_GATE_LATENCY__SHIFT 0x9
#define CPM_CONTROL__TXCLK_DYN_GATE_LATENCY_MASK 0x400
#define CPM_CONTROL__TXCLK_DYN_GATE_LATENCY__SHIFT 0xa
#define CPM_CONTROL__TXCLK_PERM_GATE_LATENCY_MASK 0x800
#define CPM_CONTROL__TXCLK_PERM_GATE_LATENCY__SHIFT 0xb
#define CPM_CONTROL__TXCLK_REGS_GATE_LATENCY_MASK 0x1000
#define CPM_CONTROL__TXCLK_REGS_GATE_LATENCY__SHIFT 0xc
#define CPM_CONTROL__REFCLK_REGS_GATE_LATENCY_MASK 0x2000
#define CPM_CONTROL__REFCLK_REGS_GATE_LATENCY__SHIFT 0xd
#define CPM_CONTROL__LCLK_GATE_TXCLK_FREE_MASK 0x4000
#define CPM_CONTROL__LCLK_GATE_TXCLK_FREE__SHIFT 0xe
#define CPM_CONTROL__RCVR_DET_CLK_ENABLE_MASK 0x8000
#define CPM_CONTROL__RCVR_DET_CLK_ENABLE__SHIFT 0xf
#define CPM_CONTROL__TXCLK_PERM_GATE_PLL_PDN_MASK 0x10000
#define CPM_CONTROL__TXCLK_PERM_GATE_PLL_PDN__SHIFT 0x10
#define CPM_CONTROL__FAST_TXCLK_LATENCY_MASK 0xe0000
#define CPM_CONTROL__FAST_TXCLK_LATENCY__SHIFT 0x11
#define CPM_CONTROL__MASTER_PCIE_PLL_SELECT_MASK 0x100000
#define CPM_CONTROL__MASTER_PCIE_PLL_SELECT__SHIFT 0x14
#define CPM_CONTROL__MASTER_PCIE_PLL_AUTO_MASK 0x200000
#define CPM_CONTROL__MASTER_PCIE_PLL_AUTO__SHIFT 0x15
#define CPM_CONTROL__REFCLK_XSTCLK_ENABLE_MASK 0x400000
#define CPM_CONTROL__REFCLK_XSTCLK_ENABLE__SHIFT 0x16
#define CPM_CONTROL__REFCLK_XSTCLK_LATENCY_MASK 0x800000
#define CPM_CONTROL__REFCLK_XSTCLK_LATENCY__SHIFT 0x17
#define CPM_CONTROL__SPARE_REGS_MASK 0xff000000
#define CPM_CONTROL__SPARE_REGS__SHIFT 0x18
#define GSKT_CONTROL__GSKT_TxFifoBypass_MASK 0x1
#define GSKT_CONTROL__GSKT_TxFifoBypass__SHIFT 0x0
#define GSKT_CONTROL__GSKT_TxFifoDelay_MASK 0x2
#define GSKT_CONTROL__GSKT_TxFifoDelay__SHIFT 0x1
#define GSKT_CONTROL__GSKT_TxFifoDelay2_MASK 0x4
#define GSKT_CONTROL__GSKT_TxFifoDelay2__SHIFT 0x2
#define GSKT_CONTROL__GSKT_SpareRegs_MASK 0xf8
#define GSKT_CONTROL__GSKT_SpareRegs__SHIFT 0x3
#define LM_CONTROL__LoopbackSelect_MASK 0x1e
#define LM_CONTROL__LoopbackSelect__SHIFT 0x1
#define LM_CONTROL__PRBSPCIeLbSelect_MASK 0x20
#define LM_CONTROL__PRBSPCIeLbSelect__SHIFT 0x5
#define LM_CONTROL__LoopbackHalfRate_MASK 0xc0
#define LM_CONTROL__LoopbackHalfRate__SHIFT 0x6
#define LM_CONTROL__LoopbackFifoPtr_MASK 0x700
#define LM_CONTROL__LoopbackFifoPtr__SHIFT 0x8
#define LM_PCIETXMUX0__TXLANE0_MASK 0xff
#define LM_PCIETXMUX0__TXLANE0__SHIFT 0x0
#define LM_PCIETXMUX0__TXLANE1_MASK 0xff00
#define LM_PCIETXMUX0__TXLANE1__SHIFT 0x8
#define LM_PCIETXMUX0__TXLANE2_MASK 0xff0000
#define LM_PCIETXMUX0__TXLANE2__SHIFT 0x10
#define LM_PCIETXMUX0__TXLANE3_MASK 0xff000000
#define LM_PCIETXMUX0__TXLANE3__SHIFT 0x18
#define LM_PCIETXMUX1__TXLANE4_MASK 0xff
#define LM_PCIETXMUX1__TXLANE4__SHIFT 0x0
#define LM_PCIETXMUX1__TXLANE5_MASK 0xff00
#define LM_PCIETXMUX1__TXLANE5__SHIFT 0x8
#define LM_PCIETXMUX1__TXLANE6_MASK 0xff0000
#define LM_PCIETXMUX1__TXLANE6__SHIFT 0x10
#define LM_PCIETXMUX1__TXLANE7_MASK 0xff000000
#define LM_PCIETXMUX1__TXLANE7__SHIFT 0x18
#define LM_PCIETXMUX2__TXLANE8_MASK 0xff
#define LM_PCIETXMUX2__TXLANE8__SHIFT 0x0
#define LM_PCIETXMUX2__TXLANE9_MASK 0xff00
#define LM_PCIETXMUX2__TXLANE9__SHIFT 0x8
#define LM_PCIETXMUX2__TXLANE10_MASK 0xff0000
#define LM_PCIETXMUX2__TXLANE10__SHIFT 0x10
#define LM_PCIETXMUX2__TXLANE11_MASK 0xff000000
#define LM_PCIETXMUX2__TXLANE11__SHIFT 0x18
#define LM_PCIETXMUX3__TXLANE12_MASK 0xff
#define LM_PCIETXMUX3__TXLANE12__SHIFT 0x0
#define LM_PCIETXMUX3__TXLANE13_MASK 0xff00
#define LM_PCIETXMUX3__TXLANE13__SHIFT 0x8
#define LM_PCIETXMUX3__TXLANE14_MASK 0xff0000
#define LM_PCIETXMUX3__TXLANE14__SHIFT 0x10
#define LM_PCIETXMUX3__TXLANE15_MASK 0xff000000
#define LM_PCIETXMUX3__TXLANE15__SHIFT 0x18
#define LM_PCIERXMUX0__RXLANE0_MASK 0xff
#define LM_PCIERXMUX0__RXLANE0__SHIFT 0x0
#define LM_PCIERXMUX0__RXLANE1_MASK 0xff00
#define LM_PCIERXMUX0__RXLANE1__SHIFT 0x8
#define LM_PCIERXMUX0__RXLANE2_MASK 0xff0000
#define LM_PCIERXMUX0__RXLANE2__SHIFT 0x10
#define LM_PCIERXMUX0__RXLANE3_MASK 0xff000000
#define LM_PCIERXMUX0__RXLANE3__SHIFT 0x18
#define LM_PCIERXMUX1__RXLANE4_MASK 0xff
#define LM_PCIERXMUX1__RXLANE4__SHIFT 0x0
#define LM_PCIERXMUX1__RXLANE5_MASK 0xff00
#define LM_PCIERXMUX1__RXLANE5__SHIFT 0x8
#define LM_PCIERXMUX1__RXLANE6_MASK 0xff0000
#define LM_PCIERXMUX1__RXLANE6__SHIFT 0x10
#define LM_PCIERXMUX1__RXLANE7_MASK 0xff000000
#define LM_PCIERXMUX1__RXLANE7__SHIFT 0x18
#define LM_PCIERXMUX2__RXLANE8_MASK 0xff
#define LM_PCIERXMUX2__RXLANE8__SHIFT 0x0
#define LM_PCIERXMUX2__RXLANE9_MASK 0xff00
#define LM_PCIERXMUX2__RXLANE9__SHIFT 0x8
#define LM_PCIERXMUX2__RXLANE10_MASK 0xff0000
#define LM_PCIERXMUX2__RXLANE10__SHIFT 0x10
#define LM_PCIERXMUX2__RXLANE11_MASK 0xff000000
#define LM_PCIERXMUX2__RXLANE11__SHIFT 0x18
#define LM_PCIERXMUX3__RXLANE12_MASK 0xff
#define LM_PCIERXMUX3__RXLANE12__SHIFT 0x0
#define LM_PCIERXMUX3__RXLANE13_MASK 0xff00
#define LM_PCIERXMUX3__RXLANE13__SHIFT 0x8
#define LM_PCIERXMUX3__RXLANE14_MASK 0xff0000
#define LM_PCIERXMUX3__RXLANE14__SHIFT 0x10
#define LM_PCIERXMUX3__RXLANE15_MASK 0xff000000
#define LM_PCIERXMUX3__RXLANE15__SHIFT 0x18
#define LM_LANEENABLE__LANE_enable_MASK 0xffff
#define LM_LANEENABLE__LANE_enable__SHIFT 0x0
#define LM_PRBSCONTROL__PRBSPCIeSelect_MASK 0xffff
#define LM_PRBSCONTROL__PRBSPCIeSelect__SHIFT 0x0
#define LM_PRBSCONTROL__LMLaneDegrade0_MASK 0x10000000
#define LM_PRBSCONTROL__LMLaneDegrade0__SHIFT 0x1c
#define LM_PRBSCONTROL__LMLaneDegrade1_MASK 0x20000000
#define LM_PRBSCONTROL__LMLaneDegrade1__SHIFT 0x1d
#define LM_PRBSCONTROL__LMLaneDegrade2_MASK 0x40000000
#define LM_PRBSCONTROL__LMLaneDegrade2__SHIFT 0x1e
#define LM_PRBSCONTROL__LMLaneDegrade3_MASK 0x80000000
#define LM_PRBSCONTROL__LMLaneDegrade3__SHIFT 0x1f
#define LM_POWERCONTROL__LMTxPhyCmd0_MASK 0x7
#define LM_POWERCONTROL__LMTxPhyCmd0__SHIFT 0x0
#define LM_POWERCONTROL__LMRxPhyCmd0_MASK 0x38
#define LM_POWERCONTROL__LMRxPhyCmd0__SHIFT 0x3
#define LM_POWERCONTROL__LMLinkSpeed0_MASK 0xc0
#define LM_POWERCONTROL__LMLinkSpeed0__SHIFT 0x6
#define LM_POWERCONTROL__LMTxPhyCmd1_MASK 0x700
#define LM_POWERCONTROL__LMTxPhyCmd1__SHIFT 0x8
#define LM_POWERCONTROL__LMRxPhyCmd1_MASK 0x3800
#define LM_POWERCONTROL__LMRxPhyCmd1__SHIFT 0xb
#define LM_POWERCONTROL__LMLinkSpeed1_MASK 0xc000
#define LM_POWERCONTROL__LMLinkSpeed1__SHIFT 0xe
#define LM_POWERCONTROL__LMTxPhyCmd2_MASK 0x70000
#define LM_POWERCONTROL__LMTxPhyCmd2__SHIFT 0x10
#define LM_POWERCONTROL__LMRxPhyCmd2_MASK 0x380000
#define LM_POWERCONTROL__LMRxPhyCmd2__SHIFT 0x13
#define LM_POWERCONTROL__LMLinkSpeed2_MASK 0xc00000
#define LM_POWERCONTROL__LMLinkSpeed2__SHIFT 0x16
#define LM_POWERCONTROL__LMTxPhyCmd3_MASK 0x7000000
#define LM_POWERCONTROL__LMTxPhyCmd3__SHIFT 0x18
#define LM_POWERCONTROL__LMRxPhyCmd3_MASK 0x38000000
#define LM_POWERCONTROL__LMRxPhyCmd3__SHIFT 0x1b
#define LM_POWERCONTROL__LMLinkSpeed3_MASK 0xc0000000
#define LM_POWERCONTROL__LMLinkSpeed3__SHIFT 0x1e
#define LM_POWERCONTROL1__LMTxEn0_MASK 0x1
#define LM_POWERCONTROL1__LMTxEn0__SHIFT 0x0
#define LM_POWERCONTROL1__LMTxClkEn0_MASK 0x2
#define LM_POWERCONTROL1__LMTxClkEn0__SHIFT 0x1
#define LM_POWERCONTROL1__LMTxMargin0_MASK 0x1c
#define LM_POWERCONTROL1__LMTxMargin0__SHIFT 0x2
#define LM_POWERCONTROL1__LMSkipBit0_MASK 0x20
#define LM_POWERCONTROL1__LMSkipBit0__SHIFT 0x5
#define LM_POWERCONTROL1__LMLaneUnused0_MASK 0x40
#define LM_POWERCONTROL1__LMLaneUnused0__SHIFT 0x6
#define LM_POWERCONTROL1__LMTxMarginEn0_MASK 0x80
#define LM_POWERCONTROL1__LMTxMarginEn0__SHIFT 0x7
#define LM_POWERCONTROL1__LMDeemph0_MASK 0x100
#define LM_POWERCONTROL1__LMDeemph0__SHIFT 0x8
#define LM_POWERCONTROL1__LMTxEn1_MASK 0x200
#define LM_POWERCONTROL1__LMTxEn1__SHIFT 0x9
#define LM_POWERCONTROL1__LMTxClkEn1_MASK 0x400
#define LM_POWERCONTROL1__LMTxClkEn1__SHIFT 0xa
#define LM_POWERCONTROL1__LMTxMargin1_MASK 0x3800
#define LM_POWERCONTROL1__LMTxMargin1__SHIFT 0xb
#define LM_POWERCONTROL1__LMSkipBit1_MASK 0x4000
#define LM_POWERCONTROL1__LMSkipBit1__SHIFT 0xe
#define LM_POWERCONTROL1__LMLaneUnused1_MASK 0x8000
#define LM_POWERCONTROL1__LMLaneUnused1__SHIFT 0xf
#define LM_POWERCONTROL1__LMTxMarginEn1_MASK 0x10000
#define LM_POWERCONTROL1__LMTxMarginEn1__SHIFT 0x10
#define LM_POWERCONTROL1__LMDeemph1_MASK 0x20000
#define LM_POWERCONTROL1__LMDeemph1__SHIFT 0x11
#define LM_POWERCONTROL1__LMTxEn2_MASK 0x40000
#define LM_POWERCONTROL1__LMTxEn2__SHIFT 0x12
#define LM_POWERCONTROL1__LMTxClkEn2_MASK 0x80000
#define LM_POWERCONTROL1__LMTxClkEn2__SHIFT 0x13
#define LM_POWERCONTROL1__LMTxMargin2_MASK 0x700000
#define LM_POWERCONTROL1__LMTxMargin2__SHIFT 0x14
#define LM_POWERCONTROL1__LMSkipBit2_MASK 0x800000
#define LM_POWERCONTROL1__LMSkipBit2__SHIFT 0x17
#define LM_POWERCONTROL1__LMLaneUnused2_MASK 0x1000000
#define LM_POWERCONTROL1__LMLaneUnused2__SHIFT 0x18
#define LM_POWERCONTROL1__LMTxMarginEn2_MASK 0x2000000
#define LM_POWERCONTROL1__LMTxMarginEn2__SHIFT 0x19
#define LM_POWERCONTROL1__LMDeemph2_MASK 0x4000000
#define LM_POWERCONTROL1__LMDeemph2__SHIFT 0x1a
#define LM_POWERCONTROL1__TxCoeffID0_MASK 0x18000000
#define LM_POWERCONTROL1__TxCoeffID0__SHIFT 0x1b
#define LM_POWERCONTROL1__TxCoeffID1_MASK 0x60000000
#define LM_POWERCONTROL1__TxCoeffID1__SHIFT 0x1d
#define LM_POWERCONTROL2__LMTxEn3_MASK 0x1
#define LM_POWERCONTROL2__LMTxEn3__SHIFT 0x0
#define LM_POWERCONTROL2__LMTxClkEn3_MASK 0x2
#define LM_POWERCONTROL2__LMTxClkEn3__SHIFT 0x1
#define LM_POWERCONTROL2__LMTxMargin3_MASK 0x1c
#define LM_POWERCONTROL2__LMTxMargin3__SHIFT 0x2
#define LM_POWERCONTROL2__LMSkipBit3_MASK 0x20
#define LM_POWERCONTROL2__LMSkipBit3__SHIFT 0x5
#define LM_POWERCONTROL2__LMLaneUnused3_MASK 0x40
#define LM_POWERCONTROL2__LMLaneUnused3__SHIFT 0x6
#define LM_POWERCONTROL2__LMTxMarginEn3_MASK 0x80
#define LM_POWERCONTROL2__LMTxMarginEn3__SHIFT 0x7
#define LM_POWERCONTROL2__LMDeemph3_MASK 0x100
#define LM_POWERCONTROL2__LMDeemph3__SHIFT 0x8
#define LM_POWERCONTROL2__TxCoeffID2_MASK 0x600
#define LM_POWERCONTROL2__TxCoeffID2__SHIFT 0x9
#define LM_POWERCONTROL2__TxCoeffID3_MASK 0x1800
#define LM_POWERCONTROL2__TxCoeffID3__SHIFT 0xb
#define LM_POWERCONTROL2__TxCoeff0_MASK 0x7e000
#define LM_POWERCONTROL2__TxCoeff0__SHIFT 0xd
#define LM_POWERCONTROL2__TxCoeff1_MASK 0x1f80000
#define LM_POWERCONTROL2__TxCoeff1__SHIFT 0x13
#define LM_POWERCONTROL2__TxCoeff2_MASK 0x7e000000
#define LM_POWERCONTROL2__TxCoeff2__SHIFT 0x19
#define LM_POWERCONTROL3__TxCoeff3_MASK 0x3f
#define LM_POWERCONTROL3__TxCoeff3__SHIFT 0x0
#define LM_POWERCONTROL3__RxEqCtl0_MASK 0xfc0
#define LM_POWERCONTROL3__RxEqCtl0__SHIFT 0x6
#define LM_POWERCONTROL3__RxEqCtl1_MASK 0x3f000
#define LM_POWERCONTROL3__RxEqCtl1__SHIFT 0xc
#define LM_POWERCONTROL3__RxEqCtl2_MASK 0xfc0000
#define LM_POWERCONTROL3__RxEqCtl2__SHIFT 0x12
#define LM_POWERCONTROL3__RxEqCtl3_MASK 0x3f000000
#define LM_POWERCONTROL3__RxEqCtl3__SHIFT 0x18
#define LM_POWERCONTROL4__LinkNum0_MASK 0x7
#define LM_POWERCONTROL4__LinkNum0__SHIFT 0x0
#define LM_POWERCONTROL4__LinkNum1_MASK 0x38
#define LM_POWERCONTROL4__LinkNum1__SHIFT 0x3
#define LM_POWERCONTROL4__LinkNum2_MASK 0x1c0
#define LM_POWERCONTROL4__LinkNum2__SHIFT 0x6
#define LM_POWERCONTROL4__LinkNum3_MASK 0xe00
#define LM_POWERCONTROL4__LinkNum3__SHIFT 0x9
#define LM_POWERCONTROL4__LaneNum0_MASK 0xf000
#define LM_POWERCONTROL4__LaneNum0__SHIFT 0xc
#define LM_POWERCONTROL4__LaneNum1_MASK 0xf0000
#define LM_POWERCONTROL4__LaneNum1__SHIFT 0x10
#define LM_POWERCONTROL4__LaneNum2_MASK 0xf00000
#define LM_POWERCONTROL4__LaneNum2__SHIFT 0x14
#define LM_POWERCONTROL4__LaneNum3_MASK 0xf000000
#define LM_POWERCONTROL4__LaneNum3__SHIFT 0x18
#define LM_POWERCONTROL4__SpcMode0_MASK 0x10000000
#define LM_POWERCONTROL4__SpcMode0__SHIFT 0x1c
#define LM_POWERCONTROL4__SpcMode1_MASK 0x20000000
#define LM_POWERCONTROL4__SpcMode1__SHIFT 0x1d
#define LM_POWERCONTROL4__SpcMode2_MASK 0x40000000
#define LM_POWERCONTROL4__SpcMode2__SHIFT 0x1e
#define LM_POWERCONTROL4__SpcMode3_MASK 0x80000000
#define LM_POWERCONTROL4__SpcMode3__SHIFT 0x1f
#define PB0_GLB_CTRL_REG0__BACKUP_MASK 0xffff
#define PB0_GLB_CTRL_REG0__BACKUP__SHIFT 0x0
#define PB0_GLB_CTRL_REG0__CFG_IDLEDET_TH_MASK 0x30000
#define PB0_GLB_CTRL_REG0__CFG_IDLEDET_TH__SHIFT 0x10
#define PB0_GLB_CTRL_REG0__DBG_RX2TXBYP_SEL_MASK 0x700000
#define PB0_GLB_CTRL_REG0__DBG_RX2TXBYP_SEL__SHIFT 0x14
#define PB0_GLB_CTRL_REG0__DBG_RXFEBYP_EN_MASK 0x800000
#define PB0_GLB_CTRL_REG0__DBG_RXFEBYP_EN__SHIFT 0x17
#define PB0_GLB_CTRL_REG0__DBG_RXPRBS_CLR_MASK 0x1000000
#define PB0_GLB_CTRL_REG0__DBG_RXPRBS_CLR__SHIFT 0x18
#define PB0_GLB_CTRL_REG0__DBG_RXTOGGLE_EN_MASK 0x2000000
#define PB0_GLB_CTRL_REG0__DBG_RXTOGGLE_EN__SHIFT 0x19
#define PB0_GLB_CTRL_REG0__DBG_TX2RXLBACK_EN_MASK 0x4000000
#define PB0_GLB_CTRL_REG0__DBG_TX2RXLBACK_EN__SHIFT 0x1a
#define PB0_GLB_CTRL_REG0__TXCFG_CMGOOD_RANGE_MASK 0xc0000000
#define PB0_GLB_CTRL_REG0__TXCFG_CMGOOD_RANGE__SHIFT 0x1e
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_EN_MASK 0x1
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_EN__SHIFT 0x0
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_VAL_MASK 0x7e
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_VAL__SHIFT 0x1
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_EN_MASK 0x80
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_EN__SHIFT 0x7
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_VAL_MASK 0x3f00
#define PB0_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_VAL__SHIFT 0x8
#define PB0_GLB_CTRL_REG1__RXDBG_D0TH_BYP_EN_MASK 0x4000
#define PB0_GLB_CTRL_REG1__RXDBG_D0TH_BYP_EN__SHIFT 0xe
#define PB0_GLB_CTRL_REG1__RXDBG_D0TH_BYP_VAL_MASK 0x3f8000
#define PB0_GLB_CTRL_REG1__RXDBG_D0TH_BYP_VAL__SHIFT 0xf
#define PB0_GLB_CTRL_REG1__RXDBG_D1TH_BYP_EN_MASK 0x400000
#define PB0_GLB_CTRL_REG1__RXDBG_D1TH_BYP_EN__SHIFT 0x16
#define PB0_GLB_CTRL_REG1__RXDBG_D1TH_BYP_VAL_MASK 0x3f800000
#define PB0_GLB_CTRL_REG1__RXDBG_D1TH_BYP_VAL__SHIFT 0x17
#define PB0_GLB_CTRL_REG1__TST_LOSPDTST_EN_MASK 0x40000000
#define PB0_GLB_CTRL_REG1__TST_LOSPDTST_EN__SHIFT 0x1e
#define PB0_GLB_CTRL_REG1__PLL_CFG_DISPCLK_DIV_MASK 0x80000000
#define PB0_GLB_CTRL_REG1__PLL_CFG_DISPCLK_DIV__SHIFT 0x1f
#define PB0_GLB_CTRL_REG2__RXDBG_D2TH_BYP_EN_MASK 0x1
#define PB0_GLB_CTRL_REG2__RXDBG_D2TH_BYP_EN__SHIFT 0x0
#define PB0_GLB_CTRL_REG2__RXDBG_D2TH_BYP_VAL_MASK 0xfe
#define PB0_GLB_CTRL_REG2__RXDBG_D2TH_BYP_VAL__SHIFT 0x1
#define PB0_GLB_CTRL_REG2__RXDBG_D3TH_BYP_EN_MASK 0x100
#define PB0_GLB_CTRL_REG2__RXDBG_D3TH_BYP_EN__SHIFT 0x8
#define PB0_GLB_CTRL_REG2__RXDBG_D3TH_BYP_VAL_MASK 0xfe00
#define PB0_GLB_CTRL_REG2__RXDBG_D3TH_BYP_VAL__SHIFT 0x9
#define PB0_GLB_CTRL_REG2__RXDBG_DXTH_BYP_EN_MASK 0x10000
#define PB0_GLB_CTRL_REG2__RXDBG_DXTH_BYP_EN__SHIFT 0x10
#define PB0_GLB_CTRL_REG2__RXDBG_DXTH_BYP_VAL_MASK 0xfe0000
#define PB0_GLB_CTRL_REG2__RXDBG_DXTH_BYP_VAL__SHIFT 0x11
#define PB0_GLB_CTRL_REG2__RXDBG_ETH_BYP_EN_MASK 0x1000000
#define PB0_GLB_CTRL_REG2__RXDBG_ETH_BYP_EN__SHIFT 0x18
#define PB0_GLB_CTRL_REG2__RXDBG_ETH_BYP_VAL_MASK 0xfe000000
#define PB0_GLB_CTRL_REG2__RXDBG_ETH_BYP_VAL__SHIFT 0x19
#define PB0_GLB_CTRL_REG3__RXDBG_SEL_MASK 0x1f
#define PB0_GLB_CTRL_REG3__RXDBG_SEL__SHIFT 0x0
#define PB0_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF0_SEL_MASK 0x60
#define PB0_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF0_SEL__SHIFT 0x5
#define PB0_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF1_SEL_MASK 0x180
#define PB0_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF1_SEL__SHIFT 0x7
#define PB0_GLB_CTRL_REG3__BG_CFG_RO_REG_VREF_SEL_MASK 0x600
#define PB0_GLB_CTRL_REG3__BG_CFG_RO_REG_VREF_SEL__SHIFT 0x9
#define PB0_GLB_CTRL_REG3__BG_DBG_VREFBYP_EN_MASK 0x800
#define PB0_GLB_CTRL_REG3__BG_DBG_VREFBYP_EN__SHIFT 0xb
#define PB0_GLB_CTRL_REG3__BG_DBG_IREFBYP_EN_MASK 0x1000
#define PB0_GLB_CTRL_REG3__BG_DBG_IREFBYP_EN__SHIFT 0xc
#define PB0_GLB_CTRL_REG3__BG_DBG_ANALOG_SEL_MASK 0x1c000
#define PB0_GLB_CTRL_REG3__BG_DBG_ANALOG_SEL__SHIFT 0xe
#define PB0_GLB_CTRL_REG3__DBG_DLL_CLK_SEL_MASK 0x1c0000
#define PB0_GLB_CTRL_REG3__DBG_DLL_CLK_SEL__SHIFT 0x12
#define PB0_GLB_CTRL_REG3__PLL_DISPCLK_CMOS_SEL_MASK 0x200000
#define PB0_GLB_CTRL_REG3__PLL_DISPCLK_CMOS_SEL__SHIFT 0x15
#define PB0_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_EN_MASK 0x400000
#define PB0_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_EN__SHIFT 0x16
#define PB0_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_VAL_MASK 0x7800000
#define PB0_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_VAL__SHIFT 0x17
#define PB0_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_EN_MASK 0x8000000
#define PB0_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_EN__SHIFT 0x1b
#define PB0_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_VAL_MASK 0x70000000
#define PB0_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_VAL__SHIFT 0x1c
#define PB0_GLB_CTRL_REG3__DBG_RXLEQ_DCATTN_BYP_OVR_DISABLE_MASK 0x80000000
#define PB0_GLB_CTRL_REG3__DBG_RXLEQ_DCATTN_BYP_OVR_DISABLE__SHIFT 0x1f
#define PB0_GLB_CTRL_REG4__DBG_RXAPU_INST_MASK 0xffff
#define PB0_GLB_CTRL_REG4__DBG_RXAPU_INST__SHIFT 0x0
#define PB0_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_VAL_MASK 0x30000
#define PB0_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_VAL__SHIFT 0x10
#define PB0_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_EN_MASK 0x40000
#define PB0_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_EN__SHIFT 0x12
#define PB0_GLB_CTRL_REG4__DBG_RXAPU_EXEC_MASK 0x3c00000
#define PB0_GLB_CTRL_REG4__DBG_RXAPU_EXEC__SHIFT 0x16
#define PB0_GLB_CTRL_REG4__DBG_RXDLL_VREG_REF_SEL_MASK 0x4000000
#define PB0_GLB_CTRL_REG4__DBG_RXDLL_VREG_REF_SEL__SHIFT 0x1a
#define PB0_GLB_CTRL_REG4__PWRGOOD_OVRD_MASK 0x8000000
#define PB0_GLB_CTRL_REG4__PWRGOOD_OVRD__SHIFT 0x1b
#define PB0_GLB_CTRL_REG4__DBG_RXRDATA_GATING_DISABLE_MASK 0x10000000
#define PB0_GLB_CTRL_REG4__DBG_RXRDATA_GATING_DISABLE__SHIFT 0x1c
#define PB0_GLB_CTRL_REG5__DBG_RXAPU_MODE_MASK 0xff
#define PB0_GLB_CTRL_REG5__DBG_RXAPU_MODE__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L0T3_MASK 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L0T3__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L4T7_MASK 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L4T7__SHIFT 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L8T11_MASK 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L8T11__SHIFT 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L12T15_MASK 0x8
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L12T15__SHIFT 0x3
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_IMPCAL_ACTIVE_CBI_UPDT_MASK 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG0__IGNR_IMPCAL_ACTIVE_CBI_UPDT__SHIFT 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG0__TXNIMP_MASK 0xf00
#define PB0_GLB_SCI_STAT_OVRD_REG0__TXNIMP__SHIFT 0x8
#define PB0_GLB_SCI_STAT_OVRD_REG0__TXPIMP_MASK 0xf000
#define PB0_GLB_SCI_STAT_OVRD_REG0__TXPIMP__SHIFT 0xc
#define PB0_GLB_SCI_STAT_OVRD_REG0__RXIMP_MASK 0xf0000
#define PB0_GLB_SCI_STAT_OVRD_REG0__RXIMP__SHIFT 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG0__IMPCAL_ACTIVE_MASK 0x100000
#define PB0_GLB_SCI_STAT_OVRD_REG0__IMPCAL_ACTIVE__SHIFT 0x14
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_LINKSPEED_CBI_UPDT_L0T3_MASK 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_LINKSPEED_CBI_UPDT_L0T3__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_FREQDIV_CBI_UPDT_L0T3_MASK 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_FREQDIV_CBI_UPDT_L0T3__SHIFT 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_DLL_LOCK_CBI_UPDT_L0T3_MASK 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG1__IGNR_DLL_LOCK_CBI_UPDT_L0T3__SHIFT 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_0_MASK 0x1000
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_0__SHIFT 0xc
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_1_MASK 0x2000
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_1__SHIFT 0xd
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_2_MASK 0x4000
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_2__SHIFT 0xe
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_3_MASK 0x8000
#define PB0_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_3__SHIFT 0xf
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_0_MASK 0x30000
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_0__SHIFT 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_0_MASK 0xc0000
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_0__SHIFT 0x12
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_1_MASK 0x300000
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_1__SHIFT 0x14
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_1_MASK 0xc00000
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_1__SHIFT 0x16
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_2_MASK 0x3000000
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_2__SHIFT 0x18
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_2_MASK 0xc000000
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_2__SHIFT 0x1a
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_3_MASK 0x30000000
#define PB0_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_3__SHIFT 0x1c
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_3_MASK 0xc0000000
#define PB0_GLB_SCI_STAT_OVRD_REG1__FREQDIV_3__SHIFT 0x1e
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_LINKSPEED_CBI_UPDT_L4T7_MASK 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_LINKSPEED_CBI_UPDT_L4T7__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_FREQDIV_CBI_UPDT_L4T7_MASK 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_FREQDIV_CBI_UPDT_L4T7__SHIFT 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_DLL_LOCK_CBI_UPDT_L4T7_MASK 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG2__IGNR_DLL_LOCK_CBI_UPDT_L4T7__SHIFT 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_4_MASK 0x1000
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_4__SHIFT 0xc
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_5_MASK 0x2000
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_5__SHIFT 0xd
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_6_MASK 0x4000
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_6__SHIFT 0xe
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_7_MASK 0x8000
#define PB0_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_7__SHIFT 0xf
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_4_MASK 0x30000
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_4__SHIFT 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_4_MASK 0xc0000
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_4__SHIFT 0x12
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_5_MASK 0x300000
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_5__SHIFT 0x14
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_5_MASK 0xc00000
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_5__SHIFT 0x16
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_6_MASK 0x3000000
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_6__SHIFT 0x18
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_6_MASK 0xc000000
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_6__SHIFT 0x1a
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_7_MASK 0x30000000
#define PB0_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_7__SHIFT 0x1c
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_7_MASK 0xc0000000
#define PB0_GLB_SCI_STAT_OVRD_REG2__FREQDIV_7__SHIFT 0x1e
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_LINKSPEED_CBI_UPDT_L8T11_MASK 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_LINKSPEED_CBI_UPDT_L8T11__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_FREQDIV_CBI_UPDT_L8T11_MASK 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_FREQDIV_CBI_UPDT_L8T11__SHIFT 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_DLL_LOCK_CBI_UPDT_L8T11_MASK 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG3__IGNR_DLL_LOCK_CBI_UPDT_L8T11__SHIFT 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_8_MASK 0x1000
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_8__SHIFT 0xc
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_9_MASK 0x2000
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_9__SHIFT 0xd
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_10_MASK 0x4000
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_10__SHIFT 0xe
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_11_MASK 0x8000
#define PB0_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_11__SHIFT 0xf
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_8_MASK 0x30000
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_8__SHIFT 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_8_MASK 0xc0000
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_8__SHIFT 0x12
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_9_MASK 0x300000
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_9__SHIFT 0x14
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_9_MASK 0xc00000
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_9__SHIFT 0x16
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_10_MASK 0x3000000
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_10__SHIFT 0x18
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_10_MASK 0xc000000
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_10__SHIFT 0x1a
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_11_MASK 0x30000000
#define PB0_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_11__SHIFT 0x1c
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_11_MASK 0xc0000000
#define PB0_GLB_SCI_STAT_OVRD_REG3__FREQDIV_11__SHIFT 0x1e
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_LINKSPEED_CBI_UPDT_L12T15_MASK 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_LINKSPEED_CBI_UPDT_L12T15__SHIFT 0x0
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_FREQDIV_CBI_UPDT_L12T15_MASK 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_FREQDIV_CBI_UPDT_L12T15__SHIFT 0x1
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_DLL_LOCK_CBI_UPDT_L12T15_MASK 0x4
#define PB0_GLB_SCI_STAT_OVRD_REG4__IGNR_DLL_LOCK_CBI_UPDT_L12T15__SHIFT 0x2
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_12_MASK 0x1000
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_12__SHIFT 0xc
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_13_MASK 0x2000
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_13__SHIFT 0xd
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_14_MASK 0x4000
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_14__SHIFT 0xe
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_15_MASK 0x8000
#define PB0_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_15__SHIFT 0xf
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_12_MASK 0x30000
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_12__SHIFT 0x10
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_12_MASK 0xc0000
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_12__SHIFT 0x12
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_13_MASK 0x300000
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_13__SHIFT 0x14
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_13_MASK 0xc00000
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_13__SHIFT 0x16
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_14_MASK 0x3000000
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_14__SHIFT 0x18
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_14_MASK 0xc000000
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_14__SHIFT 0x1a
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_15_MASK 0x30000000
#define PB0_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_15__SHIFT 0x1c
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_15_MASK 0xc0000000
#define PB0_GLB_SCI_STAT_OVRD_REG4__FREQDIV_15__SHIFT 0x1e
#define PB0_GLB_OVRD_REG0__TXPDTERM_VAL_OVRD_VAL_MASK 0xffff
#define PB0_GLB_OVRD_REG0__TXPDTERM_VAL_OVRD_VAL__SHIFT 0x0
#define PB0_GLB_OVRD_REG0__TXPUTERM_VAL_OVRD_VAL_MASK 0xffff0000
#define PB0_GLB_OVRD_REG0__TXPUTERM_VAL_OVRD_VAL__SHIFT 0x10
#define PB0_GLB_OVRD_REG1__TXPDTERM_VAL_OVRD_EN_MASK 0x1
#define PB0_GLB_OVRD_REG1__TXPDTERM_VAL_OVRD_EN__SHIFT 0x0
#define PB0_GLB_OVRD_REG1__TXPUTERM_VAL_OVRD_EN_MASK 0x2
#define PB0_GLB_OVRD_REG1__TXPUTERM_VAL_OVRD_EN__SHIFT 0x1
#define PB0_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_EN_MASK 0x4
#define PB0_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_EN__SHIFT 0x2
#define PB0_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_VAL_MASK 0x8
#define PB0_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_VAL__SHIFT 0x3
#define PB0_GLB_OVRD_REG1__RXTERM_VAL_OVRD_EN_MASK 0x8000
#define PB0_GLB_OVRD_REG1__RXTERM_VAL_OVRD_EN__SHIFT 0xf
#define PB0_GLB_OVRD_REG1__RXTERM_VAL_OVRD_VAL_MASK 0xffff0000
#define PB0_GLB_OVRD_REG1__RXTERM_VAL_OVRD_VAL__SHIFT 0x10
#define PB0_GLB_OVRD_REG2__BG_PWRON_OVRD_EN_MASK 0x1
#define PB0_GLB_OVRD_REG2__BG_PWRON_OVRD_EN__SHIFT 0x0
#define PB0_GLB_OVRD_REG2__BG_PWRON_OVRD_VAL_MASK 0x2
#define PB0_GLB_OVRD_REG2__BG_PWRON_OVRD_VAL__SHIFT 0x1
#define PB0_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_EN_MASK 0x4
#define PB0_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_EN__SHIFT 0x2
#define PB0_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_VAL_MASK 0x8
#define PB0_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_VAL__SHIFT 0x3
#define PB0_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_EN_MASK 0x10
#define PB0_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_EN__SHIFT 0x4
#define PB0_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_VAL_MASK 0x20
#define PB0_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_VAL__SHIFT 0x5
#define PB0_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PB0_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PB0_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PB0_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PB0_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PB0_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PB0_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PB0_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PB0_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PB0_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PB0_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PB0_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PB0_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PB0_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PB0_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PB0_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PB0_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PB0_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PB0_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PB0_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PB0_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PB0_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PB0_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PB0_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PB0_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PB0_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PB0_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PB0_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PB0_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PB0_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PB0_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PB0_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PB0_HW_DEBUG__HW_16_DEBUG_MASK 0x10000
#define PB0_HW_DEBUG__HW_16_DEBUG__SHIFT 0x10
#define PB0_HW_DEBUG__HW_17_DEBUG_MASK 0x20000
#define PB0_HW_DEBUG__HW_17_DEBUG__SHIFT 0x11
#define PB0_HW_DEBUG__HW_18_DEBUG_MASK 0x40000
#define PB0_HW_DEBUG__HW_18_DEBUG__SHIFT 0x12
#define PB0_HW_DEBUG__HW_19_DEBUG_MASK 0x80000
#define PB0_HW_DEBUG__HW_19_DEBUG__SHIFT 0x13
#define PB0_HW_DEBUG__HW_20_DEBUG_MASK 0x100000
#define PB0_HW_DEBUG__HW_20_DEBUG__SHIFT 0x14
#define PB0_HW_DEBUG__HW_21_DEBUG_MASK 0x200000
#define PB0_HW_DEBUG__HW_21_DEBUG__SHIFT 0x15
#define PB0_HW_DEBUG__HW_22_DEBUG_MASK 0x400000
#define PB0_HW_DEBUG__HW_22_DEBUG__SHIFT 0x16
#define PB0_HW_DEBUG__HW_23_DEBUG_MASK 0x800000
#define PB0_HW_DEBUG__HW_23_DEBUG__SHIFT 0x17
#define PB0_HW_DEBUG__HW_24_DEBUG_MASK 0x1000000
#define PB0_HW_DEBUG__HW_24_DEBUG__SHIFT 0x18
#define PB0_HW_DEBUG__HW_25_DEBUG_MASK 0x2000000
#define PB0_HW_DEBUG__HW_25_DEBUG__SHIFT 0x19
#define PB0_HW_DEBUG__HW_26_DEBUG_MASK 0x4000000
#define PB0_HW_DEBUG__HW_26_DEBUG__SHIFT 0x1a
#define PB0_HW_DEBUG__HW_27_DEBUG_MASK 0x8000000
#define PB0_HW_DEBUG__HW_27_DEBUG__SHIFT 0x1b
#define PB0_HW_DEBUG__HW_28_DEBUG_MASK 0x10000000
#define PB0_HW_DEBUG__HW_28_DEBUG__SHIFT 0x1c
#define PB0_HW_DEBUG__HW_29_DEBUG_MASK 0x20000000
#define PB0_HW_DEBUG__HW_29_DEBUG__SHIFT 0x1d
#define PB0_HW_DEBUG__HW_30_DEBUG_MASK 0x40000000
#define PB0_HW_DEBUG__HW_30_DEBUG__SHIFT 0x1e
#define PB0_HW_DEBUG__HW_31_DEBUG_MASK 0x80000000
#define PB0_HW_DEBUG__HW_31_DEBUG__SHIFT 0x1f
#define PB0_STRAP_GLB_REG0__STRAP_QUICK_SIM_START_MASK 0x2
#define PB0_STRAP_GLB_REG0__STRAP_QUICK_SIM_START__SHIFT 0x1
#define PB0_STRAP_GLB_REG0__STRAP_DFT_RXBSCAN_EN_VAL_MASK 0x4
#define PB0_STRAP_GLB_REG0__STRAP_DFT_RXBSCAN_EN_VAL__SHIFT 0x2
#define PB0_STRAP_GLB_REG0__STRAP_DFT_CALIB_BYPASS_MASK 0x8
#define PB0_STRAP_GLB_REG0__STRAP_DFT_CALIB_BYPASS__SHIFT 0x3
#define PB0_STRAP_GLB_REG0__STRAP_FORCE_LC_PLL_ON_MASK 0x10
#define PB0_STRAP_GLB_REG0__STRAP_FORCE_LC_PLL_ON__SHIFT 0x4
#define PB0_STRAP_GLB_REG0__STRAP_CFG_IDLEDET_TH_MASK 0x60
#define PB0_STRAP_GLB_REG0__STRAP_CFG_IDLEDET_TH__SHIFT 0x5
#define PB0_STRAP_GLB_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_VAL_MASK 0xf80
#define PB0_STRAP_GLB_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_VAL__SHIFT 0x7
#define PB0_STRAP_GLB_REG0__STRAP_RX_CFG_OVR_PWRSF_MASK 0x1000
#define PB0_STRAP_GLB_REG0__STRAP_RX_CFG_OVR_PWRSF__SHIFT 0xc
#define PB0_STRAP_GLB_REG0__STRAP_RX_TRK_MODE_0__MASK 0x2000
#define PB0_STRAP_GLB_REG0__STRAP_RX_TRK_MODE_0___SHIFT 0xd
#define PB0_STRAP_GLB_REG0__STRAP_PWRGOOD_OVRD_MASK 0x4000
#define PB0_STRAP_GLB_REG0__STRAP_PWRGOOD_OVRD__SHIFT 0xe
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXDLL_VREG_REF_SEL_MASK 0x8000
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXDLL_VREG_REF_SEL__SHIFT 0xf
#define PB0_STRAP_GLB_REG0__STRAP_PLL_CFG_LC_VCO_TUNE_MASK 0xf0000
#define PB0_STRAP_GLB_REG0__STRAP_PLL_CFG_LC_VCO_TUNE__SHIFT 0x10
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXRDATA_GATING_DISABLE_MASK 0x100000
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXRDATA_GATING_DISABLE__SHIFT 0x14
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXPI_OFFSET_BYP_VAL_MASK 0x1e00000
#define PB0_STRAP_GLB_REG0__STRAP_DBG_RXPI_OFFSET_BYP_VAL__SHIFT 0x15
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_EN_MASK 0x1e
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_EN__SHIFT 0x1
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_TAP_SEL_MASK 0x1e0
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_TAP_SEL__SHIFT 0x5
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_EN_MASK 0x3e00
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_EN__SHIFT 0x9
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_TAP_SEL_MASK 0x7c000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_TAP_SEL__SHIFT 0xe
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_EN_MASK 0x780000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_EN__SHIFT 0x13
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_TAP_SEL_MASK 0x7800000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_TAP_SEL__SHIFT 0x17
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_EN_MASK 0x8000000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_EN__SHIFT 0x1b
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_TAP_SEL_MASK 0x10000000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_TAP_SEL__SHIFT 0x1c
#define PB0_STRAP_TX_REG0__STRAP_RX_TRK_MODE_1__MASK 0x20000000
#define PB0_STRAP_TX_REG0__STRAP_RX_TRK_MODE_1___SHIFT 0x1d
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_SWING_BOOST_EN_MASK 0x40000000
#define PB0_STRAP_TX_REG0__STRAP_TX_CFG_SWING_BOOST_EN__SHIFT 0x1e
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_TH_LOOP_GAIN_MASK 0x1e
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_TH_LOOP_GAIN__SHIFT 0x1
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_DLL_FLOCK_DISABLE_MASK 0x20
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_DLL_FLOCK_DISABLE__SHIFT 0x5
#define PB0_STRAP_RX_REG0__STRAP_DBG_RXPI_OFFSET_BYP_EN_MASK 0x40
#define PB0_STRAP_RX_REG0__STRAP_DBG_RXPI_OFFSET_BYP_EN__SHIFT 0x6
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_DIS_MASK 0x80
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_DIS__SHIFT 0x7
#define PB0_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF0_SEL_MASK 0x300
#define PB0_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF0_SEL__SHIFT 0x8
#define PB0_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF1_SEL_MASK 0xc00
#define PB0_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF1_SEL__SHIFT 0xa
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_CDR_TIME_MASK 0xf000
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_CDR_TIME__SHIFT 0xc
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_FOM_TIME_MASK 0xf0000
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_FOM_TIME__SHIFT 0x10
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_TIME_MASK 0xf00000
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_TIME__SHIFT 0x14
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_OC_TIME_MASK 0xf000000
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_OC_TIME__SHIFT 0x18
#define PB0_STRAP_RX_REG0__STRAP_TX_CFG_RPTR_RST_VAL_MASK 0x70000000
#define PB0_STRAP_RX_REG0__STRAP_TX_CFG_RPTR_RST_VAL__SHIFT 0x1c
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_TERM_MODE_MASK 0x80000000
#define PB0_STRAP_RX_REG0__STRAP_RX_CFG_TERM_MODE__SHIFT 0x1f
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PI_STPSZ_MASK 0x2
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PI_STPSZ__SHIFT 0x1
#define PB0_STRAP_RX_REG1__STRAP_TX_DEEMPH_PRSHT_STNG_MASK 0x1c
#define PB0_STRAP_RX_REG1__STRAP_TX_DEEMPH_PRSHT_STNG__SHIFT 0x2
#define PB0_STRAP_RX_REG1__STRAP_BG_CFG_RO_REG_VREF_SEL_MASK 0x60
#define PB0_STRAP_RX_REG1__STRAP_BG_CFG_RO_REG_VREF_SEL__SHIFT 0x5
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_DIS_MASK 0x80
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_DIS__SHIFT 0x7
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_VAL_MASK 0x700
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_VAL__SHIFT 0x8
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PH_GAIN_MASK 0x7800
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PH_GAIN__SHIFT 0xb
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_ADAPT_MODE_MASK 0x1ff8000
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_ADAPT_MODE__SHIFT 0xf
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_DFE_TIME_MASK 0x1e000000
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_DFE_TIME__SHIFT 0x19
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_LOOP_GAIN_MASK 0x60000000
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_LOOP_GAIN__SHIFT 0x1d
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_SHUNT_DIS_MASK 0x80000000
#define PB0_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_SHUNT_DIS__SHIFT 0x1f
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_BW_CNTRL_MASK 0xe
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_BW_CNTRL__SHIFT 0x1
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_LF_CNTRL_MASK 0x1ff0
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_LF_CNTRL__SHIFT 0x4
#define PB0_STRAP_PLL_REG0__STRAP_TX_RXDET_X1_SSF_MASK 0x2000
#define PB0_STRAP_PLL_REG0__STRAP_TX_RXDET_X1_SSF__SHIFT 0xd
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_VTOI_BIAS_CNTRL_DIS_MASK 0x8000
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_VTOI_BIAS_CNTRL_DIS__SHIFT 0xf
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_BW_CNTRL_MASK 0xff0000
#define PB0_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_BW_CNTRL__SHIFT 0x10
#define PB0_STRAP_PLL_REG0__STRAP_PLL_STRAP_SEL_MASK 0x1000000
#define PB0_STRAP_PLL_REG0__STRAP_PLL_STRAP_SEL__SHIFT 0x18
#define PB0_STRAP_PIN_REG0__STRAP_TX_DEEMPH_EN_MASK 0x2
#define PB0_STRAP_PIN_REG0__STRAP_TX_DEEMPH_EN__SHIFT 0x1
#define PB0_STRAP_PIN_REG0__STRAP_TX_FULL_SWING_MASK 0x4
#define PB0_STRAP_PIN_REG0__STRAP_TX_FULL_SWING__SHIFT 0x2
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_MODE_MASK 0x6
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_MODE__SHIFT 0x1
#define PB0_STRAP_GLB_REG1__STRAP_RX_L0_ENTRY_MODE_MASK 0x18
#define PB0_STRAP_GLB_REG1__STRAP_RX_L0_ENTRY_MODE__SHIFT 0x3
#define PB0_STRAP_GLB_REG1__STRAP_RX_EI_FILTER_MASK 0x60
#define PB0_STRAP_GLB_REG1__STRAP_RX_EI_FILTER__SHIFT 0x5
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_SUB_ENTRY_MASK 0x80
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_SUB_ENTRY__SHIFT 0x7
#define PB0_STRAP_GLB_REG1__STRAP_RX_PS0_RDY_GEN_MODE_MASK 0x300
#define PB0_STRAP_GLB_REG1__STRAP_RX_PS0_RDY_GEN_MODE__SHIFT 0x8
#define PB0_STRAP_GLB_REG1__STRAP_RX_DLL_RESET_IN_SPDCHG_MASK 0x400
#define PB0_STRAP_GLB_REG1__STRAP_RX_DLL_RESET_IN_SPDCHG__SHIFT 0xa
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_TIME_OUT_MASK 0x1800
#define PB0_STRAP_GLB_REG1__STRAP_RX_ADAPT_TIME_OUT__SHIFT 0xb
#define PB0_STRAP_GLB_REG2__STRAP_BPHYC_PLL_RAMP_UP_TIME_MASK 0x1c
#define PB0_STRAP_GLB_REG2__STRAP_BPHYC_PLL_RAMP_UP_TIME__SHIFT 0x2
#define PB0_STRAP_GLB_REG2__STRAP_IMPCAL_SETTLE_TIME_MASK 0x60
#define PB0_STRAP_GLB_REG2__STRAP_IMPCAL_SETTLE_TIME__SHIFT 0x5
#define PB0_STRAP_GLB_REG2__STRAP_BG_SETTLE_TIME_MASK 0x180
#define PB0_STRAP_GLB_REG2__STRAP_BG_SETTLE_TIME__SHIFT 0x7
#define PB0_STRAP_GLB_REG2__STRAP_TX_CMDET_TIME_MASK 0x600
#define PB0_STRAP_GLB_REG2__STRAP_TX_CMDET_TIME__SHIFT 0x9
#define PB0_STRAP_GLB_REG2__STRAP_TX_STARTUP_TIME_MASK 0x1800
#define PB0_STRAP_GLB_REG2__STRAP_TX_STARTUP_TIME__SHIFT 0xb
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DIS0_MASK 0x10000000
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DIS0__SHIFT 0x1c
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DIS1_MASK 0x20000000
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DIS1__SHIFT 0x1d
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DRV_STR_MASK 0xc0000000
#define PB0_STRAP_GLB_REG2__STRAP_B_PCB_DRV_STR__SHIFT 0x1e
#define PB0_DFT_JIT_INJ_REG0__DFT_NUM_STEPS_MASK 0x3f
#define PB0_DFT_JIT_INJ_REG0__DFT_NUM_STEPS__SHIFT 0x0
#define PB0_DFT_JIT_INJ_REG0__DFT_DISABLE_ERR_MASK 0x80
#define PB0_DFT_JIT_INJ_REG0__DFT_DISABLE_ERR__SHIFT 0x7
#define PB0_DFT_JIT_INJ_REG0__DFT_CLK_PER_STEP_MASK 0xf00
#define PB0_DFT_JIT_INJ_REG0__DFT_CLK_PER_STEP__SHIFT 0x8
#define PB0_DFT_JIT_INJ_REG0__DFT_MODE_CDR_EN_MASK 0x100000
#define PB0_DFT_JIT_INJ_REG0__DFT_MODE_CDR_EN__SHIFT 0x14
#define PB0_DFT_JIT_INJ_REG0__DFT_EN_RECOVERY_MASK 0x200000
#define PB0_DFT_JIT_INJ_REG0__DFT_EN_RECOVERY__SHIFT 0x15
#define PB0_DFT_JIT_INJ_REG0__DFT_INCR_SWP_EN_MASK 0x400000
#define PB0_DFT_JIT_INJ_REG0__DFT_INCR_SWP_EN__SHIFT 0x16
#define PB0_DFT_JIT_INJ_REG0__DFT_DECR_SWP_EN_MASK 0x800000
#define PB0_DFT_JIT_INJ_REG0__DFT_DECR_SWP_EN__SHIFT 0x17
#define PB0_DFT_JIT_INJ_REG0__DFT_RECOVERY_TIME_MASK 0xff000000
#define PB0_DFT_JIT_INJ_REG0__DFT_RECOVERY_TIME__SHIFT 0x18
#define PB0_DFT_JIT_INJ_REG1__DFT_BYPASS_VALUE_MASK 0xff
#define PB0_DFT_JIT_INJ_REG1__DFT_BYPASS_VALUE__SHIFT 0x0
#define PB0_DFT_JIT_INJ_REG1__DFT_BYPASS_EN_MASK 0x100
#define PB0_DFT_JIT_INJ_REG1__DFT_BYPASS_EN__SHIFT 0x8
#define PB0_DFT_JIT_INJ_REG1__DFT_BLOCK_EN_MASK 0x10000
#define PB0_DFT_JIT_INJ_REG1__DFT_BLOCK_EN__SHIFT 0x10
#define PB0_DFT_JIT_INJ_REG1__DFT_NUM_OF_TESTS_MASK 0xe0000
#define PB0_DFT_JIT_INJ_REG1__DFT_NUM_OF_TESTS__SHIFT 0x11
#define PB0_DFT_JIT_INJ_REG1__DFT_CHECK_TIME_MASK 0xf00000
#define PB0_DFT_JIT_INJ_REG1__DFT_CHECK_TIME__SHIFT 0x14
#define PB0_DFT_JIT_INJ_REG2__DFT_LANE_EN_MASK 0xffff
#define PB0_DFT_JIT_INJ_REG2__DFT_LANE_EN__SHIFT 0x0
#define PB0_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_EN_MASK 0x1
#define PB0_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_EN__SHIFT 0x0
#define PB0_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_MODE_MASK 0x3e
#define PB0_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_MODE__SHIFT 0x1
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_DECR_MASK 0xff
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_DECR__SHIFT 0x0
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_INCR_MASK 0xff00
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_INCR__SHIFT 0x8
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_FINISHED_MASK 0x10000
#define PB0_DFT_JIT_INJ_STAT_REG0__DFT_STAT_FINISHED__SHIFT 0x10
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_TST_LOSPDTST_SRC_MASK 0x1
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_TST_LOSPDTST_SRC__SHIFT 0x0
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS0_MASK 0x2
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS0__SHIFT 0x1
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS1_MASK 0x4
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS1__SHIFT 0x2
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS2_MASK 0x8
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS2__SHIFT 0x3
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS0_MASK 0x10
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS0__SHIFT 0x4
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS1_MASK 0x20
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS1__SHIFT 0x5
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS2_MASK 0x40
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS2__SHIFT 0x6
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_PWRON_LUT_ENTRY_LS2_MASK 0x80
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_PWRON_LUT_ENTRY_LS2__SHIFT 0x7
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_PWRON_LUT_ENTRY_LS2_MASK 0x100
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_PWRON_LUT_ENTRY_LS2__SHIFT 0x8
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS0_MASK 0x200
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS0__SHIFT 0x9
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS1_MASK 0x400
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS1__SHIFT 0xa
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS2_MASK 0x800
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS2__SHIFT 0xb
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS0_MASK 0x1000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS0__SHIFT 0xc
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS1_MASK 0x2000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS1__SHIFT 0xd
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS2_MASK 0x4000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS2__SHIFT 0xe
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_GATING_EN_MASK 0x8000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_GATING_EN__SHIFT 0xf
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_GATING_EN_MASK 0x10000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_GATING_EN__SHIFT 0x10
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_GATING_EN_MASK 0x20000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_GATING_EN__SHIFT 0x11
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_GATING_EN_MASK 0x40000
#define PB0_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_GATING_EN__SHIFT 0x12
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_ANALOG_SEL_0_MASK 0x3
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_ANALOG_SEL_0__SHIFT 0x0
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_EXT_RESET_EN_0_MASK 0x4
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_EXT_RESET_EN_0__SHIFT 0x2
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_VCTL_ADC_EN_0_MASK 0x8
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_VCTL_ADC_EN_0__SHIFT 0x3
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_LF_CNTRL_0_MASK 0x7f0
#define PB0_PLL_RO0_CTRL_REG0__PLL_DBG_RO_LF_CNTRL_0__SHIFT 0x4
#define PB0_PLL_RO0_CTRL_REG0__PLL_TST_RO_USAMPLE_EN_0_MASK 0x800
#define PB0_PLL_RO0_CTRL_REG0__PLL_TST_RO_USAMPLE_EN_0__SHIFT 0xb
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_VAL_0_MASK 0xff
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_VAL_0__SHIFT 0x0
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_EN_0_MASK 0x100
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_EN_0__SHIFT 0x8
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_VAL_0_MASK 0xe00
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_VAL_0__SHIFT 0x9
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_EN_0_MASK 0x1000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_EN_0__SHIFT 0xc
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_VAL_0_MASK 0x2000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_VAL_0__SHIFT 0xd
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_EN_0_MASK 0x4000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_EN_0__SHIFT 0xe
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_VAL_0_MASK 0xfff8000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_VAL_0__SHIFT 0xf
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_EN_0_MASK 0x10000000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_EN_0__SHIFT 0x1c
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_VAL_0_MASK 0x40000000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_VAL_0__SHIFT 0x1e
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_EN_0_MASK 0x80000000
#define PB0_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_EN_0__SHIFT 0x1f
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_VAL_0_MASK 0x1f
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_VAL_0__SHIFT 0x0
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_EN_0_MASK 0x20
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_EN_0__SHIFT 0x5
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_VAL_0_MASK 0xc0
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_VAL_0__SHIFT 0x6
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_EN_0_MASK 0x100
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_EN_0__SHIFT 0x8
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_VAL_0_MASK 0x200
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_VAL_0__SHIFT 0x9
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_EN_0_MASK 0x400
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_EN_0__SHIFT 0xa
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_VAL_0_MASK 0x800
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_VAL_0__SHIFT 0xb
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_EN_0_MASK 0x1000
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_EN_0__SHIFT 0xc
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_VAL_0_MASK 0x2000
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_VAL_0__SHIFT 0xd
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_EN_0_MASK 0x4000
#define PB0_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_EN_0__SHIFT 0xe
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_VAL_0_MASK 0x380000
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_VAL_0__SHIFT 0x13
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_EN_0_MASK 0x400000
#define PB0_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_EN_0__SHIFT 0x16
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLPWR_MASK 0x70
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLPWR__SHIFT 0x4
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLFREQ_MASK 0x300
#define PB0_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLFREQ__SHIFT 0x8
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLPWR_MASK 0x70
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLPWR__SHIFT 0x4
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLFREQ_MASK 0x300
#define PB0_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLFREQ__SHIFT 0x8
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLPWR_MASK 0x70
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLPWR__SHIFT 0x4
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLFREQ_MASK 0x300
#define PB0_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLFREQ__SHIFT 0x8
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLPWR_MASK 0x70
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLPWR__SHIFT 0x4
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLFREQ_MASK 0x300
#define PB0_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLFREQ__SHIFT 0x8
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_ANALOG_SEL_0_MASK 0x3
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_ANALOG_SEL_0__SHIFT 0x0
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_EXT_RESET_EN_0_MASK 0x4
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_EXT_RESET_EN_0__SHIFT 0x2
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_VCTL_ADC_EN_0_MASK 0x8
#define PB0_PLL_LC0_CTRL_REG0__PLL_DBG_LC_VCTL_ADC_EN_0__SHIFT 0x3
#define PB0_PLL_LC0_CTRL_REG0__PLL_TST_LC_USAMPLE_EN_0_MASK 0x10
#define PB0_PLL_LC0_CTRL_REG0__PLL_TST_LC_USAMPLE_EN_0__SHIFT 0x4
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_VAL_0_MASK 0x7
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_VAL_0__SHIFT 0x0
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_EN_0_MASK 0x8
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_EN_0__SHIFT 0x3
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_VAL_0_MASK 0x70
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_VAL_0__SHIFT 0x4
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_EN_0_MASK 0x80
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_EN_0__SHIFT 0x7
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_VAL_0_MASK 0x100
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_VAL_0__SHIFT 0x8
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_EN_0_MASK 0x200
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_EN_0__SHIFT 0x9
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_VAL_0_MASK 0x3fc00
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_VAL_0__SHIFT 0xa
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_EN_0_MASK 0x40000
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_EN_0__SHIFT 0x12
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_VAL_0_MASK 0xff80000
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_VAL_0__SHIFT 0x13
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_EN_0_MASK 0x10000000
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_EN_0__SHIFT 0x1c
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_VAL_0_MASK 0x60000000
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_VAL_0__SHIFT 0x1d
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_EN_0_MASK 0x80000000
#define PB0_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_EN_0__SHIFT 0x1f
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_VAL_0_MASK 0x7
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_VAL_0__SHIFT 0x0
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_EN_0_MASK 0x8
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_EN_0__SHIFT 0x3
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_VAL_0_MASK 0x10
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_VAL_0__SHIFT 0x4
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_EN_0_MASK 0x20
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_EN_0__SHIFT 0x5
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_VAL_0_MASK 0x40
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_VAL_0__SHIFT 0x6
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_EN_0_MASK 0x80
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_EN_0__SHIFT 0x7
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_VAL_0_MASK 0x100
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_VAL_0__SHIFT 0x8
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_EN_0_MASK 0x200
#define PB0_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_EN_0__SHIFT 0x9
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_VAL_0_MASK 0x3c000
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_VAL_0__SHIFT 0xe
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_EN_0_MASK 0x40000
#define PB0_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_EN_0__SHIFT 0x12
#define PB0_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_PLLPWR_MASK 0x70
#define PB0_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_PLLPWR__SHIFT 0x4
#define PB0_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_PLLPWR_MASK 0x70
#define PB0_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_PLLPWR__SHIFT 0x4
#define PB0_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_PLLPWR_MASK 0x70
#define PB0_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_PLLPWR__SHIFT 0x4
#define PB0_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB0_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB0_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_PLLPWR_MASK 0x70
#define PB0_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_PLLPWR__SHIFT 0x4
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN1_MASK 0x3ff
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN2_MASK 0xffc00
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN2__SHIFT 0xa
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN3_MASK 0x3ff00000
#define PB0_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN3__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN1_MASK 0xf
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN2_MASK 0xf0
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN2__SHIFT 0x4
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN3_MASK 0xf00
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN3__SHIFT 0x8
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN1_MASK 0xf000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN1__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN2_MASK 0xf0000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN2__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN3_MASK 0xf00000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN3__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN1_MASK 0x1000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN1__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN2_MASK 0x2000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN2__SHIFT 0x19
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN3_MASK 0x4000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN3__SHIFT 0x1a
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN1_MASK 0x8000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN1__SHIFT 0x1b
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN2_MASK 0x10000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN2__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN3_MASK 0x20000000
#define PB0_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN3__SHIFT 0x1d
#define PB0_RX_GLB_CTRL_REG1__RX_ADAPT_HLD_ASRT_TO_DCLK_EN_MASK 0xc0000000
#define PB0_RX_GLB_CTRL_REG1__RX_ADAPT_HLD_ASRT_TO_DCLK_EN__SHIFT 0x1e
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN1_MASK 0xf000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN1__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN2_MASK 0xf0000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN2__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN3_MASK 0xf00000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN3__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN1_MASK 0x3000000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN1__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN2_MASK 0xc000000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN2__SHIFT 0x1a
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN3_MASK 0x30000000
#define PB0_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN3__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG2__RX_DCLK_EN_ASRT_TO_ADAPT_HLD_MASK 0xc0000000
#define PB0_RX_GLB_CTRL_REG2__RX_DCLK_EN_ASRT_TO_ADAPT_HLD__SHIFT 0x1e
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN1_MASK 0x1
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN2_MASK 0x2
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN2__SHIFT 0x1
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN3_MASK 0x4
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN3__SHIFT 0x2
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN1_MASK 0x18
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN1__SHIFT 0x3
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN2_MASK 0x60
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN2__SHIFT 0x5
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN3_MASK 0x180
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN3__SHIFT 0x7
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_SUB_MODE_MASK 0xe00
#define PB0_RX_GLB_CTRL_REG3__RX_ADAPT_RST_SUB_MODE__SHIFT 0x9
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN1_MASK 0x3000
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN1__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN2_MASK 0xc000
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN2__SHIFT 0xe
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN3_MASK 0x30000
#define PB0_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN3__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN1_MASK 0xf00000
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN1__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN2_MASK 0xf000000
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN2__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN3_MASK 0xf0000000
#define PB0_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN3__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN1_MASK 0x7
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN2_MASK 0x38
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN2__SHIFT 0x3
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN3_MASK 0x1c0
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN3__SHIFT 0x6
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN1_MASK 0xe00
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN1__SHIFT 0x9
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN2_MASK 0x7000
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN2__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN3_MASK 0x38000
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN3__SHIFT 0xf
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN1_MASK 0xf00000
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN1__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN2_MASK 0xf000000
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN2__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN3_MASK 0xf0000000
#define PB0_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN3__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN1_MASK 0x1f
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN2_MASK 0x3e0
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN2__SHIFT 0x5
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN3_MASK 0x7c00
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN3__SHIFT 0xa
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN1_MASK 0x8000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN1__SHIFT 0xf
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN2_MASK 0x10000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN2__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN3_MASK 0x20000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN3__SHIFT 0x11
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN1_MASK 0x40000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN1__SHIFT 0x12
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN2_MASK 0x80000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN2__SHIFT 0x13
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN3_MASK 0x100000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN3__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN1_MASK 0x8000000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN1__SHIFT 0x1b
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN2_MASK 0x10000000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN2__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN3_MASK 0x20000000
#define PB0_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN3__SHIFT 0x1d
#define PB0_RX_GLB_CTRL_REG5__RX_ADAPT_AUX_PWRON_MODE_MASK 0x80000000
#define PB0_RX_GLB_CTRL_REG5__RX_ADAPT_AUX_PWRON_MODE__SHIFT 0x1f
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN1_MASK 0xf
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN2_MASK 0xf0
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN2__SHIFT 0x4
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN3_MASK 0xf00
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN3__SHIFT 0x8
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN1_MASK 0xf000
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN1__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN2_MASK 0xf0000
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN2__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN3_MASK 0xf00000
#define PB0_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN3__SHIFT 0x14
#define PB0_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS0_CDR_EN_0_MASK 0x1000000
#define PB0_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS0_CDR_EN_0__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS2_MASK 0x4000000
#define PB0_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS2__SHIFT 0x1a
#define PB0_RX_GLB_CTRL_REG6__RX_AUX_PWRON_LUT_ENTRY_LS2_MASK 0x8000000
#define PB0_RX_GLB_CTRL_REG6__RX_AUX_PWRON_LUT_ENTRY_LS2__SHIFT 0x1b
#define PB0_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L0S_EARLY_EXIT_DIS_MASK 0x10000000
#define PB0_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L0S_EARLY_EXIT_DIS__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L1_DLL_OFF_MASK 0x20000000
#define PB0_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L1_DLL_OFF__SHIFT 0x1d
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN1_MASK 0xf
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN1__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN2_MASK 0xf0
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN2__SHIFT 0x4
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN3_MASK 0xf00
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN3__SHIFT 0x8
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS0_CDR_EN_0_MASK 0x1000
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS0_CDR_EN_0__SHIFT 0xc
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS2_MASK 0x2000
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS2__SHIFT 0xd
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_AFTER_DLL_LOCK_MASK 0x4000
#define PB0_RX_GLB_CTRL_REG7__RX_DCLK_EN_AFTER_DLL_LOCK__SHIFT 0xe
#define PB0_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS3_MASK 0x10000
#define PB0_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS3__SHIFT 0x10
#define PB0_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS2_MASK 0x20000
#define PB0_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS2__SHIFT 0x11
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN1_MASK 0x1c0000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN1__SHIFT 0x12
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN2_MASK 0xe00000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN2__SHIFT 0x15
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN3_MASK 0x7000000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN3__SHIFT 0x18
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN1_MASK 0x8000000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN1__SHIFT 0x1b
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN2_MASK 0x10000000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN2__SHIFT 0x1c
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN3_MASK 0x20000000
#define PB0_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN3__SHIFT 0x1d
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_LOCK_TIME_MASK 0x3
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_LOCK_TIME__SHIFT 0x0
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_SPEEDCHANGE_RESET_TIME_MASK 0xc
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_SPEEDCHANGE_RESET_TIME__SHIFT 0x2
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_PWRON_IN_RAMPDOWN_MASK 0x10
#define PB0_RX_GLB_CTRL_REG8__RX_DLL_PWRON_IN_RAMPDOWN__SHIFT 0x4
#define PB0_RX_GLB_CTRL_REG8__RX_FSM_L0S_IF_RX_RDY_MASK 0x20
#define PB0_RX_GLB_CTRL_REG8__RX_FSM_L0S_IF_RX_RDY__SHIFT 0x5
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L0T3_MASK 0x1
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L0T3__SHIFT 0x0
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L4T7_MASK 0x2
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L4T7__SHIFT 0x1
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L8T11_MASK 0x4
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L8T11__SHIFT 0x2
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L12T15_MASK 0x8
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L12T15__SHIFT 0x3
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L0T3_MASK 0x10
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L0T3__SHIFT 0x4
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L4T7_MASK 0x20
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L4T7__SHIFT 0x5
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L8T11_MASK 0x40
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L8T11__SHIFT 0x6
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L12T15_MASK 0x80
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L12T15__SHIFT 0x7
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L0T3_MASK 0x100
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L0T3__SHIFT 0x8
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L4T7_MASK 0x200
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L4T7__SHIFT 0x9
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L8T11_MASK 0x400
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L8T11__SHIFT 0xa
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L12T15_MASK 0x800
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L12T15__SHIFT 0xb
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L0T3_MASK 0x1000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L0T3__SHIFT 0xc
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L4T7_MASK 0x2000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L4T7__SHIFT 0xd
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L8T11_MASK 0x4000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L8T11__SHIFT 0xe
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L12T15_MASK 0x8000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L12T15__SHIFT 0xf
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L0T3_MASK 0x10000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L0T3__SHIFT 0x10
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L4T7_MASK 0x20000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L4T7__SHIFT 0x11
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L8T11_MASK 0x40000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L8T11__SHIFT 0x12
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L12T15_MASK 0x80000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L12T15__SHIFT 0x13
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L0T3_MASK 0x100000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L0T3__SHIFT 0x14
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L4T7_MASK 0x200000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L4T7__SHIFT 0x15
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L8T11_MASK 0x400000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L8T11__SHIFT 0x16
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L12T15_MASK 0x800000
#define PB0_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L12T15__SHIFT 0x17
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_VAL_MASK 0x1
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_VAL__SHIFT 0x0
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_EN_MASK 0x2
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_EN__SHIFT 0x1
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_VAL_MASK 0x4
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_VAL__SHIFT 0x2
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_EN_MASK 0x8
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_EN__SHIFT 0x3
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_VAL_MASK 0xc0
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_VAL__SHIFT 0x6
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_EN_MASK 0x100
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_EN__SHIFT 0x8
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_VAL_MASK 0x200
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_VAL__SHIFT 0x9
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_EN_MASK 0x400
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_EN__SHIFT 0xa
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_VAL_MASK 0x800
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_VAL__SHIFT 0xb
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_EN_MASK 0x1000
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_EN__SHIFT 0xc
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_VAL_MASK 0x2000
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_VAL__SHIFT 0xd
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_EN_MASK 0x4000
#define PB0_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_EN__SHIFT 0xe
#define PB0_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_VAL_MASK 0x8000
#define PB0_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_VAL__SHIFT 0xf
#define PB0_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_EN_MASK 0x10000
#define PB0_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_EN__SHIFT 0x10
#define PB0_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_VAL_MASK 0x20000
#define PB0_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_VAL__SHIFT 0x11
#define PB0_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_EN_MASK 0x40000
#define PB0_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_EN__SHIFT 0x12
#define PB0_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_VAL_MASK 0x80000
#define PB0_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_VAL__SHIFT 0x13
#define PB0_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_EN_MASK 0x100000
#define PB0_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_EN__SHIFT 0x14
#define PB0_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_VAL_MASK 0x200000
#define PB0_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_VAL__SHIFT 0x15
#define PB0_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_EN_MASK 0x400000
#define PB0_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_EN__SHIFT 0x16
#define PB0_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_VAL_MASK 0x10000000
#define PB0_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_VAL__SHIFT 0x1c
#define PB0_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_EN_MASK 0x20000000
#define PB0_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_EN__SHIFT 0x1d
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_VAL_MASK 0x40000000
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_VAL__SHIFT 0x1e
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_EN_MASK 0x80000000
#define PB0_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_EN__SHIFT 0x1f
#define PB0_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_VAL_MASK 0x1
#define PB0_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_VAL__SHIFT 0x0
#define PB0_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_EN_MASK 0x2
#define PB0_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_EN__SHIFT 0x1
#define PB0_RX_LANE0_CTRL_REG0__RX_BACKUP_0_MASK 0xff
#define PB0_RX_LANE0_CTRL_REG0__RX_BACKUP_0__SHIFT 0x0
#define PB0_RX_LANE0_CTRL_REG0__RX_DBG_ANALOG_SEL_0_MASK 0xc00
#define PB0_RX_LANE0_CTRL_REG0__RX_DBG_ANALOG_SEL_0__SHIFT 0xa
#define PB0_RX_LANE0_CTRL_REG0__RX_TST_BSCAN_EN_0_MASK 0x1000
#define PB0_RX_LANE0_CTRL_REG0__RX_TST_BSCAN_EN_0__SHIFT 0xc
#define PB0_RX_LANE0_CTRL_REG0__RX_CFG_OVR_PWRSF_0_MASK 0x2000
#define PB0_RX_LANE0_CTRL_REG0__RX_CFG_OVR_PWRSF_0__SHIFT 0xd
#define PB0_RX_LANE0_CTRL_REG0__RX_TERM_EN_0_MASK 0x4000
#define PB0_RX_LANE0_CTRL_REG0__RX_TERM_EN_0__SHIFT 0xe
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RXPWR_0_MASK 0x7
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RXPWR_0__SHIFT 0x0
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_0_MASK 0x8
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_0__SHIFT 0x3
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTTRK_0_MASK 0x40
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTTRK_0__SHIFT 0x6
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__ENABLEFOM_0_MASK 0x80
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__ENABLEFOM_0__SHIFT 0x7
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTFOM_0_MASK 0x100
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTFOM_0__SHIFT 0x8
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RESPONSEMODE_0_MASK 0x200
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RESPONSEMODE_0__SHIFT 0x9
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RXEYEFOM_0_MASK 0x3fc00
#define PB0_RX_LANE0_SCI_STAT_OVRD_REG0__RXEYEFOM_0__SHIFT 0xa
#define PB0_RX_LANE1_CTRL_REG0__RX_BACKUP_1_MASK 0xff
#define PB0_RX_LANE1_CTRL_REG0__RX_BACKUP_1__SHIFT 0x0
#define PB0_RX_LANE1_CTRL_REG0__RX_DBG_ANALOG_SEL_1_MASK 0xc00
#define PB0_RX_LANE1_CTRL_REG0__RX_DBG_ANALOG_SEL_1__SHIFT 0xa
#define PB0_RX_LANE1_CTRL_REG0__RX_TST_BSCAN_EN_1_MASK 0x1000
#define PB0_RX_LANE1_CTRL_REG0__RX_TST_BSCAN_EN_1__SHIFT 0xc
#define PB0_RX_LANE1_CTRL_REG0__RX_CFG_OVR_PWRSF_1_MASK 0x2000
#define PB0_RX_LANE1_CTRL_REG0__RX_CFG_OVR_PWRSF_1__SHIFT 0xd
#define PB0_RX_LANE1_CTRL_REG0__RX_TERM_EN_1_MASK 0x4000
#define PB0_RX_LANE1_CTRL_REG0__RX_TERM_EN_1__SHIFT 0xe
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RXPWR_1_MASK 0x7
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RXPWR_1__SHIFT 0x0
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_1_MASK 0x8
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_1__SHIFT 0x3
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTTRK_1_MASK 0x40
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTTRK_1__SHIFT 0x6
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__ENABLEFOM_1_MASK 0x80
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__ENABLEFOM_1__SHIFT 0x7
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTFOM_1_MASK 0x100
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTFOM_1__SHIFT 0x8
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RESPONSEMODE_1_MASK 0x200
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RESPONSEMODE_1__SHIFT 0x9
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RXEYEFOM_1_MASK 0x3fc00
#define PB0_RX_LANE1_SCI_STAT_OVRD_REG0__RXEYEFOM_1__SHIFT 0xa
#define PB0_RX_LANE2_CTRL_REG0__RX_BACKUP_2_MASK 0xff
#define PB0_RX_LANE2_CTRL_REG0__RX_BACKUP_2__SHIFT 0x0
#define PB0_RX_LANE2_CTRL_REG0__RX_DBG_ANALOG_SEL_2_MASK 0xc00
#define PB0_RX_LANE2_CTRL_REG0__RX_DBG_ANALOG_SEL_2__SHIFT 0xa
#define PB0_RX_LANE2_CTRL_REG0__RX_TST_BSCAN_EN_2_MASK 0x1000
#define PB0_RX_LANE2_CTRL_REG0__RX_TST_BSCAN_EN_2__SHIFT 0xc
#define PB0_RX_LANE2_CTRL_REG0__RX_CFG_OVR_PWRSF_2_MASK 0x2000
#define PB0_RX_LANE2_CTRL_REG0__RX_CFG_OVR_PWRSF_2__SHIFT 0xd
#define PB0_RX_LANE2_CTRL_REG0__RX_TERM_EN_2_MASK 0x4000
#define PB0_RX_LANE2_CTRL_REG0__RX_TERM_EN_2__SHIFT 0xe
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RXPWR_2_MASK 0x7
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RXPWR_2__SHIFT 0x0
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_2_MASK 0x8
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_2__SHIFT 0x3
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTTRK_2_MASK 0x40
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTTRK_2__SHIFT 0x6
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__ENABLEFOM_2_MASK 0x80
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__ENABLEFOM_2__SHIFT 0x7
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTFOM_2_MASK 0x100
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTFOM_2__SHIFT 0x8
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RESPONSEMODE_2_MASK 0x200
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RESPONSEMODE_2__SHIFT 0x9
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RXEYEFOM_2_MASK 0x3fc00
#define PB0_RX_LANE2_SCI_STAT_OVRD_REG0__RXEYEFOM_2__SHIFT 0xa
#define PB0_RX_LANE3_CTRL_REG0__RX_BACKUP_3_MASK 0xff
#define PB0_RX_LANE3_CTRL_REG0__RX_BACKUP_3__SHIFT 0x0
#define PB0_RX_LANE3_CTRL_REG0__RX_DBG_ANALOG_SEL_3_MASK 0xc00
#define PB0_RX_LANE3_CTRL_REG0__RX_DBG_ANALOG_SEL_3__SHIFT 0xa
#define PB0_RX_LANE3_CTRL_REG0__RX_TST_BSCAN_EN_3_MASK 0x1000
#define PB0_RX_LANE3_CTRL_REG0__RX_TST_BSCAN_EN_3__SHIFT 0xc
#define PB0_RX_LANE3_CTRL_REG0__RX_CFG_OVR_PWRSF_3_MASK 0x2000
#define PB0_RX_LANE3_CTRL_REG0__RX_CFG_OVR_PWRSF_3__SHIFT 0xd
#define PB0_RX_LANE3_CTRL_REG0__RX_TERM_EN_3_MASK 0x4000
#define PB0_RX_LANE3_CTRL_REG0__RX_TERM_EN_3__SHIFT 0xe
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RXPWR_3_MASK 0x7
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RXPWR_3__SHIFT 0x0
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_3_MASK 0x8
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_3__SHIFT 0x3
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTTRK_3_MASK 0x40
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTTRK_3__SHIFT 0x6
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__ENABLEFOM_3_MASK 0x80
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__ENABLEFOM_3__SHIFT 0x7
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTFOM_3_MASK 0x100
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTFOM_3__SHIFT 0x8
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RESPONSEMODE_3_MASK 0x200
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RESPONSEMODE_3__SHIFT 0x9
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RXEYEFOM_3_MASK 0x3fc00
#define PB0_RX_LANE3_SCI_STAT_OVRD_REG0__RXEYEFOM_3__SHIFT 0xa
#define PB0_RX_LANE4_CTRL_REG0__RX_BACKUP_4_MASK 0xff
#define PB0_RX_LANE4_CTRL_REG0__RX_BACKUP_4__SHIFT 0x0
#define PB0_RX_LANE4_CTRL_REG0__RX_DBG_ANALOG_SEL_4_MASK 0xc00
#define PB0_RX_LANE4_CTRL_REG0__RX_DBG_ANALOG_SEL_4__SHIFT 0xa
#define PB0_RX_LANE4_CTRL_REG0__RX_TST_BSCAN_EN_4_MASK 0x1000
#define PB0_RX_LANE4_CTRL_REG0__RX_TST_BSCAN_EN_4__SHIFT 0xc
#define PB0_RX_LANE4_CTRL_REG0__RX_CFG_OVR_PWRSF_4_MASK 0x2000
#define PB0_RX_LANE4_CTRL_REG0__RX_CFG_OVR_PWRSF_4__SHIFT 0xd
#define PB0_RX_LANE4_CTRL_REG0__RX_TERM_EN_4_MASK 0x4000
#define PB0_RX_LANE4_CTRL_REG0__RX_TERM_EN_4__SHIFT 0xe
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RXPWR_4_MASK 0x7
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RXPWR_4__SHIFT 0x0
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_4_MASK 0x8
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_4__SHIFT 0x3
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTTRK_4_MASK 0x40
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTTRK_4__SHIFT 0x6
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__ENABLEFOM_4_MASK 0x80
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__ENABLEFOM_4__SHIFT 0x7
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTFOM_4_MASK 0x100
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTFOM_4__SHIFT 0x8
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RESPONSEMODE_4_MASK 0x200
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RESPONSEMODE_4__SHIFT 0x9
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RXEYEFOM_4_MASK 0x3fc00
#define PB0_RX_LANE4_SCI_STAT_OVRD_REG0__RXEYEFOM_4__SHIFT 0xa
#define PB0_RX_LANE5_CTRL_REG0__RX_BACKUP_5_MASK 0xff
#define PB0_RX_LANE5_CTRL_REG0__RX_BACKUP_5__SHIFT 0x0
#define PB0_RX_LANE5_CTRL_REG0__RX_DBG_ANALOG_SEL_5_MASK 0xc00
#define PB0_RX_LANE5_CTRL_REG0__RX_DBG_ANALOG_SEL_5__SHIFT 0xa
#define PB0_RX_LANE5_CTRL_REG0__RX_TST_BSCAN_EN_5_MASK 0x1000
#define PB0_RX_LANE5_CTRL_REG0__RX_TST_BSCAN_EN_5__SHIFT 0xc
#define PB0_RX_LANE5_CTRL_REG0__RX_CFG_OVR_PWRSF_5_MASK 0x2000
#define PB0_RX_LANE5_CTRL_REG0__RX_CFG_OVR_PWRSF_5__SHIFT 0xd
#define PB0_RX_LANE5_CTRL_REG0__RX_TERM_EN_5_MASK 0x4000
#define PB0_RX_LANE5_CTRL_REG0__RX_TERM_EN_5__SHIFT 0xe
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RXPWR_5_MASK 0x7
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RXPWR_5__SHIFT 0x0
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_5_MASK 0x8
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_5__SHIFT 0x3
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTTRK_5_MASK 0x40
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTTRK_5__SHIFT 0x6
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__ENABLEFOM_5_MASK 0x80
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__ENABLEFOM_5__SHIFT 0x7
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTFOM_5_MASK 0x100
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTFOM_5__SHIFT 0x8
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RESPONSEMODE_5_MASK 0x200
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RESPONSEMODE_5__SHIFT 0x9
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RXEYEFOM_5_MASK 0x3fc00
#define PB0_RX_LANE5_SCI_STAT_OVRD_REG0__RXEYEFOM_5__SHIFT 0xa
#define PB0_RX_LANE6_CTRL_REG0__RX_BACKUP_6_MASK 0xff
#define PB0_RX_LANE6_CTRL_REG0__RX_BACKUP_6__SHIFT 0x0
#define PB0_RX_LANE6_CTRL_REG0__RX_DBG_ANALOG_SEL_6_MASK 0xc00
#define PB0_RX_LANE6_CTRL_REG0__RX_DBG_ANALOG_SEL_6__SHIFT 0xa
#define PB0_RX_LANE6_CTRL_REG0__RX_TST_BSCAN_EN_6_MASK 0x1000
#define PB0_RX_LANE6_CTRL_REG0__RX_TST_BSCAN_EN_6__SHIFT 0xc
#define PB0_RX_LANE6_CTRL_REG0__RX_CFG_OVR_PWRSF_6_MASK 0x2000
#define PB0_RX_LANE6_CTRL_REG0__RX_CFG_OVR_PWRSF_6__SHIFT 0xd
#define PB0_RX_LANE6_CTRL_REG0__RX_TERM_EN_6_MASK 0x4000
#define PB0_RX_LANE6_CTRL_REG0__RX_TERM_EN_6__SHIFT 0xe
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RXPWR_6_MASK 0x7
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RXPWR_6__SHIFT 0x0
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_6_MASK 0x8
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_6__SHIFT 0x3
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTTRK_6_MASK 0x40
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTTRK_6__SHIFT 0x6
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__ENABLEFOM_6_MASK 0x80
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__ENABLEFOM_6__SHIFT 0x7
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTFOM_6_MASK 0x100
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTFOM_6__SHIFT 0x8
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RESPONSEMODE_6_MASK 0x200
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RESPONSEMODE_6__SHIFT 0x9
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RXEYEFOM_6_MASK 0x3fc00
#define PB0_RX_LANE6_SCI_STAT_OVRD_REG0__RXEYEFOM_6__SHIFT 0xa
#define PB0_RX_LANE7_CTRL_REG0__RX_BACKUP_7_MASK 0xff
#define PB0_RX_LANE7_CTRL_REG0__RX_BACKUP_7__SHIFT 0x0
#define PB0_RX_LANE7_CTRL_REG0__RX_DBG_ANALOG_SEL_7_MASK 0xc00
#define PB0_RX_LANE7_CTRL_REG0__RX_DBG_ANALOG_SEL_7__SHIFT 0xa
#define PB0_RX_LANE7_CTRL_REG0__RX_TST_BSCAN_EN_7_MASK 0x1000
#define PB0_RX_LANE7_CTRL_REG0__RX_TST_BSCAN_EN_7__SHIFT 0xc
#define PB0_RX_LANE7_CTRL_REG0__RX_CFG_OVR_PWRSF_7_MASK 0x2000
#define PB0_RX_LANE7_CTRL_REG0__RX_CFG_OVR_PWRSF_7__SHIFT 0xd
#define PB0_RX_LANE7_CTRL_REG0__RX_TERM_EN_7_MASK 0x4000
#define PB0_RX_LANE7_CTRL_REG0__RX_TERM_EN_7__SHIFT 0xe
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RXPWR_7_MASK 0x7
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RXPWR_7__SHIFT 0x0
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_7_MASK 0x8
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_7__SHIFT 0x3
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTTRK_7_MASK 0x40
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTTRK_7__SHIFT 0x6
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__ENABLEFOM_7_MASK 0x80
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__ENABLEFOM_7__SHIFT 0x7
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTFOM_7_MASK 0x100
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTFOM_7__SHIFT 0x8
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RESPONSEMODE_7_MASK 0x200
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RESPONSEMODE_7__SHIFT 0x9
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RXEYEFOM_7_MASK 0x3fc00
#define PB0_RX_LANE7_SCI_STAT_OVRD_REG0__RXEYEFOM_7__SHIFT 0xa
#define PB0_RX_LANE8_CTRL_REG0__RX_BACKUP_8_MASK 0xff
#define PB0_RX_LANE8_CTRL_REG0__RX_BACKUP_8__SHIFT 0x0
#define PB0_RX_LANE8_CTRL_REG0__RX_DBG_ANALOG_SEL_8_MASK 0xc00
#define PB0_RX_LANE8_CTRL_REG0__RX_DBG_ANALOG_SEL_8__SHIFT 0xa
#define PB0_RX_LANE8_CTRL_REG0__RX_TST_BSCAN_EN_8_MASK 0x1000
#define PB0_RX_LANE8_CTRL_REG0__RX_TST_BSCAN_EN_8__SHIFT 0xc
#define PB0_RX_LANE8_CTRL_REG0__RX_CFG_OVR_PWRSF_8_MASK 0x2000
#define PB0_RX_LANE8_CTRL_REG0__RX_CFG_OVR_PWRSF_8__SHIFT 0xd
#define PB0_RX_LANE8_CTRL_REG0__RX_TERM_EN_8_MASK 0x4000
#define PB0_RX_LANE8_CTRL_REG0__RX_TERM_EN_8__SHIFT 0xe
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RXPWR_8_MASK 0x7
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RXPWR_8__SHIFT 0x0
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_8_MASK 0x8
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_8__SHIFT 0x3
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTTRK_8_MASK 0x40
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTTRK_8__SHIFT 0x6
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__ENABLEFOM_8_MASK 0x80
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__ENABLEFOM_8__SHIFT 0x7
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTFOM_8_MASK 0x100
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTFOM_8__SHIFT 0x8
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RESPONSEMODE_8_MASK 0x200
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RESPONSEMODE_8__SHIFT 0x9
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RXEYEFOM_8_MASK 0x3fc00
#define PB0_RX_LANE8_SCI_STAT_OVRD_REG0__RXEYEFOM_8__SHIFT 0xa
#define PB0_RX_LANE9_CTRL_REG0__RX_BACKUP_9_MASK 0xff
#define PB0_RX_LANE9_CTRL_REG0__RX_BACKUP_9__SHIFT 0x0
#define PB0_RX_LANE9_CTRL_REG0__RX_DBG_ANALOG_SEL_9_MASK 0xc00
#define PB0_RX_LANE9_CTRL_REG0__RX_DBG_ANALOG_SEL_9__SHIFT 0xa
#define PB0_RX_LANE9_CTRL_REG0__RX_TST_BSCAN_EN_9_MASK 0x1000
#define PB0_RX_LANE9_CTRL_REG0__RX_TST_BSCAN_EN_9__SHIFT 0xc
#define PB0_RX_LANE9_CTRL_REG0__RX_CFG_OVR_PWRSF_9_MASK 0x2000
#define PB0_RX_LANE9_CTRL_REG0__RX_CFG_OVR_PWRSF_9__SHIFT 0xd
#define PB0_RX_LANE9_CTRL_REG0__RX_TERM_EN_9_MASK 0x4000
#define PB0_RX_LANE9_CTRL_REG0__RX_TERM_EN_9__SHIFT 0xe
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RXPWR_9_MASK 0x7
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RXPWR_9__SHIFT 0x0
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_9_MASK 0x8
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_9__SHIFT 0x3
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTTRK_9_MASK 0x40
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTTRK_9__SHIFT 0x6
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__ENABLEFOM_9_MASK 0x80
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__ENABLEFOM_9__SHIFT 0x7
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTFOM_9_MASK 0x100
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTFOM_9__SHIFT 0x8
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RESPONSEMODE_9_MASK 0x200
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RESPONSEMODE_9__SHIFT 0x9
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RXEYEFOM_9_MASK 0x3fc00
#define PB0_RX_LANE9_SCI_STAT_OVRD_REG0__RXEYEFOM_9__SHIFT 0xa
#define PB0_RX_LANE10_CTRL_REG0__RX_BACKUP_10_MASK 0xff
#define PB0_RX_LANE10_CTRL_REG0__RX_BACKUP_10__SHIFT 0x0
#define PB0_RX_LANE10_CTRL_REG0__RX_DBG_ANALOG_SEL_10_MASK 0xc00
#define PB0_RX_LANE10_CTRL_REG0__RX_DBG_ANALOG_SEL_10__SHIFT 0xa
#define PB0_RX_LANE10_CTRL_REG0__RX_TST_BSCAN_EN_10_MASK 0x1000
#define PB0_RX_LANE10_CTRL_REG0__RX_TST_BSCAN_EN_10__SHIFT 0xc
#define PB0_RX_LANE10_CTRL_REG0__RX_CFG_OVR_PWRSF_10_MASK 0x2000
#define PB0_RX_LANE10_CTRL_REG0__RX_CFG_OVR_PWRSF_10__SHIFT 0xd
#define PB0_RX_LANE10_CTRL_REG0__RX_TERM_EN_10_MASK 0x4000
#define PB0_RX_LANE10_CTRL_REG0__RX_TERM_EN_10__SHIFT 0xe
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RXPWR_10_MASK 0x7
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RXPWR_10__SHIFT 0x0
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_10_MASK 0x8
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_10__SHIFT 0x3
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTTRK_10_MASK 0x40
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTTRK_10__SHIFT 0x6
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__ENABLEFOM_10_MASK 0x80
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__ENABLEFOM_10__SHIFT 0x7
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTFOM_10_MASK 0x100
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTFOM_10__SHIFT 0x8
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RESPONSEMODE_10_MASK 0x200
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RESPONSEMODE_10__SHIFT 0x9
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RXEYEFOM_10_MASK 0x3fc00
#define PB0_RX_LANE10_SCI_STAT_OVRD_REG0__RXEYEFOM_10__SHIFT 0xa
#define PB0_RX_LANE11_CTRL_REG0__RX_BACKUP_11_MASK 0xff
#define PB0_RX_LANE11_CTRL_REG0__RX_BACKUP_11__SHIFT 0x0
#define PB0_RX_LANE11_CTRL_REG0__RX_DBG_ANALOG_SEL_11_MASK 0xc00
#define PB0_RX_LANE11_CTRL_REG0__RX_DBG_ANALOG_SEL_11__SHIFT 0xa
#define PB0_RX_LANE11_CTRL_REG0__RX_TST_BSCAN_EN_11_MASK 0x1000
#define PB0_RX_LANE11_CTRL_REG0__RX_TST_BSCAN_EN_11__SHIFT 0xc
#define PB0_RX_LANE11_CTRL_REG0__RX_CFG_OVR_PWRSF_11_MASK 0x2000
#define PB0_RX_LANE11_CTRL_REG0__RX_CFG_OVR_PWRSF_11__SHIFT 0xd
#define PB0_RX_LANE11_CTRL_REG0__RX_TERM_EN_11_MASK 0x4000
#define PB0_RX_LANE11_CTRL_REG0__RX_TERM_EN_11__SHIFT 0xe
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RXPWR_11_MASK 0x7
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RXPWR_11__SHIFT 0x0
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_11_MASK 0x8
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_11__SHIFT 0x3
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTTRK_11_MASK 0x40
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTTRK_11__SHIFT 0x6
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__ENABLEFOM_11_MASK 0x80
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__ENABLEFOM_11__SHIFT 0x7
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTFOM_11_MASK 0x100
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTFOM_11__SHIFT 0x8
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RESPONSEMODE_11_MASK 0x200
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RESPONSEMODE_11__SHIFT 0x9
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RXEYEFOM_11_MASK 0x3fc00
#define PB0_RX_LANE11_SCI_STAT_OVRD_REG0__RXEYEFOM_11__SHIFT 0xa
#define PB0_RX_LANE12_CTRL_REG0__RX_BACKUP_12_MASK 0xff
#define PB0_RX_LANE12_CTRL_REG0__RX_BACKUP_12__SHIFT 0x0
#define PB0_RX_LANE12_CTRL_REG0__RX_DBG_ANALOG_SEL_12_MASK 0xc00
#define PB0_RX_LANE12_CTRL_REG0__RX_DBG_ANALOG_SEL_12__SHIFT 0xa
#define PB0_RX_LANE12_CTRL_REG0__RX_TST_BSCAN_EN_12_MASK 0x1000
#define PB0_RX_LANE12_CTRL_REG0__RX_TST_BSCAN_EN_12__SHIFT 0xc
#define PB0_RX_LANE12_CTRL_REG0__RX_CFG_OVR_PWRSF_12_MASK 0x2000
#define PB0_RX_LANE12_CTRL_REG0__RX_CFG_OVR_PWRSF_12__SHIFT 0xd
#define PB0_RX_LANE12_CTRL_REG0__RX_TERM_EN_12_MASK 0x4000
#define PB0_RX_LANE12_CTRL_REG0__RX_TERM_EN_12__SHIFT 0xe
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RXPWR_12_MASK 0x7
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RXPWR_12__SHIFT 0x0
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_12_MASK 0x8
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_12__SHIFT 0x3
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTTRK_12_MASK 0x40
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTTRK_12__SHIFT 0x6
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__ENABLEFOM_12_MASK 0x80
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__ENABLEFOM_12__SHIFT 0x7
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTFOM_12_MASK 0x100
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTFOM_12__SHIFT 0x8
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RESPONSEMODE_12_MASK 0x200
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RESPONSEMODE_12__SHIFT 0x9
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RXEYEFOM_12_MASK 0x3fc00
#define PB0_RX_LANE12_SCI_STAT_OVRD_REG0__RXEYEFOM_12__SHIFT 0xa
#define PB0_RX_LANE13_CTRL_REG0__RX_BACKUP_13_MASK 0xff
#define PB0_RX_LANE13_CTRL_REG0__RX_BACKUP_13__SHIFT 0x0
#define PB0_RX_LANE13_CTRL_REG0__RX_DBG_ANALOG_SEL_13_MASK 0xc00
#define PB0_RX_LANE13_CTRL_REG0__RX_DBG_ANALOG_SEL_13__SHIFT 0xa
#define PB0_RX_LANE13_CTRL_REG0__RX_TST_BSCAN_EN_13_MASK 0x1000
#define PB0_RX_LANE13_CTRL_REG0__RX_TST_BSCAN_EN_13__SHIFT 0xc
#define PB0_RX_LANE13_CTRL_REG0__RX_CFG_OVR_PWRSF_13_MASK 0x2000
#define PB0_RX_LANE13_CTRL_REG0__RX_CFG_OVR_PWRSF_13__SHIFT 0xd
#define PB0_RX_LANE13_CTRL_REG0__RX_TERM_EN_13_MASK 0x4000
#define PB0_RX_LANE13_CTRL_REG0__RX_TERM_EN_13__SHIFT 0xe
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RXPWR_13_MASK 0x7
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RXPWR_13__SHIFT 0x0
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_13_MASK 0x8
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_13__SHIFT 0x3
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTTRK_13_MASK 0x40
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTTRK_13__SHIFT 0x6
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__ENABLEFOM_13_MASK 0x80
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__ENABLEFOM_13__SHIFT 0x7
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTFOM_13_MASK 0x100
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTFOM_13__SHIFT 0x8
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RESPONSEMODE_13_MASK 0x200
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RESPONSEMODE_13__SHIFT 0x9
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RXEYEFOM_13_MASK 0x3fc00
#define PB0_RX_LANE13_SCI_STAT_OVRD_REG0__RXEYEFOM_13__SHIFT 0xa
#define PB0_RX_LANE14_CTRL_REG0__RX_BACKUP_14_MASK 0xff
#define PB0_RX_LANE14_CTRL_REG0__RX_BACKUP_14__SHIFT 0x0
#define PB0_RX_LANE14_CTRL_REG0__RX_DBG_ANALOG_SEL_14_MASK 0xc00
#define PB0_RX_LANE14_CTRL_REG0__RX_DBG_ANALOG_SEL_14__SHIFT 0xa
#define PB0_RX_LANE14_CTRL_REG0__RX_TST_BSCAN_EN_14_MASK 0x1000
#define PB0_RX_LANE14_CTRL_REG0__RX_TST_BSCAN_EN_14__SHIFT 0xc
#define PB0_RX_LANE14_CTRL_REG0__RX_CFG_OVR_PWRSF_14_MASK 0x2000
#define PB0_RX_LANE14_CTRL_REG0__RX_CFG_OVR_PWRSF_14__SHIFT 0xd
#define PB0_RX_LANE14_CTRL_REG0__RX_TERM_EN_14_MASK 0x4000
#define PB0_RX_LANE14_CTRL_REG0__RX_TERM_EN_14__SHIFT 0xe
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RXPWR_14_MASK 0x7
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RXPWR_14__SHIFT 0x0
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_14_MASK 0x8
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_14__SHIFT 0x3
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTTRK_14_MASK 0x40
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTTRK_14__SHIFT 0x6
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__ENABLEFOM_14_MASK 0x80
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__ENABLEFOM_14__SHIFT 0x7
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTFOM_14_MASK 0x100
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTFOM_14__SHIFT 0x8
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RESPONSEMODE_14_MASK 0x200
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RESPONSEMODE_14__SHIFT 0x9
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RXEYEFOM_14_MASK 0x3fc00
#define PB0_RX_LANE14_SCI_STAT_OVRD_REG0__RXEYEFOM_14__SHIFT 0xa
#define PB0_RX_LANE15_CTRL_REG0__RX_BACKUP_15_MASK 0xff
#define PB0_RX_LANE15_CTRL_REG0__RX_BACKUP_15__SHIFT 0x0
#define PB0_RX_LANE15_CTRL_REG0__RX_DBG_ANALOG_SEL_15_MASK 0xc00
#define PB0_RX_LANE15_CTRL_REG0__RX_DBG_ANALOG_SEL_15__SHIFT 0xa
#define PB0_RX_LANE15_CTRL_REG0__RX_TST_BSCAN_EN_15_MASK 0x1000
#define PB0_RX_LANE15_CTRL_REG0__RX_TST_BSCAN_EN_15__SHIFT 0xc
#define PB0_RX_LANE15_CTRL_REG0__RX_CFG_OVR_PWRSF_15_MASK 0x2000
#define PB0_RX_LANE15_CTRL_REG0__RX_CFG_OVR_PWRSF_15__SHIFT 0xd
#define PB0_RX_LANE15_CTRL_REG0__RX_TERM_EN_15_MASK 0x4000
#define PB0_RX_LANE15_CTRL_REG0__RX_TERM_EN_15__SHIFT 0xe
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RXPWR_15_MASK 0x7
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RXPWR_15__SHIFT 0x0
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_15_MASK 0x8
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_15__SHIFT 0x3
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTTRK_15_MASK 0x40
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTTRK_15__SHIFT 0x6
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__ENABLEFOM_15_MASK 0x80
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__ENABLEFOM_15__SHIFT 0x7
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTFOM_15_MASK 0x100
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTFOM_15__SHIFT 0x8
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RESPONSEMODE_15_MASK 0x200
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RESPONSEMODE_15__SHIFT 0x9
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RXEYEFOM_15_MASK 0x3fc00
#define PB0_RX_LANE15_SCI_STAT_OVRD_REG0__RXEYEFOM_15__SHIFT 0xa
#define PB0_TX_GLB_CTRL_REG0__TX_DRV_DATA_ASRT_DLY_VAL_MASK 0x7
#define PB0_TX_GLB_CTRL_REG0__TX_DRV_DATA_ASRT_DLY_VAL__SHIFT 0x0
#define PB0_TX_GLB_CTRL_REG0__TX_DRV_DATA_DSRT_DLY_VAL_MASK 0x38
#define PB0_TX_GLB_CTRL_REG0__TX_DRV_DATA_DSRT_DLY_VAL__SHIFT 0x3
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN1_MASK 0x700
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN1__SHIFT 0x8
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN2_MASK 0x3800
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN2__SHIFT 0xb
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN3_MASK 0x1c000
#define PB0_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN3__SHIFT 0xe
#define PB0_TX_GLB_CTRL_REG0__TX_STAGGER_CTRL_MASK 0x60000
#define PB0_TX_GLB_CTRL_REG0__TX_STAGGER_CTRL__SHIFT 0x11
#define PB0_TX_GLB_CTRL_REG0__TX_DATA_CLK_GATING_MASK 0x80000
#define PB0_TX_GLB_CTRL_REG0__TX_DATA_CLK_GATING__SHIFT 0x13
#define PB0_TX_GLB_CTRL_REG0__TX_PRESET_TABLE_BYPASS_MASK 0x100000
#define PB0_TX_GLB_CTRL_REG0__TX_PRESET_TABLE_BYPASS__SHIFT 0x14
#define PB0_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_EN_MASK 0x200000
#define PB0_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_EN__SHIFT 0x15
#define PB0_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_DIR_VER_MASK 0x400000
#define PB0_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_DIR_VER__SHIFT 0x16
#define PB0_TX_GLB_CTRL_REG0__TX_DCLK_EN_LSX_ALWAYS_ON_MASK 0x800000
#define PB0_TX_GLB_CTRL_REG0__TX_DCLK_EN_LSX_ALWAYS_ON__SHIFT 0x17
#define PB0_TX_GLB_CTRL_REG0__TX_FRONTEND_PWRON_IN_PS4_MASK 0x1000000
#define PB0_TX_GLB_CTRL_REG0__TX_FRONTEND_PWRON_IN_PS4__SHIFT 0x18
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_0_MASK 0x1
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_0__SHIFT 0x0
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_1_MASK 0x2
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_1__SHIFT 0x1
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_2_MASK 0x4
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_2__SHIFT 0x2
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_3_MASK 0x8
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_3__SHIFT 0x3
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_4_MASK 0x10
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_4__SHIFT 0x4
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_5_MASK 0x20
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_5__SHIFT 0x5
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_6_MASK 0x40
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_6__SHIFT 0x6
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_7_MASK 0x80
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_7__SHIFT 0x7
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_8_MASK 0x100
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_8__SHIFT 0x8
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_9_MASK 0x200
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_9__SHIFT 0x9
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_10_MASK 0x400
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_10__SHIFT 0xa
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_11_MASK 0x800
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_11__SHIFT 0xb
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_12_MASK 0x1000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_12__SHIFT 0xc
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_13_MASK 0x2000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_13__SHIFT 0xd
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_14_MASK 0x4000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_14__SHIFT 0xe
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_15_MASK 0x8000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_15__SHIFT 0xf
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L0T1_MASK 0x10000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L0T1__SHIFT 0x10
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L2T3_MASK 0x20000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L2T3__SHIFT 0x11
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L4T5_MASK 0x40000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L4T5__SHIFT 0x12
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L6T7_MASK 0x80000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L6T7__SHIFT 0x13
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L8T9_MASK 0x100000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L8T9__SHIFT 0x14
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L10T11_MASK 0x200000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L10T11__SHIFT 0x15
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L12T13_MASK 0x400000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L12T13__SHIFT 0x16
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L14T15_MASK 0x800000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L14T15__SHIFT 0x17
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L0T3_MASK 0x1000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L0T3__SHIFT 0x18
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L4T7_MASK 0x2000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L4T7__SHIFT 0x19
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L8T11_MASK 0x4000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L8T11__SHIFT 0x1a
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L12T15_MASK 0x8000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L12T15__SHIFT 0x1b
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L0T7_MASK 0x10000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L0T7__SHIFT 0x1c
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L8T15_MASK 0x20000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L8T15__SHIFT 0x1d
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX16_EN_L0T15_MASK 0x40000000
#define PB0_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX16_EN_L0T15__SHIFT 0x1e
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L0T3_MASK 0x1
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L0T3__SHIFT 0x0
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L4T7_MASK 0x2
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L4T7__SHIFT 0x1
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L8T11_MASK 0x4
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L8T11__SHIFT 0x2
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L12T15_MASK 0x8
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L12T15__SHIFT 0x3
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L0T3_MASK 0x100
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L0T3__SHIFT 0x8
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L4T7_MASK 0x200
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L4T7__SHIFT 0x9
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L8T11_MASK 0x400
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L8T11__SHIFT 0xa
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L12T15_MASK 0x800
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L12T15__SHIFT 0xb
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L0T3_MASK 0x1000
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L0T3__SHIFT 0xc
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L4T7_MASK 0x2000
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L4T7__SHIFT 0xd
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L8T11_MASK 0x4000
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L8T11__SHIFT 0xe
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L12T15_MASK 0x8000
#define PB0_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L12T15__SHIFT 0xf
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_0_MASK 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_0__SHIFT 0x0
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_1_MASK 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_1__SHIFT 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_2_MASK 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_2__SHIFT 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_3_MASK 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_3__SHIFT 0x3
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_4_MASK 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_4__SHIFT 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_5_MASK 0x20
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_5__SHIFT 0x5
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_6_MASK 0x40
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_6__SHIFT 0x6
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_7_MASK 0x80
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_7__SHIFT 0x7
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_8_MASK 0x100
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_8__SHIFT 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_9_MASK 0x200
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_9__SHIFT 0x9
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_10_MASK 0x400
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_10__SHIFT 0xa
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_11_MASK 0x800
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_11__SHIFT 0xb
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_12_MASK 0x1000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_12__SHIFT 0xc
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_13_MASK 0x2000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_13__SHIFT 0xd
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_14_MASK 0x4000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_14__SHIFT 0xe
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_15_MASK 0x8000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_15__SHIFT 0xf
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_16_MASK 0x10000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_16__SHIFT 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_17_MASK 0x20000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_17__SHIFT 0x11
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_18_MASK 0x40000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_18__SHIFT 0x12
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_19_MASK 0x80000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_19__SHIFT 0x13
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_20_MASK 0x100000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_20__SHIFT 0x14
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_21_MASK 0x200000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_21__SHIFT 0x15
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_22_MASK 0x400000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_22__SHIFT 0x16
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_23_MASK 0x800000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_23__SHIFT 0x17
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_24_MASK 0x1000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_24__SHIFT 0x18
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_25_MASK 0x2000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_25__SHIFT 0x19
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_26_MASK 0x4000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_26__SHIFT 0x1a
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_27_MASK 0x8000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_27__SHIFT 0x1b
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_28_MASK 0x10000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_28__SHIFT 0x1c
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_29_MASK 0x20000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_29__SHIFT 0x1d
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_30_MASK 0x40000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_30__SHIFT 0x1e
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_31_MASK 0x80000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_31__SHIFT 0x1f
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_32_MASK 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_32__SHIFT 0x0
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_33_MASK 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_33__SHIFT 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_34_MASK 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_34__SHIFT 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_35_MASK 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_35__SHIFT 0x3
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_36_MASK 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_36__SHIFT 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_37_MASK 0x20
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_37__SHIFT 0x5
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_38_MASK 0x40
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_38__SHIFT 0x6
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_39_MASK 0x80
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_39__SHIFT 0x7
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_40_MASK 0x100
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_40__SHIFT 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_41_MASK 0x200
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_41__SHIFT 0x9
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_42_MASK 0x400
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_42__SHIFT 0xa
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_43_MASK 0x800
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_43__SHIFT 0xb
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_44_MASK 0x1000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_44__SHIFT 0xc
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_45_MASK 0x2000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_45__SHIFT 0xd
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_46_MASK 0x4000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_46__SHIFT 0xe
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_47_MASK 0x8000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_47__SHIFT 0xf
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_48_MASK 0x10000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_48__SHIFT 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_49_MASK 0x20000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_49__SHIFT 0x11
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_50_MASK 0x40000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_50__SHIFT 0x12
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_51_MASK 0x80000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_51__SHIFT 0x13
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_52_MASK 0x100000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_52__SHIFT 0x14
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_53_MASK 0x200000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_53__SHIFT 0x15
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_54_MASK 0x400000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_54__SHIFT 0x16
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_55_MASK 0x800000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_55__SHIFT 0x17
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_56_MASK 0x1000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_56__SHIFT 0x18
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_57_MASK 0x2000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_57__SHIFT 0x19
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_58_MASK 0x4000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_58__SHIFT 0x1a
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_59_MASK 0x8000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_59__SHIFT 0x1b
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_60_MASK 0x10000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_60__SHIFT 0x1c
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_61_MASK 0x20000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_61__SHIFT 0x1d
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_62_MASK 0x40000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_62__SHIFT 0x1e
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_63_MASK 0x80000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_63__SHIFT 0x1f
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_64_MASK 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_64__SHIFT 0x0
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_65_MASK 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_65__SHIFT 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_66_MASK 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_66__SHIFT 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_67_MASK 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_67__SHIFT 0x3
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_68_MASK 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_68__SHIFT 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_69_MASK 0x20
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_69__SHIFT 0x5
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_70_MASK 0x40
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_70__SHIFT 0x6
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_71_MASK 0x80
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_71__SHIFT 0x7
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_72_MASK 0x100
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_72__SHIFT 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_73_MASK 0x200
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_73__SHIFT 0x9
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_74_MASK 0x400
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_74__SHIFT 0xa
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_75_MASK 0x800
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_75__SHIFT 0xb
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_76_MASK 0x1000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_76__SHIFT 0xc
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_77_MASK 0x2000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_77__SHIFT 0xd
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_78_MASK 0x4000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_78__SHIFT 0xe
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_79_MASK 0x8000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_79__SHIFT 0xf
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_80_MASK 0x10000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_80__SHIFT 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_81_MASK 0x20000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_81__SHIFT 0x11
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_82_MASK 0x40000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_82__SHIFT 0x12
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_83_MASK 0x80000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_83__SHIFT 0x13
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_84_MASK 0x100000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_84__SHIFT 0x14
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_85_MASK 0x200000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_85__SHIFT 0x15
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_86_MASK 0x400000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_86__SHIFT 0x16
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_87_MASK 0x800000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_87__SHIFT 0x17
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_88_MASK 0x1000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_88__SHIFT 0x18
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_89_MASK 0x2000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_89__SHIFT 0x19
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_90_MASK 0x4000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_90__SHIFT 0x1a
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_91_MASK 0x8000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_91__SHIFT 0x1b
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_92_MASK 0x10000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_92__SHIFT 0x1c
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_93_MASK 0x20000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_93__SHIFT 0x1d
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_94_MASK 0x40000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_94__SHIFT 0x1e
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_95_MASK 0x80000000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_95__SHIFT 0x1f
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_96_MASK 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_96__SHIFT 0x0
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_97_MASK 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_97__SHIFT 0x1
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_98_MASK 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_98__SHIFT 0x2
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_99_MASK 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_99__SHIFT 0x3
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_100_MASK 0x10
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_100__SHIFT 0x4
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_101_MASK 0x20
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_101__SHIFT 0x5
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_102_MASK 0x40
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_102__SHIFT 0x6
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_103_MASK 0x80
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_103__SHIFT 0x7
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_104_MASK 0x100
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_104__SHIFT 0x8
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_105_MASK 0x200
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_105__SHIFT 0x9
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_106_MASK 0x400
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_106__SHIFT 0xa
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_107_MASK 0x800
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_107__SHIFT 0xb
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_108_MASK 0x1000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_108__SHIFT 0xc
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_109_MASK 0x2000
#define PB0_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_109__SHIFT 0xd
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_VAL_MASK 0x7
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_VAL__SHIFT 0x0
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_EN_MASK 0x8
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_EN__SHIFT 0x3
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_GEN1_OVRD_VAL_MASK 0xf0
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_GEN1_OVRD_VAL__SHIFT 0x4
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_OVRD_EN_MASK 0x100
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_OVRD_EN__SHIFT 0x8
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_GEN1_OVRD_VAL_MASK 0x1e00
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x9
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_OVRD_EN_MASK 0x2000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_OVRD_EN__SHIFT 0xd
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_GEN1_OVRD_VAL_MASK 0x7c000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_GEN1_OVRD_VAL__SHIFT 0xe
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_OVRD_EN_MASK 0x80000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_OVRD_EN__SHIFT 0x13
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_GEN1_OVRD_VAL_MASK 0x1f00000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x14
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_OVRD_EN_MASK 0x2000000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_OVRD_EN__SHIFT 0x19
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_GEN1_OVRD_VAL_MASK 0x3c000000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_GEN1_OVRD_VAL__SHIFT 0x1a
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_OVRD_EN_MASK 0x40000000
#define PB0_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_OVRD_EN__SHIFT 0x1e
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_GEN1_OVRD_VAL_MASK 0xf
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x0
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_OVRD_EN_MASK 0x10
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_OVRD_EN__SHIFT 0x4
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_GEN1_OVRD_VAL_MASK 0x20
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_GEN1_OVRD_VAL__SHIFT 0x5
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_OVRD_EN_MASK 0x40
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_OVRD_EN__SHIFT 0x6
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_GEN1_OVRD_VAL_MASK 0x80
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x7
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_OVRD_EN_MASK 0x100
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_OVRD_EN__SHIFT 0x8
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_VAL_MASK 0x200
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_VAL__SHIFT 0x9
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_EN_MASK 0x400
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_EN__SHIFT 0xa
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_VAL_MASK 0x800
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_VAL__SHIFT 0xb
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_EN_MASK 0x1000
#define PB0_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_EN__SHIFT 0xc
#define PB0_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_VAL_MASK 0x2000
#define PB0_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_VAL__SHIFT 0xd
#define PB0_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_EN_MASK 0x4000
#define PB0_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_EN__SHIFT 0xe
#define PB0_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_VAL_MASK 0x1ff8000
#define PB0_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_VAL__SHIFT 0xf
#define PB0_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_EN_MASK 0x2000000
#define PB0_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_EN__SHIFT 0x19
#define PB0_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_VAL_MASK 0x4000000
#define PB0_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_VAL__SHIFT 0x1a
#define PB0_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_EN_MASK 0x8000000
#define PB0_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_EN__SHIFT 0x1b
#define PB0_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_VAL_MASK 0x10000000
#define PB0_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_VAL__SHIFT 0x1c
#define PB0_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_EN_MASK 0x20000000
#define PB0_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_EN__SHIFT 0x1d
#define PB0_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_VAL_MASK 0x40000000
#define PB0_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_VAL__SHIFT 0x1e
#define PB0_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_EN_MASK 0x80000000
#define PB0_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_EN__SHIFT 0x1f
#define PB0_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_VAL_MASK 0x1
#define PB0_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_VAL__SHIFT 0x0
#define PB0_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_EN_MASK 0x2
#define PB0_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_EN__SHIFT 0x1
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_VAL_MASK 0x4
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_VAL__SHIFT 0x2
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_EN_MASK 0x8
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_EN__SHIFT 0x3
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_VAL_MASK 0x10
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_VAL__SHIFT 0x4
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_EN_MASK 0x20
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_EN__SHIFT 0x5
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_VAL_MASK 0x40
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_VAL__SHIFT 0x6
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_EN_MASK 0x80
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_EN__SHIFT 0x7
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_VAL_MASK 0x100
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_VAL__SHIFT 0x8
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_EN_MASK 0x200
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_EN__SHIFT 0x9
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_VAL_MASK 0x400
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_VAL__SHIFT 0xa
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_EN_MASK 0x800
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_EN__SHIFT 0xb
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV0_EN_GEN2_OVRD_VAL_MASK 0xf000
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV0_EN_GEN2_OVRD_VAL__SHIFT 0xc
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV0_TAP_SEL_GEN2_OVRD_VAL_MASK 0xf0000
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV0_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x10
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV1_EN_GEN2_OVRD_VAL_MASK 0x1f00000
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV1_EN_GEN2_OVRD_VAL__SHIFT 0x14
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV1_TAP_SEL_GEN2_OVRD_VAL_MASK 0x3e000000
#define PB0_TX_GLB_OVRD_REG2__TX_CFG_DRV1_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x19
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN2_OVRD_VAL_MASK 0xf
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN2_OVRD_VAL__SHIFT 0x0
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_TAP_SEL_GEN2_OVRD_VAL_MASK 0xf0
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x4
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRVX_EN_GEN2_OVRD_VAL_MASK 0x100
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRVX_EN_GEN2_OVRD_VAL__SHIFT 0x8
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRVX_TAP_SEL_GEN2_OVRD_VAL_MASK 0x200
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRVX_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x9
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV0_EN_GEN3_OVRD_VAL_MASK 0x3c00
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV0_EN_GEN3_OVRD_VAL__SHIFT 0xa
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV0_TAP_SEL_GEN3_OVRD_VAL_MASK 0x3c000
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV0_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0xe
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV1_EN_GEN3_OVRD_VAL_MASK 0x7c0000
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV1_EN_GEN3_OVRD_VAL__SHIFT 0x12
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV1_TAP_SEL_GEN3_OVRD_VAL_MASK 0xf800000
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV1_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x17
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN3_OVRD_VAL_MASK 0xf0000000
#define PB0_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN3_OVRD_VAL__SHIFT 0x1c
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRV2_TAP_SEL_GEN3_OVRD_VAL_MASK 0xf
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRV2_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x0
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRVX_EN_GEN3_OVRD_VAL_MASK 0x10
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRVX_EN_GEN3_OVRD_VAL__SHIFT 0x4
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRVX_TAP_SEL_GEN3_OVRD_VAL_MASK 0x20
#define PB0_TX_GLB_OVRD_REG4__TX_CFG_DRVX_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x5
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_DISPCLK_MODE_0_MASK 0x1
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_DISPCLK_MODE_0__SHIFT 0x0
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_INV_DATA_0_MASK 0x2
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_INV_DATA_0__SHIFT 0x1
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_SWING_BOOST_EN_0_MASK 0x4
#define PB0_TX_LANE0_CTRL_REG0__TX_CFG_SWING_BOOST_EN_0__SHIFT 0x2
#define PB0_TX_LANE0_CTRL_REG0__TX_DBG_PRBS_EN_0_MASK 0x8
#define PB0_TX_LANE0_CTRL_REG0__TX_DBG_PRBS_EN_0__SHIFT 0x3
#define PB0_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_0_MASK 0x1
#define PB0_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_0__SHIFT 0x0
#define PB0_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_EN_0_MASK 0x2
#define PB0_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_EN_0__SHIFT 0x1
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_0_MASK 0x4
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_0__SHIFT 0x2
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_0_MASK 0x8
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_0__SHIFT 0x3
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_0_MASK 0x10
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_0__SHIFT 0x4
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_0_MASK 0x20
#define PB0_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_0__SHIFT 0x5
#define PB0_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_0_MASK 0x40
#define PB0_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_0__SHIFT 0x6
#define PB0_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_0_MASK 0x80
#define PB0_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_0__SHIFT 0x7
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__TXPWR_0_MASK 0x7
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__TXPWR_0__SHIFT 0x0
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__TXMARG_0_MASK 0x70
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__TXMARG_0__SHIFT 0x4
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__DEEMPH_0_MASK 0x80
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__DEEMPH_0__SHIFT 0x7
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENTID_0_MASK 0x300
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENTID_0__SHIFT 0x8
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENT_0_MASK 0xfc00
#define PB0_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENT_0__SHIFT 0xa
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_DISPCLK_MODE_1_MASK 0x1
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_DISPCLK_MODE_1__SHIFT 0x0
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_INV_DATA_1_MASK 0x2
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_INV_DATA_1__SHIFT 0x1
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_SWING_BOOST_EN_1_MASK 0x4
#define PB0_TX_LANE1_CTRL_REG0__TX_CFG_SWING_BOOST_EN_1__SHIFT 0x2
#define PB0_TX_LANE1_CTRL_REG0__TX_DBG_PRBS_EN_1_MASK 0x8
#define PB0_TX_LANE1_CTRL_REG0__TX_DBG_PRBS_EN_1__SHIFT 0x3
#define PB0_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_1_MASK 0x1
#define PB0_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_1__SHIFT 0x0
#define PB0_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_EN_1_MASK 0x2
#define PB0_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_EN_1__SHIFT 0x1
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_1_MASK 0x4
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_1__SHIFT 0x2
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_1_MASK 0x8
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_1__SHIFT 0x3
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_1_MASK 0x10
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_1__SHIFT 0x4
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_1_MASK 0x20
#define PB0_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_1__SHIFT 0x5
#define PB0_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_1_MASK 0x40
#define PB0_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_1__SHIFT 0x6
#define PB0_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_1_MASK 0x80
#define PB0_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_1__SHIFT 0x7
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__TXPWR_1_MASK 0x7
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__TXPWR_1__SHIFT 0x0
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__TXMARG_1_MASK 0x70
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__TXMARG_1__SHIFT 0x4
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__DEEMPH_1_MASK 0x80
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__DEEMPH_1__SHIFT 0x7
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENTID_1_MASK 0x300
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENTID_1__SHIFT 0x8
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENT_1_MASK 0xfc00
#define PB0_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENT_1__SHIFT 0xa
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_DISPCLK_MODE_2_MASK 0x1
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_DISPCLK_MODE_2__SHIFT 0x0
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_INV_DATA_2_MASK 0x2
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_INV_DATA_2__SHIFT 0x1
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_SWING_BOOST_EN_2_MASK 0x4
#define PB0_TX_LANE2_CTRL_REG0__TX_CFG_SWING_BOOST_EN_2__SHIFT 0x2
#define PB0_TX_LANE2_CTRL_REG0__TX_DBG_PRBS_EN_2_MASK 0x8
#define PB0_TX_LANE2_CTRL_REG0__TX_DBG_PRBS_EN_2__SHIFT 0x3
#define PB0_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_2_MASK 0x1
#define PB0_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_2__SHIFT 0x0
#define PB0_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_EN_2_MASK 0x2
#define PB0_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_EN_2__SHIFT 0x1
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_2_MASK 0x4
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_2__SHIFT 0x2
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_2_MASK 0x8
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_2__SHIFT 0x3
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_2_MASK 0x10
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_2__SHIFT 0x4
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_2_MASK 0x20
#define PB0_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_2__SHIFT 0x5
#define PB0_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_2_MASK 0x40
#define PB0_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_2__SHIFT 0x6
#define PB0_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_2_MASK 0x80
#define PB0_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_2__SHIFT 0x7
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__TXPWR_2_MASK 0x7
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__TXPWR_2__SHIFT 0x0
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__TXMARG_2_MASK 0x70
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__TXMARG_2__SHIFT 0x4
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__DEEMPH_2_MASK 0x80
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__DEEMPH_2__SHIFT 0x7
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENTID_2_MASK 0x300
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENTID_2__SHIFT 0x8
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENT_2_MASK 0xfc00
#define PB0_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENT_2__SHIFT 0xa
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_DISPCLK_MODE_3_MASK 0x1
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_DISPCLK_MODE_3__SHIFT 0x0
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_INV_DATA_3_MASK 0x2
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_INV_DATA_3__SHIFT 0x1
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_SWING_BOOST_EN_3_MASK 0x4
#define PB0_TX_LANE3_CTRL_REG0__TX_CFG_SWING_BOOST_EN_3__SHIFT 0x2
#define PB0_TX_LANE3_CTRL_REG0__TX_DBG_PRBS_EN_3_MASK 0x8
#define PB0_TX_LANE3_CTRL_REG0__TX_DBG_PRBS_EN_3__SHIFT 0x3
#define PB0_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_3_MASK 0x1
#define PB0_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_3__SHIFT 0x0
#define PB0_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_EN_3_MASK 0x2
#define PB0_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_EN_3__SHIFT 0x1
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_3_MASK 0x4
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_3__SHIFT 0x2
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_3_MASK 0x8
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_3__SHIFT 0x3
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_3_MASK 0x10
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_3__SHIFT 0x4
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_3_MASK 0x20
#define PB0_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_3__SHIFT 0x5
#define PB0_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_3_MASK 0x40
#define PB0_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_3__SHIFT 0x6
#define PB0_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_3_MASK 0x80
#define PB0_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_3__SHIFT 0x7
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__TXPWR_3_MASK 0x7
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__TXPWR_3__SHIFT 0x0
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__TXMARG_3_MASK 0x70
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__TXMARG_3__SHIFT 0x4
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__DEEMPH_3_MASK 0x80
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__DEEMPH_3__SHIFT 0x7
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENTID_3_MASK 0x300
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENTID_3__SHIFT 0x8
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENT_3_MASK 0xfc00
#define PB0_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENT_3__SHIFT 0xa
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_DISPCLK_MODE_4_MASK 0x1
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_DISPCLK_MODE_4__SHIFT 0x0
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_INV_DATA_4_MASK 0x2
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_INV_DATA_4__SHIFT 0x1
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_SWING_BOOST_EN_4_MASK 0x4
#define PB0_TX_LANE4_CTRL_REG0__TX_CFG_SWING_BOOST_EN_4__SHIFT 0x2
#define PB0_TX_LANE4_CTRL_REG0__TX_DBG_PRBS_EN_4_MASK 0x8
#define PB0_TX_LANE4_CTRL_REG0__TX_DBG_PRBS_EN_4__SHIFT 0x3
#define PB0_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_4_MASK 0x1
#define PB0_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_4__SHIFT 0x0
#define PB0_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_EN_4_MASK 0x2
#define PB0_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_EN_4__SHIFT 0x1
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_4_MASK 0x4
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_4__SHIFT 0x2
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_4_MASK 0x8
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_4__SHIFT 0x3
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_4_MASK 0x10
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_4__SHIFT 0x4
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_4_MASK 0x20
#define PB0_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_4__SHIFT 0x5
#define PB0_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_4_MASK 0x40
#define PB0_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_4__SHIFT 0x6
#define PB0_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_4_MASK 0x80
#define PB0_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_4__SHIFT 0x7
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__TXPWR_4_MASK 0x7
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__TXPWR_4__SHIFT 0x0
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__TXMARG_4_MASK 0x70
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__TXMARG_4__SHIFT 0x4
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__DEEMPH_4_MASK 0x80
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__DEEMPH_4__SHIFT 0x7
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENTID_4_MASK 0x300
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENTID_4__SHIFT 0x8
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENT_4_MASK 0xfc00
#define PB0_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENT_4__SHIFT 0xa
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_DISPCLK_MODE_5_MASK 0x1
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_DISPCLK_MODE_5__SHIFT 0x0
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_INV_DATA_5_MASK 0x2
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_INV_DATA_5__SHIFT 0x1
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_SWING_BOOST_EN_5_MASK 0x4
#define PB0_TX_LANE5_CTRL_REG0__TX_CFG_SWING_BOOST_EN_5__SHIFT 0x2
#define PB0_TX_LANE5_CTRL_REG0__TX_DBG_PRBS_EN_5_MASK 0x8
#define PB0_TX_LANE5_CTRL_REG0__TX_DBG_PRBS_EN_5__SHIFT 0x3
#define PB0_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_5_MASK 0x1
#define PB0_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_5__SHIFT 0x0
#define PB0_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_EN_5_MASK 0x2
#define PB0_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_EN_5__SHIFT 0x1
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_5_MASK 0x4
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_5__SHIFT 0x2
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_5_MASK 0x8
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_5__SHIFT 0x3
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_5_MASK 0x10
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_5__SHIFT 0x4
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_5_MASK 0x20
#define PB0_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_5__SHIFT 0x5
#define PB0_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_5_MASK 0x40
#define PB0_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_5__SHIFT 0x6
#define PB0_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_5_MASK 0x80
#define PB0_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_5__SHIFT 0x7
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__TXPWR_5_MASK 0x7
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__TXPWR_5__SHIFT 0x0
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__TXMARG_5_MASK 0x70
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__TXMARG_5__SHIFT 0x4
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__DEEMPH_5_MASK 0x80
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__DEEMPH_5__SHIFT 0x7
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENTID_5_MASK 0x300
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENTID_5__SHIFT 0x8
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENT_5_MASK 0xfc00
#define PB0_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENT_5__SHIFT 0xa
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_DISPCLK_MODE_6_MASK 0x1
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_DISPCLK_MODE_6__SHIFT 0x0
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_INV_DATA_6_MASK 0x2
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_INV_DATA_6__SHIFT 0x1
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_SWING_BOOST_EN_6_MASK 0x4
#define PB0_TX_LANE6_CTRL_REG0__TX_CFG_SWING_BOOST_EN_6__SHIFT 0x2
#define PB0_TX_LANE6_CTRL_REG0__TX_DBG_PRBS_EN_6_MASK 0x8
#define PB0_TX_LANE6_CTRL_REG0__TX_DBG_PRBS_EN_6__SHIFT 0x3
#define PB0_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_6_MASK 0x1
#define PB0_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_6__SHIFT 0x0
#define PB0_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_EN_6_MASK 0x2
#define PB0_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_EN_6__SHIFT 0x1
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_6_MASK 0x4
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_6__SHIFT 0x2
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_6_MASK 0x8
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_6__SHIFT 0x3
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_6_MASK 0x10
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_6__SHIFT 0x4
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_6_MASK 0x20
#define PB0_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_6__SHIFT 0x5
#define PB0_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_6_MASK 0x40
#define PB0_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_6__SHIFT 0x6
#define PB0_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_6_MASK 0x80
#define PB0_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_6__SHIFT 0x7
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__TXPWR_6_MASK 0x7
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__TXPWR_6__SHIFT 0x0
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__TXMARG_6_MASK 0x70
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__TXMARG_6__SHIFT 0x4
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__DEEMPH_6_MASK 0x80
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__DEEMPH_6__SHIFT 0x7
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENTID_6_MASK 0x300
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENTID_6__SHIFT 0x8
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENT_6_MASK 0xfc00
#define PB0_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENT_6__SHIFT 0xa
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_DISPCLK_MODE_7_MASK 0x1
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_DISPCLK_MODE_7__SHIFT 0x0
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_INV_DATA_7_MASK 0x2
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_INV_DATA_7__SHIFT 0x1
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_SWING_BOOST_EN_7_MASK 0x4
#define PB0_TX_LANE7_CTRL_REG0__TX_CFG_SWING_BOOST_EN_7__SHIFT 0x2
#define PB0_TX_LANE7_CTRL_REG0__TX_DBG_PRBS_EN_7_MASK 0x8
#define PB0_TX_LANE7_CTRL_REG0__TX_DBG_PRBS_EN_7__SHIFT 0x3
#define PB0_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_7_MASK 0x1
#define PB0_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_7__SHIFT 0x0
#define PB0_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_EN_7_MASK 0x2
#define PB0_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_EN_7__SHIFT 0x1
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_7_MASK 0x4
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_7__SHIFT 0x2
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_7_MASK 0x8
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_7__SHIFT 0x3
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_7_MASK 0x10
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_7__SHIFT 0x4
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_7_MASK 0x20
#define PB0_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_7__SHIFT 0x5
#define PB0_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_7_MASK 0x40
#define PB0_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_7__SHIFT 0x6
#define PB0_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_7_MASK 0x80
#define PB0_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_7__SHIFT 0x7
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__TXPWR_7_MASK 0x7
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__TXPWR_7__SHIFT 0x0
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__TXMARG_7_MASK 0x70
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__TXMARG_7__SHIFT 0x4
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__DEEMPH_7_MASK 0x80
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__DEEMPH_7__SHIFT 0x7
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENTID_7_MASK 0x300
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENTID_7__SHIFT 0x8
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENT_7_MASK 0xfc00
#define PB0_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENT_7__SHIFT 0xa
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_DISPCLK_MODE_8_MASK 0x1
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_DISPCLK_MODE_8__SHIFT 0x0
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_INV_DATA_8_MASK 0x2
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_INV_DATA_8__SHIFT 0x1
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_SWING_BOOST_EN_8_MASK 0x4
#define PB0_TX_LANE8_CTRL_REG0__TX_CFG_SWING_BOOST_EN_8__SHIFT 0x2
#define PB0_TX_LANE8_CTRL_REG0__TX_DBG_PRBS_EN_8_MASK 0x8
#define PB0_TX_LANE8_CTRL_REG0__TX_DBG_PRBS_EN_8__SHIFT 0x3
#define PB0_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_8_MASK 0x1
#define PB0_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_8__SHIFT 0x0
#define PB0_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_EN_8_MASK 0x2
#define PB0_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_EN_8__SHIFT 0x1
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_8_MASK 0x4
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_8__SHIFT 0x2
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_8_MASK 0x8
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_8__SHIFT 0x3
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_8_MASK 0x10
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_8__SHIFT 0x4
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_8_MASK 0x20
#define PB0_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_8__SHIFT 0x5
#define PB0_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_8_MASK 0x40
#define PB0_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_8__SHIFT 0x6
#define PB0_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_8_MASK 0x80
#define PB0_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_8__SHIFT 0x7
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__TXPWR_8_MASK 0x7
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__TXPWR_8__SHIFT 0x0
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__TXMARG_8_MASK 0x70
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__TXMARG_8__SHIFT 0x4
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__DEEMPH_8_MASK 0x80
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__DEEMPH_8__SHIFT 0x7
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENTID_8_MASK 0x300
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENTID_8__SHIFT 0x8
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENT_8_MASK 0xfc00
#define PB0_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENT_8__SHIFT 0xa
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_DISPCLK_MODE_9_MASK 0x1
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_DISPCLK_MODE_9__SHIFT 0x0
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_INV_DATA_9_MASK 0x2
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_INV_DATA_9__SHIFT 0x1
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_SWING_BOOST_EN_9_MASK 0x4
#define PB0_TX_LANE9_CTRL_REG0__TX_CFG_SWING_BOOST_EN_9__SHIFT 0x2
#define PB0_TX_LANE9_CTRL_REG0__TX_DBG_PRBS_EN_9_MASK 0x8
#define PB0_TX_LANE9_CTRL_REG0__TX_DBG_PRBS_EN_9__SHIFT 0x3
#define PB0_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_9_MASK 0x1
#define PB0_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_9__SHIFT 0x0
#define PB0_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_EN_9_MASK 0x2
#define PB0_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_EN_9__SHIFT 0x1
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_9_MASK 0x4
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_9__SHIFT 0x2
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_9_MASK 0x8
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_9__SHIFT 0x3
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_9_MASK 0x10
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_9__SHIFT 0x4
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_9_MASK 0x20
#define PB0_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_9__SHIFT 0x5
#define PB0_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_9_MASK 0x40
#define PB0_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_9__SHIFT 0x6
#define PB0_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_9_MASK 0x80
#define PB0_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_9__SHIFT 0x7
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__TXPWR_9_MASK 0x7
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__TXPWR_9__SHIFT 0x0
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__TXMARG_9_MASK 0x70
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__TXMARG_9__SHIFT 0x4
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__DEEMPH_9_MASK 0x80
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__DEEMPH_9__SHIFT 0x7
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENTID_9_MASK 0x300
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENTID_9__SHIFT 0x8
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENT_9_MASK 0xfc00
#define PB0_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENT_9__SHIFT 0xa
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_DISPCLK_MODE_10_MASK 0x1
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_DISPCLK_MODE_10__SHIFT 0x0
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_INV_DATA_10_MASK 0x2
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_INV_DATA_10__SHIFT 0x1
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_SWING_BOOST_EN_10_MASK 0x4
#define PB0_TX_LANE10_CTRL_REG0__TX_CFG_SWING_BOOST_EN_10__SHIFT 0x2
#define PB0_TX_LANE10_CTRL_REG0__TX_DBG_PRBS_EN_10_MASK 0x8
#define PB0_TX_LANE10_CTRL_REG0__TX_DBG_PRBS_EN_10__SHIFT 0x3
#define PB0_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_10_MASK 0x1
#define PB0_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_10__SHIFT 0x0
#define PB0_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_EN_10_MASK 0x2
#define PB0_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_EN_10__SHIFT 0x1
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_10_MASK 0x4
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_10__SHIFT 0x2
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_10_MASK 0x8
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_10__SHIFT 0x3
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_10_MASK 0x10
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_10__SHIFT 0x4
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_10_MASK 0x20
#define PB0_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_10__SHIFT 0x5
#define PB0_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_10_MASK 0x40
#define PB0_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_10__SHIFT 0x6
#define PB0_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_10_MASK 0x80
#define PB0_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_10__SHIFT 0x7
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__TXPWR_10_MASK 0x7
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__TXPWR_10__SHIFT 0x0
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__TXMARG_10_MASK 0x70
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__TXMARG_10__SHIFT 0x4
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__DEEMPH_10_MASK 0x80
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__DEEMPH_10__SHIFT 0x7
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENTID_10_MASK 0x300
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENTID_10__SHIFT 0x8
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENT_10_MASK 0xfc00
#define PB0_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENT_10__SHIFT 0xa
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_DISPCLK_MODE_11_MASK 0x1
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_DISPCLK_MODE_11__SHIFT 0x0
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_INV_DATA_11_MASK 0x2
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_INV_DATA_11__SHIFT 0x1
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_SWING_BOOST_EN_11_MASK 0x4
#define PB0_TX_LANE11_CTRL_REG0__TX_CFG_SWING_BOOST_EN_11__SHIFT 0x2
#define PB0_TX_LANE11_CTRL_REG0__TX_DBG_PRBS_EN_11_MASK 0x8
#define PB0_TX_LANE11_CTRL_REG0__TX_DBG_PRBS_EN_11__SHIFT 0x3
#define PB0_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_11_MASK 0x1
#define PB0_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_11__SHIFT 0x0
#define PB0_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_EN_11_MASK 0x2
#define PB0_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_EN_11__SHIFT 0x1
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_11_MASK 0x4
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_11__SHIFT 0x2
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_11_MASK 0x8
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_11__SHIFT 0x3
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_11_MASK 0x10
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_11__SHIFT 0x4
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_11_MASK 0x20
#define PB0_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_11__SHIFT 0x5
#define PB0_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_11_MASK 0x40
#define PB0_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_11__SHIFT 0x6
#define PB0_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_11_MASK 0x80
#define PB0_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_11__SHIFT 0x7
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__TXPWR_11_MASK 0x7
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__TXPWR_11__SHIFT 0x0
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__TXMARG_11_MASK 0x70
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__TXMARG_11__SHIFT 0x4
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__DEEMPH_11_MASK 0x80
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__DEEMPH_11__SHIFT 0x7
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENTID_11_MASK 0x300
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENTID_11__SHIFT 0x8
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENT_11_MASK 0xfc00
#define PB0_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENT_11__SHIFT 0xa
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_DISPCLK_MODE_12_MASK 0x1
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_DISPCLK_MODE_12__SHIFT 0x0
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_INV_DATA_12_MASK 0x2
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_INV_DATA_12__SHIFT 0x1
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_SWING_BOOST_EN_12_MASK 0x4
#define PB0_TX_LANE12_CTRL_REG0__TX_CFG_SWING_BOOST_EN_12__SHIFT 0x2
#define PB0_TX_LANE12_CTRL_REG0__TX_DBG_PRBS_EN_12_MASK 0x8
#define PB0_TX_LANE12_CTRL_REG0__TX_DBG_PRBS_EN_12__SHIFT 0x3
#define PB0_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_12_MASK 0x1
#define PB0_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_12__SHIFT 0x0
#define PB0_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_EN_12_MASK 0x2
#define PB0_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_EN_12__SHIFT 0x1
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_12_MASK 0x4
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_12__SHIFT 0x2
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_12_MASK 0x8
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_12__SHIFT 0x3
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_12_MASK 0x10
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_12__SHIFT 0x4
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_12_MASK 0x20
#define PB0_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_12__SHIFT 0x5
#define PB0_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_12_MASK 0x40
#define PB0_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_12__SHIFT 0x6
#define PB0_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_12_MASK 0x80
#define PB0_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_12__SHIFT 0x7
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__TXPWR_12_MASK 0x7
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__TXPWR_12__SHIFT 0x0
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__TXMARG_12_MASK 0x70
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__TXMARG_12__SHIFT 0x4
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__DEEMPH_12_MASK 0x80
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__DEEMPH_12__SHIFT 0x7
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENTID_12_MASK 0x300
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENTID_12__SHIFT 0x8
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENT_12_MASK 0xfc00
#define PB0_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENT_12__SHIFT 0xa
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_DISPCLK_MODE_13_MASK 0x1
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_DISPCLK_MODE_13__SHIFT 0x0
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_INV_DATA_13_MASK 0x2
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_INV_DATA_13__SHIFT 0x1
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_SWING_BOOST_EN_13_MASK 0x4
#define PB0_TX_LANE13_CTRL_REG0__TX_CFG_SWING_BOOST_EN_13__SHIFT 0x2
#define PB0_TX_LANE13_CTRL_REG0__TX_DBG_PRBS_EN_13_MASK 0x8
#define PB0_TX_LANE13_CTRL_REG0__TX_DBG_PRBS_EN_13__SHIFT 0x3
#define PB0_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_13_MASK 0x1
#define PB0_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_13__SHIFT 0x0
#define PB0_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_EN_13_MASK 0x2
#define PB0_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_EN_13__SHIFT 0x1
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_13_MASK 0x4
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_13__SHIFT 0x2
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_13_MASK 0x8
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_13__SHIFT 0x3
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_13_MASK 0x10
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_13__SHIFT 0x4
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_13_MASK 0x20
#define PB0_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_13__SHIFT 0x5
#define PB0_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_13_MASK 0x40
#define PB0_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_13__SHIFT 0x6
#define PB0_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_13_MASK 0x80
#define PB0_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_13__SHIFT 0x7
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__TXPWR_13_MASK 0x7
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__TXPWR_13__SHIFT 0x0
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__TXMARG_13_MASK 0x70
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__TXMARG_13__SHIFT 0x4
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__DEEMPH_13_MASK 0x80
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__DEEMPH_13__SHIFT 0x7
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENTID_13_MASK 0x300
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENTID_13__SHIFT 0x8
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENT_13_MASK 0xfc00
#define PB0_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENT_13__SHIFT 0xa
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_DISPCLK_MODE_14_MASK 0x1
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_DISPCLK_MODE_14__SHIFT 0x0
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_INV_DATA_14_MASK 0x2
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_INV_DATA_14__SHIFT 0x1
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_SWING_BOOST_EN_14_MASK 0x4
#define PB0_TX_LANE14_CTRL_REG0__TX_CFG_SWING_BOOST_EN_14__SHIFT 0x2
#define PB0_TX_LANE14_CTRL_REG0__TX_DBG_PRBS_EN_14_MASK 0x8
#define PB0_TX_LANE14_CTRL_REG0__TX_DBG_PRBS_EN_14__SHIFT 0x3
#define PB0_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_14_MASK 0x1
#define PB0_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_14__SHIFT 0x0
#define PB0_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_EN_14_MASK 0x2
#define PB0_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_EN_14__SHIFT 0x1
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_14_MASK 0x4
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_14__SHIFT 0x2
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_14_MASK 0x8
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_14__SHIFT 0x3
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_14_MASK 0x10
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_14__SHIFT 0x4
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_14_MASK 0x20
#define PB0_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_14__SHIFT 0x5
#define PB0_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_14_MASK 0x40
#define PB0_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_14__SHIFT 0x6
#define PB0_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_14_MASK 0x80
#define PB0_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_14__SHIFT 0x7
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__TXPWR_14_MASK 0x7
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__TXPWR_14__SHIFT 0x0
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__TXMARG_14_MASK 0x70
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__TXMARG_14__SHIFT 0x4
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__DEEMPH_14_MASK 0x80
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__DEEMPH_14__SHIFT 0x7
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENTID_14_MASK 0x300
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENTID_14__SHIFT 0x8
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENT_14_MASK 0xfc00
#define PB0_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENT_14__SHIFT 0xa
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_DISPCLK_MODE_15_MASK 0x1
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_DISPCLK_MODE_15__SHIFT 0x0
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_INV_DATA_15_MASK 0x2
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_INV_DATA_15__SHIFT 0x1
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_SWING_BOOST_EN_15_MASK 0x4
#define PB0_TX_LANE15_CTRL_REG0__TX_CFG_SWING_BOOST_EN_15__SHIFT 0x2
#define PB0_TX_LANE15_CTRL_REG0__TX_DBG_PRBS_EN_15_MASK 0x8
#define PB0_TX_LANE15_CTRL_REG0__TX_DBG_PRBS_EN_15__SHIFT 0x3
#define PB0_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_15_MASK 0x1
#define PB0_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_15__SHIFT 0x0
#define PB0_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_EN_15_MASK 0x2
#define PB0_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_EN_15__SHIFT 0x1
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_15_MASK 0x4
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_15__SHIFT 0x2
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_15_MASK 0x8
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_15__SHIFT 0x3
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_15_MASK 0x10
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_15__SHIFT 0x4
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_15_MASK 0x20
#define PB0_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_15__SHIFT 0x5
#define PB0_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_15_MASK 0x40
#define PB0_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_15__SHIFT 0x6
#define PB0_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_15_MASK 0x80
#define PB0_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_15__SHIFT 0x7
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__TXPWR_15_MASK 0x7
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__TXPWR_15__SHIFT 0x0
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__TXMARG_15_MASK 0x70
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__TXMARG_15__SHIFT 0x4
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__DEEMPH_15_MASK 0x80
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__DEEMPH_15__SHIFT 0x7
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENTID_15_MASK 0x300
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENTID_15__SHIFT 0x8
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENT_15_MASK 0xfc00
#define PB0_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENT_15__SHIFT 0xa
#define PB1_GLB_CTRL_REG0__BACKUP_MASK 0xffff
#define PB1_GLB_CTRL_REG0__BACKUP__SHIFT 0x0
#define PB1_GLB_CTRL_REG0__CFG_IDLEDET_TH_MASK 0x30000
#define PB1_GLB_CTRL_REG0__CFG_IDLEDET_TH__SHIFT 0x10
#define PB1_GLB_CTRL_REG0__DBG_RX2TXBYP_SEL_MASK 0x700000
#define PB1_GLB_CTRL_REG0__DBG_RX2TXBYP_SEL__SHIFT 0x14
#define PB1_GLB_CTRL_REG0__DBG_RXFEBYP_EN_MASK 0x800000
#define PB1_GLB_CTRL_REG0__DBG_RXFEBYP_EN__SHIFT 0x17
#define PB1_GLB_CTRL_REG0__DBG_RXPRBS_CLR_MASK 0x1000000
#define PB1_GLB_CTRL_REG0__DBG_RXPRBS_CLR__SHIFT 0x18
#define PB1_GLB_CTRL_REG0__DBG_RXTOGGLE_EN_MASK 0x2000000
#define PB1_GLB_CTRL_REG0__DBG_RXTOGGLE_EN__SHIFT 0x19
#define PB1_GLB_CTRL_REG0__DBG_TX2RXLBACK_EN_MASK 0x4000000
#define PB1_GLB_CTRL_REG0__DBG_TX2RXLBACK_EN__SHIFT 0x1a
#define PB1_GLB_CTRL_REG0__TXCFG_CMGOOD_RANGE_MASK 0xc0000000
#define PB1_GLB_CTRL_REG0__TXCFG_CMGOOD_RANGE__SHIFT 0x1e
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_EN_MASK 0x1
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_EN__SHIFT 0x0
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_VAL_MASK 0x7e
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_FR_BYP_VAL__SHIFT 0x1
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_EN_MASK 0x80
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_EN__SHIFT 0x7
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_VAL_MASK 0x3f00
#define PB1_GLB_CTRL_REG1__RXDBG_CDR_PH_BYP_VAL__SHIFT 0x8
#define PB1_GLB_CTRL_REG1__RXDBG_D0TH_BYP_EN_MASK 0x4000
#define PB1_GLB_CTRL_REG1__RXDBG_D0TH_BYP_EN__SHIFT 0xe
#define PB1_GLB_CTRL_REG1__RXDBG_D0TH_BYP_VAL_MASK 0x3f8000
#define PB1_GLB_CTRL_REG1__RXDBG_D0TH_BYP_VAL__SHIFT 0xf
#define PB1_GLB_CTRL_REG1__RXDBG_D1TH_BYP_EN_MASK 0x400000
#define PB1_GLB_CTRL_REG1__RXDBG_D1TH_BYP_EN__SHIFT 0x16
#define PB1_GLB_CTRL_REG1__RXDBG_D1TH_BYP_VAL_MASK 0x3f800000
#define PB1_GLB_CTRL_REG1__RXDBG_D1TH_BYP_VAL__SHIFT 0x17
#define PB1_GLB_CTRL_REG1__TST_LOSPDTST_EN_MASK 0x40000000
#define PB1_GLB_CTRL_REG1__TST_LOSPDTST_EN__SHIFT 0x1e
#define PB1_GLB_CTRL_REG1__PLL_CFG_DISPCLK_DIV_MASK 0x80000000
#define PB1_GLB_CTRL_REG1__PLL_CFG_DISPCLK_DIV__SHIFT 0x1f
#define PB1_GLB_CTRL_REG2__RXDBG_D2TH_BYP_EN_MASK 0x1
#define PB1_GLB_CTRL_REG2__RXDBG_D2TH_BYP_EN__SHIFT 0x0
#define PB1_GLB_CTRL_REG2__RXDBG_D2TH_BYP_VAL_MASK 0xfe
#define PB1_GLB_CTRL_REG2__RXDBG_D2TH_BYP_VAL__SHIFT 0x1
#define PB1_GLB_CTRL_REG2__RXDBG_D3TH_BYP_EN_MASK 0x100
#define PB1_GLB_CTRL_REG2__RXDBG_D3TH_BYP_EN__SHIFT 0x8
#define PB1_GLB_CTRL_REG2__RXDBG_D3TH_BYP_VAL_MASK 0xfe00
#define PB1_GLB_CTRL_REG2__RXDBG_D3TH_BYP_VAL__SHIFT 0x9
#define PB1_GLB_CTRL_REG2__RXDBG_DXTH_BYP_EN_MASK 0x10000
#define PB1_GLB_CTRL_REG2__RXDBG_DXTH_BYP_EN__SHIFT 0x10
#define PB1_GLB_CTRL_REG2__RXDBG_DXTH_BYP_VAL_MASK 0xfe0000
#define PB1_GLB_CTRL_REG2__RXDBG_DXTH_BYP_VAL__SHIFT 0x11
#define PB1_GLB_CTRL_REG2__RXDBG_ETH_BYP_EN_MASK 0x1000000
#define PB1_GLB_CTRL_REG2__RXDBG_ETH_BYP_EN__SHIFT 0x18
#define PB1_GLB_CTRL_REG2__RXDBG_ETH_BYP_VAL_MASK 0xfe000000
#define PB1_GLB_CTRL_REG2__RXDBG_ETH_BYP_VAL__SHIFT 0x19
#define PB1_GLB_CTRL_REG3__RXDBG_SEL_MASK 0x1f
#define PB1_GLB_CTRL_REG3__RXDBG_SEL__SHIFT 0x0
#define PB1_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF0_SEL_MASK 0x60
#define PB1_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF0_SEL__SHIFT 0x5
#define PB1_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF1_SEL_MASK 0x180
#define PB1_GLB_CTRL_REG3__BG_CFG_LC_REG_VREF1_SEL__SHIFT 0x7
#define PB1_GLB_CTRL_REG3__BG_CFG_RO_REG_VREF_SEL_MASK 0x600
#define PB1_GLB_CTRL_REG3__BG_CFG_RO_REG_VREF_SEL__SHIFT 0x9
#define PB1_GLB_CTRL_REG3__BG_DBG_VREFBYP_EN_MASK 0x800
#define PB1_GLB_CTRL_REG3__BG_DBG_VREFBYP_EN__SHIFT 0xb
#define PB1_GLB_CTRL_REG3__BG_DBG_IREFBYP_EN_MASK 0x1000
#define PB1_GLB_CTRL_REG3__BG_DBG_IREFBYP_EN__SHIFT 0xc
#define PB1_GLB_CTRL_REG3__BG_DBG_ANALOG_SEL_MASK 0x1c000
#define PB1_GLB_CTRL_REG3__BG_DBG_ANALOG_SEL__SHIFT 0xe
#define PB1_GLB_CTRL_REG3__DBG_DLL_CLK_SEL_MASK 0x1c0000
#define PB1_GLB_CTRL_REG3__DBG_DLL_CLK_SEL__SHIFT 0x12
#define PB1_GLB_CTRL_REG3__PLL_DISPCLK_CMOS_SEL_MASK 0x200000
#define PB1_GLB_CTRL_REG3__PLL_DISPCLK_CMOS_SEL__SHIFT 0x15
#define PB1_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_EN_MASK 0x400000
#define PB1_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_EN__SHIFT 0x16
#define PB1_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_VAL_MASK 0x7800000
#define PB1_GLB_CTRL_REG3__DBG_RXPI_OFFSET_BYP_VAL__SHIFT 0x17
#define PB1_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_EN_MASK 0x8000000
#define PB1_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_EN__SHIFT 0x1b
#define PB1_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_VAL_MASK 0x70000000
#define PB1_GLB_CTRL_REG3__DBG_RXSWAPDX_BYP_VAL__SHIFT 0x1c
#define PB1_GLB_CTRL_REG3__DBG_RXLEQ_DCATTN_BYP_OVR_DISABLE_MASK 0x80000000
#define PB1_GLB_CTRL_REG3__DBG_RXLEQ_DCATTN_BYP_OVR_DISABLE__SHIFT 0x1f
#define PB1_GLB_CTRL_REG4__DBG_RXAPU_INST_MASK 0xffff
#define PB1_GLB_CTRL_REG4__DBG_RXAPU_INST__SHIFT 0x0
#define PB1_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_VAL_MASK 0x30000
#define PB1_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_VAL__SHIFT 0x10
#define PB1_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_EN_MASK 0x40000
#define PB1_GLB_CTRL_REG4__DBG_RXDFEMUX_BYP_EN__SHIFT 0x12
#define PB1_GLB_CTRL_REG4__DBG_RXAPU_EXEC_MASK 0x3c00000
#define PB1_GLB_CTRL_REG4__DBG_RXAPU_EXEC__SHIFT 0x16
#define PB1_GLB_CTRL_REG4__DBG_RXDLL_VREG_REF_SEL_MASK 0x4000000
#define PB1_GLB_CTRL_REG4__DBG_RXDLL_VREG_REF_SEL__SHIFT 0x1a
#define PB1_GLB_CTRL_REG4__PWRGOOD_OVRD_MASK 0x8000000
#define PB1_GLB_CTRL_REG4__PWRGOOD_OVRD__SHIFT 0x1b
#define PB1_GLB_CTRL_REG4__DBG_RXRDATA_GATING_DISABLE_MASK 0x10000000
#define PB1_GLB_CTRL_REG4__DBG_RXRDATA_GATING_DISABLE__SHIFT 0x1c
#define PB1_GLB_CTRL_REG5__DBG_RXAPU_MODE_MASK 0xff
#define PB1_GLB_CTRL_REG5__DBG_RXAPU_MODE__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L0T3_MASK 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L0T3__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L4T7_MASK 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L4T7__SHIFT 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L8T11_MASK 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L8T11__SHIFT 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L12T15_MASK 0x8
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_ALL_CBI_UPDT_L12T15__SHIFT 0x3
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_IMPCAL_ACTIVE_CBI_UPDT_MASK 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG0__IGNR_IMPCAL_ACTIVE_CBI_UPDT__SHIFT 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG0__TXNIMP_MASK 0xf00
#define PB1_GLB_SCI_STAT_OVRD_REG0__TXNIMP__SHIFT 0x8
#define PB1_GLB_SCI_STAT_OVRD_REG0__TXPIMP_MASK 0xf000
#define PB1_GLB_SCI_STAT_OVRD_REG0__TXPIMP__SHIFT 0xc
#define PB1_GLB_SCI_STAT_OVRD_REG0__RXIMP_MASK 0xf0000
#define PB1_GLB_SCI_STAT_OVRD_REG0__RXIMP__SHIFT 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG0__IMPCAL_ACTIVE_MASK 0x100000
#define PB1_GLB_SCI_STAT_OVRD_REG0__IMPCAL_ACTIVE__SHIFT 0x14
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_LINKSPEED_CBI_UPDT_L0T3_MASK 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_LINKSPEED_CBI_UPDT_L0T3__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_FREQDIV_CBI_UPDT_L0T3_MASK 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_FREQDIV_CBI_UPDT_L0T3__SHIFT 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_DLL_LOCK_CBI_UPDT_L0T3_MASK 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG1__IGNR_DLL_LOCK_CBI_UPDT_L0T3__SHIFT 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_0_MASK 0x1000
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_0__SHIFT 0xc
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_1_MASK 0x2000
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_1__SHIFT 0xd
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_2_MASK 0x4000
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_2__SHIFT 0xe
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_3_MASK 0x8000
#define PB1_GLB_SCI_STAT_OVRD_REG1__DLL_LOCK_3__SHIFT 0xf
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_0_MASK 0x30000
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_0__SHIFT 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_0_MASK 0xc0000
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_0__SHIFT 0x12
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_1_MASK 0x300000
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_1__SHIFT 0x14
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_1_MASK 0xc00000
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_1__SHIFT 0x16
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_2_MASK 0x3000000
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_2__SHIFT 0x18
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_2_MASK 0xc000000
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_2__SHIFT 0x1a
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_3_MASK 0x30000000
#define PB1_GLB_SCI_STAT_OVRD_REG1__LINKSPEED_3__SHIFT 0x1c
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_3_MASK 0xc0000000
#define PB1_GLB_SCI_STAT_OVRD_REG1__FREQDIV_3__SHIFT 0x1e
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_LINKSPEED_CBI_UPDT_L4T7_MASK 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_LINKSPEED_CBI_UPDT_L4T7__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_FREQDIV_CBI_UPDT_L4T7_MASK 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_FREQDIV_CBI_UPDT_L4T7__SHIFT 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_DLL_LOCK_CBI_UPDT_L4T7_MASK 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG2__IGNR_DLL_LOCK_CBI_UPDT_L4T7__SHIFT 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_4_MASK 0x1000
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_4__SHIFT 0xc
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_5_MASK 0x2000
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_5__SHIFT 0xd
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_6_MASK 0x4000
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_6__SHIFT 0xe
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_7_MASK 0x8000
#define PB1_GLB_SCI_STAT_OVRD_REG2__DLL_LOCK_7__SHIFT 0xf
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_4_MASK 0x30000
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_4__SHIFT 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_4_MASK 0xc0000
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_4__SHIFT 0x12
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_5_MASK 0x300000
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_5__SHIFT 0x14
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_5_MASK 0xc00000
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_5__SHIFT 0x16
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_6_MASK 0x3000000
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_6__SHIFT 0x18
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_6_MASK 0xc000000
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_6__SHIFT 0x1a
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_7_MASK 0x30000000
#define PB1_GLB_SCI_STAT_OVRD_REG2__LINKSPEED_7__SHIFT 0x1c
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_7_MASK 0xc0000000
#define PB1_GLB_SCI_STAT_OVRD_REG2__FREQDIV_7__SHIFT 0x1e
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_LINKSPEED_CBI_UPDT_L8T11_MASK 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_LINKSPEED_CBI_UPDT_L8T11__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_FREQDIV_CBI_UPDT_L8T11_MASK 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_FREQDIV_CBI_UPDT_L8T11__SHIFT 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_DLL_LOCK_CBI_UPDT_L8T11_MASK 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG3__IGNR_DLL_LOCK_CBI_UPDT_L8T11__SHIFT 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_8_MASK 0x1000
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_8__SHIFT 0xc
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_9_MASK 0x2000
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_9__SHIFT 0xd
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_10_MASK 0x4000
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_10__SHIFT 0xe
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_11_MASK 0x8000
#define PB1_GLB_SCI_STAT_OVRD_REG3__DLL_LOCK_11__SHIFT 0xf
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_8_MASK 0x30000
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_8__SHIFT 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_8_MASK 0xc0000
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_8__SHIFT 0x12
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_9_MASK 0x300000
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_9__SHIFT 0x14
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_9_MASK 0xc00000
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_9__SHIFT 0x16
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_10_MASK 0x3000000
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_10__SHIFT 0x18
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_10_MASK 0xc000000
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_10__SHIFT 0x1a
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_11_MASK 0x30000000
#define PB1_GLB_SCI_STAT_OVRD_REG3__LINKSPEED_11__SHIFT 0x1c
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_11_MASK 0xc0000000
#define PB1_GLB_SCI_STAT_OVRD_REG3__FREQDIV_11__SHIFT 0x1e
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_LINKSPEED_CBI_UPDT_L12T15_MASK 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_LINKSPEED_CBI_UPDT_L12T15__SHIFT 0x0
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_FREQDIV_CBI_UPDT_L12T15_MASK 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_FREQDIV_CBI_UPDT_L12T15__SHIFT 0x1
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_DLL_LOCK_CBI_UPDT_L12T15_MASK 0x4
#define PB1_GLB_SCI_STAT_OVRD_REG4__IGNR_DLL_LOCK_CBI_UPDT_L12T15__SHIFT 0x2
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_12_MASK 0x1000
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_12__SHIFT 0xc
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_13_MASK 0x2000
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_13__SHIFT 0xd
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_14_MASK 0x4000
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_14__SHIFT 0xe
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_15_MASK 0x8000
#define PB1_GLB_SCI_STAT_OVRD_REG4__DLL_LOCK_15__SHIFT 0xf
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_12_MASK 0x30000
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_12__SHIFT 0x10
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_12_MASK 0xc0000
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_12__SHIFT 0x12
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_13_MASK 0x300000
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_13__SHIFT 0x14
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_13_MASK 0xc00000
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_13__SHIFT 0x16
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_14_MASK 0x3000000
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_14__SHIFT 0x18
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_14_MASK 0xc000000
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_14__SHIFT 0x1a
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_15_MASK 0x30000000
#define PB1_GLB_SCI_STAT_OVRD_REG4__LINKSPEED_15__SHIFT 0x1c
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_15_MASK 0xc0000000
#define PB1_GLB_SCI_STAT_OVRD_REG4__FREQDIV_15__SHIFT 0x1e
#define PB1_GLB_OVRD_REG0__TXPDTERM_VAL_OVRD_VAL_MASK 0xffff
#define PB1_GLB_OVRD_REG0__TXPDTERM_VAL_OVRD_VAL__SHIFT 0x0
#define PB1_GLB_OVRD_REG0__TXPUTERM_VAL_OVRD_VAL_MASK 0xffff0000
#define PB1_GLB_OVRD_REG0__TXPUTERM_VAL_OVRD_VAL__SHIFT 0x10
#define PB1_GLB_OVRD_REG1__TXPDTERM_VAL_OVRD_EN_MASK 0x1
#define PB1_GLB_OVRD_REG1__TXPDTERM_VAL_OVRD_EN__SHIFT 0x0
#define PB1_GLB_OVRD_REG1__TXPUTERM_VAL_OVRD_EN_MASK 0x2
#define PB1_GLB_OVRD_REG1__TXPUTERM_VAL_OVRD_EN__SHIFT 0x1
#define PB1_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_EN_MASK 0x4
#define PB1_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_EN__SHIFT 0x2
#define PB1_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_VAL_MASK 0x8
#define PB1_GLB_OVRD_REG1__TST_LOSPDTST_RST_OVRD_VAL__SHIFT 0x3
#define PB1_GLB_OVRD_REG1__RXTERM_VAL_OVRD_EN_MASK 0x8000
#define PB1_GLB_OVRD_REG1__RXTERM_VAL_OVRD_EN__SHIFT 0xf
#define PB1_GLB_OVRD_REG1__RXTERM_VAL_OVRD_VAL_MASK 0xffff0000
#define PB1_GLB_OVRD_REG1__RXTERM_VAL_OVRD_VAL__SHIFT 0x10
#define PB1_GLB_OVRD_REG2__BG_PWRON_OVRD_EN_MASK 0x1
#define PB1_GLB_OVRD_REG2__BG_PWRON_OVRD_EN__SHIFT 0x0
#define PB1_GLB_OVRD_REG2__BG_PWRON_OVRD_VAL_MASK 0x2
#define PB1_GLB_OVRD_REG2__BG_PWRON_OVRD_VAL__SHIFT 0x1
#define PB1_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_EN_MASK 0x4
#define PB1_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_EN__SHIFT 0x2
#define PB1_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_VAL_MASK 0x8
#define PB1_GLB_OVRD_REG2__PLL_DBG_LC_EXT_RESET_OVRD_VAL__SHIFT 0x3
#define PB1_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_EN_MASK 0x10
#define PB1_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_EN__SHIFT 0x4
#define PB1_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_VAL_MASK 0x20
#define PB1_GLB_OVRD_REG2__PLL_DBG_RO_EXT_RESET_OVRD_VAL__SHIFT 0x5
#define PB1_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PB1_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PB1_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PB1_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PB1_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PB1_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PB1_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PB1_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PB1_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PB1_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PB1_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PB1_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PB1_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PB1_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PB1_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PB1_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PB1_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PB1_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PB1_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PB1_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PB1_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PB1_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PB1_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PB1_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PB1_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PB1_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PB1_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PB1_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PB1_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PB1_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PB1_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PB1_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PB1_HW_DEBUG__HW_16_DEBUG_MASK 0x10000
#define PB1_HW_DEBUG__HW_16_DEBUG__SHIFT 0x10
#define PB1_HW_DEBUG__HW_17_DEBUG_MASK 0x20000
#define PB1_HW_DEBUG__HW_17_DEBUG__SHIFT 0x11
#define PB1_HW_DEBUG__HW_18_DEBUG_MASK 0x40000
#define PB1_HW_DEBUG__HW_18_DEBUG__SHIFT 0x12
#define PB1_HW_DEBUG__HW_19_DEBUG_MASK 0x80000
#define PB1_HW_DEBUG__HW_19_DEBUG__SHIFT 0x13
#define PB1_HW_DEBUG__HW_20_DEBUG_MASK 0x100000
#define PB1_HW_DEBUG__HW_20_DEBUG__SHIFT 0x14
#define PB1_HW_DEBUG__HW_21_DEBUG_MASK 0x200000
#define PB1_HW_DEBUG__HW_21_DEBUG__SHIFT 0x15
#define PB1_HW_DEBUG__HW_22_DEBUG_MASK 0x400000
#define PB1_HW_DEBUG__HW_22_DEBUG__SHIFT 0x16
#define PB1_HW_DEBUG__HW_23_DEBUG_MASK 0x800000
#define PB1_HW_DEBUG__HW_23_DEBUG__SHIFT 0x17
#define PB1_HW_DEBUG__HW_24_DEBUG_MASK 0x1000000
#define PB1_HW_DEBUG__HW_24_DEBUG__SHIFT 0x18
#define PB1_HW_DEBUG__HW_25_DEBUG_MASK 0x2000000
#define PB1_HW_DEBUG__HW_25_DEBUG__SHIFT 0x19
#define PB1_HW_DEBUG__HW_26_DEBUG_MASK 0x4000000
#define PB1_HW_DEBUG__HW_26_DEBUG__SHIFT 0x1a
#define PB1_HW_DEBUG__HW_27_DEBUG_MASK 0x8000000
#define PB1_HW_DEBUG__HW_27_DEBUG__SHIFT 0x1b
#define PB1_HW_DEBUG__HW_28_DEBUG_MASK 0x10000000
#define PB1_HW_DEBUG__HW_28_DEBUG__SHIFT 0x1c
#define PB1_HW_DEBUG__HW_29_DEBUG_MASK 0x20000000
#define PB1_HW_DEBUG__HW_29_DEBUG__SHIFT 0x1d
#define PB1_HW_DEBUG__HW_30_DEBUG_MASK 0x40000000
#define PB1_HW_DEBUG__HW_30_DEBUG__SHIFT 0x1e
#define PB1_HW_DEBUG__HW_31_DEBUG_MASK 0x80000000
#define PB1_HW_DEBUG__HW_31_DEBUG__SHIFT 0x1f
#define PB1_STRAP_GLB_REG0__STRAP_QUICK_SIM_START_MASK 0x2
#define PB1_STRAP_GLB_REG0__STRAP_QUICK_SIM_START__SHIFT 0x1
#define PB1_STRAP_GLB_REG0__STRAP_DFT_RXBSCAN_EN_VAL_MASK 0x4
#define PB1_STRAP_GLB_REG0__STRAP_DFT_RXBSCAN_EN_VAL__SHIFT 0x2
#define PB1_STRAP_GLB_REG0__STRAP_DFT_CALIB_BYPASS_MASK 0x8
#define PB1_STRAP_GLB_REG0__STRAP_DFT_CALIB_BYPASS__SHIFT 0x3
#define PB1_STRAP_GLB_REG0__STRAP_FORCE_LC_PLL_ON_MASK 0x10
#define PB1_STRAP_GLB_REG0__STRAP_FORCE_LC_PLL_ON__SHIFT 0x4
#define PB1_STRAP_GLB_REG0__STRAP_CFG_IDLEDET_TH_MASK 0x60
#define PB1_STRAP_GLB_REG0__STRAP_CFG_IDLEDET_TH__SHIFT 0x5
#define PB1_STRAP_GLB_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_VAL_MASK 0xf80
#define PB1_STRAP_GLB_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_VAL__SHIFT 0x7
#define PB1_STRAP_GLB_REG0__STRAP_RX_CFG_OVR_PWRSF_MASK 0x1000
#define PB1_STRAP_GLB_REG0__STRAP_RX_CFG_OVR_PWRSF__SHIFT 0xc
#define PB1_STRAP_GLB_REG0__STRAP_RX_TRK_MODE_0__MASK 0x2000
#define PB1_STRAP_GLB_REG0__STRAP_RX_TRK_MODE_0___SHIFT 0xd
#define PB1_STRAP_GLB_REG0__STRAP_PWRGOOD_OVRD_MASK 0x4000
#define PB1_STRAP_GLB_REG0__STRAP_PWRGOOD_OVRD__SHIFT 0xe
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXDLL_VREG_REF_SEL_MASK 0x8000
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXDLL_VREG_REF_SEL__SHIFT 0xf
#define PB1_STRAP_GLB_REG0__STRAP_PLL_CFG_LC_VCO_TUNE_MASK 0xf0000
#define PB1_STRAP_GLB_REG0__STRAP_PLL_CFG_LC_VCO_TUNE__SHIFT 0x10
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXRDATA_GATING_DISABLE_MASK 0x100000
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXRDATA_GATING_DISABLE__SHIFT 0x14
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXPI_OFFSET_BYP_VAL_MASK 0x1e00000
#define PB1_STRAP_GLB_REG0__STRAP_DBG_RXPI_OFFSET_BYP_VAL__SHIFT 0x15
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_EN_MASK 0x1e
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_EN__SHIFT 0x1
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_TAP_SEL_MASK 0x1e0
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV0_TAP_SEL__SHIFT 0x5
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_EN_MASK 0x3e00
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_EN__SHIFT 0x9
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_TAP_SEL_MASK 0x7c000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV1_TAP_SEL__SHIFT 0xe
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_EN_MASK 0x780000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_EN__SHIFT 0x13
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_TAP_SEL_MASK 0x7800000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRV2_TAP_SEL__SHIFT 0x17
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_EN_MASK 0x8000000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_EN__SHIFT 0x1b
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_TAP_SEL_MASK 0x10000000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_DRVX_TAP_SEL__SHIFT 0x1c
#define PB1_STRAP_TX_REG0__STRAP_RX_TRK_MODE_1__MASK 0x20000000
#define PB1_STRAP_TX_REG0__STRAP_RX_TRK_MODE_1___SHIFT 0x1d
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_SWING_BOOST_EN_MASK 0x40000000
#define PB1_STRAP_TX_REG0__STRAP_TX_CFG_SWING_BOOST_EN__SHIFT 0x1e
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_TH_LOOP_GAIN_MASK 0x1e
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_TH_LOOP_GAIN__SHIFT 0x1
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_DLL_FLOCK_DISABLE_MASK 0x20
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_DLL_FLOCK_DISABLE__SHIFT 0x5
#define PB1_STRAP_RX_REG0__STRAP_DBG_RXPI_OFFSET_BYP_EN_MASK 0x40
#define PB1_STRAP_RX_REG0__STRAP_DBG_RXPI_OFFSET_BYP_EN__SHIFT 0x6
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_DIS_MASK 0x80
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_DCATTN_BYP_DIS__SHIFT 0x7
#define PB1_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF0_SEL_MASK 0x300
#define PB1_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF0_SEL__SHIFT 0x8
#define PB1_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF1_SEL_MASK 0xc00
#define PB1_STRAP_RX_REG0__STRAP_BG_CFG_LC_REG_VREF1_SEL__SHIFT 0xa
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_CDR_TIME_MASK 0xf000
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_CDR_TIME__SHIFT 0xc
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_FOM_TIME_MASK 0xf0000
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_FOM_TIME__SHIFT 0x10
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_TIME_MASK 0xf00000
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_LEQ_TIME__SHIFT 0x14
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_OC_TIME_MASK 0xf000000
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_OC_TIME__SHIFT 0x18
#define PB1_STRAP_RX_REG0__STRAP_TX_CFG_RPTR_RST_VAL_MASK 0x70000000
#define PB1_STRAP_RX_REG0__STRAP_TX_CFG_RPTR_RST_VAL__SHIFT 0x1c
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_TERM_MODE_MASK 0x80000000
#define PB1_STRAP_RX_REG0__STRAP_RX_CFG_TERM_MODE__SHIFT 0x1f
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PI_STPSZ_MASK 0x2
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PI_STPSZ__SHIFT 0x1
#define PB1_STRAP_RX_REG1__STRAP_TX_DEEMPH_PRSHT_STNG_MASK 0x1c
#define PB1_STRAP_RX_REG1__STRAP_TX_DEEMPH_PRSHT_STNG__SHIFT 0x2
#define PB1_STRAP_RX_REG1__STRAP_BG_CFG_RO_REG_VREF_SEL_MASK 0x60
#define PB1_STRAP_RX_REG1__STRAP_BG_CFG_RO_REG_VREF_SEL__SHIFT 0x5
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_DIS_MASK 0x80
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_DIS__SHIFT 0x7
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_VAL_MASK 0x700
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_POLE_BYP_VAL__SHIFT 0x8
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PH_GAIN_MASK 0x7800
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_CDR_PH_GAIN__SHIFT 0xb
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_ADAPT_MODE_MASK 0x1ff8000
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_ADAPT_MODE__SHIFT 0xf
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_DFE_TIME_MASK 0x1e000000
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_DFE_TIME__SHIFT 0x19
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_LOOP_GAIN_MASK 0x60000000
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_LOOP_GAIN__SHIFT 0x1d
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_SHUNT_DIS_MASK 0x80000000
#define PB1_STRAP_RX_REG1__STRAP_RX_CFG_LEQ_SHUNT_DIS__SHIFT 0x1f
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_BW_CNTRL_MASK 0xe
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_BW_CNTRL__SHIFT 0x1
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_LF_CNTRL_MASK 0x1ff0
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_LC_LF_CNTRL__SHIFT 0x4
#define PB1_STRAP_PLL_REG0__STRAP_TX_RXDET_X1_SSF_MASK 0x2000
#define PB1_STRAP_PLL_REG0__STRAP_TX_RXDET_X1_SSF__SHIFT 0xd
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_VTOI_BIAS_CNTRL_DIS_MASK 0x8000
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_VTOI_BIAS_CNTRL_DIS__SHIFT 0xf
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_BW_CNTRL_MASK 0xff0000
#define PB1_STRAP_PLL_REG0__STRAP_PLL_CFG_RO_BW_CNTRL__SHIFT 0x10
#define PB1_STRAP_PLL_REG0__STRAP_PLL_STRAP_SEL_MASK 0x1000000
#define PB1_STRAP_PLL_REG0__STRAP_PLL_STRAP_SEL__SHIFT 0x18
#define PB1_STRAP_PIN_REG0__STRAP_TX_DEEMPH_EN_MASK 0x2
#define PB1_STRAP_PIN_REG0__STRAP_TX_DEEMPH_EN__SHIFT 0x1
#define PB1_STRAP_PIN_REG0__STRAP_TX_FULL_SWING_MASK 0x4
#define PB1_STRAP_PIN_REG0__STRAP_TX_FULL_SWING__SHIFT 0x2
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_MODE_MASK 0x6
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_MODE__SHIFT 0x1
#define PB1_STRAP_GLB_REG1__STRAP_RX_L0_ENTRY_MODE_MASK 0x18
#define PB1_STRAP_GLB_REG1__STRAP_RX_L0_ENTRY_MODE__SHIFT 0x3
#define PB1_STRAP_GLB_REG1__STRAP_RX_EI_FILTER_MASK 0x60
#define PB1_STRAP_GLB_REG1__STRAP_RX_EI_FILTER__SHIFT 0x5
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_SUB_ENTRY_MASK 0x80
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_RST_SUB_ENTRY__SHIFT 0x7
#define PB1_STRAP_GLB_REG1__STRAP_RX_PS0_RDY_GEN_MODE_MASK 0x300
#define PB1_STRAP_GLB_REG1__STRAP_RX_PS0_RDY_GEN_MODE__SHIFT 0x8
#define PB1_STRAP_GLB_REG1__STRAP_RX_DLL_RESET_IN_SPDCHG_MASK 0x400
#define PB1_STRAP_GLB_REG1__STRAP_RX_DLL_RESET_IN_SPDCHG__SHIFT 0xa
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_TIME_OUT_MASK 0x1800
#define PB1_STRAP_GLB_REG1__STRAP_RX_ADAPT_TIME_OUT__SHIFT 0xb
#define PB1_STRAP_GLB_REG2__STRAP_BPHYC_PLL_RAMP_UP_TIME_MASK 0x1c
#define PB1_STRAP_GLB_REG2__STRAP_BPHYC_PLL_RAMP_UP_TIME__SHIFT 0x2
#define PB1_STRAP_GLB_REG2__STRAP_IMPCAL_SETTLE_TIME_MASK 0x60
#define PB1_STRAP_GLB_REG2__STRAP_IMPCAL_SETTLE_TIME__SHIFT 0x5
#define PB1_STRAP_GLB_REG2__STRAP_BG_SETTLE_TIME_MASK 0x180
#define PB1_STRAP_GLB_REG2__STRAP_BG_SETTLE_TIME__SHIFT 0x7
#define PB1_STRAP_GLB_REG2__STRAP_TX_CMDET_TIME_MASK 0x600
#define PB1_STRAP_GLB_REG2__STRAP_TX_CMDET_TIME__SHIFT 0x9
#define PB1_STRAP_GLB_REG2__STRAP_TX_STARTUP_TIME_MASK 0x1800
#define PB1_STRAP_GLB_REG2__STRAP_TX_STARTUP_TIME__SHIFT 0xb
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DIS0_MASK 0x10000000
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DIS0__SHIFT 0x1c
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DIS1_MASK 0x20000000
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DIS1__SHIFT 0x1d
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DRV_STR_MASK 0xc0000000
#define PB1_STRAP_GLB_REG2__STRAP_B_PCB_DRV_STR__SHIFT 0x1e
#define PB1_DFT_JIT_INJ_REG0__DFT_NUM_STEPS_MASK 0x3f
#define PB1_DFT_JIT_INJ_REG0__DFT_NUM_STEPS__SHIFT 0x0
#define PB1_DFT_JIT_INJ_REG0__DFT_DISABLE_ERR_MASK 0x80
#define PB1_DFT_JIT_INJ_REG0__DFT_DISABLE_ERR__SHIFT 0x7
#define PB1_DFT_JIT_INJ_REG0__DFT_CLK_PER_STEP_MASK 0xf00
#define PB1_DFT_JIT_INJ_REG0__DFT_CLK_PER_STEP__SHIFT 0x8
#define PB1_DFT_JIT_INJ_REG0__DFT_MODE_CDR_EN_MASK 0x100000
#define PB1_DFT_JIT_INJ_REG0__DFT_MODE_CDR_EN__SHIFT 0x14
#define PB1_DFT_JIT_INJ_REG0__DFT_EN_RECOVERY_MASK 0x200000
#define PB1_DFT_JIT_INJ_REG0__DFT_EN_RECOVERY__SHIFT 0x15
#define PB1_DFT_JIT_INJ_REG0__DFT_INCR_SWP_EN_MASK 0x400000
#define PB1_DFT_JIT_INJ_REG0__DFT_INCR_SWP_EN__SHIFT 0x16
#define PB1_DFT_JIT_INJ_REG0__DFT_DECR_SWP_EN_MASK 0x800000
#define PB1_DFT_JIT_INJ_REG0__DFT_DECR_SWP_EN__SHIFT 0x17
#define PB1_DFT_JIT_INJ_REG0__DFT_RECOVERY_TIME_MASK 0xff000000
#define PB1_DFT_JIT_INJ_REG0__DFT_RECOVERY_TIME__SHIFT 0x18
#define PB1_DFT_JIT_INJ_REG1__DFT_BYPASS_VALUE_MASK 0xff
#define PB1_DFT_JIT_INJ_REG1__DFT_BYPASS_VALUE__SHIFT 0x0
#define PB1_DFT_JIT_INJ_REG1__DFT_BYPASS_EN_MASK 0x100
#define PB1_DFT_JIT_INJ_REG1__DFT_BYPASS_EN__SHIFT 0x8
#define PB1_DFT_JIT_INJ_REG1__DFT_BLOCK_EN_MASK 0x10000
#define PB1_DFT_JIT_INJ_REG1__DFT_BLOCK_EN__SHIFT 0x10
#define PB1_DFT_JIT_INJ_REG1__DFT_NUM_OF_TESTS_MASK 0xe0000
#define PB1_DFT_JIT_INJ_REG1__DFT_NUM_OF_TESTS__SHIFT 0x11
#define PB1_DFT_JIT_INJ_REG1__DFT_CHECK_TIME_MASK 0xf00000
#define PB1_DFT_JIT_INJ_REG1__DFT_CHECK_TIME__SHIFT 0x14
#define PB1_DFT_JIT_INJ_REG2__DFT_LANE_EN_MASK 0xffff
#define PB1_DFT_JIT_INJ_REG2__DFT_LANE_EN__SHIFT 0x0
#define PB1_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_EN_MASK 0x1
#define PB1_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_EN__SHIFT 0x0
#define PB1_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_MODE_MASK 0x3e
#define PB1_DFT_DEBUG_CTRL_REG0__DFT_PHY_DEBUG_MODE__SHIFT 0x1
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_DECR_MASK 0xff
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_DECR__SHIFT 0x0
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_INCR_MASK 0xff00
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_INCR__SHIFT 0x8
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_FINISHED_MASK 0x10000
#define PB1_DFT_JIT_INJ_STAT_REG0__DFT_STAT_FINISHED__SHIFT 0x10
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_TST_LOSPDTST_SRC_MASK 0x1
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_TST_LOSPDTST_SRC__SHIFT 0x0
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS0_MASK 0x2
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS0__SHIFT 0x1
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS1_MASK 0x4
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS1__SHIFT 0x2
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS2_MASK 0x8
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_LUT_ENTRY_LS2__SHIFT 0x3
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS0_MASK 0x10
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS0__SHIFT 0x4
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS1_MASK 0x20
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS1__SHIFT 0x5
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS2_MASK 0x40
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_LUT_ENTRY_LS2__SHIFT 0x6
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_PWRON_LUT_ENTRY_LS2_MASK 0x80
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_PWRON_LUT_ENTRY_LS2__SHIFT 0x7
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_PWRON_LUT_ENTRY_LS2_MASK 0x100
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_PWRON_LUT_ENTRY_LS2__SHIFT 0x8
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS0_MASK 0x200
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS0__SHIFT 0x9
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS1_MASK 0x400
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS1__SHIFT 0xa
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS2_MASK 0x800
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_LUT_ENTRY_LS2__SHIFT 0xb
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS0_MASK 0x1000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS0__SHIFT 0xc
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS1_MASK 0x2000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS1__SHIFT 0xd
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS2_MASK 0x4000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_LUT_ENTRY_LS2__SHIFT 0xe
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_GATING_EN_MASK 0x8000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_LEFT_EN_GATING_EN__SHIFT 0xf
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_GATING_EN_MASK 0x10000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_RO_HSCLK_RIGHT_EN_GATING_EN__SHIFT 0x10
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_GATING_EN_MASK 0x20000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_LEFT_EN_GATING_EN__SHIFT 0x11
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_GATING_EN_MASK 0x40000
#define PB1_PLL_RO_GLB_CTRL_REG0__PLL_LC_HSCLK_RIGHT_EN_GATING_EN__SHIFT 0x12
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_ANALOG_SEL_0_MASK 0x3
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_ANALOG_SEL_0__SHIFT 0x0
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_EXT_RESET_EN_0_MASK 0x4
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_EXT_RESET_EN_0__SHIFT 0x2
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_VCTL_ADC_EN_0_MASK 0x8
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_VCTL_ADC_EN_0__SHIFT 0x3
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_LF_CNTRL_0_MASK 0x7f0
#define PB1_PLL_RO0_CTRL_REG0__PLL_DBG_RO_LF_CNTRL_0__SHIFT 0x4
#define PB1_PLL_RO0_CTRL_REG0__PLL_TST_RO_USAMPLE_EN_0_MASK 0x800
#define PB1_PLL_RO0_CTRL_REG0__PLL_TST_RO_USAMPLE_EN_0__SHIFT 0xb
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_VAL_0_MASK 0xff
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_VAL_0__SHIFT 0x0
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_EN_0_MASK 0x100
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_BW_CNTRL_OVRD_EN_0__SHIFT 0x8
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_VAL_0_MASK 0xe00
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_VAL_0__SHIFT 0x9
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_EN_0_MASK 0x1000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_DIV_OVRD_EN_0__SHIFT 0xc
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_VAL_0_MASK 0x2000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_VAL_0__SHIFT 0xd
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_EN_0_MASK 0x4000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_CORECLK_EN_OVRD_EN_0__SHIFT 0xe
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_VAL_0_MASK 0xfff8000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_VAL_0__SHIFT 0xf
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_EN_0_MASK 0x10000000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_FBDIV_OVRD_EN_0__SHIFT 0x1c
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_VAL_0_MASK 0x40000000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_VAL_0__SHIFT 0x1e
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_EN_0_MASK 0x80000000
#define PB1_PLL_RO0_OVRD_REG0__PLL_CFG_RO_VTOI_BIAS_CNTRL_OVRD_EN_0__SHIFT 0x1f
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_VAL_0_MASK 0x1f
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_VAL_0__SHIFT 0x0
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_EN_0_MASK 0x20
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFDIV_OVRD_EN_0__SHIFT 0x5
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_VAL_0_MASK 0xc0
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_VAL_0__SHIFT 0x6
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_EN_0_MASK 0x100
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_VCO_MODE_OVRD_EN_0__SHIFT 0x8
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_VAL_0_MASK 0x200
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_VAL_0__SHIFT 0x9
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_EN_0_MASK 0x400
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_LEFT_EN_OVRD_EN_0__SHIFT 0xa
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_VAL_0_MASK 0x800
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_VAL_0__SHIFT 0xb
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_EN_0_MASK 0x1000
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_HSCLK_RIGHT_EN_OVRD_EN_0__SHIFT 0xc
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_VAL_0_MASK 0x2000
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_VAL_0__SHIFT 0xd
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_EN_0_MASK 0x4000
#define PB1_PLL_RO0_OVRD_REG1__PLL_RO_PWRON_OVRD_EN_0__SHIFT 0xe
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_VAL_0_MASK 0x380000
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_VAL_0__SHIFT 0x13
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_EN_0_MASK 0x400000
#define PB1_PLL_RO0_OVRD_REG1__PLL_CFG_RO_REFCLK_SRC_OVRD_EN_0__SHIFT 0x16
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLPWR_MASK 0x70
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLPWR__SHIFT 0x4
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLFREQ_MASK 0x300
#define PB1_PLL_RO0_SCI_STAT_OVRD_REG0__PLL_RO0_PLLFREQ__SHIFT 0x8
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLPWR_MASK 0x70
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLPWR__SHIFT 0x4
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLFREQ_MASK 0x300
#define PB1_PLL_RO1_SCI_STAT_OVRD_REG0__PLL_RO1_PLLFREQ__SHIFT 0x8
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLPWR_MASK 0x70
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLPWR__SHIFT 0x4
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLFREQ_MASK 0x300
#define PB1_PLL_RO2_SCI_STAT_OVRD_REG0__PLL_RO2_PLLFREQ__SHIFT 0x8
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLFREQ_CBI_UPDT_MASK 0x2
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_IGNR_PLLFREQ_CBI_UPDT__SHIFT 0x1
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLPWR_MASK 0x70
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLPWR__SHIFT 0x4
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLFREQ_MASK 0x300
#define PB1_PLL_RO3_SCI_STAT_OVRD_REG0__PLL_RO3_PLLFREQ__SHIFT 0x8
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_ANALOG_SEL_0_MASK 0x3
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_ANALOG_SEL_0__SHIFT 0x0
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_EXT_RESET_EN_0_MASK 0x4
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_EXT_RESET_EN_0__SHIFT 0x2
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_VCTL_ADC_EN_0_MASK 0x8
#define PB1_PLL_LC0_CTRL_REG0__PLL_DBG_LC_VCTL_ADC_EN_0__SHIFT 0x3
#define PB1_PLL_LC0_CTRL_REG0__PLL_TST_LC_USAMPLE_EN_0_MASK 0x10
#define PB1_PLL_LC0_CTRL_REG0__PLL_TST_LC_USAMPLE_EN_0__SHIFT 0x4
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_VAL_0_MASK 0x7
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_VAL_0__SHIFT 0x0
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_EN_0_MASK 0x8
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_BW_CNTRL_OVRD_EN_0__SHIFT 0x3
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_VAL_0_MASK 0x70
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_VAL_0__SHIFT 0x4
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_EN_0_MASK 0x80
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_DIV_OVRD_EN_0__SHIFT 0x7
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_VAL_0_MASK 0x100
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_VAL_0__SHIFT 0x8
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_EN_0_MASK 0x200
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_CORECLK_EN_OVRD_EN_0__SHIFT 0x9
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_VAL_0_MASK 0x3fc00
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_VAL_0__SHIFT 0xa
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_EN_0_MASK 0x40000
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_FBDIV_OVRD_EN_0__SHIFT 0x12
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_VAL_0_MASK 0xff80000
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_VAL_0__SHIFT 0x13
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_EN_0_MASK 0x10000000
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_LF_CNTRL_OVRD_EN_0__SHIFT 0x1c
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_VAL_0_MASK 0x60000000
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_VAL_0__SHIFT 0x1d
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_EN_0_MASK 0x80000000
#define PB1_PLL_LC0_OVRD_REG0__PLL_CFG_LC_REFDIV_OVRD_EN_0__SHIFT 0x1f
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_VAL_0_MASK 0x7
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_VAL_0__SHIFT 0x0
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_EN_0_MASK 0x8
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_REFCLK_SRC_OVRD_EN_0__SHIFT 0x3
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_VAL_0_MASK 0x10
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_VAL_0__SHIFT 0x4
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_EN_0_MASK 0x20
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_LEFT_EN_OVRD_EN_0__SHIFT 0x5
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_VAL_0_MASK 0x40
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_VAL_0__SHIFT 0x6
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_EN_0_MASK 0x80
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_HSCLK_RIGHT_EN_OVRD_EN_0__SHIFT 0x7
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_VAL_0_MASK 0x100
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_VAL_0__SHIFT 0x8
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_EN_0_MASK 0x200
#define PB1_PLL_LC0_OVRD_REG1__PLL_LC_PWRON_OVRD_EN_0__SHIFT 0x9
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_VAL_0_MASK 0x3c000
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_VAL_0__SHIFT 0xe
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_EN_0_MASK 0x40000
#define PB1_PLL_LC0_OVRD_REG1__PLL_CFG_LC_VCO_TUNE_OVRD_EN_0__SHIFT 0x12
#define PB1_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_PLLPWR_MASK 0x70
#define PB1_PLL_LC0_SCI_STAT_OVRD_REG0__PLL_LC0_PLLPWR__SHIFT 0x4
#define PB1_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_PLLPWR_MASK 0x70
#define PB1_PLL_LC1_SCI_STAT_OVRD_REG0__PLL_LC1_PLLPWR__SHIFT 0x4
#define PB1_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_PLLPWR_MASK 0x70
#define PB1_PLL_LC2_SCI_STAT_OVRD_REG0__PLL_LC2_PLLPWR__SHIFT 0x4
#define PB1_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_IGNR_PLLPWR_CBI_UPDT_MASK 0x1
#define PB1_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_IGNR_PLLPWR_CBI_UPDT__SHIFT 0x0
#define PB1_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_PLLPWR_MASK 0x70
#define PB1_PLL_LC3_SCI_STAT_OVRD_REG0__PLL_LC3_PLLPWR__SHIFT 0x4
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN1_MASK 0x3ff
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN2_MASK 0xffc00
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN2__SHIFT 0xa
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN3_MASK 0x3ff00000
#define PB1_RX_GLB_CTRL_REG0__RX_CFG_ADAPT_MODE_GEN3__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN1_MASK 0xf
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN2_MASK 0xf0
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN2__SHIFT 0x4
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN3_MASK 0xf00
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_FR_GAIN_GEN3__SHIFT 0x8
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN1_MASK 0xf000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN1__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN2_MASK 0xf0000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN2__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN3_MASK 0xf00000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PH_GAIN_GEN3__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN1_MASK 0x1000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN1__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN2_MASK 0x2000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN2__SHIFT 0x19
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN3_MASK 0x4000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_CDR_PI_STPSZ_GEN3__SHIFT 0x1a
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN1_MASK 0x8000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN1__SHIFT 0x1b
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN2_MASK 0x10000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN2__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN3_MASK 0x20000000
#define PB1_RX_GLB_CTRL_REG1__RX_CFG_LEQ_DCATTN_BYP_EN_GEN3__SHIFT 0x1d
#define PB1_RX_GLB_CTRL_REG1__RX_ADAPT_HLD_ASRT_TO_DCLK_EN_MASK 0xc0000000
#define PB1_RX_GLB_CTRL_REG1__RX_ADAPT_HLD_ASRT_TO_DCLK_EN__SHIFT 0x1e
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN1_MASK 0xf000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN1__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN2_MASK 0xf0000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN2__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN3_MASK 0xf00000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_CDR_TIME_GEN3__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN1_MASK 0x3000000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN1__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN2_MASK 0xc000000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN2__SHIFT 0x1a
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN3_MASK 0x30000000
#define PB1_RX_GLB_CTRL_REG2__RX_CFG_LEQ_LOOP_GAIN_GEN3__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG2__RX_DCLK_EN_ASRT_TO_ADAPT_HLD_MASK 0xc0000000
#define PB1_RX_GLB_CTRL_REG2__RX_DCLK_EN_ASRT_TO_ADAPT_HLD__SHIFT 0x1e
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN1_MASK 0x1
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN2_MASK 0x2
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN2__SHIFT 0x1
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN3_MASK 0x4
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_CDR_FR_EN_GEN3__SHIFT 0x2
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN1_MASK 0x18
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN1__SHIFT 0x3
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN2_MASK 0x60
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN2__SHIFT 0x5
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN3_MASK 0x180
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_MODE_GEN3__SHIFT 0x7
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_SUB_MODE_MASK 0xe00
#define PB1_RX_GLB_CTRL_REG3__RX_ADAPT_RST_SUB_MODE__SHIFT 0x9
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN1_MASK 0x3000
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN1__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN2_MASK 0xc000
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN2__SHIFT 0xe
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN3_MASK 0x30000
#define PB1_RX_GLB_CTRL_REG3__RX_L0_ENTRY_MODE_GEN3__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN1_MASK 0xf00000
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN1__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN2_MASK 0xf000000
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN2__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN3_MASK 0xf0000000
#define PB1_RX_GLB_CTRL_REG3__RX_CFG_DFE_TIME_GEN3__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN1_MASK 0x7
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN2_MASK 0x38
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN2__SHIFT 0x3
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN3_MASK 0x1c0
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_BER_GEN3__SHIFT 0x6
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN1_MASK 0xe00
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN1__SHIFT 0x9
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN2_MASK 0x7000
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN2__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN3_MASK 0x38000
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_LEQ_POLE_BYP_VAL_GEN3__SHIFT 0xf
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN1_MASK 0xf00000
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN1__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN2_MASK 0xf000000
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN2__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN3_MASK 0xf0000000
#define PB1_RX_GLB_CTRL_REG4__RX_CFG_FOM_TIME_GEN3__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN1_MASK 0x1f
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN2_MASK 0x3e0
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN2__SHIFT 0x5
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN3_MASK 0x7c00
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_DCATTN_BYP_VAL_GEN3__SHIFT 0xa
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN1_MASK 0x8000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN1__SHIFT 0xf
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN2_MASK 0x10000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN2__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN3_MASK 0x20000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_POLE_BYP_EN_GEN3__SHIFT 0x11
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN1_MASK 0x40000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN1__SHIFT 0x12
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN2_MASK 0x80000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN2__SHIFT 0x13
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN3_MASK 0x100000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_LEQ_SHUNT_EN_GEN3__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN1_MASK 0x8000000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN1__SHIFT 0x1b
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN2_MASK 0x10000000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN2__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN3_MASK 0x20000000
#define PB1_RX_GLB_CTRL_REG5__RX_CFG_TERM_MODE_GEN3__SHIFT 0x1d
#define PB1_RX_GLB_CTRL_REG5__RX_ADAPT_AUX_PWRON_MODE_MASK 0x80000000
#define PB1_RX_GLB_CTRL_REG5__RX_ADAPT_AUX_PWRON_MODE__SHIFT 0x1f
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN1_MASK 0xf
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN2_MASK 0xf0
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN2__SHIFT 0x4
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN3_MASK 0xf00
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_LEQ_TIME_GEN3__SHIFT 0x8
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN1_MASK 0xf000
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN1__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN2_MASK 0xf0000
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN2__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN3_MASK 0xf00000
#define PB1_RX_GLB_CTRL_REG6__RX_CFG_OC_TIME_GEN3__SHIFT 0x14
#define PB1_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS0_CDR_EN_0_MASK 0x1000000
#define PB1_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS0_CDR_EN_0__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS2_MASK 0x4000000
#define PB1_RX_GLB_CTRL_REG6__RX_FRONTEND_PWRON_LUT_ENTRY_LS2__SHIFT 0x1a
#define PB1_RX_GLB_CTRL_REG6__RX_AUX_PWRON_LUT_ENTRY_LS2_MASK 0x8000000
#define PB1_RX_GLB_CTRL_REG6__RX_AUX_PWRON_LUT_ENTRY_LS2__SHIFT 0x1b
#define PB1_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L0S_EARLY_EXIT_DIS_MASK 0x10000000
#define PB1_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L0S_EARLY_EXIT_DIS__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L1_DLL_OFF_MASK 0x20000000
#define PB1_RX_GLB_CTRL_REG6__RX_ADAPT_HLD_L1_DLL_OFF__SHIFT 0x1d
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN1_MASK 0xf
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN1__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN2_MASK 0xf0
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN2__SHIFT 0x4
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN3_MASK 0xf00
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_TH_LOOP_GAIN_GEN3__SHIFT 0x8
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS0_CDR_EN_0_MASK 0x1000
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS0_CDR_EN_0__SHIFT 0xc
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS2_MASK 0x2000
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_LUT_ENTRY_LS2__SHIFT 0xd
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_AFTER_DLL_LOCK_MASK 0x4000
#define PB1_RX_GLB_CTRL_REG7__RX_DCLK_EN_AFTER_DLL_LOCK__SHIFT 0xe
#define PB1_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS3_MASK 0x10000
#define PB1_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS3__SHIFT 0x10
#define PB1_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS2_MASK 0x20000
#define PB1_RX_GLB_CTRL_REG7__RX_DLL_PWRON_LUT_ENTRY_PS2__SHIFT 0x11
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN1_MASK 0x1c0000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN1__SHIFT 0x12
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN2_MASK 0xe00000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN2__SHIFT 0x15
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN3_MASK 0x7000000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_CPI_SEL_GEN3__SHIFT 0x18
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN1_MASK 0x8000000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN1__SHIFT 0x1b
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN2_MASK 0x10000000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN2__SHIFT 0x1c
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN3_MASK 0x20000000
#define PB1_RX_GLB_CTRL_REG7__RX_CFG_DLL_FLOCK_DISABLE_GEN3__SHIFT 0x1d
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_LOCK_TIME_MASK 0x3
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_LOCK_TIME__SHIFT 0x0
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_SPEEDCHANGE_RESET_TIME_MASK 0xc
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_SPEEDCHANGE_RESET_TIME__SHIFT 0x2
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_PWRON_IN_RAMPDOWN_MASK 0x10
#define PB1_RX_GLB_CTRL_REG8__RX_DLL_PWRON_IN_RAMPDOWN__SHIFT 0x4
#define PB1_RX_GLB_CTRL_REG8__RX_FSM_L0S_IF_RX_RDY_MASK 0x20
#define PB1_RX_GLB_CTRL_REG8__RX_FSM_L0S_IF_RX_RDY__SHIFT 0x5
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L0T3_MASK 0x1
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L0T3__SHIFT 0x0
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L4T7_MASK 0x2
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L4T7__SHIFT 0x1
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L8T11_MASK 0x4
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L8T11__SHIFT 0x2
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L12T15_MASK 0x8
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RXPWR_CBI_UPDT_L12T15__SHIFT 0x3
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L0T3_MASK 0x10
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L0T3__SHIFT 0x4
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L4T7_MASK 0x20
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L4T7__SHIFT 0x5
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L8T11_MASK 0x40
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L8T11__SHIFT 0x6
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L12T15_MASK 0x80
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ELECIDLEDETEN_CBI_UPDT_L12T15__SHIFT 0x7
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L0T3_MASK 0x100
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L0T3__SHIFT 0x8
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L4T7_MASK 0x200
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L4T7__SHIFT 0x9
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L8T11_MASK 0x400
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L8T11__SHIFT 0xa
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L12T15_MASK 0x800
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTTRK_CBI_UPDT_L12T15__SHIFT 0xb
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L0T3_MASK 0x1000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L0T3__SHIFT 0xc
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L4T7_MASK 0x2000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L4T7__SHIFT 0xd
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L8T11_MASK 0x4000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L8T11__SHIFT 0xe
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L12T15_MASK 0x8000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_ENABLEFOM_CBI_UPDT_L12T15__SHIFT 0xf
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L0T3_MASK 0x10000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L0T3__SHIFT 0x10
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L4T7_MASK 0x20000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L4T7__SHIFT 0x11
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L8T11_MASK 0x40000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L8T11__SHIFT 0x12
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L12T15_MASK 0x80000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_REQUESTFOM_CBI_UPDT_L12T15__SHIFT 0x13
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L0T3_MASK 0x100000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L0T3__SHIFT 0x14
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L4T7_MASK 0x200000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L4T7__SHIFT 0x15
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L8T11_MASK 0x400000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L8T11__SHIFT 0x16
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L12T15_MASK 0x800000
#define PB1_RX_GLB_SCI_STAT_OVRD_REG0__IGNR_RESPONSEMODE_CBI_UPDT_L12T15__SHIFT 0x17
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_VAL_MASK 0x1
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_VAL__SHIFT 0x0
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_EN_MASK 0x2
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_HLD_OVRD_EN__SHIFT 0x1
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_VAL_MASK 0x4
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_VAL__SHIFT 0x2
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_EN_MASK 0x8
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_RST_OVRD_EN__SHIFT 0x3
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_VAL_MASK 0xc0
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_VAL__SHIFT 0x6
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_EN_MASK 0x100
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DCLK_DIV_OVRD_EN__SHIFT 0x8
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_VAL_MASK 0x200
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_VAL__SHIFT 0x9
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_EN_MASK 0x400
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_DLL_FREQ_MODE_OVRD_EN__SHIFT 0xa
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_VAL_MASK 0x800
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_VAL__SHIFT 0xb
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_EN_MASK 0x1000
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_PLLCLK_SEL_OVRD_EN__SHIFT 0xc
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_VAL_MASK 0x2000
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_VAL__SHIFT 0xd
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_EN_MASK 0x4000
#define PB1_RX_GLB_OVRD_REG0__RX_CFG_RCLK_DIV_OVRD_EN__SHIFT 0xe
#define PB1_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_VAL_MASK 0x8000
#define PB1_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_VAL__SHIFT 0xf
#define PB1_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_EN_MASK 0x10000
#define PB1_RX_GLB_OVRD_REG0__RX_DCLK_EN_OVRD_EN__SHIFT 0x10
#define PB1_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_VAL_MASK 0x20000
#define PB1_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_VAL__SHIFT 0x11
#define PB1_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_EN_MASK 0x40000
#define PB1_RX_GLB_OVRD_REG0__RX_DLL_PWRON_OVRD_EN__SHIFT 0x12
#define PB1_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_VAL_MASK 0x80000
#define PB1_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_VAL__SHIFT 0x13
#define PB1_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_EN_MASK 0x100000
#define PB1_RX_GLB_OVRD_REG0__RX_FRONTEND_PWRON_OVRD_EN__SHIFT 0x14
#define PB1_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_VAL_MASK 0x200000
#define PB1_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_VAL__SHIFT 0x15
#define PB1_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_EN_MASK 0x400000
#define PB1_RX_GLB_OVRD_REG0__RX_IDLEDET_PWRON_OVRD_EN__SHIFT 0x16
#define PB1_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_VAL_MASK 0x10000000
#define PB1_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_VAL__SHIFT 0x1c
#define PB1_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_EN_MASK 0x20000000
#define PB1_RX_GLB_OVRD_REG0__RX_AUX_PWRON_OVRD_EN__SHIFT 0x1d
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_VAL_MASK 0x40000000
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_VAL__SHIFT 0x1e
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_EN_MASK 0x80000000
#define PB1_RX_GLB_OVRD_REG0__RX_ADAPT_FOM_OVRD_EN__SHIFT 0x1f
#define PB1_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_VAL_MASK 0x1
#define PB1_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_VAL__SHIFT 0x0
#define PB1_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_EN_MASK 0x2
#define PB1_RX_GLB_OVRD_REG1__RX_ADAPT_TRK_OVRD_EN__SHIFT 0x1
#define PB1_RX_LANE0_CTRL_REG0__RX_BACKUP_0_MASK 0xff
#define PB1_RX_LANE0_CTRL_REG0__RX_BACKUP_0__SHIFT 0x0
#define PB1_RX_LANE0_CTRL_REG0__RX_DBG_ANALOG_SEL_0_MASK 0xc00
#define PB1_RX_LANE0_CTRL_REG0__RX_DBG_ANALOG_SEL_0__SHIFT 0xa
#define PB1_RX_LANE0_CTRL_REG0__RX_TST_BSCAN_EN_0_MASK 0x1000
#define PB1_RX_LANE0_CTRL_REG0__RX_TST_BSCAN_EN_0__SHIFT 0xc
#define PB1_RX_LANE0_CTRL_REG0__RX_CFG_OVR_PWRSF_0_MASK 0x2000
#define PB1_RX_LANE0_CTRL_REG0__RX_CFG_OVR_PWRSF_0__SHIFT 0xd
#define PB1_RX_LANE0_CTRL_REG0__RX_TERM_EN_0_MASK 0x4000
#define PB1_RX_LANE0_CTRL_REG0__RX_TERM_EN_0__SHIFT 0xe
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RXPWR_0_MASK 0x7
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RXPWR_0__SHIFT 0x0
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_0_MASK 0x8
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_0__SHIFT 0x3
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTTRK_0_MASK 0x40
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTTRK_0__SHIFT 0x6
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__ENABLEFOM_0_MASK 0x80
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__ENABLEFOM_0__SHIFT 0x7
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTFOM_0_MASK 0x100
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__REQUESTFOM_0__SHIFT 0x8
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RESPONSEMODE_0_MASK 0x200
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RESPONSEMODE_0__SHIFT 0x9
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RXEYEFOM_0_MASK 0x3fc00
#define PB1_RX_LANE0_SCI_STAT_OVRD_REG0__RXEYEFOM_0__SHIFT 0xa
#define PB1_RX_LANE1_CTRL_REG0__RX_BACKUP_1_MASK 0xff
#define PB1_RX_LANE1_CTRL_REG0__RX_BACKUP_1__SHIFT 0x0
#define PB1_RX_LANE1_CTRL_REG0__RX_DBG_ANALOG_SEL_1_MASK 0xc00
#define PB1_RX_LANE1_CTRL_REG0__RX_DBG_ANALOG_SEL_1__SHIFT 0xa
#define PB1_RX_LANE1_CTRL_REG0__RX_TST_BSCAN_EN_1_MASK 0x1000
#define PB1_RX_LANE1_CTRL_REG0__RX_TST_BSCAN_EN_1__SHIFT 0xc
#define PB1_RX_LANE1_CTRL_REG0__RX_CFG_OVR_PWRSF_1_MASK 0x2000
#define PB1_RX_LANE1_CTRL_REG0__RX_CFG_OVR_PWRSF_1__SHIFT 0xd
#define PB1_RX_LANE1_CTRL_REG0__RX_TERM_EN_1_MASK 0x4000
#define PB1_RX_LANE1_CTRL_REG0__RX_TERM_EN_1__SHIFT 0xe
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RXPWR_1_MASK 0x7
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RXPWR_1__SHIFT 0x0
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_1_MASK 0x8
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_1__SHIFT 0x3
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTTRK_1_MASK 0x40
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTTRK_1__SHIFT 0x6
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__ENABLEFOM_1_MASK 0x80
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__ENABLEFOM_1__SHIFT 0x7
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTFOM_1_MASK 0x100
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__REQUESTFOM_1__SHIFT 0x8
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RESPONSEMODE_1_MASK 0x200
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RESPONSEMODE_1__SHIFT 0x9
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RXEYEFOM_1_MASK 0x3fc00
#define PB1_RX_LANE1_SCI_STAT_OVRD_REG0__RXEYEFOM_1__SHIFT 0xa
#define PB1_RX_LANE2_CTRL_REG0__RX_BACKUP_2_MASK 0xff
#define PB1_RX_LANE2_CTRL_REG0__RX_BACKUP_2__SHIFT 0x0
#define PB1_RX_LANE2_CTRL_REG0__RX_DBG_ANALOG_SEL_2_MASK 0xc00
#define PB1_RX_LANE2_CTRL_REG0__RX_DBG_ANALOG_SEL_2__SHIFT 0xa
#define PB1_RX_LANE2_CTRL_REG0__RX_TST_BSCAN_EN_2_MASK 0x1000
#define PB1_RX_LANE2_CTRL_REG0__RX_TST_BSCAN_EN_2__SHIFT 0xc
#define PB1_RX_LANE2_CTRL_REG0__RX_CFG_OVR_PWRSF_2_MASK 0x2000
#define PB1_RX_LANE2_CTRL_REG0__RX_CFG_OVR_PWRSF_2__SHIFT 0xd
#define PB1_RX_LANE2_CTRL_REG0__RX_TERM_EN_2_MASK 0x4000
#define PB1_RX_LANE2_CTRL_REG0__RX_TERM_EN_2__SHIFT 0xe
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RXPWR_2_MASK 0x7
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RXPWR_2__SHIFT 0x0
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_2_MASK 0x8
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_2__SHIFT 0x3
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTTRK_2_MASK 0x40
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTTRK_2__SHIFT 0x6
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__ENABLEFOM_2_MASK 0x80
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__ENABLEFOM_2__SHIFT 0x7
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTFOM_2_MASK 0x100
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__REQUESTFOM_2__SHIFT 0x8
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RESPONSEMODE_2_MASK 0x200
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RESPONSEMODE_2__SHIFT 0x9
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RXEYEFOM_2_MASK 0x3fc00
#define PB1_RX_LANE2_SCI_STAT_OVRD_REG0__RXEYEFOM_2__SHIFT 0xa
#define PB1_RX_LANE3_CTRL_REG0__RX_BACKUP_3_MASK 0xff
#define PB1_RX_LANE3_CTRL_REG0__RX_BACKUP_3__SHIFT 0x0
#define PB1_RX_LANE3_CTRL_REG0__RX_DBG_ANALOG_SEL_3_MASK 0xc00
#define PB1_RX_LANE3_CTRL_REG0__RX_DBG_ANALOG_SEL_3__SHIFT 0xa
#define PB1_RX_LANE3_CTRL_REG0__RX_TST_BSCAN_EN_3_MASK 0x1000
#define PB1_RX_LANE3_CTRL_REG0__RX_TST_BSCAN_EN_3__SHIFT 0xc
#define PB1_RX_LANE3_CTRL_REG0__RX_CFG_OVR_PWRSF_3_MASK 0x2000
#define PB1_RX_LANE3_CTRL_REG0__RX_CFG_OVR_PWRSF_3__SHIFT 0xd
#define PB1_RX_LANE3_CTRL_REG0__RX_TERM_EN_3_MASK 0x4000
#define PB1_RX_LANE3_CTRL_REG0__RX_TERM_EN_3__SHIFT 0xe
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RXPWR_3_MASK 0x7
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RXPWR_3__SHIFT 0x0
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_3_MASK 0x8
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_3__SHIFT 0x3
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTTRK_3_MASK 0x40
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTTRK_3__SHIFT 0x6
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__ENABLEFOM_3_MASK 0x80
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__ENABLEFOM_3__SHIFT 0x7
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTFOM_3_MASK 0x100
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__REQUESTFOM_3__SHIFT 0x8
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RESPONSEMODE_3_MASK 0x200
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RESPONSEMODE_3__SHIFT 0x9
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RXEYEFOM_3_MASK 0x3fc00
#define PB1_RX_LANE3_SCI_STAT_OVRD_REG0__RXEYEFOM_3__SHIFT 0xa
#define PB1_RX_LANE4_CTRL_REG0__RX_BACKUP_4_MASK 0xff
#define PB1_RX_LANE4_CTRL_REG0__RX_BACKUP_4__SHIFT 0x0
#define PB1_RX_LANE4_CTRL_REG0__RX_DBG_ANALOG_SEL_4_MASK 0xc00
#define PB1_RX_LANE4_CTRL_REG0__RX_DBG_ANALOG_SEL_4__SHIFT 0xa
#define PB1_RX_LANE4_CTRL_REG0__RX_TST_BSCAN_EN_4_MASK 0x1000
#define PB1_RX_LANE4_CTRL_REG0__RX_TST_BSCAN_EN_4__SHIFT 0xc
#define PB1_RX_LANE4_CTRL_REG0__RX_CFG_OVR_PWRSF_4_MASK 0x2000
#define PB1_RX_LANE4_CTRL_REG0__RX_CFG_OVR_PWRSF_4__SHIFT 0xd
#define PB1_RX_LANE4_CTRL_REG0__RX_TERM_EN_4_MASK 0x4000
#define PB1_RX_LANE4_CTRL_REG0__RX_TERM_EN_4__SHIFT 0xe
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RXPWR_4_MASK 0x7
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RXPWR_4__SHIFT 0x0
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_4_MASK 0x8
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_4__SHIFT 0x3
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTTRK_4_MASK 0x40
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTTRK_4__SHIFT 0x6
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__ENABLEFOM_4_MASK 0x80
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__ENABLEFOM_4__SHIFT 0x7
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTFOM_4_MASK 0x100
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__REQUESTFOM_4__SHIFT 0x8
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RESPONSEMODE_4_MASK 0x200
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RESPONSEMODE_4__SHIFT 0x9
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RXEYEFOM_4_MASK 0x3fc00
#define PB1_RX_LANE4_SCI_STAT_OVRD_REG0__RXEYEFOM_4__SHIFT 0xa
#define PB1_RX_LANE5_CTRL_REG0__RX_BACKUP_5_MASK 0xff
#define PB1_RX_LANE5_CTRL_REG0__RX_BACKUP_5__SHIFT 0x0
#define PB1_RX_LANE5_CTRL_REG0__RX_DBG_ANALOG_SEL_5_MASK 0xc00
#define PB1_RX_LANE5_CTRL_REG0__RX_DBG_ANALOG_SEL_5__SHIFT 0xa
#define PB1_RX_LANE5_CTRL_REG0__RX_TST_BSCAN_EN_5_MASK 0x1000
#define PB1_RX_LANE5_CTRL_REG0__RX_TST_BSCAN_EN_5__SHIFT 0xc
#define PB1_RX_LANE5_CTRL_REG0__RX_CFG_OVR_PWRSF_5_MASK 0x2000
#define PB1_RX_LANE5_CTRL_REG0__RX_CFG_OVR_PWRSF_5__SHIFT 0xd
#define PB1_RX_LANE5_CTRL_REG0__RX_TERM_EN_5_MASK 0x4000
#define PB1_RX_LANE5_CTRL_REG0__RX_TERM_EN_5__SHIFT 0xe
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RXPWR_5_MASK 0x7
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RXPWR_5__SHIFT 0x0
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_5_MASK 0x8
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_5__SHIFT 0x3
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTTRK_5_MASK 0x40
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTTRK_5__SHIFT 0x6
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__ENABLEFOM_5_MASK 0x80
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__ENABLEFOM_5__SHIFT 0x7
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTFOM_5_MASK 0x100
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__REQUESTFOM_5__SHIFT 0x8
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RESPONSEMODE_5_MASK 0x200
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RESPONSEMODE_5__SHIFT 0x9
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RXEYEFOM_5_MASK 0x3fc00
#define PB1_RX_LANE5_SCI_STAT_OVRD_REG0__RXEYEFOM_5__SHIFT 0xa
#define PB1_RX_LANE6_CTRL_REG0__RX_BACKUP_6_MASK 0xff
#define PB1_RX_LANE6_CTRL_REG0__RX_BACKUP_6__SHIFT 0x0
#define PB1_RX_LANE6_CTRL_REG0__RX_DBG_ANALOG_SEL_6_MASK 0xc00
#define PB1_RX_LANE6_CTRL_REG0__RX_DBG_ANALOG_SEL_6__SHIFT 0xa
#define PB1_RX_LANE6_CTRL_REG0__RX_TST_BSCAN_EN_6_MASK 0x1000
#define PB1_RX_LANE6_CTRL_REG0__RX_TST_BSCAN_EN_6__SHIFT 0xc
#define PB1_RX_LANE6_CTRL_REG0__RX_CFG_OVR_PWRSF_6_MASK 0x2000
#define PB1_RX_LANE6_CTRL_REG0__RX_CFG_OVR_PWRSF_6__SHIFT 0xd
#define PB1_RX_LANE6_CTRL_REG0__RX_TERM_EN_6_MASK 0x4000
#define PB1_RX_LANE6_CTRL_REG0__RX_TERM_EN_6__SHIFT 0xe
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RXPWR_6_MASK 0x7
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RXPWR_6__SHIFT 0x0
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_6_MASK 0x8
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_6__SHIFT 0x3
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTTRK_6_MASK 0x40
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTTRK_6__SHIFT 0x6
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__ENABLEFOM_6_MASK 0x80
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__ENABLEFOM_6__SHIFT 0x7
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTFOM_6_MASK 0x100
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__REQUESTFOM_6__SHIFT 0x8
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RESPONSEMODE_6_MASK 0x200
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RESPONSEMODE_6__SHIFT 0x9
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RXEYEFOM_6_MASK 0x3fc00
#define PB1_RX_LANE6_SCI_STAT_OVRD_REG0__RXEYEFOM_6__SHIFT 0xa
#define PB1_RX_LANE7_CTRL_REG0__RX_BACKUP_7_MASK 0xff
#define PB1_RX_LANE7_CTRL_REG0__RX_BACKUP_7__SHIFT 0x0
#define PB1_RX_LANE7_CTRL_REG0__RX_DBG_ANALOG_SEL_7_MASK 0xc00
#define PB1_RX_LANE7_CTRL_REG0__RX_DBG_ANALOG_SEL_7__SHIFT 0xa
#define PB1_RX_LANE7_CTRL_REG0__RX_TST_BSCAN_EN_7_MASK 0x1000
#define PB1_RX_LANE7_CTRL_REG0__RX_TST_BSCAN_EN_7__SHIFT 0xc
#define PB1_RX_LANE7_CTRL_REG0__RX_CFG_OVR_PWRSF_7_MASK 0x2000
#define PB1_RX_LANE7_CTRL_REG0__RX_CFG_OVR_PWRSF_7__SHIFT 0xd
#define PB1_RX_LANE7_CTRL_REG0__RX_TERM_EN_7_MASK 0x4000
#define PB1_RX_LANE7_CTRL_REG0__RX_TERM_EN_7__SHIFT 0xe
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RXPWR_7_MASK 0x7
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RXPWR_7__SHIFT 0x0
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_7_MASK 0x8
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_7__SHIFT 0x3
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTTRK_7_MASK 0x40
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTTRK_7__SHIFT 0x6
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__ENABLEFOM_7_MASK 0x80
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__ENABLEFOM_7__SHIFT 0x7
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTFOM_7_MASK 0x100
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__REQUESTFOM_7__SHIFT 0x8
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RESPONSEMODE_7_MASK 0x200
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RESPONSEMODE_7__SHIFT 0x9
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RXEYEFOM_7_MASK 0x3fc00
#define PB1_RX_LANE7_SCI_STAT_OVRD_REG0__RXEYEFOM_7__SHIFT 0xa
#define PB1_RX_LANE8_CTRL_REG0__RX_BACKUP_8_MASK 0xff
#define PB1_RX_LANE8_CTRL_REG0__RX_BACKUP_8__SHIFT 0x0
#define PB1_RX_LANE8_CTRL_REG0__RX_DBG_ANALOG_SEL_8_MASK 0xc00
#define PB1_RX_LANE8_CTRL_REG0__RX_DBG_ANALOG_SEL_8__SHIFT 0xa
#define PB1_RX_LANE8_CTRL_REG0__RX_TST_BSCAN_EN_8_MASK 0x1000
#define PB1_RX_LANE8_CTRL_REG0__RX_TST_BSCAN_EN_8__SHIFT 0xc
#define PB1_RX_LANE8_CTRL_REG0__RX_CFG_OVR_PWRSF_8_MASK 0x2000
#define PB1_RX_LANE8_CTRL_REG0__RX_CFG_OVR_PWRSF_8__SHIFT 0xd
#define PB1_RX_LANE8_CTRL_REG0__RX_TERM_EN_8_MASK 0x4000
#define PB1_RX_LANE8_CTRL_REG0__RX_TERM_EN_8__SHIFT 0xe
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RXPWR_8_MASK 0x7
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RXPWR_8__SHIFT 0x0
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_8_MASK 0x8
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_8__SHIFT 0x3
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTTRK_8_MASK 0x40
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTTRK_8__SHIFT 0x6
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__ENABLEFOM_8_MASK 0x80
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__ENABLEFOM_8__SHIFT 0x7
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTFOM_8_MASK 0x100
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__REQUESTFOM_8__SHIFT 0x8
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RESPONSEMODE_8_MASK 0x200
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RESPONSEMODE_8__SHIFT 0x9
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RXEYEFOM_8_MASK 0x3fc00
#define PB1_RX_LANE8_SCI_STAT_OVRD_REG0__RXEYEFOM_8__SHIFT 0xa
#define PB1_RX_LANE9_CTRL_REG0__RX_BACKUP_9_MASK 0xff
#define PB1_RX_LANE9_CTRL_REG0__RX_BACKUP_9__SHIFT 0x0
#define PB1_RX_LANE9_CTRL_REG0__RX_DBG_ANALOG_SEL_9_MASK 0xc00
#define PB1_RX_LANE9_CTRL_REG0__RX_DBG_ANALOG_SEL_9__SHIFT 0xa
#define PB1_RX_LANE9_CTRL_REG0__RX_TST_BSCAN_EN_9_MASK 0x1000
#define PB1_RX_LANE9_CTRL_REG0__RX_TST_BSCAN_EN_9__SHIFT 0xc
#define PB1_RX_LANE9_CTRL_REG0__RX_CFG_OVR_PWRSF_9_MASK 0x2000
#define PB1_RX_LANE9_CTRL_REG0__RX_CFG_OVR_PWRSF_9__SHIFT 0xd
#define PB1_RX_LANE9_CTRL_REG0__RX_TERM_EN_9_MASK 0x4000
#define PB1_RX_LANE9_CTRL_REG0__RX_TERM_EN_9__SHIFT 0xe
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RXPWR_9_MASK 0x7
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RXPWR_9__SHIFT 0x0
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_9_MASK 0x8
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_9__SHIFT 0x3
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTTRK_9_MASK 0x40
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTTRK_9__SHIFT 0x6
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__ENABLEFOM_9_MASK 0x80
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__ENABLEFOM_9__SHIFT 0x7
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTFOM_9_MASK 0x100
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__REQUESTFOM_9__SHIFT 0x8
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RESPONSEMODE_9_MASK 0x200
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RESPONSEMODE_9__SHIFT 0x9
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RXEYEFOM_9_MASK 0x3fc00
#define PB1_RX_LANE9_SCI_STAT_OVRD_REG0__RXEYEFOM_9__SHIFT 0xa
#define PB1_RX_LANE10_CTRL_REG0__RX_BACKUP_10_MASK 0xff
#define PB1_RX_LANE10_CTRL_REG0__RX_BACKUP_10__SHIFT 0x0
#define PB1_RX_LANE10_CTRL_REG0__RX_DBG_ANALOG_SEL_10_MASK 0xc00
#define PB1_RX_LANE10_CTRL_REG0__RX_DBG_ANALOG_SEL_10__SHIFT 0xa
#define PB1_RX_LANE10_CTRL_REG0__RX_TST_BSCAN_EN_10_MASK 0x1000
#define PB1_RX_LANE10_CTRL_REG0__RX_TST_BSCAN_EN_10__SHIFT 0xc
#define PB1_RX_LANE10_CTRL_REG0__RX_CFG_OVR_PWRSF_10_MASK 0x2000
#define PB1_RX_LANE10_CTRL_REG0__RX_CFG_OVR_PWRSF_10__SHIFT 0xd
#define PB1_RX_LANE10_CTRL_REG0__RX_TERM_EN_10_MASK 0x4000
#define PB1_RX_LANE10_CTRL_REG0__RX_TERM_EN_10__SHIFT 0xe
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RXPWR_10_MASK 0x7
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RXPWR_10__SHIFT 0x0
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_10_MASK 0x8
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_10__SHIFT 0x3
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTTRK_10_MASK 0x40
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTTRK_10__SHIFT 0x6
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__ENABLEFOM_10_MASK 0x80
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__ENABLEFOM_10__SHIFT 0x7
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTFOM_10_MASK 0x100
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__REQUESTFOM_10__SHIFT 0x8
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RESPONSEMODE_10_MASK 0x200
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RESPONSEMODE_10__SHIFT 0x9
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RXEYEFOM_10_MASK 0x3fc00
#define PB1_RX_LANE10_SCI_STAT_OVRD_REG0__RXEYEFOM_10__SHIFT 0xa
#define PB1_RX_LANE11_CTRL_REG0__RX_BACKUP_11_MASK 0xff
#define PB1_RX_LANE11_CTRL_REG0__RX_BACKUP_11__SHIFT 0x0
#define PB1_RX_LANE11_CTRL_REG0__RX_DBG_ANALOG_SEL_11_MASK 0xc00
#define PB1_RX_LANE11_CTRL_REG0__RX_DBG_ANALOG_SEL_11__SHIFT 0xa
#define PB1_RX_LANE11_CTRL_REG0__RX_TST_BSCAN_EN_11_MASK 0x1000
#define PB1_RX_LANE11_CTRL_REG0__RX_TST_BSCAN_EN_11__SHIFT 0xc
#define PB1_RX_LANE11_CTRL_REG0__RX_CFG_OVR_PWRSF_11_MASK 0x2000
#define PB1_RX_LANE11_CTRL_REG0__RX_CFG_OVR_PWRSF_11__SHIFT 0xd
#define PB1_RX_LANE11_CTRL_REG0__RX_TERM_EN_11_MASK 0x4000
#define PB1_RX_LANE11_CTRL_REG0__RX_TERM_EN_11__SHIFT 0xe
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RXPWR_11_MASK 0x7
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RXPWR_11__SHIFT 0x0
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_11_MASK 0x8
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_11__SHIFT 0x3
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTTRK_11_MASK 0x40
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTTRK_11__SHIFT 0x6
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__ENABLEFOM_11_MASK 0x80
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__ENABLEFOM_11__SHIFT 0x7
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTFOM_11_MASK 0x100
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__REQUESTFOM_11__SHIFT 0x8
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RESPONSEMODE_11_MASK 0x200
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RESPONSEMODE_11__SHIFT 0x9
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RXEYEFOM_11_MASK 0x3fc00
#define PB1_RX_LANE11_SCI_STAT_OVRD_REG0__RXEYEFOM_11__SHIFT 0xa
#define PB1_RX_LANE12_CTRL_REG0__RX_BACKUP_12_MASK 0xff
#define PB1_RX_LANE12_CTRL_REG0__RX_BACKUP_12__SHIFT 0x0
#define PB1_RX_LANE12_CTRL_REG0__RX_DBG_ANALOG_SEL_12_MASK 0xc00
#define PB1_RX_LANE12_CTRL_REG0__RX_DBG_ANALOG_SEL_12__SHIFT 0xa
#define PB1_RX_LANE12_CTRL_REG0__RX_TST_BSCAN_EN_12_MASK 0x1000
#define PB1_RX_LANE12_CTRL_REG0__RX_TST_BSCAN_EN_12__SHIFT 0xc
#define PB1_RX_LANE12_CTRL_REG0__RX_CFG_OVR_PWRSF_12_MASK 0x2000
#define PB1_RX_LANE12_CTRL_REG0__RX_CFG_OVR_PWRSF_12__SHIFT 0xd
#define PB1_RX_LANE12_CTRL_REG0__RX_TERM_EN_12_MASK 0x4000
#define PB1_RX_LANE12_CTRL_REG0__RX_TERM_EN_12__SHIFT 0xe
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RXPWR_12_MASK 0x7
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RXPWR_12__SHIFT 0x0
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_12_MASK 0x8
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_12__SHIFT 0x3
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTTRK_12_MASK 0x40
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTTRK_12__SHIFT 0x6
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__ENABLEFOM_12_MASK 0x80
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__ENABLEFOM_12__SHIFT 0x7
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTFOM_12_MASK 0x100
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__REQUESTFOM_12__SHIFT 0x8
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RESPONSEMODE_12_MASK 0x200
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RESPONSEMODE_12__SHIFT 0x9
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RXEYEFOM_12_MASK 0x3fc00
#define PB1_RX_LANE12_SCI_STAT_OVRD_REG0__RXEYEFOM_12__SHIFT 0xa
#define PB1_RX_LANE13_CTRL_REG0__RX_BACKUP_13_MASK 0xff
#define PB1_RX_LANE13_CTRL_REG0__RX_BACKUP_13__SHIFT 0x0
#define PB1_RX_LANE13_CTRL_REG0__RX_DBG_ANALOG_SEL_13_MASK 0xc00
#define PB1_RX_LANE13_CTRL_REG0__RX_DBG_ANALOG_SEL_13__SHIFT 0xa
#define PB1_RX_LANE13_CTRL_REG0__RX_TST_BSCAN_EN_13_MASK 0x1000
#define PB1_RX_LANE13_CTRL_REG0__RX_TST_BSCAN_EN_13__SHIFT 0xc
#define PB1_RX_LANE13_CTRL_REG0__RX_CFG_OVR_PWRSF_13_MASK 0x2000
#define PB1_RX_LANE13_CTRL_REG0__RX_CFG_OVR_PWRSF_13__SHIFT 0xd
#define PB1_RX_LANE13_CTRL_REG0__RX_TERM_EN_13_MASK 0x4000
#define PB1_RX_LANE13_CTRL_REG0__RX_TERM_EN_13__SHIFT 0xe
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RXPWR_13_MASK 0x7
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RXPWR_13__SHIFT 0x0
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_13_MASK 0x8
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_13__SHIFT 0x3
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTTRK_13_MASK 0x40
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTTRK_13__SHIFT 0x6
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__ENABLEFOM_13_MASK 0x80
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__ENABLEFOM_13__SHIFT 0x7
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTFOM_13_MASK 0x100
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__REQUESTFOM_13__SHIFT 0x8
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RESPONSEMODE_13_MASK 0x200
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RESPONSEMODE_13__SHIFT 0x9
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RXEYEFOM_13_MASK 0x3fc00
#define PB1_RX_LANE13_SCI_STAT_OVRD_REG0__RXEYEFOM_13__SHIFT 0xa
#define PB1_RX_LANE14_CTRL_REG0__RX_BACKUP_14_MASK 0xff
#define PB1_RX_LANE14_CTRL_REG0__RX_BACKUP_14__SHIFT 0x0
#define PB1_RX_LANE14_CTRL_REG0__RX_DBG_ANALOG_SEL_14_MASK 0xc00
#define PB1_RX_LANE14_CTRL_REG0__RX_DBG_ANALOG_SEL_14__SHIFT 0xa
#define PB1_RX_LANE14_CTRL_REG0__RX_TST_BSCAN_EN_14_MASK 0x1000
#define PB1_RX_LANE14_CTRL_REG0__RX_TST_BSCAN_EN_14__SHIFT 0xc
#define PB1_RX_LANE14_CTRL_REG0__RX_CFG_OVR_PWRSF_14_MASK 0x2000
#define PB1_RX_LANE14_CTRL_REG0__RX_CFG_OVR_PWRSF_14__SHIFT 0xd
#define PB1_RX_LANE14_CTRL_REG0__RX_TERM_EN_14_MASK 0x4000
#define PB1_RX_LANE14_CTRL_REG0__RX_TERM_EN_14__SHIFT 0xe
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RXPWR_14_MASK 0x7
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RXPWR_14__SHIFT 0x0
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_14_MASK 0x8
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_14__SHIFT 0x3
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTTRK_14_MASK 0x40
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTTRK_14__SHIFT 0x6
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__ENABLEFOM_14_MASK 0x80
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__ENABLEFOM_14__SHIFT 0x7
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTFOM_14_MASK 0x100
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__REQUESTFOM_14__SHIFT 0x8
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RESPONSEMODE_14_MASK 0x200
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RESPONSEMODE_14__SHIFT 0x9
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RXEYEFOM_14_MASK 0x3fc00
#define PB1_RX_LANE14_SCI_STAT_OVRD_REG0__RXEYEFOM_14__SHIFT 0xa
#define PB1_RX_LANE15_CTRL_REG0__RX_BACKUP_15_MASK 0xff
#define PB1_RX_LANE15_CTRL_REG0__RX_BACKUP_15__SHIFT 0x0
#define PB1_RX_LANE15_CTRL_REG0__RX_DBG_ANALOG_SEL_15_MASK 0xc00
#define PB1_RX_LANE15_CTRL_REG0__RX_DBG_ANALOG_SEL_15__SHIFT 0xa
#define PB1_RX_LANE15_CTRL_REG0__RX_TST_BSCAN_EN_15_MASK 0x1000
#define PB1_RX_LANE15_CTRL_REG0__RX_TST_BSCAN_EN_15__SHIFT 0xc
#define PB1_RX_LANE15_CTRL_REG0__RX_CFG_OVR_PWRSF_15_MASK 0x2000
#define PB1_RX_LANE15_CTRL_REG0__RX_CFG_OVR_PWRSF_15__SHIFT 0xd
#define PB1_RX_LANE15_CTRL_REG0__RX_TERM_EN_15_MASK 0x4000
#define PB1_RX_LANE15_CTRL_REG0__RX_TERM_EN_15__SHIFT 0xe
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RXPWR_15_MASK 0x7
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RXPWR_15__SHIFT 0x0
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_15_MASK 0x8
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__ELECIDLEDETEN_15__SHIFT 0x3
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTTRK_15_MASK 0x40
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTTRK_15__SHIFT 0x6
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__ENABLEFOM_15_MASK 0x80
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__ENABLEFOM_15__SHIFT 0x7
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTFOM_15_MASK 0x100
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__REQUESTFOM_15__SHIFT 0x8
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RESPONSEMODE_15_MASK 0x200
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RESPONSEMODE_15__SHIFT 0x9
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RXEYEFOM_15_MASK 0x3fc00
#define PB1_RX_LANE15_SCI_STAT_OVRD_REG0__RXEYEFOM_15__SHIFT 0xa
#define PB1_TX_GLB_CTRL_REG0__TX_DRV_DATA_ASRT_DLY_VAL_MASK 0x7
#define PB1_TX_GLB_CTRL_REG0__TX_DRV_DATA_ASRT_DLY_VAL__SHIFT 0x0
#define PB1_TX_GLB_CTRL_REG0__TX_DRV_DATA_DSRT_DLY_VAL_MASK 0x38
#define PB1_TX_GLB_CTRL_REG0__TX_DRV_DATA_DSRT_DLY_VAL__SHIFT 0x3
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN1_MASK 0x700
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN1__SHIFT 0x8
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN2_MASK 0x3800
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN2__SHIFT 0xb
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN3_MASK 0x1c000
#define PB1_TX_GLB_CTRL_REG0__TX_CFG_RPTR_RST_VAL_GEN3__SHIFT 0xe
#define PB1_TX_GLB_CTRL_REG0__TX_STAGGER_CTRL_MASK 0x60000
#define PB1_TX_GLB_CTRL_REG0__TX_STAGGER_CTRL__SHIFT 0x11
#define PB1_TX_GLB_CTRL_REG0__TX_DATA_CLK_GATING_MASK 0x80000
#define PB1_TX_GLB_CTRL_REG0__TX_DATA_CLK_GATING__SHIFT 0x13
#define PB1_TX_GLB_CTRL_REG0__TX_PRESET_TABLE_BYPASS_MASK 0x100000
#define PB1_TX_GLB_CTRL_REG0__TX_PRESET_TABLE_BYPASS__SHIFT 0x14
#define PB1_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_EN_MASK 0x200000
#define PB1_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_EN__SHIFT 0x15
#define PB1_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_DIR_VER_MASK 0x400000
#define PB1_TX_GLB_CTRL_REG0__TX_COEFF_ROUND_DIR_VER__SHIFT 0x16
#define PB1_TX_GLB_CTRL_REG0__TX_DCLK_EN_LSX_ALWAYS_ON_MASK 0x800000
#define PB1_TX_GLB_CTRL_REG0__TX_DCLK_EN_LSX_ALWAYS_ON__SHIFT 0x17
#define PB1_TX_GLB_CTRL_REG0__TX_FRONTEND_PWRON_IN_PS4_MASK 0x1000000
#define PB1_TX_GLB_CTRL_REG0__TX_FRONTEND_PWRON_IN_PS4__SHIFT 0x18
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_0_MASK 0x1
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_0__SHIFT 0x0
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_1_MASK 0x2
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_1__SHIFT 0x1
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_2_MASK 0x4
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_2__SHIFT 0x2
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_3_MASK 0x8
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_3__SHIFT 0x3
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_4_MASK 0x10
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_4__SHIFT 0x4
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_5_MASK 0x20
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_5__SHIFT 0x5
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_6_MASK 0x40
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_6__SHIFT 0x6
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_7_MASK 0x80
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_7__SHIFT 0x7
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_8_MASK 0x100
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_8__SHIFT 0x8
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_9_MASK 0x200
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_9__SHIFT 0x9
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_10_MASK 0x400
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_10__SHIFT 0xa
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_11_MASK 0x800
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_11__SHIFT 0xb
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_12_MASK 0x1000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_12__SHIFT 0xc
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_13_MASK 0x2000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_13__SHIFT 0xd
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_14_MASK 0x4000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_14__SHIFT 0xe
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_15_MASK 0x8000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX1_EN_15__SHIFT 0xf
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L0T1_MASK 0x10000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L0T1__SHIFT 0x10
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L2T3_MASK 0x20000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L2T3__SHIFT 0x11
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L4T5_MASK 0x40000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L4T5__SHIFT 0x12
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L6T7_MASK 0x80000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L6T7__SHIFT 0x13
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L8T9_MASK 0x100000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L8T9__SHIFT 0x14
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L10T11_MASK 0x200000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L10T11__SHIFT 0x15
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L12T13_MASK 0x400000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L12T13__SHIFT 0x16
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L14T15_MASK 0x800000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX2_EN_L14T15__SHIFT 0x17
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L0T3_MASK 0x1000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L0T3__SHIFT 0x18
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L4T7_MASK 0x2000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L4T7__SHIFT 0x19
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L8T11_MASK 0x4000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L8T11__SHIFT 0x1a
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L12T15_MASK 0x8000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX4_EN_L12T15__SHIFT 0x1b
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L0T7_MASK 0x10000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L0T7__SHIFT 0x1c
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L8T15_MASK 0x20000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX8_EN_L8T15__SHIFT 0x1d
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX16_EN_L0T15_MASK 0x40000000
#define PB1_TX_GLB_LANE_SKEW_CTRL__TX_CFG_GROUPX16_EN_L0T15__SHIFT 0x1e
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L0T3_MASK 0x1
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L0T3__SHIFT 0x0
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L4T7_MASK 0x2
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L4T7__SHIFT 0x1
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L8T11_MASK 0x4
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L8T11__SHIFT 0x2
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L12T15_MASK 0x8
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_TXPWR_CBI_UPDT_L12T15__SHIFT 0x3
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L0T3_MASK 0x100
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L0T3__SHIFT 0x8
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L4T7_MASK 0x200
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L4T7__SHIFT 0x9
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L8T11_MASK 0x400
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L8T11__SHIFT 0xa
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L12T15_MASK 0x800
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENTID_CBI_UPDT_L12T15__SHIFT 0xb
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L0T3_MASK 0x1000
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L0T3__SHIFT 0xc
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L4T7_MASK 0x2000
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L4T7__SHIFT 0xd
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L8T11_MASK 0x4000
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L8T11__SHIFT 0xe
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L12T15_MASK 0x8000
#define PB1_TX_GLB_SCI_STAT_OVRD_REG0__IGNR_COEFFICIENT_CBI_UPDT_L12T15__SHIFT 0xf
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_0_MASK 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_0__SHIFT 0x0
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_1_MASK 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_1__SHIFT 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_2_MASK 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_2__SHIFT 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_3_MASK 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_3__SHIFT 0x3
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_4_MASK 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_4__SHIFT 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_5_MASK 0x20
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_5__SHIFT 0x5
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_6_MASK 0x40
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_6__SHIFT 0x6
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_7_MASK 0x80
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_7__SHIFT 0x7
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_8_MASK 0x100
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_8__SHIFT 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_9_MASK 0x200
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_9__SHIFT 0x9
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_10_MASK 0x400
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_10__SHIFT 0xa
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_11_MASK 0x800
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_11__SHIFT 0xb
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_12_MASK 0x1000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_12__SHIFT 0xc
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_13_MASK 0x2000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_13__SHIFT 0xd
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_14_MASK 0x4000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_14__SHIFT 0xe
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_15_MASK 0x8000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_15__SHIFT 0xf
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_16_MASK 0x10000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_16__SHIFT 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_17_MASK 0x20000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_17__SHIFT 0x11
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_18_MASK 0x40000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_18__SHIFT 0x12
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_19_MASK 0x80000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_19__SHIFT 0x13
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_20_MASK 0x100000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_20__SHIFT 0x14
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_21_MASK 0x200000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_21__SHIFT 0x15
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_22_MASK 0x400000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_22__SHIFT 0x16
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_23_MASK 0x800000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_23__SHIFT 0x17
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_24_MASK 0x1000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_24__SHIFT 0x18
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_25_MASK 0x2000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_25__SHIFT 0x19
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_26_MASK 0x4000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_26__SHIFT 0x1a
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_27_MASK 0x8000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_27__SHIFT 0x1b
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_28_MASK 0x10000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_28__SHIFT 0x1c
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_29_MASK 0x20000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_29__SHIFT 0x1d
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_30_MASK 0x40000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_30__SHIFT 0x1e
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_31_MASK 0x80000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG0__ACCEPT_ENTRY_31__SHIFT 0x1f
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_32_MASK 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_32__SHIFT 0x0
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_33_MASK 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_33__SHIFT 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_34_MASK 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_34__SHIFT 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_35_MASK 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_35__SHIFT 0x3
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_36_MASK 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_36__SHIFT 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_37_MASK 0x20
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_37__SHIFT 0x5
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_38_MASK 0x40
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_38__SHIFT 0x6
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_39_MASK 0x80
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_39__SHIFT 0x7
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_40_MASK 0x100
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_40__SHIFT 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_41_MASK 0x200
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_41__SHIFT 0x9
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_42_MASK 0x400
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_42__SHIFT 0xa
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_43_MASK 0x800
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_43__SHIFT 0xb
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_44_MASK 0x1000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_44__SHIFT 0xc
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_45_MASK 0x2000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_45__SHIFT 0xd
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_46_MASK 0x4000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_46__SHIFT 0xe
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_47_MASK 0x8000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_47__SHIFT 0xf
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_48_MASK 0x10000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_48__SHIFT 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_49_MASK 0x20000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_49__SHIFT 0x11
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_50_MASK 0x40000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_50__SHIFT 0x12
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_51_MASK 0x80000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_51__SHIFT 0x13
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_52_MASK 0x100000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_52__SHIFT 0x14
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_53_MASK 0x200000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_53__SHIFT 0x15
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_54_MASK 0x400000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_54__SHIFT 0x16
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_55_MASK 0x800000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_55__SHIFT 0x17
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_56_MASK 0x1000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_56__SHIFT 0x18
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_57_MASK 0x2000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_57__SHIFT 0x19
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_58_MASK 0x4000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_58__SHIFT 0x1a
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_59_MASK 0x8000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_59__SHIFT 0x1b
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_60_MASK 0x10000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_60__SHIFT 0x1c
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_61_MASK 0x20000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_61__SHIFT 0x1d
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_62_MASK 0x40000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_62__SHIFT 0x1e
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_63_MASK 0x80000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG1__ACCEPT_ENTRY_63__SHIFT 0x1f
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_64_MASK 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_64__SHIFT 0x0
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_65_MASK 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_65__SHIFT 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_66_MASK 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_66__SHIFT 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_67_MASK 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_67__SHIFT 0x3
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_68_MASK 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_68__SHIFT 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_69_MASK 0x20
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_69__SHIFT 0x5
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_70_MASK 0x40
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_70__SHIFT 0x6
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_71_MASK 0x80
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_71__SHIFT 0x7
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_72_MASK 0x100
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_72__SHIFT 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_73_MASK 0x200
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_73__SHIFT 0x9
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_74_MASK 0x400
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_74__SHIFT 0xa
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_75_MASK 0x800
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_75__SHIFT 0xb
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_76_MASK 0x1000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_76__SHIFT 0xc
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_77_MASK 0x2000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_77__SHIFT 0xd
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_78_MASK 0x4000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_78__SHIFT 0xe
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_79_MASK 0x8000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_79__SHIFT 0xf
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_80_MASK 0x10000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_80__SHIFT 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_81_MASK 0x20000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_81__SHIFT 0x11
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_82_MASK 0x40000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_82__SHIFT 0x12
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_83_MASK 0x80000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_83__SHIFT 0x13
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_84_MASK 0x100000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_84__SHIFT 0x14
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_85_MASK 0x200000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_85__SHIFT 0x15
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_86_MASK 0x400000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_86__SHIFT 0x16
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_87_MASK 0x800000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_87__SHIFT 0x17
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_88_MASK 0x1000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_88__SHIFT 0x18
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_89_MASK 0x2000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_89__SHIFT 0x19
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_90_MASK 0x4000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_90__SHIFT 0x1a
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_91_MASK 0x8000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_91__SHIFT 0x1b
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_92_MASK 0x10000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_92__SHIFT 0x1c
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_93_MASK 0x20000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_93__SHIFT 0x1d
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_94_MASK 0x40000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_94__SHIFT 0x1e
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_95_MASK 0x80000000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG2__ACCEPT_ENTRY_95__SHIFT 0x1f
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_96_MASK 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_96__SHIFT 0x0
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_97_MASK 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_97__SHIFT 0x1
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_98_MASK 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_98__SHIFT 0x2
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_99_MASK 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_99__SHIFT 0x3
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_100_MASK 0x10
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_100__SHIFT 0x4
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_101_MASK 0x20
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_101__SHIFT 0x5
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_102_MASK 0x40
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_102__SHIFT 0x6
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_103_MASK 0x80
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_103__SHIFT 0x7
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_104_MASK 0x100
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_104__SHIFT 0x8
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_105_MASK 0x200
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_105__SHIFT 0x9
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_106_MASK 0x400
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_106__SHIFT 0xa
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_107_MASK 0x800
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_107__SHIFT 0xb
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_108_MASK 0x1000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_108__SHIFT 0xc
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_109_MASK 0x2000
#define PB1_TX_GLB_COEFF_ACCEPT_TABLE_REG3__ACCEPT_ENTRY_109__SHIFT 0xd
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_VAL_MASK 0x7
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_VAL__SHIFT 0x0
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_EN_MASK 0x8
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DCLK_DIV_OVRD_EN__SHIFT 0x3
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_GEN1_OVRD_VAL_MASK 0xf0
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_GEN1_OVRD_VAL__SHIFT 0x4
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_OVRD_EN_MASK 0x100
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_EN_OVRD_EN__SHIFT 0x8
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_GEN1_OVRD_VAL_MASK 0x1e00
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x9
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_OVRD_EN_MASK 0x2000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV0_TAP_SEL_OVRD_EN__SHIFT 0xd
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_GEN1_OVRD_VAL_MASK 0x7c000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_GEN1_OVRD_VAL__SHIFT 0xe
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_OVRD_EN_MASK 0x80000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_EN_OVRD_EN__SHIFT 0x13
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_GEN1_OVRD_VAL_MASK 0x1f00000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x14
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_OVRD_EN_MASK 0x2000000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV1_TAP_SEL_OVRD_EN__SHIFT 0x19
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_GEN1_OVRD_VAL_MASK 0x3c000000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_GEN1_OVRD_VAL__SHIFT 0x1a
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_OVRD_EN_MASK 0x40000000
#define PB1_TX_GLB_OVRD_REG0__TX_CFG_DRV2_EN_OVRD_EN__SHIFT 0x1e
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_GEN1_OVRD_VAL_MASK 0xf
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x0
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_OVRD_EN_MASK 0x10
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRV2_TAP_SEL_OVRD_EN__SHIFT 0x4
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_GEN1_OVRD_VAL_MASK 0x20
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_GEN1_OVRD_VAL__SHIFT 0x5
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_OVRD_EN_MASK 0x40
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_EN_OVRD_EN__SHIFT 0x6
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_GEN1_OVRD_VAL_MASK 0x80
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_GEN1_OVRD_VAL__SHIFT 0x7
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_OVRD_EN_MASK 0x100
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_DRVX_TAP_SEL_OVRD_EN__SHIFT 0x8
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_VAL_MASK 0x200
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_VAL__SHIFT 0x9
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_EN_MASK 0x400
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_PLLCLK_SEL_OVRD_EN__SHIFT 0xa
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_VAL_MASK 0x800
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_VAL__SHIFT 0xb
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_EN_MASK 0x1000
#define PB1_TX_GLB_OVRD_REG1__TX_CFG_TCLK_DIV_OVRD_EN__SHIFT 0xc
#define PB1_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_VAL_MASK 0x2000
#define PB1_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_VAL__SHIFT 0xd
#define PB1_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_EN_MASK 0x4000
#define PB1_TX_GLB_OVRD_REG1__TX_CMDET_EN_OVRD_EN__SHIFT 0xe
#define PB1_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_VAL_MASK 0x1ff8000
#define PB1_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_VAL__SHIFT 0xf
#define PB1_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_EN_MASK 0x2000000
#define PB1_TX_GLB_OVRD_REG1__TX_DATA_IN_OVRD_EN__SHIFT 0x19
#define PB1_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_VAL_MASK 0x4000000
#define PB1_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_VAL__SHIFT 0x1a
#define PB1_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_EN_MASK 0x8000000
#define PB1_TX_GLB_OVRD_REG1__TX_RPTR_RSTN_OVRD_EN__SHIFT 0x1b
#define PB1_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_VAL_MASK 0x10000000
#define PB1_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_VAL__SHIFT 0x1c
#define PB1_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_EN_MASK 0x20000000
#define PB1_TX_GLB_OVRD_REG1__TX_RXDET_EN_OVRD_EN__SHIFT 0x1d
#define PB1_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_VAL_MASK 0x40000000
#define PB1_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_VAL__SHIFT 0x1e
#define PB1_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_EN_MASK 0x80000000
#define PB1_TX_GLB_OVRD_REG1__TX_WPTR_RSTN_OVRD_EN__SHIFT 0x1f
#define PB1_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_VAL_MASK 0x1
#define PB1_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_VAL__SHIFT 0x0
#define PB1_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_EN_MASK 0x2
#define PB1_TX_GLB_OVRD_REG2__TX_WRITE_EN_OVRD_EN__SHIFT 0x1
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_VAL_MASK 0x4
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_VAL__SHIFT 0x2
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_EN_MASK 0x8
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX1_EN_OVRD_EN__SHIFT 0x3
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_VAL_MASK 0x10
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_VAL__SHIFT 0x4
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_EN_MASK 0x20
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX2_EN_OVRD_EN__SHIFT 0x5
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_VAL_MASK 0x40
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_VAL__SHIFT 0x6
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_EN_MASK 0x80
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX4_EN_OVRD_EN__SHIFT 0x7
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_VAL_MASK 0x100
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_VAL__SHIFT 0x8
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_EN_MASK 0x200
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX8_EN_OVRD_EN__SHIFT 0x9
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_VAL_MASK 0x400
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_VAL__SHIFT 0xa
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_EN_MASK 0x800
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_GROUPX16_EN_OVRD_EN__SHIFT 0xb
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV0_EN_GEN2_OVRD_VAL_MASK 0xf000
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV0_EN_GEN2_OVRD_VAL__SHIFT 0xc
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV0_TAP_SEL_GEN2_OVRD_VAL_MASK 0xf0000
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV0_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x10
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV1_EN_GEN2_OVRD_VAL_MASK 0x1f00000
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV1_EN_GEN2_OVRD_VAL__SHIFT 0x14
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV1_TAP_SEL_GEN2_OVRD_VAL_MASK 0x3e000000
#define PB1_TX_GLB_OVRD_REG2__TX_CFG_DRV1_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x19
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN2_OVRD_VAL_MASK 0xf
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN2_OVRD_VAL__SHIFT 0x0
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_TAP_SEL_GEN2_OVRD_VAL_MASK 0xf0
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x4
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRVX_EN_GEN2_OVRD_VAL_MASK 0x100
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRVX_EN_GEN2_OVRD_VAL__SHIFT 0x8
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRVX_TAP_SEL_GEN2_OVRD_VAL_MASK 0x200
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRVX_TAP_SEL_GEN2_OVRD_VAL__SHIFT 0x9
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV0_EN_GEN3_OVRD_VAL_MASK 0x3c00
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV0_EN_GEN3_OVRD_VAL__SHIFT 0xa
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV0_TAP_SEL_GEN3_OVRD_VAL_MASK 0x3c000
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV0_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0xe
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV1_EN_GEN3_OVRD_VAL_MASK 0x7c0000
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV1_EN_GEN3_OVRD_VAL__SHIFT 0x12
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV1_TAP_SEL_GEN3_OVRD_VAL_MASK 0xf800000
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV1_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x17
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN3_OVRD_VAL_MASK 0xf0000000
#define PB1_TX_GLB_OVRD_REG3__TX_CFG_DRV2_EN_GEN3_OVRD_VAL__SHIFT 0x1c
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRV2_TAP_SEL_GEN3_OVRD_VAL_MASK 0xf
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRV2_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x0
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRVX_EN_GEN3_OVRD_VAL_MASK 0x10
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRVX_EN_GEN3_OVRD_VAL__SHIFT 0x4
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRVX_TAP_SEL_GEN3_OVRD_VAL_MASK 0x20
#define PB1_TX_GLB_OVRD_REG4__TX_CFG_DRVX_TAP_SEL_GEN3_OVRD_VAL__SHIFT 0x5
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_DISPCLK_MODE_0_MASK 0x1
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_DISPCLK_MODE_0__SHIFT 0x0
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_INV_DATA_0_MASK 0x2
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_INV_DATA_0__SHIFT 0x1
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_SWING_BOOST_EN_0_MASK 0x4
#define PB1_TX_LANE0_CTRL_REG0__TX_CFG_SWING_BOOST_EN_0__SHIFT 0x2
#define PB1_TX_LANE0_CTRL_REG0__TX_DBG_PRBS_EN_0_MASK 0x8
#define PB1_TX_LANE0_CTRL_REG0__TX_DBG_PRBS_EN_0__SHIFT 0x3
#define PB1_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_0_MASK 0x1
#define PB1_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_0__SHIFT 0x0
#define PB1_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_EN_0_MASK 0x2
#define PB1_TX_LANE0_OVRD_REG0__TX_DCLK_EN_OVRD_EN_0__SHIFT 0x1
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_0_MASK 0x4
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_0__SHIFT 0x2
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_0_MASK 0x8
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_0__SHIFT 0x3
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_0_MASK 0x10
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_0__SHIFT 0x4
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_0_MASK 0x20
#define PB1_TX_LANE0_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_0__SHIFT 0x5
#define PB1_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_0_MASK 0x40
#define PB1_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_0__SHIFT 0x6
#define PB1_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_0_MASK 0x80
#define PB1_TX_LANE0_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_0__SHIFT 0x7
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__TXPWR_0_MASK 0x7
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__TXPWR_0__SHIFT 0x0
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__TXMARG_0_MASK 0x70
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__TXMARG_0__SHIFT 0x4
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__DEEMPH_0_MASK 0x80
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__DEEMPH_0__SHIFT 0x7
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENTID_0_MASK 0x300
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENTID_0__SHIFT 0x8
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENT_0_MASK 0xfc00
#define PB1_TX_LANE0_SCI_STAT_OVRD_REG0__COEFFICIENT_0__SHIFT 0xa
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_DISPCLK_MODE_1_MASK 0x1
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_DISPCLK_MODE_1__SHIFT 0x0
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_INV_DATA_1_MASK 0x2
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_INV_DATA_1__SHIFT 0x1
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_SWING_BOOST_EN_1_MASK 0x4
#define PB1_TX_LANE1_CTRL_REG0__TX_CFG_SWING_BOOST_EN_1__SHIFT 0x2
#define PB1_TX_LANE1_CTRL_REG0__TX_DBG_PRBS_EN_1_MASK 0x8
#define PB1_TX_LANE1_CTRL_REG0__TX_DBG_PRBS_EN_1__SHIFT 0x3
#define PB1_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_1_MASK 0x1
#define PB1_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_1__SHIFT 0x0
#define PB1_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_EN_1_MASK 0x2
#define PB1_TX_LANE1_OVRD_REG0__TX_DCLK_EN_OVRD_EN_1__SHIFT 0x1
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_1_MASK 0x4
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_1__SHIFT 0x2
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_1_MASK 0x8
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_1__SHIFT 0x3
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_1_MASK 0x10
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_1__SHIFT 0x4
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_1_MASK 0x20
#define PB1_TX_LANE1_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_1__SHIFT 0x5
#define PB1_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_1_MASK 0x40
#define PB1_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_1__SHIFT 0x6
#define PB1_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_1_MASK 0x80
#define PB1_TX_LANE1_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_1__SHIFT 0x7
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__TXPWR_1_MASK 0x7
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__TXPWR_1__SHIFT 0x0
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__TXMARG_1_MASK 0x70
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__TXMARG_1__SHIFT 0x4
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__DEEMPH_1_MASK 0x80
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__DEEMPH_1__SHIFT 0x7
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENTID_1_MASK 0x300
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENTID_1__SHIFT 0x8
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENT_1_MASK 0xfc00
#define PB1_TX_LANE1_SCI_STAT_OVRD_REG0__COEFFICIENT_1__SHIFT 0xa
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_DISPCLK_MODE_2_MASK 0x1
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_DISPCLK_MODE_2__SHIFT 0x0
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_INV_DATA_2_MASK 0x2
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_INV_DATA_2__SHIFT 0x1
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_SWING_BOOST_EN_2_MASK 0x4
#define PB1_TX_LANE2_CTRL_REG0__TX_CFG_SWING_BOOST_EN_2__SHIFT 0x2
#define PB1_TX_LANE2_CTRL_REG0__TX_DBG_PRBS_EN_2_MASK 0x8
#define PB1_TX_LANE2_CTRL_REG0__TX_DBG_PRBS_EN_2__SHIFT 0x3
#define PB1_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_2_MASK 0x1
#define PB1_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_2__SHIFT 0x0
#define PB1_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_EN_2_MASK 0x2
#define PB1_TX_LANE2_OVRD_REG0__TX_DCLK_EN_OVRD_EN_2__SHIFT 0x1
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_2_MASK 0x4
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_2__SHIFT 0x2
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_2_MASK 0x8
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_2__SHIFT 0x3
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_2_MASK 0x10
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_2__SHIFT 0x4
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_2_MASK 0x20
#define PB1_TX_LANE2_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_2__SHIFT 0x5
#define PB1_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_2_MASK 0x40
#define PB1_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_2__SHIFT 0x6
#define PB1_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_2_MASK 0x80
#define PB1_TX_LANE2_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_2__SHIFT 0x7
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__TXPWR_2_MASK 0x7
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__TXPWR_2__SHIFT 0x0
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__TXMARG_2_MASK 0x70
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__TXMARG_2__SHIFT 0x4
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__DEEMPH_2_MASK 0x80
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__DEEMPH_2__SHIFT 0x7
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENTID_2_MASK 0x300
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENTID_2__SHIFT 0x8
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENT_2_MASK 0xfc00
#define PB1_TX_LANE2_SCI_STAT_OVRD_REG0__COEFFICIENT_2__SHIFT 0xa
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_DISPCLK_MODE_3_MASK 0x1
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_DISPCLK_MODE_3__SHIFT 0x0
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_INV_DATA_3_MASK 0x2
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_INV_DATA_3__SHIFT 0x1
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_SWING_BOOST_EN_3_MASK 0x4
#define PB1_TX_LANE3_CTRL_REG0__TX_CFG_SWING_BOOST_EN_3__SHIFT 0x2
#define PB1_TX_LANE3_CTRL_REG0__TX_DBG_PRBS_EN_3_MASK 0x8
#define PB1_TX_LANE3_CTRL_REG0__TX_DBG_PRBS_EN_3__SHIFT 0x3
#define PB1_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_3_MASK 0x1
#define PB1_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_3__SHIFT 0x0
#define PB1_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_EN_3_MASK 0x2
#define PB1_TX_LANE3_OVRD_REG0__TX_DCLK_EN_OVRD_EN_3__SHIFT 0x1
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_3_MASK 0x4
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_3__SHIFT 0x2
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_3_MASK 0x8
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_3__SHIFT 0x3
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_3_MASK 0x10
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_3__SHIFT 0x4
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_3_MASK 0x20
#define PB1_TX_LANE3_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_3__SHIFT 0x5
#define PB1_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_3_MASK 0x40
#define PB1_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_3__SHIFT 0x6
#define PB1_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_3_MASK 0x80
#define PB1_TX_LANE3_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_3__SHIFT 0x7
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__TXPWR_3_MASK 0x7
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__TXPWR_3__SHIFT 0x0
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__TXMARG_3_MASK 0x70
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__TXMARG_3__SHIFT 0x4
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__DEEMPH_3_MASK 0x80
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__DEEMPH_3__SHIFT 0x7
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENTID_3_MASK 0x300
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENTID_3__SHIFT 0x8
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENT_3_MASK 0xfc00
#define PB1_TX_LANE3_SCI_STAT_OVRD_REG0__COEFFICIENT_3__SHIFT 0xa
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_DISPCLK_MODE_4_MASK 0x1
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_DISPCLK_MODE_4__SHIFT 0x0
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_INV_DATA_4_MASK 0x2
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_INV_DATA_4__SHIFT 0x1
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_SWING_BOOST_EN_4_MASK 0x4
#define PB1_TX_LANE4_CTRL_REG0__TX_CFG_SWING_BOOST_EN_4__SHIFT 0x2
#define PB1_TX_LANE4_CTRL_REG0__TX_DBG_PRBS_EN_4_MASK 0x8
#define PB1_TX_LANE4_CTRL_REG0__TX_DBG_PRBS_EN_4__SHIFT 0x3
#define PB1_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_4_MASK 0x1
#define PB1_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_4__SHIFT 0x0
#define PB1_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_EN_4_MASK 0x2
#define PB1_TX_LANE4_OVRD_REG0__TX_DCLK_EN_OVRD_EN_4__SHIFT 0x1
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_4_MASK 0x4
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_4__SHIFT 0x2
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_4_MASK 0x8
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_4__SHIFT 0x3
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_4_MASK 0x10
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_4__SHIFT 0x4
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_4_MASK 0x20
#define PB1_TX_LANE4_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_4__SHIFT 0x5
#define PB1_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_4_MASK 0x40
#define PB1_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_4__SHIFT 0x6
#define PB1_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_4_MASK 0x80
#define PB1_TX_LANE4_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_4__SHIFT 0x7
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__TXPWR_4_MASK 0x7
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__TXPWR_4__SHIFT 0x0
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__TXMARG_4_MASK 0x70
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__TXMARG_4__SHIFT 0x4
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__DEEMPH_4_MASK 0x80
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__DEEMPH_4__SHIFT 0x7
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENTID_4_MASK 0x300
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENTID_4__SHIFT 0x8
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENT_4_MASK 0xfc00
#define PB1_TX_LANE4_SCI_STAT_OVRD_REG0__COEFFICIENT_4__SHIFT 0xa
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_DISPCLK_MODE_5_MASK 0x1
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_DISPCLK_MODE_5__SHIFT 0x0
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_INV_DATA_5_MASK 0x2
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_INV_DATA_5__SHIFT 0x1
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_SWING_BOOST_EN_5_MASK 0x4
#define PB1_TX_LANE5_CTRL_REG0__TX_CFG_SWING_BOOST_EN_5__SHIFT 0x2
#define PB1_TX_LANE5_CTRL_REG0__TX_DBG_PRBS_EN_5_MASK 0x8
#define PB1_TX_LANE5_CTRL_REG0__TX_DBG_PRBS_EN_5__SHIFT 0x3
#define PB1_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_5_MASK 0x1
#define PB1_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_5__SHIFT 0x0
#define PB1_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_EN_5_MASK 0x2
#define PB1_TX_LANE5_OVRD_REG0__TX_DCLK_EN_OVRD_EN_5__SHIFT 0x1
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_5_MASK 0x4
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_5__SHIFT 0x2
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_5_MASK 0x8
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_5__SHIFT 0x3
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_5_MASK 0x10
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_5__SHIFT 0x4
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_5_MASK 0x20
#define PB1_TX_LANE5_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_5__SHIFT 0x5
#define PB1_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_5_MASK 0x40
#define PB1_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_5__SHIFT 0x6
#define PB1_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_5_MASK 0x80
#define PB1_TX_LANE5_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_5__SHIFT 0x7
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__TXPWR_5_MASK 0x7
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__TXPWR_5__SHIFT 0x0
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__TXMARG_5_MASK 0x70
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__TXMARG_5__SHIFT 0x4
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__DEEMPH_5_MASK 0x80
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__DEEMPH_5__SHIFT 0x7
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENTID_5_MASK 0x300
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENTID_5__SHIFT 0x8
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENT_5_MASK 0xfc00
#define PB1_TX_LANE5_SCI_STAT_OVRD_REG0__COEFFICIENT_5__SHIFT 0xa
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_DISPCLK_MODE_6_MASK 0x1
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_DISPCLK_MODE_6__SHIFT 0x0
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_INV_DATA_6_MASK 0x2
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_INV_DATA_6__SHIFT 0x1
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_SWING_BOOST_EN_6_MASK 0x4
#define PB1_TX_LANE6_CTRL_REG0__TX_CFG_SWING_BOOST_EN_6__SHIFT 0x2
#define PB1_TX_LANE6_CTRL_REG0__TX_DBG_PRBS_EN_6_MASK 0x8
#define PB1_TX_LANE6_CTRL_REG0__TX_DBG_PRBS_EN_6__SHIFT 0x3
#define PB1_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_6_MASK 0x1
#define PB1_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_6__SHIFT 0x0
#define PB1_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_EN_6_MASK 0x2
#define PB1_TX_LANE6_OVRD_REG0__TX_DCLK_EN_OVRD_EN_6__SHIFT 0x1
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_6_MASK 0x4
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_6__SHIFT 0x2
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_6_MASK 0x8
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_6__SHIFT 0x3
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_6_MASK 0x10
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_6__SHIFT 0x4
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_6_MASK 0x20
#define PB1_TX_LANE6_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_6__SHIFT 0x5
#define PB1_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_6_MASK 0x40
#define PB1_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_6__SHIFT 0x6
#define PB1_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_6_MASK 0x80
#define PB1_TX_LANE6_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_6__SHIFT 0x7
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__TXPWR_6_MASK 0x7
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__TXPWR_6__SHIFT 0x0
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__TXMARG_6_MASK 0x70
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__TXMARG_6__SHIFT 0x4
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__DEEMPH_6_MASK 0x80
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__DEEMPH_6__SHIFT 0x7
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENTID_6_MASK 0x300
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENTID_6__SHIFT 0x8
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENT_6_MASK 0xfc00
#define PB1_TX_LANE6_SCI_STAT_OVRD_REG0__COEFFICIENT_6__SHIFT 0xa
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_DISPCLK_MODE_7_MASK 0x1
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_DISPCLK_MODE_7__SHIFT 0x0
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_INV_DATA_7_MASK 0x2
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_INV_DATA_7__SHIFT 0x1
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_SWING_BOOST_EN_7_MASK 0x4
#define PB1_TX_LANE7_CTRL_REG0__TX_CFG_SWING_BOOST_EN_7__SHIFT 0x2
#define PB1_TX_LANE7_CTRL_REG0__TX_DBG_PRBS_EN_7_MASK 0x8
#define PB1_TX_LANE7_CTRL_REG0__TX_DBG_PRBS_EN_7__SHIFT 0x3
#define PB1_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_7_MASK 0x1
#define PB1_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_7__SHIFT 0x0
#define PB1_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_EN_7_MASK 0x2
#define PB1_TX_LANE7_OVRD_REG0__TX_DCLK_EN_OVRD_EN_7__SHIFT 0x1
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_7_MASK 0x4
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_7__SHIFT 0x2
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_7_MASK 0x8
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_7__SHIFT 0x3
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_7_MASK 0x10
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_7__SHIFT 0x4
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_7_MASK 0x20
#define PB1_TX_LANE7_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_7__SHIFT 0x5
#define PB1_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_7_MASK 0x40
#define PB1_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_7__SHIFT 0x6
#define PB1_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_7_MASK 0x80
#define PB1_TX_LANE7_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_7__SHIFT 0x7
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__TXPWR_7_MASK 0x7
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__TXPWR_7__SHIFT 0x0
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__TXMARG_7_MASK 0x70
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__TXMARG_7__SHIFT 0x4
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__DEEMPH_7_MASK 0x80
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__DEEMPH_7__SHIFT 0x7
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENTID_7_MASK 0x300
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENTID_7__SHIFT 0x8
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENT_7_MASK 0xfc00
#define PB1_TX_LANE7_SCI_STAT_OVRD_REG0__COEFFICIENT_7__SHIFT 0xa
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_DISPCLK_MODE_8_MASK 0x1
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_DISPCLK_MODE_8__SHIFT 0x0
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_INV_DATA_8_MASK 0x2
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_INV_DATA_8__SHIFT 0x1
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_SWING_BOOST_EN_8_MASK 0x4
#define PB1_TX_LANE8_CTRL_REG0__TX_CFG_SWING_BOOST_EN_8__SHIFT 0x2
#define PB1_TX_LANE8_CTRL_REG0__TX_DBG_PRBS_EN_8_MASK 0x8
#define PB1_TX_LANE8_CTRL_REG0__TX_DBG_PRBS_EN_8__SHIFT 0x3
#define PB1_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_8_MASK 0x1
#define PB1_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_8__SHIFT 0x0
#define PB1_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_EN_8_MASK 0x2
#define PB1_TX_LANE8_OVRD_REG0__TX_DCLK_EN_OVRD_EN_8__SHIFT 0x1
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_8_MASK 0x4
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_8__SHIFT 0x2
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_8_MASK 0x8
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_8__SHIFT 0x3
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_8_MASK 0x10
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_8__SHIFT 0x4
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_8_MASK 0x20
#define PB1_TX_LANE8_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_8__SHIFT 0x5
#define PB1_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_8_MASK 0x40
#define PB1_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_8__SHIFT 0x6
#define PB1_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_8_MASK 0x80
#define PB1_TX_LANE8_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_8__SHIFT 0x7
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__TXPWR_8_MASK 0x7
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__TXPWR_8__SHIFT 0x0
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__TXMARG_8_MASK 0x70
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__TXMARG_8__SHIFT 0x4
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__DEEMPH_8_MASK 0x80
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__DEEMPH_8__SHIFT 0x7
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENTID_8_MASK 0x300
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENTID_8__SHIFT 0x8
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENT_8_MASK 0xfc00
#define PB1_TX_LANE8_SCI_STAT_OVRD_REG0__COEFFICIENT_8__SHIFT 0xa
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_DISPCLK_MODE_9_MASK 0x1
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_DISPCLK_MODE_9__SHIFT 0x0
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_INV_DATA_9_MASK 0x2
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_INV_DATA_9__SHIFT 0x1
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_SWING_BOOST_EN_9_MASK 0x4
#define PB1_TX_LANE9_CTRL_REG0__TX_CFG_SWING_BOOST_EN_9__SHIFT 0x2
#define PB1_TX_LANE9_CTRL_REG0__TX_DBG_PRBS_EN_9_MASK 0x8
#define PB1_TX_LANE9_CTRL_REG0__TX_DBG_PRBS_EN_9__SHIFT 0x3
#define PB1_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_9_MASK 0x1
#define PB1_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_9__SHIFT 0x0
#define PB1_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_EN_9_MASK 0x2
#define PB1_TX_LANE9_OVRD_REG0__TX_DCLK_EN_OVRD_EN_9__SHIFT 0x1
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_9_MASK 0x4
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_9__SHIFT 0x2
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_9_MASK 0x8
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_9__SHIFT 0x3
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_9_MASK 0x10
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_9__SHIFT 0x4
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_9_MASK 0x20
#define PB1_TX_LANE9_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_9__SHIFT 0x5
#define PB1_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_9_MASK 0x40
#define PB1_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_9__SHIFT 0x6
#define PB1_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_9_MASK 0x80
#define PB1_TX_LANE9_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_9__SHIFT 0x7
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__TXPWR_9_MASK 0x7
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__TXPWR_9__SHIFT 0x0
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__TXMARG_9_MASK 0x70
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__TXMARG_9__SHIFT 0x4
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__DEEMPH_9_MASK 0x80
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__DEEMPH_9__SHIFT 0x7
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENTID_9_MASK 0x300
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENTID_9__SHIFT 0x8
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENT_9_MASK 0xfc00
#define PB1_TX_LANE9_SCI_STAT_OVRD_REG0__COEFFICIENT_9__SHIFT 0xa
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_DISPCLK_MODE_10_MASK 0x1
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_DISPCLK_MODE_10__SHIFT 0x0
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_INV_DATA_10_MASK 0x2
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_INV_DATA_10__SHIFT 0x1
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_SWING_BOOST_EN_10_MASK 0x4
#define PB1_TX_LANE10_CTRL_REG0__TX_CFG_SWING_BOOST_EN_10__SHIFT 0x2
#define PB1_TX_LANE10_CTRL_REG0__TX_DBG_PRBS_EN_10_MASK 0x8
#define PB1_TX_LANE10_CTRL_REG0__TX_DBG_PRBS_EN_10__SHIFT 0x3
#define PB1_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_10_MASK 0x1
#define PB1_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_10__SHIFT 0x0
#define PB1_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_EN_10_MASK 0x2
#define PB1_TX_LANE10_OVRD_REG0__TX_DCLK_EN_OVRD_EN_10__SHIFT 0x1
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_10_MASK 0x4
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_10__SHIFT 0x2
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_10_MASK 0x8
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_10__SHIFT 0x3
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_10_MASK 0x10
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_10__SHIFT 0x4
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_10_MASK 0x20
#define PB1_TX_LANE10_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_10__SHIFT 0x5
#define PB1_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_10_MASK 0x40
#define PB1_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_10__SHIFT 0x6
#define PB1_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_10_MASK 0x80
#define PB1_TX_LANE10_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_10__SHIFT 0x7
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__TXPWR_10_MASK 0x7
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__TXPWR_10__SHIFT 0x0
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__TXMARG_10_MASK 0x70
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__TXMARG_10__SHIFT 0x4
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__DEEMPH_10_MASK 0x80
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__DEEMPH_10__SHIFT 0x7
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENTID_10_MASK 0x300
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENTID_10__SHIFT 0x8
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENT_10_MASK 0xfc00
#define PB1_TX_LANE10_SCI_STAT_OVRD_REG0__COEFFICIENT_10__SHIFT 0xa
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_DISPCLK_MODE_11_MASK 0x1
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_DISPCLK_MODE_11__SHIFT 0x0
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_INV_DATA_11_MASK 0x2
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_INV_DATA_11__SHIFT 0x1
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_SWING_BOOST_EN_11_MASK 0x4
#define PB1_TX_LANE11_CTRL_REG0__TX_CFG_SWING_BOOST_EN_11__SHIFT 0x2
#define PB1_TX_LANE11_CTRL_REG0__TX_DBG_PRBS_EN_11_MASK 0x8
#define PB1_TX_LANE11_CTRL_REG0__TX_DBG_PRBS_EN_11__SHIFT 0x3
#define PB1_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_11_MASK 0x1
#define PB1_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_11__SHIFT 0x0
#define PB1_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_EN_11_MASK 0x2
#define PB1_TX_LANE11_OVRD_REG0__TX_DCLK_EN_OVRD_EN_11__SHIFT 0x1
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_11_MASK 0x4
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_11__SHIFT 0x2
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_11_MASK 0x8
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_11__SHIFT 0x3
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_11_MASK 0x10
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_11__SHIFT 0x4
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_11_MASK 0x20
#define PB1_TX_LANE11_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_11__SHIFT 0x5
#define PB1_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_11_MASK 0x40
#define PB1_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_11__SHIFT 0x6
#define PB1_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_11_MASK 0x80
#define PB1_TX_LANE11_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_11__SHIFT 0x7
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__TXPWR_11_MASK 0x7
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__TXPWR_11__SHIFT 0x0
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__TXMARG_11_MASK 0x70
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__TXMARG_11__SHIFT 0x4
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__DEEMPH_11_MASK 0x80
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__DEEMPH_11__SHIFT 0x7
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENTID_11_MASK 0x300
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENTID_11__SHIFT 0x8
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENT_11_MASK 0xfc00
#define PB1_TX_LANE11_SCI_STAT_OVRD_REG0__COEFFICIENT_11__SHIFT 0xa
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_DISPCLK_MODE_12_MASK 0x1
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_DISPCLK_MODE_12__SHIFT 0x0
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_INV_DATA_12_MASK 0x2
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_INV_DATA_12__SHIFT 0x1
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_SWING_BOOST_EN_12_MASK 0x4
#define PB1_TX_LANE12_CTRL_REG0__TX_CFG_SWING_BOOST_EN_12__SHIFT 0x2
#define PB1_TX_LANE12_CTRL_REG0__TX_DBG_PRBS_EN_12_MASK 0x8
#define PB1_TX_LANE12_CTRL_REG0__TX_DBG_PRBS_EN_12__SHIFT 0x3
#define PB1_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_12_MASK 0x1
#define PB1_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_12__SHIFT 0x0
#define PB1_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_EN_12_MASK 0x2
#define PB1_TX_LANE12_OVRD_REG0__TX_DCLK_EN_OVRD_EN_12__SHIFT 0x1
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_12_MASK 0x4
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_12__SHIFT 0x2
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_12_MASK 0x8
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_12__SHIFT 0x3
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_12_MASK 0x10
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_12__SHIFT 0x4
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_12_MASK 0x20
#define PB1_TX_LANE12_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_12__SHIFT 0x5
#define PB1_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_12_MASK 0x40
#define PB1_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_12__SHIFT 0x6
#define PB1_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_12_MASK 0x80
#define PB1_TX_LANE12_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_12__SHIFT 0x7
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__TXPWR_12_MASK 0x7
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__TXPWR_12__SHIFT 0x0
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__TXMARG_12_MASK 0x70
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__TXMARG_12__SHIFT 0x4
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__DEEMPH_12_MASK 0x80
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__DEEMPH_12__SHIFT 0x7
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENTID_12_MASK 0x300
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENTID_12__SHIFT 0x8
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENT_12_MASK 0xfc00
#define PB1_TX_LANE12_SCI_STAT_OVRD_REG0__COEFFICIENT_12__SHIFT 0xa
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_DISPCLK_MODE_13_MASK 0x1
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_DISPCLK_MODE_13__SHIFT 0x0
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_INV_DATA_13_MASK 0x2
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_INV_DATA_13__SHIFT 0x1
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_SWING_BOOST_EN_13_MASK 0x4
#define PB1_TX_LANE13_CTRL_REG0__TX_CFG_SWING_BOOST_EN_13__SHIFT 0x2
#define PB1_TX_LANE13_CTRL_REG0__TX_DBG_PRBS_EN_13_MASK 0x8
#define PB1_TX_LANE13_CTRL_REG0__TX_DBG_PRBS_EN_13__SHIFT 0x3
#define PB1_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_13_MASK 0x1
#define PB1_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_13__SHIFT 0x0
#define PB1_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_EN_13_MASK 0x2
#define PB1_TX_LANE13_OVRD_REG0__TX_DCLK_EN_OVRD_EN_13__SHIFT 0x1
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_13_MASK 0x4
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_13__SHIFT 0x2
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_13_MASK 0x8
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_13__SHIFT 0x3
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_13_MASK 0x10
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_13__SHIFT 0x4
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_13_MASK 0x20
#define PB1_TX_LANE13_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_13__SHIFT 0x5
#define PB1_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_13_MASK 0x40
#define PB1_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_13__SHIFT 0x6
#define PB1_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_13_MASK 0x80
#define PB1_TX_LANE13_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_13__SHIFT 0x7
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__TXPWR_13_MASK 0x7
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__TXPWR_13__SHIFT 0x0
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__TXMARG_13_MASK 0x70
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__TXMARG_13__SHIFT 0x4
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__DEEMPH_13_MASK 0x80
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__DEEMPH_13__SHIFT 0x7
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENTID_13_MASK 0x300
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENTID_13__SHIFT 0x8
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENT_13_MASK 0xfc00
#define PB1_TX_LANE13_SCI_STAT_OVRD_REG0__COEFFICIENT_13__SHIFT 0xa
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_DISPCLK_MODE_14_MASK 0x1
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_DISPCLK_MODE_14__SHIFT 0x0
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_INV_DATA_14_MASK 0x2
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_INV_DATA_14__SHIFT 0x1
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_SWING_BOOST_EN_14_MASK 0x4
#define PB1_TX_LANE14_CTRL_REG0__TX_CFG_SWING_BOOST_EN_14__SHIFT 0x2
#define PB1_TX_LANE14_CTRL_REG0__TX_DBG_PRBS_EN_14_MASK 0x8
#define PB1_TX_LANE14_CTRL_REG0__TX_DBG_PRBS_EN_14__SHIFT 0x3
#define PB1_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_14_MASK 0x1
#define PB1_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_14__SHIFT 0x0
#define PB1_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_EN_14_MASK 0x2
#define PB1_TX_LANE14_OVRD_REG0__TX_DCLK_EN_OVRD_EN_14__SHIFT 0x1
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_14_MASK 0x4
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_14__SHIFT 0x2
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_14_MASK 0x8
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_14__SHIFT 0x3
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_14_MASK 0x10
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_14__SHIFT 0x4
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_14_MASK 0x20
#define PB1_TX_LANE14_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_14__SHIFT 0x5
#define PB1_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_14_MASK 0x40
#define PB1_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_14__SHIFT 0x6
#define PB1_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_14_MASK 0x80
#define PB1_TX_LANE14_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_14__SHIFT 0x7
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__TXPWR_14_MASK 0x7
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__TXPWR_14__SHIFT 0x0
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__TXMARG_14_MASK 0x70
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__TXMARG_14__SHIFT 0x4
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__DEEMPH_14_MASK 0x80
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__DEEMPH_14__SHIFT 0x7
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENTID_14_MASK 0x300
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENTID_14__SHIFT 0x8
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENT_14_MASK 0xfc00
#define PB1_TX_LANE14_SCI_STAT_OVRD_REG0__COEFFICIENT_14__SHIFT 0xa
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_DISPCLK_MODE_15_MASK 0x1
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_DISPCLK_MODE_15__SHIFT 0x0
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_INV_DATA_15_MASK 0x2
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_INV_DATA_15__SHIFT 0x1
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_SWING_BOOST_EN_15_MASK 0x4
#define PB1_TX_LANE15_CTRL_REG0__TX_CFG_SWING_BOOST_EN_15__SHIFT 0x2
#define PB1_TX_LANE15_CTRL_REG0__TX_DBG_PRBS_EN_15_MASK 0x8
#define PB1_TX_LANE15_CTRL_REG0__TX_DBG_PRBS_EN_15__SHIFT 0x3
#define PB1_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_15_MASK 0x1
#define PB1_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_VAL_15__SHIFT 0x0
#define PB1_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_EN_15_MASK 0x2
#define PB1_TX_LANE15_OVRD_REG0__TX_DCLK_EN_OVRD_EN_15__SHIFT 0x1
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_15_MASK 0x4
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_VAL_15__SHIFT 0x2
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_15_MASK 0x8
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_DATA_EN_OVRD_EN_15__SHIFT 0x3
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_15_MASK 0x10
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_VAL_15__SHIFT 0x4
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_15_MASK 0x20
#define PB1_TX_LANE15_OVRD_REG0__TX_DRV_PWRON_OVRD_EN_15__SHIFT 0x5
#define PB1_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_15_MASK 0x40
#define PB1_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_VAL_15__SHIFT 0x6
#define PB1_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_15_MASK 0x80
#define PB1_TX_LANE15_OVRD_REG0__TX_FRONTEND_PWRON_OVRD_EN_15__SHIFT 0x7
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__TXPWR_15_MASK 0x7
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__TXPWR_15__SHIFT 0x0
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__TXMARG_15_MASK 0x70
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__TXMARG_15__SHIFT 0x4
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__DEEMPH_15_MASK 0x80
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__DEEMPH_15__SHIFT 0x7
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENTID_15_MASK 0x300
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENTID_15__SHIFT 0x8
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENT_15_MASK 0xfc00
#define PB1_TX_LANE15_SCI_STAT_OVRD_REG0__COEFFICIENT_15__SHIFT 0xa
#define PB0_PIF_SCRATCH__PIF_SCRATCH_MASK 0xffffffff
#define PB0_PIF_SCRATCH__PIF_SCRATCH__SHIFT 0x0
#define PB0_PIF_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PB0_PIF_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PB0_PIF_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PB0_PIF_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PB0_PIF_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PB0_PIF_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PB0_PIF_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PB0_PIF_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PB0_PIF_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PB0_PIF_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PB0_PIF_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PB0_PIF_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PB0_PIF_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PB0_PIF_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PB0_PIF_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PB0_PIF_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PB0_PIF_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PB0_PIF_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PB0_PIF_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PB0_PIF_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PB0_PIF_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PB0_PIF_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PB0_PIF_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PB0_PIF_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PB0_PIF_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PB0_PIF_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PB0_PIF_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PB0_PIF_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PB0_PIF_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PB0_PIF_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PB0_PIF_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PB0_PIF_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PB0_PIF_STRAP_0__STRAP_TX_RDY_XTND_DIS_MASK 0x2
#define PB0_PIF_STRAP_0__STRAP_TX_RDY_XTND_DIS__SHIFT 0x1
#define PB0_PIF_STRAP_0__STRAP_RX_RDY_XTND_DIS_MASK 0x4
#define PB0_PIF_STRAP_0__STRAP_RX_RDY_XTND_DIS__SHIFT 0x2
#define PB0_PIF_STRAP_0__STRAP_TX_STATUS_XTND_DIS_MASK 0x8
#define PB0_PIF_STRAP_0__STRAP_TX_STATUS_XTND_DIS__SHIFT 0x3
#define PB0_PIF_STRAP_0__STRAP_RX_STATUS_XTND_DIS_MASK 0x10
#define PB0_PIF_STRAP_0__STRAP_RX_STATUS_XTND_DIS__SHIFT 0x4
#define PB0_PIF_STRAP_0__STRAP_FORCE_OWN_MSTR_MASK 0x20
#define PB0_PIF_STRAP_0__STRAP_FORCE_OWN_MSTR__SHIFT 0x5
#define PB0_PIF_STRAP_0__STRAP_PIF_CDR_EN_MODE_MASK 0xc0
#define PB0_PIF_STRAP_0__STRAP_PIF_CDR_EN_MODE__SHIFT 0x6
#define PB0_PIF_STRAP_0__STRAP_RX_EI_FILTER_MASK 0x300
#define PB0_PIF_STRAP_0__STRAP_RX_EI_FILTER__SHIFT 0x8
#define PB0_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS1_MASK 0x400
#define PB0_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS1__SHIFT 0xa
#define PB0_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS2_MASK 0x800
#define PB0_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS2__SHIFT 0xb
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_12_MASK 0x1000
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_12__SHIFT 0xc
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_13_MASK 0x2000
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_13__SHIFT 0xd
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_14_MASK 0x4000
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_14__SHIFT 0xe
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_15_MASK 0x8000
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_15__SHIFT 0xf
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_16_MASK 0x10000
#define PB0_PIF_STRAP_0__STRAP_PIF_BIT_16__SHIFT 0x10
#define PB0_PIF_CTRL__PIF_PLL_PWRDN_EN_MASK 0x1
#define PB0_PIF_CTRL__PIF_PLL_PWRDN_EN__SHIFT 0x0
#define PB0_PIF_CTRL__DTM_FORCE_FREQDIV_X1_MASK 0x2
#define PB0_PIF_CTRL__DTM_FORCE_FREQDIV_X1__SHIFT 0x1
#define PB0_PIF_CTRL__PIF_PLL_HNDSHK_EARLY_ABORT_MASK 0x4
#define PB0_PIF_CTRL__PIF_PLL_HNDSHK_EARLY_ABORT__SHIFT 0x2
#define PB0_PIF_CTRL__PIF_PLL_PWRDN_EARLY_EXIT_MASK 0x8
#define PB0_PIF_CTRL__PIF_PLL_PWRDN_EARLY_EXIT__SHIFT 0x3
#define PB0_PIF_CTRL__PHY_RST_PWROK_VDD_MASK 0x10
#define PB0_PIF_CTRL__PHY_RST_PWROK_VDD__SHIFT 0x4
#define PB0_PIF_CTRL__PIF_PLL_STATUS_MASK 0xc0
#define PB0_PIF_CTRL__PIF_PLL_STATUS__SHIFT 0x6
#define PB0_PIF_CTRL__PIF_PLL_DEGRADE_OFF_VOTE_MASK 0x100
#define PB0_PIF_CTRL__PIF_PLL_DEGRADE_OFF_VOTE__SHIFT 0x8
#define PB0_PIF_CTRL__PIF_PLL_UNUSED_OFF_VOTE_MASK 0x200
#define PB0_PIF_CTRL__PIF_PLL_UNUSED_OFF_VOTE__SHIFT 0x9
#define PB0_PIF_CTRL__PIF_PLL_DEGRADE_S2_VOTE_MASK 0x400
#define PB0_PIF_CTRL__PIF_PLL_DEGRADE_S2_VOTE__SHIFT 0xa
#define PB0_PIF_CTRL__PIF_PG_EXIT_MODE_MASK 0x800
#define PB0_PIF_CTRL__PIF_PG_EXIT_MODE__SHIFT 0xb
#define PB0_PIF_CTRL__PIF_DEGRADE_PWR_PLL_MODE_MASK 0x1000
#define PB0_PIF_CTRL__PIF_DEGRADE_PWR_PLL_MODE__SHIFT 0xc
#define PB0_PIF_CTRL__PIF_LANEUNUSED_AFFECT_GANG_MASK 0x2000
#define PB0_PIF_CTRL__PIF_LANEUNUSED_AFFECT_GANG__SHIFT 0xd
#define PB0_PIF_CTRL__PIF_PG_ABORT_DISABLE_MASK 0x4000
#define PB0_PIF_CTRL__PIF_PG_ABORT_DISABLE__SHIFT 0xe
#define PB0_PIF_TX_CTRL__TXPWR_IN_S2_MASK 0x7
#define PB0_PIF_TX_CTRL__TXPWR_IN_S2__SHIFT 0x0
#define PB0_PIF_TX_CTRL__TXPWR_IN_SPDCHNG_MASK 0x38
#define PB0_PIF_TX_CTRL__TXPWR_IN_SPDCHNG__SHIFT 0x3
#define PB0_PIF_TX_CTRL__TXPWR_IN_OFF_MASK 0x1c0
#define PB0_PIF_TX_CTRL__TXPWR_IN_OFF__SHIFT 0x6
#define PB0_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MASK 0xe00
#define PB0_PIF_TX_CTRL__TXPWR_IN_DEGRADE__SHIFT 0x9
#define PB0_PIF_TX_CTRL__TXPWR_IN_UNUSED_MASK 0x7000
#define PB0_PIF_TX_CTRL__TXPWR_IN_UNUSED__SHIFT 0xc
#define PB0_PIF_TX_CTRL__TXPWR_IN_INIT_MASK 0x38000
#define PB0_PIF_TX_CTRL__TXPWR_IN_INIT__SHIFT 0xf
#define PB0_PIF_TX_CTRL__TXPWR_IN_PLL_OFF_MASK 0x1c0000
#define PB0_PIF_TX_CTRL__TXPWR_IN_PLL_OFF__SHIFT 0x12
#define PB0_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MODE_MASK 0x200000
#define PB0_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MODE__SHIFT 0x15
#define PB0_PIF_TX_CTRL__TXPWR_IN_UNUSED_MODE_MASK 0x400000
#define PB0_PIF_TX_CTRL__TXPWR_IN_UNUSED_MODE__SHIFT 0x16
#define PB0_PIF_TX_CTRL__TXPWR_GATING_IN_L1_MASK 0x800000
#define PB0_PIF_TX_CTRL__TXPWR_GATING_IN_L1__SHIFT 0x17
#define PB0_PIF_TX_CTRL__TXPWR_GATING_IN_UNUSED_MASK 0x1000000
#define PB0_PIF_TX_CTRL__TXPWR_GATING_IN_UNUSED__SHIFT 0x18
#define PB0_PIF_TX_CTRL2__TX_RDY_DASRT_COUNT_MASK 0x7
#define PB0_PIF_TX_CTRL2__TX_RDY_DASRT_COUNT__SHIFT 0x0
#define PB0_PIF_TX_CTRL2__TX_STATUS_DASRT_COUNT_MASK 0x38
#define PB0_PIF_TX_CTRL2__TX_STATUS_DASRT_COUNT__SHIFT 0x3
#define PB0_PIF_TX_CTRL2__TXPHYSTATUS_DELAY_MASK 0x1c0
#define PB0_PIF_TX_CTRL2__TXPHYSTATUS_DELAY__SHIFT 0x6
#define PB0_PIF_TX_CTRL2__TX_L1_PG_PHY_STATUS_MODE_MASK 0x200
#define PB0_PIF_TX_CTRL2__TX_L1_PG_PHY_STATUS_MODE__SHIFT 0x9
#define PB0_PIF_TX_CTRL2__TX_OFF_PG_PHY_STATUS_MODE_MASK 0x400
#define PB0_PIF_TX_CTRL2__TX_OFF_PG_PHY_STATUS_MODE__SHIFT 0xa
#define PB0_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MP_MASK 0x10000
#define PB0_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MP__SHIFT 0x10
#define PB0_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MODE_MASK 0x60000
#define PB0_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MODE__SHIFT 0x11
#define PB0_PIF_TX_CTRL2__TX_FORCE_DATA_VALID_MASK 0x200000
#define PB0_PIF_TX_CTRL2__TX_FORCE_DATA_VALID__SHIFT 0x15
#define PB0_PIF_TX_CTRL2__TX_L0_TO_HIZ_DLY_MASK 0x1c00000
#define PB0_PIF_TX_CTRL2__TX_L0_TO_HIZ_DLY__SHIFT 0x16
#define PB0_PIF_TX_CTRL2__TX_FIFO_INIT_UPCONFIG_MASK 0x2000000
#define PB0_PIF_TX_CTRL2__TX_FIFO_INIT_UPCONFIG__SHIFT 0x19
#define PB0_PIF_TX_CTRL2__TX_HIZ_TO_L0_DLY_MASK 0x1c000000
#define PB0_PIF_TX_CTRL2__TX_HIZ_TO_L0_DLY__SHIFT 0x1a
#define PB0_PIF_TX_CTRL2__TX_LINKSPEED_ACK_IN_S2_MASK 0x20000000
#define PB0_PIF_TX_CTRL2__TX_LINKSPEED_ACK_IN_S2__SHIFT 0x1d
#define PB0_PIF_TX_CTRL2__TX_DELAY_FIFO_INIT_IN_S1_MASK 0x40000000
#define PB0_PIF_TX_CTRL2__TX_DELAY_FIFO_INIT_IN_S1__SHIFT 0x1e
#define PB0_PIF_RX_CTRL__RXPWR_IN_S2_MASK 0x7
#define PB0_PIF_RX_CTRL__RXPWR_IN_S2__SHIFT 0x0
#define PB0_PIF_RX_CTRL__RXPWR_IN_SPDCHNG_MASK 0x38
#define PB0_PIF_RX_CTRL__RXPWR_IN_SPDCHNG__SHIFT 0x3
#define PB0_PIF_RX_CTRL__RXPWR_IN_OFF_MASK 0x1c0
#define PB0_PIF_RX_CTRL__RXPWR_IN_OFF__SHIFT 0x6
#define PB0_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MASK 0xe00
#define PB0_PIF_RX_CTRL__RXPWR_IN_DEGRADE__SHIFT 0x9
#define PB0_PIF_RX_CTRL__RXPWR_IN_UNUSED_MASK 0x7000
#define PB0_PIF_RX_CTRL__RXPWR_IN_UNUSED__SHIFT 0xc
#define PB0_PIF_RX_CTRL__RXPWR_IN_INIT_MASK 0x38000
#define PB0_PIF_RX_CTRL__RXPWR_IN_INIT__SHIFT 0xf
#define PB0_PIF_RX_CTRL__RXPWR_IN_PLL_OFF_MASK 0x1c0000
#define PB0_PIF_RX_CTRL__RXPWR_IN_PLL_OFF__SHIFT 0x12
#define PB0_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MODE_MASK 0x200000
#define PB0_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MODE__SHIFT 0x15
#define PB0_PIF_RX_CTRL__RXPWR_IN_UNUSED_MODE_MASK 0x400000
#define PB0_PIF_RX_CTRL__RXPWR_IN_UNUSED_MODE__SHIFT 0x16
#define PB0_PIF_RX_CTRL__RXPWR_GATING_IN_L1_MASK 0x800000
#define PB0_PIF_RX_CTRL__RXPWR_GATING_IN_L1__SHIFT 0x17
#define PB0_PIF_RX_CTRL__RXPWR_GATING_IN_UNUSED_MASK 0x1000000
#define PB0_PIF_RX_CTRL__RXPWR_GATING_IN_UNUSED__SHIFT 0x18
#define PB0_PIF_RX_CTRL__RX_HLD_EIE_COUNT_MASK 0x2000000
#define PB0_PIF_RX_CTRL__RX_HLD_EIE_COUNT__SHIFT 0x19
#define PB0_PIF_RX_CTRL__RX_EI_DET_IN_PS2_DEGRADE_MASK 0x4000000
#define PB0_PIF_RX_CTRL__RX_EI_DET_IN_PS2_DEGRADE__SHIFT 0x1a
#define PB0_PIF_RX_CTRL2__RX_RDY_DASRT_COUNT_MASK 0x7
#define PB0_PIF_RX_CTRL2__RX_RDY_DASRT_COUNT__SHIFT 0x0
#define PB0_PIF_RX_CTRL2__RX_STATUS_DASRT_COUNT_MASK 0x38
#define PB0_PIF_RX_CTRL2__RX_STATUS_DASRT_COUNT__SHIFT 0x3
#define PB0_PIF_RX_CTRL2__RXPHYSTATUS_DELAY_MASK 0x1c0
#define PB0_PIF_RX_CTRL2__RXPHYSTATUS_DELAY__SHIFT 0x6
#define PB0_PIF_RX_CTRL2__RX_L1_PG_PHY_STATUS_MODE_MASK 0x200
#define PB0_PIF_RX_CTRL2__RX_L1_PG_PHY_STATUS_MODE__SHIFT 0x9
#define PB0_PIF_RX_CTRL2__RX_OFF_PG_PHY_STATUS_MODE_MASK 0x400
#define PB0_PIF_RX_CTRL2__RX_OFF_PG_PHY_STATUS_MODE__SHIFT 0xa
#define PB0_PIF_RX_CTRL2__FORCE_CDREN_IN_L0S_MASK 0x10000
#define PB0_PIF_RX_CTRL2__FORCE_CDREN_IN_L0S__SHIFT 0x10
#define PB0_PIF_RX_CTRL2__EI_DET_CYCLE_MODE_MASK 0x60000
#define PB0_PIF_RX_CTRL2__EI_DET_CYCLE_MODE__SHIFT 0x11
#define PB0_PIF_RX_CTRL2__EI_DET_ON_TIME_MASK 0x180000
#define PB0_PIF_RX_CTRL2__EI_DET_ON_TIME__SHIFT 0x13
#define PB0_PIF_RX_CTRL2__EI_DET_OFF_TIME_MASK 0xe00000
#define PB0_PIF_RX_CTRL2__EI_DET_OFF_TIME__SHIFT 0x15
#define PB0_PIF_RX_CTRL2__EI_DET_CYCLE_DIS_IN_PS1_MASK 0x1000000
#define PB0_PIF_RX_CTRL2__EI_DET_CYCLE_DIS_IN_PS1__SHIFT 0x18
#define PB0_PIF_RX_CTRL2__RX_CDR_XTND_MODE_MASK 0x6000000
#define PB0_PIF_RX_CTRL2__RX_CDR_XTND_MODE__SHIFT 0x19
#define PB0_PIF_RX_CTRL2__RX_L0S_TO_L0_DETECT_EI_MASK 0x8000000
#define PB0_PIF_RX_CTRL2__RX_L0S_TO_L0_DETECT_EI__SHIFT 0x1b
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_0_MASK 0x1
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_0__SHIFT 0x0
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_1_MASK 0x2
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_1__SHIFT 0x1
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_2_MASK 0x4
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_2__SHIFT 0x2
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_3_MASK 0x8
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_3__SHIFT 0x3
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_4_MASK 0x10
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_4__SHIFT 0x4
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_5_MASK 0x20
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_5__SHIFT 0x5
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_6_MASK 0x40
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_6__SHIFT 0x6
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_7_MASK 0x80
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_7__SHIFT 0x7
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_EN_MASK 0x10000
#define PB0_PIF_GLB_OVRD__RXDETECT_OVERRIDE_EN__SHIFT 0x10
#define PB0_PIF_GLB_OVRD2__X2_LANE_1_0_OVRD_MASK 0x1
#define PB0_PIF_GLB_OVRD2__X2_LANE_1_0_OVRD__SHIFT 0x0
#define PB0_PIF_GLB_OVRD2__X2_LANE_3_2_OVRD_MASK 0x2
#define PB0_PIF_GLB_OVRD2__X2_LANE_3_2_OVRD__SHIFT 0x1
#define PB0_PIF_GLB_OVRD2__X2_LANE_5_4_OVRD_MASK 0x4
#define PB0_PIF_GLB_OVRD2__X2_LANE_5_4_OVRD__SHIFT 0x2
#define PB0_PIF_GLB_OVRD2__X2_LANE_7_6_OVRD_MASK 0x8
#define PB0_PIF_GLB_OVRD2__X2_LANE_7_6_OVRD__SHIFT 0x3
#define PB0_PIF_GLB_OVRD2__X2_LANE_9_8_OVRD_MASK 0x10
#define PB0_PIF_GLB_OVRD2__X2_LANE_9_8_OVRD__SHIFT 0x4
#define PB0_PIF_GLB_OVRD2__X2_LANE_11_10_OVRD_MASK 0x20
#define PB0_PIF_GLB_OVRD2__X2_LANE_11_10_OVRD__SHIFT 0x5
#define PB0_PIF_GLB_OVRD2__X2_LANE_13_12_OVRD_MASK 0x40
#define PB0_PIF_GLB_OVRD2__X2_LANE_13_12_OVRD__SHIFT 0x6
#define PB0_PIF_GLB_OVRD2__X2_LANE_15_14_OVRD_MASK 0x80
#define PB0_PIF_GLB_OVRD2__X2_LANE_15_14_OVRD__SHIFT 0x7
#define PB0_PIF_GLB_OVRD2__X4_LANE_3_0_OVRD_MASK 0x100
#define PB0_PIF_GLB_OVRD2__X4_LANE_3_0_OVRD__SHIFT 0x8
#define PB0_PIF_GLB_OVRD2__X4_LANE_7_4_OVRD_MASK 0x200
#define PB0_PIF_GLB_OVRD2__X4_LANE_7_4_OVRD__SHIFT 0x9
#define PB0_PIF_GLB_OVRD2__X4_LANE_11_8_OVRD_MASK 0x400
#define PB0_PIF_GLB_OVRD2__X4_LANE_11_8_OVRD__SHIFT 0xa
#define PB0_PIF_GLB_OVRD2__X4_LANE_15_12_OVRD_MASK 0x800
#define PB0_PIF_GLB_OVRD2__X4_LANE_15_12_OVRD__SHIFT 0xb
#define PB0_PIF_GLB_OVRD2__X8_LANE_7_0_OVRD_MASK 0x10000
#define PB0_PIF_GLB_OVRD2__X8_LANE_7_0_OVRD__SHIFT 0x10
#define PB0_PIF_GLB_OVRD2__X8_LANE_15_8_OVRD_MASK 0x20000
#define PB0_PIF_GLB_OVRD2__X8_LANE_15_8_OVRD__SHIFT 0x11
#define PB0_PIF_GLB_OVRD2__X16_LANE_15_0_OVRD_MASK 0x100000
#define PB0_PIF_GLB_OVRD2__X16_LANE_15_0_OVRD__SHIFT 0x14
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_0_MASK 0x1
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_0__SHIFT 0x0
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_1_MASK 0x2
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_1__SHIFT 0x1
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_2_MASK 0x4
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_2__SHIFT 0x2
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_3_MASK 0x8
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_3__SHIFT 0x3
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_4_MASK 0x10
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_4__SHIFT 0x4
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_5_MASK 0x20
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_5__SHIFT 0x5
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_6_MASK 0x40
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_6__SHIFT 0x6
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_7_MASK 0x80
#define PB0_PIF_BIF_CMD_STATUS__TXPHYSTATUS_7__SHIFT 0x7
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_0_MASK 0x100
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_0__SHIFT 0x8
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_1_MASK 0x200
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_1__SHIFT 0x9
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_2_MASK 0x400
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_2__SHIFT 0xa
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_3_MASK 0x800
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_3__SHIFT 0xb
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_4_MASK 0x1000
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_4__SHIFT 0xc
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_5_MASK 0x2000
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_5__SHIFT 0xd
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_6_MASK 0x4000
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_6__SHIFT 0xe
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_7_MASK 0x8000
#define PB0_PIF_BIF_CMD_STATUS__RXPHYSTATUS_7__SHIFT 0xf
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_0_MASK 0x10000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_0__SHIFT 0x10
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_1_MASK 0x20000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_1__SHIFT 0x11
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_2_MASK 0x40000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_2__SHIFT 0x12
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_3_MASK 0x80000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_3__SHIFT 0x13
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_4_MASK 0x100000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_4__SHIFT 0x14
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_5_MASK 0x200000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_5__SHIFT 0x15
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_6_MASK 0x400000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_6__SHIFT 0x16
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_7_MASK 0x800000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_7__SHIFT 0x17
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_0_MASK 0x1000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_0__SHIFT 0x18
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_1_MASK 0x2000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_1__SHIFT 0x19
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_2_MASK 0x4000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_2__SHIFT 0x1a
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_3_MASK 0x8000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_3__SHIFT 0x1b
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_4_MASK 0x10000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_4__SHIFT 0x1c
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_5_MASK 0x20000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_5__SHIFT 0x1d
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_6_MASK 0x40000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_6__SHIFT 0x1e
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_7_MASK 0x80000000
#define PB0_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_7__SHIFT 0x1f
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_SCHL_MODE_MASK 0x3
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_SCHL_MODE__SHIFT 0x0
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_MODE_MASK 0xc
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_MODE__SHIFT 0x2
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_DIS_MASK 0x10
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_DIS__SHIFT 0x4
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_SCH_REQ_MODE_MASK 0x60
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_SCH_REQ_MODE__SHIFT 0x5
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PEND_PWR_MASK 0x80
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PEND_PWR__SHIFT 0x7
#define PB0_PIF_CMD_BUS_CTRL__SEND_GANGED_MODE_UPDATE_FOR_OFFPG_LANES_MASK 0x100
#define PB0_PIF_CMD_BUS_CTRL__SEND_GANGED_MODE_UPDATE_FOR_OFFPG_LANES__SHIFT 0x8
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PWR_NOT_ON_MASK 0x200
#define PB0_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PWR_NOT_ON__SHIFT 0x9
#define PB0_PIF_CMD_BUS_GLB_OVRD__TXMARG_OVRD_EN_MASK 0x1
#define PB0_PIF_CMD_BUS_GLB_OVRD__TXMARG_OVRD_EN__SHIFT 0x0
#define PB0_PIF_CMD_BUS_GLB_OVRD__DEEMPH_OVRD_EN_MASK 0x2
#define PB0_PIF_CMD_BUS_GLB_OVRD__DEEMPH_OVRD_EN__SHIFT 0x1
#define PB0_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_OVRD_EN_MASK 0x4
#define PB0_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_OVRD_EN__SHIFT 0x2
#define PB0_PIF_CMD_BUS_GLB_OVRD__TXMARG_MASK 0x38
#define PB0_PIF_CMD_BUS_GLB_OVRD__TXMARG__SHIFT 0x3
#define PB0_PIF_CMD_BUS_GLB_OVRD__DEEMPH_MASK 0x40
#define PB0_PIF_CMD_BUS_GLB_OVRD__DEEMPH__SHIFT 0x6
#define PB0_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_MASK 0x180
#define PB0_PIF_CMD_BUS_GLB_OVRD__PLLFREQ__SHIFT 0x7
#define PB0_PIF_CMD_BUS_GLB_OVRD__RESPONSEMODE_PIF_OVRD_MASK 0x200
#define PB0_PIF_CMD_BUS_GLB_OVRD__RESPONSEMODE_PIF_OVRD__SHIFT 0x9
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_0_MASK 0x10000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_0__SHIFT 0x10
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_1_MASK 0x20000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_1__SHIFT 0x11
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_2_MASK 0x40000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_2__SHIFT 0x12
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_3_MASK 0x80000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_3__SHIFT 0x13
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_4_MASK 0x100000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_4__SHIFT 0x14
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_5_MASK 0x200000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_5__SHIFT 0x15
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_6_MASK 0x400000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_6__SHIFT 0x16
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_7_MASK 0x800000
#define PB0_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_7__SHIFT 0x17
#define PB0_PIF_LANE0_OVRD__GANGMODE_OVRD_EN_0_MASK 0x1
#define PB0_PIF_LANE0_OVRD__GANGMODE_OVRD_EN_0__SHIFT 0x0
#define PB0_PIF_LANE0_OVRD__FREQDIV_OVRD_EN_0_MASK 0x2
#define PB0_PIF_LANE0_OVRD__FREQDIV_OVRD_EN_0__SHIFT 0x1
#define PB0_PIF_LANE0_OVRD__LINKSPEED_OVRD_EN_0_MASK 0x4
#define PB0_PIF_LANE0_OVRD__LINKSPEED_OVRD_EN_0__SHIFT 0x2
#define PB0_PIF_LANE0_OVRD__TWOSYMENABLE_OVRD_EN_0_MASK 0x8
#define PB0_PIF_LANE0_OVRD__TWOSYMENABLE_OVRD_EN_0__SHIFT 0x3
#define PB0_PIF_LANE0_OVRD__TXPWR_OVRD_EN_0_MASK 0x10
#define PB0_PIF_LANE0_OVRD__TXPWR_OVRD_EN_0__SHIFT 0x4
#define PB0_PIF_LANE0_OVRD__TXPGENABLE_OVRD_EN_0_MASK 0x20
#define PB0_PIF_LANE0_OVRD__TXPGENABLE_OVRD_EN_0__SHIFT 0x5
#define PB0_PIF_LANE0_OVRD__RXPWR_OVRD_EN_0_MASK 0x40
#define PB0_PIF_LANE0_OVRD__RXPWR_OVRD_EN_0__SHIFT 0x6
#define PB0_PIF_LANE0_OVRD__RXPGENABLE_OVRD_EN_0_MASK 0x80
#define PB0_PIF_LANE0_OVRD__RXPGENABLE_OVRD_EN_0__SHIFT 0x7
#define PB0_PIF_LANE0_OVRD__ELECIDLEDETEN_OVRD_EN_0_MASK 0x100
#define PB0_PIF_LANE0_OVRD__ELECIDLEDETEN_OVRD_EN_0__SHIFT 0x8
#define PB0_PIF_LANE0_OVRD__ENABLEFOM_OVRD_EN_0_MASK 0x200
#define PB0_PIF_LANE0_OVRD__ENABLEFOM_OVRD_EN_0__SHIFT 0x9
#define PB0_PIF_LANE0_OVRD__REQUESTFOM_OVRD_EN_0_MASK 0x400
#define PB0_PIF_LANE0_OVRD__REQUESTFOM_OVRD_EN_0__SHIFT 0xa
#define PB0_PIF_LANE0_OVRD__RESPONSEMODE_OVRD_EN_0_MASK 0x800
#define PB0_PIF_LANE0_OVRD__RESPONSEMODE_OVRD_EN_0__SHIFT 0xb
#define PB0_PIF_LANE0_OVRD__REQUESTTRK_OVRD_EN_0_MASK 0x1000
#define PB0_PIF_LANE0_OVRD__REQUESTTRK_OVRD_EN_0__SHIFT 0xc
#define PB0_PIF_LANE0_OVRD__REQUESTTRN_OVRD_EN_0_MASK 0x2000
#define PB0_PIF_LANE0_OVRD__REQUESTTRN_OVRD_EN_0__SHIFT 0xd
#define PB0_PIF_LANE0_OVRD__COEFFICIENTID_OVRD_EN_0_MASK 0x4000
#define PB0_PIF_LANE0_OVRD__COEFFICIENTID_OVRD_EN_0__SHIFT 0xe
#define PB0_PIF_LANE0_OVRD__COEFFICIENT_OVRD_EN_0_MASK 0x8000
#define PB0_PIF_LANE0_OVRD__COEFFICIENT_OVRD_EN_0__SHIFT 0xf
#define PB0_PIF_LANE0_OVRD__CDREN_OVRD_EN_0_MASK 0x10000
#define PB0_PIF_LANE0_OVRD__CDREN_OVRD_EN_0__SHIFT 0x10
#define PB0_PIF_LANE0_OVRD__CDREN_OVRD_VAL_0_MASK 0x20000
#define PB0_PIF_LANE0_OVRD__CDREN_OVRD_VAL_0__SHIFT 0x11
#define PB0_PIF_LANE0_OVRD2__GANGMODE_0_MASK 0x7
#define PB0_PIF_LANE0_OVRD2__GANGMODE_0__SHIFT 0x0
#define PB0_PIF_LANE0_OVRD2__FREQDIV_0_MASK 0x18
#define PB0_PIF_LANE0_OVRD2__FREQDIV_0__SHIFT 0x3
#define PB0_PIF_LANE0_OVRD2__LINKSPEED_0_MASK 0x60
#define PB0_PIF_LANE0_OVRD2__LINKSPEED_0__SHIFT 0x5
#define PB0_PIF_LANE0_OVRD2__TWOSYMENABLE_0_MASK 0x80
#define PB0_PIF_LANE0_OVRD2__TWOSYMENABLE_0__SHIFT 0x7
#define PB0_PIF_LANE0_OVRD2__TXPWR_0_MASK 0x700
#define PB0_PIF_LANE0_OVRD2__TXPWR_0__SHIFT 0x8
#define PB0_PIF_LANE0_OVRD2__TXPGENABLE_0_MASK 0x1800
#define PB0_PIF_LANE0_OVRD2__TXPGENABLE_0__SHIFT 0xb
#define PB0_PIF_LANE0_OVRD2__RXPWR_0_MASK 0xe000
#define PB0_PIF_LANE0_OVRD2__RXPWR_0__SHIFT 0xd
#define PB0_PIF_LANE0_OVRD2__RXPGENABLE_0_MASK 0x30000
#define PB0_PIF_LANE0_OVRD2__RXPGENABLE_0__SHIFT 0x10
#define PB0_PIF_LANE0_OVRD2__ELECIDLEDETEN_0_MASK 0x40000
#define PB0_PIF_LANE0_OVRD2__ELECIDLEDETEN_0__SHIFT 0x12
#define PB0_PIF_LANE0_OVRD2__ENABLEFOM_0_MASK 0x80000
#define PB0_PIF_LANE0_OVRD2__ENABLEFOM_0__SHIFT 0x13
#define PB0_PIF_LANE0_OVRD2__REQUESTFOM_0_MASK 0x100000
#define PB0_PIF_LANE0_OVRD2__REQUESTFOM_0__SHIFT 0x14
#define PB0_PIF_LANE0_OVRD2__RESPONSEMODE_0_MASK 0x200000
#define PB0_PIF_LANE0_OVRD2__RESPONSEMODE_0__SHIFT 0x15
#define PB0_PIF_LANE0_OVRD2__REQUESTTRK_0_MASK 0x400000
#define PB0_PIF_LANE0_OVRD2__REQUESTTRK_0__SHIFT 0x16
#define PB0_PIF_LANE0_OVRD2__REQUESTTRN_0_MASK 0x800000
#define PB0_PIF_LANE0_OVRD2__REQUESTTRN_0__SHIFT 0x17
#define PB0_PIF_LANE0_OVRD2__COEFFICIENTID_0_MASK 0x3000000
#define PB0_PIF_LANE0_OVRD2__COEFFICIENTID_0__SHIFT 0x18
#define PB0_PIF_LANE0_OVRD2__COEFFICIENT_0_MASK 0xfc000000
#define PB0_PIF_LANE0_OVRD2__COEFFICIENT_0__SHIFT 0x1a
#define PB0_PIF_LANE1_OVRD__GANGMODE_OVRD_EN_1_MASK 0x1
#define PB0_PIF_LANE1_OVRD__GANGMODE_OVRD_EN_1__SHIFT 0x0
#define PB0_PIF_LANE1_OVRD__FREQDIV_OVRD_EN_1_MASK 0x2
#define PB0_PIF_LANE1_OVRD__FREQDIV_OVRD_EN_1__SHIFT 0x1
#define PB0_PIF_LANE1_OVRD__LINKSPEED_OVRD_EN_1_MASK 0x4
#define PB0_PIF_LANE1_OVRD__LINKSPEED_OVRD_EN_1__SHIFT 0x2
#define PB0_PIF_LANE1_OVRD__TWOSYMENABLE_OVRD_EN_1_MASK 0x8
#define PB0_PIF_LANE1_OVRD__TWOSYMENABLE_OVRD_EN_1__SHIFT 0x3
#define PB0_PIF_LANE1_OVRD__TXPWR_OVRD_EN_1_MASK 0x10
#define PB0_PIF_LANE1_OVRD__TXPWR_OVRD_EN_1__SHIFT 0x4
#define PB0_PIF_LANE1_OVRD__TXPGENABLE_OVRD_EN_1_MASK 0x20
#define PB0_PIF_LANE1_OVRD__TXPGENABLE_OVRD_EN_1__SHIFT 0x5
#define PB0_PIF_LANE1_OVRD__RXPWR_OVRD_EN_1_MASK 0x40
#define PB0_PIF_LANE1_OVRD__RXPWR_OVRD_EN_1__SHIFT 0x6
#define PB0_PIF_LANE1_OVRD__RXPGENABLE_OVRD_EN_1_MASK 0x80
#define PB0_PIF_LANE1_OVRD__RXPGENABLE_OVRD_EN_1__SHIFT 0x7
#define PB0_PIF_LANE1_OVRD__ELECIDLEDETEN_OVRD_EN_1_MASK 0x100
#define PB0_PIF_LANE1_OVRD__ELECIDLEDETEN_OVRD_EN_1__SHIFT 0x8
#define PB0_PIF_LANE1_OVRD__ENABLEFOM_OVRD_EN_1_MASK 0x200
#define PB0_PIF_LANE1_OVRD__ENABLEFOM_OVRD_EN_1__SHIFT 0x9
#define PB0_PIF_LANE1_OVRD__REQUESTFOM_OVRD_EN_1_MASK 0x400
#define PB0_PIF_LANE1_OVRD__REQUESTFOM_OVRD_EN_1__SHIFT 0xa
#define PB0_PIF_LANE1_OVRD__RESPONSEMODE_OVRD_EN_1_MASK 0x800
#define PB0_PIF_LANE1_OVRD__RESPONSEMODE_OVRD_EN_1__SHIFT 0xb
#define PB0_PIF_LANE1_OVRD__REQUESTTRK_OVRD_EN_1_MASK 0x1000
#define PB0_PIF_LANE1_OVRD__REQUESTTRK_OVRD_EN_1__SHIFT 0xc
#define PB0_PIF_LANE1_OVRD__REQUESTTRN_OVRD_EN_1_MASK 0x2000
#define PB0_PIF_LANE1_OVRD__REQUESTTRN_OVRD_EN_1__SHIFT 0xd
#define PB0_PIF_LANE1_OVRD__COEFFICIENTID_OVRD_EN_1_MASK 0x4000
#define PB0_PIF_LANE1_OVRD__COEFFICIENTID_OVRD_EN_1__SHIFT 0xe
#define PB0_PIF_LANE1_OVRD__COEFFICIENT_OVRD_EN_1_MASK 0x8000
#define PB0_PIF_LANE1_OVRD__COEFFICIENT_OVRD_EN_1__SHIFT 0xf
#define PB0_PIF_LANE1_OVRD__CDREN_OVRD_EN_1_MASK 0x10000
#define PB0_PIF_LANE1_OVRD__CDREN_OVRD_EN_1__SHIFT 0x10
#define PB0_PIF_LANE1_OVRD__CDREN_OVRD_VAL_1_MASK 0x20000
#define PB0_PIF_LANE1_OVRD__CDREN_OVRD_VAL_1__SHIFT 0x11
#define PB0_PIF_LANE1_OVRD2__GANGMODE_1_MASK 0x7
#define PB0_PIF_LANE1_OVRD2__GANGMODE_1__SHIFT 0x0
#define PB0_PIF_LANE1_OVRD2__FREQDIV_1_MASK 0x18
#define PB0_PIF_LANE1_OVRD2__FREQDIV_1__SHIFT 0x3
#define PB0_PIF_LANE1_OVRD2__LINKSPEED_1_MASK 0x60
#define PB0_PIF_LANE1_OVRD2__LINKSPEED_1__SHIFT 0x5
#define PB0_PIF_LANE1_OVRD2__TWOSYMENABLE_1_MASK 0x80
#define PB0_PIF_LANE1_OVRD2__TWOSYMENABLE_1__SHIFT 0x7
#define PB0_PIF_LANE1_OVRD2__TXPWR_1_MASK 0x700
#define PB0_PIF_LANE1_OVRD2__TXPWR_1__SHIFT 0x8
#define PB0_PIF_LANE1_OVRD2__TXPGENABLE_1_MASK 0x1800
#define PB0_PIF_LANE1_OVRD2__TXPGENABLE_1__SHIFT 0xb
#define PB0_PIF_LANE1_OVRD2__RXPWR_1_MASK 0xe000
#define PB0_PIF_LANE1_OVRD2__RXPWR_1__SHIFT 0xd
#define PB0_PIF_LANE1_OVRD2__RXPGENABLE_1_MASK 0x30000
#define PB0_PIF_LANE1_OVRD2__RXPGENABLE_1__SHIFT 0x10
#define PB0_PIF_LANE1_OVRD2__ELECIDLEDETEN_1_MASK 0x40000
#define PB0_PIF_LANE1_OVRD2__ELECIDLEDETEN_1__SHIFT 0x12
#define PB0_PIF_LANE1_OVRD2__ENABLEFOM_1_MASK 0x80000
#define PB0_PIF_LANE1_OVRD2__ENABLEFOM_1__SHIFT 0x13
#define PB0_PIF_LANE1_OVRD2__REQUESTFOM_1_MASK 0x100000
#define PB0_PIF_LANE1_OVRD2__REQUESTFOM_1__SHIFT 0x14
#define PB0_PIF_LANE1_OVRD2__RESPONSEMODE_1_MASK 0x200000
#define PB0_PIF_LANE1_OVRD2__RESPONSEMODE_1__SHIFT 0x15
#define PB0_PIF_LANE1_OVRD2__REQUESTTRK_1_MASK 0x400000
#define PB0_PIF_LANE1_OVRD2__REQUESTTRK_1__SHIFT 0x16
#define PB0_PIF_LANE1_OVRD2__REQUESTTRN_1_MASK 0x800000
#define PB0_PIF_LANE1_OVRD2__REQUESTTRN_1__SHIFT 0x17
#define PB0_PIF_LANE1_OVRD2__COEFFICIENTID_1_MASK 0x3000000
#define PB0_PIF_LANE1_OVRD2__COEFFICIENTID_1__SHIFT 0x18
#define PB0_PIF_LANE1_OVRD2__COEFFICIENT_1_MASK 0xfc000000
#define PB0_PIF_LANE1_OVRD2__COEFFICIENT_1__SHIFT 0x1a
#define PB0_PIF_LANE2_OVRD__GANGMODE_OVRD_EN_2_MASK 0x1
#define PB0_PIF_LANE2_OVRD__GANGMODE_OVRD_EN_2__SHIFT 0x0
#define PB0_PIF_LANE2_OVRD__FREQDIV_OVRD_EN_2_MASK 0x2
#define PB0_PIF_LANE2_OVRD__FREQDIV_OVRD_EN_2__SHIFT 0x1
#define PB0_PIF_LANE2_OVRD__LINKSPEED_OVRD_EN_2_MASK 0x4
#define PB0_PIF_LANE2_OVRD__LINKSPEED_OVRD_EN_2__SHIFT 0x2
#define PB0_PIF_LANE2_OVRD__TWOSYMENABLE_OVRD_EN_2_MASK 0x8
#define PB0_PIF_LANE2_OVRD__TWOSYMENABLE_OVRD_EN_2__SHIFT 0x3
#define PB0_PIF_LANE2_OVRD__TXPWR_OVRD_EN_2_MASK 0x10
#define PB0_PIF_LANE2_OVRD__TXPWR_OVRD_EN_2__SHIFT 0x4
#define PB0_PIF_LANE2_OVRD__TXPGENABLE_OVRD_EN_2_MASK 0x20
#define PB0_PIF_LANE2_OVRD__TXPGENABLE_OVRD_EN_2__SHIFT 0x5
#define PB0_PIF_LANE2_OVRD__RXPWR_OVRD_EN_2_MASK 0x40
#define PB0_PIF_LANE2_OVRD__RXPWR_OVRD_EN_2__SHIFT 0x6
#define PB0_PIF_LANE2_OVRD__RXPGENABLE_OVRD_EN_2_MASK 0x80
#define PB0_PIF_LANE2_OVRD__RXPGENABLE_OVRD_EN_2__SHIFT 0x7
#define PB0_PIF_LANE2_OVRD__ELECIDLEDETEN_OVRD_EN_2_MASK 0x100
#define PB0_PIF_LANE2_OVRD__ELECIDLEDETEN_OVRD_EN_2__SHIFT 0x8
#define PB0_PIF_LANE2_OVRD__ENABLEFOM_OVRD_EN_2_MASK 0x200
#define PB0_PIF_LANE2_OVRD__ENABLEFOM_OVRD_EN_2__SHIFT 0x9
#define PB0_PIF_LANE2_OVRD__REQUESTFOM_OVRD_EN_2_MASK 0x400
#define PB0_PIF_LANE2_OVRD__REQUESTFOM_OVRD_EN_2__SHIFT 0xa
#define PB0_PIF_LANE2_OVRD__RESPONSEMODE_OVRD_EN_2_MASK 0x800
#define PB0_PIF_LANE2_OVRD__RESPONSEMODE_OVRD_EN_2__SHIFT 0xb
#define PB0_PIF_LANE2_OVRD__REQUESTTRK_OVRD_EN_2_MASK 0x1000
#define PB0_PIF_LANE2_OVRD__REQUESTTRK_OVRD_EN_2__SHIFT 0xc
#define PB0_PIF_LANE2_OVRD__REQUESTTRN_OVRD_EN_2_MASK 0x2000
#define PB0_PIF_LANE2_OVRD__REQUESTTRN_OVRD_EN_2__SHIFT 0xd
#define PB0_PIF_LANE2_OVRD__COEFFICIENTID_OVRD_EN_2_MASK 0x4000
#define PB0_PIF_LANE2_OVRD__COEFFICIENTID_OVRD_EN_2__SHIFT 0xe
#define PB0_PIF_LANE2_OVRD__COEFFICIENT_OVRD_EN_2_MASK 0x8000
#define PB0_PIF_LANE2_OVRD__COEFFICIENT_OVRD_EN_2__SHIFT 0xf
#define PB0_PIF_LANE2_OVRD__CDREN_OVRD_EN_2_MASK 0x10000
#define PB0_PIF_LANE2_OVRD__CDREN_OVRD_EN_2__SHIFT 0x10
#define PB0_PIF_LANE2_OVRD__CDREN_OVRD_VAL_2_MASK 0x20000
#define PB0_PIF_LANE2_OVRD__CDREN_OVRD_VAL_2__SHIFT 0x11
#define PB0_PIF_LANE2_OVRD2__GANGMODE_2_MASK 0x7
#define PB0_PIF_LANE2_OVRD2__GANGMODE_2__SHIFT 0x0
#define PB0_PIF_LANE2_OVRD2__FREQDIV_2_MASK 0x18
#define PB0_PIF_LANE2_OVRD2__FREQDIV_2__SHIFT 0x3
#define PB0_PIF_LANE2_OVRD2__LINKSPEED_2_MASK 0x60
#define PB0_PIF_LANE2_OVRD2__LINKSPEED_2__SHIFT 0x5
#define PB0_PIF_LANE2_OVRD2__TWOSYMENABLE_2_MASK 0x80
#define PB0_PIF_LANE2_OVRD2__TWOSYMENABLE_2__SHIFT 0x7
#define PB0_PIF_LANE2_OVRD2__TXPWR_2_MASK 0x700
#define PB0_PIF_LANE2_OVRD2__TXPWR_2__SHIFT 0x8
#define PB0_PIF_LANE2_OVRD2__TXPGENABLE_2_MASK 0x1800
#define PB0_PIF_LANE2_OVRD2__TXPGENABLE_2__SHIFT 0xb
#define PB0_PIF_LANE2_OVRD2__RXPWR_2_MASK 0xe000
#define PB0_PIF_LANE2_OVRD2__RXPWR_2__SHIFT 0xd
#define PB0_PIF_LANE2_OVRD2__RXPGENABLE_2_MASK 0x30000
#define PB0_PIF_LANE2_OVRD2__RXPGENABLE_2__SHIFT 0x10
#define PB0_PIF_LANE2_OVRD2__ELECIDLEDETEN_2_MASK 0x40000
#define PB0_PIF_LANE2_OVRD2__ELECIDLEDETEN_2__SHIFT 0x12
#define PB0_PIF_LANE2_OVRD2__ENABLEFOM_2_MASK 0x80000
#define PB0_PIF_LANE2_OVRD2__ENABLEFOM_2__SHIFT 0x13
#define PB0_PIF_LANE2_OVRD2__REQUESTFOM_2_MASK 0x100000
#define PB0_PIF_LANE2_OVRD2__REQUESTFOM_2__SHIFT 0x14
#define PB0_PIF_LANE2_OVRD2__RESPONSEMODE_2_MASK 0x200000
#define PB0_PIF_LANE2_OVRD2__RESPONSEMODE_2__SHIFT 0x15
#define PB0_PIF_LANE2_OVRD2__REQUESTTRK_2_MASK 0x400000
#define PB0_PIF_LANE2_OVRD2__REQUESTTRK_2__SHIFT 0x16
#define PB0_PIF_LANE2_OVRD2__REQUESTTRN_2_MASK 0x800000
#define PB0_PIF_LANE2_OVRD2__REQUESTTRN_2__SHIFT 0x17
#define PB0_PIF_LANE2_OVRD2__COEFFICIENTID_2_MASK 0x3000000
#define PB0_PIF_LANE2_OVRD2__COEFFICIENTID_2__SHIFT 0x18
#define PB0_PIF_LANE2_OVRD2__COEFFICIENT_2_MASK 0xfc000000
#define PB0_PIF_LANE2_OVRD2__COEFFICIENT_2__SHIFT 0x1a
#define PB0_PIF_LANE3_OVRD__GANGMODE_OVRD_EN_3_MASK 0x1
#define PB0_PIF_LANE3_OVRD__GANGMODE_OVRD_EN_3__SHIFT 0x0
#define PB0_PIF_LANE3_OVRD__FREQDIV_OVRD_EN_3_MASK 0x2
#define PB0_PIF_LANE3_OVRD__FREQDIV_OVRD_EN_3__SHIFT 0x1
#define PB0_PIF_LANE3_OVRD__LINKSPEED_OVRD_EN_3_MASK 0x4
#define PB0_PIF_LANE3_OVRD__LINKSPEED_OVRD_EN_3__SHIFT 0x2
#define PB0_PIF_LANE3_OVRD__TWOSYMENABLE_OVRD_EN_3_MASK 0x8
#define PB0_PIF_LANE3_OVRD__TWOSYMENABLE_OVRD_EN_3__SHIFT 0x3
#define PB0_PIF_LANE3_OVRD__TXPWR_OVRD_EN_3_MASK 0x10
#define PB0_PIF_LANE3_OVRD__TXPWR_OVRD_EN_3__SHIFT 0x4
#define PB0_PIF_LANE3_OVRD__TXPGENABLE_OVRD_EN_3_MASK 0x20
#define PB0_PIF_LANE3_OVRD__TXPGENABLE_OVRD_EN_3__SHIFT 0x5
#define PB0_PIF_LANE3_OVRD__RXPWR_OVRD_EN_3_MASK 0x40
#define PB0_PIF_LANE3_OVRD__RXPWR_OVRD_EN_3__SHIFT 0x6
#define PB0_PIF_LANE3_OVRD__RXPGENABLE_OVRD_EN_3_MASK 0x80
#define PB0_PIF_LANE3_OVRD__RXPGENABLE_OVRD_EN_3__SHIFT 0x7
#define PB0_PIF_LANE3_OVRD__ELECIDLEDETEN_OVRD_EN_3_MASK 0x100
#define PB0_PIF_LANE3_OVRD__ELECIDLEDETEN_OVRD_EN_3__SHIFT 0x8
#define PB0_PIF_LANE3_OVRD__ENABLEFOM_OVRD_EN_3_MASK 0x200
#define PB0_PIF_LANE3_OVRD__ENABLEFOM_OVRD_EN_3__SHIFT 0x9
#define PB0_PIF_LANE3_OVRD__REQUESTFOM_OVRD_EN_3_MASK 0x400
#define PB0_PIF_LANE3_OVRD__REQUESTFOM_OVRD_EN_3__SHIFT 0xa
#define PB0_PIF_LANE3_OVRD__RESPONSEMODE_OVRD_EN_3_MASK 0x800
#define PB0_PIF_LANE3_OVRD__RESPONSEMODE_OVRD_EN_3__SHIFT 0xb
#define PB0_PIF_LANE3_OVRD__REQUESTTRK_OVRD_EN_3_MASK 0x1000
#define PB0_PIF_LANE3_OVRD__REQUESTTRK_OVRD_EN_3__SHIFT 0xc
#define PB0_PIF_LANE3_OVRD__REQUESTTRN_OVRD_EN_3_MASK 0x2000
#define PB0_PIF_LANE3_OVRD__REQUESTTRN_OVRD_EN_3__SHIFT 0xd
#define PB0_PIF_LANE3_OVRD__COEFFICIENTID_OVRD_EN_3_MASK 0x4000
#define PB0_PIF_LANE3_OVRD__COEFFICIENTID_OVRD_EN_3__SHIFT 0xe
#define PB0_PIF_LANE3_OVRD__COEFFICIENT_OVRD_EN_3_MASK 0x8000
#define PB0_PIF_LANE3_OVRD__COEFFICIENT_OVRD_EN_3__SHIFT 0xf
#define PB0_PIF_LANE3_OVRD__CDREN_OVRD_EN_3_MASK 0x10000
#define PB0_PIF_LANE3_OVRD__CDREN_OVRD_EN_3__SHIFT 0x10
#define PB0_PIF_LANE3_OVRD__CDREN_OVRD_VAL_3_MASK 0x20000
#define PB0_PIF_LANE3_OVRD__CDREN_OVRD_VAL_3__SHIFT 0x11
#define PB0_PIF_LANE3_OVRD2__GANGMODE_3_MASK 0x7
#define PB0_PIF_LANE3_OVRD2__GANGMODE_3__SHIFT 0x0
#define PB0_PIF_LANE3_OVRD2__FREQDIV_3_MASK 0x18
#define PB0_PIF_LANE3_OVRD2__FREQDIV_3__SHIFT 0x3
#define PB0_PIF_LANE3_OVRD2__LINKSPEED_3_MASK 0x60
#define PB0_PIF_LANE3_OVRD2__LINKSPEED_3__SHIFT 0x5
#define PB0_PIF_LANE3_OVRD2__TWOSYMENABLE_3_MASK 0x80
#define PB0_PIF_LANE3_OVRD2__TWOSYMENABLE_3__SHIFT 0x7
#define PB0_PIF_LANE3_OVRD2__TXPWR_3_MASK 0x700
#define PB0_PIF_LANE3_OVRD2__TXPWR_3__SHIFT 0x8
#define PB0_PIF_LANE3_OVRD2__TXPGENABLE_3_MASK 0x1800
#define PB0_PIF_LANE3_OVRD2__TXPGENABLE_3__SHIFT 0xb
#define PB0_PIF_LANE3_OVRD2__RXPWR_3_MASK 0xe000
#define PB0_PIF_LANE3_OVRD2__RXPWR_3__SHIFT 0xd
#define PB0_PIF_LANE3_OVRD2__RXPGENABLE_3_MASK 0x30000
#define PB0_PIF_LANE3_OVRD2__RXPGENABLE_3__SHIFT 0x10
#define PB0_PIF_LANE3_OVRD2__ELECIDLEDETEN_3_MASK 0x40000
#define PB0_PIF_LANE3_OVRD2__ELECIDLEDETEN_3__SHIFT 0x12
#define PB0_PIF_LANE3_OVRD2__ENABLEFOM_3_MASK 0x80000
#define PB0_PIF_LANE3_OVRD2__ENABLEFOM_3__SHIFT 0x13
#define PB0_PIF_LANE3_OVRD2__REQUESTFOM_3_MASK 0x100000
#define PB0_PIF_LANE3_OVRD2__REQUESTFOM_3__SHIFT 0x14
#define PB0_PIF_LANE3_OVRD2__RESPONSEMODE_3_MASK 0x200000
#define PB0_PIF_LANE3_OVRD2__RESPONSEMODE_3__SHIFT 0x15
#define PB0_PIF_LANE3_OVRD2__REQUESTTRK_3_MASK 0x400000
#define PB0_PIF_LANE3_OVRD2__REQUESTTRK_3__SHIFT 0x16
#define PB0_PIF_LANE3_OVRD2__REQUESTTRN_3_MASK 0x800000
#define PB0_PIF_LANE3_OVRD2__REQUESTTRN_3__SHIFT 0x17
#define PB0_PIF_LANE3_OVRD2__COEFFICIENTID_3_MASK 0x3000000
#define PB0_PIF_LANE3_OVRD2__COEFFICIENTID_3__SHIFT 0x18
#define PB0_PIF_LANE3_OVRD2__COEFFICIENT_3_MASK 0xfc000000
#define PB0_PIF_LANE3_OVRD2__COEFFICIENT_3__SHIFT 0x1a
#define PB0_PIF_LANE4_OVRD__GANGMODE_OVRD_EN_4_MASK 0x1
#define PB0_PIF_LANE4_OVRD__GANGMODE_OVRD_EN_4__SHIFT 0x0
#define PB0_PIF_LANE4_OVRD__FREQDIV_OVRD_EN_4_MASK 0x2
#define PB0_PIF_LANE4_OVRD__FREQDIV_OVRD_EN_4__SHIFT 0x1
#define PB0_PIF_LANE4_OVRD__LINKSPEED_OVRD_EN_4_MASK 0x4
#define PB0_PIF_LANE4_OVRD__LINKSPEED_OVRD_EN_4__SHIFT 0x2
#define PB0_PIF_LANE4_OVRD__TWOSYMENABLE_OVRD_EN_4_MASK 0x8
#define PB0_PIF_LANE4_OVRD__TWOSYMENABLE_OVRD_EN_4__SHIFT 0x3
#define PB0_PIF_LANE4_OVRD__TXPWR_OVRD_EN_4_MASK 0x10
#define PB0_PIF_LANE4_OVRD__TXPWR_OVRD_EN_4__SHIFT 0x4
#define PB0_PIF_LANE4_OVRD__TXPGENABLE_OVRD_EN_4_MASK 0x20
#define PB0_PIF_LANE4_OVRD__TXPGENABLE_OVRD_EN_4__SHIFT 0x5
#define PB0_PIF_LANE4_OVRD__RXPWR_OVRD_EN_4_MASK 0x40
#define PB0_PIF_LANE4_OVRD__RXPWR_OVRD_EN_4__SHIFT 0x6
#define PB0_PIF_LANE4_OVRD__RXPGENABLE_OVRD_EN_4_MASK 0x80
#define PB0_PIF_LANE4_OVRD__RXPGENABLE_OVRD_EN_4__SHIFT 0x7
#define PB0_PIF_LANE4_OVRD__ELECIDLEDETEN_OVRD_EN_4_MASK 0x100
#define PB0_PIF_LANE4_OVRD__ELECIDLEDETEN_OVRD_EN_4__SHIFT 0x8
#define PB0_PIF_LANE4_OVRD__ENABLEFOM_OVRD_EN_4_MASK 0x200
#define PB0_PIF_LANE4_OVRD__ENABLEFOM_OVRD_EN_4__SHIFT 0x9
#define PB0_PIF_LANE4_OVRD__REQUESTFOM_OVRD_EN_4_MASK 0x400
#define PB0_PIF_LANE4_OVRD__REQUESTFOM_OVRD_EN_4__SHIFT 0xa
#define PB0_PIF_LANE4_OVRD__RESPONSEMODE_OVRD_EN_4_MASK 0x800
#define PB0_PIF_LANE4_OVRD__RESPONSEMODE_OVRD_EN_4__SHIFT 0xb
#define PB0_PIF_LANE4_OVRD__REQUESTTRK_OVRD_EN_4_MASK 0x1000
#define PB0_PIF_LANE4_OVRD__REQUESTTRK_OVRD_EN_4__SHIFT 0xc
#define PB0_PIF_LANE4_OVRD__REQUESTTRN_OVRD_EN_4_MASK 0x2000
#define PB0_PIF_LANE4_OVRD__REQUESTTRN_OVRD_EN_4__SHIFT 0xd
#define PB0_PIF_LANE4_OVRD__COEFFICIENTID_OVRD_EN_4_MASK 0x4000
#define PB0_PIF_LANE4_OVRD__COEFFICIENTID_OVRD_EN_4__SHIFT 0xe
#define PB0_PIF_LANE4_OVRD__COEFFICIENT_OVRD_EN_4_MASK 0x8000
#define PB0_PIF_LANE4_OVRD__COEFFICIENT_OVRD_EN_4__SHIFT 0xf
#define PB0_PIF_LANE4_OVRD__CDREN_OVRD_EN_4_MASK 0x10000
#define PB0_PIF_LANE4_OVRD__CDREN_OVRD_EN_4__SHIFT 0x10
#define PB0_PIF_LANE4_OVRD__CDREN_OVRD_VAL_4_MASK 0x20000
#define PB0_PIF_LANE4_OVRD__CDREN_OVRD_VAL_4__SHIFT 0x11
#define PB0_PIF_LANE4_OVRD2__GANGMODE_4_MASK 0x7
#define PB0_PIF_LANE4_OVRD2__GANGMODE_4__SHIFT 0x0
#define PB0_PIF_LANE4_OVRD2__FREQDIV_4_MASK 0x18
#define PB0_PIF_LANE4_OVRD2__FREQDIV_4__SHIFT 0x3
#define PB0_PIF_LANE4_OVRD2__LINKSPEED_4_MASK 0x60
#define PB0_PIF_LANE4_OVRD2__LINKSPEED_4__SHIFT 0x5
#define PB0_PIF_LANE4_OVRD2__TWOSYMENABLE_4_MASK 0x80
#define PB0_PIF_LANE4_OVRD2__TWOSYMENABLE_4__SHIFT 0x7
#define PB0_PIF_LANE4_OVRD2__TXPWR_4_MASK 0x700
#define PB0_PIF_LANE4_OVRD2__TXPWR_4__SHIFT 0x8
#define PB0_PIF_LANE4_OVRD2__TXPGENABLE_4_MASK 0x1800
#define PB0_PIF_LANE4_OVRD2__TXPGENABLE_4__SHIFT 0xb
#define PB0_PIF_LANE4_OVRD2__RXPWR_4_MASK 0xe000
#define PB0_PIF_LANE4_OVRD2__RXPWR_4__SHIFT 0xd
#define PB0_PIF_LANE4_OVRD2__RXPGENABLE_4_MASK 0x30000
#define PB0_PIF_LANE4_OVRD2__RXPGENABLE_4__SHIFT 0x10
#define PB0_PIF_LANE4_OVRD2__ELECIDLEDETEN_4_MASK 0x40000
#define PB0_PIF_LANE4_OVRD2__ELECIDLEDETEN_4__SHIFT 0x12
#define PB0_PIF_LANE4_OVRD2__ENABLEFOM_4_MASK 0x80000
#define PB0_PIF_LANE4_OVRD2__ENABLEFOM_4__SHIFT 0x13
#define PB0_PIF_LANE4_OVRD2__REQUESTFOM_4_MASK 0x100000
#define PB0_PIF_LANE4_OVRD2__REQUESTFOM_4__SHIFT 0x14
#define PB0_PIF_LANE4_OVRD2__RESPONSEMODE_4_MASK 0x200000
#define PB0_PIF_LANE4_OVRD2__RESPONSEMODE_4__SHIFT 0x15
#define PB0_PIF_LANE4_OVRD2__REQUESTTRK_4_MASK 0x400000
#define PB0_PIF_LANE4_OVRD2__REQUESTTRK_4__SHIFT 0x16
#define PB0_PIF_LANE4_OVRD2__REQUESTTRN_4_MASK 0x800000
#define PB0_PIF_LANE4_OVRD2__REQUESTTRN_4__SHIFT 0x17
#define PB0_PIF_LANE4_OVRD2__COEFFICIENTID_4_MASK 0x3000000
#define PB0_PIF_LANE4_OVRD2__COEFFICIENTID_4__SHIFT 0x18
#define PB0_PIF_LANE4_OVRD2__COEFFICIENT_4_MASK 0xfc000000
#define PB0_PIF_LANE4_OVRD2__COEFFICIENT_4__SHIFT 0x1a
#define PB0_PIF_LANE5_OVRD__GANGMODE_OVRD_EN_5_MASK 0x1
#define PB0_PIF_LANE5_OVRD__GANGMODE_OVRD_EN_5__SHIFT 0x0
#define PB0_PIF_LANE5_OVRD__FREQDIV_OVRD_EN_5_MASK 0x2
#define PB0_PIF_LANE5_OVRD__FREQDIV_OVRD_EN_5__SHIFT 0x1
#define PB0_PIF_LANE5_OVRD__LINKSPEED_OVRD_EN_5_MASK 0x4
#define PB0_PIF_LANE5_OVRD__LINKSPEED_OVRD_EN_5__SHIFT 0x2
#define PB0_PIF_LANE5_OVRD__TWOSYMENABLE_OVRD_EN_5_MASK 0x8
#define PB0_PIF_LANE5_OVRD__TWOSYMENABLE_OVRD_EN_5__SHIFT 0x3
#define PB0_PIF_LANE5_OVRD__TXPWR_OVRD_EN_5_MASK 0x10
#define PB0_PIF_LANE5_OVRD__TXPWR_OVRD_EN_5__SHIFT 0x4
#define PB0_PIF_LANE5_OVRD__TXPGENABLE_OVRD_EN_5_MASK 0x20
#define PB0_PIF_LANE5_OVRD__TXPGENABLE_OVRD_EN_5__SHIFT 0x5
#define PB0_PIF_LANE5_OVRD__RXPWR_OVRD_EN_5_MASK 0x40
#define PB0_PIF_LANE5_OVRD__RXPWR_OVRD_EN_5__SHIFT 0x6
#define PB0_PIF_LANE5_OVRD__RXPGENABLE_OVRD_EN_5_MASK 0x80
#define PB0_PIF_LANE5_OVRD__RXPGENABLE_OVRD_EN_5__SHIFT 0x7
#define PB0_PIF_LANE5_OVRD__ELECIDLEDETEN_OVRD_EN_5_MASK 0x100
#define PB0_PIF_LANE5_OVRD__ELECIDLEDETEN_OVRD_EN_5__SHIFT 0x8
#define PB0_PIF_LANE5_OVRD__ENABLEFOM_OVRD_EN_5_MASK 0x200
#define PB0_PIF_LANE5_OVRD__ENABLEFOM_OVRD_EN_5__SHIFT 0x9
#define PB0_PIF_LANE5_OVRD__REQUESTFOM_OVRD_EN_5_MASK 0x400
#define PB0_PIF_LANE5_OVRD__REQUESTFOM_OVRD_EN_5__SHIFT 0xa
#define PB0_PIF_LANE5_OVRD__RESPONSEMODE_OVRD_EN_5_MASK 0x800
#define PB0_PIF_LANE5_OVRD__RESPONSEMODE_OVRD_EN_5__SHIFT 0xb
#define PB0_PIF_LANE5_OVRD__REQUESTTRK_OVRD_EN_5_MASK 0x1000
#define PB0_PIF_LANE5_OVRD__REQUESTTRK_OVRD_EN_5__SHIFT 0xc
#define PB0_PIF_LANE5_OVRD__REQUESTTRN_OVRD_EN_5_MASK 0x2000
#define PB0_PIF_LANE5_OVRD__REQUESTTRN_OVRD_EN_5__SHIFT 0xd
#define PB0_PIF_LANE5_OVRD__COEFFICIENTID_OVRD_EN_5_MASK 0x4000
#define PB0_PIF_LANE5_OVRD__COEFFICIENTID_OVRD_EN_5__SHIFT 0xe
#define PB0_PIF_LANE5_OVRD__COEFFICIENT_OVRD_EN_5_MASK 0x8000
#define PB0_PIF_LANE5_OVRD__COEFFICIENT_OVRD_EN_5__SHIFT 0xf
#define PB0_PIF_LANE5_OVRD__CDREN_OVRD_EN_5_MASK 0x10000
#define PB0_PIF_LANE5_OVRD__CDREN_OVRD_EN_5__SHIFT 0x10
#define PB0_PIF_LANE5_OVRD__CDREN_OVRD_VAL_5_MASK 0x20000
#define PB0_PIF_LANE5_OVRD__CDREN_OVRD_VAL_5__SHIFT 0x11
#define PB0_PIF_LANE5_OVRD2__GANGMODE_5_MASK 0x7
#define PB0_PIF_LANE5_OVRD2__GANGMODE_5__SHIFT 0x0
#define PB0_PIF_LANE5_OVRD2__FREQDIV_5_MASK 0x18
#define PB0_PIF_LANE5_OVRD2__FREQDIV_5__SHIFT 0x3
#define PB0_PIF_LANE5_OVRD2__LINKSPEED_5_MASK 0x60
#define PB0_PIF_LANE5_OVRD2__LINKSPEED_5__SHIFT 0x5
#define PB0_PIF_LANE5_OVRD2__TWOSYMENABLE_5_MASK 0x80
#define PB0_PIF_LANE5_OVRD2__TWOSYMENABLE_5__SHIFT 0x7
#define PB0_PIF_LANE5_OVRD2__TXPWR_5_MASK 0x700
#define PB0_PIF_LANE5_OVRD2__TXPWR_5__SHIFT 0x8
#define PB0_PIF_LANE5_OVRD2__TXPGENABLE_5_MASK 0x1800
#define PB0_PIF_LANE5_OVRD2__TXPGENABLE_5__SHIFT 0xb
#define PB0_PIF_LANE5_OVRD2__RXPWR_5_MASK 0xe000
#define PB0_PIF_LANE5_OVRD2__RXPWR_5__SHIFT 0xd
#define PB0_PIF_LANE5_OVRD2__RXPGENABLE_5_MASK 0x30000
#define PB0_PIF_LANE5_OVRD2__RXPGENABLE_5__SHIFT 0x10
#define PB0_PIF_LANE5_OVRD2__ELECIDLEDETEN_5_MASK 0x40000
#define PB0_PIF_LANE5_OVRD2__ELECIDLEDETEN_5__SHIFT 0x12
#define PB0_PIF_LANE5_OVRD2__ENABLEFOM_5_MASK 0x80000
#define PB0_PIF_LANE5_OVRD2__ENABLEFOM_5__SHIFT 0x13
#define PB0_PIF_LANE5_OVRD2__REQUESTFOM_5_MASK 0x100000
#define PB0_PIF_LANE5_OVRD2__REQUESTFOM_5__SHIFT 0x14
#define PB0_PIF_LANE5_OVRD2__RESPONSEMODE_5_MASK 0x200000
#define PB0_PIF_LANE5_OVRD2__RESPONSEMODE_5__SHIFT 0x15
#define PB0_PIF_LANE5_OVRD2__REQUESTTRK_5_MASK 0x400000
#define PB0_PIF_LANE5_OVRD2__REQUESTTRK_5__SHIFT 0x16
#define PB0_PIF_LANE5_OVRD2__REQUESTTRN_5_MASK 0x800000
#define PB0_PIF_LANE5_OVRD2__REQUESTTRN_5__SHIFT 0x17
#define PB0_PIF_LANE5_OVRD2__COEFFICIENTID_5_MASK 0x3000000
#define PB0_PIF_LANE5_OVRD2__COEFFICIENTID_5__SHIFT 0x18
#define PB0_PIF_LANE5_OVRD2__COEFFICIENT_5_MASK 0xfc000000
#define PB0_PIF_LANE5_OVRD2__COEFFICIENT_5__SHIFT 0x1a
#define PB0_PIF_LANE6_OVRD__GANGMODE_OVRD_EN_6_MASK 0x1
#define PB0_PIF_LANE6_OVRD__GANGMODE_OVRD_EN_6__SHIFT 0x0
#define PB0_PIF_LANE6_OVRD__FREQDIV_OVRD_EN_6_MASK 0x2
#define PB0_PIF_LANE6_OVRD__FREQDIV_OVRD_EN_6__SHIFT 0x1
#define PB0_PIF_LANE6_OVRD__LINKSPEED_OVRD_EN_6_MASK 0x4
#define PB0_PIF_LANE6_OVRD__LINKSPEED_OVRD_EN_6__SHIFT 0x2
#define PB0_PIF_LANE6_OVRD__TWOSYMENABLE_OVRD_EN_6_MASK 0x8
#define PB0_PIF_LANE6_OVRD__TWOSYMENABLE_OVRD_EN_6__SHIFT 0x3
#define PB0_PIF_LANE6_OVRD__TXPWR_OVRD_EN_6_MASK 0x10
#define PB0_PIF_LANE6_OVRD__TXPWR_OVRD_EN_6__SHIFT 0x4
#define PB0_PIF_LANE6_OVRD__TXPGENABLE_OVRD_EN_6_MASK 0x20
#define PB0_PIF_LANE6_OVRD__TXPGENABLE_OVRD_EN_6__SHIFT 0x5
#define PB0_PIF_LANE6_OVRD__RXPWR_OVRD_EN_6_MASK 0x40
#define PB0_PIF_LANE6_OVRD__RXPWR_OVRD_EN_6__SHIFT 0x6
#define PB0_PIF_LANE6_OVRD__RXPGENABLE_OVRD_EN_6_MASK 0x80
#define PB0_PIF_LANE6_OVRD__RXPGENABLE_OVRD_EN_6__SHIFT 0x7
#define PB0_PIF_LANE6_OVRD__ELECIDLEDETEN_OVRD_EN_6_MASK 0x100
#define PB0_PIF_LANE6_OVRD__ELECIDLEDETEN_OVRD_EN_6__SHIFT 0x8
#define PB0_PIF_LANE6_OVRD__ENABLEFOM_OVRD_EN_6_MASK 0x200
#define PB0_PIF_LANE6_OVRD__ENABLEFOM_OVRD_EN_6__SHIFT 0x9
#define PB0_PIF_LANE6_OVRD__REQUESTFOM_OVRD_EN_6_MASK 0x400
#define PB0_PIF_LANE6_OVRD__REQUESTFOM_OVRD_EN_6__SHIFT 0xa
#define PB0_PIF_LANE6_OVRD__RESPONSEMODE_OVRD_EN_6_MASK 0x800
#define PB0_PIF_LANE6_OVRD__RESPONSEMODE_OVRD_EN_6__SHIFT 0xb
#define PB0_PIF_LANE6_OVRD__REQUESTTRK_OVRD_EN_6_MASK 0x1000
#define PB0_PIF_LANE6_OVRD__REQUESTTRK_OVRD_EN_6__SHIFT 0xc
#define PB0_PIF_LANE6_OVRD__REQUESTTRN_OVRD_EN_6_MASK 0x2000
#define PB0_PIF_LANE6_OVRD__REQUESTTRN_OVRD_EN_6__SHIFT 0xd
#define PB0_PIF_LANE6_OVRD__COEFFICIENTID_OVRD_EN_6_MASK 0x4000
#define PB0_PIF_LANE6_OVRD__COEFFICIENTID_OVRD_EN_6__SHIFT 0xe
#define PB0_PIF_LANE6_OVRD__COEFFICIENT_OVRD_EN_6_MASK 0x8000
#define PB0_PIF_LANE6_OVRD__COEFFICIENT_OVRD_EN_6__SHIFT 0xf
#define PB0_PIF_LANE6_OVRD__CDREN_OVRD_EN_6_MASK 0x10000
#define PB0_PIF_LANE6_OVRD__CDREN_OVRD_EN_6__SHIFT 0x10
#define PB0_PIF_LANE6_OVRD__CDREN_OVRD_VAL_6_MASK 0x20000
#define PB0_PIF_LANE6_OVRD__CDREN_OVRD_VAL_6__SHIFT 0x11
#define PB0_PIF_LANE6_OVRD2__GANGMODE_6_MASK 0x7
#define PB0_PIF_LANE6_OVRD2__GANGMODE_6__SHIFT 0x0
#define PB0_PIF_LANE6_OVRD2__FREQDIV_6_MASK 0x18
#define PB0_PIF_LANE6_OVRD2__FREQDIV_6__SHIFT 0x3
#define PB0_PIF_LANE6_OVRD2__LINKSPEED_6_MASK 0x60
#define PB0_PIF_LANE6_OVRD2__LINKSPEED_6__SHIFT 0x5
#define PB0_PIF_LANE6_OVRD2__TWOSYMENABLE_6_MASK 0x80
#define PB0_PIF_LANE6_OVRD2__TWOSYMENABLE_6__SHIFT 0x7
#define PB0_PIF_LANE6_OVRD2__TXPWR_6_MASK 0x700
#define PB0_PIF_LANE6_OVRD2__TXPWR_6__SHIFT 0x8
#define PB0_PIF_LANE6_OVRD2__TXPGENABLE_6_MASK 0x1800
#define PB0_PIF_LANE6_OVRD2__TXPGENABLE_6__SHIFT 0xb
#define PB0_PIF_LANE6_OVRD2__RXPWR_6_MASK 0xe000
#define PB0_PIF_LANE6_OVRD2__RXPWR_6__SHIFT 0xd
#define PB0_PIF_LANE6_OVRD2__RXPGENABLE_6_MASK 0x30000
#define PB0_PIF_LANE6_OVRD2__RXPGENABLE_6__SHIFT 0x10
#define PB0_PIF_LANE6_OVRD2__ELECIDLEDETEN_6_MASK 0x40000
#define PB0_PIF_LANE6_OVRD2__ELECIDLEDETEN_6__SHIFT 0x12
#define PB0_PIF_LANE6_OVRD2__ENABLEFOM_6_MASK 0x80000
#define PB0_PIF_LANE6_OVRD2__ENABLEFOM_6__SHIFT 0x13
#define PB0_PIF_LANE6_OVRD2__REQUESTFOM_6_MASK 0x100000
#define PB0_PIF_LANE6_OVRD2__REQUESTFOM_6__SHIFT 0x14
#define PB0_PIF_LANE6_OVRD2__RESPONSEMODE_6_MASK 0x200000
#define PB0_PIF_LANE6_OVRD2__RESPONSEMODE_6__SHIFT 0x15
#define PB0_PIF_LANE6_OVRD2__REQUESTTRK_6_MASK 0x400000
#define PB0_PIF_LANE6_OVRD2__REQUESTTRK_6__SHIFT 0x16
#define PB0_PIF_LANE6_OVRD2__REQUESTTRN_6_MASK 0x800000
#define PB0_PIF_LANE6_OVRD2__REQUESTTRN_6__SHIFT 0x17
#define PB0_PIF_LANE6_OVRD2__COEFFICIENTID_6_MASK 0x3000000
#define PB0_PIF_LANE6_OVRD2__COEFFICIENTID_6__SHIFT 0x18
#define PB0_PIF_LANE6_OVRD2__COEFFICIENT_6_MASK 0xfc000000
#define PB0_PIF_LANE6_OVRD2__COEFFICIENT_6__SHIFT 0x1a
#define PB0_PIF_LANE7_OVRD__GANGMODE_OVRD_EN_7_MASK 0x1
#define PB0_PIF_LANE7_OVRD__GANGMODE_OVRD_EN_7__SHIFT 0x0
#define PB0_PIF_LANE7_OVRD__FREQDIV_OVRD_EN_7_MASK 0x2
#define PB0_PIF_LANE7_OVRD__FREQDIV_OVRD_EN_7__SHIFT 0x1
#define PB0_PIF_LANE7_OVRD__LINKSPEED_OVRD_EN_7_MASK 0x4
#define PB0_PIF_LANE7_OVRD__LINKSPEED_OVRD_EN_7__SHIFT 0x2
#define PB0_PIF_LANE7_OVRD__TWOSYMENABLE_OVRD_EN_7_MASK 0x8
#define PB0_PIF_LANE7_OVRD__TWOSYMENABLE_OVRD_EN_7__SHIFT 0x3
#define PB0_PIF_LANE7_OVRD__TXPWR_OVRD_EN_7_MASK 0x10
#define PB0_PIF_LANE7_OVRD__TXPWR_OVRD_EN_7__SHIFT 0x4
#define PB0_PIF_LANE7_OVRD__TXPGENABLE_OVRD_EN_7_MASK 0x20
#define PB0_PIF_LANE7_OVRD__TXPGENABLE_OVRD_EN_7__SHIFT 0x5
#define PB0_PIF_LANE7_OVRD__RXPWR_OVRD_EN_7_MASK 0x40
#define PB0_PIF_LANE7_OVRD__RXPWR_OVRD_EN_7__SHIFT 0x6
#define PB0_PIF_LANE7_OVRD__RXPGENABLE_OVRD_EN_7_MASK 0x80
#define PB0_PIF_LANE7_OVRD__RXPGENABLE_OVRD_EN_7__SHIFT 0x7
#define PB0_PIF_LANE7_OVRD__ELECIDLEDETEN_OVRD_EN_7_MASK 0x100
#define PB0_PIF_LANE7_OVRD__ELECIDLEDETEN_OVRD_EN_7__SHIFT 0x8
#define PB0_PIF_LANE7_OVRD__ENABLEFOM_OVRD_EN_7_MASK 0x200
#define PB0_PIF_LANE7_OVRD__ENABLEFOM_OVRD_EN_7__SHIFT 0x9
#define PB0_PIF_LANE7_OVRD__REQUESTFOM_OVRD_EN_7_MASK 0x400
#define PB0_PIF_LANE7_OVRD__REQUESTFOM_OVRD_EN_7__SHIFT 0xa
#define PB0_PIF_LANE7_OVRD__RESPONSEMODE_OVRD_EN_7_MASK 0x800
#define PB0_PIF_LANE7_OVRD__RESPONSEMODE_OVRD_EN_7__SHIFT 0xb
#define PB0_PIF_LANE7_OVRD__REQUESTTRK_OVRD_EN_7_MASK 0x1000
#define PB0_PIF_LANE7_OVRD__REQUESTTRK_OVRD_EN_7__SHIFT 0xc
#define PB0_PIF_LANE7_OVRD__REQUESTTRN_OVRD_EN_7_MASK 0x2000
#define PB0_PIF_LANE7_OVRD__REQUESTTRN_OVRD_EN_7__SHIFT 0xd
#define PB0_PIF_LANE7_OVRD__COEFFICIENTID_OVRD_EN_7_MASK 0x4000
#define PB0_PIF_LANE7_OVRD__COEFFICIENTID_OVRD_EN_7__SHIFT 0xe
#define PB0_PIF_LANE7_OVRD__COEFFICIENT_OVRD_EN_7_MASK 0x8000
#define PB0_PIF_LANE7_OVRD__COEFFICIENT_OVRD_EN_7__SHIFT 0xf
#define PB0_PIF_LANE7_OVRD__CDREN_OVRD_EN_7_MASK 0x10000
#define PB0_PIF_LANE7_OVRD__CDREN_OVRD_EN_7__SHIFT 0x10
#define PB0_PIF_LANE7_OVRD__CDREN_OVRD_VAL_7_MASK 0x20000
#define PB0_PIF_LANE7_OVRD__CDREN_OVRD_VAL_7__SHIFT 0x11
#define PB0_PIF_LANE7_OVRD2__GANGMODE_7_MASK 0x7
#define PB0_PIF_LANE7_OVRD2__GANGMODE_7__SHIFT 0x0
#define PB0_PIF_LANE7_OVRD2__FREQDIV_7_MASK 0x18
#define PB0_PIF_LANE7_OVRD2__FREQDIV_7__SHIFT 0x3
#define PB0_PIF_LANE7_OVRD2__LINKSPEED_7_MASK 0x60
#define PB0_PIF_LANE7_OVRD2__LINKSPEED_7__SHIFT 0x5
#define PB0_PIF_LANE7_OVRD2__TWOSYMENABLE_7_MASK 0x80
#define PB0_PIF_LANE7_OVRD2__TWOSYMENABLE_7__SHIFT 0x7
#define PB0_PIF_LANE7_OVRD2__TXPWR_7_MASK 0x700
#define PB0_PIF_LANE7_OVRD2__TXPWR_7__SHIFT 0x8
#define PB0_PIF_LANE7_OVRD2__TXPGENABLE_7_MASK 0x1800
#define PB0_PIF_LANE7_OVRD2__TXPGENABLE_7__SHIFT 0xb
#define PB0_PIF_LANE7_OVRD2__RXPWR_7_MASK 0xe000
#define PB0_PIF_LANE7_OVRD2__RXPWR_7__SHIFT 0xd
#define PB0_PIF_LANE7_OVRD2__RXPGENABLE_7_MASK 0x30000
#define PB0_PIF_LANE7_OVRD2__RXPGENABLE_7__SHIFT 0x10
#define PB0_PIF_LANE7_OVRD2__ELECIDLEDETEN_7_MASK 0x40000
#define PB0_PIF_LANE7_OVRD2__ELECIDLEDETEN_7__SHIFT 0x12
#define PB0_PIF_LANE7_OVRD2__ENABLEFOM_7_MASK 0x80000
#define PB0_PIF_LANE7_OVRD2__ENABLEFOM_7__SHIFT 0x13
#define PB0_PIF_LANE7_OVRD2__REQUESTFOM_7_MASK 0x100000
#define PB0_PIF_LANE7_OVRD2__REQUESTFOM_7__SHIFT 0x14
#define PB0_PIF_LANE7_OVRD2__RESPONSEMODE_7_MASK 0x200000
#define PB0_PIF_LANE7_OVRD2__RESPONSEMODE_7__SHIFT 0x15
#define PB0_PIF_LANE7_OVRD2__REQUESTTRK_7_MASK 0x400000
#define PB0_PIF_LANE7_OVRD2__REQUESTTRK_7__SHIFT 0x16
#define PB0_PIF_LANE7_OVRD2__REQUESTTRN_7_MASK 0x800000
#define PB0_PIF_LANE7_OVRD2__REQUESTTRN_7__SHIFT 0x17
#define PB0_PIF_LANE7_OVRD2__COEFFICIENTID_7_MASK 0x3000000
#define PB0_PIF_LANE7_OVRD2__COEFFICIENTID_7__SHIFT 0x18
#define PB0_PIF_LANE7_OVRD2__COEFFICIENT_7_MASK 0xfc000000
#define PB0_PIF_LANE7_OVRD2__COEFFICIENT_7__SHIFT 0x1a
#define PB1_PIF_SCRATCH__PIF_SCRATCH_MASK 0xffffffff
#define PB1_PIF_SCRATCH__PIF_SCRATCH__SHIFT 0x0
#define PB1_PIF_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PB1_PIF_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PB1_PIF_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PB1_PIF_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PB1_PIF_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PB1_PIF_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PB1_PIF_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PB1_PIF_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PB1_PIF_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PB1_PIF_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PB1_PIF_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PB1_PIF_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PB1_PIF_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PB1_PIF_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PB1_PIF_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PB1_PIF_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PB1_PIF_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PB1_PIF_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PB1_PIF_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PB1_PIF_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PB1_PIF_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PB1_PIF_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PB1_PIF_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PB1_PIF_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PB1_PIF_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PB1_PIF_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PB1_PIF_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PB1_PIF_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PB1_PIF_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PB1_PIF_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PB1_PIF_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PB1_PIF_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PB1_PIF_STRAP_0__STRAP_TX_RDY_XTND_DIS_MASK 0x2
#define PB1_PIF_STRAP_0__STRAP_TX_RDY_XTND_DIS__SHIFT 0x1
#define PB1_PIF_STRAP_0__STRAP_RX_RDY_XTND_DIS_MASK 0x4
#define PB1_PIF_STRAP_0__STRAP_RX_RDY_XTND_DIS__SHIFT 0x2
#define PB1_PIF_STRAP_0__STRAP_TX_STATUS_XTND_DIS_MASK 0x8
#define PB1_PIF_STRAP_0__STRAP_TX_STATUS_XTND_DIS__SHIFT 0x3
#define PB1_PIF_STRAP_0__STRAP_RX_STATUS_XTND_DIS_MASK 0x10
#define PB1_PIF_STRAP_0__STRAP_RX_STATUS_XTND_DIS__SHIFT 0x4
#define PB1_PIF_STRAP_0__STRAP_FORCE_OWN_MSTR_MASK 0x20
#define PB1_PIF_STRAP_0__STRAP_FORCE_OWN_MSTR__SHIFT 0x5
#define PB1_PIF_STRAP_0__STRAP_PIF_CDR_EN_MODE_MASK 0xc0
#define PB1_PIF_STRAP_0__STRAP_PIF_CDR_EN_MODE__SHIFT 0x6
#define PB1_PIF_STRAP_0__STRAP_RX_EI_FILTER_MASK 0x300
#define PB1_PIF_STRAP_0__STRAP_RX_EI_FILTER__SHIFT 0x8
#define PB1_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS1_MASK 0x400
#define PB1_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS1__SHIFT 0xa
#define PB1_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS2_MASK 0x800
#define PB1_PIF_STRAP_0__STRAP_RX_DIS_HLD_EIE_IN_PS2__SHIFT 0xb
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_12_MASK 0x1000
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_12__SHIFT 0xc
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_13_MASK 0x2000
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_13__SHIFT 0xd
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_14_MASK 0x4000
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_14__SHIFT 0xe
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_15_MASK 0x8000
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_15__SHIFT 0xf
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_16_MASK 0x10000
#define PB1_PIF_STRAP_0__STRAP_PIF_BIT_16__SHIFT 0x10
#define PB1_PIF_CTRL__PIF_PLL_PWRDN_EN_MASK 0x1
#define PB1_PIF_CTRL__PIF_PLL_PWRDN_EN__SHIFT 0x0
#define PB1_PIF_CTRL__DTM_FORCE_FREQDIV_X1_MASK 0x2
#define PB1_PIF_CTRL__DTM_FORCE_FREQDIV_X1__SHIFT 0x1
#define PB1_PIF_CTRL__PIF_PLL_HNDSHK_EARLY_ABORT_MASK 0x4
#define PB1_PIF_CTRL__PIF_PLL_HNDSHK_EARLY_ABORT__SHIFT 0x2
#define PB1_PIF_CTRL__PIF_PLL_PWRDN_EARLY_EXIT_MASK 0x8
#define PB1_PIF_CTRL__PIF_PLL_PWRDN_EARLY_EXIT__SHIFT 0x3
#define PB1_PIF_CTRL__PHY_RST_PWROK_VDD_MASK 0x10
#define PB1_PIF_CTRL__PHY_RST_PWROK_VDD__SHIFT 0x4
#define PB1_PIF_CTRL__PIF_PLL_STATUS_MASK 0xc0
#define PB1_PIF_CTRL__PIF_PLL_STATUS__SHIFT 0x6
#define PB1_PIF_CTRL__PIF_PLL_DEGRADE_OFF_VOTE_MASK 0x100
#define PB1_PIF_CTRL__PIF_PLL_DEGRADE_OFF_VOTE__SHIFT 0x8
#define PB1_PIF_CTRL__PIF_PLL_UNUSED_OFF_VOTE_MASK 0x200
#define PB1_PIF_CTRL__PIF_PLL_UNUSED_OFF_VOTE__SHIFT 0x9
#define PB1_PIF_CTRL__PIF_PLL_DEGRADE_S2_VOTE_MASK 0x400
#define PB1_PIF_CTRL__PIF_PLL_DEGRADE_S2_VOTE__SHIFT 0xa
#define PB1_PIF_CTRL__PIF_PG_EXIT_MODE_MASK 0x800
#define PB1_PIF_CTRL__PIF_PG_EXIT_MODE__SHIFT 0xb
#define PB1_PIF_CTRL__PIF_DEGRADE_PWR_PLL_MODE_MASK 0x1000
#define PB1_PIF_CTRL__PIF_DEGRADE_PWR_PLL_MODE__SHIFT 0xc
#define PB1_PIF_CTRL__PIF_LANEUNUSED_AFFECT_GANG_MASK 0x2000
#define PB1_PIF_CTRL__PIF_LANEUNUSED_AFFECT_GANG__SHIFT 0xd
#define PB1_PIF_CTRL__PIF_PG_ABORT_DISABLE_MASK 0x4000
#define PB1_PIF_CTRL__PIF_PG_ABORT_DISABLE__SHIFT 0xe
#define PB1_PIF_TX_CTRL__TXPWR_IN_S2_MASK 0x7
#define PB1_PIF_TX_CTRL__TXPWR_IN_S2__SHIFT 0x0
#define PB1_PIF_TX_CTRL__TXPWR_IN_SPDCHNG_MASK 0x38
#define PB1_PIF_TX_CTRL__TXPWR_IN_SPDCHNG__SHIFT 0x3
#define PB1_PIF_TX_CTRL__TXPWR_IN_OFF_MASK 0x1c0
#define PB1_PIF_TX_CTRL__TXPWR_IN_OFF__SHIFT 0x6
#define PB1_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MASK 0xe00
#define PB1_PIF_TX_CTRL__TXPWR_IN_DEGRADE__SHIFT 0x9
#define PB1_PIF_TX_CTRL__TXPWR_IN_UNUSED_MASK 0x7000
#define PB1_PIF_TX_CTRL__TXPWR_IN_UNUSED__SHIFT 0xc
#define PB1_PIF_TX_CTRL__TXPWR_IN_INIT_MASK 0x38000
#define PB1_PIF_TX_CTRL__TXPWR_IN_INIT__SHIFT 0xf
#define PB1_PIF_TX_CTRL__TXPWR_IN_PLL_OFF_MASK 0x1c0000
#define PB1_PIF_TX_CTRL__TXPWR_IN_PLL_OFF__SHIFT 0x12
#define PB1_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MODE_MASK 0x200000
#define PB1_PIF_TX_CTRL__TXPWR_IN_DEGRADE_MODE__SHIFT 0x15
#define PB1_PIF_TX_CTRL__TXPWR_IN_UNUSED_MODE_MASK 0x400000
#define PB1_PIF_TX_CTRL__TXPWR_IN_UNUSED_MODE__SHIFT 0x16
#define PB1_PIF_TX_CTRL__TXPWR_GATING_IN_L1_MASK 0x800000
#define PB1_PIF_TX_CTRL__TXPWR_GATING_IN_L1__SHIFT 0x17
#define PB1_PIF_TX_CTRL__TXPWR_GATING_IN_UNUSED_MASK 0x1000000
#define PB1_PIF_TX_CTRL__TXPWR_GATING_IN_UNUSED__SHIFT 0x18
#define PB1_PIF_TX_CTRL2__TX_RDY_DASRT_COUNT_MASK 0x7
#define PB1_PIF_TX_CTRL2__TX_RDY_DASRT_COUNT__SHIFT 0x0
#define PB1_PIF_TX_CTRL2__TX_STATUS_DASRT_COUNT_MASK 0x38
#define PB1_PIF_TX_CTRL2__TX_STATUS_DASRT_COUNT__SHIFT 0x3
#define PB1_PIF_TX_CTRL2__TXPHYSTATUS_DELAY_MASK 0x1c0
#define PB1_PIF_TX_CTRL2__TXPHYSTATUS_DELAY__SHIFT 0x6
#define PB1_PIF_TX_CTRL2__TX_L1_PG_PHY_STATUS_MODE_MASK 0x200
#define PB1_PIF_TX_CTRL2__TX_L1_PG_PHY_STATUS_MODE__SHIFT 0x9
#define PB1_PIF_TX_CTRL2__TX_OFF_PG_PHY_STATUS_MODE_MASK 0x400
#define PB1_PIF_TX_CTRL2__TX_OFF_PG_PHY_STATUS_MODE__SHIFT 0xa
#define PB1_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MP_MASK 0x10000
#define PB1_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MP__SHIFT 0x10
#define PB1_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MODE_MASK 0x60000
#define PB1_PIF_TX_CTRL2__TX_HIGH_IMP_STAG_MODE__SHIFT 0x11
#define PB1_PIF_TX_CTRL2__TX_FORCE_DATA_VALID_MASK 0x200000
#define PB1_PIF_TX_CTRL2__TX_FORCE_DATA_VALID__SHIFT 0x15
#define PB1_PIF_TX_CTRL2__TX_L0_TO_HIZ_DLY_MASK 0x1c00000
#define PB1_PIF_TX_CTRL2__TX_L0_TO_HIZ_DLY__SHIFT 0x16
#define PB1_PIF_TX_CTRL2__TX_FIFO_INIT_UPCONFIG_MASK 0x2000000
#define PB1_PIF_TX_CTRL2__TX_FIFO_INIT_UPCONFIG__SHIFT 0x19
#define PB1_PIF_TX_CTRL2__TX_HIZ_TO_L0_DLY_MASK 0x1c000000
#define PB1_PIF_TX_CTRL2__TX_HIZ_TO_L0_DLY__SHIFT 0x1a
#define PB1_PIF_TX_CTRL2__TX_LINKSPEED_ACK_IN_S2_MASK 0x20000000
#define PB1_PIF_TX_CTRL2__TX_LINKSPEED_ACK_IN_S2__SHIFT 0x1d
#define PB1_PIF_TX_CTRL2__TX_DELAY_FIFO_INIT_IN_S1_MASK 0x40000000
#define PB1_PIF_TX_CTRL2__TX_DELAY_FIFO_INIT_IN_S1__SHIFT 0x1e
#define PB1_PIF_RX_CTRL__RXPWR_IN_S2_MASK 0x7
#define PB1_PIF_RX_CTRL__RXPWR_IN_S2__SHIFT 0x0
#define PB1_PIF_RX_CTRL__RXPWR_IN_SPDCHNG_MASK 0x38
#define PB1_PIF_RX_CTRL__RXPWR_IN_SPDCHNG__SHIFT 0x3
#define PB1_PIF_RX_CTRL__RXPWR_IN_OFF_MASK 0x1c0
#define PB1_PIF_RX_CTRL__RXPWR_IN_OFF__SHIFT 0x6
#define PB1_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MASK 0xe00
#define PB1_PIF_RX_CTRL__RXPWR_IN_DEGRADE__SHIFT 0x9
#define PB1_PIF_RX_CTRL__RXPWR_IN_UNUSED_MASK 0x7000
#define PB1_PIF_RX_CTRL__RXPWR_IN_UNUSED__SHIFT 0xc
#define PB1_PIF_RX_CTRL__RXPWR_IN_INIT_MASK 0x38000
#define PB1_PIF_RX_CTRL__RXPWR_IN_INIT__SHIFT 0xf
#define PB1_PIF_RX_CTRL__RXPWR_IN_PLL_OFF_MASK 0x1c0000
#define PB1_PIF_RX_CTRL__RXPWR_IN_PLL_OFF__SHIFT 0x12
#define PB1_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MODE_MASK 0x200000
#define PB1_PIF_RX_CTRL__RXPWR_IN_DEGRADE_MODE__SHIFT 0x15
#define PB1_PIF_RX_CTRL__RXPWR_IN_UNUSED_MODE_MASK 0x400000
#define PB1_PIF_RX_CTRL__RXPWR_IN_UNUSED_MODE__SHIFT 0x16
#define PB1_PIF_RX_CTRL__RXPWR_GATING_IN_L1_MASK 0x800000
#define PB1_PIF_RX_CTRL__RXPWR_GATING_IN_L1__SHIFT 0x17
#define PB1_PIF_RX_CTRL__RXPWR_GATING_IN_UNUSED_MASK 0x1000000
#define PB1_PIF_RX_CTRL__RXPWR_GATING_IN_UNUSED__SHIFT 0x18
#define PB1_PIF_RX_CTRL__RX_HLD_EIE_COUNT_MASK 0x2000000
#define PB1_PIF_RX_CTRL__RX_HLD_EIE_COUNT__SHIFT 0x19
#define PB1_PIF_RX_CTRL__RX_EI_DET_IN_PS2_DEGRADE_MASK 0x4000000
#define PB1_PIF_RX_CTRL__RX_EI_DET_IN_PS2_DEGRADE__SHIFT 0x1a
#define PB1_PIF_RX_CTRL2__RX_RDY_DASRT_COUNT_MASK 0x7
#define PB1_PIF_RX_CTRL2__RX_RDY_DASRT_COUNT__SHIFT 0x0
#define PB1_PIF_RX_CTRL2__RX_STATUS_DASRT_COUNT_MASK 0x38
#define PB1_PIF_RX_CTRL2__RX_STATUS_DASRT_COUNT__SHIFT 0x3
#define PB1_PIF_RX_CTRL2__RXPHYSTATUS_DELAY_MASK 0x1c0
#define PB1_PIF_RX_CTRL2__RXPHYSTATUS_DELAY__SHIFT 0x6
#define PB1_PIF_RX_CTRL2__RX_L1_PG_PHY_STATUS_MODE_MASK 0x200
#define PB1_PIF_RX_CTRL2__RX_L1_PG_PHY_STATUS_MODE__SHIFT 0x9
#define PB1_PIF_RX_CTRL2__RX_OFF_PG_PHY_STATUS_MODE_MASK 0x400
#define PB1_PIF_RX_CTRL2__RX_OFF_PG_PHY_STATUS_MODE__SHIFT 0xa
#define PB1_PIF_RX_CTRL2__FORCE_CDREN_IN_L0S_MASK 0x10000
#define PB1_PIF_RX_CTRL2__FORCE_CDREN_IN_L0S__SHIFT 0x10
#define PB1_PIF_RX_CTRL2__EI_DET_CYCLE_MODE_MASK 0x60000
#define PB1_PIF_RX_CTRL2__EI_DET_CYCLE_MODE__SHIFT 0x11
#define PB1_PIF_RX_CTRL2__EI_DET_ON_TIME_MASK 0x180000
#define PB1_PIF_RX_CTRL2__EI_DET_ON_TIME__SHIFT 0x13
#define PB1_PIF_RX_CTRL2__EI_DET_OFF_TIME_MASK 0xe00000
#define PB1_PIF_RX_CTRL2__EI_DET_OFF_TIME__SHIFT 0x15
#define PB1_PIF_RX_CTRL2__EI_DET_CYCLE_DIS_IN_PS1_MASK 0x1000000
#define PB1_PIF_RX_CTRL2__EI_DET_CYCLE_DIS_IN_PS1__SHIFT 0x18
#define PB1_PIF_RX_CTRL2__RX_CDR_XTND_MODE_MASK 0x6000000
#define PB1_PIF_RX_CTRL2__RX_CDR_XTND_MODE__SHIFT 0x19
#define PB1_PIF_RX_CTRL2__RX_L0S_TO_L0_DETECT_EI_MASK 0x8000000
#define PB1_PIF_RX_CTRL2__RX_L0S_TO_L0_DETECT_EI__SHIFT 0x1b
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_0_MASK 0x1
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_0__SHIFT 0x0
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_1_MASK 0x2
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_1__SHIFT 0x1
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_2_MASK 0x4
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_2__SHIFT 0x2
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_3_MASK 0x8
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_3__SHIFT 0x3
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_4_MASK 0x10
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_4__SHIFT 0x4
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_5_MASK 0x20
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_5__SHIFT 0x5
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_6_MASK 0x40
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_6__SHIFT 0x6
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_7_MASK 0x80
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_VAL_7__SHIFT 0x7
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_EN_MASK 0x10000
#define PB1_PIF_GLB_OVRD__RXDETECT_OVERRIDE_EN__SHIFT 0x10
#define PB1_PIF_GLB_OVRD2__X2_LANE_1_0_OVRD_MASK 0x1
#define PB1_PIF_GLB_OVRD2__X2_LANE_1_0_OVRD__SHIFT 0x0
#define PB1_PIF_GLB_OVRD2__X2_LANE_3_2_OVRD_MASK 0x2
#define PB1_PIF_GLB_OVRD2__X2_LANE_3_2_OVRD__SHIFT 0x1
#define PB1_PIF_GLB_OVRD2__X2_LANE_5_4_OVRD_MASK 0x4
#define PB1_PIF_GLB_OVRD2__X2_LANE_5_4_OVRD__SHIFT 0x2
#define PB1_PIF_GLB_OVRD2__X2_LANE_7_6_OVRD_MASK 0x8
#define PB1_PIF_GLB_OVRD2__X2_LANE_7_6_OVRD__SHIFT 0x3
#define PB1_PIF_GLB_OVRD2__X2_LANE_9_8_OVRD_MASK 0x10
#define PB1_PIF_GLB_OVRD2__X2_LANE_9_8_OVRD__SHIFT 0x4
#define PB1_PIF_GLB_OVRD2__X2_LANE_11_10_OVRD_MASK 0x20
#define PB1_PIF_GLB_OVRD2__X2_LANE_11_10_OVRD__SHIFT 0x5
#define PB1_PIF_GLB_OVRD2__X2_LANE_13_12_OVRD_MASK 0x40
#define PB1_PIF_GLB_OVRD2__X2_LANE_13_12_OVRD__SHIFT 0x6
#define PB1_PIF_GLB_OVRD2__X2_LANE_15_14_OVRD_MASK 0x80
#define PB1_PIF_GLB_OVRD2__X2_LANE_15_14_OVRD__SHIFT 0x7
#define PB1_PIF_GLB_OVRD2__X4_LANE_3_0_OVRD_MASK 0x100
#define PB1_PIF_GLB_OVRD2__X4_LANE_3_0_OVRD__SHIFT 0x8
#define PB1_PIF_GLB_OVRD2__X4_LANE_7_4_OVRD_MASK 0x200
#define PB1_PIF_GLB_OVRD2__X4_LANE_7_4_OVRD__SHIFT 0x9
#define PB1_PIF_GLB_OVRD2__X4_LANE_11_8_OVRD_MASK 0x400
#define PB1_PIF_GLB_OVRD2__X4_LANE_11_8_OVRD__SHIFT 0xa
#define PB1_PIF_GLB_OVRD2__X4_LANE_15_12_OVRD_MASK 0x800
#define PB1_PIF_GLB_OVRD2__X4_LANE_15_12_OVRD__SHIFT 0xb
#define PB1_PIF_GLB_OVRD2__X8_LANE_7_0_OVRD_MASK 0x10000
#define PB1_PIF_GLB_OVRD2__X8_LANE_7_0_OVRD__SHIFT 0x10
#define PB1_PIF_GLB_OVRD2__X8_LANE_15_8_OVRD_MASK 0x20000
#define PB1_PIF_GLB_OVRD2__X8_LANE_15_8_OVRD__SHIFT 0x11
#define PB1_PIF_GLB_OVRD2__X16_LANE_15_0_OVRD_MASK 0x100000
#define PB1_PIF_GLB_OVRD2__X16_LANE_15_0_OVRD__SHIFT 0x14
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_0_MASK 0x1
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_0__SHIFT 0x0
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_1_MASK 0x2
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_1__SHIFT 0x1
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_2_MASK 0x4
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_2__SHIFT 0x2
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_3_MASK 0x8
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_3__SHIFT 0x3
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_4_MASK 0x10
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_4__SHIFT 0x4
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_5_MASK 0x20
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_5__SHIFT 0x5
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_6_MASK 0x40
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_6__SHIFT 0x6
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_7_MASK 0x80
#define PB1_PIF_BIF_CMD_STATUS__TXPHYSTATUS_7__SHIFT 0x7
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_0_MASK 0x100
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_0__SHIFT 0x8
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_1_MASK 0x200
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_1__SHIFT 0x9
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_2_MASK 0x400
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_2__SHIFT 0xa
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_3_MASK 0x800
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_3__SHIFT 0xb
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_4_MASK 0x1000
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_4__SHIFT 0xc
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_5_MASK 0x2000
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_5__SHIFT 0xd
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_6_MASK 0x4000
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_6__SHIFT 0xe
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_7_MASK 0x8000
#define PB1_PIF_BIF_CMD_STATUS__RXPHYSTATUS_7__SHIFT 0xf
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_0_MASK 0x10000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_0__SHIFT 0x10
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_1_MASK 0x20000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_1__SHIFT 0x11
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_2_MASK 0x40000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_2__SHIFT 0x12
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_3_MASK 0x80000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_3__SHIFT 0x13
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_4_MASK 0x100000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_4__SHIFT 0x14
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_5_MASK 0x200000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_5__SHIFT 0x15
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_6_MASK 0x400000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_6__SHIFT 0x16
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_7_MASK 0x800000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_TX_RDY_7__SHIFT 0x17
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_0_MASK 0x1000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_0__SHIFT 0x18
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_1_MASK 0x2000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_1__SHIFT 0x19
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_2_MASK 0x4000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_2__SHIFT 0x1a
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_3_MASK 0x8000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_3__SHIFT 0x1b
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_4_MASK 0x10000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_4__SHIFT 0x1c
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_5_MASK 0x20000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_5__SHIFT 0x1d
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_6_MASK 0x40000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_6__SHIFT 0x1e
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_7_MASK 0x80000000
#define PB1_PIF_BIF_CMD_STATUS__BPHY_CORE_RX_RDY_7__SHIFT 0x1f
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_SCHL_MODE_MASK 0x3
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_SCHL_MODE__SHIFT 0x0
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_MODE_MASK 0xc
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_MODE__SHIFT 0x2
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_DIS_MASK 0x10
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_STAG_DIS__SHIFT 0x4
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_SCH_REQ_MODE_MASK 0x60
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_SCH_REQ_MODE__SHIFT 0x5
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PEND_PWR_MASK 0x80
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PEND_PWR__SHIFT 0x7
#define PB1_PIF_CMD_BUS_CTRL__SEND_GANGED_MODE_UPDATE_FOR_OFFPG_LANES_MASK 0x100
#define PB1_PIF_CMD_BUS_CTRL__SEND_GANGED_MODE_UPDATE_FOR_OFFPG_LANES__SHIFT 0x8
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PWR_NOT_ON_MASK 0x200
#define PB1_PIF_CMD_BUS_CTRL__CMD_BUS_IGNR_PWR_NOT_ON__SHIFT 0x9
#define PB1_PIF_CMD_BUS_GLB_OVRD__TXMARG_OVRD_EN_MASK 0x1
#define PB1_PIF_CMD_BUS_GLB_OVRD__TXMARG_OVRD_EN__SHIFT 0x0
#define PB1_PIF_CMD_BUS_GLB_OVRD__DEEMPH_OVRD_EN_MASK 0x2
#define PB1_PIF_CMD_BUS_GLB_OVRD__DEEMPH_OVRD_EN__SHIFT 0x1
#define PB1_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_OVRD_EN_MASK 0x4
#define PB1_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_OVRD_EN__SHIFT 0x2
#define PB1_PIF_CMD_BUS_GLB_OVRD__TXMARG_MASK 0x38
#define PB1_PIF_CMD_BUS_GLB_OVRD__TXMARG__SHIFT 0x3
#define PB1_PIF_CMD_BUS_GLB_OVRD__DEEMPH_MASK 0x40
#define PB1_PIF_CMD_BUS_GLB_OVRD__DEEMPH__SHIFT 0x6
#define PB1_PIF_CMD_BUS_GLB_OVRD__PLLFREQ_MASK 0x180
#define PB1_PIF_CMD_BUS_GLB_OVRD__PLLFREQ__SHIFT 0x7
#define PB1_PIF_CMD_BUS_GLB_OVRD__RESPONSEMODE_PIF_OVRD_MASK 0x200
#define PB1_PIF_CMD_BUS_GLB_OVRD__RESPONSEMODE_PIF_OVRD__SHIFT 0x9
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_0_MASK 0x10000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_0__SHIFT 0x10
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_1_MASK 0x20000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_1__SHIFT 0x11
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_2_MASK 0x40000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_2__SHIFT 0x12
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_3_MASK 0x80000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_3__SHIFT 0x13
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_4_MASK 0x100000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_4__SHIFT 0x14
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_5_MASK 0x200000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_5__SHIFT 0x15
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_6_MASK 0x400000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_6__SHIFT 0x16
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_7_MASK 0x800000
#define PB1_PIF_CMD_BUS_GLB_OVRD__CMD_BUS_LANE_DIS_7__SHIFT 0x17
#define PB1_PIF_LANE0_OVRD__GANGMODE_OVRD_EN_0_MASK 0x1
#define PB1_PIF_LANE0_OVRD__GANGMODE_OVRD_EN_0__SHIFT 0x0
#define PB1_PIF_LANE0_OVRD__FREQDIV_OVRD_EN_0_MASK 0x2
#define PB1_PIF_LANE0_OVRD__FREQDIV_OVRD_EN_0__SHIFT 0x1
#define PB1_PIF_LANE0_OVRD__LINKSPEED_OVRD_EN_0_MASK 0x4
#define PB1_PIF_LANE0_OVRD__LINKSPEED_OVRD_EN_0__SHIFT 0x2
#define PB1_PIF_LANE0_OVRD__TWOSYMENABLE_OVRD_EN_0_MASK 0x8
#define PB1_PIF_LANE0_OVRD__TWOSYMENABLE_OVRD_EN_0__SHIFT 0x3
#define PB1_PIF_LANE0_OVRD__TXPWR_OVRD_EN_0_MASK 0x10
#define PB1_PIF_LANE0_OVRD__TXPWR_OVRD_EN_0__SHIFT 0x4
#define PB1_PIF_LANE0_OVRD__TXPGENABLE_OVRD_EN_0_MASK 0x20
#define PB1_PIF_LANE0_OVRD__TXPGENABLE_OVRD_EN_0__SHIFT 0x5
#define PB1_PIF_LANE0_OVRD__RXPWR_OVRD_EN_0_MASK 0x40
#define PB1_PIF_LANE0_OVRD__RXPWR_OVRD_EN_0__SHIFT 0x6
#define PB1_PIF_LANE0_OVRD__RXPGENABLE_OVRD_EN_0_MASK 0x80
#define PB1_PIF_LANE0_OVRD__RXPGENABLE_OVRD_EN_0__SHIFT 0x7
#define PB1_PIF_LANE0_OVRD__ELECIDLEDETEN_OVRD_EN_0_MASK 0x100
#define PB1_PIF_LANE0_OVRD__ELECIDLEDETEN_OVRD_EN_0__SHIFT 0x8
#define PB1_PIF_LANE0_OVRD__ENABLEFOM_OVRD_EN_0_MASK 0x200
#define PB1_PIF_LANE0_OVRD__ENABLEFOM_OVRD_EN_0__SHIFT 0x9
#define PB1_PIF_LANE0_OVRD__REQUESTFOM_OVRD_EN_0_MASK 0x400
#define PB1_PIF_LANE0_OVRD__REQUESTFOM_OVRD_EN_0__SHIFT 0xa
#define PB1_PIF_LANE0_OVRD__RESPONSEMODE_OVRD_EN_0_MASK 0x800
#define PB1_PIF_LANE0_OVRD__RESPONSEMODE_OVRD_EN_0__SHIFT 0xb
#define PB1_PIF_LANE0_OVRD__REQUESTTRK_OVRD_EN_0_MASK 0x1000
#define PB1_PIF_LANE0_OVRD__REQUESTTRK_OVRD_EN_0__SHIFT 0xc
#define PB1_PIF_LANE0_OVRD__REQUESTTRN_OVRD_EN_0_MASK 0x2000
#define PB1_PIF_LANE0_OVRD__REQUESTTRN_OVRD_EN_0__SHIFT 0xd
#define PB1_PIF_LANE0_OVRD__COEFFICIENTID_OVRD_EN_0_MASK 0x4000
#define PB1_PIF_LANE0_OVRD__COEFFICIENTID_OVRD_EN_0__SHIFT 0xe
#define PB1_PIF_LANE0_OVRD__COEFFICIENT_OVRD_EN_0_MASK 0x8000
#define PB1_PIF_LANE0_OVRD__COEFFICIENT_OVRD_EN_0__SHIFT 0xf
#define PB1_PIF_LANE0_OVRD__CDREN_OVRD_EN_0_MASK 0x10000
#define PB1_PIF_LANE0_OVRD__CDREN_OVRD_EN_0__SHIFT 0x10
#define PB1_PIF_LANE0_OVRD__CDREN_OVRD_VAL_0_MASK 0x20000
#define PB1_PIF_LANE0_OVRD__CDREN_OVRD_VAL_0__SHIFT 0x11
#define PB1_PIF_LANE0_OVRD2__GANGMODE_0_MASK 0x7
#define PB1_PIF_LANE0_OVRD2__GANGMODE_0__SHIFT 0x0
#define PB1_PIF_LANE0_OVRD2__FREQDIV_0_MASK 0x18
#define PB1_PIF_LANE0_OVRD2__FREQDIV_0__SHIFT 0x3
#define PB1_PIF_LANE0_OVRD2__LINKSPEED_0_MASK 0x60
#define PB1_PIF_LANE0_OVRD2__LINKSPEED_0__SHIFT 0x5
#define PB1_PIF_LANE0_OVRD2__TWOSYMENABLE_0_MASK 0x80
#define PB1_PIF_LANE0_OVRD2__TWOSYMENABLE_0__SHIFT 0x7
#define PB1_PIF_LANE0_OVRD2__TXPWR_0_MASK 0x700
#define PB1_PIF_LANE0_OVRD2__TXPWR_0__SHIFT 0x8
#define PB1_PIF_LANE0_OVRD2__TXPGENABLE_0_MASK 0x1800
#define PB1_PIF_LANE0_OVRD2__TXPGENABLE_0__SHIFT 0xb
#define PB1_PIF_LANE0_OVRD2__RXPWR_0_MASK 0xe000
#define PB1_PIF_LANE0_OVRD2__RXPWR_0__SHIFT 0xd
#define PB1_PIF_LANE0_OVRD2__RXPGENABLE_0_MASK 0x30000
#define PB1_PIF_LANE0_OVRD2__RXPGENABLE_0__SHIFT 0x10
#define PB1_PIF_LANE0_OVRD2__ELECIDLEDETEN_0_MASK 0x40000
#define PB1_PIF_LANE0_OVRD2__ELECIDLEDETEN_0__SHIFT 0x12
#define PB1_PIF_LANE0_OVRD2__ENABLEFOM_0_MASK 0x80000
#define PB1_PIF_LANE0_OVRD2__ENABLEFOM_0__SHIFT 0x13
#define PB1_PIF_LANE0_OVRD2__REQUESTFOM_0_MASK 0x100000
#define PB1_PIF_LANE0_OVRD2__REQUESTFOM_0__SHIFT 0x14
#define PB1_PIF_LANE0_OVRD2__RESPONSEMODE_0_MASK 0x200000
#define PB1_PIF_LANE0_OVRD2__RESPONSEMODE_0__SHIFT 0x15
#define PB1_PIF_LANE0_OVRD2__REQUESTTRK_0_MASK 0x400000
#define PB1_PIF_LANE0_OVRD2__REQUESTTRK_0__SHIFT 0x16
#define PB1_PIF_LANE0_OVRD2__REQUESTTRN_0_MASK 0x800000
#define PB1_PIF_LANE0_OVRD2__REQUESTTRN_0__SHIFT 0x17
#define PB1_PIF_LANE0_OVRD2__COEFFICIENTID_0_MASK 0x3000000
#define PB1_PIF_LANE0_OVRD2__COEFFICIENTID_0__SHIFT 0x18
#define PB1_PIF_LANE0_OVRD2__COEFFICIENT_0_MASK 0xfc000000
#define PB1_PIF_LANE0_OVRD2__COEFFICIENT_0__SHIFT 0x1a
#define PB1_PIF_LANE1_OVRD__GANGMODE_OVRD_EN_1_MASK 0x1
#define PB1_PIF_LANE1_OVRD__GANGMODE_OVRD_EN_1__SHIFT 0x0
#define PB1_PIF_LANE1_OVRD__FREQDIV_OVRD_EN_1_MASK 0x2
#define PB1_PIF_LANE1_OVRD__FREQDIV_OVRD_EN_1__SHIFT 0x1
#define PB1_PIF_LANE1_OVRD__LINKSPEED_OVRD_EN_1_MASK 0x4
#define PB1_PIF_LANE1_OVRD__LINKSPEED_OVRD_EN_1__SHIFT 0x2
#define PB1_PIF_LANE1_OVRD__TWOSYMENABLE_OVRD_EN_1_MASK 0x8
#define PB1_PIF_LANE1_OVRD__TWOSYMENABLE_OVRD_EN_1__SHIFT 0x3
#define PB1_PIF_LANE1_OVRD__TXPWR_OVRD_EN_1_MASK 0x10
#define PB1_PIF_LANE1_OVRD__TXPWR_OVRD_EN_1__SHIFT 0x4
#define PB1_PIF_LANE1_OVRD__TXPGENABLE_OVRD_EN_1_MASK 0x20
#define PB1_PIF_LANE1_OVRD__TXPGENABLE_OVRD_EN_1__SHIFT 0x5
#define PB1_PIF_LANE1_OVRD__RXPWR_OVRD_EN_1_MASK 0x40
#define PB1_PIF_LANE1_OVRD__RXPWR_OVRD_EN_1__SHIFT 0x6
#define PB1_PIF_LANE1_OVRD__RXPGENABLE_OVRD_EN_1_MASK 0x80
#define PB1_PIF_LANE1_OVRD__RXPGENABLE_OVRD_EN_1__SHIFT 0x7
#define PB1_PIF_LANE1_OVRD__ELECIDLEDETEN_OVRD_EN_1_MASK 0x100
#define PB1_PIF_LANE1_OVRD__ELECIDLEDETEN_OVRD_EN_1__SHIFT 0x8
#define PB1_PIF_LANE1_OVRD__ENABLEFOM_OVRD_EN_1_MASK 0x200
#define PB1_PIF_LANE1_OVRD__ENABLEFOM_OVRD_EN_1__SHIFT 0x9
#define PB1_PIF_LANE1_OVRD__REQUESTFOM_OVRD_EN_1_MASK 0x400
#define PB1_PIF_LANE1_OVRD__REQUESTFOM_OVRD_EN_1__SHIFT 0xa
#define PB1_PIF_LANE1_OVRD__RESPONSEMODE_OVRD_EN_1_MASK 0x800
#define PB1_PIF_LANE1_OVRD__RESPONSEMODE_OVRD_EN_1__SHIFT 0xb
#define PB1_PIF_LANE1_OVRD__REQUESTTRK_OVRD_EN_1_MASK 0x1000
#define PB1_PIF_LANE1_OVRD__REQUESTTRK_OVRD_EN_1__SHIFT 0xc
#define PB1_PIF_LANE1_OVRD__REQUESTTRN_OVRD_EN_1_MASK 0x2000
#define PB1_PIF_LANE1_OVRD__REQUESTTRN_OVRD_EN_1__SHIFT 0xd
#define PB1_PIF_LANE1_OVRD__COEFFICIENTID_OVRD_EN_1_MASK 0x4000
#define PB1_PIF_LANE1_OVRD__COEFFICIENTID_OVRD_EN_1__SHIFT 0xe
#define PB1_PIF_LANE1_OVRD__COEFFICIENT_OVRD_EN_1_MASK 0x8000
#define PB1_PIF_LANE1_OVRD__COEFFICIENT_OVRD_EN_1__SHIFT 0xf
#define PB1_PIF_LANE1_OVRD__CDREN_OVRD_EN_1_MASK 0x10000
#define PB1_PIF_LANE1_OVRD__CDREN_OVRD_EN_1__SHIFT 0x10
#define PB1_PIF_LANE1_OVRD__CDREN_OVRD_VAL_1_MASK 0x20000
#define PB1_PIF_LANE1_OVRD__CDREN_OVRD_VAL_1__SHIFT 0x11
#define PB1_PIF_LANE1_OVRD2__GANGMODE_1_MASK 0x7
#define PB1_PIF_LANE1_OVRD2__GANGMODE_1__SHIFT 0x0
#define PB1_PIF_LANE1_OVRD2__FREQDIV_1_MASK 0x18
#define PB1_PIF_LANE1_OVRD2__FREQDIV_1__SHIFT 0x3
#define PB1_PIF_LANE1_OVRD2__LINKSPEED_1_MASK 0x60
#define PB1_PIF_LANE1_OVRD2__LINKSPEED_1__SHIFT 0x5
#define PB1_PIF_LANE1_OVRD2__TWOSYMENABLE_1_MASK 0x80
#define PB1_PIF_LANE1_OVRD2__TWOSYMENABLE_1__SHIFT 0x7
#define PB1_PIF_LANE1_OVRD2__TXPWR_1_MASK 0x700
#define PB1_PIF_LANE1_OVRD2__TXPWR_1__SHIFT 0x8
#define PB1_PIF_LANE1_OVRD2__TXPGENABLE_1_MASK 0x1800
#define PB1_PIF_LANE1_OVRD2__TXPGENABLE_1__SHIFT 0xb
#define PB1_PIF_LANE1_OVRD2__RXPWR_1_MASK 0xe000
#define PB1_PIF_LANE1_OVRD2__RXPWR_1__SHIFT 0xd
#define PB1_PIF_LANE1_OVRD2__RXPGENABLE_1_MASK 0x30000
#define PB1_PIF_LANE1_OVRD2__RXPGENABLE_1__SHIFT 0x10
#define PB1_PIF_LANE1_OVRD2__ELECIDLEDETEN_1_MASK 0x40000
#define PB1_PIF_LANE1_OVRD2__ELECIDLEDETEN_1__SHIFT 0x12
#define PB1_PIF_LANE1_OVRD2__ENABLEFOM_1_MASK 0x80000
#define PB1_PIF_LANE1_OVRD2__ENABLEFOM_1__SHIFT 0x13
#define PB1_PIF_LANE1_OVRD2__REQUESTFOM_1_MASK 0x100000
#define PB1_PIF_LANE1_OVRD2__REQUESTFOM_1__SHIFT 0x14
#define PB1_PIF_LANE1_OVRD2__RESPONSEMODE_1_MASK 0x200000
#define PB1_PIF_LANE1_OVRD2__RESPONSEMODE_1__SHIFT 0x15
#define PB1_PIF_LANE1_OVRD2__REQUESTTRK_1_MASK 0x400000
#define PB1_PIF_LANE1_OVRD2__REQUESTTRK_1__SHIFT 0x16
#define PB1_PIF_LANE1_OVRD2__REQUESTTRN_1_MASK 0x800000
#define PB1_PIF_LANE1_OVRD2__REQUESTTRN_1__SHIFT 0x17
#define PB1_PIF_LANE1_OVRD2__COEFFICIENTID_1_MASK 0x3000000
#define PB1_PIF_LANE1_OVRD2__COEFFICIENTID_1__SHIFT 0x18
#define PB1_PIF_LANE1_OVRD2__COEFFICIENT_1_MASK 0xfc000000
#define PB1_PIF_LANE1_OVRD2__COEFFICIENT_1__SHIFT 0x1a
#define PB1_PIF_LANE2_OVRD__GANGMODE_OVRD_EN_2_MASK 0x1
#define PB1_PIF_LANE2_OVRD__GANGMODE_OVRD_EN_2__SHIFT 0x0
#define PB1_PIF_LANE2_OVRD__FREQDIV_OVRD_EN_2_MASK 0x2
#define PB1_PIF_LANE2_OVRD__FREQDIV_OVRD_EN_2__SHIFT 0x1
#define PB1_PIF_LANE2_OVRD__LINKSPEED_OVRD_EN_2_MASK 0x4
#define PB1_PIF_LANE2_OVRD__LINKSPEED_OVRD_EN_2__SHIFT 0x2
#define PB1_PIF_LANE2_OVRD__TWOSYMENABLE_OVRD_EN_2_MASK 0x8
#define PB1_PIF_LANE2_OVRD__TWOSYMENABLE_OVRD_EN_2__SHIFT 0x3
#define PB1_PIF_LANE2_OVRD__TXPWR_OVRD_EN_2_MASK 0x10
#define PB1_PIF_LANE2_OVRD__TXPWR_OVRD_EN_2__SHIFT 0x4
#define PB1_PIF_LANE2_OVRD__TXPGENABLE_OVRD_EN_2_MASK 0x20
#define PB1_PIF_LANE2_OVRD__TXPGENABLE_OVRD_EN_2__SHIFT 0x5
#define PB1_PIF_LANE2_OVRD__RXPWR_OVRD_EN_2_MASK 0x40
#define PB1_PIF_LANE2_OVRD__RXPWR_OVRD_EN_2__SHIFT 0x6
#define PB1_PIF_LANE2_OVRD__RXPGENABLE_OVRD_EN_2_MASK 0x80
#define PB1_PIF_LANE2_OVRD__RXPGENABLE_OVRD_EN_2__SHIFT 0x7
#define PB1_PIF_LANE2_OVRD__ELECIDLEDETEN_OVRD_EN_2_MASK 0x100
#define PB1_PIF_LANE2_OVRD__ELECIDLEDETEN_OVRD_EN_2__SHIFT 0x8
#define PB1_PIF_LANE2_OVRD__ENABLEFOM_OVRD_EN_2_MASK 0x200
#define PB1_PIF_LANE2_OVRD__ENABLEFOM_OVRD_EN_2__SHIFT 0x9
#define PB1_PIF_LANE2_OVRD__REQUESTFOM_OVRD_EN_2_MASK 0x400
#define PB1_PIF_LANE2_OVRD__REQUESTFOM_OVRD_EN_2__SHIFT 0xa
#define PB1_PIF_LANE2_OVRD__RESPONSEMODE_OVRD_EN_2_MASK 0x800
#define PB1_PIF_LANE2_OVRD__RESPONSEMODE_OVRD_EN_2__SHIFT 0xb
#define PB1_PIF_LANE2_OVRD__REQUESTTRK_OVRD_EN_2_MASK 0x1000
#define PB1_PIF_LANE2_OVRD__REQUESTTRK_OVRD_EN_2__SHIFT 0xc
#define PB1_PIF_LANE2_OVRD__REQUESTTRN_OVRD_EN_2_MASK 0x2000
#define PB1_PIF_LANE2_OVRD__REQUESTTRN_OVRD_EN_2__SHIFT 0xd
#define PB1_PIF_LANE2_OVRD__COEFFICIENTID_OVRD_EN_2_MASK 0x4000
#define PB1_PIF_LANE2_OVRD__COEFFICIENTID_OVRD_EN_2__SHIFT 0xe
#define PB1_PIF_LANE2_OVRD__COEFFICIENT_OVRD_EN_2_MASK 0x8000
#define PB1_PIF_LANE2_OVRD__COEFFICIENT_OVRD_EN_2__SHIFT 0xf
#define PB1_PIF_LANE2_OVRD__CDREN_OVRD_EN_2_MASK 0x10000
#define PB1_PIF_LANE2_OVRD__CDREN_OVRD_EN_2__SHIFT 0x10
#define PB1_PIF_LANE2_OVRD__CDREN_OVRD_VAL_2_MASK 0x20000
#define PB1_PIF_LANE2_OVRD__CDREN_OVRD_VAL_2__SHIFT 0x11
#define PB1_PIF_LANE2_OVRD2__GANGMODE_2_MASK 0x7
#define PB1_PIF_LANE2_OVRD2__GANGMODE_2__SHIFT 0x0
#define PB1_PIF_LANE2_OVRD2__FREQDIV_2_MASK 0x18
#define PB1_PIF_LANE2_OVRD2__FREQDIV_2__SHIFT 0x3
#define PB1_PIF_LANE2_OVRD2__LINKSPEED_2_MASK 0x60
#define PB1_PIF_LANE2_OVRD2__LINKSPEED_2__SHIFT 0x5
#define PB1_PIF_LANE2_OVRD2__TWOSYMENABLE_2_MASK 0x80
#define PB1_PIF_LANE2_OVRD2__TWOSYMENABLE_2__SHIFT 0x7
#define PB1_PIF_LANE2_OVRD2__TXPWR_2_MASK 0x700
#define PB1_PIF_LANE2_OVRD2__TXPWR_2__SHIFT 0x8
#define PB1_PIF_LANE2_OVRD2__TXPGENABLE_2_MASK 0x1800
#define PB1_PIF_LANE2_OVRD2__TXPGENABLE_2__SHIFT 0xb
#define PB1_PIF_LANE2_OVRD2__RXPWR_2_MASK 0xe000
#define PB1_PIF_LANE2_OVRD2__RXPWR_2__SHIFT 0xd
#define PB1_PIF_LANE2_OVRD2__RXPGENABLE_2_MASK 0x30000
#define PB1_PIF_LANE2_OVRD2__RXPGENABLE_2__SHIFT 0x10
#define PB1_PIF_LANE2_OVRD2__ELECIDLEDETEN_2_MASK 0x40000
#define PB1_PIF_LANE2_OVRD2__ELECIDLEDETEN_2__SHIFT 0x12
#define PB1_PIF_LANE2_OVRD2__ENABLEFOM_2_MASK 0x80000
#define PB1_PIF_LANE2_OVRD2__ENABLEFOM_2__SHIFT 0x13
#define PB1_PIF_LANE2_OVRD2__REQUESTFOM_2_MASK 0x100000
#define PB1_PIF_LANE2_OVRD2__REQUESTFOM_2__SHIFT 0x14
#define PB1_PIF_LANE2_OVRD2__RESPONSEMODE_2_MASK 0x200000
#define PB1_PIF_LANE2_OVRD2__RESPONSEMODE_2__SHIFT 0x15
#define PB1_PIF_LANE2_OVRD2__REQUESTTRK_2_MASK 0x400000
#define PB1_PIF_LANE2_OVRD2__REQUESTTRK_2__SHIFT 0x16
#define PB1_PIF_LANE2_OVRD2__REQUESTTRN_2_MASK 0x800000
#define PB1_PIF_LANE2_OVRD2__REQUESTTRN_2__SHIFT 0x17
#define PB1_PIF_LANE2_OVRD2__COEFFICIENTID_2_MASK 0x3000000
#define PB1_PIF_LANE2_OVRD2__COEFFICIENTID_2__SHIFT 0x18
#define PB1_PIF_LANE2_OVRD2__COEFFICIENT_2_MASK 0xfc000000
#define PB1_PIF_LANE2_OVRD2__COEFFICIENT_2__SHIFT 0x1a
#define PB1_PIF_LANE3_OVRD__GANGMODE_OVRD_EN_3_MASK 0x1
#define PB1_PIF_LANE3_OVRD__GANGMODE_OVRD_EN_3__SHIFT 0x0
#define PB1_PIF_LANE3_OVRD__FREQDIV_OVRD_EN_3_MASK 0x2
#define PB1_PIF_LANE3_OVRD__FREQDIV_OVRD_EN_3__SHIFT 0x1
#define PB1_PIF_LANE3_OVRD__LINKSPEED_OVRD_EN_3_MASK 0x4
#define PB1_PIF_LANE3_OVRD__LINKSPEED_OVRD_EN_3__SHIFT 0x2
#define PB1_PIF_LANE3_OVRD__TWOSYMENABLE_OVRD_EN_3_MASK 0x8
#define PB1_PIF_LANE3_OVRD__TWOSYMENABLE_OVRD_EN_3__SHIFT 0x3
#define PB1_PIF_LANE3_OVRD__TXPWR_OVRD_EN_3_MASK 0x10
#define PB1_PIF_LANE3_OVRD__TXPWR_OVRD_EN_3__SHIFT 0x4
#define PB1_PIF_LANE3_OVRD__TXPGENABLE_OVRD_EN_3_MASK 0x20
#define PB1_PIF_LANE3_OVRD__TXPGENABLE_OVRD_EN_3__SHIFT 0x5
#define PB1_PIF_LANE3_OVRD__RXPWR_OVRD_EN_3_MASK 0x40
#define PB1_PIF_LANE3_OVRD__RXPWR_OVRD_EN_3__SHIFT 0x6
#define PB1_PIF_LANE3_OVRD__RXPGENABLE_OVRD_EN_3_MASK 0x80
#define PB1_PIF_LANE3_OVRD__RXPGENABLE_OVRD_EN_3__SHIFT 0x7
#define PB1_PIF_LANE3_OVRD__ELECIDLEDETEN_OVRD_EN_3_MASK 0x100
#define PB1_PIF_LANE3_OVRD__ELECIDLEDETEN_OVRD_EN_3__SHIFT 0x8
#define PB1_PIF_LANE3_OVRD__ENABLEFOM_OVRD_EN_3_MASK 0x200
#define PB1_PIF_LANE3_OVRD__ENABLEFOM_OVRD_EN_3__SHIFT 0x9
#define PB1_PIF_LANE3_OVRD__REQUESTFOM_OVRD_EN_3_MASK 0x400
#define PB1_PIF_LANE3_OVRD__REQUESTFOM_OVRD_EN_3__SHIFT 0xa
#define PB1_PIF_LANE3_OVRD__RESPONSEMODE_OVRD_EN_3_MASK 0x800
#define PB1_PIF_LANE3_OVRD__RESPONSEMODE_OVRD_EN_3__SHIFT 0xb
#define PB1_PIF_LANE3_OVRD__REQUESTTRK_OVRD_EN_3_MASK 0x1000
#define PB1_PIF_LANE3_OVRD__REQUESTTRK_OVRD_EN_3__SHIFT 0xc
#define PB1_PIF_LANE3_OVRD__REQUESTTRN_OVRD_EN_3_MASK 0x2000
#define PB1_PIF_LANE3_OVRD__REQUESTTRN_OVRD_EN_3__SHIFT 0xd
#define PB1_PIF_LANE3_OVRD__COEFFICIENTID_OVRD_EN_3_MASK 0x4000
#define PB1_PIF_LANE3_OVRD__COEFFICIENTID_OVRD_EN_3__SHIFT 0xe
#define PB1_PIF_LANE3_OVRD__COEFFICIENT_OVRD_EN_3_MASK 0x8000
#define PB1_PIF_LANE3_OVRD__COEFFICIENT_OVRD_EN_3__SHIFT 0xf
#define PB1_PIF_LANE3_OVRD__CDREN_OVRD_EN_3_MASK 0x10000
#define PB1_PIF_LANE3_OVRD__CDREN_OVRD_EN_3__SHIFT 0x10
#define PB1_PIF_LANE3_OVRD__CDREN_OVRD_VAL_3_MASK 0x20000
#define PB1_PIF_LANE3_OVRD__CDREN_OVRD_VAL_3__SHIFT 0x11
#define PB1_PIF_LANE3_OVRD2__GANGMODE_3_MASK 0x7
#define PB1_PIF_LANE3_OVRD2__GANGMODE_3__SHIFT 0x0
#define PB1_PIF_LANE3_OVRD2__FREQDIV_3_MASK 0x18
#define PB1_PIF_LANE3_OVRD2__FREQDIV_3__SHIFT 0x3
#define PB1_PIF_LANE3_OVRD2__LINKSPEED_3_MASK 0x60
#define PB1_PIF_LANE3_OVRD2__LINKSPEED_3__SHIFT 0x5
#define PB1_PIF_LANE3_OVRD2__TWOSYMENABLE_3_MASK 0x80
#define PB1_PIF_LANE3_OVRD2__TWOSYMENABLE_3__SHIFT 0x7
#define PB1_PIF_LANE3_OVRD2__TXPWR_3_MASK 0x700
#define PB1_PIF_LANE3_OVRD2__TXPWR_3__SHIFT 0x8
#define PB1_PIF_LANE3_OVRD2__TXPGENABLE_3_MASK 0x1800
#define PB1_PIF_LANE3_OVRD2__TXPGENABLE_3__SHIFT 0xb
#define PB1_PIF_LANE3_OVRD2__RXPWR_3_MASK 0xe000
#define PB1_PIF_LANE3_OVRD2__RXPWR_3__SHIFT 0xd
#define PB1_PIF_LANE3_OVRD2__RXPGENABLE_3_MASK 0x30000
#define PB1_PIF_LANE3_OVRD2__RXPGENABLE_3__SHIFT 0x10
#define PB1_PIF_LANE3_OVRD2__ELECIDLEDETEN_3_MASK 0x40000
#define PB1_PIF_LANE3_OVRD2__ELECIDLEDETEN_3__SHIFT 0x12
#define PB1_PIF_LANE3_OVRD2__ENABLEFOM_3_MASK 0x80000
#define PB1_PIF_LANE3_OVRD2__ENABLEFOM_3__SHIFT 0x13
#define PB1_PIF_LANE3_OVRD2__REQUESTFOM_3_MASK 0x100000
#define PB1_PIF_LANE3_OVRD2__REQUESTFOM_3__SHIFT 0x14
#define PB1_PIF_LANE3_OVRD2__RESPONSEMODE_3_MASK 0x200000
#define PB1_PIF_LANE3_OVRD2__RESPONSEMODE_3__SHIFT 0x15
#define PB1_PIF_LANE3_OVRD2__REQUESTTRK_3_MASK 0x400000
#define PB1_PIF_LANE3_OVRD2__REQUESTTRK_3__SHIFT 0x16
#define PB1_PIF_LANE3_OVRD2__REQUESTTRN_3_MASK 0x800000
#define PB1_PIF_LANE3_OVRD2__REQUESTTRN_3__SHIFT 0x17
#define PB1_PIF_LANE3_OVRD2__COEFFICIENTID_3_MASK 0x3000000
#define PB1_PIF_LANE3_OVRD2__COEFFICIENTID_3__SHIFT 0x18
#define PB1_PIF_LANE3_OVRD2__COEFFICIENT_3_MASK 0xfc000000
#define PB1_PIF_LANE3_OVRD2__COEFFICIENT_3__SHIFT 0x1a
#define PB1_PIF_LANE4_OVRD__GANGMODE_OVRD_EN_4_MASK 0x1
#define PB1_PIF_LANE4_OVRD__GANGMODE_OVRD_EN_4__SHIFT 0x0
#define PB1_PIF_LANE4_OVRD__FREQDIV_OVRD_EN_4_MASK 0x2
#define PB1_PIF_LANE4_OVRD__FREQDIV_OVRD_EN_4__SHIFT 0x1
#define PB1_PIF_LANE4_OVRD__LINKSPEED_OVRD_EN_4_MASK 0x4
#define PB1_PIF_LANE4_OVRD__LINKSPEED_OVRD_EN_4__SHIFT 0x2
#define PB1_PIF_LANE4_OVRD__TWOSYMENABLE_OVRD_EN_4_MASK 0x8
#define PB1_PIF_LANE4_OVRD__TWOSYMENABLE_OVRD_EN_4__SHIFT 0x3
#define PB1_PIF_LANE4_OVRD__TXPWR_OVRD_EN_4_MASK 0x10
#define PB1_PIF_LANE4_OVRD__TXPWR_OVRD_EN_4__SHIFT 0x4
#define PB1_PIF_LANE4_OVRD__TXPGENABLE_OVRD_EN_4_MASK 0x20
#define PB1_PIF_LANE4_OVRD__TXPGENABLE_OVRD_EN_4__SHIFT 0x5
#define PB1_PIF_LANE4_OVRD__RXPWR_OVRD_EN_4_MASK 0x40
#define PB1_PIF_LANE4_OVRD__RXPWR_OVRD_EN_4__SHIFT 0x6
#define PB1_PIF_LANE4_OVRD__RXPGENABLE_OVRD_EN_4_MASK 0x80
#define PB1_PIF_LANE4_OVRD__RXPGENABLE_OVRD_EN_4__SHIFT 0x7
#define PB1_PIF_LANE4_OVRD__ELECIDLEDETEN_OVRD_EN_4_MASK 0x100
#define PB1_PIF_LANE4_OVRD__ELECIDLEDETEN_OVRD_EN_4__SHIFT 0x8
#define PB1_PIF_LANE4_OVRD__ENABLEFOM_OVRD_EN_4_MASK 0x200
#define PB1_PIF_LANE4_OVRD__ENABLEFOM_OVRD_EN_4__SHIFT 0x9
#define PB1_PIF_LANE4_OVRD__REQUESTFOM_OVRD_EN_4_MASK 0x400
#define PB1_PIF_LANE4_OVRD__REQUESTFOM_OVRD_EN_4__SHIFT 0xa
#define PB1_PIF_LANE4_OVRD__RESPONSEMODE_OVRD_EN_4_MASK 0x800
#define PB1_PIF_LANE4_OVRD__RESPONSEMODE_OVRD_EN_4__SHIFT 0xb
#define PB1_PIF_LANE4_OVRD__REQUESTTRK_OVRD_EN_4_MASK 0x1000
#define PB1_PIF_LANE4_OVRD__REQUESTTRK_OVRD_EN_4__SHIFT 0xc
#define PB1_PIF_LANE4_OVRD__REQUESTTRN_OVRD_EN_4_MASK 0x2000
#define PB1_PIF_LANE4_OVRD__REQUESTTRN_OVRD_EN_4__SHIFT 0xd
#define PB1_PIF_LANE4_OVRD__COEFFICIENTID_OVRD_EN_4_MASK 0x4000
#define PB1_PIF_LANE4_OVRD__COEFFICIENTID_OVRD_EN_4__SHIFT 0xe
#define PB1_PIF_LANE4_OVRD__COEFFICIENT_OVRD_EN_4_MASK 0x8000
#define PB1_PIF_LANE4_OVRD__COEFFICIENT_OVRD_EN_4__SHIFT 0xf
#define PB1_PIF_LANE4_OVRD__CDREN_OVRD_EN_4_MASK 0x10000
#define PB1_PIF_LANE4_OVRD__CDREN_OVRD_EN_4__SHIFT 0x10
#define PB1_PIF_LANE4_OVRD__CDREN_OVRD_VAL_4_MASK 0x20000
#define PB1_PIF_LANE4_OVRD__CDREN_OVRD_VAL_4__SHIFT 0x11
#define PB1_PIF_LANE4_OVRD2__GANGMODE_4_MASK 0x7
#define PB1_PIF_LANE4_OVRD2__GANGMODE_4__SHIFT 0x0
#define PB1_PIF_LANE4_OVRD2__FREQDIV_4_MASK 0x18
#define PB1_PIF_LANE4_OVRD2__FREQDIV_4__SHIFT 0x3
#define PB1_PIF_LANE4_OVRD2__LINKSPEED_4_MASK 0x60
#define PB1_PIF_LANE4_OVRD2__LINKSPEED_4__SHIFT 0x5
#define PB1_PIF_LANE4_OVRD2__TWOSYMENABLE_4_MASK 0x80
#define PB1_PIF_LANE4_OVRD2__TWOSYMENABLE_4__SHIFT 0x7
#define PB1_PIF_LANE4_OVRD2__TXPWR_4_MASK 0x700
#define PB1_PIF_LANE4_OVRD2__TXPWR_4__SHIFT 0x8
#define PB1_PIF_LANE4_OVRD2__TXPGENABLE_4_MASK 0x1800
#define PB1_PIF_LANE4_OVRD2__TXPGENABLE_4__SHIFT 0xb
#define PB1_PIF_LANE4_OVRD2__RXPWR_4_MASK 0xe000
#define PB1_PIF_LANE4_OVRD2__RXPWR_4__SHIFT 0xd
#define PB1_PIF_LANE4_OVRD2__RXPGENABLE_4_MASK 0x30000
#define PB1_PIF_LANE4_OVRD2__RXPGENABLE_4__SHIFT 0x10
#define PB1_PIF_LANE4_OVRD2__ELECIDLEDETEN_4_MASK 0x40000
#define PB1_PIF_LANE4_OVRD2__ELECIDLEDETEN_4__SHIFT 0x12
#define PB1_PIF_LANE4_OVRD2__ENABLEFOM_4_MASK 0x80000
#define PB1_PIF_LANE4_OVRD2__ENABLEFOM_4__SHIFT 0x13
#define PB1_PIF_LANE4_OVRD2__REQUESTFOM_4_MASK 0x100000
#define PB1_PIF_LANE4_OVRD2__REQUESTFOM_4__SHIFT 0x14
#define PB1_PIF_LANE4_OVRD2__RESPONSEMODE_4_MASK 0x200000
#define PB1_PIF_LANE4_OVRD2__RESPONSEMODE_4__SHIFT 0x15
#define PB1_PIF_LANE4_OVRD2__REQUESTTRK_4_MASK 0x400000
#define PB1_PIF_LANE4_OVRD2__REQUESTTRK_4__SHIFT 0x16
#define PB1_PIF_LANE4_OVRD2__REQUESTTRN_4_MASK 0x800000
#define PB1_PIF_LANE4_OVRD2__REQUESTTRN_4__SHIFT 0x17
#define PB1_PIF_LANE4_OVRD2__COEFFICIENTID_4_MASK 0x3000000
#define PB1_PIF_LANE4_OVRD2__COEFFICIENTID_4__SHIFT 0x18
#define PB1_PIF_LANE4_OVRD2__COEFFICIENT_4_MASK 0xfc000000
#define PB1_PIF_LANE4_OVRD2__COEFFICIENT_4__SHIFT 0x1a
#define PB1_PIF_LANE5_OVRD__GANGMODE_OVRD_EN_5_MASK 0x1
#define PB1_PIF_LANE5_OVRD__GANGMODE_OVRD_EN_5__SHIFT 0x0
#define PB1_PIF_LANE5_OVRD__FREQDIV_OVRD_EN_5_MASK 0x2
#define PB1_PIF_LANE5_OVRD__FREQDIV_OVRD_EN_5__SHIFT 0x1
#define PB1_PIF_LANE5_OVRD__LINKSPEED_OVRD_EN_5_MASK 0x4
#define PB1_PIF_LANE5_OVRD__LINKSPEED_OVRD_EN_5__SHIFT 0x2
#define PB1_PIF_LANE5_OVRD__TWOSYMENABLE_OVRD_EN_5_MASK 0x8
#define PB1_PIF_LANE5_OVRD__TWOSYMENABLE_OVRD_EN_5__SHIFT 0x3
#define PB1_PIF_LANE5_OVRD__TXPWR_OVRD_EN_5_MASK 0x10
#define PB1_PIF_LANE5_OVRD__TXPWR_OVRD_EN_5__SHIFT 0x4
#define PB1_PIF_LANE5_OVRD__TXPGENABLE_OVRD_EN_5_MASK 0x20
#define PB1_PIF_LANE5_OVRD__TXPGENABLE_OVRD_EN_5__SHIFT 0x5
#define PB1_PIF_LANE5_OVRD__RXPWR_OVRD_EN_5_MASK 0x40
#define PB1_PIF_LANE5_OVRD__RXPWR_OVRD_EN_5__SHIFT 0x6
#define PB1_PIF_LANE5_OVRD__RXPGENABLE_OVRD_EN_5_MASK 0x80
#define PB1_PIF_LANE5_OVRD__RXPGENABLE_OVRD_EN_5__SHIFT 0x7
#define PB1_PIF_LANE5_OVRD__ELECIDLEDETEN_OVRD_EN_5_MASK 0x100
#define PB1_PIF_LANE5_OVRD__ELECIDLEDETEN_OVRD_EN_5__SHIFT 0x8
#define PB1_PIF_LANE5_OVRD__ENABLEFOM_OVRD_EN_5_MASK 0x200
#define PB1_PIF_LANE5_OVRD__ENABLEFOM_OVRD_EN_5__SHIFT 0x9
#define PB1_PIF_LANE5_OVRD__REQUESTFOM_OVRD_EN_5_MASK 0x400
#define PB1_PIF_LANE5_OVRD__REQUESTFOM_OVRD_EN_5__SHIFT 0xa
#define PB1_PIF_LANE5_OVRD__RESPONSEMODE_OVRD_EN_5_MASK 0x800
#define PB1_PIF_LANE5_OVRD__RESPONSEMODE_OVRD_EN_5__SHIFT 0xb
#define PB1_PIF_LANE5_OVRD__REQUESTTRK_OVRD_EN_5_MASK 0x1000
#define PB1_PIF_LANE5_OVRD__REQUESTTRK_OVRD_EN_5__SHIFT 0xc
#define PB1_PIF_LANE5_OVRD__REQUESTTRN_OVRD_EN_5_MASK 0x2000
#define PB1_PIF_LANE5_OVRD__REQUESTTRN_OVRD_EN_5__SHIFT 0xd
#define PB1_PIF_LANE5_OVRD__COEFFICIENTID_OVRD_EN_5_MASK 0x4000
#define PB1_PIF_LANE5_OVRD__COEFFICIENTID_OVRD_EN_5__SHIFT 0xe
#define PB1_PIF_LANE5_OVRD__COEFFICIENT_OVRD_EN_5_MASK 0x8000
#define PB1_PIF_LANE5_OVRD__COEFFICIENT_OVRD_EN_5__SHIFT 0xf
#define PB1_PIF_LANE5_OVRD__CDREN_OVRD_EN_5_MASK 0x10000
#define PB1_PIF_LANE5_OVRD__CDREN_OVRD_EN_5__SHIFT 0x10
#define PB1_PIF_LANE5_OVRD__CDREN_OVRD_VAL_5_MASK 0x20000
#define PB1_PIF_LANE5_OVRD__CDREN_OVRD_VAL_5__SHIFT 0x11
#define PB1_PIF_LANE5_OVRD2__GANGMODE_5_MASK 0x7
#define PB1_PIF_LANE5_OVRD2__GANGMODE_5__SHIFT 0x0
#define PB1_PIF_LANE5_OVRD2__FREQDIV_5_MASK 0x18
#define PB1_PIF_LANE5_OVRD2__FREQDIV_5__SHIFT 0x3
#define PB1_PIF_LANE5_OVRD2__LINKSPEED_5_MASK 0x60
#define PB1_PIF_LANE5_OVRD2__LINKSPEED_5__SHIFT 0x5
#define PB1_PIF_LANE5_OVRD2__TWOSYMENABLE_5_MASK 0x80
#define PB1_PIF_LANE5_OVRD2__TWOSYMENABLE_5__SHIFT 0x7
#define PB1_PIF_LANE5_OVRD2__TXPWR_5_MASK 0x700
#define PB1_PIF_LANE5_OVRD2__TXPWR_5__SHIFT 0x8
#define PB1_PIF_LANE5_OVRD2__TXPGENABLE_5_MASK 0x1800
#define PB1_PIF_LANE5_OVRD2__TXPGENABLE_5__SHIFT 0xb
#define PB1_PIF_LANE5_OVRD2__RXPWR_5_MASK 0xe000
#define PB1_PIF_LANE5_OVRD2__RXPWR_5__SHIFT 0xd
#define PB1_PIF_LANE5_OVRD2__RXPGENABLE_5_MASK 0x30000
#define PB1_PIF_LANE5_OVRD2__RXPGENABLE_5__SHIFT 0x10
#define PB1_PIF_LANE5_OVRD2__ELECIDLEDETEN_5_MASK 0x40000
#define PB1_PIF_LANE5_OVRD2__ELECIDLEDETEN_5__SHIFT 0x12
#define PB1_PIF_LANE5_OVRD2__ENABLEFOM_5_MASK 0x80000
#define PB1_PIF_LANE5_OVRD2__ENABLEFOM_5__SHIFT 0x13
#define PB1_PIF_LANE5_OVRD2__REQUESTFOM_5_MASK 0x100000
#define PB1_PIF_LANE5_OVRD2__REQUESTFOM_5__SHIFT 0x14
#define PB1_PIF_LANE5_OVRD2__RESPONSEMODE_5_MASK 0x200000
#define PB1_PIF_LANE5_OVRD2__RESPONSEMODE_5__SHIFT 0x15
#define PB1_PIF_LANE5_OVRD2__REQUESTTRK_5_MASK 0x400000
#define PB1_PIF_LANE5_OVRD2__REQUESTTRK_5__SHIFT 0x16
#define PB1_PIF_LANE5_OVRD2__REQUESTTRN_5_MASK 0x800000
#define PB1_PIF_LANE5_OVRD2__REQUESTTRN_5__SHIFT 0x17
#define PB1_PIF_LANE5_OVRD2__COEFFICIENTID_5_MASK 0x3000000
#define PB1_PIF_LANE5_OVRD2__COEFFICIENTID_5__SHIFT 0x18
#define PB1_PIF_LANE5_OVRD2__COEFFICIENT_5_MASK 0xfc000000
#define PB1_PIF_LANE5_OVRD2__COEFFICIENT_5__SHIFT 0x1a
#define PB1_PIF_LANE6_OVRD__GANGMODE_OVRD_EN_6_MASK 0x1
#define PB1_PIF_LANE6_OVRD__GANGMODE_OVRD_EN_6__SHIFT 0x0
#define PB1_PIF_LANE6_OVRD__FREQDIV_OVRD_EN_6_MASK 0x2
#define PB1_PIF_LANE6_OVRD__FREQDIV_OVRD_EN_6__SHIFT 0x1
#define PB1_PIF_LANE6_OVRD__LINKSPEED_OVRD_EN_6_MASK 0x4
#define PB1_PIF_LANE6_OVRD__LINKSPEED_OVRD_EN_6__SHIFT 0x2
#define PB1_PIF_LANE6_OVRD__TWOSYMENABLE_OVRD_EN_6_MASK 0x8
#define PB1_PIF_LANE6_OVRD__TWOSYMENABLE_OVRD_EN_6__SHIFT 0x3
#define PB1_PIF_LANE6_OVRD__TXPWR_OVRD_EN_6_MASK 0x10
#define PB1_PIF_LANE6_OVRD__TXPWR_OVRD_EN_6__SHIFT 0x4
#define PB1_PIF_LANE6_OVRD__TXPGENABLE_OVRD_EN_6_MASK 0x20
#define PB1_PIF_LANE6_OVRD__TXPGENABLE_OVRD_EN_6__SHIFT 0x5
#define PB1_PIF_LANE6_OVRD__RXPWR_OVRD_EN_6_MASK 0x40
#define PB1_PIF_LANE6_OVRD__RXPWR_OVRD_EN_6__SHIFT 0x6
#define PB1_PIF_LANE6_OVRD__RXPGENABLE_OVRD_EN_6_MASK 0x80
#define PB1_PIF_LANE6_OVRD__RXPGENABLE_OVRD_EN_6__SHIFT 0x7
#define PB1_PIF_LANE6_OVRD__ELECIDLEDETEN_OVRD_EN_6_MASK 0x100
#define PB1_PIF_LANE6_OVRD__ELECIDLEDETEN_OVRD_EN_6__SHIFT 0x8
#define PB1_PIF_LANE6_OVRD__ENABLEFOM_OVRD_EN_6_MASK 0x200
#define PB1_PIF_LANE6_OVRD__ENABLEFOM_OVRD_EN_6__SHIFT 0x9
#define PB1_PIF_LANE6_OVRD__REQUESTFOM_OVRD_EN_6_MASK 0x400
#define PB1_PIF_LANE6_OVRD__REQUESTFOM_OVRD_EN_6__SHIFT 0xa
#define PB1_PIF_LANE6_OVRD__RESPONSEMODE_OVRD_EN_6_MASK 0x800
#define PB1_PIF_LANE6_OVRD__RESPONSEMODE_OVRD_EN_6__SHIFT 0xb
#define PB1_PIF_LANE6_OVRD__REQUESTTRK_OVRD_EN_6_MASK 0x1000
#define PB1_PIF_LANE6_OVRD__REQUESTTRK_OVRD_EN_6__SHIFT 0xc
#define PB1_PIF_LANE6_OVRD__REQUESTTRN_OVRD_EN_6_MASK 0x2000
#define PB1_PIF_LANE6_OVRD__REQUESTTRN_OVRD_EN_6__SHIFT 0xd
#define PB1_PIF_LANE6_OVRD__COEFFICIENTID_OVRD_EN_6_MASK 0x4000
#define PB1_PIF_LANE6_OVRD__COEFFICIENTID_OVRD_EN_6__SHIFT 0xe
#define PB1_PIF_LANE6_OVRD__COEFFICIENT_OVRD_EN_6_MASK 0x8000
#define PB1_PIF_LANE6_OVRD__COEFFICIENT_OVRD_EN_6__SHIFT 0xf
#define PB1_PIF_LANE6_OVRD__CDREN_OVRD_EN_6_MASK 0x10000
#define PB1_PIF_LANE6_OVRD__CDREN_OVRD_EN_6__SHIFT 0x10
#define PB1_PIF_LANE6_OVRD__CDREN_OVRD_VAL_6_MASK 0x20000
#define PB1_PIF_LANE6_OVRD__CDREN_OVRD_VAL_6__SHIFT 0x11
#define PB1_PIF_LANE6_OVRD2__GANGMODE_6_MASK 0x7
#define PB1_PIF_LANE6_OVRD2__GANGMODE_6__SHIFT 0x0
#define PB1_PIF_LANE6_OVRD2__FREQDIV_6_MASK 0x18
#define PB1_PIF_LANE6_OVRD2__FREQDIV_6__SHIFT 0x3
#define PB1_PIF_LANE6_OVRD2__LINKSPEED_6_MASK 0x60
#define PB1_PIF_LANE6_OVRD2__LINKSPEED_6__SHIFT 0x5
#define PB1_PIF_LANE6_OVRD2__TWOSYMENABLE_6_MASK 0x80
#define PB1_PIF_LANE6_OVRD2__TWOSYMENABLE_6__SHIFT 0x7
#define PB1_PIF_LANE6_OVRD2__TXPWR_6_MASK 0x700
#define PB1_PIF_LANE6_OVRD2__TXPWR_6__SHIFT 0x8
#define PB1_PIF_LANE6_OVRD2__TXPGENABLE_6_MASK 0x1800
#define PB1_PIF_LANE6_OVRD2__TXPGENABLE_6__SHIFT 0xb
#define PB1_PIF_LANE6_OVRD2__RXPWR_6_MASK 0xe000
#define PB1_PIF_LANE6_OVRD2__RXPWR_6__SHIFT 0xd
#define PB1_PIF_LANE6_OVRD2__RXPGENABLE_6_MASK 0x30000
#define PB1_PIF_LANE6_OVRD2__RXPGENABLE_6__SHIFT 0x10
#define PB1_PIF_LANE6_OVRD2__ELECIDLEDETEN_6_MASK 0x40000
#define PB1_PIF_LANE6_OVRD2__ELECIDLEDETEN_6__SHIFT 0x12
#define PB1_PIF_LANE6_OVRD2__ENABLEFOM_6_MASK 0x80000
#define PB1_PIF_LANE6_OVRD2__ENABLEFOM_6__SHIFT 0x13
#define PB1_PIF_LANE6_OVRD2__REQUESTFOM_6_MASK 0x100000
#define PB1_PIF_LANE6_OVRD2__REQUESTFOM_6__SHIFT 0x14
#define PB1_PIF_LANE6_OVRD2__RESPONSEMODE_6_MASK 0x200000
#define PB1_PIF_LANE6_OVRD2__RESPONSEMODE_6__SHIFT 0x15
#define PB1_PIF_LANE6_OVRD2__REQUESTTRK_6_MASK 0x400000
#define PB1_PIF_LANE6_OVRD2__REQUESTTRK_6__SHIFT 0x16
#define PB1_PIF_LANE6_OVRD2__REQUESTTRN_6_MASK 0x800000
#define PB1_PIF_LANE6_OVRD2__REQUESTTRN_6__SHIFT 0x17
#define PB1_PIF_LANE6_OVRD2__COEFFICIENTID_6_MASK 0x3000000
#define PB1_PIF_LANE6_OVRD2__COEFFICIENTID_6__SHIFT 0x18
#define PB1_PIF_LANE6_OVRD2__COEFFICIENT_6_MASK 0xfc000000
#define PB1_PIF_LANE6_OVRD2__COEFFICIENT_6__SHIFT 0x1a
#define PB1_PIF_LANE7_OVRD__GANGMODE_OVRD_EN_7_MASK 0x1
#define PB1_PIF_LANE7_OVRD__GANGMODE_OVRD_EN_7__SHIFT 0x0
#define PB1_PIF_LANE7_OVRD__FREQDIV_OVRD_EN_7_MASK 0x2
#define PB1_PIF_LANE7_OVRD__FREQDIV_OVRD_EN_7__SHIFT 0x1
#define PB1_PIF_LANE7_OVRD__LINKSPEED_OVRD_EN_7_MASK 0x4
#define PB1_PIF_LANE7_OVRD__LINKSPEED_OVRD_EN_7__SHIFT 0x2
#define PB1_PIF_LANE7_OVRD__TWOSYMENABLE_OVRD_EN_7_MASK 0x8
#define PB1_PIF_LANE7_OVRD__TWOSYMENABLE_OVRD_EN_7__SHIFT 0x3
#define PB1_PIF_LANE7_OVRD__TXPWR_OVRD_EN_7_MASK 0x10
#define PB1_PIF_LANE7_OVRD__TXPWR_OVRD_EN_7__SHIFT 0x4
#define PB1_PIF_LANE7_OVRD__TXPGENABLE_OVRD_EN_7_MASK 0x20
#define PB1_PIF_LANE7_OVRD__TXPGENABLE_OVRD_EN_7__SHIFT 0x5
#define PB1_PIF_LANE7_OVRD__RXPWR_OVRD_EN_7_MASK 0x40
#define PB1_PIF_LANE7_OVRD__RXPWR_OVRD_EN_7__SHIFT 0x6
#define PB1_PIF_LANE7_OVRD__RXPGENABLE_OVRD_EN_7_MASK 0x80
#define PB1_PIF_LANE7_OVRD__RXPGENABLE_OVRD_EN_7__SHIFT 0x7
#define PB1_PIF_LANE7_OVRD__ELECIDLEDETEN_OVRD_EN_7_MASK 0x100
#define PB1_PIF_LANE7_OVRD__ELECIDLEDETEN_OVRD_EN_7__SHIFT 0x8
#define PB1_PIF_LANE7_OVRD__ENABLEFOM_OVRD_EN_7_MASK 0x200
#define PB1_PIF_LANE7_OVRD__ENABLEFOM_OVRD_EN_7__SHIFT 0x9
#define PB1_PIF_LANE7_OVRD__REQUESTFOM_OVRD_EN_7_MASK 0x400
#define PB1_PIF_LANE7_OVRD__REQUESTFOM_OVRD_EN_7__SHIFT 0xa
#define PB1_PIF_LANE7_OVRD__RESPONSEMODE_OVRD_EN_7_MASK 0x800
#define PB1_PIF_LANE7_OVRD__RESPONSEMODE_OVRD_EN_7__SHIFT 0xb
#define PB1_PIF_LANE7_OVRD__REQUESTTRK_OVRD_EN_7_MASK 0x1000
#define PB1_PIF_LANE7_OVRD__REQUESTTRK_OVRD_EN_7__SHIFT 0xc
#define PB1_PIF_LANE7_OVRD__REQUESTTRN_OVRD_EN_7_MASK 0x2000
#define PB1_PIF_LANE7_OVRD__REQUESTTRN_OVRD_EN_7__SHIFT 0xd
#define PB1_PIF_LANE7_OVRD__COEFFICIENTID_OVRD_EN_7_MASK 0x4000
#define PB1_PIF_LANE7_OVRD__COEFFICIENTID_OVRD_EN_7__SHIFT 0xe
#define PB1_PIF_LANE7_OVRD__COEFFICIENT_OVRD_EN_7_MASK 0x8000
#define PB1_PIF_LANE7_OVRD__COEFFICIENT_OVRD_EN_7__SHIFT 0xf
#define PB1_PIF_LANE7_OVRD__CDREN_OVRD_EN_7_MASK 0x10000
#define PB1_PIF_LANE7_OVRD__CDREN_OVRD_EN_7__SHIFT 0x10
#define PB1_PIF_LANE7_OVRD__CDREN_OVRD_VAL_7_MASK 0x20000
#define PB1_PIF_LANE7_OVRD__CDREN_OVRD_VAL_7__SHIFT 0x11
#define PB1_PIF_LANE7_OVRD2__GANGMODE_7_MASK 0x7
#define PB1_PIF_LANE7_OVRD2__GANGMODE_7__SHIFT 0x0
#define PB1_PIF_LANE7_OVRD2__FREQDIV_7_MASK 0x18
#define PB1_PIF_LANE7_OVRD2__FREQDIV_7__SHIFT 0x3
#define PB1_PIF_LANE7_OVRD2__LINKSPEED_7_MASK 0x60
#define PB1_PIF_LANE7_OVRD2__LINKSPEED_7__SHIFT 0x5
#define PB1_PIF_LANE7_OVRD2__TWOSYMENABLE_7_MASK 0x80
#define PB1_PIF_LANE7_OVRD2__TWOSYMENABLE_7__SHIFT 0x7
#define PB1_PIF_LANE7_OVRD2__TXPWR_7_MASK 0x700
#define PB1_PIF_LANE7_OVRD2__TXPWR_7__SHIFT 0x8
#define PB1_PIF_LANE7_OVRD2__TXPGENABLE_7_MASK 0x1800
#define PB1_PIF_LANE7_OVRD2__TXPGENABLE_7__SHIFT 0xb
#define PB1_PIF_LANE7_OVRD2__RXPWR_7_MASK 0xe000
#define PB1_PIF_LANE7_OVRD2__RXPWR_7__SHIFT 0xd
#define PB1_PIF_LANE7_OVRD2__RXPGENABLE_7_MASK 0x30000
#define PB1_PIF_LANE7_OVRD2__RXPGENABLE_7__SHIFT 0x10
#define PB1_PIF_LANE7_OVRD2__ELECIDLEDETEN_7_MASK 0x40000
#define PB1_PIF_LANE7_OVRD2__ELECIDLEDETEN_7__SHIFT 0x12
#define PB1_PIF_LANE7_OVRD2__ENABLEFOM_7_MASK 0x80000
#define PB1_PIF_LANE7_OVRD2__ENABLEFOM_7__SHIFT 0x13
#define PB1_PIF_LANE7_OVRD2__REQUESTFOM_7_MASK 0x100000
#define PB1_PIF_LANE7_OVRD2__REQUESTFOM_7__SHIFT 0x14
#define PB1_PIF_LANE7_OVRD2__RESPONSEMODE_7_MASK 0x200000
#define PB1_PIF_LANE7_OVRD2__RESPONSEMODE_7__SHIFT 0x15
#define PB1_PIF_LANE7_OVRD2__REQUESTTRK_7_MASK 0x400000
#define PB1_PIF_LANE7_OVRD2__REQUESTTRK_7__SHIFT 0x16
#define PB1_PIF_LANE7_OVRD2__REQUESTTRN_7_MASK 0x800000
#define PB1_PIF_LANE7_OVRD2__REQUESTTRN_7__SHIFT 0x17
#define PB1_PIF_LANE7_OVRD2__COEFFICIENTID_7_MASK 0x3000000
#define PB1_PIF_LANE7_OVRD2__COEFFICIENTID_7__SHIFT 0x18
#define PB1_PIF_LANE7_OVRD2__COEFFICIENT_7_MASK 0xfc000000
#define PB1_PIF_LANE7_OVRD2__COEFFICIENT_7__SHIFT 0x1a
#define PCIEP_RESERVED__PCIEP_RESERVED_MASK 0xffffffff
#define PCIEP_RESERVED__PCIEP_RESERVED__SHIFT 0x0
#define PCIEP_SCRATCH__PCIEP_SCRATCH_MASK 0xffffffff
#define PCIEP_SCRATCH__PCIEP_SCRATCH__SHIFT 0x0
#define PCIEP_HW_DEBUG__HW_00_DEBUG_MASK 0x1
#define PCIEP_HW_DEBUG__HW_00_DEBUG__SHIFT 0x0
#define PCIEP_HW_DEBUG__HW_01_DEBUG_MASK 0x2
#define PCIEP_HW_DEBUG__HW_01_DEBUG__SHIFT 0x1
#define PCIEP_HW_DEBUG__HW_02_DEBUG_MASK 0x4
#define PCIEP_HW_DEBUG__HW_02_DEBUG__SHIFT 0x2
#define PCIEP_HW_DEBUG__HW_03_DEBUG_MASK 0x8
#define PCIEP_HW_DEBUG__HW_03_DEBUG__SHIFT 0x3
#define PCIEP_HW_DEBUG__HW_04_DEBUG_MASK 0x10
#define PCIEP_HW_DEBUG__HW_04_DEBUG__SHIFT 0x4
#define PCIEP_HW_DEBUG__HW_05_DEBUG_MASK 0x20
#define PCIEP_HW_DEBUG__HW_05_DEBUG__SHIFT 0x5
#define PCIEP_HW_DEBUG__HW_06_DEBUG_MASK 0x40
#define PCIEP_HW_DEBUG__HW_06_DEBUG__SHIFT 0x6
#define PCIEP_HW_DEBUG__HW_07_DEBUG_MASK 0x80
#define PCIEP_HW_DEBUG__HW_07_DEBUG__SHIFT 0x7
#define PCIEP_HW_DEBUG__HW_08_DEBUG_MASK 0x100
#define PCIEP_HW_DEBUG__HW_08_DEBUG__SHIFT 0x8
#define PCIEP_HW_DEBUG__HW_09_DEBUG_MASK 0x200
#define PCIEP_HW_DEBUG__HW_09_DEBUG__SHIFT 0x9
#define PCIEP_HW_DEBUG__HW_10_DEBUG_MASK 0x400
#define PCIEP_HW_DEBUG__HW_10_DEBUG__SHIFT 0xa
#define PCIEP_HW_DEBUG__HW_11_DEBUG_MASK 0x800
#define PCIEP_HW_DEBUG__HW_11_DEBUG__SHIFT 0xb
#define PCIEP_HW_DEBUG__HW_12_DEBUG_MASK 0x1000
#define PCIEP_HW_DEBUG__HW_12_DEBUG__SHIFT 0xc
#define PCIEP_HW_DEBUG__HW_13_DEBUG_MASK 0x2000
#define PCIEP_HW_DEBUG__HW_13_DEBUG__SHIFT 0xd
#define PCIEP_HW_DEBUG__HW_14_DEBUG_MASK 0x4000
#define PCIEP_HW_DEBUG__HW_14_DEBUG__SHIFT 0xe
#define PCIEP_HW_DEBUG__HW_15_DEBUG_MASK 0x8000
#define PCIEP_HW_DEBUG__HW_15_DEBUG__SHIFT 0xf
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN_MASK 0x1
#define PCIEP_PORT_CNTL__SLV_PORT_REQ_EN__SHIFT 0x0
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE_MASK 0x2
#define PCIEP_PORT_CNTL__CI_SNOOP_OVERRIDE__SHIFT 0x1
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN_MASK 0x4
#define PCIEP_PORT_CNTL__HOTPLUG_MSG_EN__SHIFT 0x2
#define PCIEP_PORT_CNTL__NATIVE_PME_EN_MASK 0x8
#define PCIEP_PORT_CNTL__NATIVE_PME_EN__SHIFT 0x3
#define PCIEP_PORT_CNTL__PWR_FAULT_EN_MASK 0x10
#define PCIEP_PORT_CNTL__PWR_FAULT_EN__SHIFT 0x4
#define PCIEP_PORT_CNTL__PMI_BM_DIS_MASK 0x20
#define PCIEP_PORT_CNTL__PMI_BM_DIS__SHIFT 0x5
#define PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE_MASK 0x40
#define PCIEP_PORT_CNTL__SEQNUM_DEBUG_MODE__SHIFT 0x6
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S_MASK 0x7f00
#define PCIEP_PORT_CNTL__CI_SLV_CPL_STATIC_ALLOC_LIMIT_S__SHIFT 0x8
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE_MASK 0x30000
#define PCIEP_PORT_CNTL__CI_MAX_CPL_PAYLOAD_SIZE_MODE__SHIFT 0x10
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE_MASK 0x1c0000
#define PCIEP_PORT_CNTL__CI_PRIV_MAX_CPL_PAYLOAD_SIZE__SHIFT 0x12
#define PCIE_TX_CNTL__TX_SNR_OVERRIDE_MASK 0xc00
#define PCIE_TX_CNTL__TX_SNR_OVERRIDE__SHIFT 0xa
#define PCIE_TX_CNTL__TX_RO_OVERRIDE_MASK 0x3000
#define PCIE_TX_CNTL__TX_RO_OVERRIDE__SHIFT 0xc
#define PCIE_TX_CNTL__TX_PACK_PACKET_DIS_MASK 0x4000
#define PCIE_TX_CNTL__TX_PACK_PACKET_DIS__SHIFT 0xe
#define PCIE_TX_CNTL__TX_FLUSH_TLP_DIS_MASK 0x8000
#define PCIE_TX_CNTL__TX_FLUSH_TLP_DIS__SHIFT 0xf
#define PCIE_TX_CNTL__TX_CPL_PASS_P_MASK 0x100000
#define PCIE_TX_CNTL__TX_CPL_PASS_P__SHIFT 0x14
#define PCIE_TX_CNTL__TX_NP_PASS_P_MASK 0x200000
#define PCIE_TX_CNTL__TX_NP_PASS_P__SHIFT 0x15
#define PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS_MASK 0x400000
#define PCIE_TX_CNTL__TX_CLEAR_EXTRA_PM_REQS__SHIFT 0x16
#define PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS_MASK 0x800000
#define PCIE_TX_CNTL__TX_FC_UPDATE_TIMEOUT_DIS__SHIFT 0x17
#define PCIE_TX_CNTL__TX_F0_TPH_DIS_MASK 0x1000000
#define PCIE_TX_CNTL__TX_F0_TPH_DIS__SHIFT 0x18
#define PCIE_TX_CNTL__TX_F1_TPH_DIS_MASK 0x2000000
#define PCIE_TX_CNTL__TX_F1_TPH_DIS__SHIFT 0x19
#define PCIE_TX_CNTL__TX_F2_TPH_DIS_MASK 0x4000000
#define PCIE_TX_CNTL__TX_F2_TPH_DIS__SHIFT 0x1a
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION_MASK 0x7
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_FUNCTION__SHIFT 0x0
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE_MASK 0xf8
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_DEVICE__SHIFT 0x3
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS_MASK 0xff00
#define PCIE_TX_REQUESTER_ID__TX_REQUESTER_ID_BUS__SHIFT 0x8
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA_MASK 0xffffff
#define PCIE_TX_VENDOR_SPECIFIC__TX_VENDOR_DATA__SHIFT 0x0
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_MASK 0x3f000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP__SHIFT 0x18
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN_MASK 0x40000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_VC1_EN__SHIFT 0x1e
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN_MASK 0x80000000
#define PCIE_TX_REQUEST_NUM_CNTL__TX_NUM_OUTSTANDING_NP_EN__SHIFT 0x1f
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ_MASK 0xfff
#define PCIE_TX_SEQ__TX_NEXT_TRANSMIT_SEQ__SHIFT 0x0
#define PCIE_TX_SEQ__TX_ACKD_SEQ_MASK 0xfff0000
#define PCIE_TX_SEQ__TX_ACKD_SEQ__SHIFT 0x10
#define PCIE_TX_REPLAY__TX_REPLAY_NUM_MASK 0x7
#define PCIE_TX_REPLAY__TX_REPLAY_NUM__SHIFT 0x0
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE_MASK 0x8000
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_OVERWRITE__SHIFT 0xf
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER_MASK 0xffff0000
#define PCIE_TX_REPLAY__TX_REPLAY_TIMER__SHIFT 0x10
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_MASK 0xfff
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT__SHIFT 0x0
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE_MASK 0x1000
#define PCIE_TX_ACK_LATENCY_LIMIT__TX_ACK_LATENCY_LIMIT_OVERWRITE__SHIFT 0xc
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_P__TX_CREDITS_ADVT_PH__SHIFT 0x10
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_NP__TX_CREDITS_ADVT_NPH__SHIFT 0x10
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD_MASK 0xfff
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLD__SHIFT 0x0
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH_MASK 0xff0000
#define PCIE_TX_CREDITS_ADVT_CPL__TX_CREDITS_ADVT_CPLH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_P__TX_CREDITS_INIT_PH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_NP__TX_CREDITS_INIT_NPH__SHIFT 0x10
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD_MASK 0xfff
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLD__SHIFT 0x0
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH_MASK 0xff0000
#define PCIE_TX_CREDITS_INIT_CPL__TX_CREDITS_INIT_CPLH__SHIFT 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD_MASK 0x1
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PD__SHIFT 0x0
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH_MASK 0x2
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_PH__SHIFT 0x1
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD_MASK 0x4
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPD__SHIFT 0x2
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH_MASK 0x8
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_NPH__SHIFT 0x3
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD_MASK 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLD__SHIFT 0x4
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH_MASK 0x20
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_ERR_CPLH__SHIFT 0x5
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD_MASK 0x10000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PD__SHIFT 0x10
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH_MASK 0x20000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_PH__SHIFT 0x11
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD_MASK 0x40000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPD__SHIFT 0x12
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH_MASK 0x80000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_NPH__SHIFT 0x13
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD_MASK 0x100000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLD__SHIFT 0x14
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH_MASK 0x200000
#define PCIE_TX_CREDITS_STATUS__TX_CREDITS_CUR_STATUS_CPLH__SHIFT 0x15
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0_MASK 0x7
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC0__SHIFT 0x0
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0_MASK 0x70
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC0__SHIFT 0x4
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0_MASK 0x700
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC0__SHIFT 0x8
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1_MASK 0x70000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_P_VC1__SHIFT 0x10
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1_MASK 0x700000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_NP_VC1__SHIFT 0x14
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1_MASK 0x7000000
#define PCIE_TX_CREDITS_FCU_THRESHOLD__TX_FCU_THRESHOLD_CPL_VC1__SHIFT 0x18
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL_MASK 0x1
#define PCIE_P_PORT_LANE_STATUS__PORT_LANE_REVERSAL__SHIFT 0x0
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH_MASK 0x7e
#define PCIE_P_PORT_LANE_STATUS__PHY_LINK_WIDTH__SHIFT 0x1
#define PCIE_FC_P__PD_CREDITS_MASK 0xff
#define PCIE_FC_P__PD_CREDITS__SHIFT 0x0
#define PCIE_FC_P__PH_CREDITS_MASK 0xff00
#define PCIE_FC_P__PH_CREDITS__SHIFT 0x8
#define PCIE_FC_NP__NPD_CREDITS_MASK 0xff
#define PCIE_FC_NP__NPD_CREDITS__SHIFT 0x0
#define PCIE_FC_NP__NPH_CREDITS_MASK 0xff00
#define PCIE_FC_NP__NPH_CREDITS__SHIFT 0x8
#define PCIE_FC_CPL__CPLD_CREDITS_MASK 0xff
#define PCIE_FC_CPL__CPLD_CREDITS__SHIFT 0x0
#define PCIE_FC_CPL__CPLH_CREDITS_MASK 0xff00
#define PCIE_FC_CPL__CPLH_CREDITS__SHIFT 0x8
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS_MASK 0x1
#define PCIE_ERR_CNTL__ERR_REPORTING_DIS__SHIFT 0x0
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG_MASK 0x2
#define PCIE_ERR_CNTL__STRAP_FIRST_RCVD_ERR_LOG__SHIFT 0x1
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES_MASK 0x4
#define PCIE_ERR_CNTL__RX_DROP_ECRC_FAILURES__SHIFT 0x2
#define PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR_MASK 0x10
#define PCIE_ERR_CNTL__TX_GENERATE_LCRC_ERR__SHIFT 0x4
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR_MASK 0x20
#define PCIE_ERR_CNTL__RX_GENERATE_LCRC_ERR__SHIFT 0x5
#define PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR_MASK 0x40
#define PCIE_ERR_CNTL__TX_GENERATE_ECRC_ERR__SHIFT 0x6
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR_MASK 0x80
#define PCIE_ERR_CNTL__RX_GENERATE_ECRC_ERR__SHIFT 0x7
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT_MASK 0x700
#define PCIE_ERR_CNTL__AER_HDR_LOG_TIMEOUT__SHIFT 0x8
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED_MASK 0x800
#define PCIE_ERR_CNTL__AER_HDR_LOG_F0_TIMER_EXPIRED__SHIFT 0xb
#define PCIE_ERR_CNTL__AER_HDR_LOG_F1_TIMER_EXPIRED_MASK 0x1000
#define PCIE_ERR_CNTL__AER_HDR_LOG_F1_TIMER_EXPIRED__SHIFT 0xc
#define PCIE_ERR_CNTL__AER_HDR_LOG_F2_TIMER_EXPIRED_MASK 0x2000
#define PCIE_ERR_CNTL__AER_HDR_LOG_F2_TIMER_EXPIRED__SHIFT 0xd
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS_MASK 0x4000
#define PCIE_ERR_CNTL__CI_P_SLV_BUF_RD_HALT_STATUS__SHIFT 0xe
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS_MASK 0x8000
#define PCIE_ERR_CNTL__CI_NP_SLV_BUF_RD_HALT_STATUS__SHIFT 0xf
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET_MASK 0x10000
#define PCIE_ERR_CNTL__CI_SLV_BUF_HALT_RESET__SHIFT 0x10
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY_MASK 0x20000
#define PCIE_ERR_CNTL__SEND_ERR_MSG_IMMEDIATELY__SHIFT 0x11
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL_MASK 0x40000
#define PCIE_ERR_CNTL__STRAP_POISONED_ADVISORY_NONFATAL__SHIFT 0x12
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR_MASK 0x1
#define PCIE_RX_CNTL__RX_IGNORE_IO_ERR__SHIFT 0x0
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR_MASK 0x2
#define PCIE_RX_CNTL__RX_IGNORE_BE_ERR__SHIFT 0x1
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR_MASK 0x4
#define PCIE_RX_CNTL__RX_IGNORE_MSG_ERR__SHIFT 0x2
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR_MASK 0x8
#define PCIE_RX_CNTL__RX_IGNORE_CRC_ERR__SHIFT 0x3
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR_MASK 0x10
#define PCIE_RX_CNTL__RX_IGNORE_CFG_ERR__SHIFT 0x4
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR_MASK 0x20
#define PCIE_RX_CNTL__RX_IGNORE_CPL_ERR__SHIFT 0x5
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR_MASK 0x40
#define PCIE_RX_CNTL__RX_IGNORE_EP_ERR__SHIFT 0x6
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR_MASK 0x80
#define PCIE_RX_CNTL__RX_IGNORE_LEN_MISMATCH_ERR__SHIFT 0x7
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR_MASK 0x100
#define PCIE_RX_CNTL__RX_IGNORE_MAX_PAYLOAD_ERR__SHIFT 0x8
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR_MASK 0x200
#define PCIE_RX_CNTL__RX_IGNORE_TC_ERR__SHIFT 0x9
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR_MASK 0x400
#define PCIE_RX_CNTL__RX_IGNORE_CFG_UR__SHIFT 0xa
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR_MASK 0x800
#define PCIE_RX_CNTL__RX_IGNORE_IO_UR__SHIFT 0xb
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR_MASK 0x1000
#define PCIE_RX_CNTL__RX_IGNORE_AT_ERR__SHIFT 0xc
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL_MASK 0x2000
#define PCIE_RX_CNTL__RX_NAK_IF_FIFO_FULL__SHIFT 0xd
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK_MASK 0x4000
#define PCIE_RX_CNTL__RX_GEN_ONE_NAK__SHIFT 0xe
#define PCIE_RX_CNTL__RX_FC_INIT_FROM_REG_MASK 0x8000
#define PCIE_RX_CNTL__RX_FC_INIT_FROM_REG__SHIFT 0xf
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MASK 0x70000
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT__SHIFT 0x10
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE_MASK 0x80000
#define PCIE_RX_CNTL__RX_RCB_CPL_TIMEOUT_MODE__SHIFT 0x13
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS_MASK 0x100000
#define PCIE_RX_CNTL__RX_PCIE_CPL_TIMEOUT_DIS__SHIFT 0x14
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR_MASK 0x200000
#define PCIE_RX_CNTL__RX_IGNORE_SHORTPREFIX_ERR__SHIFT 0x15
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR_MASK 0x400000
#define PCIE_RX_CNTL__RX_IGNORE_MAXPREFIX_ERR__SHIFT 0x16
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR_MASK 0x800000
#define PCIE_RX_CNTL__RX_IGNORE_CPLPREFIX_ERR__SHIFT 0x17
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR_MASK 0x1000000
#define PCIE_RX_CNTL__RX_IGNORE_INVALIDPASID_ERR__SHIFT 0x18
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR_MASK 0x2000000
#define PCIE_RX_CNTL__RX_IGNORE_NOT_PASID_UR__SHIFT 0x19
#define PCIE_RX_CNTL__RX_TPH_DIS_MASK 0x4000000
#define PCIE_RX_CNTL__RX_TPH_DIS__SHIFT 0x1a
#define PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS_MASK 0x8000000
#define PCIE_RX_CNTL__RX_RCB_FLR_TIMEOUT_DIS__SHIFT 0x1b
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM_MASK 0xfff
#define PCIE_RX_EXPECTED_SEQNUM__RX_EXPECTED_SEQNUM__SHIFT 0x0
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA_MASK 0xffffff
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_DATA__SHIFT 0x0
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS_MASK 0x1000000
#define PCIE_RX_VENDOR_SPECIFIC__RX_VENDOR_STATUS__SHIFT 0x18
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR_MASK 0x1
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMRDPASID_UR__SHIFT 0x0
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR_MASK 0x2
#define PCIE_RX_CNTL3__RX_IGNORE_RC_TRANSMWRPASID_UR__SHIFT 0x1
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR_MASK 0x4
#define PCIE_RX_CNTL3__RX_IGNORE_RC_PRGRESPMSG_UR__SHIFT 0x2
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR_MASK 0x8
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVREQ_UR__SHIFT 0x3
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR_MASK 0x10
#define PCIE_RX_CNTL3__RX_IGNORE_RC_INVCPLPASID_UR__SHIFT 0x4
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_P__RX_CREDITS_ALLOCATED_PH__SHIFT 0x10
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_NP__RX_CREDITS_ALLOCATED_NPH__SHIFT 0x10
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD_MASK 0xfff
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLD__SHIFT 0x0
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH_MASK 0xff0000
#define PCIE_RX_CREDITS_ALLOCATED_CPL__RX_CREDITS_ALLOCATED_CPLH__SHIFT 0x10
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR_MASK 0x3
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LANE_ERR__SHIFT 0x0
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR_MASK 0xc
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_FRAMING_ERR__SHIFT 0x2
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP_MASK 0x30
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_PARITY_IN_SKP__SHIFT 0x4
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP_MASK 0xc0
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_LFSR_IN_SKP__SHIFT 0x6
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW_MASK 0x300
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_UFLOW__SHIFT 0x8
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW_MASK 0xc00
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_LOOPBACK_OFLOW__SHIFT 0xa
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR_MASK 0x3000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_DESKEW_ERR__SHIFT 0xc
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR_MASK 0xc000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DISPARITY_ERR__SHIFT 0xe
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR_MASK 0x30000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_8B10B_DECODE_ERR__SHIFT 0x10
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR_MASK 0xc0000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_SKP_OS_ERROR__SHIFT 0x12
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER_MASK 0x300000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_INV_OS_IDENTIFIER__SHIFT 0x14
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER_MASK 0xc00000
#define PCIEP_ERROR_INJECT_PHYSICAL__ERROR_INJECT_PL_BAD_SYNC_HEADER__SHIFT 0x16
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR_MASK 0x3
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_FLOW_CTL_ERR__SHIFT 0x0
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER_MASK 0xc
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_REPLAY_NUM_ROLLOVER__SHIFT 0x2
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP_MASK 0x30
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_DLLP__SHIFT 0x4
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP_MASK 0xc0
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_BAD_TLP__SHIFT 0x6
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ_MASK 0x300
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNSUPPORTED_REQ__SHIFT 0x8
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR_MASK 0xc00
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_ECRC_ERROR__SHIFT 0xa
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP_MASK 0x3000
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_MALFORMED_TLP__SHIFT 0xc
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT_MASK 0xc000
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_UNEXPECTED_CMPLT__SHIFT 0xe
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT_MASK 0x30000
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETER_ABORT__SHIFT 0x10
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT_MASK 0xc0000
#define PCIEP_ERROR_INJECT_TRANSACTION__ERROR_INJECT_TL_COMPLETION_TIMEOUT__SHIFT 0x12
#define PCIEP_SRIOV_PRIV_CTRL__RX_SRIOV_VF_MAPPING_MODE_MASK 0x3
#define PCIEP_SRIOV_PRIV_CTRL__RX_SRIOV_VF_MAPPING_MODE__SHIFT 0x0
#define PCIEP_SRIOV_PRIV_CTRL__SRIOV_SAVE_VFS_ON_VFENABLE_CLR_MASK 0xc
#define PCIEP_SRIOV_PRIV_CTRL__SRIOV_SAVE_VFS_ON_VFENABLE_CLR__SHIFT 0x2
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0_MASK 0x2
#define PCIE_LC_CNTL__LC_DONT_ENTER_L23_IN_D0__SHIFT 0x1
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN_MASK 0x4
#define PCIE_LC_CNTL__LC_RESET_L_IDLE_COUNT_EN__SHIFT 0x2
#define PCIE_LC_CNTL__LC_RESET_LINK_MASK 0x8
#define PCIE_LC_CNTL__LC_RESET_LINK__SHIFT 0x3
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE_MASK 0xf0
#define PCIE_LC_CNTL__LC_16X_CLEAR_TX_PIPE__SHIFT 0x4
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY_MASK 0xf00
#define PCIE_LC_CNTL__LC_L0S_INACTIVITY__SHIFT 0x8
#define PCIE_LC_CNTL__LC_L1_INACTIVITY_MASK 0xf000
#define PCIE_LC_CNTL__LC_L1_INACTIVITY__SHIFT 0xc
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS_MASK 0x10000
#define PCIE_LC_CNTL__LC_PMI_TO_L1_DIS__SHIFT 0x10
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN_MASK 0x20000
#define PCIE_LC_CNTL__LC_INC_N_FTS_EN__SHIFT 0x11
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23_MASK 0xc0000
#define PCIE_LC_CNTL__LC_LOOK_FOR_IDLE_IN_L1L23__SHIFT 0x12
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC_MASK 0x100000
#define PCIE_LC_CNTL__LC_FACTOR_IN_EXT_SYNC__SHIFT 0x14
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS_MASK 0x200000
#define PCIE_LC_CNTL__LC_WAIT_FOR_PM_ACK_DIS__SHIFT 0x15
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23_MASK 0x400000
#define PCIE_LC_CNTL__LC_WAKE_FROM_L23__SHIFT 0x16
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK_MASK 0x800000
#define PCIE_LC_CNTL__LC_L1_IMMEDIATE_ACK__SHIFT 0x17
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS_MASK 0x1000000
#define PCIE_LC_CNTL__LC_ASPM_TO_L1_DIS__SHIFT 0x18
#define PCIE_LC_CNTL__LC_DELAY_COUNT_MASK 0x6000000
#define PCIE_LC_CNTL__LC_DELAY_COUNT__SHIFT 0x19
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT_MASK 0x8000000
#define PCIE_LC_CNTL__LC_DELAY_L0S_EXIT__SHIFT 0x1b
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT_MASK 0x10000000
#define PCIE_LC_CNTL__LC_DELAY_L1_EXIT__SHIFT 0x1c
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE_MASK 0x20000000
#define PCIE_LC_CNTL__LC_EXTEND_WAIT_FOR_EL_IDLE__SHIFT 0x1d
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN_MASK 0x40000000
#define PCIE_LC_CNTL__LC_ESCAPE_L1L23_EN__SHIFT 0x1e
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE_MASK 0x80000000
#define PCIE_LC_CNTL__LC_GATE_RCVR_IDLE__SHIFT 0x1f
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE_MASK 0x3f
#define PCIE_LC_CNTL2__LC_TIMED_OUT_STATE__SHIFT 0x0
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT_MASK 0x40
#define PCIE_LC_CNTL2__LC_STATE_TIMED_OUT__SHIFT 0x6
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION_MASK 0x80
#define PCIE_LC_CNTL2__LC_LOOK_FOR_BW_REDUCTION__SHIFT 0x7
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN_MASK 0x100
#define PCIE_LC_CNTL2__LC_MORE_TS2_EN__SHIFT 0x8
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS_MASK 0x200
#define PCIE_LC_CNTL2__LC_X12_NEGOTIATION_DIS__SHIFT 0x9
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN_MASK 0x400
#define PCIE_LC_CNTL2__LC_LINK_UP_REVERSAL_EN__SHIFT 0xa
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_MASK 0x800
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE__SHIFT 0xb
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN_MASK 0x1000
#define PCIE_LC_CNTL2__LC_ILLEGAL_STATE_RESTART_EN__SHIFT 0xc
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE_MASK 0x2000
#define PCIE_LC_CNTL2__LC_WAIT_FOR_OTHER_LANES_MODE__SHIFT 0xd
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE_MASK 0xc000
#define PCIE_LC_CNTL2__LC_ELEC_IDLE_MODE__SHIFT 0xe
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET_MASK 0x10000
#define PCIE_LC_CNTL2__LC_DISABLE_INFERRED_ELEC_IDLE_DET__SHIFT 0x10
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1_MASK 0x20000
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L1__SHIFT 0x11
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23_MASK 0x40000
#define PCIE_LC_CNTL2__LC_ALLOW_PDWN_IN_L23__SHIFT 0x12
#define PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S_MASK 0x80000
#define PCIE_LC_CNTL2__LC_DEASSERT_RX_EN_IN_L0S__SHIFT 0x13
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0_MASK 0x100000
#define PCIE_LC_CNTL2__LC_BLOCK_EL_IDLE_IN_L0__SHIFT 0x14
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS_MASK 0x200000
#define PCIE_LC_CNTL2__LC_RCV_L0_TO_RCV_L0S_DIS__SHIFT 0x15
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD_MASK 0x400000
#define PCIE_LC_CNTL2__LC_ASSERT_INACTIVE_DURING_HOLD__SHIFT 0x16
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG_MASK 0x1800000
#define PCIE_LC_CNTL2__LC_WAIT_FOR_LANES_IN_LW_NEG__SHIFT 0x17
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES_MASK 0x2000000
#define PCIE_LC_CNTL2__LC_PWR_DOWN_NEG_OFF_LANES__SHIFT 0x19
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS_MASK 0x4000000
#define PCIE_LC_CNTL2__LC_DISABLE_LOST_SYM_LOCK_ARCS__SHIFT 0x1a
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS_MASK 0x8000000
#define PCIE_LC_CNTL2__LC_LINK_BW_NOTIFICATION_DIS__SHIFT 0x1b
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE_MASK 0x10000000
#define PCIE_LC_CNTL2__LC_PMI_L1_WAIT_FOR_SLV_IDLE__SHIFT 0x1c
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL_MASK 0x60000000
#define PCIE_LC_CNTL2__LC_TEST_TIMER_SEL__SHIFT 0x1d
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI_MASK 0x80000000
#define PCIE_LC_CNTL2__LC_ENABLE_INFERRED_ELEC_IDLE_FOR_PI__SHIFT 0x1f
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_MASK 0x1
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS__SHIFT 0x0
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL_MASK 0x6
#define PCIE_LC_CNTL3__LC_SELECT_DEEMPHASIS_CNTL__SHIFT 0x1
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS_MASK 0x8
#define PCIE_LC_CNTL3__LC_RCVD_DEEMPHASIS__SHIFT 0x3
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT_MASK 0x10
#define PCIE_LC_CNTL3__LC_COMP_TO_DETECT__SHIFT 0x4
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN_MASK 0x20
#define PCIE_LC_CNTL3__LC_RESET_TSX_CNT_IN_RLOCK_EN__SHIFT 0x5
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc0
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0x6
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x100
#define PCIE_LC_CNTL3__LC_AUTO_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0x8
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT_MASK 0x200
#define PCIE_LC_CNTL3__LC_CLR_FAILED_AUTO_SPD_CHANGE_CNT__SHIFT 0x9
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN_MASK 0x400
#define PCIE_LC_CNTL3__LC_ENHANCED_HOT_PLUG_EN__SHIFT 0xa
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE_MASK 0x800
#define PCIE_LC_CNTL3__LC_RCVR_DET_EN_OVERRIDE__SHIFT 0xb
#define PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD_MASK 0x3000
#define PCIE_LC_CNTL3__LC_EHP_RX_PHY_CMD__SHIFT 0xc
#define PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD_MASK 0xc000
#define PCIE_LC_CNTL3__LC_EHP_TX_PHY_CMD__SHIFT 0xe
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN_MASK 0x10000
#define PCIE_LC_CNTL3__LC_CHIP_BIF_USB_IDLE_EN__SHIFT 0x10
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN_MASK 0x20000
#define PCIE_LC_CNTL3__LC_L1_BLOCK_RECONFIG_EN__SHIFT 0x11
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN_MASK 0x40000
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_EN__SHIFT 0x12
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL_MASK 0x180000
#define PCIE_LC_CNTL3__LC_AUTO_DISABLE_SPEED_SUPPORT_MAX_FAIL_SEL__SHIFT 0x13
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN_MASK 0x200000
#define PCIE_LC_CNTL3__LC_FAST_L1_ENTRY_EXIT_EN__SHIFT 0x15
#define PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE_MASK 0x400000
#define PCIE_LC_CNTL3__LC_RXPHYCMD_INACTIVE_EN_MODE__SHIFT 0x16
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK_MASK 0x800000
#define PCIE_LC_CNTL3__LC_DSC_DONT_ENTER_L23_AFTER_PME_ACK__SHIFT 0x17
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL_MASK 0x3000000
#define PCIE_LC_CNTL3__LC_HW_VOLTAGE_IF_CONTROL__SHIFT 0x18
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL_MASK 0x3c000000
#define PCIE_LC_CNTL3__LC_VOLTAGE_TIMER_SEL__SHIFT 0x1a
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY_MASK 0x40000000
#define PCIE_LC_CNTL3__LC_GO_TO_RECOVERY__SHIFT 0x1e
#define PCIE_LC_CNTL3__LC_N_EIE_SEL_MASK 0x80000000
#define PCIE_LC_CNTL3__LC_N_EIE_SEL__SHIFT 0x1f
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR_MASK 0x3
#define PCIE_LC_CNTL4__LC_TX_ENABLE_BEHAVIOUR__SHIFT 0x0
#define PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK_MASK 0x4
#define PCIE_LC_CNTL4__LC_DIS_CONTIG_END_SET_CHECK__SHIFT 0x2
#define PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE_MASK 0x8
#define PCIE_LC_CNTL4__LC_DIS_ASPM_L1_IN_SPEED_CHANGE__SHIFT 0x3
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_MASK 0x10
#define PCIE_LC_CNTL4__LC_BYPASS_EQ__SHIFT 0x4
#define PCIE_LC_CNTL4__LC_REDO_EQ_MASK 0x20
#define PCIE_LC_CNTL4__LC_REDO_EQ__SHIFT 0x5
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS_MASK 0x40
#define PCIE_LC_CNTL4__LC_EXTEND_EIEOS__SHIFT 0x6
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY_MASK 0x80
#define PCIE_LC_CNTL4__LC_IGNORE_PARITY__SHIFT 0x7
#define PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE_MASK 0x300
#define PCIE_LC_CNTL4__LC_EQ_SEARCH_MODE__SHIFT 0x8
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK_MASK 0x400
#define PCIE_LC_CNTL4__LC_DSC_CHECK_COEFFS_IN_RLOCK__SHIFT 0xa
#define PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD_MASK 0x800
#define PCIE_LC_CNTL4__LC_USC_EQ_NOT_REQD__SHIFT 0xb
#define PCIE_LC_CNTL4__LC_USC_GO_TO_EQ_MASK 0x1000
#define PCIE_LC_CNTL4__LC_USC_GO_TO_EQ__SHIFT 0xc
#define PCIE_LC_CNTL4__LC_SET_QUIESCE_MASK 0x2000
#define PCIE_LC_CNTL4__LC_SET_QUIESCE__SHIFT 0xd
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD_MASK 0x4000
#define PCIE_LC_CNTL4__LC_QUIESCE_RCVD__SHIFT 0xe
#define PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD_MASK 0x8000
#define PCIE_LC_CNTL4__LC_UNEXPECTED_COEFFS_RCVD__SHIFT 0xf
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE_MASK 0x10000
#define PCIE_LC_CNTL4__LC_BYPASS_EQ_REQ_PHASE__SHIFT 0x10
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE_MASK 0x20000
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_IN_EQ_REQ_PHASE__SHIFT 0x11
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE_MASK 0x3c0000
#define PCIE_LC_CNTL4__LC_FORCE_PRESET_VALUE__SHIFT 0x12
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS_MASK 0x400000
#define PCIE_LC_CNTL4__LC_USC_DELAY_DLLPS__SHIFT 0x16
#define PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING_MASK 0x800000
#define PCIE_LC_CNTL4__LC_PCIE_TX_FULL_SWING__SHIFT 0x17
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE_MASK 0x1000000
#define PCIE_LC_CNTL4__LC_EQ_WAIT_FOR_EVAL_DONE__SHIFT 0x18
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN_MASK 0x2000000
#define PCIE_LC_CNTL4__LC_8GT_SKIP_ORDER_EN__SHIFT 0x19
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK_MASK 0xfc000000
#define PCIE_LC_CNTL4__LC_WAIT_FOR_MORE_TS_IN_RLOCK__SHIFT 0x1a
#define PCIE_LC_CNTL5__LC_EQ_FS_0_MASK 0x3f
#define PCIE_LC_CNTL5__LC_EQ_FS_0__SHIFT 0x0
#define PCIE_LC_CNTL5__LC_EQ_FS_8_MASK 0xfc0
#define PCIE_LC_CNTL5__LC_EQ_FS_8__SHIFT 0x6
#define PCIE_LC_CNTL5__LC_EQ_LF_0_MASK 0x3f000
#define PCIE_LC_CNTL5__LC_EQ_LF_0__SHIFT 0xc
#define PCIE_LC_CNTL5__LC_EQ_LF_8_MASK 0xfc0000
#define PCIE_LC_CNTL5__LC_EQ_LF_8__SHIFT 0x12
#define PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS_MASK 0x1000000
#define PCIE_LC_CNTL5__LC_DSC_EQ_FS_LF_INVALID_TO_PRESETS__SHIFT 0x18
#define PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT_MASK 0x1
#define PCIE_LC_CNTL6__LC_SPC_MODE_2P5GT__SHIFT 0x0
#define PCIE_LC_CNTL6__LC_SPC_MODE_5GT_MASK 0x4
#define PCIE_LC_CNTL6__LC_SPC_MODE_5GT__SHIFT 0x2
#define PCIE_LC_CNTL6__LC_SPC_MODE_8GT_MASK 0x10
#define PCIE_LC_CNTL6__LC_SPC_MODE_8GT__SHIFT 0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN_MASK 0x1
#define PCIE_LC_BW_CHANGE_CNTL__LC_BW_CHANGE_INT_EN__SHIFT 0x0
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE_MASK 0x2
#define PCIE_LC_BW_CHANGE_CNTL__LC_HW_INIT_SPEED_CHANGE__SHIFT 0x1
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE_MASK 0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_SW_INIT_SPEED_CHANGE__SHIFT 0x2
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE_MASK 0x8
#define PCIE_LC_BW_CHANGE_CNTL__LC_OTHER_INIT_SPEED_CHANGE__SHIFT 0x3
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE_MASK 0x10
#define PCIE_LC_BW_CHANGE_CNTL__LC_RELIABILITY_SPEED_CHANGE__SHIFT 0x4
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG_MASK 0x20
#define PCIE_LC_BW_CHANGE_CNTL__LC_FAILED_SPEED_NEG__SHIFT 0x5
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE_MASK 0x40
#define PCIE_LC_BW_CHANGE_CNTL__LC_LONG_LW_CHANGE__SHIFT 0x6
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE_MASK 0x80
#define PCIE_LC_BW_CHANGE_CNTL__LC_SHORT_LW_CHANGE__SHIFT 0x7
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER_MASK 0x100
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_OTHER__SHIFT 0x8
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED_MASK 0x200
#define PCIE_LC_BW_CHANGE_CNTL__LC_LW_CHANGE_FAILED__SHIFT 0x9
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE_MASK 0x400
#define PCIE_LC_BW_CHANGE_CNTL__LC_LINK_BW_NOTIFICATION_DETECT_MODE__SHIFT 0xa
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL_MASK 0xf
#define PCIE_LC_TRAINING_CNTL__LC_TRAINING_CNTL__SHIFT 0x0
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE_MASK 0x10
#define PCIE_LC_TRAINING_CNTL__LC_COMPLIANCE_RECEIVE__SHIFT 0x4
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1_MASK 0x20
#define PCIE_LC_TRAINING_CNTL__LC_LOOK_FOR_MORE_NON_MATCHING_TS1__SHIFT 0x5
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN_MASK 0x40
#define PCIE_LC_TRAINING_CNTL__LC_L0S_L1_TRAINING_CNTL_EN__SHIFT 0x6
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN_MASK 0x80
#define PCIE_LC_TRAINING_CNTL__LC_L1_LONG_WAKE_FIX_EN__SHIFT 0x7
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE_MASK 0x700
#define PCIE_LC_TRAINING_CNTL__LC_POWER_STATE__SHIFT 0x8
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED_MASK 0x800
#define PCIE_LC_TRAINING_CNTL__LC_DONT_GO_TO_L0S_IF_L1_ARMED__SHIFT 0xb
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN_MASK 0x1000
#define PCIE_LC_TRAINING_CNTL__LC_INIT_SPD_CHG_WITH_CSR_EN__SHIFT 0xc
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH_MASK 0x2000
#define PCIE_LC_TRAINING_CNTL__LC_DISABLE_TRAINING_BIT_ARCH__SHIFT 0xd
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG_MASK 0x4000
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_SETS_IN_RCFG__SHIFT 0xe
#define PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN_MASK 0x8000
#define PCIE_LC_TRAINING_CNTL__LC_HOT_RESET_QUICK_EXIT_EN__SHIFT 0xf
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP_MASK 0x10000
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_WAIT_FOR_SKP__SHIFT 0x10
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF_MASK 0x20000
#define PCIE_LC_TRAINING_CNTL__LC_AUTONOMOUS_CHANGE_OFF__SHIFT 0x11
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF_MASK 0x40000
#define PCIE_LC_TRAINING_CNTL__LC_UPCONFIGURE_CAP_OFF__SHIFT 0x12
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN_MASK 0x80000
#define PCIE_LC_TRAINING_CNTL__LC_HW_LINK_DIS_EN__SHIFT 0x13
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW_MASK 0x100000
#define PCIE_LC_TRAINING_CNTL__LC_LINK_DIS_BY_HW__SHIFT 0x14
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN_MASK 0x200000
#define PCIE_LC_TRAINING_CNTL__LC_STATIC_TX_PIPE_COUNT_EN__SHIFT 0x15
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL_MASK 0xc00000
#define PCIE_LC_TRAINING_CNTL__LC_ASPM_L1_NAK_TIMER_SEL__SHIFT 0x16
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED_MASK 0x1000000
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_R_SPEED__SHIFT 0x18
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST_MASK 0x2000000
#define PCIE_LC_TRAINING_CNTL__LC_DONT_DEASSERT_RX_EN_IN_TEST__SHIFT 0x19
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER_MASK 0x4000000
#define PCIE_LC_TRAINING_CNTL__LC_RESET_ASPM_L1_NAK_TIMER__SHIFT 0x1a
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT_MASK 0x8000000
#define PCIE_LC_TRAINING_CNTL__LC_SHORT_RCFG_TIMEOUT__SHIFT 0x1b
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL_MASK 0x10000000
#define PCIE_LC_TRAINING_CNTL__LC_ALLOW_TX_L1_CONTROL__SHIFT 0x1c
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK_MASK 0x20000000
#define PCIE_LC_TRAINING_CNTL__LC_WAIT_FOR_FOM_VALID_AFTER_TRACK__SHIFT 0x1d
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME_MASK 0xc0000000
#define PCIE_LC_TRAINING_CNTL__LC_EXTEND_EQ_REQ_TIME__SHIFT 0x1e
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_MASK 0x7
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH__SHIFT 0x0
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD_MASK 0x70
#define PCIE_LC_LINK_WIDTH_CNTL__LC_LINK_WIDTH_RD__SHIFT 0x4
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE_MASK 0x80
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_ARC_MISSING_ESCAPE__SHIFT 0x7
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW_MASK 0x100
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RECONFIG_NOW__SHIFT 0x8
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT_MASK 0x200
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATION_SUPPORT__SHIFT 0x9
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN_MASK 0x400
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RENEGOTIATE_EN__SHIFT 0xa
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN_MASK 0x800
#define PCIE_LC_LINK_WIDTH_CNTL__LC_SHORT_RECONFIG_EN__SHIFT 0xb
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT_MASK 0x1000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_SUPPORT__SHIFT 0xc
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS_MASK 0x2000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_DIS__SHIFT 0xd
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS_MASK 0x4000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_WAIT_FOR_RCVR_DIS__SHIFT 0xe
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL_MASK 0x8000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCFG_TIMER_SEL__SHIFT 0xf
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB_MASK 0x10000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DEASSERT_TX_PDNB__SHIFT 0x10
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN_MASK 0x20000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_L1_RECONFIG_EN__SHIFT 0x11
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN_MASK 0x40000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYNLINK_MST_EN__SHIFT 0x12
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN_MASK 0x80000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DUAL_END_RECONFIG_EN__SHIFT 0x13
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE_MASK 0x100000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_UPCONFIGURE_CAPABLE__SHIFT 0x14
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE_MASK 0x600000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_DYN_LANES_PWR_STATE__SHIFT 0x15
#define PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN_MASK 0x800000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_EQ_REVERSAL_LOGIC_EN__SHIFT 0x17
#define PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN_MASK 0x1000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_MULT_REVERSE_ATTEMP_EN__SHIFT 0x18
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN_MASK 0x2000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_RESET_TSX_CNT_IN_RCONFIG_EN__SHIFT 0x19
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE_MASK 0x4000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_L_IDLE_IN_R_IDLE__SHIFT 0x1a
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT_MASK 0x8000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_WAIT_FOR_NON_EI_ON_RXL0S_EXIT__SHIFT 0x1b
#define PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE_MASK 0x10000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_HOLD_EI_FOR_RSPEED_CMD_CHANGE__SHIFT 0x1c
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI_MASK 0x20000000
#define PCIE_LC_LINK_WIDTH_CNTL__LC_BYPASS_RXL0S_ON_SHORT_EI__SHIFT 0x1d
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_MASK 0xff
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS__SHIFT 0x0
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN_MASK 0x100
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_OVERRIDE_EN__SHIFT 0x8
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY_MASK 0x200
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_FTS_BEFORE_RECOVERY__SHIFT 0x9
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT_MASK 0xff0000
#define PCIE_LC_N_FTS_CNTL__LC_XMIT_N_FTS_LIMIT__SHIFT 0x10
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS_MASK 0xff000000
#define PCIE_LC_N_FTS_CNTL__LC_N_FTS__SHIFT 0x18
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP_MASK 0x1
#define PCIE_LC_SPEED_CNTL__LC_GEN2_EN_STRAP__SHIFT 0x0
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP_MASK 0x2
#define PCIE_LC_SPEED_CNTL__LC_GEN3_EN_STRAP__SHIFT 0x1
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN_MASK 0x4
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_EN__SHIFT 0x2
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE_MASK 0x18
#define PCIE_LC_SPEED_CNTL__LC_TARGET_LINK_SPEED_OVERRIDE__SHIFT 0x3
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE_MASK 0x20
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_SW_SPEED_CHANGE__SHIFT 0x5
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE_MASK 0x40
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_SW_SPEED_CHANGE__SHIFT 0x6
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE_MASK 0x80
#define PCIE_LC_SPEED_CNTL__LC_FORCE_EN_HW_SPEED_CHANGE__SHIFT 0x7
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE_MASK 0x100
#define PCIE_LC_SPEED_CNTL__LC_FORCE_DIS_HW_SPEED_CHANGE__SHIFT 0x8
#define PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE_MASK 0x200
#define PCIE_LC_SPEED_CNTL__LC_INITIATE_LINK_SPEED_CHANGE__SHIFT 0x9
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED_MASK 0xc00
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPTS_ALLOWED__SHIFT 0xa
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED_MASK 0x1000
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_ATTEMPT_FAILED__SHIFT 0xc
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE_MASK 0x6000
#define PCIE_LC_SPEED_CNTL__LC_CURRENT_DATA_RATE__SHIFT 0xd
#define PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS_MASK 0x8000
#define PCIE_LC_SPEED_CNTL__LC_DONT_CLR_TARGET_SPD_CHANGE_STATUS__SHIFT 0xf
#define PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT_MASK 0x10000
#define PCIE_LC_SPEED_CNTL__LC_CLR_FAILED_SPD_CHANGE_CNT__SHIFT 0x10
#define PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN_MASK 0x20000
#define PCIE_LC_SPEED_CNTL__LC_1_OR_MORE_TS2_SPEED_ARC_EN__SHIFT 0x11
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2_MASK 0x40000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN2__SHIFT 0x12
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2_MASK 0x80000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN2__SHIFT 0x13
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3_MASK 0x100000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_EVER_SENT_GEN3__SHIFT 0x14
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3_MASK 0x200000
#define PCIE_LC_SPEED_CNTL__LC_OTHER_SIDE_SUPPORTS_GEN3__SHIFT 0x15
#define PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS_MASK 0x400000
#define PCIE_LC_SPEED_CNTL__LC_AUTO_RECOVERY_DIS__SHIFT 0x16
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS_MASK 0x800000
#define PCIE_LC_SPEED_CNTL__LC_SPEED_CHANGE_STATUS__SHIFT 0x17
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED_MASK 0x3000000
#define PCIE_LC_SPEED_CNTL__LC_DATA_RATE_ADVERTISED__SHIFT 0x18
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE_MASK 0x4000000
#define PCIE_LC_SPEED_CNTL__LC_CHECK_DATA_RATE__SHIFT 0x1a
#define PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN_MASK 0x8000000
#define PCIE_LC_SPEED_CNTL__LC_MULT_UPSTREAM_AUTO_SPD_CHNG_EN__SHIFT 0x1b
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN_MASK 0x10000000
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L0s_EN__SHIFT 0x1c
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN_MASK 0x20000000
#define PCIE_LC_SPEED_CNTL__LC_INIT_SPEED_NEG_IN_L1_EN__SHIFT 0x1d
#define PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG_MASK 0x40000000
#define PCIE_LC_SPEED_CNTL__LC_DONT_CHECK_EQTS_IN_RCFG__SHIFT 0x1e
#define PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS_MASK 0x80000000
#define PCIE_LC_SPEED_CNTL__LC_DELAY_COEFF_UPDATE_DIS__SHIFT 0x1f
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF_MASK 0xfff
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_OFF__SHIFT 0x0
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS_MASK 0xfff000
#define PCIE_LC_CDR_CNTL__LC_CDR_TEST_SETS__SHIFT 0xc
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE_MASK 0x3000000
#define PCIE_LC_CDR_CNTL__LC_CDR_SET_TYPE__SHIFT 0x18
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES_MASK 0xffff
#define PCIE_LC_LANE_CNTL__LC_CORRUPTED_LANES__SHIFT 0x0
#define PCIE_LC_LANE_CNTL__LC_LANE_DIS_MASK 0xffff0000
#define PCIE_LC_LANE_CNTL__LC_LANE_DIS__SHIFT 0x10
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF_MASK 0x1
#define PCIE_LC_FORCE_COEFF__LC_FORCE_COEFF__SHIFT 0x0
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR_MASK 0x7e
#define PCIE_LC_FORCE_COEFF__LC_FORCE_PRE_CURSOR__SHIFT 0x1
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR_MASK 0x1f80
#define PCIE_LC_FORCE_COEFF__LC_FORCE_CURSOR__SHIFT 0x7
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR_MASK 0x7e000
#define PCIE_LC_FORCE_COEFF__LC_FORCE_POST_CURSOR__SHIFT 0xd
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN_MASK 0x80000
#define PCIE_LC_FORCE_COEFF__LC_3X3_COEFF_SEARCH_EN__SHIFT 0x13
#define PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN_MASK 0x100000
#define PCIE_LC_FORCE_COEFF__LC_PRESET_10_EN__SHIFT 0x14
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET_MASK 0xf
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRESET__SHIFT 0x0
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR_MASK 0x3f0
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_PRECURSOR__SHIFT 0x4
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR_MASK 0xfc00
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_CURSOR__SHIFT 0xa
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR_MASK 0x3f0000
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_POSTCURSOR__SHIFT 0x10
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM_MASK 0x3fc00000
#define PCIE_LC_BEST_EQ_SETTINGS__LC_BEST_FOM__SHIFT 0x16
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE_MASK 0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_COEFF_IN_EQ_REQ_PHASE__SHIFT 0x0
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ_MASK 0x7e
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_PRE_CURSOR_REQ__SHIFT 0x1
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ_MASK 0x1f80
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_CURSOR_REQ__SHIFT 0x7
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ_MASK 0x7e000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FORCE_POST_CURSOR_REQ__SHIFT 0xd
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END_MASK 0x1f80000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_FS_OTHER_END__SHIFT 0x13
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END_MASK 0x7e000000
#define PCIE_LC_FORCE_EQ_REQ_COEFF__LC_LF_OTHER_END__SHIFT 0x19
#define PCIE_LC_STATE0__LC_CURRENT_STATE_MASK 0x3f
#define PCIE_LC_STATE0__LC_CURRENT_STATE__SHIFT 0x0
#define PCIE_LC_STATE0__LC_PREV_STATE1_MASK 0x3f00
#define PCIE_LC_STATE0__LC_PREV_STATE1__SHIFT 0x8
#define PCIE_LC_STATE0__LC_PREV_STATE2_MASK 0x3f0000
#define PCIE_LC_STATE0__LC_PREV_STATE2__SHIFT 0x10
#define PCIE_LC_STATE0__LC_PREV_STATE3_MASK 0x3f000000
#define PCIE_LC_STATE0__LC_PREV_STATE3__SHIFT 0x18
#define PCIE_LC_STATE1__LC_PREV_STATE4_MASK 0x3f
#define PCIE_LC_STATE1__LC_PREV_STATE4__SHIFT 0x0
#define PCIE_LC_STATE1__LC_PREV_STATE5_MASK 0x3f00
#define PCIE_LC_STATE1__LC_PREV_STATE5__SHIFT 0x8
#define PCIE_LC_STATE1__LC_PREV_STATE6_MASK 0x3f0000
#define PCIE_LC_STATE1__LC_PREV_STATE6__SHIFT 0x10
#define PCIE_LC_STATE1__LC_PREV_STATE7_MASK 0x3f000000
#define PCIE_LC_STATE1__LC_PREV_STATE7__SHIFT 0x18
#define PCIE_LC_STATE2__LC_PREV_STATE8_MASK 0x3f
#define PCIE_LC_STATE2__LC_PREV_STATE8__SHIFT 0x0
#define PCIE_LC_STATE2__LC_PREV_STATE9_MASK 0x3f00
#define PCIE_LC_STATE2__LC_PREV_STATE9__SHIFT 0x8
#define PCIE_LC_STATE2__LC_PREV_STATE10_MASK 0x3f0000
#define PCIE_LC_STATE2__LC_PREV_STATE10__SHIFT 0x10
#define PCIE_LC_STATE2__LC_PREV_STATE11_MASK 0x3f000000
#define PCIE_LC_STATE2__LC_PREV_STATE11__SHIFT 0x18
#define PCIE_LC_STATE3__LC_PREV_STATE12_MASK 0x3f
#define PCIE_LC_STATE3__LC_PREV_STATE12__SHIFT 0x0
#define PCIE_LC_STATE3__LC_PREV_STATE13_MASK 0x3f00
#define PCIE_LC_STATE3__LC_PREV_STATE13__SHIFT 0x8
#define PCIE_LC_STATE3__LC_PREV_STATE14_MASK 0x3f0000
#define PCIE_LC_STATE3__LC_PREV_STATE14__SHIFT 0x10
#define PCIE_LC_STATE3__LC_PREV_STATE15_MASK 0x3f000000
#define PCIE_LC_STATE3__LC_PREV_STATE15__SHIFT 0x18
#define PCIE_LC_STATE4__LC_PREV_STATE16_MASK 0x3f
#define PCIE_LC_STATE4__LC_PREV_STATE16__SHIFT 0x0
#define PCIE_LC_STATE4__LC_PREV_STATE17_MASK 0x3f00
#define PCIE_LC_STATE4__LC_PREV_STATE17__SHIFT 0x8
#define PCIE_LC_STATE4__LC_PREV_STATE18_MASK 0x3f0000
#define PCIE_LC_STATE4__LC_PREV_STATE18__SHIFT 0x10
#define PCIE_LC_STATE4__LC_PREV_STATE19_MASK 0x3f000000
#define PCIE_LC_STATE4__LC_PREV_STATE19__SHIFT 0x18
#define PCIE_LC_STATE5__LC_PREV_STATE20_MASK 0x3f
#define PCIE_LC_STATE5__LC_PREV_STATE20__SHIFT 0x0
#define PCIE_LC_STATE5__LC_PREV_STATE21_MASK 0x3f00
#define PCIE_LC_STATE5__LC_PREV_STATE21__SHIFT 0x8
#define PCIE_LC_STATE5__LC_PREV_STATE22_MASK 0x3f0000
#define PCIE_LC_STATE5__LC_PREV_STATE22__SHIFT 0x10
#define PCIE_LC_STATE5__LC_PREV_STATE23_MASK 0x3f000000
#define PCIE_LC_STATE5__LC_PREV_STATE23__SHIFT 0x18
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT_MASK 0x3
#define PCIEP_STRAP_LC__STRAP_FTS_yTSx_COUNT__SHIFT 0x0
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT_MASK 0xc
#define PCIEP_STRAP_LC__STRAP_LONG_yTSx_COUNT__SHIFT 0x2
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT_MASK 0x30
#define PCIEP_STRAP_LC__STRAP_MED_yTSx_COUNT__SHIFT 0x4
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT_MASK 0xc0
#define PCIEP_STRAP_LC__STRAP_SHORT_yTSx_COUNT__SHIFT 0x6
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL_MASK 0x700
#define PCIEP_STRAP_LC__STRAP_SKIP_INTERVAL__SHIFT 0x8
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET_MASK 0x800
#define PCIEP_STRAP_LC__STRAP_BYPASS_RCVR_DET__SHIFT 0xb
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS_MASK 0x1000
#define PCIEP_STRAP_LC__STRAP_COMPLIANCE_DIS__SHIFT 0xc
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE_MASK 0x2000
#define PCIEP_STRAP_LC__STRAP_FORCE_COMPLIANCE__SHIFT 0xd
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES_MASK 0x4000
#define PCIEP_STRAP_LC__STRAP_REVERSE_LC_LANES__SHIFT 0xe
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS_MASK 0x8000
#define PCIEP_STRAP_LC__STRAP_AUTO_RC_SPEED_NEGOTIATION_DIS__SHIFT 0xf
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION_MASK 0x70000
#define PCIEP_STRAP_LC__STRAP_LANE_NEGOTIATION__SHIFT 0x10
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES_MASK 0x1
#define PCIEP_STRAP_MISC__STRAP_REVERSE_LANES__SHIFT 0x0
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN_MASK 0x2
#define PCIEP_STRAP_MISC__STRAP_E2E_PREFIX_EN__SHIFT 0x1
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED_MASK 0x4
#define PCIEP_STRAP_MISC__STRAP_EXTENDED_FMT_SUPPORTED__SHIFT 0x2
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED_MASK 0x18
#define PCIEP_STRAP_MISC__STRAP_OBFF_SUPPORTED__SHIFT 0x3
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED_MASK 0x20
#define PCIEP_STRAP_MISC__STRAP_LTR_SUPPORTED__SHIFT 0x5
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN_MASK 0x1
#define PCIEP_BCH_ECC_CNTL__STRAP_BCH_ECC_EN__SHIFT 0x0
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD_MASK 0xff00
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_THRESHOLD__SHIFT 0x8
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS_MASK 0xffff0000
#define PCIEP_BCH_ECC_CNTL__BCH_ECC_ERROR_STATUS__SHIFT 0x10
#define PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE_MASK 0x8
#define PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_CHANGED_PRIVATE__SHIFT 0x3
#define PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE_MASK 0x40
#define PCIEP_HPGI_PRIVATE__PRESENCE_DETECT_STATE_PRIVATE__SHIFT 0x6
#define PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN_MASK 0x1
#define PCIEP_HPGI__REG_HPGI_ASSERT_TO_SMI_EN__SHIFT 0x0
#define PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN_MASK 0x2
#define PCIEP_HPGI__REG_HPGI_ASSERT_TO_SCI_EN__SHIFT 0x1
#define PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN_MASK 0x4
#define PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SMI_EN__SHIFT 0x2
#define PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN_MASK 0x8
#define PCIEP_HPGI__REG_HPGI_DEASSERT_TO_SCI_EN__SHIFT 0x3
#define PCIEP_HPGI__REG_HPGI_HOOK_MASK 0x80
#define PCIEP_HPGI__REG_HPGI_HOOK__SHIFT 0x7
#define PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS_MASK 0x100
#define PCIEP_HPGI__HPGI_REG_ASSERT_TO_SMI_STATUS__SHIFT 0x8
#define PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS_MASK 0x200
#define PCIEP_HPGI__HPGI_REG_ASSERT_TO_SCI_STATUS__SHIFT 0x9
#define PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS_MASK 0x400
#define PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SMI_STATUS__SHIFT 0xa
#define PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS_MASK 0x800
#define PCIEP_HPGI__HPGI_REG_DEASSERT_TO_SCI_STATUS__SHIFT 0xb
#define PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS_MASK 0x8000
#define PCIEP_HPGI__HPGI_REG_PRESENCE_DETECT_STATE_CHANGE_STATUS__SHIFT 0xf
#define PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN_MASK 0x10000
#define PCIEP_HPGI__REG_HPGI_PRESENCE_DETECT_STATE_CHANGE_EN__SHIFT 0x10
#define PCIEMSIX_VECT0_ADDR_LO__MSG_ADDR_LO_MASK 0xfffffffc
#define PCIEMSIX_VECT0_ADDR_LO__MSG_ADDR_LO__SHIFT 0x2
#define PCIEMSIX_VECT0_ADDR_HI__MSG_ADDR_HI_MASK 0xffffffff
#define PCIEMSIX_VECT0_ADDR_HI__MSG_ADDR_HI__SHIFT 0x0
#define PCIEMSIX_VECT0_MSG_DATA__MSG_DATA_MASK 0xffffffff
#define PCIEMSIX_VECT0_MSG_DATA__MSG_DATA__SHIFT 0x0
#define PCIEMSIX_VECT0_CONTROL__MASK_BIT_MASK 0x1
#define PCIEMSIX_VECT0_CONTROL__MASK_BIT__SHIFT 0x0
#define PCIEMSIX_VECT1_ADDR_LO__MSG_ADDR_LO_MASK 0xfffffffc
#define PCIEMSIX_VECT1_ADDR_LO__MSG_ADDR_LO__SHIFT 0x2
#define PCIEMSIX_VECT1_ADDR_HI__MSG_ADDR_HI_MASK 0xffffffff
#define PCIEMSIX_VECT1_ADDR_HI__MSG_ADDR_HI__SHIFT 0x0
#define PCIEMSIX_VECT1_MSG_DATA__MSG_DATA_MASK 0xffffffff
#define PCIEMSIX_VECT1_MSG_DATA__MSG_DATA__SHIFT 0x0
#define PCIEMSIX_VECT1_CONTROL__MASK_BIT_MASK 0x1
#define PCIEMSIX_VECT1_CONTROL__MASK_BIT__SHIFT 0x0
#define PCIEMSIX_VECT2_ADDR_LO__MSG_ADDR_LO_MASK 0xfffffffc
#define PCIEMSIX_VECT2_ADDR_LO__MSG_ADDR_LO__SHIFT 0x2
#define PCIEMSIX_VECT2_ADDR_HI__MSG_ADDR_HI_MASK 0xffffffff
#define PCIEMSIX_VECT2_ADDR_HI__MSG_ADDR_HI__SHIFT 0x0
#define PCIEMSIX_VECT2_MSG_DATA__MSG_DATA_MASK 0xffffffff
#define PCIEMSIX_VECT2_MSG_DATA__MSG_DATA__SHIFT 0x0
#define PCIEMSIX_VECT2_CONTROL__MASK_BIT_MASK 0x1
#define PCIEMSIX_VECT2_CONTROL__MASK_BIT__SHIFT 0x0
#define PCIEMSIX_VECT3_ADDR_LO__MSG_ADDR_LO_MASK 0xfffffffc
#define PCIEMSIX_VECT3_ADDR_LO__MSG_ADDR_LO__SHIFT 0x2
#define PCIEMSIX_VECT3_ADDR_HI__MSG_ADDR_HI_MASK 0xffffffff
#define PCIEMSIX_VECT3_ADDR_HI__MSG_ADDR_HI__SHIFT 0x0
#define PCIEMSIX_VECT3_MSG_DATA__MSG_DATA_MASK 0xffffffff
#define PCIEMSIX_VECT3_MSG_DATA__MSG_DATA__SHIFT 0x0
#define PCIEMSIX_VECT3_CONTROL__MASK_BIT_MASK 0x1
#define PCIEMSIX_VECT3_CONTROL__MASK_BIT__SHIFT 0x0
#define PCIEMSIX_PBA__MSIX_PENDING_BITS_MASK 0xf
#define PCIEMSIX_PBA__MSIX_PENDING_BITS__SHIFT 0x0
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ARBITER_MASK 0x1
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ARBITER__SHIFT 0x0
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ALLMASTER_MASK 0x2
#define BIF_RFE_SNOOP_REG__REG_SNOOP_ALLMASTER__SHIFT 0x1
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstRfeEn_MASK 0x1
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstRfeEn__SHIFT 0x0
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstImpEn_MASK 0x2
#define BIF_RFE_WARMRST_CNTL__REG_RST_warmRstImpEn__SHIFT 0x1
#define BIF_RFE_SOFTRST_CNTL__REG_RST_rstTimer_MASK 0xffff
#define BIF_RFE_SOFTRST_CNTL__REG_RST_rstTimer__SHIFT 0x0
#define BIF_RFE_SOFTRST_CNTL__REG_RST_softRstPropEn_MASK 0x40000000
#define BIF_RFE_SOFTRST_CNTL__REG_RST_softRstPropEn__SHIFT 0x1e
#define BIF_RFE_SOFTRST_CNTL__SoftRstReg_MASK 0x80000000
#define BIF_RFE_SOFTRST_CNTL__SoftRstReg__SHIFT 0x1f
#define BIF_RFE_IMPRST_CNTL__REG_RST_impEn_MASK 0x1
#define BIF_RFE_IMPRST_CNTL__REG_RST_impEn__SHIFT 0x0
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT0_RFE_RFEWDBIF_rst_MASK 0x1
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT0_RFE_RFEWDBIF_rst__SHIFT 0x0
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT1_RFE_RFEWDBIF_rst_MASK 0x2
#define BIF_RFE_CLIENT_SOFTRST_TRIGGER__CLIENT1_RFE_RFEWDBIF_rst__SHIFT 0x1
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BU_rst_MASK 0x1
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BU_rst__SHIFT 0x0
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__RWREG_RFEWDBIF_rst_MASK 0x2
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__RWREG_RFEWDBIF_rst__SHIFT 0x1
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__SMBUS_rst_MASK 0x4
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__SMBUS_rst__SHIFT 0x2
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BX_rst_MASK 0x8
#define BIF_RFE_MASTER_SOFTRST_TRIGGER__BX_rst__SHIFT 0x3
#define BIF_PWDN_COMMAND__REG_BU_pw_cmd_MASK 0x1
#define BIF_PWDN_COMMAND__REG_BU_pw_cmd__SHIFT 0x0
#define BIF_PWDN_COMMAND__REG_RWREG_RFEWDBIF_pw_cmd_MASK 0x2
#define BIF_PWDN_COMMAND__REG_RWREG_RFEWDBIF_pw_cmd__SHIFT 0x1
#define BIF_PWDN_COMMAND__REG_SMBUS_pw_cmd_MASK 0x4
#define BIF_PWDN_COMMAND__REG_SMBUS_pw_cmd__SHIFT 0x2
#define BIF_PWDN_COMMAND__REG_BX_pw_cmd_MASK 0x8
#define BIF_PWDN_COMMAND__REG_BX_pw_cmd__SHIFT 0x3
#define BIF_PWDN_STATUS__BU_REG_pw_status_MASK 0x1
#define BIF_PWDN_STATUS__BU_REG_pw_status__SHIFT 0x0
#define BIF_PWDN_STATUS__RWREG_RFEWDBIF_REG_pw_status_MASK 0x2
#define BIF_PWDN_STATUS__RWREG_RFEWDBIF_REG_pw_status__SHIFT 0x1
#define BIF_PWDN_STATUS__SMBUS_REG_pw_status_MASK 0x4
#define BIF_PWDN_STATUS__SMBUS_REG_pw_status__SHIFT 0x2
#define BIF_PWDN_STATUS__BX_REG_pw_status_MASK 0x8
#define BIF_PWDN_STATUS__BX_REG_pw_status__SHIFT 0x3
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_BU_CMDSTATUS__REG_BU_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_BU_CMDSTATUS__BU_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_BU_CMDSTATUS__BU_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__REG_RWREG_RFEWDBIF_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__RWREG_RFEWDBIF_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_RWREG_RFEWDBIF_CMDSTATUS__RWREG_RFEWDBIF_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_SMBUS_CMDSTATUS__REG_SMBUS_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_SMBUS_CMDSTATUS__SMBUS_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_SMBUS_CMDSTATUS__SMBUS_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkGate_timer_MASK 0xff
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkGate_timer__SHIFT 0x0
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkSetup_timer_MASK 0xf00
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_clkSetup_timer__SHIFT 0x8
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_timeout_timer_MASK 0xff0000
#define BIF_RFE_MST_BX_CMDSTATUS__REG_BX_timeout_timer__SHIFT 0x10
#define BIF_RFE_MST_BX_CMDSTATUS__BX_RFE_mstTimeout_MASK 0x1000000
#define BIF_RFE_MST_BX_CMDSTATUS__BX_RFE_mstTimeout__SHIFT 0x18
#define BIF_RFE_MST_TMOUT_STATUS__MstTmoutStatus_MASK 0x1
#define BIF_RFE_MST_TMOUT_STATUS__MstTmoutStatus__SHIFT 0x0
#define BIF_RFE_MMCFG_CNTL__CLIENT0_RFE_RFEWDBIF_MM_WR_TO_CFG_EN_MASK 0x1
#define BIF_RFE_MMCFG_CNTL__CLIENT0_RFE_RFEWDBIF_MM_WR_TO_CFG_EN__SHIFT 0x0
#define BIF_RFE_MMCFG_CNTL__CLIENT0_RFE_RFEWDBIF_MM_CFG_FUNC_SEL_MASK 0xe
#define BIF_RFE_MMCFG_CNTL__CLIENT0_RFE_RFEWDBIF_MM_CFG_FUNC_SEL__SHIFT 0x1
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWDBIF_MM_WR_TO_CFG_EN_MASK 0x10
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWDBIF_MM_WR_TO_CFG_EN__SHIFT 0x4
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWDBIF_MM_CFG_FUNC_SEL_MASK 0xe0
#define BIF_RFE_MMCFG_CNTL__CLIENT1_RFE_RFEWDBIF_MM_CFG_FUNC_SEL__SHIFT 0x5
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_RX_IMPVAL_MASK 0x1e
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_RX_IMPVAL__SHIFT 0x1
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_RX_IMPVAL_EN_MASK 0x20
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_RX_IMPVAL_EN__SHIFT 0x5
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_PD_MASK 0x3c0
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_PD__SHIFT 0x6
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_EN_PD_MASK 0x400
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_EN_PD__SHIFT 0xa
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_PU_MASK 0x7800
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_PU__SHIFT 0xb
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_EN_PU_MASK 0x8000
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_TX_IMPVAL_EN_PU__SHIFT 0xf
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_IMP_DBG_ANALOG_EN_MASK 0x10000
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_IMP_DBG_ANALOG_EN__SHIFT 0x10
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_IMP_IGNORE_QUICKSIM_MASK 0x20000
#define BIF_CC_RFE_IMP_OVERRIDECNTL__STRAP_PLL_IMP_IGNORE_QUICKSIM__SHIFT 0x11
#define BIF_IMPCTL_SMPLCNTL__FORCE_DONE_MASK 0x1
#define BIF_IMPCTL_SMPLCNTL__FORCE_DONE__SHIFT 0x0
#define BIF_IMPCTL_SMPLCNTL__RxPDNB_MASK 0x2
#define BIF_IMPCTL_SMPLCNTL__RxPDNB__SHIFT 0x1
#define BIF_IMPCTL_SMPLCNTL__TxPDNB_pd_MASK 0x4
#define BIF_IMPCTL_SMPLCNTL__TxPDNB_pd__SHIFT 0x2
#define BIF_IMPCTL_SMPLCNTL__TxPDNB_pu_MASK 0x8
#define BIF_IMPCTL_SMPLCNTL__TxPDNB_pu__SHIFT 0x3
#define BIF_IMPCTL_SMPLCNTL__SAMPLE_PERIOD_MASK 0x1f00
#define BIF_IMPCTL_SMPLCNTL__SAMPLE_PERIOD__SHIFT 0x8
#define BIF_IMPCTL_SMPLCNTL__EXTEND_SAMPLES_MASK 0x2000
#define BIF_IMPCTL_SMPLCNTL__EXTEND_SAMPLES__SHIFT 0xd
#define BIF_IMPCTL_SMPLCNTL__FORCE_ENABLE_MASK 0x4000
#define BIF_IMPCTL_SMPLCNTL__FORCE_ENABLE__SHIFT 0xe
#define BIF_IMPCTL_SMPLCNTL__SETUP_TIME_MASK 0xf8000
#define BIF_IMPCTL_SMPLCNTL__SETUP_TIME__SHIFT 0xf
#define BIF_IMPCTL_SMPLCNTL__LOWER_SAMPLE_THRESH_MASK 0x3f00000
#define BIF_IMPCTL_SMPLCNTL__LOWER_SAMPLE_THRESH__SHIFT 0x14
#define BIF_IMPCTL_SMPLCNTL__UPPER_SAMPLE_THRESH_MASK 0xfc000000
#define BIF_IMPCTL_SMPLCNTL__UPPER_SAMPLE_THRESH__SHIFT 0x1a
#define BIF_IMPCTL_RXCNTL__RX_ADJUST_MASK 0x7
#define BIF_IMPCTL_RXCNTL__RX_ADJUST__SHIFT 0x0
#define BIF_IMPCTL_RXCNTL__RX_BIAS_HIGH_MASK 0x8
#define BIF_IMPCTL_RXCNTL__RX_BIAS_HIGH__SHIFT 0x3
#define BIF_IMPCTL_RXCNTL__CONT_AFTER_RX_DECT_MASK 0x10
#define BIF_IMPCTL_RXCNTL__CONT_AFTER_RX_DECT__SHIFT 0x4
#define BIF_IMPCTL_RXCNTL__SUSPEND_MASK 0x40
#define BIF_IMPCTL_RXCNTL__SUSPEND__SHIFT 0x6
#define BIF_IMPCTL_RXCNTL__FORCE_RST_MASK 0x80
#define BIF_IMPCTL_RXCNTL__FORCE_RST__SHIFT 0x7
#define BIF_IMPCTL_RXCNTL__LOWER_RX_ADJ_THRESH_MASK 0xf00
#define BIF_IMPCTL_RXCNTL__LOWER_RX_ADJ_THRESH__SHIFT 0x8
#define BIF_IMPCTL_RXCNTL__LOWER_RX_ADJ_MASK 0x1000
#define BIF_IMPCTL_RXCNTL__LOWER_RX_ADJ__SHIFT 0xc
#define BIF_IMPCTL_RXCNTL__UPPER_RX_ADJ_THRESH_MASK 0x1e000
#define BIF_IMPCTL_RXCNTL__UPPER_RX_ADJ_THRESH__SHIFT 0xd
#define BIF_IMPCTL_RXCNTL__UPPER_RX_ADJ_MASK 0x20000
#define BIF_IMPCTL_RXCNTL__UPPER_RX_ADJ__SHIFT 0x11
#define BIF_IMPCTL_RXCNTL__RX_IMP_LOCKED_MASK 0x40000
#define BIF_IMPCTL_RXCNTL__RX_IMP_LOCKED__SHIFT 0x12
#define BIF_IMPCTL_RXCNTL__RX_IMP_READBACK_SEL_MASK 0x80000
#define BIF_IMPCTL_RXCNTL__RX_IMP_READBACK_SEL__SHIFT 0x13
#define BIF_IMPCTL_RXCNTL__RX_IMP_READBACK_MASK 0xf00000
#define BIF_IMPCTL_RXCNTL__RX_IMP_READBACK__SHIFT 0x14
#define BIF_IMPCTL_RXCNTL__RX_CMP_AMBIG_MASK 0x10000000
#define BIF_IMPCTL_RXCNTL__RX_CMP_AMBIG__SHIFT 0x1c
#define BIF_IMPCTL_RXCNTL__CAL_DONE_MASK 0x20000000
#define BIF_IMPCTL_RXCNTL__CAL_DONE__SHIFT 0x1d
#define BIF_IMPCTL_TXCNTL_pd__TX_ADJUST_pd_MASK 0x7
#define BIF_IMPCTL_TXCNTL_pd__TX_ADJUST_pd__SHIFT 0x0
#define BIF_IMPCTL_TXCNTL_pd__TX_BIAS_HIGH_pd_MASK 0x8
#define BIF_IMPCTL_TXCNTL_pd__TX_BIAS_HIGH_pd__SHIFT 0x3
#define BIF_IMPCTL_TXCNTL_pd__LOWER_TX_ADJ_THRESH_pd_MASK 0xf00
#define BIF_IMPCTL_TXCNTL_pd__LOWER_TX_ADJ_THRESH_pd__SHIFT 0x8
#define BIF_IMPCTL_TXCNTL_pd__LOWER_TX_ADJ_pd_MASK 0x1000
#define BIF_IMPCTL_TXCNTL_pd__LOWER_TX_ADJ_pd__SHIFT 0xc
#define BIF_IMPCTL_TXCNTL_pd__UPPER_TX_ADJ_THRESH_pd_MASK 0x1e000
#define BIF_IMPCTL_TXCNTL_pd__UPPER_TX_ADJ_THRESH_pd__SHIFT 0xd
#define BIF_IMPCTL_TXCNTL_pd__UPPER_TX_ADJ_pd_MASK 0x20000
#define BIF_IMPCTL_TXCNTL_pd__UPPER_TX_ADJ_pd__SHIFT 0x11
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_LOCKED_pd_MASK 0x40000
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_LOCKED_pd__SHIFT 0x12
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_READBACK_SEL_pd_MASK 0x80000
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_READBACK_SEL_pd__SHIFT 0x13
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_READBACK_pd_MASK 0xf00000
#define BIF_IMPCTL_TXCNTL_pd__TX_IMP_READBACK_pd__SHIFT 0x14
#define BIF_IMPCTL_TXCNTL_pd__TX_CMP_AMBIG_pd_MASK 0x10000000
#define BIF_IMPCTL_TXCNTL_pd__TX_CMP_AMBIG_pd__SHIFT 0x1c
#define BIF_IMPCTL_TXCNTL_pu__TX_ADJUST_pu_MASK 0x7
#define BIF_IMPCTL_TXCNTL_pu__TX_ADJUST_pu__SHIFT 0x0
#define BIF_IMPCTL_TXCNTL_pu__TX_BIAS_HIGH_pu_MASK 0x8
#define BIF_IMPCTL_TXCNTL_pu__TX_BIAS_HIGH_pu__SHIFT 0x3
#define BIF_IMPCTL_TXCNTL_pu__LOWER_TX_ADJ_THRESH_pu_MASK 0xf00
#define BIF_IMPCTL_TXCNTL_pu__LOWER_TX_ADJ_THRESH_pu__SHIFT 0x8
#define BIF_IMPCTL_TXCNTL_pu__LOWER_TX_ADJ_pu_MASK 0x1000
#define BIF_IMPCTL_TXCNTL_pu__LOWER_TX_ADJ_pu__SHIFT 0xc
#define BIF_IMPCTL_TXCNTL_pu__UPPER_TX_ADJ_THRESH_pu_MASK 0x1e000
#define BIF_IMPCTL_TXCNTL_pu__UPPER_TX_ADJ_THRESH_pu__SHIFT 0xd
#define BIF_IMPCTL_TXCNTL_pu__UPPER_TX_ADJ_pu_MASK 0x20000
#define BIF_IMPCTL_TXCNTL_pu__UPPER_TX_ADJ_pu__SHIFT 0x11
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_LOCKED_pu_MASK 0x40000
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_LOCKED_pu__SHIFT 0x12
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_READBACK_SEL_pu_MASK 0x80000
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_READBACK_SEL_pu__SHIFT 0x13
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_READBACK_pu_MASK 0xf00000
#define BIF_IMPCTL_TXCNTL_pu__TX_IMP_READBACK_pu__SHIFT 0x14
#define BIF_IMPCTL_TXCNTL_pu__TX_CMP_AMBIG_pu_MASK 0x10000000
#define BIF_IMPCTL_TXCNTL_pu__TX_CMP_AMBIG_pu__SHIFT 0x1c
#define BIF_IMPCTL_CONTINUOUS_CALIBRATION_PERIOD__UPDATE_PERIOD_MASK 0xffffffff
#define BIF_IMPCTL_CONTINUOUS_CALIBRATION_PERIOD__UPDATE_PERIOD__SHIFT 0x0

#endif /* BIF_5_0_SH_MASK_H */
