/*	$NetBSD: octeon_powreg.h,v 1.1 2015/04/29 08:32:01 hikaru Exp $	*/

/*
 * Copyright (c) 2007 Internet Initiative Japan, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * POW Registers
 */

#ifndef _OCTEON_POWREG_H_
#define _OCTEON_POWREG_H_

/* ---- register addresses */

#define	POW_PP_GRP_MSK0				UINT64_C(0x0001670000000000)
#define	POW_PP_GRP_MSK1				UINT64_C(0x0001670000000008)
#define	POW_WQ_INT_THR0				UINT64_C(0x0001670000000080)
#define	POW_WQ_INT_THR1				UINT64_C(0x0001670000000088)
#define	POW_WQ_INT_THR2				UINT64_C(0x0001670000000090)
#define	POW_WQ_INT_THR3				UINT64_C(0x0001670000000098)
#define	POW_WQ_INT_THR4				UINT64_C(0x00016700000000a0)
#define	POW_WQ_INT_THR5				UINT64_C(0x00016700000000a8)
#define	POW_WQ_INT_THR6				UINT64_C(0x00016700000000b0)
#define	POW_WQ_INT_THR7				UINT64_C(0x00016700000000b8)
#define	POW_WQ_INT_THR8				UINT64_C(0x00016700000000c0)
#define	POW_WQ_INT_THR9				UINT64_C(0x00016700000000c8)
#define	POW_WQ_INT_THR10			UINT64_C(0x00016700000000d0)
#define	POW_WQ_INT_THR11			UINT64_C(0x00016700000000d8)
#define	POW_WQ_INT_THR12			UINT64_C(0x00016700000000e0)
#define	POW_WQ_INT_THR13			UINT64_C(0x00016700000000e8)
#define	POW_WQ_INT_THR14			UINT64_C(0x00016700000000f0)
#define	POW_WQ_INT_THR15			UINT64_C(0x00016700000000f8)
#define	POW_WQ_INT_CNT0				UINT64_C(0x0001670000000100)
#define	POW_WQ_INT_CNT1				UINT64_C(0x0001670000000108)
#define	POW_WQ_INT_CNT2				UINT64_C(0x0001670000000110)
#define	POW_WQ_INT_CNT3				UINT64_C(0x0001670000000118)
#define	POW_WQ_INT_CNT4				UINT64_C(0x0001670000000120)
#define	POW_WQ_INT_CNT5				UINT64_C(0x0001670000000128)
#define	POW_WQ_INT_CNT6				UINT64_C(0x0001670000000130)
#define	POW_WQ_INT_CNT7				UINT64_C(0x0001670000000138)
#define	POW_WQ_INT_CNT8				UINT64_C(0x0001670000000140)
#define	POW_WQ_INT_CNT9				UINT64_C(0x0001670000000148)
#define	POW_WQ_INT_CNT10			UINT64_C(0x0001670000000150)
#define	POW_WQ_INT_CNT11			UINT64_C(0x0001670000000158)
#define	POW_WQ_INT_CNT12			UINT64_C(0x0001670000000160)
#define	POW_WQ_INT_CNT13			UINT64_C(0x0001670000000168)
#define	POW_WQ_INT_CNT14			UINT64_C(0x0001670000000170)
#define	POW_WQ_INT_CNT15			UINT64_C(0x0001670000000178)
#define	POW_QOS_THR0				UINT64_C(0x0001670000000180)
#define	POW_QOS_THR1				UINT64_C(0x0001670000000188)
#define	POW_QOS_THR2				UINT64_C(0x0001670000000190)
#define	POW_QOS_THR3				UINT64_C(0x0001670000000198)
#define	POW_QOS_THR4				UINT64_C(0x00016700000001a0)
#define	POW_QOS_THR5				UINT64_C(0x00016700000001a8)
#define	POW_QOS_THR6				UINT64_C(0x00016700000001b0)
#define	POW_QOS_THR7				UINT64_C(0x00016700000001b8)
#define	POW_QOS_RND0				UINT64_C(0x00016700000001c0)
#define	POW_QOS_RND1				UINT64_C(0x00016700000001c8)
#define	POW_QOS_RND2				UINT64_C(0x00016700000001d0)
#define	POW_QOS_RND3				UINT64_C(0x00016700000001d8)
#define	POW_QOS_RND4				UINT64_C(0x00016700000001e0)
#define	POW_QOS_RND5				UINT64_C(0x00016700000001e8)
#define	POW_QOS_RND6				UINT64_C(0x00016700000001f0)
#define	POW_QOS_RND7				UINT64_C(0x00016700000001f8)
#define	POW_WQ_INT				UINT64_C(0x0001670000000200)
#define	POW_WQ_INT_PC				UINT64_C(0x0001670000000208)
#define	POW_NW_TIM				UINT64_C(0x0001670000000210)
#define	POW_ECC_ERR				UINT64_C(0x0001670000000218)
#define	POW_NOS_CNT				UINT64_C(0x0001670000000220)
#define	POW_WS_PC0				UINT64_C(0x0001670000000280)
#define	POW_WS_PC1				UINT64_C(0x0001670000000288)
#define	POW_WS_PC2				UINT64_C(0x0001670000000290)
#define	POW_WS_PC3				UINT64_C(0x0001670000000298)
#define	POW_WS_PC4				UINT64_C(0x00016700000002a0)
#define	POW_WS_PC5				UINT64_C(0x00016700000002a8)
#define	POW_WS_PC6				UINT64_C(0x00016700000002b0)
#define	POW_WS_PC7				UINT64_C(0x00016700000002b8)
#define	POW_WS_PC8				UINT64_C(0x00016700000002c0)
#define	POW_WS_PC9				UINT64_C(0x00016700000002c8)
#define	POW_WS_PC10				UINT64_C(0x00016700000002d0)
#define	POW_WS_PC11				UINT64_C(0x00016700000002d8)
#define	POW_WS_PC12				UINT64_C(0x00016700000002e0)
#define	POW_WS_PC13				UINT64_C(0x00016700000002e8)
#define	POW_WS_PC14				UINT64_C(0x00016700000002f0)
#define	POW_WS_PC15				UINT64_C(0x00016700000002f8)
#define	POW_WA_PC0				UINT64_C(0x0001670000000300)
#define	POW_WA_PC1				UINT64_C(0x0001670000000308)
#define	POW_WA_PC2				UINT64_C(0x0001670000000310)
#define	POW_WA_PC3				UINT64_C(0x0001670000000318)
#define	POW_WA_PC4				UINT64_C(0x0001670000000320)
#define	POW_WA_PC5				UINT64_C(0x0001670000000328)
#define	POW_WA_PC6				UINT64_C(0x0001670000000330)
#define	POW_WA_PC7				UINT64_C(0x0001670000000338)
#define	POW_IQ_CNT0				UINT64_C(0x0001670000000340)
#define	POW_IQ_CNT1				UINT64_C(0x0001670000000348)
#define	POW_IQ_CNT2				UINT64_C(0x0001670000000350)
#define	POW_IQ_CNT3				UINT64_C(0x0001670000000358)
#define	POW_IQ_CNT4				UINT64_C(0x0001670000000360)
#define	POW_IQ_CNT5				UINT64_C(0x0001670000000368)
#define	POW_IQ_CNT6				UINT64_C(0x0001670000000370)
#define	POW_IQ_CNT7				UINT64_C(0x0001670000000378)
#define	POW_WA_COM_PC				UINT64_C(0x0001670000000380)
#define	POW_IQ_COM_CNT				UINT64_C(0x0001670000000388)
#define	POW_TS_PC				UINT64_C(0x0001670000000390)
#define	POW_DS_PC				UINT64_C(0x0001670000000398)
#define	POW_BIST_STAT				UINT64_C(0x00016700000003f8)

#define POW_BASE				UINT64_C(0x0001670000000000)
#define POW_SIZE				UINT64_C(0x400)

#define	POW_PP_GRP_MSK0_OFFSET			UINT64_C(0x0)
#define	POW_PP_GRP_MSK1_OFFSET			UINT64_C(0x8)
#define	POW_WQ_INT_THR0_OFFSET			UINT64_C(0x80)
#define	POW_WQ_INT_THR1_OFFSET			UINT64_C(0x88)
#define	POW_WQ_INT_THR2_OFFSET			UINT64_C(0x90)
#define	POW_WQ_INT_THR3_OFFSET			UINT64_C(0x98)
#define	POW_WQ_INT_THR4_OFFSET			UINT64_C(0xa0)
#define	POW_WQ_INT_THR5_OFFSET			UINT64_C(0xa8)
#define	POW_WQ_INT_THR6_OFFSET			UINT64_C(0xb0)
#define	POW_WQ_INT_THR7_OFFSET			UINT64_C(0xb8)
#define	POW_WQ_INT_THR8_OFFSET			UINT64_C(0xc0)
#define	POW_WQ_INT_THR9_OFFSET			UINT64_C(0xc8)
#define	POW_WQ_INT_THR10_OFFSET			UINT64_C(0xd0)
#define	POW_WQ_INT_THR11_OFFSET			UINT64_C(0xd8)
#define	POW_WQ_INT_THR12_OFFSET			UINT64_C(0xe0)
#define	POW_WQ_INT_THR13_OFFSET			UINT64_C(0xe8)
#define	POW_WQ_INT_THR14_OFFSET			UINT64_C(0xf0)
#define	POW_WQ_INT_THR15_OFFSET			UINT64_C(0xf8)
#define	POW_WQ_INT_CNT0_OFFSET			UINT64_C(0x100)
#define	POW_WQ_INT_CNT1_OFFSET			UINT64_C(0x108)
#define	POW_WQ_INT_CNT2_OFFSET			UINT64_C(0x110)
#define	POW_WQ_INT_CNT3_OFFSET			UINT64_C(0x118)
#define	POW_WQ_INT_CNT4_OFFSET			UINT64_C(0x120)
#define	POW_WQ_INT_CNT5_OFFSET			UINT64_C(0x128)
#define	POW_WQ_INT_CNT6_OFFSET			UINT64_C(0x130)
#define	POW_WQ_INT_CNT7_OFFSET			UINT64_C(0x138)
#define	POW_WQ_INT_CNT8_OFFSET			UINT64_C(0x140)
#define	POW_WQ_INT_CNT9_OFFSET			UINT64_C(0x148)
#define	POW_WQ_INT_CNT10_OFFSET			UINT64_C(0x150)
#define	POW_WQ_INT_CNT11_OFFSET			UINT64_C(0x158)
#define	POW_WQ_INT_CNT12_OFFSET			UINT64_C(0x160)
#define	POW_WQ_INT_CNT13_OFFSET			UINT64_C(0x168)
#define	POW_WQ_INT_CNT14_OFFSET			UINT64_C(0x170)
#define	POW_WQ_INT_CNT15_OFFSET			UINT64_C(0x178)
#define	POW_QOS_THR0_OFFSET			UINT64_C(0x180)
#define	POW_QOS_THR1_OFFSET			UINT64_C(0x188)
#define	POW_QOS_THR2_OFFSET			UINT64_C(0x190)
#define	POW_QOS_THR3_OFFSET			UINT64_C(0x198)
#define	POW_QOS_THR4_OFFSET			UINT64_C(0x1a0)
#define	POW_QOS_THR5_OFFSET			UINT64_C(0x1a8)
#define	POW_QOS_THR6_OFFSET			UINT64_C(0x1b0)
#define	POW_QOS_THR7_OFFSET			UINT64_C(0x1b8)
#define	POW_QOS_RND0_OFFSET			UINT64_C(0x1c0)
#define	POW_QOS_RND1_OFFSET			UINT64_C(0x1c8)
#define	POW_QOS_RND2_OFFSET			UINT64_C(0x1d0)
#define	POW_QOS_RND3_OFFSET			UINT64_C(0x1d8)
#define	POW_QOS_RND4_OFFSET			UINT64_C(0x1e0)
#define	POW_QOS_RND5_OFFSET			UINT64_C(0x1e8)
#define	POW_QOS_RND6_OFFSET			UINT64_C(0x1f0)
#define	POW_QOS_RND7_OFFSET			UINT64_C(0x1f8)
#define	POW_WQ_INT_OFFSET			UINT64_C(0x200)
#define	POW_WQ_INT_PC_OFFSET			UINT64_C(0x208)
#define	POW_NW_TIM_OFFSET			UINT64_C(0x210)
#define	POW_ECC_ERR_OFFSET			UINT64_C(0x218)
#define	POW_NOS_CNT_OFFSET			UINT64_C(0x220)
#define	POW_WS_PC0_OFFSET			UINT64_C(0x280)
#define	POW_WS_PC1_OFFSET			UINT64_C(0x288)
#define	POW_WS_PC2_OFFSET			UINT64_C(0x290)
#define	POW_WS_PC3_OFFSET			UINT64_C(0x298)
#define	POW_WS_PC4_OFFSET			UINT64_C(0x2a0)
#define	POW_WS_PC5_OFFSET			UINT64_C(0x2a8)
#define	POW_WS_PC6_OFFSET			UINT64_C(0x2b0)
#define	POW_WS_PC7_OFFSET			UINT64_C(0x2b8)
#define	POW_WS_PC8_OFFSET			UINT64_C(0x2c0)
#define	POW_WS_PC9_OFFSET			UINT64_C(0x2c8)
#define	POW_WS_PC10_OFFSET			UINT64_C(0x2d0)
#define	POW_WS_PC11_OFFSET			UINT64_C(0x2d8)
#define	POW_WS_PC12_OFFSET			UINT64_C(0x2e0)
#define	POW_WS_PC13_OFFSET			UINT64_C(0x2e8)
#define	POW_WS_PC14_OFFSET			UINT64_C(0x2f0)
#define	POW_WS_PC15_OFFSET			UINT64_C(0x2f8)
#define	POW_WA_PC0_OFFSET			UINT64_C(0x300)
#define	POW_WA_PC1_OFFSET			UINT64_C(0x308)
#define	POW_WA_PC2_OFFSET			UINT64_C(0x310)
#define	POW_WA_PC3_OFFSET			UINT64_C(0x318)
#define	POW_WA_PC4_OFFSET			UINT64_C(0x320)
#define	POW_WA_PC5_OFFSET			UINT64_C(0x328)
#define	POW_WA_PC6_OFFSET			UINT64_C(0x330)
#define	POW_WA_PC7_OFFSET			UINT64_C(0x338)
#define	POW_IQ_CNT0_OFFSET			UINT64_C(0x340)
#define	POW_IQ_CNT1_OFFSET			UINT64_C(0x348)
#define	POW_IQ_CNT2_OFFSET			UINT64_C(0x350)
#define	POW_IQ_CNT3_OFFSET			UINT64_C(0x358)
#define	POW_IQ_CNT4_OFFSET			UINT64_C(0x360)
#define	POW_IQ_CNT5_OFFSET			UINT64_C(0x368)
#define	POW_IQ_CNT6_OFFSET			UINT64_C(0x370)
#define	POW_IQ_CNT7_OFFSET			UINT64_C(0x378)
#define	POW_WA_COM_PC_OFFSET			UINT64_C(0x380)
#define	POW_IQ_COM_CNT_OFFSET			UINT64_C(0x388)
#define	POW_TS_PC_OFFSET			UINT64_C(0x390)
#define	POW_DS_PC_OFFSET			UINT64_C(0x398)
#define	POW_BIST_STAT_OFFSET			UINT64_C(0x3f8)

/* ---- register bits */

#define	POW_PP_GRP_MSKX_XXX_63_16		UINT64_C(0xffffffffffff0000)
#define	POW_PP_GRP_MSKX_GRP_MSK			UINT64_C(0x000000000000ffff)
#define	 POW_PP_GRP_MSKX_GRP_MSK_SHIFT		0

#define	POW_WQ_INT_THRX_XXX_63_29		UINT64_C(0xffffffffe0000000)
#define	POW_WQ_INT_THRX_TC_EN			UINT64_C(0x0000000010000000)
#define	POW_WQ_INT_THRX_TC_THR			UINT64_C(0x000000000f000000)
#define	 POW_WQ_INT_THRX_TC_THR_SHIFT		24
#define	POW_WQ_INT_THRX_XXX_23_18		UINT64_C(0x0000000000fc0000)
#define	POW_WQ_INT_THRX_DS_THR			UINT64_C(0x000000000003f000)
#define	 POW_WQ_INT_THRX_DS_THR_SHIFT		12
#define	POW_WQ_INT_THRX_XXX_11_6		UINT64_C(0x0000000000000fc0)
#define	POW_WQ_INT_THRX_IQ_THR			UINT64_C(0x000000000000003f)
#define	 POW_WQ_INT_THRX_IQ_THR_SHIFT		0

#define	POW_WQ_INT_CNTX_XXX_63_28		UINT64_C(0xfffffffff0000000)
#define	POW_WQ_INT_CNTX_TC_CNT			UINT64_C(0x000000000f000000)
#define	 POW_WQ_INT_CNTX_TC_CNT_SHIFT		24
#define	POW_WQ_INT_CNTX_XXX_23_18		UINT64_C(0x0000000000fc0000)
#define	POW_WQ_INT_CNTX_DS_CNT			UINT64_C(0x000000000003f000)
#define	 POW_WQ_INT_CNTX_DS_CNT_SHIFT		12
#define	POW_WQ_INT_CNTX_XXX_11_6		UINT64_C(0x0000000000000fc0)
#define	POW_WQ_INT_CNTX_IQ_CNT			UINT64_C(0x000000000000003f)
#define	 POW_WQ_INT_CNTX_IQ_CNT_SHIFT		0

#define	POW_QOS_THRX_XXX_63_55			UINT64_C(0xff80000000000000)
#define	POW_QOS_THRX_DES_CNT			UINT64_C(0x007f000000000000)
#define	 POW_QOS_THRX_DES_CNT_SHIFT		48
#define	POW_QOS_THRX_XXX_47_43			UINT64_C(0x0000f80000000000)
#define	POW_QOS_THRX_BUF_CNT			UINT64_C(0x000007f000000000)
#define	 POW_QOS_THRX_BUF_CNT_SHIFT		36
#define	POW_QOS_THRX_XXX_35_31			UINT64_C(0x0000000f80000000)
#define	POW_QOS_THRX_FREE_CNT			UINT64_C(0x000000007f000000)
#define	 POW_QOS_THRX_FREE_CNT_SHIFT		24
#define	POW_QOS_THRX_XXX_23_18			UINT64_C(0x0000000000fc0000)
#define	POW_QOS_THRX_MAX_THR			UINT64_C(0x000000000003f000)
#define	 POW_QOS_THRX_MAX_THR_SHIFT		12
#define	POW_QOS_THRX_XXX_11_6			UINT64_C(0x0000000000000fc0)
#define	POW_QOS_THRX_MIN_THR			UINT64_C(0x000000000000003f)
#define	 POW_QOS_THRX_MIN_THR_SHIFT		0

#define	POW_QOS_RNDX_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_QOS_RNDX_RND_P3			UINT64_C(0x00000000ff000000)
#define	 POW_QOS_RNDX_RND_P3_SHIFT		24
#define	POW_QOS_RNDX_RND_P2			UINT64_C(0x0000000000ff0000)
#define	 POW_QOS_RNDX_RND_P2_SHIFT		16
#define	POW_QOS_RNDX_RND_P1			UINT64_C(0x000000000000ff00)
#define	 POW_QOS_RNDX_RND_P1_SHIFT		8
#define	POW_QOS_RNDX_RND			UINT64_C(0x00000000000000ff)
#define	 POW_QOS_RNDX_RND_SHIFT			0

#define	POW_WQ_INT_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_WQ_INT_IQ_DIS			UINT64_C(0x00000000ffff0000)
#define	 POW_WQ_INT_IQ_DIS_SHIFT		16
#define	POW_WQ_INT_WQ_INT			UINT64_C(0x000000000000ffff)
#define	 POW_WQ_INT_WQ_INT_SHIFT		0

#define	POW_WQ_INT_PC_XXX_63_60			UINT64_C(0xf000000000000000)
#define	POW_WQ_INT_PC_PC			UINT64_C(0x0fffffff00000000)
#define	 POW_WQ_INT_PC_PC_SHIFT			32
#define	POW_WQ_INT_PC_XXX_31_28			UINT64_C(0x00000000f0000000)
#define	POW_WQ_INT_PC_PC_THR			UINT64_C(0x000000000fffff00)
#define	 POW_WQ_INT_PC_PC_THR_SHIFT		8
#define	POW_WQ_INT_PC_XXX_7_0			UINT64_C(0x00000000000000ff)

#define	POW_NW_TIM_XXX_63_10			UINT64_C(0xfffffffffffffc00)
#define	POW_NW_TIM_NW_TIM			UINT64_C(0x00000000000003ff)
#define	 POW_NW_TIM_NW_TIM_SHIFT		0

#define	POW_ECC_ERR_XXX_63_45			UINT64_C(0xffffe00000000000)
#define	POW_ECC_ERR_IOP_IE			UINT64_C(0x00001fff00000000)
#define	 POW_ECC_ERR_IOP_IE_SHIFT		32
#define	POW_ECC_ERR_XXX_31_29			UINT64_C(0x00000000e0000000)
#define	POW_ECC_ERR_IOP				UINT64_C(0x000000001fff0000)
#define	 POW_ECC_ERR_IOP_SHIFT			16
#define	  POW_ECC_ERR_IOP_CSRPEND		(UINT64_C(28) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_DBGPEND		(UINT64_C(27) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_ADDWORK		(UINT64_C(26) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_ILLOP			(UINT64_C(25) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_PEND24		(UINT64_C(24) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_PEND23		(UINT64_C(23) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_PEND22		(UINT64_C(22) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_PEND21		(UINT64_C(21) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_TAGNULL		(UINT64_C(20) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_TAGNULLNULL		(UINT64_C(19) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_ORDATOM		(UINT64_C(18) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_NULL			(UINT64_C(17) << POW_ECC_ERR_IOP_SHIFT)
#define	  POW_ECC_ERR_IOP_NULLNULL		(UINT64_C(16) << POW_ECC_ERR_IOP_SHIFT)
#define	POW_ECC_ERR_XXX_15_14			UINT64_C(0x000000000000c000)
#define	POW_ECC_ERR_RPE_IE			UINT64_C(0x0000000000002000)
#define	POW_ECC_ERR_RPE				UINT64_C(0x0000000000001000)
#define	POW_ECC_ERR_XXX_11_9			UINT64_C(0x0000000000000e00)
#define	POW_ECC_ERR_SYN				UINT64_C(0x00000000000001f0)
#define	 POW_ECC_ERR_SYN_SHIFT			4
#define	POW_ECC_ERR_DBE_IE			UINT64_C(0x0000000000000008)
#define	POW_ECC_ERR_SBE_IE			UINT64_C(0x0000000000000004)
#define	POW_ECC_ERR_DBE				UINT64_C(0x0000000000000002)
#define	POW_ECC_ERR_SBE				UINT64_C(0x0000000000000001)

#define	POW_NOS_CNT_XXX_63_7			UINT64_C(0xffffffffffffff80)
#define	POW_NOS_CNT_NOS_CNT			UINT64_C(0x000000000000007f)
#define	 POW_NOS_CNT_NOS_CNT_SHIFT		0

#define	POW_WS_PC0_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_WS_PC0_WS_PC			UINT64_C(0x00000000ffffffff)
#define	 POW_WS_PC0_WS_PC_SHIFT			0

#define	POW_WA_PC0_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_WA_PC0_WA_PC			UINT64_C(0x00000000ffffffff)
#define	 POW_WA_PC0_WA_PC_SHIFT			0

#define	POW_IQ_CNT0_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_IQ_CNT0_IQ_CNT			UINT64_C(0x00000000ffffffff)
#define	 POW_IQ_CNT0_IQ_CNT_SHIFT		0

#define	POW_WA_COM_PC_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_WA_COM_PC_WA_PC			UINT64_C(0x00000000ffffffff)
#define	 POW_WA_COM_PC_WA_PC_SHIFT		0

#define	POW_WQ_COM_CNT_XXX_63_32		UINT64_C(0xffffffff00000000)
#define	POW_WQ_COM_CNT_IQ_CNT			UINT64_C(0x00000000ffffffff)
#define	 POW_WQ_COM_CNT_IQ_CNT_SHIFT		0

#define	POW_TS_PC_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_TS_PC_TS_PC				UINT64_C(0x00000000ffffffff)
#define	 POW_TS_PC_TS_PC_SHIFT			0

#define	POW_DS_PC_XXX_63_32			UINT64_C(0xffffffff00000000)
#define	POW_DS_PC_DS_PC				UINT64_C(0x00000000ffffffff)
#define	 POW_DS_PC_DS_PC_SHIFT			0

#define	POW_BIST_STAT_XXX_63_7			UINT64_C(0xfffffffffffe0000)
#define	POW_BIST_STAT_PP			UINT64_C(0x0000000000010000)
#define	POW_BIST_STAT_XXX_15_9			UINT64_C(0x000000000000fe00)
#define	POW_BIST_STAT_CAM			UINT64_C(0x0000000000000100)
#define	POW_BIST_STAT_NBT1			UINT64_C(0x0000000000000080)
#define	POW_BIST_STAT_NBT0			UINT64_C(0x0000000000000040)
#define	POW_BIST_STAT_IDX			UINT64_C(0x0000000000000020)
#define	POW_BIST_STAT_FIDX			UINT64_C(0x0000000000000010)
#define	POW_BIST_STAT_NBR1			UINT64_C(0x0000000000000008)
#define	POW_BIST_STAT_NBR0			UINT64_C(0x0000000000000004)
#define	POW_BIST_STAT_PEND			UINT64_C(0x0000000000000002)
#define	POW_BIST_STAT_ADR			UINT64_C(0x0000000000000001)

/* ---- pow operations */ 

/* pow operations base */ 
#define POW_OPERATION_BASE_IO_BIT		UINT64_C(0x0001000000000000)
#define POW_OPERATION_BASE_MAJOR_DID		UINT64_C(0x0000f80000000000)
#define POW_OPERATION_BASE_SUB_DID		UINT64_C(0x0000070000000000)
#define	POW_OPERATION_BASE_IO_BIT_SHIFT	48
#define	POW_OPERATION_BASE_MAJOR_DID_SHIFT	43
#define	POW_OPERATION_BASE_SUB_DID_SHIFT	40

/* get work load  (subid = 0) */
#define POW_GET_WORK_LOAD_WAIT			UINT64_C(0x0000000000000008)
#define POW_GET_WORK_LOAD_2_0			UINT64_C(0x0000000000000007)
#define	POW_GET_WORK_LOAD_WAIT_SHIFT	3
#define	POW_GET_WORK_LOAD_2_0_SHIFT	0

#define POW_GET_WORK_LOAD_RESULT_NO_WORK	UINT64_C(0x8000000000000000)
#define POW_GET_WORK_LOAD_RESULT_62_40		UINT64_C(0x7fffff0000000000)
#define POW_GET_WORK_LOAD_RESULT_ADDR		UINT64_C(0x000000ffffffffff)

/* pow status load (subid = 1) */
#define POW_STATUS_LOAD_COREID			UINT64_C(0x00000000000003c0)
#define POW_STATUS_LOAD_GET_REV			UINT64_C(0x0000000000000020)
#define POW_STATUS_LOAD_GET_CUR			UINT64_C(0x0000000000000010)
#define POW_STATUS_LOAD_GET_WQP			UINT64_C(0x0000000000000008)
#define POW_STATUS_LOAD_GET_2_0			UINT64_C(0x0000000000000007)
#define	POW_STATUS_LOAD_GET_WQP_SHIFT	3
#define	POW_STATUS_LOAD_GET_CUR_SHIFT	4
#define	POW_STATUS_LOAD_COREID_SHIFT	6
#define	POW_STATUS_LOAD_GET_2_0_SHIFT	0
#define	POW_STATUS_LOAD_GET_REV_SHIFT	5

/* get_cur = 0 and get_wqp = 0 ("pend_tag") */
#define POW_STATUS_LOAD_RESULT_PEND_TAG_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_SWITCH		UINT64_C(0x2000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_SWITCH_FULL	UINT64_C(0x1000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_SWITCH_NULL	UINT64_C(0x0800000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_DESCHED		UINT64_C(0x0400000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_DESCHED_SWITCH	UINT64_C(0x0200000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_NOSCHED		UINT64_C(0x0100000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_NEW_WORK		UINT64_C(0x0080000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_NEW_WORK_WAIT	UINT64_C(0x0040000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_NULL_RD		UINT64_C(0x0020000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_NOSCHED_CLR	UINT64_C(0x0010000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_XXX_51		UINT64_C(0x0008000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_GRP		UINT64_C(0x000000f000000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_XXX_35_34		UINT64_C(0x0000000c00000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_TYPE		UINT64_C(0x0000000300000000)
#define POW_STATUS_LOAD_RESULT_PEND_TAG_PEND_TAG		UINT64_C(0x00000000ffffffff)
#define	POW_STATUS_LOAD_RESULT_PEND_TAG_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x3d"		"PEND_SWITCH\0" \
	"b\x3c"		"PEND_SWITCH_FULL\0" \
	"b\x3b"		"PEND_SWITCH_NULL\0" \
	"b\x3a"		"PEND_DESCHED\0" \
	"b\x39"		"PEND_DESCHED_SWITCH\0" \
	"b\x38"		"PEND_NOSCHED\0" \
	"b\x37"		"PEND_NEW_WORK\0" \
	"b\x36"		"PEND_NEW_WORK_WAIT\0" \
	"b\x35"		"PEND_NULL_RD\0" \
	"b\x34"		"PEND_NOSCHED_CLR\0" \
	"f\x28\x0b"	"PEND_INDEX\0" \
	"f\x24\x04"	"PEND_GRP\0" \
	"f\x20\x02"	"PEND_TYPE\0" \
	"f\x00\x20"	"PEND_TAG\0"

/* get_cur = 0 and get_wqp = 1 ("pend_wqp") */
#define POW_STATUS_LOAD_RESULT_PEND_WQP_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_SWITCH		UINT64_C(0x2000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_SWITCH_FULL	UINT64_C(0x1000000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_SWITCH_NULL	UINT64_C(0x0800000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_DESCHED		UINT64_C(0x0400000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_DESCHED_SWITCH	UINT64_C(0x0200000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_NOSCHED		UINT64_C(0x0100000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_NEW_WORK		UINT64_C(0x0080000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_NEW_WORK_WAIT	UINT64_C(0x0040000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_NULL_RD		UINT64_C(0x0020000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_NOSCHED_CLR	UINT64_C(0x0010000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_XXX_51		UINT64_C(0x0008000000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_PEND_WQP_PEND_WQP		UINT64_C(0x0000000fffffffff)
#define	POW_STATUS_LOAD_RESULT_PEND_WQP_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x3d"		"PEND_SWITCH\0" \
	"b\x3c"		"PEND_SWITCH_FULL\0" \
	"b\x3b"		"PEND_SWITCH_NULL\0" \
	"b\x3a"		"PEND_DESCHED\0" \
	"b\x39"		"PEND_DESCHED_SWITCH\0" \
	"b\x38"		"PEND_NOSCHED\0" \
	"b\x37"		"PEND_NEW_WORK\0" \
	"b\x36"		"PEND_NEW_WORK_WAIT\0" \
	"b\x35"		"PEND_NULL_RD\0" \
	"b\x34"		"PEND_NOSCHED_CLR\0" \
	"f\x28\x0b"	"PEND_INDEX\0" \
	"f\x00\x24"	"PEND_WQP\0"

/* get_cur = 1 and get_wqp = 0 and get_rev = 0 ("cur_tag_next") */
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_LINK_INDEX		UINT64_C(0x3ff8000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_GRP			UINT64_C(0x000000f000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_HEAD		UINT64_C(0x0000000800000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_TAIL		UINT64_C(0x0000000400000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_TAG_TYPE		UINT64_C(0x0000000300000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_TAG			UINT64_C(0x00000000ffffffff)
#define	POW_STATUS_LOAD_RESULT_CUR_TAG_NEXT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x33\x0b"	"LINK_INDEX\0" \
	"f\x28\x0b"	"INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"b\x23"		"HEAD\0" \
	"b\x22"		"TAIL\0" \
	"f\x20\x02"	"TAG_TYPE\0" \
	"f\x00\x20"	"TAG\0"

/* get_cur = 1 and get_wqp = 0 and get_rev = 1 ("cur_tag_prev") */
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_REVLINK_INDEX	UINT64_C(0x3ff8000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_GRP			UINT64_C(0x000000f000000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_HEAD		UINT64_C(0x0000000800000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_TAIL		UINT64_C(0x0000000400000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_TAG_TYPE		UINT64_C(0x0000000300000000)
#define POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_TAG			UINT64_C(0x00000000ffffffff)
#define	POW_STATUS_LOAD_RESULT_CUR_TAG_PREV_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x33\x0b"	"REVLINK_INDEX\0" \
	"f\x28\x0b"	"INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"b\x23"		"HEAD\0" \
	"b\x22"		"TAIL\0" \
	"f\x20\x02"	"TAG_TYPE\0" \
	"f\x00\x20"	"TAG\0"

/* get_cur = 1 and get_wqp = 1 and get_rev = 0 ("cur_wqp_next") */
#define POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_LINK_INDEX		UINT64_C(0x3ff8000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_GRP			UINT64_C(0x000000f000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_WQP			UINT64_C(0x0000000fffffffff)
#define	POW_STATUS_LOAD_RESULT_CUR_WQP_NEXT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x33\x0b"	"LINK_INDEX\0" \
	"f\x28\x0b"	"INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"f\x00\x24"	"WQP\0"

/* get_cur = 1 and get_wqp = 1 and get_rev = 1 ("cur_wqp_prev") */
#define POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_XXX_63_62		UINT64_C(0xc000000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_REVLINK_INDEX	UINT64_C(0x3ff8000000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_GRP			UINT64_C(0x000000f000000000)
#define POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_WQP			UINT64_C(0x0000000fffffffff)
#define	POW_STATUS_LOAD_RESULT_CUR_WQP_PREV_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x33\x0b"	"REVLINK_INDEX\0" \
	"f\x28\x0b"	"INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"f\x00\x24"	"WQP\0"

/* pow memory load (subid = 2) */
#define POW_MEMORY_LOAD_INDEX		UINT64_C(0x000000000000ffe0)
#define POW_MEMORY_LOAD_GET_DES		UINT64_C(0x0000000000000010)
#define POW_MEMORY_LOAD_GET_WQP		UINT64_C(0x0000000000000008)
#define POW_MEMORY_LOAD_2_0		UINT64_C(0x0000000000000007)
#define	POW_MEMORY_LOAD_2_0_SHIFT	0
#define	POW_MEMORY_LOAD_GET_WQP_SHIFT	3
#define	POW_MEMORY_LOAD_INDEX_SHIFT	5
#define	POW_MEMORY_LOAD_GET_DES_SHIFT	4

/* get_des = 0 and get_wqp = 0 ("tag") */
#define POW_MEMORY_LOAD_RESULT_TAG_XXX_63_51			UINT64_C(0xfff8000000000000)
#define POW_MEMORY_LOAD_RESULT_TAG_NEXT_INDEX			UINT64_C(0x0007ff0000000000)
#define POW_MEMORY_LOAD_RESULT_TAG_GRP				UINT64_C(0x000000f000000000)
#define POW_MEMORY_LOAD_RESULT_TAG_XXX_35			UINT64_C(0x0000000800000000)
#define POW_MEMORY_LOAD_RESULT_TAG_TAIL				UINT64_C(0x0000000400000000)
#define POW_MEMORY_LOAD_RESULT_TAG_TAG_TYPE			UINT64_C(0x0000000300000000)
#define POW_MEMORY_LOAD_RESULT_TAG_TAG				UINT64_C(0x00000000ffffffff)
#define	POW_MEMORY_LOAD_RESULT_TAG_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x28\x0b"	"NEXT_INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"b\x22"		"TAIL\0" \
	"f\x20\x02"	"TAG_TYPE\0" \
	"f\x00\x20"	"TAG\0"

/* get_des = 0 and get_wqp = 1 ("wqp") */
#define POW_MEMORY_LOAD_RESULT_WQP_XXX_63_51			UINT64_C(0xfff8000000000000)
#define POW_MEMORY_LOAD_RESULT_WQP_NEXT_INDEX			UINT64_C(0x0007ff0000000000)
#define POW_MEMORY_LOAD_RESULT_WQP_GRP				UINT64_C(0x000000f000000000)
#define POW_MEMORY_LOAD_RESULT_WQP_WQP				UINT64_C(0x0000000fffffffff)
#define	POW_MEMORY_LOAD_RESULT_WQP_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x28\x0b"	"NEXT_INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"f\x00\x24"	"WQP\0"

/* get_des = 1 ("desched") */
#define POW_MEMORY_LOAD_RESULT_DESCHED_XXX_63_51		UINT64_C(0xfff8000000000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_FWD_INDEX		UINT64_C(0x0007ff0000000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_GRP			UINT64_C(0x000000f000000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_NOSCHED			UINT64_C(0x0000000800000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_PEND_SWITCH		UINT64_C(0x0000000400000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_PEND_TYPE		UINT64_C(0x0000000300000000)
#define POW_MEMORY_LOAD_RESULT_DESCHED_PEND_TAG			UINT64_C(0x00000000ffffffff)
#define	POW_MEMORY_LOAD_RESULT_DESCHED_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x28\x0b"	"FWD_INDEX\0" \
	"f\x24\x04"	"GRP\0" \
	"b\x23"		"NOSCHED\0" \
	"b\x22"		"PEND_SWITCH\0" \
	"f\x20\x02"	"PEND_TYPE\0" \
	"f\x00\x20"	"PEND_TAG\0"

/* pow index/pointer load (subid = 3) */
#define POW_IDXPTR_LOAD_QOSGRP			UINT64_C(0x00000000000001e0)
#define POW_IDXPTR_LOAD_GET_DES_GET_TAIL	UINT64_C(0x0000000000000010)
#define POW_IDXPTR_LOAD_GET_RMT			UINT64_C(0x0000000000000008)
#define POW_IDXPTR_LOAD_2_0			UINT64_C(0x0000000000000007)
#define	POW_IDXPTR_LOAD_QOSGRP_SHIFT	5
#define	POW_IDXPTR_LOAD_GET_DES_GET_TAIL_SHIFT	4
#define	POW_IDXPTR_LOAD_2_0_SHIFT	0
#define	POW_IDXPTR_LOAD_GET_RMT_SHIFT	3

/* get_rmt = 0 and get_des_get_tail = 0 ("qos") */
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_XXX_63_52		UINT64_C(0xfff0000000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_FREE_VAL		UINT64_C(0x0008000000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_FREE_ONE		UINT64_C(0x0004000000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_XXX_49		UINT64_C(0x0002000000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_FREE_HEAD		UINT64_C(0x0001ffc000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_XXX_37		UINT64_C(0x0000002000000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_FREE_TAIL		UINT64_C(0x0000001ffc000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_LOC_VAL		UINT64_C(0x0000000002000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_LOC_ONE		UINT64_C(0x0000000001000000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_XXX_23		UINT64_C(0x0000000000800000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_LOC_HEAD		UINT64_C(0x00000000007ff000)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_XXX_11		UINT64_C(0x0000000000000800)
#define POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_LOC_TAIL		UINT64_C(0x00000000000007ff)
#define	POW_IDXPTR_LOAD_RESULT_QOS_FREE_LOC_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x33"		"FREE_VAL\0" \
	"b\x32"		"FREE_ONE\0" \
	"f\x26\x0b"	"FREE_HEAD\0" \
	"f\x1a\x0b"	"FREE_TAIL\0" \
	"b\x19"		"LOC_VAL\0" \
	"b\x18"		"LOC_ONE\0" \
	"f\x0c\x0b"	"LOC_HEAD\0" \
	"f\x00\x0b"	"LOC_TAIL\0"

/* get_rmt = 0 and get_des_get_tail = 1 ("desched") */
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_XXX_63_52	UINT64_C(0xfff0000000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_NOSCHED_VAL	UINT64_C(0x0008000000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_NOSCHED_ONE	UINT64_C(0x0004000000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_XXX_49		UINT64_C(0x0002000000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_NOSCHED_HEAD	UINT64_C(0x0001ffc000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_XXX_37		UINT64_C(0x0000002000000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_NOSCHED_TAIL	UINT64_C(0x0000001ffc000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_DES_VAL		UINT64_C(0x0000000002000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_DES_ONE		UINT64_C(0x0000000001000000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_XXX_23		UINT64_C(0x0000000000800000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_DES_HEAD		UINT64_C(0x00000000007ff000)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_XXX_11		UINT64_C(0x0000000000000800)
#define POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_DES_TAIL		UINT64_C(0x00000000000007ff)
#define	POW_IDXPTR_LOAD_RESULT_GRP_NOSCHED_DES_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x33"		"NOSCHED_VAL\0" \
	"b\x32"		"NOSCHED_ONE\0" \
	"f\x26\x0b"	"NOSCHED_HEAD\0" \
	"f\x1a\x0b"	"NOSCHED_TAIL\0" \
	"b\x19"		"DES_VAL\0" \
	"b\x18"		"DES_ONE\0" \
	"f\x0c\x0b"	"DES_HEAD\0" \
	"f\x00\x0b"	"DES_TAIL\0"

/* get_rmt = 1 and get_des_get_tail = 0 ("remote_head") */
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_XXX_63_39	UINT64_C(0xffffff8000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_RMT_IS_HEAD	UINT64_C(0x0000004000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_RMT_VAL	UINT64_C(0x0000002000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_RMT_ONE	UINT64_C(0x0000001000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_RMT_HEAD	UINT64_C(0x0000000fffffffff)
#define	POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_HEAD_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x26"		"RMT_IS_HEAD\0" \
	"b\x25"		"RMT_VAL\0" \
	"b\x24"		"RMT_ONE\0" \
	"f\x00\x24"	"RMT_HEAD\0"

/* get_rmt = 1 and get_des_get_tail = 1 ("remote_tail") */
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_XXX_63_39	UINT64_C(0xffffff8000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_RMT_IS_HEAD	UINT64_C(0x0000004000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_RMT_VAL	UINT64_C(0x0000002000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_RMT_ONE	UINT64_C(0x0000001000000000)
#define POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_RMT_TAIL	UINT64_C(0x0000000fffffffff)
#define	POW_IDXPTR_LOAD_RESULT_QUEUE_REMOTE_TAIL_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x26"		"RMT_IS_HEAD\0" \
	"b\x25"		"RMT_VAL\0" \
	"b\x24"		"RMT_ONE\0" \
	"f\x00\x24"	"RMT_TAIL\0"

/* pow index/pointer load (subid = 2) */
#define POW_NULL_RD_LOAD_39_3			UINT64_C(0x000000fffffffff8)
#define POW_NULL_RD_LOAD_2_0			UINT64_C(0x0000000000000007)
#define	POW_NULL_RD_LOAD_39_3_SHIFT	3
#define	POW_NULL_RD_LOAD_2_0_SHIFT	0

#define POW_NULL_RD_LOAD_RESULT_63_2		UINT64_C(0xfffffffffffffffc)
#define POW_NULL_RD_LOAD_RESULT_STATUS		UINT64_C(0x0000000000000003)

/* pow store operations */

#define POW_PHY_ADDR_STORE_ADDR			UINT64_C(0x0000000fffffffff)
#define	POW_PHY_ADDR_STORE_ADDR_SHIFT	0

#define POW_STORE_DATA_NO_SCHED			UINT64_C(0x8000000000000000)
#define POW_STORE_DATA_62_61			UINT64_C(0x6000000000000000)
#define POW_STORE_DATA_INDEX			UINT64_C(0x1fff000000000000)
#define POW_STORE_DATA_OP			UINT64_C(0x0000f00000000000)
#define POW_STORE_DATA_43_42			UINT64_C(0x00000c0000000000)
#define POW_STORE_DATA_QOS			UINT64_C(0x0000038000000000)
#define POW_STORE_DATA_GRP			UINT64_C(0x0000007800000000)
#define POW_STORE_DATA_TYPE			UINT64_C(0x0000000700000000)
#define POW_STORE_DATA_TAG			UINT64_C(0x00000000ffffffff)
#define	POW_STORE_DATA_INDEX_SHIFT	48
#define	POW_STORE_DATA_OP_SHIFT	44
#define	POW_STORE_DATA_NO_SCHED_SHIFT	63
#define	POW_STORE_DATA_62_61_SHIFT	61
#define	POW_STORE_DATA_43_42_SHIFT	42
#define	POW_STORE_DATA_QOS_SHIFT	39
#define	POW_STORE_DATA_GRP_SHIFT	35
#define	POW_STORE_DATA_TYPE_SHIFT	32
#define	POW_STORE_DATA_TAG_SHIFT	0

/* pow iobdma operations */ 

/* pow iobdma operations base*/ 
#define POW_IOBDMA_BASE_SCRADDR			UINT64_C(0xff00000000000000)
#define POW_IOBDMA_BASE_LEN			UINT64_C(0x00ff000000000000)
#define POW_IOBDMA_BASE_MAJOR_DID		UINT64_C(0x0000f80000000000)
#define POW_IOBDMA_BASE_SUB_DID			UINT64_C(0x0000070000000000)
#define POW_IOBDMA_BASE_39_0			UINT64_C(0x000000ffffffffff)
#define	POW_IOBDMA_BASE_MAJOR_DID_SHIFT	43
#define	POW_IOBDMA_BASE_LEN_SHIFT	48
#define	POW_IOBDMA_BASE_39_0_SHIFT	0
#define	POW_IOBDMA_BASE_SCRADDR_SHIFT	56
#define	POW_IOBDMA_BASE_SUB_DID_SHIFT	40

/* pow iobdma get work (subid = 0) */ 
#define POW_IOBDMA_GET_WORK_39_4		UINT64_C(0x000000ffffffffff)
#define POW_IOBDMA_GET_WORK_WAIT		UINT64_C(0x0000000000000008)
#define POW_IOBDMA_GET_WORK_2_0			UINT64_C(0x0000000000000007)
#define	POW_IOBDMA_GET_WORK_WAIT_SHIFT	3
#define	POW_IOBDMA_GET_WORK_39_4_SHIFT	0
#define	POW_IOBDMA_GET_WORK_2_0_SHIFT	0

#define POW_IOBDMA_GET_WORK_RESULT_NO_WORK	UINT64_C(0x8000000000000000)
#define POW_IOBDMA_GET_WORK_RESULT_62_40	UINT64_C(0x7fffff0000000000)
#define POW_IOBDMA_GET_WORK_RESULT_ADDR		UINT64_C(0x000000ffffffffff)

/* pow iobdma null rd (subid = 4) */
#define POW_IOBDMA_NULL_RD_39_0			UINT64_C(0x000000ffffffffff)
#define	POW_IOBDMA_NULL_RD_39_0_SHIFT	0

#define POW_IOBDMA_NULL_RD_RESULT_63_2		UINT64_C(0xfffffffffffffffc)
#define POW_IOBDMA_NULL_RD_RESULT_STATUS	UINT64_C(0x0000000000000003)

/* ------------------------------------------------------------------------- */

/* Work Queue Entry */

#define	POW_WQE_WORD0_XXX_63_40			UINT64_C(0xffffff0000000000)
#define	POW_WQE_WORD0_NEXT			UINT64_C(0x000000ffffffffff)
#define	POW_WQE_WORD0_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x28"	"NEXT\0"
#define	POW_WQE_WORD0_NEXT_SHIFT	0

#define	POW_WQE_WORD1_XXX_63_42			UINT64_C(0xfffffc0000000000)
#define	POW_WQE_WORD1_QOS			UINT64_C(0x0000038000000000)
#define	POW_WQE_WORD1_GRP			UINT64_C(0x0000007800000000)
#define	POW_WQE_WORD1_TT			UINT64_C(0x0000000700000000)
#define	POW_WQE_WORD1_TAG			UINT64_C(0x00000000ffffffff)
#define	POW_WQE_WORD1_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x27\x03"	"QOS\0" \
	"f\x23\x04"	"GRP\0" \
	"f\x20\x03"	"TT\0" \
	"f\x00\x20"	"TAG\0"
#define	POW_WQE_WORD1_TT_SHIFT	32
#define	POW_WQE_WORD1_QOS_SHIFT	39
#define	POW_WQE_WORD1_GRP_SHIFT	35
#define	POW_WQE_WORD1_TAG_SHIFT	0

/* ------------------------------------------------------------------------- */

/* for snprintb(9) */

#define	POW_PP_GRP_MSKX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x10"	"GRP_MSK\0"
#define	POW_PP_GRP_MSK0_BITS	POW_PP_GRP_MSKX_BITS
#define	POW_PP_GRP_MSK1_BITS	POW_PP_GRP_MSKX_BITS
#define	POW_WQ_INT_THRX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x1c"		"TC_EN\0" \
	"f\x18\x04"	"TC_THR\0" \
	"f\x0c\x06"	"DS_THR\0" \
	"f\x00\x06"	"IQ_THR\0"
#define	POW_WQ_INT_THR0_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR1_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR2_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR3_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR4_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR5_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR6_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR7_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR8_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR9_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR10_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR11_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR12_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR13_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR14_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_THR15_BITS	POW_WQ_INT_THRX_BITS
#define	POW_WQ_INT_CNTX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x18\x04"	"TC_CNT\0" \
	"f\x0c\x06"	"DS_CNT\0" \
	"f\x00\x06"	"IQ_CNT\0"
#define	POW_WQ_INT_CNT0_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT1_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT2_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT3_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT4_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT5_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT6_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT7_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT8_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT9_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT10_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT11_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT12_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT13_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT14_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_WQ_INT_CNT15_BITS	POW_WQ_INT_CNTX_BITS
#define	POW_QOS_THRX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x30\x07"	"DES_CNT\0" \
	"f\x24\x07"	"BUF_CNT\0" \
	"f\x18\x07"	"FREE_CNT\0" \
	"f\x0c\x06"	"MAX_THR\0" \
	"f\x00\x06"	"MIN_THR\0"
#define	POW_QOS_THR0_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR1_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR2_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR3_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR4_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR5_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR6_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_THR7_BITS	POW_QOS_THRX_BITS
#define	POW_QOS_RNDX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x18\x08"	"RND_P3\0" \
	"f\x10\x08"	"RND_P2\0" \
	"f\x08\x08"	"RND_P1\0" \
	"f\x00\x08"	"RND\0"
#define	POW_QOS_RND0_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND1_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND2_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND3_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND4_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND5_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND6_BITS	POW_QOS_RNDX_BITS
#define	POW_QOS_RND7_BITS	POW_QOS_RNDX_BITS
#define	POW_WQ_INT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x10\x10"	"IQ_DIS\0" \
	"f\x00\x10"	"WQ_INT\0"
#define	POW_WQ_INT_PC_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x20\x1c"	"PC\0" \
	"f\x08\x14"	"PC_THR\0"
#define	POW_NW_TIM_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x0a"	"NW_TIM\0"
#define	POW_ECC_ERR_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x20\x0d"	"IOP_IE\0" \
	"f\x10\x0d"	"IOP\0" \
	"b\x0d"		"RPE_IE\0" \
	"b\x0c"		"RPE\0" \
	"f\x04\x05"	"SYN\0" \
	"b\x03"		"DBE_IE\0" \
	"b\x02"		"SBE_IE\0" \
	"b\x01"		"DBE\0" \
	"b\x00"		"SBE\0"
#define	POW_NOS_CNT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x07"	"NOS_CNT\0"
#define	POW_WS_PCX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \

#define	POW_WS_PC0_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC1_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC2_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC3_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC4_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC5_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC6_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC7_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC8_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC9_BITS		POW_WS_PCX_BITS
#define	POW_WS_PC10_BITS	POW_WS_PCX_BITS
#define	POW_WS_PC11_BITS	POW_WS_PCX_BITS
#define	POW_WS_PC12_BITS	POW_WS_PCX_BITS
#define	POW_WS_PC13_BITS	POW_WS_PCX_BITS
#define	POW_WS_PC14_BITS	POW_WS_PCX_BITS
#define	POW_WS_PC15_BITS	POW_WS_PCX_BITS
#define	POW_WA_PCX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \

#define	POW_WA_PC0_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC1_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC2_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC3_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC4_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC5_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC6_BITS		POW_WA_PCX_BITS
#define	POW_WA_PC7_BITS		POW_WA_PCX_BITS
#define	POW_IQ_CNTX_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \

#define	POW_IQ_CNT0_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT1_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT2_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT3_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT4_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT5_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT6_BITS	POW_IQ_CNTX_BITS
#define	POW_IQ_CNT7_BITS	POW_IQ_CNTX_BITS
#define	POW_WA_COM_PC_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x20"	"WA_PC\0"
#define	POW_IQ_COM_CNT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \

#define	POW_TS_PC_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x20"	"TS_PC\0"
#define	POW_DS_PC_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"f\x00\x20"	"DS_PC\0"
#define	POW_BIST_STAT_BITS \
	"\177"		/* new format */ \
	"\020"		/* hex display */ \
	"\020"		/* %016x format */ \
	"b\x10"		"PP\0" \
	"b\x08"		"CAM\0" \
	"b\x07"		"NBT1\0" \
	"b\x06"		"NBT0\0" \
	"b\x05"		"IDX\0" \
	"b\x04"		"FIDX\0" \
	"b\x03"		"NBR1\0" \
	"b\x02"		"NBR0\0" \
	"b\x01"		"PEND\0" \
	"b\x00"		"ADR\0"

#endif /* _OCTEON_POWREG_H_ */
