/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan {
    static final int INITIAL_CACHE_CAPACITY = 29;
    static final float CACHE_LOAD_FACTOR = 0.75f;
    private long m_pointer;
    private static final Map s_planCache;
    private final Object m_key;

    private ExecutionPlan(Object key, long pointer) {
        this.m_key = key;
        this.m_pointer = pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ExecutionPlan old = s_planCache.put(this.m_key, this);
        if (old != null && old.m_pointer != 0L) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                ExecutionPlan._invalidate(old.m_pointer);
                old.m_pointer = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portal cursorOpen(String cursorName, Object[] parameters) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._cursorOpen(this.m_pointer, System.identityHashCode(Thread.currentThread()), cursorName, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._isCursorPlan(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] parameters, int rowCount) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._execute(this.m_pointer, System.identityHashCode(Thread.currentThread()), parameters, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionPlan prepare(String statement, Oid[] argTypes) throws SQLException {
        Object key = argTypes == null ? statement : new PlanKey(statement, argTypes);
        ExecutionPlan plan = (ExecutionPlan)s_planCache.remove(key);
        if (plan == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                plan = new ExecutionPlan(key, ExecutionPlan._prepare(System.identityHashCode(Thread.currentThread()), statement, argTypes));
            }
        }
        return plan;
    }

    private static native Portal _cursorOpen(long var0, long var2, String var4, Object[] var5) throws SQLException;

    private static native boolean _isCursorPlan(long var0) throws SQLException;

    private static native int _execute(long var0, long var2, Object[] var4, int var5) throws SQLException;

    private static native long _prepare(long var0, String var2, Oid[] var3) throws SQLException;

    private static native void _invalidate(long var0);

    static {
        int cacheSize = Backend.getStatementCacheSize();
        s_planCache = Collections.synchronizedMap(new PlanCache(cacheSize < 11 ? 11 : cacheSize));
    }

    static final class PlanKey {
        private final int m_hashCode;
        private final String m_stmt;
        private final Oid[] m_argTypes;

        PlanKey(String stmt, Oid[] argTypes) {
            this.m_stmt = stmt;
            this.m_hashCode = stmt.hashCode() + 1;
            this.m_argTypes = argTypes;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PlanKey)) {
                return false;
            }
            PlanKey pk = (PlanKey)o;
            if (!pk.m_stmt.equals(this.m_stmt)) {
                return false;
            }
            Oid[] mat = this.m_argTypes;
            Oid[] pat = pk.m_argTypes;
            int idx = pat.length;
            if (mat.length != idx) {
                return false;
            }
            while (--idx >= 0) {
                if (pat[idx].equals(mat[idx])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    static final class PlanCache
    extends LinkedHashMap {
        private final int m_cacheSize;

        public PlanCache(int cacheSize) {
            super(29, 0.75f, true);
            this.m_cacheSize = cacheSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() <= this.m_cacheSize) {
                return false;
            }
            ExecutionPlan evicted = (ExecutionPlan)eldest.getValue();
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                if (evicted.m_pointer != 0L) {
                    ExecutionPlan._invalidate(evicted.m_pointer);
                    evicted.m_pointer = 0L;
                }
            }
            return true;
        }
    }
}

