/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.internal.TupleTable;

public class SPI {
    public static final int ERROR_CONNECT = -1;
    public static final int ERROR_COPY = -2;
    public static final int ERROR_OPUNKNOWN = -3;
    public static final int ERROR_UNCONNECTED = -4;
    public static final int ERROR_CURSOR = -5;
    public static final int ERROR_ARGUMENT = -6;
    public static final int ERROR_PARAM = -7;
    public static final int ERROR_TRANSACTION = -8;
    public static final int ERROR_NOATTRIBUTE = -9;
    public static final int ERROR_NOOUTFUNC = -10;
    public static final int ERROR_TYPUNKNOWN = -11;
    public static final int OK_CONNECT = 1;
    public static final int OK_FINISH = 2;
    public static final int OK_FETCH = 3;
    public static final int OK_UTILITY = 4;
    public static final int OK_SELECT = 5;
    public static final int OK_SELINTO = 6;
    public static final int OK_INSERT = 7;
    public static final int OK_DELETE = 8;
    public static final int OK_UPDATE = 9;
    public static final int OK_CURSOR = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exec(String command, int rowCount) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SPI._exec(System.identityHashCode(Thread.currentThread()), command, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTupTable() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            SPI._freeTupTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getProcessed() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SPI._getProcessed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResult() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SPI._getResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TupleTable getTupTable(TupleDesc known) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SPI._getTupTable(known);
        }
    }

    public static String getResultText(int resultCode) {
        String s;
        switch (resultCode) {
            case -1: {
                s = "ERROR_CONNECT";
                break;
            }
            case -2: {
                s = "ERROR_COPY";
                break;
            }
            case -3: {
                s = "ERROR_OPUNKNOWN";
                break;
            }
            case -4: {
                s = "ERROR_UNCONNECTED";
                break;
            }
            case -5: {
                s = "ERROR_CURSOR";
                break;
            }
            case -6: {
                s = "ERROR_ARGUMENT";
                break;
            }
            case -7: {
                s = "ERROR_PARAM";
                break;
            }
            case -8: {
                s = "ERROR_TRANSACTION";
                break;
            }
            case -9: {
                s = "ERROR_NOATTRIBUTE";
                break;
            }
            case -10: {
                s = "ERROR_NOOUTFUNC";
                break;
            }
            case -11: {
                s = "ERROR_TYPUNKNOWN";
                break;
            }
            case 1: {
                s = "OK_CONNECT";
                break;
            }
            case 2: {
                s = "OK_FINISH";
                break;
            }
            case 3: {
                s = "OK_FETCH";
                break;
            }
            case 4: {
                s = "OK_UTILITY";
                break;
            }
            case 5: {
                s = "OK_SELECT";
                break;
            }
            case 6: {
                s = "OK_SELINTO";
                break;
            }
            case 7: {
                s = "OK_INSERT";
                break;
            }
            case 8: {
                s = "OK_DELETE";
                break;
            }
            case 9: {
                s = "OK_UPDATE";
                break;
            }
            case 10: {
                s = "OK_CURSOR";
                break;
            }
            default: {
                s = "Unkown result code: " + resultCode;
            }
        }
        return s;
    }

    private static native int _exec(long var0, String var2, int var3);

    private static native int _getProcessed();

    private static native int _getResult();

    private static native void _freeTupTable();

    private static native TupleTable _getTupTable(TupleDesc var0);
}

