/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.PgSavepoint;

class SubXactListener {
    private static final HashMap s_listeners = new HashMap();

    SubXactListener() {
    }

    static void onAbort(long listenerId, int spId, int parentSpId) throws SQLException {
        SavepointListener listener = (SavepointListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onAbort(Backend.getSession(), PgSavepoint.forId(spId), PgSavepoint.forId(parentSpId));
        }
    }

    static void onCommit(long listenerId, int spId, int parentSpId) throws SQLException {
        SavepointListener listener = (SavepointListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onCommit(Backend.getSession(), PgSavepoint.forId(spId), PgSavepoint.forId(parentSpId));
        }
    }

    static void onStart(long listenerId, long spPointer, int parentSpId) throws SQLException {
        SavepointListener listener = (SavepointListener)s_listeners.get(new Long(listenerId));
        if (listener != null) {
            listener.onStart(Backend.getSession(), new PgSavepoint(spPointer), PgSavepoint.forId(parentSpId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(SavepointListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long key = System.identityHashCode(listener);
            if (s_listeners.put(new Long(key), listener) != listener) {
                SubXactListener._register(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(SavepointListener listener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long key = System.identityHashCode(listener);
            if (s_listeners.remove(new Long(key)) == listener) {
                SubXactListener._unregister(key);
            }
        }
    }

    private static native void _register(long var0);

    private static native void _unregister(long var0);
}

