/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class ClobValue
extends Reader
implements Clob {
    private long m_markPos;
    private final long m_nChars;
    private final Reader m_reader;
    private long m_readerPos;

    public static int getReaderLength(Reader value) throws SQLException {
        try {
            value.mark(Integer.MAX_VALUE);
            long length = value.skip(Long.MAX_VALUE);
            if (length > Integer.MAX_VALUE) {
                throw new SQLException("stream content too large");
            }
            value.reset();
            return (int)length;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public ClobValue(Reader reader, long nChars) {
        this.m_reader = reader;
        this.m_nChars = nChars;
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    public ClobValue(String value) {
        this(new StringReader(value), value.length());
    }

    @Override
    public void close() throws IOException {
        this.m_reader.close();
        this.m_readerPos = 0L;
        this.m_markPos = 0L;
    }

    @Override
    public InputStream getAsciiStream() {
        return new BufferedInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                int nextChar = ClobValue.this.read();
                if (nextChar > 127) {
                    throw new CharConversionException("Non ascii character in Clob data");
                }
                return nextChar;
            }
        });
    }

    @Override
    public Reader getCharacterStream() {
        return this;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 0L || length < 0) {
            throw new IllegalArgumentException();
        }
        if (length == 0) {
            return "";
        }
        if (pos + (long)length > this.m_nChars) {
            throw new SQLException("Attempt to read beyond end of Clob data");
        }
        long skip = pos - this.m_readerPos;
        if (skip < 0L) {
            throw new SQLException("Cannot position Clob stream backwards");
        }
        try {
            char[] buf;
            int nr;
            if (skip > 0L) {
                this.skip(skip);
            }
            if ((nr = this.read(buf = new char[length])) < length) {
                throw new SQLException("Clob data read not fulfilled");
            }
            return new String(buf);
        }
        catch (IOException e) {
            throw new SQLException("Error reading Blob data: " + e.getMessage());
        }
    }

    @Override
    public long length() {
        return this.m_nChars;
    }

    @Override
    public synchronized void mark(int readLimit) throws IOException {
        this.m_reader.mark(readLimit);
        this.m_markPos = this.m_readerPos;
    }

    @Override
    public boolean markSupported() {
        return this.m_reader.markSupported();
    }

    @Override
    public long position(Clob pattern, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(String pattern, long start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int read() throws IOException {
        int rs = this.m_reader.read();
        ++this.m_readerPos;
        return rs;
    }

    @Override
    public synchronized int read(char[] b) throws IOException {
        int rs = this.m_reader.read(b);
        this.m_readerPos += (long)rs;
        return rs;
    }

    @Override
    public synchronized int read(char[] b, int off, int len) throws IOException {
        int rs = this.m_reader.read(b, off, len);
        this.m_readerPos += (long)rs;
        return rs;
    }

    @Override
    public synchronized boolean ready() throws IOException {
        return this.m_reader.ready();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.m_reader.reset();
        this.m_readerPos = this.m_markPos;
    }

    @Override
    public OutputStream setAsciiStream(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer setCharacterStream(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long pos, String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized long skip(long nBytes) throws IOException {
        long skipped = this.m_reader.skip(nBytes);
        this.m_readerPos += skipped;
        return skipped;
    }

    @Override
    public void truncate(long len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".getCharacterStream( long,long ) not implemented yet.", "0A000");
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".free() not implemented yet.", "0A000");
    }
}

