/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;

public class SQLOutputToChunk
implements SQLOutput {
    private static final byte[] s_byteBuffer = new byte[8];
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private long m_handle;
    private ByteBuffer m_bb;
    private static ByteOrder scalarOrder;
    private static ByteOrder mirrorOrder;

    public SQLOutputToChunk(long handle, ByteBuffer bb, boolean isJavaBasedScalar) throws SQLException {
        this.m_handle = handle;
        this.m_bb = bb;
        if (isJavaBasedScalar) {
            if (null == scalarOrder) {
                scalarOrder = this.getOrder(true);
            }
            this.m_bb.order(scalarOrder);
        } else {
            if (null == mirrorOrder) {
                mirrorOrder = this.getOrder(false);
            }
            this.m_bb.order(mirrorOrder);
        }
    }

    private ByteOrder getOrder(boolean isJavaBasedScalar) throws SQLException {
        ByteOrder result;
        String key = "org.postgresql.pljava.udt.byteorder." + (isJavaBasedScalar ? "scalar" : "mirror") + ".j2p";
        String val = System.getProperty(key);
        if ("big_endian".equals(val)) {
            result = ByteOrder.BIG_ENDIAN;
        } else if ("little_endian".equals(val)) {
            result = ByteOrder.LITTLE_ENDIAN;
        } else if ("native".equals(val)) {
            result = ByteOrder.nativeOrder();
        } else {
            throw new SQLNonTransientException("System property " + key + " must be big_endian, little_endian, or native", "F0000");
        }
        return result;
    }

    @Override
    public void writeArray(Array value) throws SQLException {
        throw this.unsupportedOperationException("writeArray");
    }

    @Override
    public void writeAsciiStream(InputStream value) throws SQLException {
        throw this.unsupportedOperationException("writeAsciiStream");
    }

    @Override
    public void writeBigDecimal(BigDecimal value) throws SQLException {
        this.writeString(value.toString());
    }

    @Override
    public void writeBinaryStream(InputStream value) throws SQLException {
        int got;
        byte[] buf = new byte[65536];
        try {
            got = value.read(buf);
        }
        catch (IOException e) {
            throw new SQLException("Error making binary form of user-defined type from input stream", "58030", e);
        }
        if (-1 == got) {
            got = 0;
        }
        if (65535 < got) {
            throw this.badRepresentation("writeBinaryStream");
        }
        this.ensureCapacity(2 + got);
        this.m_bb.putShort((short)got).put(buf, 0, got);
    }

    @Override
    public void writeBlob(Blob value) throws SQLException {
        throw this.unsupportedOperationException("writeBlob");
    }

    @Override
    public void writeBoolean(boolean value) throws SQLException {
        this.writeByte(value ? (byte)1 : 0);
    }

    @Override
    public void writeByte(byte value) throws SQLException {
        try {
            this.m_bb.put(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 1, "writeByte");
            this.m_bb.put(value);
        }
    }

    @Override
    public void writeBytes(byte[] buffer) throws SQLException {
        if (65535 < buffer.length) {
            throw this.badRepresentation("writeBytes");
        }
        this.ensureCapacity(2 + buffer.length);
        this.m_bb.putShort((short)buffer.length).put(buffer);
    }

    @Override
    public void writeCharacterStream(Reader value) throws SQLException {
        ByteBuffer bb = ByteBuffer.allocate(65535);
        CharBuffer cb = CharBuffer.allocate(1024);
        CharsetEncoder enc = UTF8.newEncoder();
        try {
            CoderResult cr;
            while (-1 != value.read(cb)) {
                cb.flip();
                cr = enc.encode(cb, bb, false);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                cb.clear();
            }
            cb.flip();
            cr = enc.encode(cb, bb, true);
            if (cr.isUnderflow()) {
                cr = enc.flush(bb);
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            bb.flip();
            this.ensureCapacity(2 + bb.limit());
            this.m_bb.putShort((short)bb.limit()).put(bb);
        }
        catch (Exception e) {
            throw this.badRepresentation(e);
        }
    }

    @Override
    public void writeClob(Clob value) throws SQLException {
        throw this.unsupportedOperationException("writeClob");
    }

    @Override
    public void writeDate(Date value) throws SQLException {
        long v = value.getTime();
        try {
            this.m_bb.putLong(v);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 8, "writeDate");
            this.m_bb.putLong(v);
        }
    }

    @Override
    public void writeDouble(double value) throws SQLException {
        try {
            this.m_bb.putDouble(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 8, "writeDouble");
            this.m_bb.putDouble(value);
        }
    }

    @Override
    public void writeFloat(float value) throws SQLException {
        try {
            this.m_bb.putFloat(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 4, "writeFloat");
            this.m_bb.putFloat(value);
        }
    }

    @Override
    public void writeInt(int value) throws SQLException {
        try {
            this.m_bb.putInt(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 4, "writeInt");
            this.m_bb.putInt(value);
        }
    }

    @Override
    public void writeLong(long value) throws SQLException {
        try {
            this.m_bb.putLong(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 8, "writeLong");
            this.m_bb.putLong(value);
        }
    }

    @Override
    public void writeObject(SQLData value) throws SQLException {
        throw this.unsupportedOperationException("writeObject");
    }

    @Override
    public void writeRef(Ref value) throws SQLException {
        throw this.unsupportedOperationException("writeRef");
    }

    @Override
    public void writeShort(short value) throws SQLException {
        try {
            this.m_bb.putShort(value);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 2, "writeShort");
            this.m_bb.putShort(value);
        }
    }

    @Override
    public void writeString(String value) throws SQLException {
        CharBuffer cb = CharBuffer.wrap(value);
        try {
            CharsetEncoder enc = UTF8.newEncoder();
            ByteBuffer bb = enc.encode(cb);
            int len = bb.limit();
            if (65535 < len) {
                throw this.badRepresentation("writeString");
            }
            this.ensureCapacity(2 + len);
            this.m_bb.putShort((short)len).put(bb);
        }
        catch (Exception e) {
            throw this.badRepresentation(e);
        }
    }

    @Override
    public void writeStruct(Struct value) throws SQLException {
        throw this.unsupportedOperationException("writeStruct");
    }

    @Override
    public void writeTime(Time value) throws SQLException {
        long v = value.getTime();
        try {
            this.m_bb.putLong(v);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 8, "writeTime");
            this.m_bb.putLong(v);
        }
    }

    @Override
    public void writeTimestamp(Timestamp value) throws SQLException {
        long v = value.getTime();
        try {
            this.m_bb.putLong(v);
        }
        catch (Exception e) {
            this.throwOrRetry(e, 8, "writeTimestamp");
            this.m_bb.putLong(v);
        }
    }

    @Override
    public void writeURL(URL value) throws SQLException {
        this.writeString(value.toString());
    }

    void close() throws SQLException {
        if (0L == this.m_handle) {
            return;
        }
        this.ensureCapacity(0);
        this.m_handle = 0L;
        this.m_bb = null;
    }

    private void throwOrRetry(Exception e, int needed, String fn) throws SQLException {
        if (e instanceof BufferOverflowException) {
            this.ensureCapacity(needed);
            return;
        }
        throw this.badRepresentation(e);
    }

    private SQLException unsupportedOperationException(String op) {
        return new SQLFeatureNotSupportedException(this.getClass() + "." + op + " not implemented yet.", "0A000");
    }

    private SQLException badRepresentation(String fn) {
        return new SQLNonTransientException("Limit of 65535 bytes exceeded in " + fn + "for user-defined type", "54000");
    }

    private SQLException badRepresentation(Exception e) {
        if (e instanceof NullPointerException) {
            return new SQLNonTransientException("attempted write via SQLOutput after closing it", "55000", e);
        }
        if (e instanceof BufferOverflowException) {
            return new SQLNonTransientException("Byte limit exceeded for user-defined type", "54000");
        }
        if (e instanceof UnmappableCharacterException) {
            return new SQLDataException("Character not available in destination encoding", "22P05", e);
        }
        if (e instanceof MalformedInputException) {
            return new SQLDataException("Input that does not encode a valid character", "22021", e);
        }
        return new SQLDataException("Could not form binary representation of user-defined type", "22P03", e);
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw this.unsupportedOperationException("writeNClob( NClob )");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw this.unsupportedOperationException("writeNString( String )");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw this.unsupportedOperationException("writeRowId( RowId )");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw this.unsupportedOperationException("writeSQLXML( SQLXML )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int c) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            if (this.m_handle == 0L) {
                throw new SQLException("Stream is closed");
            }
            ByteBuffer oldbb = this.m_bb;
            this.m_bb = SQLOutputToChunk._ensureCapacity(this.m_handle, this.m_bb, this.m_bb.position(), c);
            if (this.m_bb != oldbb) {
                this.m_bb.order(oldbb.order());
            }
        }
    }

    private static native ByteBuffer _ensureCapacity(long var0, ByteBuffer var2, int var3, int var4);
}

