/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.pljava.Session;
import org.postgresql.pljava.SessionManager;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.sqlgen.Lexicals;

public abstract class DDRExecutor {
    private static final DDRExecutor PLAIN = new Plain();
    private static final DDRExecutor NOOP = new Noop();
    private static final Pattern settingsRx = Pattern.compile(String.format("\\G(%1$s)(,\\s*)?", Lexicals.ISO_PG_JAVA_IDENTIFIER));

    protected DDRExecutor() {
    }

    public abstract void execute(String var1, Connection var2) throws SQLException;

    public static DDRExecutor forImplementor(String name) throws SQLException {
        String[] imps;
        if (null == name) {
            return PLAIN;
        }
        for (String i : imps = DDRExecutor.implementors()) {
            if (!name.equalsIgnoreCase(i)) continue;
            return PLAIN;
        }
        return NOOP;
    }

    private static String[] implementors() throws SQLException {
        String settingString = Backend.getConfigOption("pljava.implementors");
        ArrayList<String> al = new ArrayList<String>();
        Matcher m = settingsRx.matcher(settingString);
        while (m.find()) {
            al.add(m.group(1));
            if (-1 != m.start(2) || !m.hitEnd()) continue;
            return al.toArray(new String[al.size()]);
        }
        throw new SQLException("Failed to parse current pljava.implementors");
    }

    static class Plain
    extends DDRExecutor {
        Plain() {
        }

        @Override
        public void execute(String sql, Connection conn) throws SQLException {
            Session session = SessionManager.current();
            session.executeAsOuterUser(conn, sql);
        }
    }

    static class Noop
    extends DDRExecutor {
        Noop() {
        }

        @Override
        public void execute(String sql, Connection conn) throws SQLException {
        }
    }
}

