/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks;

import com.github.maven_nar.cpptasks.CCTaskProgressMonitor;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.CompilerEnum;
import com.github.maven_nar.cpptasks.DependencyTable;
import com.github.maven_nar.cpptasks.DistributerDef;
import com.github.maven_nar.cpptasks.FileVisitor;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.ObjectFileCollector;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.OutputTypeEnum;
import com.github.maven_nar.cpptasks.PrecompileDef;
import com.github.maven_nar.cpptasks.ProcessorDef;
import com.github.maven_nar.cpptasks.RuntimeType;
import com.github.maven_nar.cpptasks.SubsystemEnum;
import com.github.maven_nar.cpptasks.TargetDef;
import com.github.maven_nar.cpptasks.TargetHistoryTable;
import com.github.maven_nar.cpptasks.TargetInfo;
import com.github.maven_nar.cpptasks.TargetMatcher;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.WarningLevelEnum;
import com.github.maven_nar.cpptasks.compiler.CompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.LinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProcessorConfiguration;
import com.github.maven_nar.cpptasks.ide.ProjectDef;
import com.github.maven_nar.cpptasks.types.CompilerArgument;
import com.github.maven_nar.cpptasks.types.ConditionalFileSet;
import com.github.maven_nar.cpptasks.types.DefineSet;
import com.github.maven_nar.cpptasks.types.IncludePath;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemIncludePath;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;

public class CCTask
extends Task {
    private static final ProcessorConfiguration[] EMPTY_CONFIG_ARRAY = new ProcessorConfiguration[0];
    private int maxCores = 0;
    private boolean ordered = false;
    private Vector<CompilerDef> _compilers = new Vector();
    private Vector _libsets = new Vector();
    private Vector<LinkerDef> _linkers = new Vector();
    private File _objDir;
    private File _outfile;
    private final Vector<TargetDef> targetPlatforms = new Vector();
    private Vector<DistributerDef> distributers = new Vector();
    private final Vector<VersionInfo> versionInfos = new Vector();
    private final Vector<ProjectDef> projects = new Vector();
    private boolean projectsOnly = false;
    private boolean decorateLinkerOptions = true;
    protected boolean failOnError = true;
    private final CompilerDef compilerDef = new CompilerDef();
    private String dataset;
    private int dependencyDepth = -1;
    private final LinkerDef linkerDef = new LinkerDef();
    private final LinkType linkType = new LinkType();
    private String outputFileProperty;
    private boolean relentless;
    private int commandLogLevel = 3;

    public static Map<ProcessorConfiguration, Vector<TargetInfo>> getTargetsToBuildByConfiguration(Map<String, TargetInfo> targets) {
        HashMap<ProcessorConfiguration, Vector<TargetInfo>> targetsByConfig = new HashMap<ProcessorConfiguration, Vector<TargetInfo>>();
        for (TargetInfo target : targets.values()) {
            if (!target.getRebuild()) continue;
            Vector<TargetInfo> targetsForSameConfig = (Vector<TargetInfo>)targetsByConfig.get(target.getConfiguration());
            if (targetsForSameConfig != null) {
                targetsForSameConfig.addElement(target);
                continue;
            }
            targetsForSameConfig = new Vector<TargetInfo>();
            targetsForSameConfig.addElement(target);
            targetsByConfig.put(target.getConfiguration(), targetsForSameConfig);
        }
        return targetsByConfig;
    }

    public boolean isDecorateLinkerOptions() {
        return this.decorateLinkerOptions;
    }

    public void setDecorateLinkerOptions(boolean decorateLinkerOptions) {
        this.decorateLinkerOptions = decorateLinkerOptions;
    }

    public void addConfiguredCompiler(CompilerDef compiler) {
        if (compiler == null) {
            throw new NullPointerException("compiler");
        }
        compiler.setProject(this.getProject());
        this._compilers.addElement(compiler);
    }

    public void addConfiguredCompilerArg(CompilerArgument arg) {
        this.compilerDef.addConfiguredCompilerArg(arg);
    }

    public void addConfiguredDefineset(DefineSet defs) {
        this.compilerDef.addConfiguredDefineset(defs);
    }

    public void addConfiguredLinker(LinkerDef linker) {
        if (linker == null) {
            throw new NullPointerException("linker");
        }
        linker.setProject(this.getProject());
        this._linkers.addElement(linker);
    }

    public void addConfiguredLinkerArg(LinkerArgument arg) {
        this.linkerDef.addConfiguredLinkerArg(arg);
    }

    public void addEnv(Environment.Variable var) {
        this.compilerDef.addEnv(var);
        this.linkerDef.addEnv(var);
    }

    public void addFileset(ConditionalFileSet srcSet) {
        this.compilerDef.addFileset(srcSet);
    }

    public void addLibset(LibrarySet libset) {
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.linkerDef.addLibset(libset);
    }

    public void addSyslibset(SystemLibrarySet libset) {
        if (libset == null) {
            throw new NullPointerException("libset");
        }
        this.linkerDef.addSyslibset(libset);
    }

    public void addProject(ProjectDef projectDef) {
        if (projectDef == null) {
            throw new NullPointerException("projectDef");
        }
        this.projects.addElement(projectDef);
    }

    public void setProjectsOnly(boolean value) {
        this.projectsOnly = value;
    }

    protected int checkForChangedIncludeFiles(Map<String, TargetInfo> targets) {
        int potentialTargets = 0;
        int definiteTargets = 0;
        for (TargetInfo target : targets.values()) {
            if (!target.getRebuild()) {
                ++potentialTargets;
                continue;
            }
            ++definiteTargets;
        }
        if (potentialTargets > 0) {
            this.log("Starting dependency analysis for " + Integer.toString(potentialTargets) + " files.");
            DependencyTable dependencyTable = new DependencyTable(this._objDir);
            try {
                dependencyTable.load();
            }
            catch (Exception ex) {
                this.log("Problem reading dependencies.xml: " + ex.toString());
            }
            for (TargetInfo target : targets.values()) {
                if (target.getRebuild() || !dependencyTable.needsRebuild(this, target, this.dependencyDepth)) continue;
                target.mustRebuild();
            }
            dependencyTable.commit(this);
        }
        int currentTargets = 0;
        for (TargetInfo target : targets.values()) {
            if (!target.getRebuild()) continue;
            ++currentTargets;
        }
        if (potentialTargets > 0) {
            this.log(Integer.toString(potentialTargets - currentTargets + definiteTargets) + " files are up to date.");
            this.log(Integer.toString(currentTargets - definiteTargets) + " files to be recompiled from dependency analysis.");
        }
        this.log(Integer.toString(currentTargets) + " total files to be compiled.");
        return currentTargets;
    }

    protected LinkerConfiguration collectExplicitObjectFiles(Vector<File> objectFiles, Vector<File> sysObjectFiles, VersionInfo versionInfo) {
        ProcessorConfiguration linkerConfig = null;
        ProcessorDef selectedLinkerDef = null;
        Linker selectedLinker = null;
        Hashtable<String, File> sysLibraries = new Hashtable<String, File>();
        TargetDef targetPlatform = this.getTargetPlatform();
        ObjectFileCollector objCollector = null;
        SystemLibraryCollector sysLibraryCollector = null;
        for (int i = 0; i < this._linkers.size(); ++i) {
            LinkerDef currentLinkerDef = this._linkers.elementAt(i);
            if (!currentLinkerDef.isActive()) continue;
            selectedLinkerDef = currentLinkerDef;
            selectedLinker = currentLinkerDef.getProcessor().getLinker(this.linkType);
            if (selectedLinker == null) continue;
            linkerConfig = currentLinkerDef.createConfiguration(this, this.linkType, this.linkerDef, targetPlatform, versionInfo);
            if (linkerConfig == null) break;
            objCollector = new ObjectFileCollector(selectedLinker, objectFiles);
            sysLibraryCollector = new SystemLibraryCollector(selectedLinker, sysLibraries);
            if (currentLinkerDef.hasFileSets()) {
                currentLinkerDef.visitFiles(objCollector);
            }
            ((LinkerDef)selectedLinkerDef).visitUserLibraries(selectedLinker, objCollector);
            break;
        }
        if (linkerConfig == null) {
            linkerConfig = this.linkerDef.createConfiguration(this, this.linkType, null, targetPlatform, versionInfo);
            selectedLinker = this.linkerDef.getProcessor().getLinker(this.linkType);
            objCollector = new ObjectFileCollector(selectedLinker, objectFiles);
            sysLibraryCollector = new SystemLibraryCollector(selectedLinker, sysLibraries);
        }
        if (selectedLinkerDef == null || selectedLinkerDef.getInherit()) {
            this.linkerDef.visitUserLibraries(selectedLinker, objCollector);
            this.linkerDef.visitSystemLibraries(selectedLinker, sysLibraryCollector);
        }
        if (selectedLinkerDef != null) {
            ((LinkerDef)selectedLinkerDef).visitSystemLibraries(selectedLinker, sysLibraryCollector);
        }
        Enumeration sysLibEnum = sysLibraries.elements();
        while (sysLibEnum.hasMoreElements()) {
            sysObjectFiles.addElement((File)sysLibEnum.nextElement());
        }
        return (LinkerConfiguration)linkerConfig;
    }

    public IncludePath createIncludePath() {
        return this.compilerDef.createIncludePath();
    }

    public PrecompileDef createPrecompile() throws BuildException {
        return this.compilerDef.createPrecompile();
    }

    public SystemIncludePath createSysIncludePath() {
        return this.compilerDef.createSysIncludePath();
    }

    public void execute() throws BuildException {
        if (this._objDir == null) {
            this._objDir = this._outfile != null ? new File(this._outfile.getParent()) : new File(".");
        }
        if (!this._objDir.exists()) {
            throw new BuildException("Object directory does not exist");
        }
        TargetHistoryTable objHistory = new TargetHistoryTable(this, this._objDir);
        VersionInfo versionInfo = null;
        Enumeration<VersionInfo> versionEnum = this.versionInfos.elements();
        while (versionEnum.hasMoreElements()) {
            versionInfo = versionEnum.nextElement();
            if ((versionInfo = versionInfo.merge()).isActive()) break;
            versionInfo = null;
        }
        Vector<File> objectFiles = new Vector<File>();
        Vector<File> sysObjectFiles = new Vector<File>();
        LinkerConfiguration linkerConfig = this.collectExplicitObjectFiles(objectFiles, sysObjectFiles, versionInfo);
        Map<String, TargetInfo> targets = this.getTargets(linkerConfig, objectFiles, versionInfo, this._outfile);
        TargetInfo linkTarget = null;
        if (this._outfile != null) {
            linkTarget = this.getLinkTarget(linkerConfig, objectFiles, sysObjectFiles, targets, versionInfo);
        }
        if (this.projects.size() > 0) {
            ArrayList<File> files = new ArrayList<File>();
            ProjectFileCollector matcher = new ProjectFileCollector(files);
            for (int i = 0; i < this._compilers.size(); ++i) {
                CompilerDef currentCompilerDef = this._compilers.elementAt(i);
                if (!currentCompilerDef.isActive() || !currentCompilerDef.hasFileSets()) continue;
                currentCompilerDef.visitFiles(matcher);
            }
            this.compilerDef.visitFiles(matcher);
            Enumeration<ProjectDef> iter = this.projects.elements();
            while (iter.hasMoreElements()) {
                ProjectDef projectDef = iter.nextElement();
                if (!projectDef.isActive()) continue;
                projectDef.execute(this, files, targets, linkTarget);
            }
        }
        if (this.projectsOnly) {
            return;
        }
        objHistory.markForRebuild(targets);
        CCTaskProgressMonitor monitor = new CCTaskProgressMonitor(objHistory, versionInfo);
        int rebuildCount = this.checkForChangedIncludeFiles(targets);
        if (rebuildCount > 0) {
            BuildException compileException = null;
            Map<ProcessorConfiguration, Vector<TargetInfo>> targetsByConfig = CCTask.getTargetsToBuildByConfiguration(targets);
            Vector[] targetVectors = new Vector[targetsByConfig.size()];
            int index = 0;
            for (Vector<TargetInfo> targetsForConfig : targetsByConfig.values()) {
                CompilerConfiguration config = (CompilerConfiguration)targetsForConfig.elementAt(0).getConfiguration();
                if (!config.isPrecompileGeneration()) continue;
                targetVectors[index++] = targetsForConfig;
            }
            block14: for (Vector<TargetInfo> targetsForConfig : targetsByConfig.values()) {
                for (int i = 0; i < targetVectors.length && targetVectors[i] != targetsForConfig; ++i) {
                    if (targetVectors[i] != null) continue;
                    targetVectors[i] = targetsForConfig;
                    continue block14;
                }
            }
            Progress progress = new Progress(this.getObjdir(), rebuildCount);
            progress.start();
            for (int i = 0; i < targetVectors.length; ++i) {
                int j;
                int j2;
                int noOfFiles;
                Vector targetsForConfig = targetVectors[i];
                CompilerConfiguration config = (CompilerConfiguration)((TargetInfo)targetsForConfig.elementAt(0)).getConfiguration();
                int noOfCores = Runtime.getRuntime().availableProcessors();
                this.log("Found " + noOfCores + " processors available");
                if (this.maxCores > 0) {
                    noOfCores = Math.min(this.maxCores, noOfCores);
                    this.log("Limited processors to " + noOfCores);
                }
                if ((noOfFiles = targetsForConfig.size()) < noOfCores) {
                    noOfCores = noOfFiles;
                    this.log("Limited used processors to " + noOfCores);
                }
                if (this.ordered) {
                    noOfCores = 1;
                    this.log("Limited processors to 1 due to ordering of source files");
                }
                List[] sourceFiles = new List[noOfCores];
                for (int j3 = 0; j3 < sourceFiles.length; ++j3) {
                    sourceFiles[j3] = new ArrayList(noOfFiles / sourceFiles.length);
                }
                Enumeration targetsEnum = targetsForConfig.elements();
                index = 0;
                while (targetsEnum.hasMoreElements()) {
                    TargetInfo targetInfo = (TargetInfo)targetsEnum.nextElement();
                    sourceFiles[index++].add(targetInfo.getSources()[0].toString());
                    index %= sourceFiles.length;
                }
                Core[] cores = new Core[noOfCores];
                for (j2 = 0; j2 < cores.length; ++j2) {
                    cores[j2] = new Core(this, j2, config, this._objDir, sourceFiles[j2], this.relentless, monitor);
                    this.log("\nStarting Core " + j2 + " with " + sourceFiles[j2].size() + " source files...");
                }
                for (j2 = 0; j2 < cores.length; ++j2) {
                    cores[j2].start();
                }
                boolean alive = false;
                try {
                    do {
                        alive = false;
                        for (j = 0; j < cores.length; ++j) {
                            if (cores[j] == null) continue;
                            if (cores[j].isAlive()) {
                                alive = true;
                                continue;
                            }
                            Exception exception = cores[j].getException();
                            if (exception != null) {
                                if (compileException == null && exception instanceof BuildException) {
                                    compileException = (BuildException)((Object)exception);
                                } else {
                                    this.log(cores[j].getName() + " " + exception + "                                  ", 0);
                                }
                                if (!this.relentless) {
                                    cores[j] = null;
                                    alive = false;
                                    break;
                                }
                            }
                            cores[j] = null;
                        }
                        if (!alive) continue;
                        Thread.sleep(Math.min(5000, sourceFiles[0].size() * 2000));
                    } while (alive);
                }
                catch (InterruptedException e) {
                    break;
                }
                for (j = 0; j < cores.length; ++j) {
                    if (cores[j] == null) continue;
                    cores[j].interrupt();
                    this.log(cores[j].getName() + " interrupted                                          ");
                }
                if (!this.relentless && compileException != null) break;
            }
            progress.exit();
            try {
                progress.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            try {
                objHistory.commit();
            }
            catch (IOException ex) {
                this.log("Error writing history.xml: " + ex.toString());
            }
            if (compileException != null) {
                if (this.failOnError) {
                    throw compileException;
                }
                this.log(compileException.getMessage(), 0);
                return;
            }
        }
        if (this.dependencyDepth >= 0) {
            throw new BuildException("All files at depth " + Integer.toString(this.dependencyDepth) + " from changes successfully compiled.\n" + "Remove or change dependencyDepth to -1 to perform full compilation.");
        }
        if (linkTarget != null) {
            TargetHistoryTable linkHistory = this.getLinkHistory(objHistory);
            linkHistory.markForRebuild(linkTarget);
            File output = linkTarget.getOutput();
            if (linkTarget.getRebuild()) {
                LinkerConfiguration linkConfig = (LinkerConfiguration)linkTarget.getConfiguration();
                this.log("Linking...");
                this.log("Starting link {" + linkConfig.getIdentifier() + "}");
                if (this.failOnError) {
                    linkConfig.link(this, linkTarget);
                } else {
                    try {
                        linkConfig.link(this, linkTarget);
                    }
                    catch (BuildException ex) {
                        this.log(ex.getMessage(), 0);
                        return;
                    }
                }
                if (this.outputFileProperty != null) {
                    this.getProject().setProperty(this.outputFileProperty, output.getAbsolutePath());
                }
                linkHistory.update(linkTarget);
                try {
                    linkHistory.commit();
                }
                catch (IOException ex) {
                    this.log("Error writing link history.xml: " + ex.toString());
                }
            } else if (this.outputFileProperty != null) {
                this.getProject().setProperty(this.outputFileProperty, output.getAbsolutePath());
            }
        }
    }

    public String getDataset() {
        return this.dataset;
    }

    protected TargetHistoryTable getLinkHistory(TargetHistoryTable objHistory) {
        File outputFileDir = new File(this._outfile.getParent());
        if (this._objDir.equals(outputFileDir)) {
            return objHistory;
        }
        return new TargetHistoryTable(this, outputFileDir);
    }

    protected TargetInfo getLinkTarget(LinkerConfiguration linkerConfig, Vector<File> objectFiles, Vector<File> sysObjectFiles, Map<String, TargetInfo> compileTargets, VersionInfo versionInfo) {
        for (TargetInfo compileTarget : compileTargets.values()) {
            int bid = linkerConfig.bid(compileTarget.getOutput().toString());
            if (bid <= 0) continue;
            objectFiles.addElement(compileTarget.getOutput());
        }
        Object[] objectFileArray = new File[objectFiles.size()];
        objectFiles.copyInto(objectFileArray);
        Object[] sysObjectFileArray = new File[sysObjectFiles.size()];
        sysObjectFiles.copyInto(sysObjectFileArray);
        String baseName = this._outfile.getName();
        String[] fullNames = linkerConfig.getOutputFileNames(baseName, versionInfo);
        File outputFile = new File(this._outfile.getParent(), fullNames[0]);
        return new TargetInfo(linkerConfig, (File[])objectFileArray, (File[])sysObjectFileArray, outputFile, linkerConfig.getRebuild());
    }

    public File getObjdir() {
        return this._objDir;
    }

    public File getOutfile() {
        return this._outfile;
    }

    public TargetDef getTargetPlatform() {
        return null;
    }

    private Map<String, TargetInfo> getTargets(LinkerConfiguration linkerConfig, Vector<File> objectFiles, VersionInfo versionInfo, File outputFile) {
        final ArrayList<String> order = new ArrayList<String>();
        TreeMap<String, TargetInfo> targets = new TreeMap<String, TargetInfo>(new Comparator<String>(){

            @Override
            public int compare(String f0, String f1) {
                if (order.isEmpty()) {
                    return f0.compareTo(f1);
                }
                f0 = f0.lastIndexOf(46) < 0 ? f0 : f0.substring(0, f0.lastIndexOf(46));
                f1 = f1.lastIndexOf(46) < 0 ? f1 : f1.substring(0, f1.lastIndexOf(46));
                CCTask.this.ordered = true;
                int i0 = order.indexOf(f0);
                int i1 = order.indexOf(f1);
                if (i0 < 0) {
                    if (i1 < 0) {
                        return f0.compareTo(f1);
                    }
                    return 1;
                }
                if (i1 < 0) {
                    return -1;
                }
                return i0 == i1 ? 0 : (i0 < i1 ? -1 : 1);
            }
        });
        TargetDef targetPlatform = this.getTargetPlatform();
        Vector<ProcessorConfiguration> biddingProcessors = new Vector<ProcessorConfiguration>(this._compilers.size());
        for (int i = 0; i < this._compilers.size(); ++i) {
            CompilerDef currentCompilerDef = this._compilers.elementAt(i);
            if (!currentCompilerDef.isActive()) continue;
            ProcessorConfiguration config = currentCompilerDef.createConfiguration(this, this.linkType, this.compilerDef, targetPlatform, versionInfo);
            PrecompileDef precompileDef = currentCompilerDef.getActivePrecompile(this.compilerDef);
            ProcessorConfiguration[] localConfigs = new ProcessorConfiguration[]{config};
            if (precompileDef != null) {
                File prototype = precompileDef.getPrototype();
                if (!prototype.exists()) {
                    throw new BuildException("prototype (" + prototype.toString() + ") does not exist.");
                }
                if (prototype.isDirectory()) {
                    throw new BuildException("prototype (" + prototype.toString() + ") is a directory.");
                }
                String[] exceptFiles = precompileDef.getExceptFiles();
                CompilerConfiguration[] configs = ((CompilerConfiguration)config).createPrecompileConfigurations(prototype, exceptFiles);
                if (configs != null && configs.length == 2) {
                    TargetMatcher matcher = new TargetMatcher(this, this._objDir, new ProcessorConfiguration[]{configs[0]}, linkerConfig, objectFiles, targets, versionInfo);
                    matcher.visit(new File(prototype.getParent()), prototype.getName());
                    biddingProcessors.addElement(configs[1]);
                    localConfigs = new ProcessorConfiguration[]{configs[1], config};
                }
            }
            order.clear();
            List<String> newOrder = currentCompilerDef.getOrder();
            if (newOrder != null) {
                order.addAll(newOrder);
            }
            if (currentCompilerDef.hasFileSets()) {
                TargetMatcher matcher = new TargetMatcher(this, this._objDir, localConfigs, linkerConfig, objectFiles, targets, versionInfo);
                currentCompilerDef.visitFiles(matcher);
            }
            biddingProcessors.addElement(config);
        }
        ProcessorConfiguration config = this.compilerDef.createConfiguration(this, this.linkType, null, targetPlatform, versionInfo);
        biddingProcessors.addElement(config);
        Object[] bidders = new ProcessorConfiguration[biddingProcessors.size()];
        biddingProcessors.copyInto(bidders);
        TargetMatcher matcher = new TargetMatcher(this, this._objDir, (ProcessorConfiguration[])bidders, linkerConfig, objectFiles, targets, versionInfo);
        this.compilerDef.visitFiles(matcher);
        if (outputFile != null && versionInfo != null) {
            boolean isDebug = linkerConfig.isDebug();
            try {
                linkerConfig.getLinker().addVersionFiles(versionInfo, this.linkType, outputFile, isDebug, this._objDir, matcher);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        return targets;
    }

    public void setClassname(String classname) {
        this.compilerDef.setClassname(classname);
        this.linkerDef.setClassname(classname);
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public void setDebug(boolean debug) {
        this.compilerDef.setDebug(debug);
        this.linkerDef.setDebug(debug);
    }

    public boolean getDebug() {
        return this.compilerDef.getDebug(null, 0);
    }

    public void setDependencyDepth(int depth) {
        this.dependencyDepth = depth;
    }

    public void setExceptions(boolean exceptions) {
        this.compilerDef.setExceptions(exceptions);
    }

    public void setRtti(boolean rtti) {
        this.compilerDef.setRtti(rtti);
    }

    public void setIncremental(boolean incremental) {
        this.linkerDef.setIncremental(incremental);
    }

    public void setLibtool(boolean libtool) {
        this.compilerDef.setLibtool(libtool);
        this.linkerDef.setLibtool(libtool);
    }

    public void setLink(OutputTypeEnum outputType) {
        this.linkType.setOutputType(outputType);
    }

    public void setLinkCPP(boolean linkCPP) {
        this.linkType.setLinkCPP(linkCPP);
    }

    public void setLinkFortran(boolean linkFortran) {
        this.linkType.setLinkFortran(linkFortran);
    }

    public void setLinkFortranMain(boolean linkFortranMain) {
        this.linkType.setLinkFortranMain(linkFortranMain);
    }

    public void setMultithreaded(boolean multi) {
        this.compilerDef.setMultithreaded(multi);
    }

    public void setName(CompilerEnum name) {
        this.compilerDef.setName(name);
        Processor compiler = this.compilerDef.getProcessor();
        Linker linker = compiler.getLinker(this.linkType);
        this.linkerDef.setProcessor(linker);
    }

    public void setNewenvironment(boolean newenv) {
        this.compilerDef.setNewenvironment(newenv);
        this.linkerDef.setNewenvironment(newenv);
    }

    public void setObjdir(File dir) {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        this._objDir = dir;
    }

    public void setOutfile(File outfile) {
        if (outfile == null || outfile.toString().length() > 0) {
            this._outfile = outfile;
        }
    }

    public void setOutputFileProperty(String outputFileProperty) {
        this.outputFileProperty = outputFileProperty;
    }

    public void setOuttype(OutputTypeEnum outputType) {
        this.linkType.setOutputType(outputType);
    }

    public String getOuttype() {
        return this.linkType.getOutputType();
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.compilerDef.setProject(project);
        this.linkerDef.setProject(project);
    }

    public void setRebuild(boolean rebuildAll) {
        this.compilerDef.setRebuild(rebuildAll);
        this.linkerDef.setRebuild(rebuildAll);
    }

    public void setRelentless(boolean relentless) {
        this.relentless = relentless;
    }

    public void setRuntime(RuntimeType rtlType) {
        this.linkType.setStaticRuntime(rtlType.getIndex() == 1);
    }

    public void setSubsystem(SubsystemEnum subsystem) {
        if (subsystem == null) {
            throw new NullPointerException("subsystem");
        }
        this.linkType.setSubsystem(subsystem);
    }

    public String getSubsystem() {
        return this.linkType.getSubsystem();
    }

    public void setWarnings(WarningLevelEnum level) {
        this.compilerDef.setWarnings(level);
    }

    public void setMaxCores(int maxCores) {
        this.maxCores = maxCores;
    }

    public int getMaxCores() {
        return this.maxCores;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void addConfiguredTarget(TargetDef target) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        target.setProject(this.getProject());
        this.targetPlatforms.addElement(target);
    }

    public void addConfiguredDistributer(DistributerDef distributer) {
        if (distributer == null) {
            throw new NullPointerException("distributer");
        }
        distributer.setProject(this.getProject());
        this.distributers.addElement(distributer);
    }

    public void setOptimize(OptimizationEnum optimization) {
        this.compilerDef.setOptimize(optimization);
    }

    public void addConfiguredVersioninfo(VersionInfo newVersionInfo) {
        newVersionInfo.setProject(this.getProject());
        this.versionInfos.addElement(newVersionInfo);
    }

    public void setCommandLogLevel(int commandLogLevel) {
        this.commandLogLevel = commandLogLevel;
    }

    public int getCommandLogLevel() {
        return this.commandLogLevel;
    }

    class Progress
    extends Thread {
        private boolean stop = false;
        private File objDir;
        private int rebuildCount;

        public Progress(File objDir, int rebuildCount) {
            this.objDir = objDir;
            this.rebuildCount = rebuildCount;
        }

        @Override
        public void run() {
            if (this.rebuildCount < 10) {
                return;
            }
            try {
                FileFilter updatedFiles = new FileFilter(){
                    private long startTime = System.currentTimeMillis();

                    @Override
                    public boolean accept(File file) {
                        return file.lastModified() > this.startTime && !file.getName().endsWith(".xml");
                    }
                };
                while (!this.stop) {
                    System.err.print("\r" + this.objDir.listFiles(updatedFiles).length + " / " + this.rebuildCount + " files compiled...");
                    System.err.print("\r");
                    System.err.flush();
                    if (this.stop) continue;
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.print("\r                                                                    ");
            System.err.print("\r");
            System.err.flush();
            CCTask.this.log(Integer.toString(this.rebuildCount) + " files were compiled.");
        }

        public void exit() {
            this.stop = true;
        }
    }

    class Core
    extends Thread {
        private CCTask task;
        private CompilerConfiguration config;
        private File objDir;
        private List<String> sourceFiles;
        private boolean relentless;
        private CCTaskProgressMonitor monitor;
        private Exception compileException;

        Core(CCTask task, int coreNo, CompilerConfiguration config, File objDir, List<String> set, boolean relentless, CCTaskProgressMonitor monitor) {
            super("Core " + coreNo);
            this.task = task;
            this.config = config;
            this.objDir = objDir;
            this.sourceFiles = set;
            this.relentless = relentless;
            this.monitor = monitor;
        }

        public Exception getException() {
            return this.compileException;
        }

        @Override
        public void run() {
            block2: {
                super.run();
                try {
                    String[] sources = new String[this.sourceFiles.size()];
                    sources = this.sourceFiles.toArray(sources);
                    this.config.compile(this.task, this.objDir, sources, this.relentless, this.monitor);
                }
                catch (Exception ex) {
                    if (this.compileException != null) break block2;
                    this.compileException = ex;
                }
            }
        }
    }

    private static class ProjectFileCollector
    implements FileVisitor {
        private final List<File> files;

        public ProjectFileCollector(List<File> files) {
            this.files = files;
        }

        @Override
        public void visit(File parentDir, String filename) {
            this.files.add(new File(parentDir, filename));
        }
    }

    private static class SystemLibraryCollector
    implements FileVisitor {
        private Hashtable<String, File> libraries;
        private Linker linker;

        public SystemLibraryCollector(Linker linker, Hashtable<String, File> libraries) {
            this.linker = linker;
            this.libraries = libraries;
        }

        @Override
        public void visit(File basedir, String filename) {
            if (this.linker.bid(filename) > 0) {
                File libfile = new File(basedir, filename);
                String key = this.linker.getLibraryKey(libfile);
                this.libraries.put(key, libfile);
            }
        }
    }
}

