/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.arm;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.util.Vector;

public class ADSLinker
extends CommandLineLinker {
    private static final ADSLinker dllInstance = new ADSLinker(".o");
    private static final ADSLinker instance = new ADSLinker(".axf");

    public static ADSLinker getDllInstance() {
        return dllInstance;
    }

    public static ADSLinker getInstance() {
        return instance;
    }

    private ADSLinker(String outputSuffix) {
        super("armlink", "-vsn", new String[]{".o", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk"}, outputSuffix, false, null);
    }

    protected void addBase(long base, Vector<String> args) {
    }

    protected void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (debug) {
            args.addElement("-debug");
        }
    }

    protected void addIncremental(boolean incremental, Vector<String> args) {
    }

    protected void addMap(boolean map, Vector<String> args) {
    }

    protected void addStack(int stack, Vector<String> args) {
    }

    protected void addEntry(String entry, Vector<String> args) {
    }

    @Override
    protected String getCommandFileSwitch(String commandFile) {
        return "-via" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("ARMLIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return new String[]{".o"};
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        return this;
    }

    @Override
    protected int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-output", outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }
}

