/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.logging.Logger;
import org.postgresql.pljava.annotation.BaseUDT;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLType;

@SQLAction(requires={"scalar complex type", "complex assertHasValues", "complexscalar boot fn"}, install={"SELECT javatest.complexscalar()", "SELECT javatest.assertHasValues( CAST('(1,2)' AS javatest.complex), 1, 2)"})
@BaseUDT(schema="javatest", name="complex", provides={"scalar complex type"}, internalLength=16, alignment=BaseUDT.Alignment.DOUBLE)
public class ComplexScalar
implements SQLData {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private double m_x;
    private double m_y;
    private String m_typeName;

    @Function(requires={"scalar complex type"}, type="javatest.complex", schema="javatest", name="logcomplex", effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static ComplexScalar logAndReturn(@SQLType(value="javatest.complex") ComplexScalar cpl) {
        s_logger.info(cpl.getSQLTypeName() + cpl);
        return cpl;
    }

    @Function(schema="javatest", requires={"scalar complex type"}, provides={"complex assertHasValues"}, effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static void assertHasValues(@SQLType(value="javatest.complex") ComplexScalar cpl, double re, double im) throws SQLException {
        if (cpl.m_x != re || cpl.m_y != im) {
            throw new SQLException("assertHasValues fails");
        }
    }

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static ComplexScalar parse(String input, String typeName) throws SQLException {
        try {
            StreamTokenizer tz = new StreamTokenizer(new StringReader(input));
            if (tz.nextToken() == 40 && tz.nextToken() == -2) {
                double x = tz.nval;
                if (tz.nextToken() == 44 && tz.nextToken() == -2) {
                    double y = tz.nval;
                    if (tz.nextToken() == 41) {
                        s_logger.info(typeName + " from string");
                        return new ComplexScalar(x, y, typeName);
                    }
                }
            }
            throw new SQLException("Unable to parse complex from string \"" + input + '\"');
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public ComplexScalar() {
    }

    public ComplexScalar(double x, double y, String typeName) {
        this.m_x = x;
        this.m_y = y;
        this.m_typeName = typeName;
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        s_logger.info(typeName + " from SQLInput");
        this.m_x = stream.readDouble();
        this.m_y = stream.readDouble();
        this.m_typeName = typeName;
    }

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public String toString() {
        s_logger.info(this.m_typeName + " toString");
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_x);
        sb.append(',');
        sb.append(this.m_y);
        sb.append(')');
        return sb.toString();
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void writeSQL(SQLOutput stream) throws SQLException {
        s_logger.info(this.m_typeName + " to SQLOutput");
        stream.writeDouble(this.m_x);
        stream.writeDouble(this.m_y);
    }

    @Function(schema="javatest", provides={"complexscalar boot fn"})
    public static void ComplexScalar() {
    }
}

