/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Scanner;
import org.postgresql.pljava.annotation.BaseUDT;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.SQLAction;

@SQLAction(requires={"udtscalariotest type", "udtscalariotest boot fn"}, install={"SELECT javatest.udtscalariotest()", "SELECT CAST('' AS javatest.udtscalariotest)"})
@BaseUDT(schema="javatest", provides={"udtscalariotest type"})
public class UDTScalarIOTest
implements SQLData {
    private String m_typeName;
    private static BigDecimal s_bigdec = new BigDecimal("11111111111111111111111111111111111.22222222222222222222222222222222");
    private static String s_gedicht = "D\u00fb bist m\u00een, ich bin d\u00een:\ndes solt d\u00fb gewis s\u00een;\nd\u00fb bist beslozzen in m\u00eenem herzen,\nverlorn ist daz sl\u00fczzel\u00een:\nd\u00fb muost och immer darinne s\u00een.";
    private static byte[] s_utfgedicht;
    private static boolean s_bool;
    private static byte s_byte;
    private static Date s_date;
    private static double s_double;
    private static float s_float;
    private static int s_int;
    private static long s_long;
    private static short s_short;
    private static Time s_time;
    private static Timestamp s_timestamp;
    private static URL s_url;

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static UDTScalarIOTest parse(String input, String typeName) throws SQLException {
        if (!"".equals(input)) {
            throw new SQLDataException("The only valid text value for UDTScalarIOTest is ''", "22P02");
        }
        UDTScalarIOTest instance = new UDTScalarIOTest();
        instance.m_typeName = typeName;
        return instance;
    }

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public String toString() {
        return "";
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeBigDecimal(s_bigdec);
        stream.writeBinaryStream(new ByteArrayInputStream(s_utfgedicht));
        stream.writeBoolean(s_bool);
        stream.writeByte(s_byte);
        stream.writeBytes(s_utfgedicht);
        stream.writeCharacterStream(new StringReader(s_gedicht));
        stream.writeDate(s_date);
        stream.writeDouble(s_double);
        stream.writeFloat(s_float);
        stream.writeInt(s_int);
        stream.writeLong(s_long);
        stream.writeShort(s_short);
        stream.writeString(s_gedicht);
        stream.writeTime(s_time);
        stream.writeTimestamp(s_timestamp);
        stream.writeURL(s_url);
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.m_typeName = typeName;
        if (!s_bigdec.equals(stream.readBigDecimal())) {
            throw new SQLException("BigDecimal mismatch");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = stream.readBinaryStream();
        try {
            int b;
            while (-1 != (b = is.read())) {
                baos.write(b);
            }
        }
        catch (IOException e) {
            throw new SQLException("Reading binary stream", "58030", e);
        }
        if (!Arrays.equals(s_utfgedicht, baos.toByteArray())) {
            throw new SQLException("binaryStream mismatch");
        }
        if (s_bool != stream.readBoolean()) {
            throw new SQLException("boolean mismatch");
        }
        if (s_byte != stream.readByte()) {
            throw new SQLException("byte mismatch");
        }
        if (!Arrays.equals(s_utfgedicht, stream.readBytes())) {
            throw new SQLException("bytes mismatch");
        }
        String charstream = new Scanner(stream.readCharacterStream()).useDelimiter("\\A").next();
        if (!s_gedicht.equals(charstream)) {
            throw new SQLException("characterStream mismatch");
        }
        if (!s_date.equals(stream.readDate())) {
            throw new SQLException("date mismatch");
        }
        if (s_double != stream.readDouble()) {
            throw new SQLException("double mismatch");
        }
        if (s_float != stream.readFloat()) {
            throw new SQLException("float mismatch");
        }
        if (s_int != stream.readInt()) {
            throw new SQLException("int mismatch");
        }
        if (s_long != stream.readLong()) {
            throw new SQLException("long mismatch");
        }
        if (s_short != stream.readShort()) {
            throw new SQLException("short mismatch");
        }
        if (!s_gedicht.equals(stream.readString())) {
            throw new SQLException("string mismatch");
        }
        if (!s_time.equals(stream.readTime())) {
            throw new SQLException("time mismatch");
        }
        if (!s_timestamp.equals(stream.readTimestamp())) {
            throw new SQLException("timestamp mismatch");
        }
        if (!s_url.equals(stream.readURL())) {
            throw new SQLException("url mismatch");
        }
    }

    @Function(schema="javatest", provides={"udtscalariotest boot fn"})
    public static void udtscalariotest() {
    }

    static {
        s_bool = true;
        s_byte = (byte)42;
        s_date = Date.valueOf("2004-01-07");
        s_double = Math.PI;
        s_float = (float)Math.E;
        s_int = 42424242;
        s_long = 4242424242424242L;
        s_short = (short)4242;
        s_time = Time.valueOf("06:33:24");
        s_timestamp = Timestamp.valueOf("2004-01-07 06:33:24");
        try {
            s_gedicht = s_gedicht + s_gedicht + s_gedicht;
            s_gedicht = s_gedicht + s_gedicht + s_gedicht;
            ByteBuffer bb = Charset.forName("UTF-8").newEncoder().encode(CharBuffer.wrap(s_gedicht));
            s_utfgedicht = new byte[bb.limit()];
            bb.get(s_utfgedicht);
            s_url = new URL("http://tada.github.io/pljava/");
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

