/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildOptionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
    private Button fFailOnError;
    private Button fVerbose;
    private Button fDebugInfo;

    public BuildOptionsPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.desc"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 15;
        composite.setLayout((Layout)layout);
        this.fFailOnError = new Button(composite, 32);
        this.fFailOnError.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.failOnError"));
        this.fFailOnError.setSelection(this.store.getBoolean("javacFailOnError"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fFailOnError.setLayoutData((Object)gd);
        this.fVerbose = new Button(composite, 32);
        this.fVerbose.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.compilerVerbose"));
        this.fVerbose.setSelection(this.store.getBoolean("javacVerbose"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fVerbose.setLayoutData((Object)gd);
        this.fDebugInfo = new Button(composite, 32);
        this.fDebugInfo.setText(PDEPlugin.getResourceString("BuildPropertiesPreferencePage.compilerDebug"));
        this.fDebugInfo.setSelection(this.store.getBoolean("javacDebugInfo"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fDebugInfo.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.build_options_preference_page");
    }

    public boolean performOk() {
        this.store.setValue("javacFailOnError", this.fFailOnError.getSelection());
        this.store.setValue("javacVerbose", this.fVerbose.getSelection());
        this.store.setValue("javacDebugInfo", this.fDebugInfo.getSelection());
        PDEPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.fFailOnError.setSelection(this.store.getDefaultBoolean("javacFailOnError"));
        this.fVerbose.setSelection(this.store.getDefaultBoolean("javacVerbose"));
        this.fDebugInfo.setSelection(this.store.getDefaultBoolean("javacDebugInfo"));
    }
}

