/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.internal.ui.StringMatcher;

public class ResourceExtender
extends PropertyTester {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String PROPERTY_MATCHES_CONTENT_TYPE = "matchesContentType";
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IResource resource = (IResource)((IAdaptable)receiver).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = ResourceExtender.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        if (resource != null) {
            if (PROPERTY_MATCHES_PATTERN.equals(method)) {
                String fileName = resource.getName();
                StringMatcher matcher = new StringMatcher((String)expectedValue, false, false);
                return matcher.match(fileName);
            }
            if (PROJECT_NATURE.equals(method)) {
                try {
                    IProject proj = resource.getProject();
                    return proj.isAccessible() && proj.hasNature((String)expectedValue);
                }
                catch (CoreException e) {
                    return false;
                }
            }
            if (PROPERTY_MATCHES_CONTENT_TYPE.equals(method)) {
                return this.matchesContentType(resource, (String)expectedValue);
            }
        }
        return false;
    }

    private boolean matchesContentType(IResource resource, String contentType) {
        IContentDescription description;
        if (resource == null || !(resource instanceof IFile) || !resource.exists()) {
            return false;
        }
        IFile file = (IFile)resource;
        try {
            description = file.getContentDescription();
        }
        catch (CoreException e) {
            return false;
        }
        if (description != null) {
            IContentType type = description.getContentType();
            return type != null && contentType.equals(type.getId());
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

