/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;

public class PrimitiveType
extends Type {
    public static final Code INT = new Code("int");
    public static final Code CHAR = new Code("char");
    public static final Code BOOLEAN = new Code("boolean");
    public static final Code SHORT = new Code("short");
    public static final Code LONG = new Code("long");
    public static final Code FLOAT = new Code("float");
    public static final Code DOUBLE = new Code("double");
    public static final Code BYTE = new Code("byte");
    public static final Code VOID = new Code("void");
    private Code typeCode = INT;
    private static final Map CODES = new HashMap(20);
    public static final SimplePropertyDescriptor PRIMITIVE_TYPE_CODE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PrimitiveType;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$PrimitiveType$Code;

    public static Code toCode(String token) {
        return (Code)CODES.get(token);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    PrimitiveType(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return PrimitiveType.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == PRIMITIVE_TYPE_CODE_PROPERTY) {
            if (get) {
                return this.getPrimitiveTypeCode();
            }
            this.setPrimitiveTypeCode((Code)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 39;
    }

    ASTNode clone0(AST target) {
        PrimitiveType result = new PrimitiveType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setPrimitiveTypeCode(this.getPrimitiveTypeCode());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public Code getPrimitiveTypeCode() {
        return this.typeCode;
    }

    public void setPrimitiveTypeCode(Code typeCode) {
        if (typeCode == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
        this.typeCode = typeCode;
        this.postValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Code[] ops = new Code[]{INT, BYTE, CHAR, BOOLEAN, SHORT, LONG, FLOAT, DOUBLE, VOID};
        for (int i = 0; i < ops.length; ++i) {
            CODES.put(ops[i].toString(), ops[i]);
        }
        PRIMITIVE_TYPE_CODE_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$PrimitiveType == null ? (class$org$eclipse$jdt$core$dom$PrimitiveType = PrimitiveType.class$("org.eclipse.jdt.core.dom.PrimitiveType")) : class$org$eclipse$jdt$core$dom$PrimitiveType, "primitiveTypeCode", class$org$eclipse$jdt$core$dom$PrimitiveType$Code == null ? (class$org$eclipse$jdt$core$dom$PrimitiveType$Code = PrimitiveType.class$("org.eclipse.jdt.core.dom.PrimitiveType$Code")) : class$org$eclipse$jdt$core$dom$PrimitiveType$Code, MANDATORY);
        ArrayList propertyList = new ArrayList(2);
        PrimitiveType.createPropertyList(class$org$eclipse$jdt$core$dom$PrimitiveType == null ? (class$org$eclipse$jdt$core$dom$PrimitiveType = PrimitiveType.class$("org.eclipse.jdt.core.dom.PrimitiveType")) : class$org$eclipse$jdt$core$dom$PrimitiveType, propertyList);
        PrimitiveType.addProperty(PRIMITIVE_TYPE_CODE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PrimitiveType.reapPropertyList(propertyList);
    }

    public static class Code {
        private String name;

        Code(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

