/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;

public final class ReorgResult {
    private boolean fCanceled;
    private Map fNameChanges;
    private Object fDestination;
    private IResource[] fResourcesToCopy;
    private IJavaElement[] fJavaElementsToCopy;

    public ReorgResult(boolean canceled, Map nameChanges) {
        this.fCanceled = canceled;
        this.fNameChanges = nameChanges;
    }

    public boolean isCanceled() {
        return this.fCanceled;
    }

    public Map getNameChanges() {
        return this.fNameChanges;
    }

    void setArguments(Object destination, IResource[] resourcesToCopy, IJavaElement[] javaElementsToCopy) {
        this.fDestination = destination;
        this.fJavaElementsToCopy = javaElementsToCopy;
        if (this.fJavaElementsToCopy != null && resourcesToCopy != null) {
            ArrayList<IResource> realResources = new ArrayList<IResource>(resourcesToCopy.length);
            for (int i = 0; i < resourcesToCopy.length; ++i) {
                IResource resource = resourcesToCopy[i];
                if (resource == null || ReorgResult.contains(this.fJavaElementsToCopy, resource)) continue;
                realResources.add(resource);
            }
            this.fResourcesToCopy = realResources.toArray(new IResource[realResources.size()]);
        } else {
            this.fResourcesToCopy = resourcesToCopy;
        }
    }

    public Object getDestination() {
        return this.fDestination;
    }

    public IJavaElement[] getJavaElementsToCopy() {
        return this.fJavaElementsToCopy;
    }

    public IResource[] getResourcesToCopy() {
        return this.fResourcesToCopy;
    }

    private static boolean contains(IJavaElement[] javaElements, IResource resource) {
        for (int i = 0; i < javaElements.length; ++i) {
            IJavaElement element = javaElements[i];
            if (!resource.equals(element.getResource())) continue;
            return true;
        }
        return false;
    }
}

