/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;

public class PruneFolderVisitor
implements ICVSResourceVisitor {
    private ICVSFolder localRoot;

    public void visit(Session s, ICVSResource[] resources) throws CVSException {
        this.visit(s.getLocalRoot(), resources);
    }

    public void visit(ICVSFolder root, ICVSResource[] resources) throws CVSException {
        this.localRoot = root;
        HashSet<ICVSFolder> prunableParents = new HashSet<ICVSFolder>();
        for (int i = 0; i < resources.length; ++i) {
            ICVSResource cvsResource = resources[i];
            cvsResource.accept(this);
            if (cvsResource.exists()) continue;
            prunableParents.add(cvsResource.getParent());
        }
        Iterator iter = prunableParents.iterator();
        while (iter.hasNext()) {
            ICVSFolder cvsFolder = (ICVSFolder)iter.next();
            this.pruneFolderAndParentsIfAppropriate(cvsFolder);
        }
    }

    public void visitFile(ICVSFile file) throws CVSException {
    }

    public void visitFolder(ICVSFolder folder) throws CVSException {
        folder.acceptChildren(this);
        this.pruneFolderIfAppropriate(folder);
    }

    private void pruneFolderIfAppropriate(ICVSFolder folder) throws CVSException {
        if (folder.exists() && folder.isManaged() && !folder.equals(this.getLocalRoot()) && folder.members(63).length == 0) {
            folder.delete();
        }
    }

    private ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    private void pruneFolderAndParentsIfAppropriate(ICVSFolder folder) throws CVSException {
        this.pruneFolderIfAppropriate(folder);
        if (!folder.exists()) {
            ICVSFolder parent = folder.getParent();
            this.pruneFolderAndParentsIfAppropriate(parent);
        }
    }
}

